/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.util.FilterUtility;
import com.kingdee.eas.hr.train.SysCateCourseEntryCollection;
import com.kingdee.eas.hr.train.SysCateCourseEntryFactory;
import com.kingdee.eas.hr.train.SysCateCourseEntryInfo;
import com.kingdee.eas.hr.train.TrainItemCourseCollection;
import com.kingdee.eas.hr.train.TrainItemCourseInfo;
import com.kingdee.eas.hr.train.TrainItemFactory;
import com.kingdee.eas.hr.train.TrainItemInfo;
import com.kingdee.eas.hr.train.app.AbstractTrainItemControllerBean;
import com.kingdee.eas.hr.train.app.CodingRuleServerHelper;
import com.kingdee.eas.hr.train.app.TrainUtilsServer;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.log4j.Logger;

public class TrainItemControllerBean
extends AbstractTrainItemControllerBean {
    private static final String HR_ORG_UNIT = "hrOrgUnit.id";
    private static final String PARENT_ID = "treeid";
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.train.app.TrainItemControllerBean");

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this._checkNumberDup(ctx, model);
        this.syncSysCateCourse(ctx, pk, model);
        super._update(ctx, pk, model);
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        TrainItemInfo trainItemInfo = (TrainItemInfo)this._getValue(ctx, pk);
        HashSet<TrainItemCourseInfo> courses = new HashSet<TrainItemCourseInfo>();
        Iterator it = trainItemInfo.getCourse().iterator();
        TrainItemCourseInfo courseInfo = null;
        while (it.hasNext()) {
            courseInfo = (TrainItemCourseInfo)it.next();
            courseInfo.setParent(trainItemInfo);
            courses.add(courseInfo);
        }
        this.deleteSysCateCourseEntry(ctx, courses);
        CodingRuleServerHelper.recycleNumber(ctx, pk, (ICoreBase)TrainItemFactory.getLocalInstance(ctx), TrainItemInfo.class.getName());
        super._delete(ctx, pk);
    }

    protected void _addnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        CodingRuleServerHelper.setInfoNumber(ctx, (CoreBaseInfo)((TrainItemInfo)model));
        super._addnew(ctx, pk, model);
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        CodingRuleServerHelper.setInfoNumber(ctx, (CoreBaseInfo)((TrainItemInfo)model));
        return super._addnew(ctx, model);
    }

    private void syncSysCateCourse(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        Set sysCates = this.getSysCatesByTrainItem(ctx, pk);
        if (sysCates == null || sysCates.size() <= 0) {
            return;
        }
        TrainItemInfo newItemInfo = (TrainItemInfo)model;
        Map oldItemCourses = this.getOldItemCourses(ctx, pk);
        Iterator it = newItemInfo.getCourse().iterator();
        while (it.hasNext()) {
            TrainItemCourseInfo itemCourseInfo = (TrainItemCourseInfo)it.next();
            itemCourseInfo.setParent(newItemInfo);
            if (this.isExistInOldCourses(itemCourseInfo, oldItemCourses)) continue;
            this.addSysCateCourseEntry(ctx, itemCourseInfo, sysCates);
        }
        Set deleteCourses = this.getDeleteItemCourses(newItemInfo.getCourse(), oldItemCourses);
        if (deleteCourses.size() > 0) {
            this.deleteSysCateCourseEntry(ctx, deleteCourses);
        }
    }

    private Set getSysCatesByTrainItem(Context ctx, IObjectPK pk) throws BOSException {
        TreeSet<String> sysCates = null;
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("trainItem.id", (Object)pk.toString()));
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filterInfo);
        SysCateCourseEntryCollection entryCollection = SysCateCourseEntryFactory.getLocalInstance(ctx).getSysCateCourseEntryCollection(viewInfo);
        if (entryCollection != null && entryCollection.size() > 0) {
            sysCates = new TreeSet<String>();
            Iterator it = entryCollection.iterator();
            while (it.hasNext()) {
                SysCateCourseEntryInfo entryInfo = (SysCateCourseEntryInfo)it.next();
                sysCates.add(entryInfo.getParent().getId().toString());
            }
        }
        return sysCates;
    }

    private Set getDeleteItemCourses(TrainItemCourseCollection courses, Map oldItemCourses) {
        HashSet<TrainItemCourseInfo> deleteCourses = new HashSet<TrainItemCourseInfo>();
        Iterator it = oldItemCourses.keySet().iterator();
        while (it.hasNext()) {
            TrainItemCourseInfo oldItemCourse = (TrainItemCourseInfo)oldItemCourses.get(it.next());
            boolean deleteFlag = true;
            Iterator newIt = courses.iterator();
            while (newIt.hasNext()) {
                TrainItemCourseInfo newItemCourse = (TrainItemCourseInfo)newIt.next();
                if (!oldItemCourse.getCourse().getId().equals((Object)newItemCourse.getCourse().getId())) continue;
                deleteFlag = false;
                break;
            }
            if (!deleteFlag) continue;
            deleteCourses.add(oldItemCourse);
        }
        return deleteCourses;
    }

    private Map getOldItemCourses(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        TrainItemInfo oldTrainItem = (TrainItemInfo)this._getValue(ctx, pk);
        HashMap<String, TrainItemCourseInfo> itemCourses = new HashMap<String, TrainItemCourseInfo>();
        Iterator it = oldTrainItem.getCourse().iterator();
        while (it.hasNext()) {
            TrainItemCourseInfo itemCourse = (TrainItemCourseInfo)it.next();
            itemCourses.put(itemCourse.getId().toString(), itemCourse);
        }
        return itemCourses;
    }

    private boolean isExistInOldCourses(TrainItemCourseInfo itemCourseInfo, Map oldItemCourses) {
        boolean flag = false;
        Iterator it = oldItemCourses.keySet().iterator();
        while (it.hasNext()) {
            TrainItemCourseInfo oldItemCourse = (TrainItemCourseInfo)oldItemCourses.get(it.next());
            if (!oldItemCourse.getCourse().getId().equals((Object)itemCourseInfo.getCourse().getId())) continue;
            flag = true;
            break;
        }
        return flag;
    }

    private void addSysCateCourseEntry(Context ctx, TrainItemCourseInfo itemCourseInfo, Set sysCates) throws BOSException, EASBizException {
        Connection con = null;
        PreparedStatement pst = null;
        try {
            StringBuffer sql = new StringBuffer();
            sql.append("insert into T_HR_SYSCATECOURSE");
            sql.append(" (FID, FParentID, FTrainItemID, FTrainCourseID, FSeq)");
            sql.append(" values(?, ?, ?, ?, ?)");
            con = this.getConnection(ctx);
            pst = con.prepareStatement(sql.toString());
            Iterator it = sysCates.iterator();
            while (it.hasNext()) {
                int index = 1;
                String id = BOSUuid.create((BOSObjectType)new SysCateCourseEntryInfo().getBOSType()).toString();
                DbUtil.prepareVarcharParam((PreparedStatement)pst, (int)index++, (String)id);
                DbUtil.prepareVarcharParam((PreparedStatement)pst, (int)index++, (String)it.next().toString());
                DbUtil.prepareVarcharParam((PreparedStatement)pst, (int)index++, (String)itemCourseInfo.getParent().getId().toString());
                DbUtil.prepareVarcharParam((PreparedStatement)pst, (int)index++, (String)itemCourseInfo.getCourse().getId().toString());
                pst.setInt(index++, 1);
                pst.addBatch();
            }
            pst.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pst, con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pst, (Connection)con);
    }

    private void deleteSysCateCourseEntry(Context ctx, Set deleteCourses) throws BOSException {
        Connection con = null;
        PreparedStatement pst = null;
        String sql = "delete from T_HR_SYSCATECOURSE where FTrainItemID = ? and FTrainCourseID = ?";
        try {
            con = this.getConnection(ctx);
            pst = con.prepareStatement(sql);
            for (TrainItemCourseInfo itemCourseInfo : deleteCourses) {
                int index = 1;
                DbUtil.prepareVarcharParam((PreparedStatement)pst, (int)index++, (String)itemCourseInfo.getParent().getId().toString());
                DbUtil.prepareVarcharParam((PreparedStatement)pst, (int)index++, (String)itemCourseInfo.getCourse().getId().toString());
                pst.addBatch();
            }
            pst.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pst, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pst, (Connection)con);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.checkNameDup(ctx, model);
        return super._submit(ctx, model);
    }

    private void checkNameDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        DataBaseInfo dataBaseInfo = (DataBaseInfo)model;
        if (super._exists(ctx, TrainUtilsServer.getNoDupNameParentFilter(ctx, model, HR_ORG_UNIT, PARENT_ID))) {
            String name = this._getPropertyAlias(ctx, dataBaseInfo, "name") + dataBaseInfo.getName();
            throw new EASBizException(EASBizException.CHECKDUPLICATED, new Object[]{name});
        }
    }

    protected FilterInfo getFilterForDefaultCU(Context ctx, IObjectValue model) {
        FilterInfo filterInfo = TrainUtilsServer.getHRFilterInfo(ctx, HR_ORG_UNIT);
        if (FilterUtility.hasFilterItem((FilterInfo)filterInfo)) {
            return filterInfo;
        }
        return super.getFilterForDefaultCU(ctx, model);
    }

    protected void _setEnable(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        TrainItemInfo trainItemInfo = this.getTrainItemInfo(ctx, pk);
        trainItemInfo.setIsEnable(true);
        this._update(ctx, pk, (IObjectValue)trainItemInfo);
    }

    protected void _setDisable(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        TrainItemInfo trainItemInfo = this.getTrainItemInfo(ctx, pk);
        trainItemInfo.setIsEnable(false);
        this._update(ctx, pk, (IObjectValue)trainItemInfo);
    }

    protected void _setState(Context ctx, IObjectPK pk, boolean state) throws BOSException, EASBizException {
        TrainItemInfo trainItemInfo = this.getTrainItemInfo(ctx, pk);
        trainItemInfo.setIsEnable(state);
        this._update(ctx, pk, (IObjectValue)trainItemInfo);
    }
}

