/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.train.TrainException;
import com.kingdee.eas.hr.train.TrainItemCollection;
import com.kingdee.eas.hr.train.TrainItemFactory;
import com.kingdee.eas.hr.train.TrainItemTreeFactory;
import com.kingdee.eas.hr.train.TrainItemTreeInfo;
import com.kingdee.eas.hr.train.app.AbstractTrainItemTreeControllerBean;
import com.kingdee.eas.hr.train.app.CodingRuleServerHelper;
import com.kingdee.eas.hr.train.app.TrainUtilsServer;
import org.apache.log4j.Logger;

public class TrainItemTreeControllerBean
extends AbstractTrainItemTreeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.train.app.TrainItemTreeControllerBean");
    private static final String HR_ORG_UNIT = "hrOrgUnit.id";
    private static final String PARENT_ID = "parent";

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.checkDeleteCondition(ctx, pk);
        CodingRuleServerHelper.recycleNumber(ctx, pk, (ICoreBase)TrainItemTreeFactory.getLocalInstance(ctx), TrainItemTreeInfo.class.getName());
        super._delete(ctx, pk);
    }

    private void checkDeleteCondition(Context ctx, IObjectPK pk) throws BOSException, TrainException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("treeid", (Object)pk.toString()));
        viewInfo.setFilter(filterInfo);
        TrainItemCollection collection = TrainItemFactory.getLocalInstance(ctx).getTrainItemCollection(viewInfo);
        if (collection != null && collection.size() > 0) {
            throw new TrainException(TrainException.TRAINITEMTREE_DONOT_DELETE);
        }
    }

    protected void _addnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        CodingRuleServerHelper.setInfoNumber(ctx, (CoreBaseInfo)((TrainItemTreeInfo)model));
        super._addnew(ctx, pk, model);
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        CodingRuleServerHelper.setInfoNumber(ctx, (CoreBaseInfo)((TrainItemTreeInfo)model));
        return super._addnew(ctx, model);
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this._checkNumberDup(ctx, model);
        super._update(ctx, pk, model);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this._checkNameDup(ctx, model);
        return super._submit(ctx, model);
    }

    protected void _checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        DataBaseInfo dataBaseInfo = (DataBaseInfo)model;
        if (super._exists(ctx, TrainUtilsServer.getNoDupNumberFilter(ctx, model))) {
            String number = this._getPropertyAlias(ctx, dataBaseInfo, "number") + dataBaseInfo.getNumber();
            throw new EASBizException(EASBizException.CHECKDUPLICATED, new Object[]{number});
        }
    }

    protected void _checkNameDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        DataBaseInfo dataBaseInfo = (DataBaseInfo)model;
        if (super._exists(ctx, TrainUtilsServer.getNoDupNameParentFilter(ctx, model, HR_ORG_UNIT, PARENT_ID))) {
            String name = this._getPropertyAlias(ctx, dataBaseInfo, "name") + dataBaseInfo.getName();
            throw new EASBizException(EASBizException.CHECKDUPLICATED, new Object[]{name});
        }
    }
}

