/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.app.dao.ReferenceDAO;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.train.ITrainCourseMaterial;
import com.kingdee.eas.hr.train.TrainActivityException;
import com.kingdee.eas.hr.train.TrainChanneException;
import com.kingdee.eas.hr.train.TrainCourseMaterialFactory;
import com.kingdee.eas.hr.train.TrainMaterialFactory;
import com.kingdee.eas.hr.train.TrainMaterialInfo;
import com.kingdee.eas.hr.train.app.AbstractTrainMaterialControllerBean;
import com.kingdee.eas.hr.train.app.CodingRuleServerHelper;
import org.apache.log4j.Logger;

public class TrainMaterialControllerBean
extends AbstractTrainMaterialControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.train.app.TrainMaterialControllerBean");

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        DataBaseInfo dataBaseInfo = (DataBaseInfo)model;
        if (dataBaseInfo.getNumber() != null) {
            dataBaseInfo.setNumber(dataBaseInfo.getNumber().trim());
            if (dataBaseInfo.getNumber() != null && dataBaseInfo.getNumber().length() > 0) {
                this._checkNumberDup(ctx, (IObjectValue)dataBaseInfo);
            }
        }
        if (dataBaseInfo.getName() != null) {
            dataBaseInfo.setName(dataBaseInfo.getName().trim());
            if (dataBaseInfo.getName() != null && dataBaseInfo.getName().length() > 0) {
                this._checkNameDup(ctx, (IObjectValue)dataBaseInfo);
            }
        }
        return super._submit(ctx, model);
    }

    protected void _checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        TrainMaterialInfo trainMaterialInfo = (TrainMaterialInfo)model;
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)trainMaterialInfo.getNumber(), CompareType.EQUALS));
        if (trainMaterialInfo.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)trainMaterialInfo.getId(), CompareType.NOTEQUALS));
        }
        if (TrainMaterialFactory.getLocalInstance(ctx).exists(filter)) {
            throw new TrainChanneException(TrainChanneException.CHANNEL_NUMBER_NOT_DUP);
        }
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        if (pk == null) {
            return;
        }
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("TrainMaterial.id", (Object)pk.toString()));
        ITrainCourseMaterial trainCourseMaterial = TrainCourseMaterialFactory.getLocalInstance(ctx);
        if (trainCourseMaterial.exists(fi) || ReferenceDAO.isReferenced((Context)ctx, (BOSUuid)BOSUuid.read((String)pk.toString()))) {
            throw new TrainActivityException(TrainActivityException.CANNOT_DEL_TRAIN_MATERIAL);
        }
        CodingRuleServerHelper.recycleNumber(ctx, pk, (ICoreBase)TrainMaterialFactory.getLocalInstance(ctx), TrainMaterialInfo.class.getName());
        super._delete(ctx, pk);
    }

    protected void _addnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        CodingRuleServerHelper.setInfoNumber(ctx, (CoreBaseInfo)((TrainMaterialInfo)model));
        super._addnew(ctx, pk, model);
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        CodingRuleServerHelper.setInfoNumber(ctx, (CoreBaseInfo)((TrainMaterialInfo)model));
        return super._addnew(ctx, model);
    }
}

