/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.perf.app.PfServerUtils;
import com.kingdee.eas.hr.train.TrainEquipmentException;
import com.kingdee.eas.hr.train.TrainException;
import com.kingdee.eas.hr.train.TrainMaterialFactory;
import com.kingdee.eas.hr.train.TrainMaterialTreeFactory;
import com.kingdee.eas.hr.train.TrainMaterialTreeInfo;
import com.kingdee.eas.hr.train.app.AbstractTrainMaterialTreeControllerBean;
import com.kingdee.eas.hr.train.app.CodingRuleServerHelper;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.StringUtils;
import org.apache.log4j.Logger;

public class TrainMaterialTreeControllerBean
extends AbstractTrainMaterialTreeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.train.app.TrainMaterialTreeControllerBean");

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        DataBaseInfo dataBaseInfo = (DataBaseInfo)model;
        if (dataBaseInfo.getNumber() != null) {
            dataBaseInfo.setNumber(dataBaseInfo.getNumber().trim());
            if (dataBaseInfo.getNumber() != null && dataBaseInfo.getNumber().length() > 0) {
                this._checkNumberDup(ctx, (IObjectValue)dataBaseInfo);
            }
        }
        if (dataBaseInfo.getName() != null) {
            dataBaseInfo.setName(dataBaseInfo.getName().trim());
            if (dataBaseInfo.getName() != null && dataBaseInfo.getName().length() > 0) {
                this._checkNameDup(ctx, model);
            }
        }
        return super._submit(ctx, model);
    }

    protected void _checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        TrainMaterialTreeInfo info = (TrainMaterialTreeInfo)model;
        String number = info.getNumber();
        if (StringUtils.isEmpty((String)number)) {
            throw new TrainEquipmentException(TrainEquipmentException.NUMBER_NOT_NULL);
        }
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
        if (info.getId() != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId().toString(), CompareType.NOTEQUALS));
        }
        if (TrainMaterialTreeFactory.getLocalInstance(ctx).exists(filterInfo)) {
            throw new TrainEquipmentException(TrainEquipmentException.NUMBER_DUP);
        }
    }

    protected void _checkNameDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        TrainMaterialTreeInfo info = (TrainMaterialTreeInfo)model;
        String name = info.getName();
        if (StringUtils.isEmpty((String)name)) {
            throw new TrainEquipmentException(TrainEquipmentException.NAME_NOT_NULL);
        }
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString(), CompareType.EQUALS));
        if (info.getParent() != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("parent.id", (Object)info.getParent().getId().toString()));
        } else {
            filterInfo.getFilterItems().add(new FilterItemInfo("parent.id", null));
        }
        if (info.getId() != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId().toString(), CompareType.NOTEQUALS));
        } else {
            filterInfo.getFilterItems().add(new FilterItemInfo("id", null, CompareType.NOTEQUALS));
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("name", (Object)info.getName()));
        if (info.getId() != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId().toString(), CompareType.NOTEQUALS));
        }
        filterInfo.mergeFilter(PfServerUtils.getCUFilterForQuery((Context)ctx), "and");
        if (TrainMaterialTreeFactory.getLocalInstance(ctx).exists(filterInfo)) {
            throw new TrainEquipmentException(TrainEquipmentException.NAME_DUP);
        }
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        if (pk != null) {
            if (this.isReferenced(ctx, pk.toString())) {
                throw new TrainException(TrainException.MATERIALCATE_ALREADY_REFERENCED);
            }
            CodingRuleServerHelper.recycleNumber(ctx, pk, (ICoreBase)TrainMaterialTreeFactory.getLocalInstance(ctx), TrainMaterialTreeInfo.class.getName());
            super._delete(ctx, pk);
        }
    }

    private boolean isReferenced(Context ctx, String id) throws EASBizException, BOSException {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("treeid.id", (Object)id));
        return TrainMaterialFactory.getLocalInstance(ctx).exists(filterInfo);
    }

    protected void _addnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        CodingRuleServerHelper.setInfoNumber(ctx, (CoreBaseInfo)((TrainMaterialTreeInfo)model));
        super._addnew(ctx, pk, model);
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        CodingRuleServerHelper.setInfoNumber(ctx, (CoreBaseInfo)((TrainMaterialTreeInfo)model));
        return super._addnew(ctx, model);
    }
}

