/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.train.TrainActParticipantScopeFactory;
import com.kingdee.eas.hr.train.TrainActivityFacadeFactory;
import com.kingdee.eas.hr.train.TrainAuditStateEnum;
import com.kingdee.eas.hr.train.TrainCourseInfo;
import com.kingdee.eas.hr.train.TrainExePeriodCollection;
import com.kingdee.eas.hr.train.TrainExePeriodFactory;
import com.kingdee.eas.hr.train.TrainExePeriodInfo;
import com.kingdee.eas.hr.train.TrainItemCourseCollection;
import com.kingdee.eas.hr.train.TrainItemCourseInfo;
import com.kingdee.eas.hr.train.TrainItemInfo;
import com.kingdee.eas.hr.train.TrainPlanActivityCostCollection;
import com.kingdee.eas.hr.train.TrainPlanActivityCostInfo;
import com.kingdee.eas.hr.train.TrainPlanCategoryEnum;
import com.kingdee.eas.hr.train.TrainPlanCategoryPropertyEnum;
import com.kingdee.eas.hr.train.TrainPlanCollection;
import com.kingdee.eas.hr.train.TrainPlanCourseCollection;
import com.kingdee.eas.hr.train.TrainPlanCourseInfo;
import com.kingdee.eas.hr.train.TrainPlanCourseTrainPlanCourseCostCollection;
import com.kingdee.eas.hr.train.TrainPlanCourseTrainPlanCourseCostInfo;
import com.kingdee.eas.hr.train.TrainPlanException;
import com.kingdee.eas.hr.train.TrainPlanFactory;
import com.kingdee.eas.hr.train.TrainPlanInfo;
import com.kingdee.eas.hr.train.TrainPlanMessageFactory;
import com.kingdee.eas.hr.train.TrainPlanMessageInfo;
import com.kingdee.eas.hr.train.TrainPlanParticipantScopeCollection;
import com.kingdee.eas.hr.train.TrainPlanParticipantScopeInfo;
import com.kingdee.eas.hr.train.TrainPlanTrainPlanActivityCollection;
import com.kingdee.eas.hr.train.TrainPlanTrainPlanActivityInfo;
import com.kingdee.eas.hr.train.app.AbstractTrainPlanControllerBean;
import com.kingdee.eas.hr.train.app.CodingRuleServerHelper;
import com.kingdee.eas.hr.train.app.TrainUtilsServer;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Random;
import java.util.Set;
import org.apache.log4j.Logger;

public class TrainPlanControllerBean
extends AbstractTrainPlanControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.train.app.TrainPlanControllerBean");
    private static final String IS_NEED_WORKFLOW = "IS_NEED_WORK_FLOW_AUDITED";
    private static final String TABLE_NAME = " T_HR_TrainPlan ";
    private static final String RES = "com.kingdee.eas.hr.train.TrainResource";
    private static final String PERIODCOUNT = "1";

    protected void _addnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        CodingRuleServerHelper.setInfoNumber(ctx, (CoreBaseInfo)((TrainPlanInfo)model));
        this.checkData(ctx, model);
        super._addnew(ctx, pk, model);
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        CodingRuleServerHelper.setInfoNumber(ctx, (CoreBaseInfo)((TrainPlanInfo)model));
        this.checkData(ctx, model);
        return super._addnew(ctx, model);
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        CodingRuleServerHelper.recycleNumber(ctx, pk, (ICoreBase)TrainPlanFactory.getLocalInstance(ctx), TrainPlanInfo.class.getName());
        HashSet<String> setExe = null;
        TrainPlanInfo planInfo = TrainPlanFactory.getLocalInstance(ctx).getTrainPlanInfo(pk);
        TrainPlanTrainPlanActivityCollection planActivityCol = planInfo.getTrainPlanActivity();
        if (planActivityCol != null && planActivityCol.size() > 0) {
            setExe = new HashSet<String>();
            int j = planActivityCol.size();
            for (int i = 0; i < j; ++i) {
                TrainPlanTrainPlanActivityInfo planActivityInfo = planActivityCol.get(i);
                TrainExePeriodCollection exePeriodCol = planActivityInfo.getTrainExePeriods();
                if (exePeriodCol == null || exePeriodCol.size() <= 0) continue;
                int m = exePeriodCol.size();
                for (int l = 0; l < m; ++l) {
                    TrainExePeriodInfo exePeriodInfo = exePeriodCol.get(l);
                    setExe.add(exePeriodInfo.getId().toString());
                }
            }
        }
        String planName = planInfo.getName().toString();
        if (setExe != null && this.isRelationMonthPeriodInfo(ctx, setExe)) {
            throw new TrainPlanException(TrainPlanException.TRAINPLAN_HASREL, new Object[]{planName});
        }
        super._delete(ctx, pk);
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.checkData(ctx, model);
        super._update(ctx, pk, model);
    }

    private void checkData(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        DataBaseInfo info = (DataBaseInfo)model;
        if (StringUtils.isEmpty((String)info.getNumber())) {
            throw new TrainPlanException(TrainPlanException.NUMBER_NULL_EXCEPTION);
        }
        if (StringUtils.isEmpty((String)info.getName())) {
            throw new TrainPlanException(TrainPlanException.NAME_NULL_EXCEPTION);
        }
        if (super._exists(ctx, TrainUtilsServer.getNoDupNumberHROFilter(ctx, model))) {
            throw new TrainPlanException(TrainPlanException.NUMBER_DUP_EXCEPTION);
        }
        if (super._exists(ctx, TrainUtilsServer.getNoDupNameORGOFilter(ctx, model))) {
            throw new TrainPlanException(TrainPlanException.NAME_DUP_ORG_EXCEPTION);
        }
    }

    protected String _checkDateRepeat(Context ctx, IObjectValue model) throws BOSException, TrainPlanException {
        TrainPlanInfo info = (TrainPlanInfo)model;
        Date startDate = info.getPlanDate();
        Date endDate = info.getEndDate();
        String aboutDate = info.getAboutDate();
        if (startDate == null || endDate == null || aboutDate != null && aboutDate.trim().length() > 0) {
            return null;
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("name"));
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString()));
        filterInfo.getFilterItems().add(new FilterItemInfo("planCategory.id", (Object)info.getPlanCategory().getId().toString()));
        filterInfo.getFilterItems().add(new FilterItemInfo("planCategory.property", (Object)TrainPlanCategoryPropertyEnum.INNER));
        filterInfo.getFilterItems().add(new FilterItemInfo("OrgUnit.id", (Object)info.getOrgUnit().getId().toString()));
        if (info.getId() != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId().toString(), CompareType.NOTEQUALS));
        }
        FilterInfo dateFilter = new FilterInfo();
        dateFilter.getFilterItems().add(new FilterItemInfo("PlanDate", (Object)startDate, CompareType.GREATER_EQUALS));
        dateFilter.getFilterItems().add(new FilterItemInfo("PlanDate", (Object)endDate, CompareType.LESS_EQUALS));
        dateFilter.getFilterItems().add(new FilterItemInfo("endDate", (Object)startDate, CompareType.GREATER_EQUALS));
        dateFilter.getFilterItems().add(new FilterItemInfo("endDate", (Object)endDate, CompareType.LESS_EQUALS));
        dateFilter.getFilterItems().add(new FilterItemInfo("PlanDate", (Object)startDate, CompareType.LESS_EQUALS));
        dateFilter.getFilterItems().add(new FilterItemInfo("endDate", (Object)endDate, CompareType.GREATER_EQUALS));
        dateFilter.setMaskString("(#0 and #1) or (#2 and #3) or (#4 and #5)");
        filterInfo.mergeFilter(dateFilter, "AND");
        viewInfo.setFilter(filterInfo);
        String name = null;
        TrainPlanCollection collection = TrainPlanFactory.getLocalInstance(ctx).getTrainPlanCollection(viewInfo);
        if (collection != null && collection.size() > 0) {
            name = collection.get(0).getName();
        }
        return name;
    }

    protected boolean _isNeedWorkFlow(Context ctx) throws BOSException, EASBizException {
        String hrID;
        IParamControl iParam = ParamControlFactory.getLocalInstance((Context)ctx);
        String value = iParam.getParamValue((IObjectPK)new ObjectUuidPK(hrID = ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString()), IS_NEED_WORKFLOW);
        return !"false".equals(value);
    }

    protected void _setAudited(Context ctx, BOSUuid id) throws BOSException, EASBizException {
        this.setAuditState(ctx, id, TrainAuditStateEnum.AUDITED);
    }

    protected void _setAuditing(Context ctx, BOSUuid id) throws BOSException, EASBizException {
        this.setAuditState(ctx, id, TrainAuditStateEnum.AUDITING);
    }

    protected void _setNotAudited(Context ctx, BOSUuid id) throws BOSException, EASBizException {
        this.setAuditState(ctx, id, TrainAuditStateEnum.UNAUDITED);
    }

    protected void _setAuditPass(Context ctx, BOSUuid id) throws BOSException, EASBizException {
        this.setAuditState(ctx, id, TrainAuditStateEnum.PASS);
    }

    protected void _setDeniedAudit(Context ctx, BOSUuid id) throws BOSException, EASBizException {
        this.setAuditState(ctx, id, TrainAuditStateEnum.UNPASS);
    }

    protected void _setUnSubmit(Context ctx, BOSUuid id) throws BOSException, EASBizException {
        this.setAuditState(ctx, id, TrainAuditStateEnum.UNSUBMIT);
    }

    private void setAuditState(Context ctx, BOSUuid id, TrainAuditStateEnum state) throws BOSException, EASBizException {
        String sql = "UPDATE T_HR_TrainPlan SET FAuditState = ? , FAuditorID = ?  WHERE FID = ?";
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = super.getConnection(ctx);
            pstmt = conn.prepareStatement(sql);
            pstmt.setInt(1, state.getValue());
            DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)2, (String)ContextUtil.getCurrentUserInfo((Context)ctx).getPerson().getId().toString());
            DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)3, (String)id.toString());
            pstmt.execute();
        }
        catch (SQLException ex) {
            try {
                throw new BOSException(ex.toString());
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.dealTrainPlanInfo(model);
        this.saveNewExcCount(ctx, model);
        return super._submit(ctx, model);
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.dealTrainPlanInfo(model);
        this.saveNewExcCount(ctx, model);
        return super._save(ctx, model);
    }

    private void dealTrainPlanInfo(IObjectValue model) {
        if (model instanceof TrainPlanInfo) {
            TrainPlanInfo trainPlanInfo = (TrainPlanInfo)model;
            TrainPlanTrainPlanActivityCollection activityColl = trainPlanInfo.getTrainPlanActivity();
            TrainPlanTrainPlanActivityInfo activityInfo = null;
            int size = activityColl.size();
            for (int i = 0; i < size; ++i) {
                activityInfo = activityColl.get(i);
                TrainItemInfo trainItemInfo = activityInfo.getTrainItem();
                if (trainItemInfo == null) continue;
                TrainItemCourseCollection itemCourseColl = trainItemInfo.getCourse();
                TrainPlanCourseCollection planCourseColl = activityInfo.getTrainCourse();
                int size2 = itemCourseColl.size();
                for (int j = 0; j < size2; ++j) {
                    TrainItemCourseInfo itemCourseInfo = itemCourseColl.get(j);
                    if (itemCourseInfo.getCourse() == null || this.containCourseInPlanCourseColl(planCourseColl, itemCourseInfo.getCourse())) continue;
                    TrainPlanCourseInfo planCourseInfo = new TrainPlanCourseInfo();
                    planCourseInfo.setTrainPlanActivity(activityInfo);
                    planCourseInfo.setLessonHour(itemCourseInfo.getCourseHour());
                    if (itemCourseInfo.getCourseHourUnit() != null) {
                        planCourseInfo.setTimeUnit(itemCourseInfo.getCourseHourUnit());
                    }
                    planCourseInfo.setTrainCourse(itemCourseInfo.getCourse());
                    planCourseColl.add(planCourseInfo);
                }
            }
        }
    }

    private boolean containCourseInPlanCourseColl(TrainPlanCourseCollection planCourseColl, TrainCourseInfo course) {
        TrainPlanCourseInfo trainPlanCourseInfo = null;
        int size = planCourseColl.size();
        for (int i = 0; i < size; ++i) {
            trainPlanCourseInfo = planCourseColl.get(i);
            if (trainPlanCourseInfo.getTrainCourse() == null || !trainPlanCourseInfo.getTrainCourse().getId().equals((Object)course.getId())) continue;
            return true;
        }
        return false;
    }

    private void saveNewExcCount(Context ctx, IObjectValue model) {
        if (model instanceof TrainPlanInfo) {
            TrainPlanInfo trainPlanInfo = (TrainPlanInfo)model;
            TrainPlanTrainPlanActivityCollection activityColl = trainPlanInfo.getTrainPlanActivity();
            TrainPlanTrainPlanActivityInfo activityInfo = null;
            TrainExePeriodInfo trainExeperiodInfo = null;
            int size = activityColl.size();
            for (int i = 0; i < size; ++i) {
                activityInfo = activityColl.get(i);
                if (activityInfo.getFirstStartDate() == null || activityInfo.getTrainExePeriods().size() > 0) continue;
                trainExeperiodInfo = new TrainExePeriodInfo();
                Date startDate = activityInfo.getFirstStartDate();
                Date endDate = TrainPlanControllerBean.getEndDateByStartAndDayCount(startDate, activityInfo.getPlanNumberDay());
                trainExeperiodInfo.setStartDate(startDate);
                trainExeperiodInfo.setEndDate(endDate);
                trainExeperiodInfo.setName(ResourceBase.getString((String)RES, (String)"periods", (Locale)ctx.getLocale()));
                activityInfo.getTrainExePeriods().add(trainExeperiodInfo);
                activityInfo.setPeriodCount(new BigDecimal(PERIODCOUNT));
            }
        }
    }

    private static Date getEndDateByStartAndDayCount(Date startDate, BigDecimal dayCount) {
        int dayNumber = 0;
        if (dayCount != null) {
            dayNumber = dayCount.intValue();
        }
        if (dayNumber > 0) {
            --dayNumber;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(startDate);
        c.add(5, dayNumber);
        return c.getTime();
    }

    protected IObjectPK _publish(Context ctx, IObjectValue messageInfo, IObjectCollection scopeCollection, boolean sendMail) throws BOSException, EASBizException {
        TrainPlanMessageInfo trainPlanMessageInfo = (TrainPlanMessageInfo)messageInfo;
        TrainPlanParticipantScopeCollection scopes = (TrainPlanParticipantScopeCollection)scopeCollection;
        IObjectPK pk = null;
        if (scopes != null && scopes.size() >= 0) {
            TrainPlanParticipantScopeInfo info = null;
            String email = null;
            ArrayList<String> ids = new ArrayList<String>();
            HashSet<String> mails = new HashSet<String>();
            int size = scopes.size();
            for (int i = 0; i < size; ++i) {
                info = scopes.get(i);
                if (info == null || info.getPerson() == null) continue;
                ids.add(info.getPerson().getId().toString());
                email = info.getPerson().getEmail();
                if (email == null || email.indexOf("@") <= 0) continue;
                mails.add(email);
            }
            HashMap<String, String> messageMap = new HashMap<String, String>();
            messageMap.put("title", trainPlanMessageInfo.getTitle());
            messageMap.put("sender", trainPlanMessageInfo.getSendPerson().getName());
            messageMap.put("body", trainPlanMessageInfo.getContent());
            TrainActivityFacadeFactory.getLocalInstance(ctx).sendMessage(ids, messageMap);
            if (sendMail && mails.size() > 0) {
                TrainActParticipantScopeFactory.getLocalInstance(ctx).sendMail(trainPlanMessageInfo.getSendPerson().getId().toString(), mails, trainPlanMessageInfo.getTitle(), trainPlanMessageInfo.getContent());
            }
            pk = TrainPlanMessageFactory.getLocalInstance(ctx).submit((CoreBaseInfo)trainPlanMessageInfo);
        }
        return pk;
    }

    private boolean isRelationMonthPeriodInfo(Context ctx, Set notDelete_SetExe) throws BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().add(new SelectorItemInfo("planActivity.trainPlan.name"));
        viewInfo.getSelector().add(new SelectorItemInfo("name"));
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("source.id", (Object)notDelete_SetExe, CompareType.INCLUDE));
        filterInfo.getFilterItems().add(new FilterItemInfo("planActivity.trainPlan.planCategory.category", (Object)TrainPlanCategoryEnum.MONTH));
        viewInfo.setFilter(filterInfo);
        TrainExePeriodCollection exe_col = TrainExePeriodFactory.getLocalInstance(ctx).getTrainExePeriodCollection(viewInfo);
        return exe_col != null && exe_col.size() > 0;
    }

    protected void _copy(Context ctx, String trainPlanId) throws BOSException {
        ObjectUuidPK pk = new ObjectUuidPK(trainPlanId);
        try {
            TrainPlanInfo info = super.getTrainPlanInfo(ctx, (IObjectPK)pk);
            info.setId(null);
            Random random = new Random();
            info.setNumber(info.getNumber() + "_Copy" + random.nextInt(100));
            info.setName(info.getName() + "_Copy" + random.nextInt(100));
            info.setAuditState(TrainAuditStateEnum.UNSUBMIT);
            info.setAuditor(null);
            info.setHrOrgUnit(ContextUtil.getCurrentHRUnit((Context)ctx));
            info.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
            TrainPlanTrainPlanActivityCollection activityCol = info.getTrainPlanActivity();
            int size = activityCol.size();
            for (int i = 0; i < size; ++i) {
                TrainPlanTrainPlanActivityInfo activityInfo = activityCol.get(i);
                activityInfo.setId(BOSUuid.create((BOSObjectType)activityInfo.getBOSType()));
                TrainExePeriodCollection periodCol = activityInfo.getTrainExePeriods();
                int len = periodCol.size();
                for (int j = 0; j < len; ++j) {
                    TrainExePeriodInfo periodInfo = periodCol.get(j);
                    if (periodInfo == null) continue;
                    periodInfo.setId(null);
                }
                TrainPlanCourseCollection courseCol = activityInfo.getTrainCourse();
                int len2 = courseCol.size();
                for (int j = 0; j < len2; ++j) {
                    TrainPlanCourseInfo courseInfo = courseCol.get(j);
                    courseInfo.setId(null);
                    TrainPlanCourseTrainPlanCourseCostCollection courseCostCol = courseInfo.getTrainPlanCourseCost();
                    int costLen = courseCostCol.size();
                    for (int k = 0; k < costLen; ++k) {
                        TrainPlanCourseTrainPlanCourseCostInfo courseCostInfo = courseCostCol.get(k);
                        if (courseCostInfo == null) continue;
                        courseCostInfo.setId(null);
                    }
                }
                TrainPlanActivityCostCollection costCol = activityInfo.getTrainPlanActivityCost();
                int len3 = costCol.size();
                for (int j = 0; j < len3; ++j) {
                    TrainPlanActivityCostInfo costInfo = costCol.get(j);
                    if (costInfo == null) continue;
                    costInfo.setId(null);
                }
            }
            super._submit(ctx, (IObjectValue)info);
        }
        catch (EASBizException e) {
            logger.error((Object)"", (Throwable)e);
        }
    }

    protected void _obsolet(Context ctx, String trainPlanId) throws BOSException, EASBizException {
        String sql = "UPDATE T_HR_TrainPlan SET FAuditState = ? WHERE FID = ?";
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = super.getConnection(ctx);
            pstmt = conn.prepareStatement(sql);
            pstmt.setInt(1, 70);
            DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)2, (String)trainPlanId);
            pstmt.execute();
        }
        catch (SQLException ex) {
            try {
                throw new BOSException(ex.toString());
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }
}

