/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.train.TrainActivityCollection;
import com.kingdee.eas.hr.train.TrainActivityFactory;
import com.kingdee.eas.hr.train.TrainAuditStateEnum;
import com.kingdee.eas.hr.train.TrainCommonUtils;
import com.kingdee.eas.hr.train.TrainExePeriodCollection;
import com.kingdee.eas.hr.train.TrainExePeriodFactory;
import com.kingdee.eas.hr.train.TrainExePeriodInfo;
import com.kingdee.eas.hr.train.TrainPlanCategoryCollection;
import com.kingdee.eas.hr.train.TrainPlanCategoryEnum;
import com.kingdee.eas.hr.train.TrainPlanCategoryFactory;
import com.kingdee.eas.hr.train.TrainPlanCategoryInfo;
import com.kingdee.eas.hr.train.TrainPlanCollection;
import com.kingdee.eas.hr.train.TrainPlanCourseInfo;
import com.kingdee.eas.hr.train.TrainPlanException;
import com.kingdee.eas.hr.train.TrainPlanFactory;
import com.kingdee.eas.hr.train.TrainPlanInfo;
import com.kingdee.eas.hr.train.TrainPlanTrainPlanActivityInfo;
import com.kingdee.eas.hr.train.app.AbstractTrainPlanFacadeControllerBean;
import com.kingdee.eas.hr.train.app.CodingRuleServerHelper;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.NumericExceptionSubItem;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class TrainPlanFacadeControllerBean
extends AbstractTrainPlanFacadeControllerBean {
    private static final String RESOURCEPATH = "com.kingdee.eas.hr.train.TrainResource";
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.train.app.TrainPlanFacadeControllerBean");
    private boolean isFirstLoad = true;

    protected IObjectPK _planGenerate(Context ctx, IObjectValue sourceInfo, String adminOrgUnitId, Date startDate, Date endDate, String planNumber, TrainPlanCategoryEnum destType) throws BOSException, EASBizException {
        TrainPlanInfo model = this.assembleConditionInfo(ctx, adminOrgUnitId, startDate, endDate, planNumber, destType);
        this.checkCondition(ctx, model);
        return this.buildTrainPlanInfo(ctx, (TrainPlanInfo)sourceInfo, model);
    }

    private TrainPlanInfo assembleConditionInfo(Context ctx, String adminOrgUnitId, Date startDate, Date endDate, String planNumber, TrainPlanCategoryEnum destType) throws BOSException {
        TrainPlanInfo info = new TrainPlanInfo();
        AdminOrgUnitInfo adminOrgUnitInfo = new AdminOrgUnitInfo();
        adminOrgUnitInfo.setId(BOSUuid.read((String)adminOrgUnitId));
        info.setOrgUnit(adminOrgUnitInfo);
        info.setPlanDate(startDate);
        info.setEndDate(endDate);
        info.setPlanCategory(this.getTrainPlanCategoryInfo(ctx, destType));
        info.setNumber(planNumber);
        return info;
    }

    private TrainPlanCategoryInfo getTrainPlanCategoryInfo(Context ctx, TrainPlanCategoryEnum destType) throws BOSException {
        TrainPlanCategoryInfo planCategoryInfo = null;
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("category", (Object)destType.getValue()));
        viewInfo.setFilter(filterInfo);
        TrainPlanCategoryCollection collection = TrainPlanCategoryFactory.getLocalInstance(ctx).getTrainPlanCategoryCollection(viewInfo);
        if (collection != null && collection.size() > 0) {
            planCategoryInfo = collection.get(0);
        }
        return planCategoryInfo;
    }

    private void checkCondition(Context ctx, TrainPlanInfo model) throws EASBizException, BOSException {
        if (TrainCommonUtils.isEmpty(model.getNumber()) && !CodingRuleServerHelper.hasNumberRule(ctx, (CoreBaseInfo)new TrainPlanInfo())) {
            throw new TrainPlanException(TrainPlanException.CODINGRULE_NOTENABLED);
        }
    }

    protected IObjectCollection _getSourceTrainPlan(Context ctx, String adminOrgUnitId, Date date, TrainPlanCategoryEnum sourceType) throws BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("OrgUnit.id", (Object)adminOrgUnitId));
        filterInfo.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString()));
        Date sourceStartDate = null;
        Date sourceEndDate = null;
        Calendar now = Calendar.getInstance();
        if (TrainPlanCategoryEnum.YEAR.equals((Object)sourceType)) {
            now.setTimeInMillis(date.getTime());
            now.set(2, 0);
            now.set(5, 1);
            sourceStartDate = new Date(now.getTimeInMillis());
            now.set(2, 11);
            now.set(5, 31);
            sourceEndDate = new Date(now.getTimeInMillis());
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("PlanDate", sourceStartDate));
        filterInfo.getFilterItems().add(new FilterItemInfo("endDate", sourceEndDate));
        filterInfo.getFilterItems().add(new FilterItemInfo("planCategory.category", (Object)sourceType.getValue()));
        viewInfo.setFilter(filterInfo);
        return TrainPlanFactory.getLocalInstance(ctx).getTrainPlanCollection(viewInfo);
    }

    private IObjectPK buildTrainPlanInfo(Context ctx, TrainPlanInfo sourcePlanInfo, TrainPlanInfo conditionInfo) throws EASBizException, BOSException {
        TrainPlanInfo trainPlanInfo = (TrainPlanInfo)sourcePlanInfo.clone();
        if (trainPlanInfo.getTrainPlanActivity() == null || trainPlanInfo.getTrainPlanActivity().size() == 0) {
            this.handleException(trainPlanInfo, TrainPlanException.TRAINPLANACTIVITY_NOTFOUND);
        }
        Date startDate = conditionInfo.getPlanDate();
        Date endDate = conditionInfo.getEndDate();
        BigDecimal totalCost = this.handlePlanActivity(trainPlanInfo, startDate, endDate, sourcePlanInfo);
        trainPlanInfo.setTotalCost(totalCost);
        trainPlanInfo.setId(null);
        trainPlanInfo.setNumber(conditionInfo.getNumber());
        StringBuffer name = new StringBuffer();
        name.append(DateTimeUtils.getYear((Date)startDate));
        name.append(ResourceBase.getString((String)RESOURCEPATH, (String)"YEAR", (Locale)ctx.getLocale()));
        name.append(DateTimeUtils.getMonth((Date)startDate));
        name.append(ResourceBase.getString((String)RESOURCEPATH, (String)"MONTH", (Locale)ctx.getLocale()));
        name.append(trainPlanInfo.getName());
        trainPlanInfo.setName(name.toString());
        trainPlanInfo.setPlanCategory(conditionInfo.getPlanCategory());
        trainPlanInfo.setPlanDate(startDate);
        trainPlanInfo.setEndDate(endDate);
        if (this._isNeedWorkFlowAudit(ctx)) {
            trainPlanInfo.setAuditState(TrainAuditStateEnum.UNSUBMIT);
        } else {
            trainPlanInfo.setAuditState(TrainAuditStateEnum.UNAUDITED);
        }
        String str = ResourceBase.getString((String)RESOURCEPATH, (String)"TrainPlanDescription", (Locale)ctx.getLocale());
        MessageFormat formater = new MessageFormat(str);
        trainPlanInfo.setDescription(formater.format(new Object[]{sourcePlanInfo.getName(), sourcePlanInfo.getNumber()}));
        trainPlanInfo.setAuditor(null);
        trainPlanInfo.setCreator(null);
        trainPlanInfo.setCreateTime(null);
        IObjectPK pk = TrainPlanFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)trainPlanInfo);
        return pk;
    }

    private BigDecimal handlePlanActivity(TrainPlanInfo trainPlanInfo, Date startDate, Date endDate, TrainPlanInfo sourceInfo) throws EASBizException, BOSException {
        BigDecimal cost = null;
        boolean hasPeriod = false;
        int size = trainPlanInfo.getTrainPlanActivity().size();
        TrainPlanTrainPlanActivityInfo planActivityInfo = null;
        TrainPlanTrainPlanActivityInfo planActivityInfo_source = null;
        for (int i = size - 1; i >= 0; --i) {
            planActivityInfo = trainPlanInfo.getTrainPlanActivity().get(i);
            if (planActivityInfo.getTrainPlanActivityCost() != null) {
                for (int j = 0; j < planActivityInfo.getTrainPlanActivityCost().size(); ++j) {
                    planActivityInfo.getTrainPlanActivityCost().get(j).setId(null);
                }
            }
            planActivityInfo_source = sourceInfo.getTrainPlanActivity().get(i);
            TrainExePeriodCollection trainExePeriods = planActivityInfo.getTrainExePeriods();
            TrainExePeriodCollection trainExePeriods_source = planActivityInfo_source.getTrainExePeriods();
            this.handleExePeriod(trainExePeriods, startDate, endDate, trainExePeriods_source);
            int periodSize = trainExePeriods == null ? 0 : trainExePeriods.size();
            planActivityInfo.setPeriodCount(new BigDecimal(String.valueOf(periodSize)));
            if (periodSize > 0) {
                hasPeriod = true;
                if (planActivityInfo.getCost() != null) {
                    if (cost == null) {
                        cost = new BigDecimal("0.00");
                    }
                    cost = cost.add(planActivityInfo.getCost().multiply(new BigDecimal(String.valueOf(periodSize))));
                }
            } else {
                trainPlanInfo.getTrainPlanActivity().remove(planActivityInfo);
                continue;
            }
            this.handlePlanCourse(planActivityInfo);
            planActivityInfo.setId(null);
        }
        if (!hasPeriod) {
            this.handleException(trainPlanInfo, TrainPlanException.TRAINEXEPERIOD_NOTFOUND);
        }
        return cost;
    }

    private void handleExePeriod(TrainExePeriodCollection trainExePeriods, Date startDate, Date endDate, TrainExePeriodCollection trainExePeriods_source) throws EASBizException, BOSException {
        if (trainExePeriods != null && trainExePeriods.size() > 0) {
            TrainExePeriodInfo periodInfo = null;
            TrainExePeriodInfo period_sourceInfo = null;
            BOSUuid sourceID = null;
            for (int j = trainExePeriods.size() - 1; j >= 0; --j) {
                periodInfo = trainExePeriods.get(j);
                period_sourceInfo = trainExePeriods_source.get(j);
                if (periodInfo == null || periodInfo.getStartDate() == null || periodInfo.getEndDate() == null) continue;
                if (TrainCommonUtils.greaterThan(periodInfo.getStartDate(), startDate) && TrainCommonUtils.lessThan(periodInfo.getEndDate(), endDate) || TrainCommonUtils.greaterThan(startDate, periodInfo.getStartDate()) && TrainCommonUtils.lessThan(startDate, periodInfo.getEndDate()) || TrainCommonUtils.greaterThan(endDate, periodInfo.getStartDate()) && TrainCommonUtils.lessThan(endDate, periodInfo.getEndDate())) {
                    periodInfo.setSource(period_sourceInfo);
                    period_sourceInfo.setSource(period_sourceInfo);
                    if (period_sourceInfo.getSource() == null) {
                        sourceID = BOSUuid.create((BOSObjectType)new TrainExePeriodInfo().getBOSType());
                        period_sourceInfo.getSource().setId(sourceID);
                    }
                    periodInfo.setId(null);
                    continue;
                }
                trainExePeriods.remove(periodInfo);
            }
        }
    }

    private void handlePlanCourse(TrainPlanTrainPlanActivityInfo planActivityInfo) {
        if (planActivityInfo.getTrainCourse() != null && planActivityInfo.getTrainCourse().size() > 0) {
            int courseSize = planActivityInfo.getTrainCourse().size();
            TrainPlanCourseInfo trainPlanCourseInfo = null;
            for (int i = 0; i < courseSize; ++i) {
                trainPlanCourseInfo = planActivityInfo.getTrainCourse().get(i);
                trainPlanCourseInfo.setId(null);
                if (trainPlanCourseInfo.getTrainPlanCourseCost() == null || trainPlanCourseInfo.getTrainPlanCourseCost().size() <= 0) continue;
                int costSize = trainPlanCourseInfo.getTrainPlanCourseCost().size();
                for (int j = 0; j < costSize; ++j) {
                    trainPlanCourseInfo.getTrainPlanCourseCost().get(j).setId(null);
                }
            }
        }
    }

    private void handleException(TrainPlanInfo trainPlanInfo, NumericExceptionSubItem exceptionItem) throws EASBizException, BOSException {
        Object[] objs = new Object[]{trainPlanInfo.getName()};
        throw new TrainPlanException(exceptionItem, objs);
    }

    protected boolean _isNeedWorkFlowAudit(Context ctx) throws BOSException, EASBizException {
        IParamControl iParam = ParamControlFactory.getLocalInstance((Context)ctx);
        String hrOrgUnitId = ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString();
        String val = iParam.getParamValue((IObjectPK)new ObjectUuidPK(hrOrgUnitId), "hr_train_001");
        return "true".equals(val);
    }

    protected Set _getNotDeleteSet(Context ctx, Set notDeleteSet, boolean isYear) throws BOSException, EASBizException {
        HashSet<String> notDelete_Set = new HashSet<String>();
        for (TrainPlanTrainPlanActivityInfo planAct_info : notDeleteSet) {
            TrainExePeriodCollection col_exe = planAct_info.getTrainExePeriods();
            if (col_exe == null || col_exe.size() <= 0) continue;
            HashSet<TrainExePeriodInfo> notDelete_SetExe = new HashSet<TrainExePeriodInfo>();
            Map notDelete_MapExe = null;
            int j = col_exe.size();
            for (int i = 0; i < j; ++i) {
                TrainExePeriodInfo info_exe = col_exe.get(i);
                notDelete_SetExe.add(info_exe);
            }
            notDelete_MapExe = TrainExePeriodFactory.getLocalInstance(ctx).deleteSource(notDelete_SetExe, isYear);
            if (notDelete_MapExe == null || notDelete_MapExe.size() <= 0) continue;
            notDelete_Set.add(planAct_info.getId().toString());
        }
        return notDelete_Set;
    }

    private TrainActivityCollection getRelationActivity(Context ctx, String planAct_id) throws BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().add(new SelectorItemInfo("*"));
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("planActivity.id", (Object)planAct_id));
        viewInfo.setFilter(filterInfo);
        return TrainActivityFactory.getLocalInstance(ctx).getTrainActivityCollection(viewInfo);
    }

    protected BigDecimal _getBudgetBalance(Context ctx, int year, String orgUnitID) throws BOSException, EASBizException {
        TrainPlanCollection trainplanCol = this.getBugetSet(ctx, year, orgUnitID);
        TrainPlanInfo trainplanInfo = null;
        BigDecimal cost = null;
        BigDecimal totalCost = new BigDecimal("0.00");
        BigDecimal budgetHasUse = new BigDecimal("0.00");
        if (trainplanCol == null || trainplanCol.size() == 0) {
            return new BigDecimal("0.00");
        }
        int j = trainplanCol.size();
        for (int i = 0; i < j; ++i) {
            trainplanInfo = trainplanCol.get(i);
            if (trainplanInfo.getTotalCost() == null || trainplanInfo.getPlanCategory() == null) continue;
            if (trainplanInfo.getPlanCategory().getCategory().equals((Object)TrainPlanCategoryEnum.YEAR) && !TrainAuditStateEnum.OBSOLETE.equals((Object)trainplanInfo.getAuditState())) {
                cost = trainplanInfo.getTotalCost();
                totalCost = cost.add(totalCost);
                continue;
            }
            if (trainplanInfo.getTotalCost() == null || trainplanInfo.getPlanCategory() == null || trainplanInfo.getAuditState() == null || !trainplanInfo.getAuditState().equals((Object)TrainAuditStateEnum.AUDITED) && !trainplanInfo.getAuditState().equals((Object)TrainAuditStateEnum.PASS)) continue;
            cost = trainplanInfo.getTotalCost();
            budgetHasUse = cost.add(budgetHasUse);
        }
        return totalCost.subtract(budgetHasUse);
    }

    protected BigDecimal _getBudgetYear(Context ctx, int year, String orgUnitID) throws BOSException, EASBizException {
        TrainPlanInfo trainplanInfo = null;
        TrainPlanCollection trainplanCol = this.getBugetSet(ctx, year, orgUnitID);
        BigDecimal totalCost = new BigDecimal("0.00");
        BigDecimal cost = null;
        if (trainplanCol == null) {
            return totalCost;
        }
        int j = trainplanCol.size();
        for (int i = 0; i < j; ++i) {
            trainplanInfo = trainplanCol.get(i);
            if (trainplanInfo.getTotalCost() == null || trainplanInfo.getPlanCategory() == null || !trainplanInfo.getPlanCategory().getCategory().equals((Object)TrainPlanCategoryEnum.YEAR) || TrainAuditStateEnum.OBSOLETE.equals((Object)trainplanInfo.getAuditState())) continue;
            cost = trainplanInfo.getTotalCost();
            totalCost = cost.add(totalCost);
        }
        return totalCost;
    }

    protected Set _getBudget(Context ctx, int year, String orgUnitID) throws BOSException, EASBizException {
        BigDecimal[] budgetArray = new BigDecimal[3];
        HashSet<BigDecimal[]> BudgetSet = new HashSet<BigDecimal[]>();
        BigDecimal balance = this._getBudgetBalance(ctx, year, orgUnitID);
        BigDecimal totalCost = this._getBudgetYear(ctx, year, orgUnitID);
        BigDecimal budgetHasUse = totalCost.subtract(balance);
        logger.info((Object)("TrainPlan budgetHasUse: [" + budgetHasUse + "]"));
        budgetArray[0] = balance;
        budgetArray[1] = totalCost;
        budgetArray[2] = budgetHasUse;
        BudgetSet.add(budgetArray);
        return BudgetSet;
    }

    protected TrainPlanCollection getBugetSet(Context ctx, int year, String orgUnitID) throws BOSException, EASBizException {
        if (!this.isFirstLoad) {
            return null;
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        Calendar calendar = Calendar.getInstance();
        calendar.set(year - 1, 11, 31, 23, 59, 59);
        Date planDate = calendar.getTime();
        calendar.set(year, 11, 31, 23, 59, 59);
        Date endDate = calendar.getTime();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("PlanDate", (Object)planDate, CompareType.GREATER));
        fi.getFilterItems().add(new FilterItemInfo("PlanDate", (Object)endDate, CompareType.LESS));
        fi.getFilterItems().add(new FilterItemInfo("OrgUnit.id", (Object)orgUnitID, CompareType.EQUALS));
        viewInfo.setFilter(fi);
        viewInfo.getSelector().add(new SelectorItemInfo("planCategory.category"));
        viewInfo.getSelector().add(new SelectorItemInfo("TotalCost"));
        viewInfo.getSelector().add(new SelectorItemInfo("AuditState"));
        TrainPlanCollection trainplanCol = TrainPlanFactory.getLocalInstance(ctx).getTrainPlanCollection(viewInfo);
        return trainplanCol;
    }
}

