/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.train.ChannelCoursE1Collection;
import com.kingdee.eas.hr.train.ChannelCoursE1Factory;
import com.kingdee.eas.hr.train.ChannelCoursE1Info;
import com.kingdee.eas.hr.train.TrainPlanCourseCollection;
import com.kingdee.eas.hr.train.TrainPlanCourseInfo;
import com.kingdee.eas.hr.train.TrainPlanTrainPlanActivityInfo;
import com.kingdee.eas.hr.train.app.AbstractTrainPlanTrainPlanActivityControllerBean;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.log4j.Logger;

public class TrainPlanTrainPlanActivityControllerBean
extends AbstractTrainPlanTrainPlanActivityControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.train.app.TrainPlanTrainPlanActivityControllerBean");

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        TrainPlanTrainPlanActivityInfo activityInfo = (TrainPlanTrainPlanActivityInfo)model;
        TrainPlanCourseCollection courseCol = activityInfo.getTrainCourse();
        int size = courseCol.size();
        for (int i = 0; i < size; ++i) {
            String trainInstructorId;
            String trainCourseId;
            TrainPlanCourseInfo courseInfo = courseCol.get(i);
            ChannelCoursE1Info courseE1 = courseInfo.getChanelE1();
            if (courseE1 != null || courseInfo.getTrainInstructor() == null || this.isExitInstructor(ctx, trainCourseId = courseInfo.getTrainCourse().getId().toString(), trainInstructorId = courseInfo.getTrainInstructor().getId().toString())) continue;
            HashSet<String> addInstructorID = new HashSet<String>();
            addInstructorID.add(trainInstructorId);
            ChannelCoursE1Factory.getLocalInstance(ctx).batchAddInstructorForCourse(addInstructorID, null, trainCourseId);
        }
        return super._submit(ctx, model);
    }

    private boolean isExitInstructor(Context ctx, String trainCourseId, String trainInstructorId) {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("TrainCourse.id", (Object)trainCourseId));
        fi.getFilterItems().add(new FilterItemInfo("trainChannel.id", null, CompareType.EQUALS));
        evi.setFilter(fi);
        evi.getSelector().add(new SelectorItemInfo("Instructor.id"));
        try {
            ChannelCoursE1Collection col = ChannelCoursE1Factory.getLocalInstance(ctx).getChannelCoursE1Collection(evi);
            int size = col.size();
            for (int i = 0; i < size; ++i) {
                if (!trainInstructorId.equals(col.get(i).getInstructor().getId().toString())) continue;
                return true;
            }
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
        }
        return false;
    }

    protected void _setExeCount(Context ctx, String id, BigDecimal count) throws BOSException, EASBizException {
        HashSet<String> ids = new HashSet<String>();
        ids.add(id);
        this._setNewExeCount(ctx, ids, count);
    }

    protected void _setNewExeCount(Context ctx, Set ids, BigDecimal count) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE T_HR_PlanActivity SET FPeriodCount = ? WHERE FID in (");
        Iterator it = ids.iterator();
        int index = 0;
        while (it.hasNext()) {
            it.next();
            if (index > 0) {
                sql.append(",");
            }
            sql.append("?");
            ++index;
        }
        sql.append(")");
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = super.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            index = 1;
            pstmt.setBigDecimal(index++, count);
            it = ids.iterator();
            while (it.hasNext()) {
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)index++, (String)((String)it.next()));
            }
            pstmt.execute();
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e);
                throw new BOSException(e.getMessage(), e.getCause());
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }
}

