/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.HROrgUnitFactory;
import com.kingdee.eas.basedata.org.IHROrgUnit;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.train.AssessMethodFactory;
import com.kingdee.eas.hr.train.ITrainCourse;
import com.kingdee.eas.hr.train.ITrainCourseRecord;
import com.kingdee.eas.hr.train.TrainActivityFactory;
import com.kingdee.eas.hr.train.TrainCommonUtils;
import com.kingdee.eas.hr.train.TrainCourseFactory;
import com.kingdee.eas.hr.train.TrainCourseRecordCollection;
import com.kingdee.eas.hr.train.TrainCourseRecordExtendsFactory;
import com.kingdee.eas.hr.train.TrainCourseRecordExtendsInfo;
import com.kingdee.eas.hr.train.TrainCourseRecordFactory;
import com.kingdee.eas.hr.train.TrainCourseRecordInfo;
import com.kingdee.eas.hr.train.TrainItemFactory;
import com.kingdee.eas.hr.train.TrainRecordException;
import com.kingdee.eas.hr.train.TrainRecordIsPassedEnum;
import com.kingdee.eas.hr.train.TrainTypeEnum;
import com.kingdee.eas.hr.train.TrainingMethodFactory;
import com.kingdee.eas.hr.train.app.TrainUtilsServer;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.DIETemplateCollection;
import com.kingdee.eas.tools.datatask.DIETemplateFactory;
import com.kingdee.eas.tools.datatask.DIETemplateFieldEntryCollection;
import com.kingdee.eas.tools.datatask.DIETemplateFieldEntryInfo;
import com.kingdee.eas.tools.datatask.DIETemplateInfo;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.databind.DataBindUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.enums.IntEnum;
import com.kingdee.util.enums.StringEnum;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import org.apache.log4j.Logger;

public class TrainRecordDataTransmission
extends AbstractDataTransmission {
    private static final Logger logger = Logger.getLogger((String)TrainRecordDataTransmission.class.getName());
    private static final String RESOURCEPATH = "com.kingdee.eas.hr.train.TrainResource";
    private static final String split = "_";
    private static final BigDecimal maxPrecision = new BigDecimal("99999999.99");
    private static final BigDecimal minPrecision = new BigDecimal("0.00");
    private static final int TRAINADDRESS_MAXLENGTH = 200;
    private static final int DESCRIPTION_MAXLENGTH = 400;
    private ITrainCourseRecord trainCourseRecordFactory;
    private Map factoryMap;
    private List importFields;

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            if (this.trainCourseRecordFactory == null) {
                this.trainCourseRecordFactory = TrainCourseRecordFactory.getLocalInstance(ctx);
            }
            return this.trainCourseRecordFactory;
        }
        catch (BOSException e) {
            throw new TaskExternalException("BOSException: getLocalInstance", (Throwable)e);
        }
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        try {
            TrainCourseRecordInfo recordInfo = (TrainCourseRecordInfo)coreBaseInfo;
            this.verify(recordInfo);
            this.setDefaultValue(recordInfo);
            ITrainCourseRecord factory = (ITrainCourseRecord)this.getController(ctx);
            if (this.isSltImportUpdate() && !this.setRecordInfo(factory, recordInfo)) {
                return;
            }
            recordInfo.put("come_from", "TrainCourseRecord");
            factory.submitTrainCourseRecord(recordInfo);
        }
        catch (Exception e) {
            logger.info((Object)e.getMessage());
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    private boolean setRecordInfo(ITrainCourseRecord factory, TrainCourseRecordInfo recordInfo) throws BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("recordExtends.PosiStudent.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("recordExtends.OrgStudent.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("recordExtends.isApproved"));
        viewInfo.getSelector().add(new SelectorItemInfo("recordExtends.actIsApproved"));
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("employee.id", (Object)recordInfo.getEmployee().getId().toString()));
        if (!TrainCommonUtils.isEmpty((CoreBaseInfo)recordInfo.getTrainActivity())) {
            filterInfo.getFilterItems().add(new FilterItemInfo("TrainActivity.id", (Object)recordInfo.getTrainActivity().getId().toString()));
        } else {
            filterInfo.getFilterItems().add(new FilterItemInfo("TrainActivity.id", null));
            filterInfo.getFilterItems().add(new FilterItemInfo("BeginDateTime", (Object)recordInfo.getBeginDateTime()));
            filterInfo.getFilterItems().add(new FilterItemInfo("EndDateTime", (Object)recordInfo.getEndDateTime()));
        }
        String courseId = null;
        if (!TrainCommonUtils.isEmpty((CoreBaseInfo)recordInfo.getTrainCourse())) {
            courseId = recordInfo.getTrainCourse().getId().toString();
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("TrainCourse.id", (Object)courseId));
        viewInfo.setFilter(filterInfo);
        TrainCourseRecordCollection collection = factory.getTrainCourseRecordCollection(viewInfo);
        if (collection != null && collection.size() > 0) {
            if (collection.get(0).getRecordExtends().isIsApproved()) {
                return false;
            }
            recordInfo.setId(collection.get(0).getId());
            TrainCourseRecordExtendsInfo extendsInfo = collection.get(0).getRecordExtends();
            if (extendsInfo != null) {
                recordInfo.getRecordExtends().setPosiStudent(extendsInfo.getPosiStudent());
                recordInfo.getRecordExtends().setOrgStudent(extendsInfo.getOrgStudent());
            }
        }
        return true;
    }

    private void verify(TrainCourseRecordInfo info) throws TrainRecordException {
        if (TrainCommonUtils.isEmpty((CoreBaseInfo)info.getEmployee())) {
            throw new TrainRecordException(TrainRecordException.EMPLOYEENUMBER_EMPTY);
        }
        if (TrainCommonUtils.isEmpty((CoreBaseInfo)info.getTrainCourse())) {
            throw new TrainRecordException(TrainRecordException.TRAINCOURSE_NUMBER_EMPTY);
        }
        if (TrainCommonUtils.isEmpty((CoreBaseInfo)info.getTrainActivity()) && TrainCommonUtils.isEmpty((CoreBaseInfo)info.getTrainCourse())) {
            throw new TrainRecordException(TrainRecordException.ACTIVITYANDCOURSE_EMPTY);
        }
        if (info.getTrainType() == null) {
            throw new TrainRecordException(TrainRecordException.TRAINTYPE_EMPTY);
        }
        if (!TrainCommonUtils.isEmpty((CoreBaseInfo)info.getTrainActivity())) {
            if (TrainTypeEnum.OUTTRAINTYPE.equals((Object)info.getTrainType())) {
                throw new TrainRecordException(TrainRecordException.TRAINTYPE_MUST_INNER);
            }
            if (info.getActBeginDate() == null || info.getActEndDate() == null) {
                throw new TrainRecordException(TrainRecordException.ACTIVITY_DATE_EMPTY);
            }
            if (info.getActBeginDate().after(info.getActEndDate())) {
                throw new TrainRecordException(TrainRecordException.TRAINACTIVITY_BEGINDATE_ENDDATE);
            }
        }
        if (!TrainCommonUtils.isEmpty((CoreBaseInfo)info.getTrainCourse())) {
            if (info.getBeginDateTime() == null || info.getEndDateTime() == null) {
                throw new TrainRecordException(TrainRecordException.COURSE_DATE_EMPTY);
            }
            if (!info.getEndDateTime().after(info.getBeginDateTime())) {
                throw new TrainRecordException(TrainRecordException.TRAINCOURSE_BEGINDATE_ENDDATE);
            }
        }
    }

    private void setDefaultValue(TrainCourseRecordInfo info) {
        if (info.getActIsPassed() == null) {
            info.setActIsPassed(TrainRecordIsPassedEnum.PASSED);
        }
        if (info.getIsPassed() == null) {
            info.setIsPassed(TrainRecordIsPassedEnum.PASSED);
        }
        if (!TrainCommonUtils.isEmpty((CoreBaseInfo)info.getTrainActivity())) {
            info.setActTrainType(TrainTypeEnum.INNERTRAINTYPE);
        } else {
            info.put("actTrainType", null);
        }
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        try {
            TrainCourseRecordInfo recordInfo = new TrainCourseRecordInfo();
            recordInfo.setRecordExtends(new TrainCourseRecordExtendsInfo());
            this.trans(ctx, hsData, recordInfo);
            return recordInfo;
        }
        catch (Exception e) {
            logger.info((Object)e.getMessage(), (Throwable)e);
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    private void trans(Context ctx, Hashtable hsData, TrainCourseRecordInfo recordInfo) throws Exception {
        Iterator it = hsData.keySet().iterator();
        while (it.hasNext()) {
            this.fillValue(ctx, hsData, recordInfo, (String)it.next());
        }
    }

    private void fillValue(Context ctx, Hashtable hsData, TrainCourseRecordInfo recordInfo, String key) throws Exception {
        String value;
        String string = value = hsData.get(key) != null ? hsData.get(key).toString() : null;
        if (!TrainCommonUtils.isEmpty(value)) {
            if (key.indexOf(split) > 0) {
                this.transLinkProperty(ctx, recordInfo, key, value);
            } else {
                this.transBaseProperty(ctx, recordInfo, key, value);
            }
        }
    }

    private void transLinkProperty(Context ctx, TrainCourseRecordInfo recordInfo, String key, String value) throws Exception {
        IRowSet rowSet;
        String[] strs = TrainCommonUtils.parseString(key, split);
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("name"));
        viewInfo.getSelector().add(new SelectorItemInfo("number"));
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo(strs[1], (Object)value));
        if ("orgUnit_number".equals(key)) {
            IHROrgUnit hrOrgUnitFactory = HROrgUnitFactory.getLocalInstance((Context)ctx);
            AdminOrgUnitCollection adminOrgUnits = hrOrgUnitFactory.getAdminOrgUnitCollectionWithOrgRangeFilter(ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString());
            if (adminOrgUnits != null && adminOrgUnits.size() > 0) {
                filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)TrainCommonUtils.assembleSetByArray(adminOrgUnits.toArray()), CompareType.INCLUDE));
            } else {
                filterInfo.getFilterItems().add(new FilterItemInfo("id", null));
            }
        }
        if ("trainActivity_number".equals(key)) {
            filterInfo.mergeFilter(TrainUtilsServer.getHRFilterInfo(ctx, "HROrgUnit.id"), "AND");
        }
        if ("trainCourse_number".equals(key)) {
            ITrainCourse iTrainCourse = TrainCourseFactory.getLocalInstance(ctx);
            FilterInfo trainCourseFilterInfo = new FilterInfo();
            trainCourseFilterInfo.getFilterItems().add(new FilterItemInfo(strs[1], (Object)value));
            trainCourseFilterInfo.mergeFilter(TrainUtilsServer.getHRFilterInfo(ctx, "HROrgUnit.id"), "AND");
            if (iTrainCourse.exists(trainCourseFilterInfo)) {
                filterInfo.mergeFilter(TrainUtilsServer.getHRFilterInfo(ctx, "HROrgUnit.id"), "AND");
            }
        }
        viewInfo.setFilter(filterInfo);
        Object obj = this.getFactoryMapContent(ctx).get(key);
        CoreBaseInfo info = null;
        if ("recordExtends_actAssessValue".equals(key)) {
            recordInfo.getRecordExtends().setActAssessValue(value);
            recordInfo.put(strs[0], recordInfo.getRecordExtends());
            return;
        }
        if ("recordExtends_AssessValue".equals(key)) {
            recordInfo.getRecordExtends().setAssessValue(value);
            recordInfo.put(strs[0], recordInfo.getRecordExtends());
            return;
        }
        if (obj instanceof ICoreBase) {
            ICoreBase factory = (ICoreBase)obj;
            CoreBaseCollection collection = factory.getCollection(viewInfo);
            if (collection != null && collection.size() > 0) {
                info = collection.get(0);
            }
        } else if (obj instanceof String && (rowSet = TrainUtilsServer.getRowSet(ctx, (String)obj, filterInfo)) != null && rowSet.size() > 0) {
            rowSet.next();
            info = new PersonInfo();
            info.setId(BOSUuid.read((String)rowSet.getString("id")));
        }
        if (info != null) {
            if ("employee_number".equals(key)) {
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("id"));
                sic.add(new SelectorItemInfo("number"));
                sic.add(new SelectorItemInfo("name"));
                String personId = info.getId().toString();
                info = PersonFactory.getLocalInstance((Context)ctx).getPersonInfo((IObjectPK)new ObjectUuidPK(personId));
            }
        } else {
            throw new TrainRecordException(TrainRecordException.NUMBER_NOT_EXIST, new Object[]{value});
        }
        recordInfo.put(strs[0], info);
    }

    private void transBaseProperty(Context ctx, TrainCourseRecordInfo recordInfo, String key, String value) throws Exception {
        Object obj;
        block11: {
            Class classType = this.getPropertyType(key);
            obj = null;
            try {
                if (String.class.isAssignableFrom(classType)) {
                    obj = value;
                    this.checkStringLength(ctx, key, value, "rainAddress", 200);
                    this.checkStringLength(ctx, key, value, "escription", 400);
                    break block11;
                }
                if (BigDecimal.class.isAssignableFrom(classType)) {
                    obj = new BigDecimal(value);
                    if (((BigDecimal)obj).compareTo(minPrecision) < 0 || ((BigDecimal)obj).compareTo(maxPrecision) > 0) {
                        String message = ResourceBase.getString((String)RESOURCEPATH, (String)"ValueOutRange", (Locale)ctx.getLocale());
                        throw new TaskExternalException(MessageFormat.format(message, minPrecision, maxPrecision));
                    }
                    break block11;
                }
                if (classType.isAssignableFrom(Date.class) || Timestamp.class.isAssignableFrom(classType)) {
                    obj = DateTimeUtils.parseDate((String)value);
                    break block11;
                }
                if (Boolean.TYPE.isAssignableFrom(classType)) {
                    obj = Boolean.valueOf(value);
                    break block11;
                }
                if (IntEnum.class.isAssignableFrom(classType)) {
                    obj = DataBindUtil.getIntegerEnum((Class)classType, (String)"getEnum", (int)Integer.parseInt(value));
                    if (obj == null) {
                        throw new TaskExternalException(key + "'s type error");
                    }
                    break block11;
                }
                if (StringEnum.class.isAssignableFrom(classType)) {
                    obj = DataBindUtil.getStringEnum((Class)classType, (String)"getEnum", (String)value);
                    if (obj == null) {
                        throw new TaskExternalException(key + "'s type error");
                    }
                    break block11;
                }
                throw new TaskExternalException(key + "'s type match error");
            }
            catch (Exception e) {
                String alias = this.getTemplateAlias(ctx, key);
                throw new TrainRecordException(TrainRecordException.BASEPROPERTY_TRANS_FAIL, e, new Object[]{alias, value, e.getMessage()});
            }
        }
        recordInfo.put(key, obj);
    }

    private String getTemplateAlias(Context ctx, String key) throws BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("fieldEntries.number"));
        sic.add(new SelectorItemInfo("fieldEntries.name"));
        viewInfo.setSelector(sic);
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("entityBosType", (Object)new TrainCourseRecordInfo().getBOSType().toString()));
        filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)"trainRecord"));
        viewInfo.setFilter(filterInfo);
        DIETemplateCollection templates = DIETemplateFactory.getLocalInstance((Context)ctx).getDIETemplateCollection(viewInfo);
        if (templates != null && templates.size() > 0) {
            DIETemplateFieldEntryCollection fields = templates.get(0).getFieldEntries();
            DIETemplateFieldEntryInfo info = null;
            int size = fields.size();
            for (int i = 0; i < size; ++i) {
                info = fields.get(i);
                if (info == null || !key.equals(info.getNumber())) continue;
                key = info.getName();
                break;
            }
        }
        return key;
    }

    private void checkStringLength(Context ctx, String key, String value, String columnName, int maxLength) throws TaskExternalException {
        if (key.indexOf(columnName) > 0 && value.length() > maxLength) {
            String message = ResourceBase.getString((String)RESOURCEPATH, (String)"LengthTooLong", (Locale)ctx.getLocale());
            throw new TaskExternalException(MessageFormat.format(message, String.valueOf(maxLength)));
        }
    }

    private Class getPropertyType(String propertyName) throws SecurityException, NoSuchMethodException {
        String str = propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1);
        Method method = null;
        try {
            method = TrainCourseRecordInfo.class.getMethod("get" + str, null);
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
        if (method == null) {
            method = TrainCourseRecordInfo.class.getMethod("is" + str, null);
        }
        Class<?> returnType = method.getReturnType();
        return returnType;
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable<String, String> data = new Hashtable<String, String>();
        try {
            for (String columnName : this.getImportFields(ctx)) {
                if (TrainCommonUtils.isEmpty(rs.getString(columnName))) continue;
                Object obj = null;
                if (columnName.indexOf(split) > 0) {
                    obj = rs.getString(columnName);
                } else {
                    Class classType = this.getPropertyType(columnName);
                    if (BigDecimal.class.isAssignableFrom(classType)) {
                        BigDecimal value = rs.getBigDecimal(columnName);
                        value = value.setScale(2, 4);
                        obj = value;
                    } else {
                        obj = classType.isAssignableFrom(Date.class) ? DateTimeUtils.format((Date)rs.getDate(columnName), (String)"yyyy-MM-dd") : (Timestamp.class.isAssignableFrom(classType) ? DateTimeUtils.format((Date)rs.getTimestamp(columnName), (String)"yyyy-MM-dd HH:mm:ss") : rs.getString(columnName));
                    }
                }
                data.put(columnName, (String)obj);
            }
        }
        catch (Exception e) {
            logger.info((Object)e.getMessage());
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return data;
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        return TrainUtilsServer.getHRFilterInfo(ctx, "HROrgUnit.id");
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.hr.train.app.TrainRecordExportQuery";
    }

    private Map getFactoryMapContent(Context ctx) throws BOSException {
        if (this.factoryMap == null || this.factoryMap.size() == 0) {
            this.factoryMap = new HashMap();
            this.factoryMap.put("employee_number", "com.kingdee.eas.hr.train.app.TrainPersonFullQuery");
            this.factoryMap.put("trainActivity_number", TrainActivityFactory.getLocalInstance(ctx));
            this.factoryMap.put("trainCourse_number", TrainCourseFactory.getLocalInstance(ctx));
            this.factoryMap.put("trainItem_number", TrainItemFactory.getLocalInstance(ctx));
            this.factoryMap.put("orgUnit_number", AdminOrgUnitFactory.getLocalInstance((Context)ctx));
            Object factory = TrainingMethodFactory.getLocalInstance(ctx);
            this.factoryMap.put("actTrainMethod_number", factory);
            this.factoryMap.put("trainMethod_number", factory);
            factory = AssessMethodFactory.getLocalInstance(ctx);
            this.factoryMap.put("actAssessMethod_number", factory);
            this.factoryMap.put("assessMethod_number", factory);
            factory = TrainCourseRecordExtendsFactory.getLocalInstance(ctx);
            this.factoryMap.put("recordExtends_actAssessValue", factory);
            this.factoryMap.put("recordExtends_AssessValue", factory);
        }
        return this.factoryMap;
    }

    private List getImportFields(Context ctx) throws BOSException {
        if (this.importFields == null || this.importFields.size() == 0) {
            this.importFields = new ArrayList();
            EntityViewInfo viewInfo = new EntityViewInfo();
            viewInfo.getSelector().add(new SelectorItemInfo("fieldEntries.number"));
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)"trainRecord"));
            viewInfo.setFilter(filterInfo);
            DIETemplateCollection collection = DIETemplateFactory.getLocalInstance((Context)ctx).getDIETemplateCollection(viewInfo);
            if (collection != null && collection.size() > 0) {
                DIETemplateInfo templateInfo = collection.get(0);
                int size = templateInfo.getFieldEntries().size();
                for (int i = 0; i < size; ++i) {
                    this.importFields.add(templateInfo.getFieldEntries().get(i).getNumber());
                }
            }
        }
        return this.importFields;
    }

    private String getNumber() {
        StringBuffer sb = new StringBuffer();
        Date date = new Date();
        sb.append(String.valueOf(DateTimeUtils.getYear((Date)date))).append("-").append(String.valueOf(DateTimeUtils.getMonth((Date)date))).append("-").append(String.valueOf(DateTimeUtils.getDay((Date)date)));
        Random r = new Random();
        sb.append(date.getTime() + (long)r.nextInt() + (long)r.nextInt());
        return sb.toString();
    }
}

