/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.train.CourseHourUnitEnum;
import com.kingdee.eas.hr.train.TrainCommonUtils;
import com.kingdee.eas.hr.train.TrainException;
import com.kingdee.eas.hr.train.TrainMainUnitCollection;
import com.kingdee.eas.hr.train.TrainMainUnitFactory;
import com.kingdee.eas.hr.train.TrainMainUnitInfo;
import com.kingdee.eas.hr.train.TrainUnitTransferCollection;
import com.kingdee.eas.hr.train.app.AbstractTrainRptFormulaFacadeControllerBean;
import com.kingdee.eas.hr.train.app.TrainUtilsServer;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class TrainRptFormulaFacadeControllerBean
extends AbstractTrainRptFormulaFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.train.app.TrainRptFormulaFacadeControllerBean");
    private boolean isActRecord;

    protected int _getTrainEligibleCount(Context ctx, Map parameters) throws BOSException, EASBizException {
        String adminOrgUnit = (String)parameters.get("adminOrgUnit");
        String trainCondition = (String)parameters.get("trainCondition");
        String eligibleNumber = (String)parameters.get("eligibleNumber");
        String dataSource = (String)parameters.get("statDataSource");
        this.isActRecord = "actRecord".equals(dataSource);
        return this.getEmployeesAmount(ctx, adminOrgUnit, trainCondition, eligibleNumber);
    }

    private int getEmployeesAmount(Context ctx, String adminOrgUnit, String trainCondition, String eligibleNumber) throws BOSException, TrainException {
        eligibleNumber = this.convertEligibleNumber(ctx, eligibleNumber);
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.hr.train.app", this.getMainQuery());
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)queryPK);
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = TrainUtilsServer.getHRAndAdminRangeFilterInfo(ctx, "hrOrgUnitId", "adminOrgUnitId");
        if (!TrainCommonUtils.isEmpty(adminOrgUnit)) {
            filterInfo.getFilterItems().add(new FilterItemInfo("adminOrgUnitNumber", (Object)this.getAdminOrgUnitSet(adminOrgUnit), CompareType.INCLUDE));
        }
        if (!TrainCommonUtils.isEmpty(trainCondition)) {
            try {
                FilterInfo conditionFilter = new FilterInfo(trainCondition);
                filterInfo.mergeFilter(conditionFilter, "AND");
            }
            catch (ParserException e) {
                throw new BOSException((Throwable)e);
            }
        }
        viewInfo.setFilter(filterInfo);
        exec.setObjectView(viewInfo);
        StringBuffer innerSql = new StringBuffer(exec.getSQL());
        StringBuffer sql = new StringBuffer();
        sql.append("select count(t1.employeeId) as employeeCount from(");
        sql.append("select t.employeeId as employeeId, t.totalHour as totalHour from (");
        sql.append(innerSql.toString());
        sql.append(") as t where t.totalHour >= ");
        sql.append(eligibleNumber);
        sql.append(") t1");
        int amount = 0;
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            if (rowSet.next()) {
                amount = rowSet.getInt(1);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return amount;
    }

    private String convertEligibleNumber(Context ctx, String eligibleNumber) throws BOSException, TrainException {
        EntityViewInfo viewInfo1 = new EntityViewInfo();
        FilterInfo filterInfo1 = TrainUtilsServer.getHRFilterInfo(ctx, "hrOrgUnit.id");
        filterInfo1.getFilterItems().add(new FilterItemInfo("IsEnable", (Object)1));
        viewInfo1.setFilter(filterInfo1);
        TrainMainUnitCollection collection = TrainMainUnitFactory.getLocalInstance(ctx).getTrainMainUnitCollection(viewInfo1);
        if (collection != null && collection.size() > 0) {
            TrainMainUnitInfo info = collection.get(0);
            if (!CourseHourUnitEnum.DAY.equals((Object)info.getMainUnitType())) {
                TrainUnitTransferCollection entrys = info.getEntry();
                for (int i = 0; i < entrys.size(); ++i) {
                    if (!CourseHourUnitEnum.DAY.equals((Object)entrys.get(i).getTrainTransferType())) continue;
                    BigDecimal day = new BigDecimal(eligibleNumber);
                    day = day.multiply(entrys.get(i).getTransferFormat());
                    eligibleNumber = day.toString();
                    break;
                }
            }
        } else {
            throw new TrainException(TrainException.TRAINMAINUNIT_UNENABLE);
        }
        return eligibleNumber;
    }

    protected String getMainQuery() {
        return this.isActRecord ? "TrainRecordActFormulaQuery" : "TrainRecordCourseFormulaQuery";
    }

    private Set getAdminOrgUnitSet(String adminOrgUnit) {
        StringTokenizer tokenizer = new StringTokenizer(adminOrgUnit, ";");
        HashSet<String> set = new HashSet<String>();
        while (tokenizer.hasMoreTokens()) {
            set.add(tokenizer.nextToken().trim());
        }
        return set;
    }

    protected int _getTrainEmpCount(Context ctx, Map parameters) throws BOSException, EASBizException {
        String adminOrgUnit = (String)parameters.get("adminOrgUnit");
        String trainCondition = (String)parameters.get("trainCondition");
        String dimension = (String)parameters.get("dimension");
        String dataSource = (String)parameters.get("statDataSource");
        this.isActRecord = "actRecord".equals(dataSource);
        return this.getEmployeesAmounts(ctx, adminOrgUnit, trainCondition, dimension);
    }

    private int getEmployeesAmounts(Context ctx, String adminOrgUnit, String trainCondition, String dimension) throws BOSException {
        int count = 0;
        MetaDataPK queryPK = null;
        queryPK = new MetaDataPK("com.kingdee.eas.hr.train.app", this.geTQuery());
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)queryPK);
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = TrainUtilsServer.getHRAndAdminRangeFilterInfo(ctx, "hrOrgUnitId", "adminOrgUnitId");
        if (!TrainCommonUtils.isEmpty(adminOrgUnit)) {
            filterInfo.getFilterItems().add(new FilterItemInfo("adminOrgUnit.number", (Object)this.getAdminOrgUnitSet(adminOrgUnit), CompareType.INCLUDE));
        }
        if (this.isActRecord) {
            filterInfo.getFilterItems().add(new FilterItemInfo("TrainActivity.id", null, CompareType.NOTEQUALS));
        } else {
            filterInfo.getFilterItems().add(new FilterItemInfo("TrainCourse.id", null, CompareType.NOTEQUALS));
        }
        if (!TrainCommonUtils.isEmpty(trainCondition)) {
            try {
                FilterInfo conditionFilter = new FilterInfo(trainCondition);
                filterInfo.mergeFilter(conditionFilter, "AND");
            }
            catch (ParserException e) {
                throw new BOSException((Throwable)e);
            }
        }
        viewInfo.setFilter(filterInfo);
        exec.setObjectView(viewInfo);
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)exec.getSQL().toString());
        HashSet<String> persons = new HashSet<String>();
        String personAct = null;
        if ("amount".equals(dimension)) {
            try {
                rowSet.beforeFirst();
                while (rowSet.next()) {
                    persons.add(rowSet.getString("Employee.id").toString());
                }
                rowSet.beforeFirst();
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            count = persons == null ? 0 : persons.size();
        } else if ("person".equals(dimension)) {
            try {
                rowSet.beforeFirst();
                while (rowSet.next()) {
                    personAct = this.isActRecord ? rowSet.getString("TrainActivity.id").toString().trim() + rowSet.getString("Employee.id").toString().trim() : rowSet.getString("id").toString().trim();
                    persons.add(personAct);
                }
                rowSet.beforeFirst();
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            count = persons == null ? 0 : persons.size();
        }
        return count;
    }

    protected String geTQuery() {
        return this.isActRecord ? "TrainCourseRecordForReportQuery" : "TrainCourseRecordForCourseReportQuery";
    }
}

