/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.org.PositionMemberCollection;
import com.kingdee.eas.basedata.org.PositionMemberFactory;
import com.kingdee.eas.basedata.org.PositionMemberInfo;
import com.kingdee.eas.basedata.person.Genders;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.train.ITrainSignupForm;
import com.kingdee.eas.hr.train.TrainActivityFactory;
import com.kingdee.eas.hr.train.TrainActivityInfo;
import com.kingdee.eas.hr.train.TrainAuditStateEnum;
import com.kingdee.eas.hr.train.TrainCourseFactory;
import com.kingdee.eas.hr.train.TrainCourseInfo;
import com.kingdee.eas.hr.train.TrainSignupFormEntryCollection;
import com.kingdee.eas.hr.train.TrainSignupFormEntryInfo;
import com.kingdee.eas.hr.train.TrainSignupFormException;
import com.kingdee.eas.hr.train.TrainSignupFormFactory;
import com.kingdee.eas.hr.train.TrainSignupFormInfo;
import com.kingdee.eas.hr.train.app.AbstractTrainSignupSingleFacadeControllerBean;
import com.kingdee.eas.hr.train.app.TrainUtilsServer;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class TrainSignupSingleFacadeControllerBean
extends AbstractTrainSignupSingleFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.perf.app.TrainSignupSingleFacadeControllerBean");
    private static final String IS_BATCH = "IsBatch";
    static String RES = "com.kingdee.eas.hr.train.WebSignUpResource";

    protected IRowSet _getTrainActivityCourseByActivityID(Context ctx, String id) throws BOSException, EASBizException {
        if (id == null) {
            return null;
        }
        IRowSet rowSet = null;
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)id));
        viewInfo.setFilter(filter);
        IQueryExecutor iqec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK("com.kingdee.eas.hr.train.app", "TrainActivityForWebSignupFormQuery"));
        iqec.setObjectView(viewInfo);
        rowSet = iqec.executeQuery();
        return rowSet;
    }

    protected UserInfo _getCurrentUser(Context ctx) throws BOSException, EASBizException {
        return ContextUtil.getCurrentUserInfo((Context)ctx);
    }

    protected PositionInfo _getPosition(Context ctx) throws BOSException, EASBizException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("person.id", (Object)ContextUtil.getCurrentUserInfo((Context)ctx).getPerson().getId().toString(), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("isPrimary", (Object)1, CompareType.EQUALS));
        viewInfo.setFilter(filterInfo);
        viewInfo.getSelector().add(new SelectorItemInfo("position.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("position.name"));
        viewInfo.getSelector().add(new SelectorItemInfo("position.number"));
        try {
            PositionMemberCollection collection = PositionMemberFactory.getLocalInstance((Context)ctx).getPositionMemberCollection(viewInfo);
            if (collection != null && collection.size() > 0) {
                PositionMemberInfo info = collection.get(0);
                return info.getPosition();
            }
        }
        catch (BOSException e) {
            throw new BOSException(e.getMessage(), e.getCause());
        }
        return null;
    }

    protected AdminOrgUnitInfo _getAdminOrgUnit(Context ctx) throws BOSException, EASBizException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("person.id", (Object)ContextUtil.getCurrentUserInfo((Context)ctx).getPerson().getId().toString(), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("isPrimary", (Object)1, CompareType.EQUALS));
        viewInfo.setFilter(filterInfo);
        viewInfo.getSelector().add(new SelectorItemInfo("position.adminOrgUnit.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("position.adminOrgUnit.name"));
        viewInfo.getSelector().add(new SelectorItemInfo("position.adminOrgUnit.number"));
        try {
            PositionMemberCollection collection = PositionMemberFactory.getLocalInstance((Context)ctx).getPositionMemberCollection(viewInfo);
            if (collection != null && collection.size() > 0) {
                PositionMemberInfo info = collection.get(0);
                return info.getPosition().getAdminOrgUnit();
            }
        }
        catch (BOSException e) {
            throw new BOSException(e.getMessage(), e.getCause());
        }
        return null;
    }

    protected void _addNewSignUpSingle(Context ctx, String[] courseIDList, String trainActID) throws BOSException, EASBizException {
        TrainSignupFormEntryCollection collection = new TrainSignupFormEntryCollection();
        if (courseIDList.length > 0) {
            TrainSignupFormEntryInfo info = null;
            TrainCourseInfo courseInfo = null;
            for (int i = 0; i < courseIDList.length; ++i) {
                info = new TrainSignupFormEntryInfo();
                courseInfo = TrainCourseFactory.getLocalInstance(ctx).getTrainCourseInfo((IObjectPK)new ObjectUuidPK(courseIDList[i]));
                info.setCourse(courseInfo);
                info.setAttendee(ContextUtil.getCurrentUserInfo((Context)ctx).getPerson());
                collection.add(info);
            }
        }
        TrainActivityInfo activityInfo = new TrainActivityInfo();
        activityInfo = TrainActivityFactory.getLocalInstance(ctx).getTrainActivityInfo((IObjectPK)new ObjectUuidPK(trainActID));
        if (trainActID != null) {
            activityInfo.setId(BOSUuid.read((String)trainActID));
        }
        TrainSignupFormInfo editData = new TrainSignupFormInfo();
        editData.put("entrys", (Object)collection);
        editData.put("TrainAct", activityInfo);
        editData.put("Name", ResourceBase.getString((String)RES, (String)"singleApply", (Locale)ctx.getLocale()));
        editData.put("Applier", ContextUtil.getCurrentUserInfo((Context)ctx).getPerson());
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        editData.put("ApplyDate", dateFormat.format(new Date()));
        editData.put("orgUnit", this._getAdminOrgUnit(ctx));
    }

    private IRowSet getPersonByPersonID(Context ctx, HashSet set) throws BOSException {
        if (set == null || set.size() == 0) {
            return null;
        }
        IRowSet rowSet = null;
        FilterInfo filter = new FilterInfo();
        EntityViewInfo viewInfo = new EntityViewInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)set, CompareType.INCLUDE));
        viewInfo.setFilter(filter);
        IQueryExecutor iqec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK("com.kingdee.eas.hr.train.app", "PersonPositionAdminQuery"));
        iqec.setObjectView(viewInfo);
        try {
            rowSet = iqec.executeQuery();
        }
        catch (BOSException e) {
            throw new BOSException(e.getMessage(), e.getCause());
        }
        return rowSet;
    }

    public static String encodeHtmlEpecialChar(String html) {
        if (html == null) {
            return "";
        }
        if (html.indexOf("&") >= 0) {
            html = html.replaceAll("&", "&amp;");
        }
        if (html.indexOf("<") >= 0) {
            html = html.replaceAll("<", "&lt;");
        }
        if (html.indexOf(">") >= 0) {
            html = html.replaceAll(">", "&gt;");
        }
        if (html.indexOf("\"") >= 0) {
            html = html.replaceAll("\"", "&quot;");
        }
        if (html.indexOf("'") >= 0) {
            html = html.replaceAll("'", "&apos;");
        }
        if (html.indexOf("\uffe0") >= 0) {
            html = html.replaceAll("\uffe0", "&cent;");
        }
        if (html.indexOf("?") >= 0) {
            html = html.replaceAll("?", "&pound;");
        }
        if (html.indexOf("\u00a7") >= 0) {
            html = html.replaceAll("\u00a7", "&sect;");
        }
        if (html.indexOf("\u00d7") >= 0) {
            html = html.replaceAll("\u00d7", "&times;");
        }
        if (html.indexOf("\u00f7") >= 0) {
            html = html.replaceAll("\u00f7", "&divide;");
        }
        if (html.indexOf(" ") >= 0) {
            html = html.replaceAll(" ", "&nbsp;");
        }
        return html;
    }

    protected String _getPersonListKDLedger(Context ctx, String idListString) throws BOSException, EASBizException {
        HashSet<String> set = new HashSet<String>();
        if (idListString == null || "".equals(idListString)) {
            return null;
        }
        String[] idList = idListString.split(",");
        for (int i = 0; i < idList.length; ++i) {
            set.add(idList[i].replaceAll(" ", "+"));
        }
        IRowSet rowSet = this.getPersonByPersonID(ctx, set);
        StringBuffer sb = new StringBuffer();
        StringBuffer sbData = new StringBuffer();
        sb.append("<root><reccordcount>");
        try {
            int initserial = 1;
            sb.append(rowSet.size());
            sb.append("</reccordcount><data>");
            while (rowSet.next()) {
                sbData.append(initserial++);
                sbData.append("|");
                sbData.append(rowSet.getString("id"));
                sbData.append("|");
                sbData.append(rowSet.getString("name"));
                sbData.append("|");
                int sex = Integer.parseInt(rowSet.getString("gender"));
                sbData.append(Genders.getEnum((int)sex).toString());
                sbData.append("|");
                sbData.append(rowSet.getString("number"));
                sbData.append("|");
                if (rowSet.getString("positionName") != null) {
                    sbData.append(rowSet.getString("positionName"));
                }
                sbData.append("|");
                if (rowSet.getString("jobGrade.name") != null) {
                    sbData.append(rowSet.getString("jobGrade.name"));
                } else {
                    sbData.append("");
                }
                sbData.append("|");
                sbData.append(rowSet.getString("orgUnit"));
                sbData.append("|~#~~#~~!~");
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), e.getCause());
        }
        sb.append(TrainSignupSingleFacadeControllerBean.encodeHtmlEpecialChar(sbData.toString()));
        sb.append("</data></root>");
        return sb.toString();
    }

    protected IObjectPK _addNewsignUpBatch(Context ctx, String studentCourseString, String trainActID, String id) throws BOSException, EASBizException {
        if (TrainUtilsServer.objectIsNull(studentCourseString)) {
            return null;
        }
        TrainSignupFormEntryCollection collection = new TrainSignupFormEntryCollection();
        TrainSignupFormInfo editData = null;
        if (!TrainUtilsServer.objectIsNull(id)) {
            editData = TrainSignupFormFactory.getLocalInstance(ctx).getTrainSignupFormInfo((IObjectPK)new ObjectUuidPK(id));
        } else {
            editData = new TrainSignupFormInfo();
            TrainActivityInfo activityInfo = new TrainActivityInfo();
            activityInfo.setId(BOSUuid.read((String)trainActID.replaceAll(" ", "+")));
            editData.setTrainAct(activityInfo);
            editData.setName(ResourceBase.getString((String)RES, (String)"signupbatch", (Locale)ctx.getLocale()));
            editData.setApplier(ContextUtil.getCurrentUserInfo((Context)ctx).getPerson());
            editData.setApplyDate(DateTimeUtils.truncateDate((Date)new Date()));
            editData.setOrgUnit(this._getAdminOrgUnit(ctx));
            editData.setAuditState(TrainAuditStateEnum.AUDITING);
            editData.setIsBatch(true);
            if (!TrainUtilsServer.hasNumberRule(ctx, (CoreBaseInfo)editData, TrainUtilsServer.getGroupOrg(ctx).getId().toString(), IS_BATCH)) {
                throw new TrainSignupFormException(TrainSignupFormException.NOT_EXIST_CODERULE);
            }
            TrainUtilsServer.initNumber(ctx, (CoreBaseInfo)editData, TrainUtilsServer.getGroupOrg(ctx).getId().toString(), IS_BATCH);
        }
        editData.put("entrys", (Object)collection);
        String[] studentCourses = studentCourseString.split(";");
        for (int i = 0; i < studentCourses.length; ++i) {
            String[] temp = studentCourses[i].split(",");
            TrainSignupFormEntryInfo info = new TrainSignupFormEntryInfo();
            PersonInfo personInfo = new PersonInfo();
            personInfo.setId(BOSUuid.read((String)temp[0]));
            info.setAttendee(personInfo);
            TrainCourseInfo courseInfo = new TrainCourseInfo();
            courseInfo.setId(BOSUuid.read((String)temp[1]));
            info.setCourse(courseInfo);
            if (temp.length == 3 && !TrainUtilsServer.objectIsNull(temp[2])) {
                info.setId(BOSUuid.read((String)temp[2]));
            }
            if (!TrainUtilsServer.objectIsNull(id)) {
                info.setParent(editData);
            }
            collection.add(info);
        }
        ITrainSignupForm tsf = TrainSignupFormFactory.getLocalInstance(ctx);
        IObjectPK pk = tsf.submit2(editData);
        return pk;
    }

    protected IObjectValue _getTrainSignupFormByID(Context ctx, String id) throws BOSException, EASBizException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)id));
        viewInfo.setFilter(filter);
        SelectorItemCollection sic = viewInfo.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("Name"));
        sic.add(new SelectorItemInfo("TrainAct.id"));
        sic.add(new SelectorItemInfo("Applier.id"));
        sic.add(new SelectorItemInfo("Applier.name"));
        sic.add(new SelectorItemInfo("ApplyDate"));
        sic.add(new SelectorItemInfo("entrys.id"));
        sic.add(new SelectorItemInfo("entrys.Course.id"));
        sic.add(new SelectorItemInfo("entrys.Course.name"));
        sic.add(new SelectorItemInfo("entrys.Attendee.id"));
        sic.add(new SelectorItemInfo("entrys.Attendee.name"));
        TrainSignupFormInfo editData = TrainSignupFormFactory.getLocalInstance(ctx).getTrainSignupFormInfo((IObjectPK)new ObjectUuidPK(id), sic);
        return editData;
    }

    protected HashMap _getApplier(Context ctx) throws BOSException, EASBizException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("applier", this._getCurrentUser(ctx).getName());
        map.put("position", this._getPosition(ctx).getName());
        map.put("orgUnit", this._getAdminOrgUnit(ctx).getName());
        map.put("applyDate", new Date());
        return map;
    }

    protected HashMap _getApplier(Context ctx, String trainSignUpFormID) throws BOSException, EASBizException {
        if (trainSignUpFormID == null || "".equals(trainSignUpFormID)) {
            return this._getApplier(ctx);
        }
        TrainSignupFormInfo info = (TrainSignupFormInfo)this._getTrainSignupFormByID(ctx, trainSignUpFormID);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("applier", info.getApplier().getName());
        map.put("applyDate", info.getApplyDate());
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("person.id", (Object)info.getApplier().getId().toString(), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("isPrimary", (Object)1, CompareType.EQUALS));
        viewInfo.setFilter(filterInfo);
        SelectorItemCollection sic = viewInfo.getSelector();
        sic.add(new SelectorItemInfo("position.id"));
        sic.add(new SelectorItemInfo("position.name"));
        sic.add(new SelectorItemInfo("position.adminOrgUnit.id"));
        sic.add(new SelectorItemInfo("position.adminOrgUnit.name"));
        PositionMemberCollection collection = PositionMemberFactory.getLocalInstance((Context)ctx).getPositionMemberCollection(viewInfo);
        if (collection != null && collection.size() > 0) {
            PositionMemberInfo pmInfo = collection.get(0);
            map.put("position", pmInfo.getPosition().getName());
            map.put("orgUnit", pmInfo.getPosition().getAdminOrgUnit().getName());
        }
        return map;
    }

    protected String _submitSignUpSingle(Context ctx, HttpServletRequest request) throws BOSException, EASBizException {
        String[] signup = request.getParameterValues("signup");
        TrainSignupFormInfo editData = null;
        TrainSignupFormEntryCollection entryColl = null;
        TrainSignupFormEntryInfo entryInfo = null;
        TrainCourseInfo courseInfo = null;
        if (request.getParameter("id") != null) {
            String id = request.getParameter("id").trim();
            editData = (TrainSignupFormInfo)this._getTrainSignupFormByID(ctx, id);
            entryColl = editData.getEntrys();
            for (int i = 0; i < signup.length; ++i) {
                entryInfo = new TrainSignupFormEntryInfo();
                courseInfo = new TrainCourseInfo();
                courseInfo = TrainCourseFactory.getLocalInstance(ctx).getTrainCourseInfo((IObjectPK)new ObjectUuidPK(signup[i]));
                entryInfo.setCourse(courseInfo);
                entryInfo.setAttendee(ContextUtil.getCurrentUserInfo((Context)ctx).getPerson());
                if (!"noentry".equals(request.getParameter(signup[i])) && !request.getParameter(signup[i]).equals("noentry")) {
                    String entryId = request.getParameter(signup[i]).trim();
                    entryInfo.setId(BOSUuid.read((String)entryId));
                }
                entryColl.add(entryInfo);
            }
            editData.put("entrys", (Object)entryColl);
        } else {
            String trainActivityID = request.getParameter("trainActID").trim();
            editData = new TrainSignupFormInfo();
            entryColl = editData.getEntrys();
            for (int i = 0; i < signup.length; ++i) {
                entryInfo = new TrainSignupFormEntryInfo();
                courseInfo = new TrainCourseInfo();
                courseInfo = TrainCourseFactory.getLocalInstance(ctx).getTrainCourseInfo((IObjectPK)new ObjectUuidPK(signup[i]));
                entryInfo.setCourse(courseInfo);
                entryInfo.setAttendee(ContextUtil.getCurrentUserInfo((Context)ctx).getPerson());
                entryColl.add(entryInfo);
            }
            editData.put("entrys", (Object)entryColl);
            TrainActivityInfo activityInfo = new TrainActivityInfo();
            activityInfo = TrainActivityFactory.getLocalInstance(ctx).getTrainActivityInfo((IObjectPK)new ObjectUuidPK(trainActivityID));
            if (trainActivityID != null) {
                activityInfo.setId(BOSUuid.read((String)trainActivityID));
            }
            editData.setTrainAct(activityInfo);
            editData.setName(ResourceBase.getString((String)RES, (String)"singleApply", (Locale)ctx.getLocale()));
            editData.setIsBatch(false);
        }
        editData.setApplier(ContextUtil.getCurrentUserInfo((Context)ctx).getPerson());
        editData.setApplyDate(new Date());
        editData.setOrgUnit(this._getAdminOrgUnit(ctx));
        editData.setAuditState(TrainAuditStateEnum.AUDITING);
        if (!TrainUtilsServer.hasNumberRule(ctx, (CoreBaseInfo)editData, TrainUtilsServer.getGroupOrg(ctx).getId().toString(), IS_BATCH)) {
            throw new TrainSignupFormException(TrainSignupFormException.NOT_EXIST_CODERULE);
        }
        ITrainSignupForm tsf = TrainSignupFormFactory.getLocalInstance(ctx);
        IObjectPK pk = tsf.submit3(editData);
        return pk.toString();
    }

    protected void _submitSignUpBatch(Context ctx, HttpServletRequest request) throws BOSException, EASBizException {
    }
}

