/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.train.ITrainStudentCourse;
import com.kingdee.eas.hr.train.TrainActCourseCollection;
import com.kingdee.eas.hr.train.TrainActCourseFactory;
import com.kingdee.eas.hr.train.TrainActCourseInfo;
import com.kingdee.eas.hr.train.TrainStudentCollection;
import com.kingdee.eas.hr.train.TrainStudentCourseFactory;
import com.kingdee.eas.hr.train.TrainStudentCourseInfo;
import com.kingdee.eas.hr.train.TrainStudentInfo;
import com.kingdee.eas.hr.train.TrainStudentTypeEnum;
import com.kingdee.eas.hr.train.app.AbstractTrainStudentControllerBean;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class TrainStudentControllerBean
extends AbstractTrainStudentControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.train.app.TrainStudentControllerBean");

    protected Map _submitCategory(Context ctx, IObjectCollection studentCollection) throws BOSException, EASBizException {
        Connection conn = null;
        PreparedStatement pstmt = null;
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            String sql = "INSERT INTO T_HR_TrainStudent (FID, FControlUnitID, FTrainActivityID, FPersonID, FType) VALUES (?,?,?,?,?)";
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql);
            String id = null;
            TrainStudentInfo info = null;
            String trainActivityId = null;
            int size = studentCollection.size();
            for (int i = 0; i < size; ++i) {
                info = (TrainStudentInfo)studentCollection.getObject(i);
                id = BOSUuid.create((BOSObjectType)info.getBOSType()).toString();
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)1, (String)id);
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)2, (String)ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString());
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)3, (String)info.getTrainActivity().getId().toString());
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)4, (String)info.getPerson().getId().toString());
                pstmt.setInt(5, info.getType().getValue());
                if (trainActivityId == null) {
                    trainActivityId = info.getTrainActivity().getId().toString();
                }
                pstmt.addBatch();
                map.put(info.getPerson().getId().toString(), id);
            }
            pstmt.executeBatch();
            SQLUtils.cleanup((Statement)pstmt);
            ITrainStudentCourse trainStudentCourse = TrainStudentCourseFactory.getLocalInstance(ctx);
            FilterInfo filter = new FilterInfo();
            String sql2 = "INSERT INTO T_HR_TrainStudentCourse (FID, FControlUnitID, FTrainActCourseID, FPersonID, FType) VALUES (?,?,?,?,?)";
            pstmt = conn.prepareStatement(sql2);
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("TrainActivity.id", trainActivityId));
            evi.setFilter(fi);
            evi.getSelector().add(new SelectorItemInfo("id"));
            TrainActCourseCollection courseColl = TrainActCourseFactory.getLocalInstance(ctx).getTrainActCourseCollection(evi);
            TrainActCourseInfo courseInfo = null;
            int size2 = studentCollection.size();
            for (int i = 0; i < size2; ++i) {
                info = (TrainStudentInfo)studentCollection.getObject(i);
                int size22 = courseColl.size();
                for (int j = 0; j < size22; ++j) {
                    courseInfo = courseColl.get(j);
                    filter.getFilterItems().clear();
                    filter.getFilterItems().add(new FilterItemInfo("TrainActCourse.id", (Object)courseInfo.getId().toString()));
                    filter.getFilterItems().add(new FilterItemInfo("Person.id", (Object)info.getPerson().getId().toString()));
                    if (trainStudentCourse.exists(filter)) continue;
                    id = BOSUuid.create((BOSObjectType)new TrainStudentCourseInfo().getBOSType()).toString();
                    DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)1, (String)id);
                    DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)2, (String)ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString());
                    DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)3, (String)courseInfo.getId().toString());
                    DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)4, (String)info.getPerson().getId().toString());
                    pstmt.setInt(5, info.getType().getValue());
                    pstmt.addBatch();
                }
            }
            pstmt.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
        return map;
    }

    protected void _delete(Context ctx, String trainActivityId, Set idSet) throws BOSException, EASBizException {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("TrainActivity.id", (Object)trainActivityId));
        filterInfo.getFilterItems().add(new FilterItemInfo("person.id", (Object)idSet, CompareType.INCLUDE));
        this.delete(ctx, filterInfo);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("TrainActivity.id", (Object)trainActivityId));
        evi.setFilter(fi);
        evi.getSelector().add(new SelectorItemInfo("id"));
        TrainActCourseCollection courseColl = TrainActCourseFactory.getLocalInstance(ctx).getTrainActCourseCollection(evi);
        HashSet<String> courseIdSet = new HashSet<String>();
        int size = courseColl.size();
        for (int i = 0; i < size; ++i) {
            courseIdSet.add(courseColl.get(i).getId().toString());
        }
        if (courseIdSet.size() > 0) {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("TrainActCourse.id", courseIdSet, CompareType.INCLUDE));
            filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)idSet, CompareType.INCLUDE));
            TrainStudentCourseFactory.getLocalInstance(ctx).delete(filter);
        }
    }

    protected void _submitCategory(Context ctx, Map typeMap, String trainActivityId) throws BOSException, EASBizException {
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            String sql = "UPDATE T_HR_TrainStudent SET FType = ? WHERE FPersonID = ? AND FTrainActivityID = ?";
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql);
            Set entrySet = typeMap.entrySet();
            for (Map.Entry entry : entrySet) {
                if (entry.getValue() == null) continue;
                pstmt.setInt(1, ((TrainStudentTypeEnum)((Object)entry.getValue())).getValue());
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)2, (String)entry.getKey().toString());
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)3, (String)trainActivityId);
                pstmt.addBatch();
            }
            pstmt.executeBatch();
            SQLUtils.cleanup((Statement)pstmt);
            String sql2 = "UPDATE T_HR_TrainStudentCourse SET FType = ? WHERE FPersonID = ? AND FTrainActCourseID IN (SELECT FID FROM T_HR_TrainActCourse WHERE FTrainActivityID= ?)";
            pstmt = conn.prepareStatement(sql2);
            for (Map.Entry entry : entrySet) {
                if (entry.getValue() == null) continue;
                pstmt.setInt(1, ((TrainStudentTypeEnum)((Object)entry.getValue())).getValue());
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)2, (String)entry.getKey().toString());
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)3, (String)trainActivityId);
                pstmt.addBatch();
            }
            pstmt.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    protected Map _submitPerson(Context ctx, IObjectCollection trainStudent) throws BOSException {
        Map map = new HashMap();
        TrainStudentCollection studentCol_new = new TrainStudentCollection();
        TrainStudentCollection studentCol_old = new TrainStudentCollection();
        int size = trainStudent.size();
        for (int i = 0; i < size; ++i) {
            TrainStudentInfo info = (TrainStudentInfo)trainStudent.getObject(i);
            if (info.getId() == null) {
                studentCol_new.add(info);
                continue;
            }
            studentCol_old.add(info);
        }
        if (studentCol_old.size() > 0) {
            map = this.updateTrainStudent(ctx, studentCol_old);
        }
        if (studentCol_new.size() > 0) {
            map = this.createTrainStudent(ctx, studentCol_new);
        }
        return map;
    }

    private Map createTrainStudent(Context ctx, TrainStudentCollection studentCol_new) throws BOSException {
        Connection conn = null;
        PreparedStatement pstmt = null;
        String trainActivityId = null;
        TrainStudentInfo info = null;
        String id = null;
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            String sql = "INSERT INTO T_HR_TrainStudent (FID, FControlUnitID, FTrainActivityID, FPersonID, FOrgStudentID, FPosiStudentID, FType) VALUES (?,?,?,?,?,?,?)";
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql);
            int size = studentCol_new.size();
            for (int i = 0; i < size; ++i) {
                info = (TrainStudentInfo)studentCol_new.getObject(i);
                id = BOSUuid.create((BOSObjectType)info.getBOSType()).toString();
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)1, (String)id);
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)2, (String)ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString());
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)3, (String)info.getTrainActivity().getId().toString());
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)4, (String)info.getPerson().getId().toString());
                pstmt.setString(5, info.getOrgStudent().getId().toString());
                pstmt.setString(6, info.getPosiStudent().getId().toString());
                pstmt.setInt(7, info.getType().getValue());
                if (trainActivityId == null) {
                    trainActivityId = info.getTrainActivity().getId().toString();
                }
                pstmt.addBatch();
                map.put(info.getPerson().getId().toString(), id);
            }
            pstmt.executeBatch();
            SQLUtils.cleanup((Statement)pstmt);
            String sql2 = "INSERT INTO T_HR_TrainStudentCourse (FID, FControlUnitID, FTrainActCourseID, FPersonID, FOrgStudentID, FPosiStudentID, FType) VALUES (?,?,?,?,?,?,?)";
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("TrainActivity.id", trainActivityId));
            evi.setFilter(fi);
            evi.getSelector().add(new SelectorItemInfo("id"));
            TrainActCourseCollection courseColl = TrainActCourseFactory.getLocalInstance(ctx).getTrainActCourseCollection(evi);
            TrainActCourseInfo courseInfo = null;
            int size2 = courseColl.size();
            for (int i = 0; i < size2; ++i) {
                pstmt = conn.prepareStatement(sql2);
                courseInfo = courseColl.get(i);
                int size22 = studentCol_new.size();
                for (int j = 0; j < size22; ++j) {
                    info = (TrainStudentInfo)studentCol_new.getObject(j);
                    id = BOSUuid.create((BOSObjectType)new TrainStudentCourseInfo().getBOSType()).toString();
                    DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)1, (String)id);
                    DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)2, (String)ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString());
                    DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)3, (String)courseInfo.getId().toString());
                    DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)4, (String)info.getPerson().getId().toString());
                    if (info.getOrgStudent() == null) {
                        pstmt.setString(5, null);
                    } else {
                        pstmt.setString(5, info.getOrgStudent().getId().toString());
                    }
                    if (info.getPosiStudent() == null) {
                        pstmt.setString(6, null);
                    } else {
                        pstmt.setString(6, info.getPosiStudent().getId().toString());
                    }
                    pstmt.setInt(7, info.getType().getValue());
                    pstmt.addBatch();
                }
                pstmt.executeBatch();
                SQLUtils.cleanup((Statement)pstmt);
            }
            String sql3 = "UPDATE T_HR_TrainStudentCourse SET FOrgStudentID = ?, FPosiStudentID = ?, FType = ? WHERE FPersonID = ? AND FTrainActCourseID IN (SELECT FID FROM T_HR_TrainActCourse WHERE FTrainActivityID= ?)";
            pstmt = conn.prepareStatement(sql3);
            int size3 = studentCol_new.size();
            for (int i = 0; i < size3; ++i) {
                pstmt.setString(1, info.getOrgStudent().getId().toString());
                pstmt.setString(2, info.getPosiStudent().getId().toString());
                pstmt.setInt(3, info.getType().getValue());
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)4, (String)info.getPerson().getId().toString());
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)5, (String)info.getTrainActivity().getId().toString());
                pstmt.addBatch();
            }
            pstmt.executeBatch();
        }
        catch (Exception e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
        return map;
    }

    private Map updateTrainStudent(Context ctx, TrainStudentCollection studentCol_old) throws BOSException {
        Connection conn = null;
        PreparedStatement pstmt = null;
        TrainStudentInfo info = null;
        try {
            String sql = "UPDATE T_HR_TrainStudent SET FOrgStudentID = ?, FPosiStudentID = ?, FType = ? WHERE FPersonID = ? AND FTrainActivityID = ?";
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql);
            int size = studentCol_old.size();
            for (int i = 0; i < size; ++i) {
                info = (TrainStudentInfo)studentCol_old.getObject(i);
                pstmt.setString(1, info.getOrgStudent().getId().toString());
                pstmt.setString(2, info.getPosiStudent().getId().toString());
                pstmt.setInt(3, info.getType().getValue());
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)4, (String)info.getPerson().getId().toString());
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)5, (String)info.getTrainActivity().getId().toString());
                pstmt.addBatch();
            }
            pstmt.executeBatch();
            SQLUtils.cleanup((Statement)pstmt);
            String sql2 = "UPDATE T_HR_TrainStudentCourse SET FOrgStudentID = ?, FPosiStudentID = ?, FType = ? WHERE FPersonID = ? AND FTrainActCourseID IN (SELECT FID FROM T_HR_TrainActCourse WHERE FTrainActivityID= ?)";
            pstmt = conn.prepareStatement(sql2);
            int size2 = studentCol_old.size();
            for (int i = 0; i < size2; ++i) {
                info = (TrainStudentInfo)studentCol_old.getObject(i);
                pstmt.setString(1, info.getOrgStudent().getId().toString());
                pstmt.setString(2, info.getPosiStudent().getId().toString());
                pstmt.setInt(3, info.getType().getValue());
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)4, (String)info.getPerson().getId().toString());
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)5, (String)info.getTrainActivity().getId().toString());
                pstmt.addBatch();
            }
            pstmt.executeBatch();
        }
        catch (Exception e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
        return null;
    }

    protected void _updatePersonForImport(Context ctx, IObjectCollection trainStudent) throws BOSException, EASBizException {
        TrainStudentCollection studentCol = (TrainStudentCollection)trainStudent;
        this.updateTrainStudent(ctx, studentCol);
    }
}

