/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.train.TrainActParticipantScopeFactory;
import com.kingdee.eas.hr.train.TrainActivityFacadeFactory;
import com.kingdee.eas.hr.train.TrainSummaryMessageFactory;
import com.kingdee.eas.hr.train.TrainSummaryMessageInfo;
import com.kingdee.eas.hr.train.TrainSummaryPublishScopeCollection;
import com.kingdee.eas.hr.train.TrainSummaryPublishScopeInfo;
import com.kingdee.eas.hr.train.app.AbstractTrainSummaryMessageControllerBean;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class TrainSummaryMessageControllerBean
extends AbstractTrainSummaryMessageControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.train.app.TrainSummaryMessageControllerBean");
    private static Pattern pattern = Pattern.compile("^([a-zA-Z0-9_\\-\\.]+)@((\\[[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.)|(([a-zA-Z0-9\\-]+\\.)+))([a-zA-Z]{2,4}|[0-9]{1,3})(\\]?)$");
    Matcher matcher = null;

    protected IObjectPK _publish(Context ctx, TrainSummaryMessageInfo messageInfo, TrainSummaryPublishScopeCollection tspsCollection) throws BOSException, EASBizException {
        IObjectPK pk = null;
        if (tspsCollection != null && tspsCollection.size() > 0) {
            TrainSummaryPublishScopeInfo info = null;
            String email = null;
            ArrayList<String> ids = new ArrayList<String>();
            HashSet<String> mails = new HashSet<String>();
            int size = tspsCollection.size();
            for (int i = 0; i < size; ++i) {
                info = tspsCollection.get(i);
                if (info == null || info.getPerson() == null) continue;
                ids.add(info.getPerson().getId().toString());
                email = info.getPerson().getEmail();
                if (email == null || !this.isCorrectEmail(email)) continue;
                mails.add(email);
            }
            HashMap<String, String> messageMap = new HashMap<String, String>();
            messageMap.put("title", messageInfo.getTitle());
            messageMap.put("sender", messageInfo.getSendPerson().getName());
            messageMap.put("body", messageInfo.getContent());
            TrainActivityFacadeFactory.getLocalInstance(ctx).sendMessage(ids, messageMap);
            if (mails.size() > 0) {
                TrainActParticipantScopeFactory.getLocalInstance(ctx).sendMail(messageInfo.getSendPerson().getId().toString(), mails, messageInfo.getTitle(), messageInfo.getContent());
            }
            pk = TrainSummaryMessageFactory.getLocalInstance(ctx).submit(messageInfo);
        }
        return pk;
    }

    private boolean isCorrectEmail(String eMail) {
        this.matcher = pattern.matcher(eMail);
        return this.matcher.matches();
    }
}

