/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.train.ITrainActCourseParticipator;
import com.kingdee.eas.hr.train.ITrainActivityOrganigerEntry;
import com.kingdee.eas.hr.train.TrainActCourseParticipatorFactory;
import com.kingdee.eas.hr.train.TrainActCourseParticipatorInfo;
import com.kingdee.eas.hr.train.TrainActivityOrganigerEntryFactory;
import com.kingdee.eas.hr.train.TrainActivityOrganigerEntryInfo;
import com.kingdee.eas.hr.train.TrainAuditStatusEnum;
import com.kingdee.eas.hr.train.TrainWorkTimeInfo;
import com.kingdee.eas.hr.train.app.AbstractTrainWorkTimeManagerFacadeControllerBean;
import java.math.BigDecimal;
import java.util.Vector;
import org.apache.log4j.Logger;

public class TrainWorkTimeManagerFacadeControllerBean
extends AbstractTrainWorkTimeManagerFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.train.app.TrainWorkTimeManagerFacadeControllerBean");

    protected void _updateWorkTime(Context ctx, Vector changedInfo) throws BOSException, EASBizException {
        TrainWorkTimeInfo trainWorkTimeInfo = null;
        for (int i = changedInfo.size() - 1; i >= 0; --i) {
            trainWorkTimeInfo = (TrainWorkTimeInfo)changedInfo.get(i);
            if (!TrainAuditStatusEnum.AUDITED.equals((Object)trainWorkTimeInfo.getAuditor())) continue;
            changedInfo.remove(i);
        }
        this.updateWorkTimeData(ctx, changedInfo);
    }

    private void updateWorkTimeData(Context ctx, Vector changedInfo) throws BOSException, EASBizException {
        ObjectUuidPK pk = null;
        ITrainActivityOrganigerEntry ierAOE = TrainActivityOrganigerEntryFactory.getLocalInstance(ctx);
        ITrainActCourseParticipator ierACP = TrainActCourseParticipatorFactory.getLocalInstance(ctx);
        TrainActivityOrganigerEntryInfo infoAOE = null;
        TrainActCourseParticipatorInfo infoACP = null;
        TrainWorkTimeInfo trainWorkTimeInfo = null;
        String key = null;
        for (int i = 0; i < changedInfo.size(); ++i) {
            trainWorkTimeInfo = (TrainWorkTimeInfo)changedInfo.get(i);
            if (trainWorkTimeInfo.getTrainCourse() == null) {
                key = trainWorkTimeInfo.getId();
                pk = new ObjectUuidPK(key.toString());
                infoAOE = ierAOE.getTrainActivityOrganigerEntryInfo((IObjectPK)pk);
                if (trainWorkTimeInfo.getWorkTime() != null) {
                    infoAOE.setWorkload(trainWorkTimeInfo.getWorkTime());
                } else {
                    infoAOE.setWorkload(new BigDecimal("0.00"));
                }
                infoAOE.setStartDate(trainWorkTimeInfo.getStartDate());
                infoAOE.setEndDate(trainWorkTimeInfo.getEndDate());
                infoAOE.setWorkloadUnit(trainWorkTimeInfo.getWorkTimeUnit());
                infoAOE.setStatus(trainWorkTimeInfo.getAuditor());
                ierAOE.update((IObjectPK)pk, (CoreBaseInfo)infoAOE);
            }
            if (trainWorkTimeInfo.getTrainCourse() == null) continue;
            key = trainWorkTimeInfo.getId();
            pk = new ObjectUuidPK(key.toString());
            infoACP = ierACP.getTrainActCourseParticipatorInfo((IObjectPK)pk);
            if (trainWorkTimeInfo.getWorkTime() != null) {
                infoACP.setWorkload(trainWorkTimeInfo.getWorkTime());
            } else {
                infoACP.setWorkload(new BigDecimal("0.00"));
            }
            infoACP.setStartDate(trainWorkTimeInfo.getStartDate());
            infoACP.setEndDate(trainWorkTimeInfo.getEndDate());
            infoACP.setWorkloadUnit(trainWorkTimeInfo.getWorkTimeUnit());
            infoACP.setStatus(trainWorkTimeInfo.getAuditor());
            ierACP.update((IObjectPK)pk, (CoreBaseInfo)infoACP);
        }
    }

    protected void _audit(Context ctx, Vector workTimeCollection) throws BOSException, EASBizException {
        this.updateWorkTimeState(ctx, workTimeCollection, TrainAuditStatusEnum.AUDITED);
        this.dealLogInfo(ctx, workTimeCollection, "train_TrainWorkTime_audit");
    }

    protected void _antiAudit(Context ctx, Vector workTimeCollection) throws BOSException, EASBizException {
        this.updateWorkTimeState(ctx, workTimeCollection, TrainAuditStatusEnum.UNAUDITED);
        this.dealLogInfo(ctx, workTimeCollection, "train_TrainWorkTime_unaudit");
    }

    private void updateWorkTimeState(Context ctx, Vector workTimeCollection, TrainAuditStatusEnum state) throws EASBizException, BOSException {
        if (workTimeCollection != null && workTimeCollection.size() > 0) {
            TrainWorkTimeInfo info = null;
            int size = workTimeCollection.size();
            for (int i = 0; i < size; ++i) {
                info = (TrainWorkTimeInfo)workTimeCollection.get(i);
                info.setAuditor(state);
            }
            this.updateWorkTimeData(ctx, workTimeCollection);
        }
    }

    private void dealLogInfo(Context ctx, Vector workTimeCollection, String logItem) throws BOSException, EASBizException {
        StringBuffer name = new StringBuffer();
        if (workTimeCollection != null && workTimeCollection.size() > 0) {
            int size = workTimeCollection.size();
            for (int i = 0; i < size; ++i) {
                TrainWorkTimeInfo info = (TrainWorkTimeInfo)workTimeCollection.get(i);
                StringBuffer retValue = new StringBuffer();
                if (!StringUtil.isEmptyString((String)info.getPerson())) {
                    retValue.append(info.getPerson());
                }
                retValue.append("   ");
                if (!StringUtil.isEmptyString((String)info.getTrainCourse())) {
                    retValue.append(info.getTrainCourse());
                }
                if (i != size - 1) {
                    retValue.append(" \uff0c ");
                }
                name.append(retValue);
            }
        }
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)"", (BOSObjectType)TrainActivityOrganigerEntryFactory.getLocalInstance(ctx).getType(), null, (String)name.toString(), (String)logItem);
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
    }
}

