/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.web;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.common.web.util.WebContextUtil;
import com.kingdee.eas.hr.train.ITrainSignupSingleFacade;
import com.kingdee.eas.hr.train.RequirementAssistant;
import com.kingdee.eas.hr.train.RequirementFacadeFactory;
import com.kingdee.eas.hr.train.RequirementFactory;
import com.kingdee.eas.hr.train.RequirementInfo;
import com.kingdee.eas.hr.train.RequirementResponseEnum;
import com.kingdee.eas.hr.train.RequirementResponseFactory;
import com.kingdee.eas.hr.train.RequirementResponseInfo;
import com.kingdee.eas.hr.train.RequirementStateEnum;
import com.kingdee.eas.hr.train.TrainCommonUtils;
import com.kingdee.eas.hr.train.TrainSignupFormEntryFactory;
import com.kingdee.eas.hr.train.TrainSignupFormFactory;
import com.kingdee.eas.hr.train.TrainSignupSingleFacadeFactory;
import com.kingdee.eas.hr.train.app.TrainUtilsServer;
import com.kingdee.eas.hr.train.web.TrainPlanUtil;
import com.kingdee.eas.hr.train.web.TrainWebUtils;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import net.buffalo.server.BuffaloService;
import org.apache.log4j.Logger;

public class TrainWebService
extends BuffaloService {
    static String RES = "com.kingdee.eas.hr.train.WebSignUpResource";
    private static Logger logger = Logger.getLogger((String)TrainWebService.class.getName());

    public String getPersonListDataXML(String idArrays, String personIdList) throws BOSException, EASBizException {
        logger.debug((Object)("personIdListString=" + personIdList));
        HttpServletRequest request = (HttpServletRequest)this.getRequest();
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        ITrainSignupSingleFacade tsf = TrainSignupSingleFacadeFactory.getLocalInstance(ctx);
        return tsf.getPersonListKDLedger(personIdList);
    }

    public String setQuerySqlSession(String idArrays, String querySql) throws BOSException, EASBizException {
        logger.debug((Object)("processQuerySql=" + querySql));
        HttpServletRequest request = (HttpServletRequest)this.getRequest();
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        ITrainSignupSingleFacade tsf = TrainSignupSingleFacadeFactory.getLocalInstance(ctx);
        return tsf.getPersonListKDLedger(querySql);
    }

    public boolean removeQuerySqlSession(String querySqlKey) {
        HttpServletRequest request = (HttpServletRequest)this.getRequest();
        HttpSession session = request.getSession();
        session.removeAttribute(querySqlKey);
        return true;
    }

    public boolean canSignup(String activityID) {
        if (TrainUtilsServer.objectIsNull(activityID)) {
            return false;
        }
        HttpServletRequest request = (HttpServletRequest)this.getRequest();
        try {
            return TrainSignupFormFactory.getLocalInstance(WebContextUtil.getEasContext((HttpServletRequest)request)).canSignup(activityID);
        }
        catch (Exception e) {
            logger.info((Object)e.getCause());
            return false;
        }
    }

    public boolean isSignuped(String activityID) {
        if (TrainUtilsServer.objectIsNull(activityID)) {
            return true;
        }
        try {
            HttpServletRequest request = (HttpServletRequest)this.getRequest();
            Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
            String personID = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson().getId().toString();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("Attendee.id", (Object)personID));
            filter.getFilterItems().add(new FilterItemInfo("Parent.TrainAct.id", (Object)activityID));
            return TrainSignupFormEntryFactory.getLocalInstance(ctx).exists(filter);
        }
        catch (Exception e) {
            logger.info((Object)e.getCause());
            return true;
        }
    }

    public String[] submitBatchSignup(String studentCourseString, String trainActID, String id) {
        String[] error = new String[2];
        HttpServletRequest request = (HttpServletRequest)this.getRequest();
        try {
            ITrainSignupSingleFacade tssf = TrainSignupSingleFacadeFactory.getLocalInstance(WebContextUtil.getEasContext((HttpServletRequest)request));
            IObjectPK pk = tssf.addNewsignUpBatch(studentCourseString, trainActID, id);
            if (pk == null) {
                error[1] = ResourceBase.getString((String)RES, (String)"operationError", (Locale)this.getServerContext().getLocale());
                error[0] = "error";
            } else {
                error[0] = "success";
                error[1] = pk.toString();
            }
        }
        catch (EASBizException e) {
            error[1] = e.getMessage();
            error[0] = "error";
            return error;
        }
        catch (BOSException e) {
            logger.info((Object)e.getCause());
            error[1] = ResourceBase.getString((String)RES, (String)"operationError", (Locale)this.getServerContext().getLocale());
            error[0] = "error";
            return error;
        }
        return error;
    }

    public String getTrainPlanActivityDataXML(String trainPlanId) {
        HttpServletRequest request = (HttpServletRequest)this.getRequest();
        return TrainPlanUtil.getTrainPlanActivityDataXML(request, trainPlanId);
    }

    public String getTrainCourseDataXML(String trainPlanActivityId) {
        HttpServletRequest request = (HttpServletRequest)this.getRequest();
        return TrainPlanUtil.getTrainCourseDataXML(request, trainPlanActivityId);
    }

    public String getPlanPeriodsDataXML(String trainPlanActivityId) {
        HttpServletRequest request = (HttpServletRequest)this.getRequest();
        return TrainPlanUtil.getPlanPeriodsDataXML(request, trainPlanActivityId);
    }

    public static String getRequirementResponseDataXML(HttpServletRequest request) {
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        String xml = null;
        try {
            String curPersonId = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson().getId().toString();
            int pageCount = Integer.parseInt(request.getParameter("pageCount"));
            int pageNumber = Integer.parseInt(request.getParameter("pageNumber"));
            int start = (pageNumber - 1) * pageCount;
            ArrayList result = (ArrayList)RequirementFacadeFactory.getLocalInstance(ctx).getRequirementByResponser(curPersonId, start, pageCount);
            xml = TrainWebUtils.makeProcDataToXMLData(result);
        }
        catch (Exception e) {
            logger.info((Object)e.getCause());
            xml = TrainWebUtils.makeErrorProcDataToXMLData(1);
        }
        return xml;
    }

    private Context getServerContext() {
        HttpServletRequest request = (HttpServletRequest)this.getRequest();
        return WebContextUtil.getEasContext((HttpServletRequest)request);
    }

    public String responseVerify(String requirementId, String buttonText) {
        String message = null;
        Context ctx = this.getServerContext();
        String currentPersonId = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson().getId().toString();
        try {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("state"));
            sic.add(new SelectorItemInfo("requirement.state"));
            RequirementResponseInfo requirementResponseInfo = RequirementResponseFactory.getLocalInstance(ctx).getRequirementResponseInfo(requirementId, currentPersonId, sic);
            RequirementStateEnum requirementState = null;
            RequirementResponseEnum responseState = null;
            if (requirementResponseInfo != null) {
                requirementState = requirementResponseInfo.getRequirement().getState();
                responseState = requirementResponseInfo.getState();
            } else {
                sic.clear();
                sic.add(new SelectorItemInfo("state"));
                RequirementInfo requirementInfo = RequirementFactory.getLocalInstance(ctx).getRequirementInfo((IObjectPK)new ObjectUuidPK(requirementId), sic);
                requirementState = requirementInfo.getState();
            }
            if (RequirementStateEnum.CLOSED.equals((Object)requirementState)) {
                message = "error:";
                message = message + TrainCommonUtils.getResource("com.kingdee.eas.hr.train.RequirementResource", "REQUIREMENT_CLOSED", new Object[]{buttonText}, ctx.getLocale());
                return message;
            }
            boolean parentIsResponsed = RequirementResponseFactory.getLocalInstance(ctx).parentIsResponsed(requirementId, currentPersonId);
            if (parentIsResponsed) {
                message = "error:";
                message = message + TrainCommonUtils.getResource("com.kingdee.eas.hr.train.RequirementResource", "PARENT_IS_RESPONSED", new Object[]{buttonText}, ctx.getLocale());
                return message;
            }
            if (RequirementResponseEnum.RESPONSED.equals((Object)responseState)) {
                message = "confirm:";
                message = message + ResourceBase.getString((String)"com.kingdee.eas.hr.train.RequirementResource", (String)"RESPONSED", (Locale)ctx.getLocale());
            }
        }
        catch (Exception e) {
            logger.info((Object)e.getCause());
            return message;
        }
        return message;
    }

    public Object responseCalculate(String requirementId, String responserId) {
        return RequirementAssistant.responseCalculate(this.getServerContext(), requirementId, responserId);
    }

    public String responserIsModified(String requirementId, String responserId, String calculateTime) {
        RequirementResponseInfo responseInfo = new RequirementResponseInfo();
        RequirementInfo requirementInfo = new RequirementInfo();
        requirementInfo.setId(BOSUuid.read((String)requirementId));
        responseInfo.setRequirement(requirementInfo);
        PersonInfo personInfo = new PersonInfo();
        personInfo.setId(BOSUuid.read((String)responserId));
        responseInfo.setResponser(personInfo);
        try {
            Timestamp time = new Timestamp(DateTimeUtils.parseDate((String)calculateTime, (String)"yyyy-MM-dd HH:mm:ss").getTime());
            responseInfo.setCalculateTime(time);
        }
        catch (ParseException e) {
            logger.info((Object)e.getCause());
        }
        Context ctx = this.getServerContext();
        String message = null;
        if (RequirementAssistant.responserIsModified(ctx, responseInfo)) {
            message = ResourceBase.getString((String)"com.kingdee.eas.hr.train.RequirementResource", (String)"RESPONSE_MODIFIED", (Locale)ctx.getLocale());
        }
        return message;
    }

    public String[][] fastQuery(String cboKey, String txtValue, boolean chkLike) {
        if (StringUtils.isEmpty((String)cboKey) || StringUtils.isEmpty((String)txtValue)) {
            return null;
        }
        HttpServletRequest request = (HttpServletRequest)this.getRequest();
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        IQueryExecutor exec = null;
        MetaDataPK mainQueryPK = null;
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        if ("name".equals(cboKey)) {
            if (chkLike) {
                filterInfo.getFilterItems().add(new FilterItemInfo("name", (Object)("%" + txtValue.trim() + "%"), CompareType.LIKE));
            } else {
                filterInfo.getFilterItems().add(new FilterItemInfo("name", (Object)txtValue.trim()));
            }
        } else if (chkLike) {
            filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)("%" + txtValue.trim() + "%"), CompareType.LIKE));
        } else {
            filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)txtValue.trim()));
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("ToUnit.id", (Object)ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString()));
        filterInfo.getFilterItems().add(new FilterItemInfo("PMUser.id", (Object)ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString()));
        mainQueryPK = new MetaDataPK("com.kingdee.eas.hr.train.app", "TrainPersonFullQuery");
        try {
            entityViewInfo.setFilter(filterInfo);
            exec = this.getQueryExecutor((IMetaDataPK)mainQueryPK, entityViewInfo, ctx);
            IRowSet rowSet = exec.executeQuery();
            String[][] rowDataArray = new String[rowSet.size()][5];
            int i = 0;
            while (rowSet.next()) {
                StringBuffer sb = new StringBuffer();
                sb.append(rowSet.getString("id"));
                sb.append("#");
                sb.append(rowSet.getString("AdminOrgUnit.id"));
                rowDataArray[i][0] = sb.toString();
                rowDataArray[i][1] = rowSet.getString("number");
                rowDataArray[i][2] = rowSet.getString("name");
                rowDataArray[i][3] = rowSet.getString("AdminOrgUnit.name");
                rowDataArray[i][4] = rowSet.getString("jobGrade.name");
                ++i;
            }
            return rowDataArray;
        }
        catch (Exception e) {
            logger.info((Object)EASResource.getString((String)"com.kingdee.eas.hr.train.TRAINAutoGenerateResource", (String)"6_TrainWebService"), (Throwable)e);
            return null;
        }
    }

    private IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo, Context context) throws Exception {
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)context, (IMetaDataPK)queryPK);
        exec.setObjectView(viewInfo);
        exec.option().isAutoIgnoreZero = true;
        exec.option().isAutoTranslateEnum = true;
        return exec;
    }
}

