/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.light.cp.cm.service.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.master.util.StringUtil;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.cp.eip.cm.ContentManageFactory;
import com.kingdee.eas.cp.eip.cm.IContentManage;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.light.cp.cm.dto.PostDTO;
import com.kingdee.light.cp.cm.service.XtNewsService;
import com.kingdee.lightapp.xt.XTServiceConfig;
import com.kingdee.portal.common.util.JSONUtil;
import com.kingdee.portal.plt.cp.common.util.DateTool;
import com.kingdee.portal.plt.cp.common.util.PageList;
import com.kingdee.portal.plt.cp.module.cm.dto.ContentDTO;
import java.io.Serializable;
import java.sql.Date;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XtNewsServiceImpl
implements XtNewsService {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private static XtNewsService instance = null;

    public static synchronized XtNewsService getInstance() {
        if (instance == null) {
            instance = new XtNewsServiceImpl();
        }
        return instance;
    }

    @Override
    public String getNewList(Context ctx, Map<String, Object> params) throws Exception {
        int total = 0;
        int pageNo = 0;
        int totalPage = 0;
        int pageSize = 0;
        int currentPage = 0;
        String resultStr = "";
        String type = (String)params.get("type");
        String page = (String)params.get("page");
        String pageSizeStr = (String)params.get("pageSize");
        String orderByField = (String)params.get("sortFieldName");
        String orderType = (String)params.get("sortType");
        String searchKey = (String)params.get("searchKey");
        if (orderByField == null || orderByField.trim().length() == 0) {
            orderByField = "lastUpdateTime";
        }
        if (orderType == null || orderType.trim().length() == 0) {
            orderType = SortType.DESCEND.getName();
        }
        orderType = orderType.toUpperCase();
        if (page == null || page.equals("")) {
            page = "1";
        }
        if (pageSizeStr == null || pageSizeStr.equals("")) {
            pageSizeStr = "10";
        }
        pageNo = Integer.parseInt(page);
        pageSize = Integer.parseInt(pageSizeStr);
        IRowSet rowSet = null;
        IRowSet countRowSet = null;
        PageList resultList = new PageList();
        try {
            String firstPicNews = null;
            if (page.equals("1") && StringUtils.isEmpty((CharSequence)searchKey)) {
                firstPicNews = this.getPicNews(ctx, orderByField, orderType, resultList);
            }
            String columnIds = this.getReadColumnIDStr(ctx, type);
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            FilterItemInfo filterItemInfo = null;
            if (columnIds.length() > 0) {
                filterItemInfo = new FilterItemInfo("columnID", (Object)columnIds, CompareType.INCLUDE);
                filterInfo.getFilterItems().add(filterItemInfo);
            }
            if (firstPicNews != null && StringUtils.isEmpty((CharSequence)searchKey)) {
                filterItemInfo = new FilterItemInfo("id", (Object)firstPicNews, CompareType.NOTEQUALS);
                filterInfo.getFilterItems().add(filterItemInfo);
            }
            filterItemInfo = new FilterItemInfo("status", (Object)2, CompareType.EQUALS);
            filterInfo.getFilterItems().add(filterItemInfo);
            filterItemInfo = new FilterItemInfo("isConvert", (Object)1, CompareType.EQUALS);
            filterInfo.getFilterItems().add(filterItemInfo);
            if (!StringUtils.isEmpty((CharSequence)searchKey)) {
                filterItemInfo = new FilterItemInfo("title", (Object)("%" + searchKey + "%"), CompareType.LIKE);
                filterInfo.getFilterItems().add(filterItemInfo);
                filterItemInfo = new FilterItemInfo("USER.NAME", (Object)("%" + searchKey + "%"), CompareType.LIKE);
                filterInfo.getFilterItems().add(filterItemInfo);
                filterInfo.setMaskString("#0 and #1 and #2 and ( #3 or #4 )");
            } else {
                filterInfo.setMaskString("#0 and #1 and #2");
            }
            entityViewInfo.setFilter(filterInfo);
            MetaDataPK mainQueryPK = new MetaDataPK("com.kingdee.eas.cp.eip.cm.app", "ContentQuery");
            IQueryExecutor exec = null;
            SorterItemInfo sorterItemInfo = new SorterItemInfo(orderByField);
            sorterItemInfo.setSortType(SortType.getEnum((String)orderType));
            entityViewInfo.getSorter().add(sorterItemInfo);
            exec = this.getQueryExecutor((IMetaDataPK)mainQueryPK, entityViewInfo, ctx);
            String sql = exec.getSQL();
            this.logger.info("executor search content  sql is:" + sql);
            System.out.println("executor search content  sql is:" + sql);
            String countSql = sql.substring(0, sql.indexOf("ORDER BY"));
            countSql = " select count(1) from ( " + countSql + " )  AAA ";
            countRowSet = DbUtil.executeQuery((Context)ctx, (String)countSql);
            if (countRowSet.next()) {
                total = countRowSet.getInt(1);
                this.logger.debug("record total is\uff1a" + total);
            }
            totalPage = (total - 1) / pageSize + 1;
            this.logger.debug("total page is:" + totalPage);
            if (pageNo > totalPage) {
                pageNo = totalPage;
            }
            if (pageNo <= 0) {
                pageNo = 1;
            }
            currentPage = pageNo;
            resultList.setTotalRowCount(total);
            resultList.setPageCount(totalPage);
            resultList.setCurrentPage(currentPage);
            resultList.setPageSize(pageSize);
            rowSet = exec.executeQuery((pageNo - 1) * pageSize, pageSize);
            resultList = this.rowSetToPageList(ctx, resultList, rowSet);
            HashMap<String, Object> ajaxData = new HashMap<String, Object>();
            ajaxData.put("newsList", resultList);
            ajaxData.put("currentPage", currentPage);
            ajaxData.put("totalPage", totalPage);
            ajaxData.put("totalCount", total);
            resultStr = JSONUtil.getJson4Object(ajaxData);
        }
        catch (Exception e) {
            this.logger.error("\u5206\u9875\u67e5\u627e\u5185\u5bb9\u53d1\u751f\u9519\u8bef\uff1a" + e.getMessage());
        }
        return resultStr;
    }

    private String getPicNews(Context ctx, String orderByField, String orderType, PageList resultList) throws Exception {
        String firstNewId = null;
        IRowSet rowSet = null;
        String columnIds = this.getReadColumnIDStr(ctx, "70");
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        FilterItemInfo filterItemInfo = null;
        if (columnIds.length() > 0) {
            filterItemInfo = new FilterItemInfo("columnID", (Object)columnIds, CompareType.INCLUDE);
            filterInfo.getFilterItems().add(filterItemInfo);
        }
        filterItemInfo = new FilterItemInfo("status", (Object)2, CompareType.EQUALS);
        filterInfo.getFilterItems().add(filterItemInfo);
        entityViewInfo.setFilter(filterInfo);
        MetaDataPK mainQueryPK = new MetaDataPK("com.kingdee.eas.cp.eip.cm.app", "ContentQuery");
        IQueryExecutor exec = null;
        SorterItemInfo sorterItemInfo = new SorterItemInfo(orderByField);
        sorterItemInfo.setSortType(SortType.getEnum((String)orderType));
        entityViewInfo.getSorter().add(sorterItemInfo);
        exec = this.getQueryExecutor((IMetaDataPK)mainQueryPK, entityViewInfo, ctx);
        rowSet = exec.executeQuery(0, 1);
        if (rowSet.size() < 1) {
            resultList.add((Object)new ContentDTO());
        } else {
            resultList = this.rowSetToPageList(ctx, resultList, rowSet);
            ContentDTO cd = (ContentDTO)resultList.get(0);
            firstNewId = cd.getId();
        }
        return firstNewId;
    }

    private String getReadColumnIDStr(Context ctx, String type) throws Exception {
        String columnType = "";
        columnType = type.equals("news") ? "10,30,70" : (type.equals("announce") ? "40" : type);
        IContentManage iManage = ContentManageFactory.getLocalInstance((Context)ctx);
        IRowSet rowset = iManage.getReadColumn();
        StringBuffer columnIdBf = new StringBuffer();
        columnIdBf.append("0");
        if (rowset != null && rowset.size() > 0) {
            while (rowset.next()) {
                if (rowset.getString("FPublishToDesktop") == null || rowset.getInt("FPublishToDesktop") != 1 || rowset.getString("FCOLUMNTYPE") == null || columnType.indexOf(rowset.getString("FCOLUMNTYPE")) <= -1) continue;
                columnIdBf.append(",");
                columnIdBf.append(rowset.getString("FID"));
            }
        }
        return columnIdBf.toString();
    }

    private IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo, Context context) throws Exception {
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)context, (IMetaDataPK)queryPK);
        exec.setObjectView(viewInfo);
        exec.option().isAutoIgnoreZero = true;
        exec.option().isAutoTranslateEnum = true;
        return exec;
    }

    public PageList rowSetToPageList(Context ctx, PageList list, IRowSet rowSet) throws Exception {
        String columnName = "";
        String isMore = this.isMoreServer(ctx, "news");
        while (rowSet.next()) {
            if ("true".equals(isMore)) {
                this.createNewFile(ctx, "news", rowSet.getString("ID"));
            }
            ContentDTO dto = new ContentDTO();
            dto.setId(rowSet.getString("ID"));
            dto.setColumnId(rowSet.getString("COLUMNID"));
            dto.setTitle(rowSet.getString("TITLE"));
            dto.setCreateName(rowSet.getString("USER.NAME"));
            Date createTime = rowSet.getDate("CREATETIME");
            dto.setCreateTime(DateTool.dateToString((java.util.Date)createTime, (String)"yyyy-MM-dd HH:mm:ss"));
            String summary = rowSet.getString("SUMMARY");
            if (summary != null) {
                summary = summary.replaceAll("\n", "");
                summary = summary.replaceAll("\r", "");
                summary = summary.replaceAll("\t", "");
                summary = summary.replaceAll("\"", "");
            }
            dto.setSummary(summary);
            dto.setClicks(Integer.valueOf(rowSet.getInt("CLICKS")));
            dto.setFileId(rowSet.getString("xtImgName"));
            dto.setDisplayNew(String.valueOf(rowSet.getInt("DISPLAYNEW")));
            columnName = rowSet.getString("CMCOLUMN.COLUMNTYPE");
            dto.setColumnName(columnName);
            dto.setColumnType(this.getColumnType(columnName));
            list.add((Object)dto);
        }
        return list;
    }

    @Override
    public String getPostList(Context context, Map<String, Object> params) throws Exception {
        int total = 0;
        int pageNo = 0;
        int totalPage = 0;
        int pageSize = 0;
        int currentPage = 0;
        String page = (String)params.get("page");
        String pageSizeStr = (String)params.get("pageSize");
        String orderByField = (String)params.get("sortFieldName");
        String orderType = (String)params.get("sortType");
        String searchKey = (String)params.get("searchKey");
        String formId = (String)params.get("formId");
        if (orderByField == null || orderByField.trim().length() == 0) {
            orderByField = "lastUpdateTime";
        }
        if (orderType == null || orderType.trim().length() == 0) {
            orderType = SortType.DESCEND.getName();
        }
        orderType = orderType.toUpperCase();
        if (page == null || page.equals("")) {
            page = "1";
        }
        if (pageSizeStr == null || pageSizeStr.equals("")) {
            pageSizeStr = "10";
        }
        pageNo = Integer.parseInt(page);
        pageSize = Integer.parseInt(pageSizeStr);
        PersonInfo info = ContextUtil.getCurrentUserInfo((Context)context).getPerson();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("receiver.id", (Object)info.getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("DocumentInfo.workflowStatus", (Object)new Integer(2), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("DocumentInfo.workflowStatus", (Object)new Integer(4), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("ReleasePortlet.isConvert", (Object)new Integer(1), CompareType.EQUALS));
        if (!StringUtils.isEmpty((CharSequence)searchKey)) {
            filter.getFilterItems().add(new FilterItemInfo("ReleasePortlet.billName", (Object)("%" + searchKey + "%"), CompareType.LIKE));
            filter.setMaskString("#0 and (#1 or #2) and #3 and #4");
        } else {
            filter.setMaskString("#0 and (#1 or #2) and #3");
        }
        evi.setFilter(filter);
        MetaDataPK query = new MetaDataPK("com.kingdee.eas.cp.odm.app.PortletReceiveMsgQuery");
        SorterItemInfo sorterItemInfo = new SorterItemInfo(orderByField);
        sorterItemInfo.setSortType(SortType.getEnum((String)orderType));
        evi.getSorter().add(sorterItemInfo);
        IQueryExecutor exec = this.getQueryExecutor((IMetaDataPK)query, evi, context);
        String sql = exec.getSQL();
        this.logger.info("executor search content  sql is:" + sql);
        System.out.println("executor search content  sql is:" + sql);
        String countSql = sql.substring(0, sql.indexOf("ORDER BY"));
        countSql = " select count(1) from ( " + countSql + " )  AAA ";
        IRowSet countRowSet = DbUtil.executeQuery((Context)context, (String)countSql);
        if (countRowSet.next()) {
            total = countRowSet.getInt(1);
            this.logger.debug("record total is\uff1a" + total);
        }
        totalPage = (total - 1) / pageSize + 1;
        this.logger.debug("total page is:" + totalPage);
        if (pageNo > totalPage) {
            pageNo = totalPage;
        }
        if (pageNo <= 0) {
            pageNo = 1;
        }
        currentPage = pageNo;
        PageList resultList = new PageList();
        resultList.setTotalRowCount(total);
        resultList.setCurrentPage(currentPage);
        resultList.setPageSize(pageSize);
        IRowSet rowSet = exec.executeQuery((pageNo - 1) * pageSize, pageSize);
        resultList = this.rowSetToPostPageList(context, resultList, rowSet);
        HashMap<String, Object> ajaxData = new HashMap<String, Object>();
        ajaxData.put("newsList", resultList);
        ajaxData.put("currentPage", currentPage);
        ajaxData.put("totalPage", totalPage);
        ajaxData.put("totalCount", total);
        String resultStr = JSONUtil.getJson4Object(ajaxData);
        return resultStr;
    }

    public PageList rowSetToPostPageList(Context ctx, PageList list, IRowSet rowSet) throws Exception {
        String isMore = this.isMoreServer(ctx, "odm");
        while (rowSet.next()) {
            if ("true".equals(isMore)) {
                this.createNewFile(ctx, "odm", rowSet.getString("ReleasePortlet.billId"));
            }
            PostDTO dto = new PostDTO();
            dto.setId(rowSet.getString("ReleasePortlet.billId"));
            dto.setTitle(rowSet.getString("DocumentInfo.title"));
            dto.setDocNumber(rowSet.getString("DocumentInfo.docNumber"));
            dto.setCreateName("");
            Date createTime = rowSet.getDate("ReleasePortlet.createTime");
            dto.setCreateTime(DateTool.dateToString((java.util.Date)createTime, (String)"yyyy-MM-dd HH:mm:ss"));
            dto.setDocOrg("");
            list.add((Object)dto);
        }
        return list;
    }

    private String getColumnType(String columnName) {
        if (null == columnName) {
            return "";
        }
        if ("\u666e\u901a".equals(columnName)) {
            return "10";
        }
        if ("\u94fe\u63a5".equals(columnName)) {
            return "20";
        }
        if ("\u7126\u70b9\u65b0\u95fb".equals(columnName)) {
            return "30";
        }
        if ("\u901a\u77e5".equals(columnName)) {
            return "40";
        }
        if ("\u9644\u4ef6".equals(columnName)) {
            return "50";
        }
        if ("\u56fe\u7247".equals(columnName)) {
            return "60";
        }
        if ("\u56fe\u7247\u65b0\u95fb".equals(columnName)) {
            return "70";
        }
        return columnName;
    }

    @Override
    public String getCollectionList(Context context, int pageNo, int pageSize) throws BOSException, SQLException {
        this.logger.debug("##############  getCollectionList in  #################");
        HashMap<String, Serializable> result = new HashMap<String, Serializable>();
        StringBuilder sql = new StringBuilder(512);
        sql.append("select * from V_CP_NewsCollection ");
        sql.append(" where COLUMNID IN (");
        sql.append(this.getCollectCol(context)).append(") ");
        sql.append(" or CFReceiverID = ");
        sql.append("'").append(ContextUtil.getCurrentUserInfo((Context)context).getPerson().getId().toString()).append("' ");
        sql.append(" order by COLLECTTIME desc ");
        this.logger.debug("sql: " + sql.toString());
        IRowSet rowSet = DbUtil.executeQuery((Context)context, (String)sql.toString());
        int count = 0;
        ArrayList resultList = new ArrayList(pageSize);
        while (rowSet.next()) {
            if ((pageNo - 1) * pageSize >= ++count || count > pageNo * pageSize) continue;
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("id", rowSet.getString("ID"));
            map.put("title", rowSet.getString("TITLE"));
            int type = rowSet.getInt("COLLECTIONTYPE");
            if (1 == type) {
                map.put("type", "1");
                String summary = rowSet.getString("SUMMARYORDOCUMENTINFO");
                if (summary != null) {
                    summary = summary.replaceAll("\n", "");
                    summary = summary.replaceAll("\r", "");
                    summary = summary.replaceAll("\t", "");
                    summary = summary.replaceAll("\"", "");
                }
                map.put("summary", summary);
                map.put("xtImgName", rowSet.getString("XTIMGNAME"));
            } else if (2 == type) {
                map.put("type", "2");
                map.put("createTime", DateTool.dateToString((java.util.Date)rowSet.getDate("CREATETIME"), (String)"yyyy-MM-dd HH:mm:ss"));
                map.put("docNumber", rowSet.getString("SUMMARYORDOCUMENTINFO"));
            }
            resultList.add(map);
        }
        result.put("list", resultList);
        result.put("cnt", Integer.valueOf(count));
        result.put("totalPage", Integer.valueOf(count % pageSize == 0 ? count / pageSize : count / pageSize + 1));
        result.put("pageNo", Integer.valueOf(pageNo));
        String resultStr = JSONUtil.getJson4Object(result);
        this.logger.debug("############## count: " + count + "  ##############");
        this.logger.debug("############## resultStr: " + resultStr + "  ##############");
        return resultStr;
    }

    private String getCollectCol(Context ctx) {
        StringBuilder sb = new StringBuilder();
        try {
            String columnIds = this.getReadColumnIDStr(ctx, "news");
            if (!StringUtil.isEmpty((String)columnIds)) {
                String[] colArr;
                for (String id : colArr = columnIds.split(",")) {
                    sb.append("'").append(id).append("',");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sb.length() == 0 ? "" : sb.substring(0, sb.length() - 1);
    }

    private boolean createNewFile(Context ctx, String type, String contentID) {
        return false;
    }

    private String isMoreServer(Context ctx, String type) {
        String isMore = "false";
        try {
            String typeName = "news".equals(type) ? "XTNews" : "XTOdm";
            XTServiceConfig xTServiceConfig = XTServiceConfig.getInstance();
            isMore = xTServiceConfig.getPubAcctProperty(xTServiceConfig.getEidByDbCode(ctx.getAIS()), typeName, "moreServer", "");
        }
        catch (Exception e) {
            e.getMessage();
        }
        return isMore;
    }

    @Override
    public String isExistIndex(Context ctx, String type, String billId) throws Exception {
        boolean flag = false;
        flag = ctx == null || StringUtils.isEmpty((CharSequence)type) || StringUtils.isEmpty((CharSequence)billId) ? false : this.createNewFile(ctx, type, billId);
        HashMap<String, String> ajaxData = new HashMap<String, String>();
        ajaxData.put("success", flag + "");
        return JSONUtil.getJson4Object(ajaxData);
    }
}

