/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.arap.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateFactory;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.IExchangeRate;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeDefaultCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeDefaultFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.IAsstActTypeDefault;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.IProfitCenterOrgUnit;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.ma.arap.BalancebillCollection;
import com.kingdee.eas.ma.arap.BalancebillException;
import com.kingdee.eas.ma.arap.BalancebillInfo;
import com.kingdee.eas.ma.arap.app.AbstractBalancebillControllerBean;
import com.kingdee.eas.ma.arap.app.ArapUtils;
import com.kingdee.eas.ma.scmcommon.tools.SQLUtils;
import com.kingdee.eas.util.app.DbUtil;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BalancebillControllerBean
extends AbstractBalancebillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.arap.app.BalancebillControllerBean");
    private static final int systemEnum = SystemEnum.PROFIT_CENTER_STORAGE.getValue();

    @Override
    protected void _batchUpdatePartial(Context ctx, BalancebillCollection col, SelectorItemCollection sic) throws BOSException, EASBizException {
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            BalancebillInfo info = col.get(i);
            this.changeInventoryBalanceInfo(ctx, info);
            super.updatePartial(ctx, (CoreBaseInfo)info, sic);
        }
    }

    @Override
    protected void _batchAddnew(Context ctx, BalancebillCollection addCol) throws BOSException, EASBizException {
        int size = addCol.size();
        for (int i = 0; i < size; ++i) {
            BalancebillInfo info = addCol.get(i);
            this.changeInventoryBalanceInfo(ctx, info);
            super.addnew(ctx, (CoreBaseInfo)info);
        }
    }

    @Override
    protected void _batchDelete(Context ctx, List deleteList) throws BOSException, EASBizException {
        StringBuilder idSB = new StringBuilder();
        int size = deleteList.size();
        for (int i = 0; i < size; ++i) {
            if (idSB.length() <= 0) {
                idSB.append("'").append(deleteList.get(i)).append("'");
                continue;
            }
            idSB.append(",'").append(deleteList.get(i)).append("'");
        }
        StringBuilder sql = new StringBuilder();
        sql.append("delete from t_cal_inventorybalance where fid in(").append(idSB.toString()).append(")");
        SQLUtils.execute((Context)ctx, (String)sql.toString());
    }

    private void changeInventoryBalanceInfo(Context ctx, BalancebillInfo info) throws BOSException, EASBizException {
        ProfitCenterOrgUnitInfo profitCenterOrg = info.getProfitCenterOrgUnit();
        CtrlUnitInfo ctrlUnit = null;
        try {
            ctrlUnit = this.getCU(ctx, profitCenterOrg);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        info.setCU(ctrlUnit);
        if (info.getBeginAmount() == null) {
            info.setBeginAmount(new BigDecimal(0));
        }
        if (info.getBeginAmountLocal() == null) {
            info.setBeginAmountLocal(new BigDecimal(0));
        }
    }

    private CtrlUnitInfo getCU(Context ctx, ProfitCenterOrgUnitInfo profitCenter) throws Exception {
        String cuid = ArapUtils.getCUID(ctx, profitCenter);
        CtrlUnitInfo ctrlUnit = new CtrlUnitInfo();
        ctrlUnit.setId(BOSUuid.read((String)cuid));
        return ctrlUnit;
    }

    @Override
    protected Map _getCacheData(Context ctx, Map map) throws BOSException, EASBizException {
        HashMap<String, Serializable> resultMap = new HashMap<String, Serializable>();
        HashMap<String, Boolean> closedMap = new HashMap<String, Boolean>();
        HashMap<String, String> asstActTypeFilterMap = new HashMap<String, String>();
        HashMap<String, CompanyOrgUnitInfo> profitCenterRelateCompany = new HashMap<String, CompanyOrgUnitInfo>();
        boolean isClosedInit = true;
        PeriodInfo[] periods = new PeriodInfo[3];
        String firstProfitCenterId2 = null;
        CompanyOrgUnitInfo companyInfo = null;
        Set set = (Set)map.get("profitCenterIds");
        ArrayList<ProfitCenterOrgUnitInfo> profitCenterList = new ArrayList<ProfitCenterOrgUnitInfo>();
        for (String firstProfitCenterId2 : set) {
            if (firstProfitCenterId2 != null) {
                boolean isStart = SystemStatusCtrolFactory.getRemoteInstance().isProfitStart(systemEnum, firstProfitCenterId2);
                if (!isStart) {
                    isClosedInit = false;
                    closedMap.put(firstProfitCenterId2, false);
                } else {
                    closedMap.put(firstProfitCenterId2, true);
                }
            }
            String companyId = ArapUtils.getRelatedCompanyId(ctx, firstProfitCenterId2);
            ProfitCenterOrgUnitInfo profitCenterInfo = this.getProfitCenter(firstProfitCenterId2, new String[]{"name"});
            profitCenterList.add(profitCenterInfo);
            if ("".equals(companyId)) {
                throw new BalancebillException(BalancebillException.BALANCEBILLPROFITNOCOMPANY, new Object[]{profitCenterInfo.getName()});
            }
            companyInfo = this.getCompanyInfoById(companyId);
            profitCenterRelateCompany.put(firstProfitCenterId2, companyInfo);
            String filter = this.getAsstActTypeFilter(ctx, companyId);
            asstActTypeFilterMap.put(firstProfitCenterId2, filter);
        }
        if (set.size() == 1) {
            periods = this.getPeriods(ctx, firstProfitCenterId2);
        }
        resultMap.put("isClosedInit", Boolean.valueOf(isClosedInit));
        if (periods[0] != null) {
            resultMap.put("startPeriod", (Serializable)periods[0]);
        }
        resultMap.put("profitClosedMap", closedMap);
        resultMap.put("profitCenterRelateCompany", profitCenterRelateCompany);
        resultMap.put("profitCenterList", profitCenterList);
        resultMap.put("asstActTypeFilterMap", asstActTypeFilterMap);
        return resultMap;
    }

    private PeriodInfo[] getPeriods(Context ctx, String profitCenterID) throws BOSException, EASBizException {
        PeriodInfo[] periods = new PeriodInfo[3];
        periods[0] = SystemStatusCtrolFactory.getRemoteInstance().getProfitStartPeriod(systemEnum, profitCenterID);
        periods[2] = SystemStatusCtrolFactory.getRemoteInstance().getProfitCurrentPeriod(systemEnum, profitCenterID);
        return periods;
    }

    public CompanyOrgUnitInfo getCompanyInfoById(String id) throws EASBizException, BOSException {
        CompanyOrgUnitInfo info = null;
        if (id != null && id.length() > 0) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("name"));
            sic.add(new SelectorItemInfo("baseCurrency.id"));
            sic.add(new SelectorItemInfo("baseCurrency.number"));
            sic.add(new SelectorItemInfo("baseCurrency.name"));
            sic.add(new SelectorItemInfo("baseCurrency.precision"));
            sic.add(new SelectorItemInfo("baseCurrency.deletedStatus"));
            sic.add(new SelectorItemInfo("baseExchangeTable.id"));
            info = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(id), sic);
        }
        return info;
    }

    private ProfitCenterOrgUnitInfo getProfitCenter(String id, String[] fields) throws EASBizException, BOSException {
        ProfitCenterOrgUnitInfo info = null;
        if (id != null && id.length() > 0) {
            SelectorItemCollection sic = new SelectorItemCollection();
            for (String field : fields) {
                sic.add(new SelectorItemInfo(field));
            }
            IProfitCenterOrgUnit iProfitCenter = ProfitCenterOrgUnitFactory.getRemoteInstance();
            info = iProfitCenter.getProfitCenterOrgUnitInfo((IObjectPK)new ObjectUuidPK(id), sic);
        }
        return info;
    }

    @Override
    protected void _closeInit(Context ctx, String[] profitCenterIds) throws BOSException, EASBizException {
        String pks = this.getSqlIDs(profitCenterIds);
        StringBuffer sql = new StringBuffer();
        sql.append("update t_Bd_Systemstatusctrol").append(" set FCurrentPeriodID = FStartPeriodID,").append(" FIsStart = 1").append(" where").append(" FProfitCenterID in (").append(pks).append(")").append(" and fsystemstatusid = (select top 1 fid from T_BD_SystemStatus where fname = '").append(systemEnum).append("')");
        SQLUtils.execute((Context)ctx, (String)sql.toString());
        Map<String, PeriodInfo> periodMap = ArapUtils.getPeriod(ctx, profitCenterIds, systemEnum);
        for (String id : profitCenterIds) {
            sql = new StringBuffer();
            PeriodInfo period = periodMap.get(id);
            sql.append("update t_map_balancebill").append(" set finitflag = 1,FPeriodID=?").append(" where FProfitCenterOrgID = ?");
            DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{period.getId().toString(), id});
        }
    }

    @Override
    protected void _cancelInit(Context ctx, String[] profitCenterIds) throws BOSException, EASBizException {
        String pks = this.getSqlIDs(profitCenterIds);
        StringBuffer sql = new StringBuffer();
        sql.append("update t_Bd_Systemstatusctrol").append(" set ").append(" FIsStart = 0").append(" where").append(" FProfitCenterID in (").append(pks).append(")").append(" and fsystemstatusid = (select top 1 fid from T_BD_SystemStatus where fname = '").append(systemEnum).append("')");
        SQLUtils.execute((Context)ctx, (String)sql.toString());
        sql = new StringBuffer();
        sql.append("update t_map_balancebill").append(" set finitflag = 0").append(" where FProfitCenterOrgID in (").append(pks).append(")");
        SQLUtils.execute((Context)ctx, (String)sql.toString());
    }

    private String getSqlIDs(String[] pks) {
        StringBuilder sb = new StringBuilder();
        if (pks == null || "".equals(pks)) {
            return "";
        }
        for (String pk : pks) {
            if (sb.length() > 0) {
                sb.append(",'").append(pk).append("'");
                continue;
            }
            sb.append("'").append(pk).append("'");
        }
        return sb.toString();
    }

    private String getAsstActTypeFilter(Context ctx, String companyId) throws EASBizException, BOSException {
        AsstActTypeDefaultCollection defaultCollection = this.getDefaultAsstActTypeCol(ctx, companyId);
        HashSet<String> set = new HashSet<String>();
        AsstActTypeInfo asstActTypeInfo = null;
        for (int i = 0; i < defaultCollection.size(); ++i) {
            asstActTypeInfo = defaultCollection.get(i).getAsstActType();
            set.add(asstActTypeInfo.getId().toString());
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
        return filter.toString();
    }

    private AsstActTypeDefaultCollection getDefaultAsstActTypeCol(Context ctx, String companyID) throws EASBizException, BOSException {
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem1 = new FilterItemInfo("isAccountCussent", (Object)Boolean.TRUE);
        FilterItemInfo filterItem2 = new FilterItemInfo("company.id", (Object)companyID);
        filter.getFilterItems().add(filterItem1);
        filter.getFilterItems().add(filterItem2);
        ev.getSelector().add("*");
        ev.getSelector().add("asstActType.*");
        ev.setFilter(filter);
        IAsstActTypeDefault iAsstActType = AsstActTypeDefaultFactory.getLocalInstance((Context)ctx);
        AsstActTypeDefaultCollection asstActTypeColl = iAsstActType.getAsstActTypeDefaultCollection(ev);
        return asstActTypeColl;
    }

    @Override
    protected Map _getExchangeRate(Context ctx, String profitCenterID, String companyID, String currencyID) throws EASBizException, BOSException {
        CompanyOrgUnitInfo company = this.getCompanyInfoById(companyID);
        CurrencyInfo currency = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyID));
        String baseExchangeTableID = company.getBaseExchangeTable().getId().toString();
        String baseCurrencyID = "";
        if (company.getBaseCurrency() != null) {
            baseCurrencyID = company.getBaseCurrency().getId().toString();
        }
        IExchangeRate iexchangRate = ExchangeRateFactory.getLocalInstance((Context)ctx);
        ExchangeRateInfo exgRateInfo = iexchangRate.getExchangeRate((IObjectPK)new ObjectUuidPK(baseExchangeTableID), (IObjectPK)new ObjectUuidPK(currencyID), (IObjectPK)new ObjectUuidPK(baseCurrencyID), null);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("exchangeRateInfo", exgRateInfo);
        int exchangeprecision = currency.getPrecision();
        if (exgRateInfo != null) {
            exchangeprecision = exgRateInfo.getPrecision();
            if (exgRateInfo.getExchangeAux() != null) {
                exchangeprecision = exgRateInfo.getExchangeAux().getPrecision();
            }
        }
        result.put("precision", currency.getPrecision());
        result.put("exchangeprecision", exchangeprecision);
        boolean isDirectExchange = true;
        if (exgRateInfo != null && exgRateInfo.getExchangeAux() != null && exgRateInfo.getExchangeAux().getConvertMode().getValue() == 1) {
            isDirectExchange = false;
        }
        result.put("isDirectExchange", isDirectExchange);
        return result;
    }
}

