/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.arap.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.batch.BatchExecuteParamsEntry;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateFactory;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.IExchangeRate;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeDefaultCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeDefaultFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeDefaultInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.IAsstActTypeDefault;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.ma.arap.BillStatusEnum;
import com.kingdee.eas.ma.arap.BizRelatedBillCollection;
import com.kingdee.eas.ma.arap.BizRelatedBillEntryCollection;
import com.kingdee.eas.ma.arap.BizRelatedBillEntryInfo;
import com.kingdee.eas.ma.arap.BizRelatedBillException;
import com.kingdee.eas.ma.arap.BizRelatedBillFactory;
import com.kingdee.eas.ma.arap.BizRelatedBillInfo;
import com.kingdee.eas.ma.arap.IBizRelatedBill;
import com.kingdee.eas.ma.arap.SettlementTypeEnum;
import com.kingdee.eas.ma.arap.app.AbstractBizRelatedBillControllerBean;
import com.kingdee.eas.ma.arap.app.ArapUtils;
import com.kingdee.eas.ma.cal.app.CalUtils;
import com.kingdee.eas.ma.scmcommon.tools.SQLUtils;
import com.kingdee.eas.ma.scmcommon.tools.Utils;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jfree.util.Log;

public class BizRelatedBillControllerBean
extends AbstractBizRelatedBillControllerBean {
    private static final String OPERATESTATE = "operateState";
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.arap.app.BizRelatedBillControllerBean");

    @Override
    protected Map _getAllParam(Context ctx, String profitCenterId, String operateState) throws BOSException, EASBizException {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put(OPERATESTATE, operateState);
        this.setDefaultProfitCenter(ctx, profitCenterId, param);
        return param;
    }

    @Override
    protected BizRelatedBillInfo _createNewModel(Context ctx, String profitCenterId, String operate, String billId) throws BOSException, EASBizException {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put(OPERATESTATE, operate);
        this.setDefaultProfitCenter(ctx, profitCenterId, param);
        BizRelatedBillInfo info = null;
        UserInfo userinfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
        if (operate == null || "ADDNEW".equals(operate)) {
            CompanyOrgUnitInfo addNewDefaultcompany = (CompanyOrgUnitInfo)param.get("company");
            ProfitCenterOrgUnitInfo profitCenterInfo = (ProfitCenterOrgUnitInfo)param.get("profitCenter");
            info = new BizRelatedBillInfo();
            info.setId(BOSUuid.create((BOSObjectType)info.getBOSType()));
            info.setBizDate(new Date());
            info.setProfitCenterOrg(profitCenterInfo);
            if (addNewDefaultcompany != null) {
                info.setCompanyOrgUnit(addNewDefaultcompany);
                info.setCurrency(addNewDefaultcompany.getBaseCurrency());
            }
            info.setCreator(userinfo);
            info.setCreateTime(new Timestamp(System.currentTimeMillis()));
            info.setStatus(BillStatusEnum.Saved);
            info.setExchangeRate(this.getExchangeRate(addNewDefaultcompany, addNewDefaultcompany.getBaseCurrency()));
            info.setSettlementType(SettlementTypeEnum.AR);
            info.setAsstActType(this.getAsstActType(ctx, addNewDefaultcompany, SystemEnum.ACCOUNTSRECEIVABLE));
            this.setNumberAddNew(ctx, info);
        }
        return info;
    }

    @Override
    protected Map _getCacheData(Context ctx, BizRelatedBillInfo info) throws BOSException, EASBizException {
        HashMap<String, Object> cacheMap = new HashMap<String, Object>();
        CompanyOrgUnitInfo company = info.getCompanyOrgUnit();
        HashSet<String> set = new HashSet<String>();
        AsstActTypeCollection col = this.getAsstActTypeCol(this.getDefaultAsstActTypeCol(ctx, company));
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            set.add(col.get(i).getId().toString());
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
        cacheMap.put("asstActTypeFilter", filter.toString());
        CurrencyInfo baseCurrencyInfo = company.getBaseCurrency();
        if (baseCurrencyInfo == null) {
            company = this.getCompanyInfoById(company.getId().toString());
            baseCurrencyInfo = company.getBaseCurrency();
        }
        if (baseCurrencyInfo != null && baseCurrencyInfo.getPrecision() == 0) {
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("id"));
            selector.add(new SelectorItemInfo("number"));
            selector.add(new SelectorItemInfo("name"));
            selector.add(new SelectorItemInfo("precision"));
            baseCurrencyInfo = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(baseCurrencyInfo.getId().toString()), selector);
            company.setBaseCurrency(baseCurrencyInfo);
        }
        cacheMap.put("baseCurrency", baseCurrencyInfo);
        BizRelatedBillEntryCollection entryCol = info.getEntry();
        ArrayList idsList = new ArrayList();
        Object entryInfo = null;
        for (int i = 0; i < entryCol.size(); ++i) {
            ArrayList<String> ll = new ArrayList<String>();
            if (entryCol.get(i).getMaterial() == null || entryCol.get(i).getUnit() == null) continue;
            ll.add(entryCol.get(i).getMaterial().getId().toString());
            ll.add(entryCol.get(i).getUnit().getId().toString());
            idsList.add(ll);
        }
        Map precisionsMap = super.getMaterialMmuPrecisions(ctx, idsList);
        cacheMap.put("MmuPrecisions", precisionsMap);
        String excTableid = "";
        if (company != null && company.getBaseExchangeTable() != null) {
            excTableid = company.getBaseExchangeTable().getId().toString();
        } else {
            company = this.getCompanyInfoById(company.getId().toString());
            excTableid = company.getBaseExchangeTable().getId().toString();
        }
        String currencyId = "";
        if (info.getCurrency() != null) {
            currencyId = info.getCurrency().getId().toString();
        }
        String bizDate = "";
        if (info.getBizDate() != null) {
            SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            bizDate = sf.format(info.getBizDate());
        }
        Map exchangeMap = super.getExchange(ctx, excTableid, baseCurrencyInfo.getId().toString(), currencyId, bizDate);
        cacheMap.put("exchangeData", exchangeMap);
        cacheMap.put("company", company);
        return cacheMap;
    }

    protected void setDefaultProfitCenter(Context ctx, String profitCenterId, Map<String, Object> param) throws BOSException, EASBizException {
        logger.info((Object)("setDefaultProfitCenter:profitCenterId\u4e3a" + profitCenterId));
        String companyId = CalUtils.getRelatedCompanyId((Context)ctx, (String)profitCenterId);
        ProfitCenterOrgUnitInfo profitCenterInfo = ProfitCenterOrgUnitFactory.getLocalInstance((Context)ctx).getProfitCenterOrgUnitInfo((IObjectPK)new ObjectUuidPK(profitCenterId), CalUtils.getProfitCenterSic());
        if (companyId == null || "".equals(companyId)) {
            throw new BizRelatedBillException(BizRelatedBillException.NOCOMPANYORGUNIT, new Object[]{profitCenterInfo.getName()});
        }
        param.put("profitCenter", profitCenterInfo);
        logger.info((Object)("profitCenterId\u5bf9\u5e94\u7684CompanyId\u4e3a" + companyId));
        if (companyId != null && !"".equals(companyId)) {
            this.setDefaultCompany(ctx, companyId, param);
        }
    }

    protected void setDefaultCompany(Context ctx, String companyId, Map<String, Object> param) throws BOSException, EASBizException {
        String operateState = (String)param.get(OPERATESTATE);
        String permItem = "cas_paymentbill_01view";
        if (operateState != null && operateState.equals("ADDNEW")) {
            permItem = "cas_paymentbill_02addNew";
        }
        CompanyOrgUnitInfo company = null;
        company = this.getCompanyInfoById(companyId);
        param.put("company", company);
        UserInfo userinfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
        param.put("userInfo", userinfo);
    }

    private BigDecimal getExchangeRate(CompanyOrgUnitInfo company, CurrencyInfo currency) throws EASBizException, BOSException {
        boolean isLocalCurrency = currency.equals((Object)company.getBaseCurrency());
        BigDecimal rate = null;
        rate = isLocalCurrency ? new BigDecimal(1.0) : Utils.getExchangeRate((CompanyOrgUnitInfo)company, (CurrencyInfo)currency, (Date)Calendar.getInstance().getTime()).getConvertRate();
        return rate;
    }

    private AsstActTypeCollection getAsstActTypeCol(AsstActTypeDefaultCollection defaultCollection) throws EASBizException, BOSException {
        AsstActTypeCollection asstActTypeCol = new AsstActTypeCollection();
        AsstActTypeInfo asstActTypeInfo = null;
        for (int i = 0; i < defaultCollection.size(); ++i) {
            asstActTypeInfo = defaultCollection.get(i).getAsstActType();
            asstActTypeCol.add(asstActTypeInfo);
        }
        return asstActTypeCol;
    }

    private AsstActTypeDefaultCollection getDefaultAsstActTypeCol(Context ctx, CompanyOrgUnitInfo company) throws EASBizException, BOSException {
        if (company == null) {
            throw new IllegalAccessError();
        }
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem1 = new FilterItemInfo("isAccountCussent", (Object)Boolean.TRUE);
        FilterItemInfo filterItem2 = new FilterItemInfo("company.id", (Object)company.getId());
        filter.getFilterItems().add(filterItem1);
        filter.getFilterItems().add(filterItem2);
        ev.getSelector().add("*");
        ev.getSelector().add("asstActType.*");
        ev.setFilter(filter);
        IAsstActTypeDefault iAsstActType = AsstActTypeDefaultFactory.getLocalInstance((Context)ctx);
        AsstActTypeDefaultCollection asstActTypeColl = iAsstActType.getAsstActTypeDefaultCollection(ev);
        return asstActTypeColl;
    }

    public AsstActTypeInfo getAsstActType(Context ctx, CompanyOrgUnitInfo cachedCompany, SystemEnum defaultSysEnum) throws BOSException {
        if (cachedCompany == null) {
            throw new IllegalAccessError();
        }
        AsstActTypeInfo defaulteAsstActType = null;
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem1 = new FilterItemInfo("isAccountCussent", (Object)Boolean.TRUE);
        FilterItemInfo filterItem2 = new FilterItemInfo("company.id", (Object)cachedCompany.getId());
        filter.getFilterItems().add(filterItem1);
        filter.getFilterItems().add(filterItem2);
        ev.getSelector().add("*");
        ev.getSelector().add("asstActType.*");
        ev.setFilter(filter);
        AsstActTypeDefaultCollection asstActTypeColl = AsstActTypeDefaultFactory.getLocalInstance((Context)ctx).getAsstActTypeDefaultCollection(ev);
        AsstActTypeDefaultInfo value = null;
        int size = asstActTypeColl.size();
        for (int i = 0; i < size; ++i) {
            value = asstActTypeColl.get(i);
            if (SystemEnum.ACCOUNTSPAYABLE.equals((Object)defaultSysEnum) && value.isIsDefaultAccountPayable()) {
                defaulteAsstActType = value.getAsstActType();
                continue;
            }
            if (!SystemEnum.ACCOUNTSRECEIVABLE.equals((Object)defaultSysEnum) || !value.isIsDefaultAccountReceivable()) continue;
            defaulteAsstActType = value.getAsstActType();
        }
        return defaulteAsstActType;
    }

    @Override
    protected Map _getMaterialMmuPrecisions(Context ctx, List ids) throws BOSException, EASBizException {
        return Utils.getMaterialMmuPrecisions((Context)ctx, (List)ids);
    }

    @Override
    protected Map _getExchange(Context ctx, String excTableid, String baseCurrencyId, String currencyid, String billDate) throws BOSException, EASBizException {
        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Log.info((Object)("BizRelatedBillControllerBean._getExchange:425 \u65e5\u671f - " + billDate));
        Date bizDate = null;
        try {
            bizDate = sf.parse(billDate);
        }
        catch (ParseException e) {
            throw new BOSException((Throwable)e);
        }
        IExchangeRate iexchangRate = ExchangeRateFactory.getLocalInstance((Context)ctx);
        ObjectUuidPK excTablepk = new ObjectUuidPK(excTableid);
        ObjectUuidPK sourceCurrpk = new ObjectUuidPK(currencyid);
        ObjectUuidPK destCurrpk = new ObjectUuidPK(baseCurrencyId);
        ExchangeRateInfo exgRateInfo = iexchangRate.getExchangeRate((IObjectPK)excTablepk, (IObjectPK)sourceCurrpk, (IObjectPK)destCurrpk, bizDate);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("exchangeRateInfo", exgRateInfo);
        CurrencyInfo currency = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyid));
        int exchangeprecision = currency.getPrecision();
        if (exgRateInfo != null) {
            exchangeprecision = exgRateInfo.getPrecision();
            if (exgRateInfo.getExchangeAux() != null) {
                exchangeprecision = exgRateInfo.getExchangeAux().getPrecision();
            }
        }
        result.put("precision", currency.getPrecision());
        result.put("exchangePrecision", exchangeprecision);
        boolean isDirectExchange = true;
        if (exgRateInfo != null && exgRateInfo.getExchangeAux() != null && exgRateInfo.getExchangeAux().getConvertMode().getValue() == 1) {
            isDirectExchange = false;
        }
        result.put("isDirectExchange", isDirectExchange);
        return result;
    }

    public CompanyOrgUnitInfo getCompanyInfoById(String id) throws EASBizException, BOSException {
        CompanyOrgUnitInfo info = null;
        if (id != null && id.length() > 0) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("name"));
            sic.add(new SelectorItemInfo("baseExchangeTable.id"));
            sic.add(new SelectorItemInfo("accountTable.id"));
            sic.add(new SelectorItemInfo("CU.longNumber"));
            sic.add(new SelectorItemInfo("baseCurrency.id"));
            sic.add(new SelectorItemInfo("baseCurrency.number"));
            sic.add(new SelectorItemInfo("baseCurrency.name"));
            sic.add(new SelectorItemInfo("baseCurrency.precision"));
            sic.add(new SelectorItemInfo("baseCurrency.deletedStatus"));
            info = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(id), sic);
        }
        return info;
    }

    private void setNumberAddNew(Context ctx, BizRelatedBillInfo bizRelatedBillInfo) throws EASBizException, BOSException {
        try {
            ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
            boolean isNumberAddNew = iCodingRuleManager.isAddView((IObjectValue)bizRelatedBillInfo, bizRelatedBillInfo.getProfitCenterOrg().getId().toString(), "status");
            if (isNumberAddNew) {
                String number = iCodingRuleManager.readNumber((IObjectValue)bizRelatedBillInfo, bizRelatedBillInfo.getProfitCenterOrg().getId().toString(), "status", "");
                bizRelatedBillInfo.setNumber(number);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"codingRule error!", (Throwable)ex);
        }
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        BizRelatedBillInfo info = (BizRelatedBillInfo)model;
        this.beforeSubmitAndSave(info);
        info.setStatus(BillStatusEnum.Submited);
        if (info.getEntry() == null || info.getEntry().size() == 0) {
            throw new BizRelatedBillException(BizRelatedBillException.BILL_ENTRY_CANNOT_EMPTY);
        }
        return super._submit(ctx, (IObjectValue)info);
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        BizRelatedBillInfo info = (BizRelatedBillInfo)model;
        this.beforeSubmitAndSave(info);
        StringBuffer sql = new StringBuffer();
        sql.append("select fid from T_MAP_BizRelatedBill where fnumber='").append(info.getNumber()).append("'").append(" and fid<>'").append(info.getId().toString()).append("'");
        IRowSet rowset = SQLUtils.executeQuery((Context)ctx, (String)sql.toString());
        try {
            if (rowset.next()) {
                throw new BizRelatedBillException(BizRelatedBillException.BILLNUMBER_EXISTED);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (info.getEntry() == null || info.getEntry().size() == 0) {
            throw new BizRelatedBillException(BizRelatedBillException.BILL_ENTRY_CANNOT_EMPTY);
        }
        return super._save(ctx, (IObjectValue)info);
    }

    private void beforeSubmitAndSave(BizRelatedBillInfo info) {
        int size = info.getEntry().size();
        for (int j = size - 1; j >= 0; --j) {
            BizRelatedBillEntryInfo entry = info.getEntry().get(j);
            if (entry.getMaterial() != null || entry.getExpenseItem() != null) continue;
            info.getEntry().removeObject(j);
        }
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.batchDelete(ctx, Utils.buildBatchParam((Context)ctx, (IObjectPK)pk));
    }

    @Override
    protected void _submit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.batchSubmit(ctx, Utils.buildBatchParam((Context)ctx, (IObjectPK)pk));
    }

    @Override
    protected void _audit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.batchAudit(ctx, Utils.buildBatchParam((Context)ctx, (IObjectPK)pk));
    }

    @Override
    protected void _unaudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.batchUnaudit(ctx, Utils.buildBatchParam((Context)ctx, (IObjectPK)pk));
    }

    public BatchActionResults batchDelete(Context ctx, BatchExecuteParamsEntry[] params) throws BOSException, EASBizException {
        String pks = this.structurePKCol(params);
        StringBuffer sql = new StringBuffer();
        sql.append("select fid from T_MAP_BizRelatedBill where fstatus=30 and fid in").append(pks);
        IRowSet rs = SQLUtils.executeQuery((Context)ctx, (String)sql.toString());
        BatchActionResults actionResults = BatchActionResults.populateActionResults((BatchExecuteParamsEntry[])params);
        try {
            while (rs.next()) {
                actionResults.addError(rs.getString("fid"), new BizRelatedBillException(BizRelatedBillException.BILLISAUDITED).getMessage());
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        sql.setLength(0);
        sql.append(" delete from T_MAP_BizRelatedBill ");
        sql.append(" where FID in ").append(pks);
        sql.append(" and fstatus<>30");
        SQLUtils.execute((Context)ctx, (String)sql.toString());
        return actionResults;
    }

    public BatchActionResults batchSubmit(Context ctx, BatchExecuteParamsEntry[] params) throws BOSException, EASBizException {
        String pks = this.structurePKCol(params);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id in " + pks));
        EntityViewInfo entityView = new EntityViewInfo();
        entityView.setFilter(filter);
        entityView.getSelector().add(new SelectorItemInfo("*"));
        entityView.getSelector().add(new SelectorItemInfo("entry.*"));
        entityView.getSelector().add(new SelectorItemInfo("entry.material.*"));
        IBizRelatedBill iBizRelatedBill = BizRelatedBillFactory.getLocalInstance(ctx);
        BizRelatedBillCollection col = iBizRelatedBill.getBizRelatedBillCollection(entityView);
        BatchActionResults actionResults = BatchActionResults.populateActionResults((BatchExecuteParamsEntry[])params);
        HashSet<String> idSet = new HashSet<String>();
        for (int i = 0; i < col.size(); ++i) {
            BizRelatedBillInfo info = col.get(i);
            if (this.checkBizRelatedBillInfoForSubmit(ctx, info, actionResults)) continue;
            idSet.add(info.getId().toString());
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" update T_MAP_BizRelatedBill ").append(" set fstatus=20").append(" where FID in ").append(pks).append(" and fstatus<=20");
        if (idSet.size() > 0) {
            sql.append(" and fid not in (").append(ArapUtils.getSqlIDs(idSet)).append(")");
        }
        SQLUtils.execute((Context)ctx, (String)sql.toString());
        return actionResults;
    }

    public BatchActionResults batchAudit(Context ctx, BatchExecuteParamsEntry[] params) throws BOSException, EASBizException {
        String pks = this.structurePKCol(params);
        StringBuffer sql = new StringBuffer();
        sql.append("select fid from T_MAP_BizRelatedBill where fstatus<>20 and fid in").append(pks);
        IRowSet rs = SQLUtils.executeQuery((Context)ctx, (String)sql.toString());
        BatchActionResults actionResults = BatchActionResults.populateActionResults((BatchExecuteParamsEntry[])params);
        try {
            while (rs.next()) {
                actionResults.addError(rs.getString("fid"), new BizRelatedBillException(BizRelatedBillException.SAVINGORAUDITEDNOTAUDIT).getMessage());
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        sql.setLength(0);
        sql.append(" update T_MAP_BizRelatedBill ");
        sql.append(" set fstatus=30 ");
        sql.append(" ,fauditorid='").append(this.getUserID(ctx)).append("'");
        sql.append(" ,fbizDate = now() ");
        sql.append(" where FID in ").append(pks);
        sql.append(" and fstatus=20");
        SQLUtils.execute((Context)ctx, (String)sql.toString());
        System.out.println("success");
        return actionResults;
    }

    public BatchActionResults batchUnaudit(Context ctx, BatchExecuteParamsEntry[] params) throws BOSException, EASBizException {
        String pks = this.structurePKCol(params);
        StringBuffer sql = new StringBuffer();
        sql.append("select fid from T_MAP_BizRelatedBill where fstatus<>30 and fid in").append(pks);
        IRowSet rs = SQLUtils.executeQuery((Context)ctx, (String)sql.toString());
        BatchActionResults actionResults = BatchActionResults.populateActionResults((BatchExecuteParamsEntry[])params);
        try {
            while (rs.next()) {
                actionResults.addError(rs.getString("fid"), new BizRelatedBillException(BizRelatedBillException.SAVINGORSUBMITNOTUNAUDIT).getMessage());
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        sql.setLength(0);
        sql.append(" update T_MAP_BizRelatedBill ");
        sql.append(" set fstatus=10");
        sql.append(" where FID in ").append(pks);
        sql.append(" and fstatus=30");
        SQLUtils.execute((Context)ctx, (String)sql.toString());
        return actionResults;
    }

    private String structurePKCol(BatchExecuteParamsEntry[] params) {
        StringBuffer pks = new StringBuffer();
        int size = params.length;
        for (int i = 0; i < size; ++i) {
            if (i == 0) {
                pks.append("('").append(params[i].get(0)).append("'");
                continue;
            }
            pks.append(",'").append(params[i].get(0)).append("'");
        }
        pks.append(")");
        return pks.toString();
    }

    private String getUserID(Context ctx) {
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        String userId = userInfo.getId().toString();
        return userId;
    }

    protected boolean checkBizRelatedBillInfoForSubmit(Context ctx, BizRelatedBillInfo info, BatchActionResults result) throws BOSException, EASBizException {
        if (!info.getStatus().equals((Object)BillStatusEnum.Saved) && !info.getStatus().equals((Object)BillStatusEnum.Submited)) {
            result.addError(info.getId().toString(), new BizRelatedBillException(BizRelatedBillException.SAVINGORSUBMITCANSUBMIT).getMessage());
            return false;
        }
        BizRelatedBillEntryCollection entryCol = info.getEntry();
        for (int j = 0; j < entryCol.size(); ++j) {
            BizRelatedBillEntryInfo entryInfo = entryCol.get(j);
            if (entryInfo.getAmount().doubleValue() != 0.0) continue;
            result.addError(info.getId().toString(), new BizRelatedBillException(BizRelatedBillException.ENTRYAMOUNTEQUALZERO).getMessage());
            return false;
        }
        return true;
    }
}

