/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.arap.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrol;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.ma.arap.BizCloseAccountException;
import com.kingdee.eas.ma.arap.app.ArapUtils;
import com.kingdee.eas.ma.scmcommon.tools.BizCommand;
import com.kingdee.eas.ma.scmcommon.tools.SQLUtils;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class CloseAccountService
extends BizCommand {
    public static final String NEWLINE = "\r\n";

    public CloseAccountService(Context ctx) {
        super(ctx);
    }

    protected Object doing(Object profitCenterId) throws BOSException, EASBizException {
        this.closeAccount(profitCenterId.toString());
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeAccount(String profitCenterId) throws BOSException, EASBizException {
        Map prams = this.getSystemParams(profitCenterId);
        PeriodInfo curPeriodInfo = (PeriodInfo)prams.get("period");
        PeriodInfo nextPeriodInfo = (PeriodInfo)prams.get("nextPeriod");
        PeriodInfo prePeriodInfo = PeriodUtils.getPrePeriodInfo((Context)this.ctx, (PeriodInfo)curPeriodInfo);
        PeriodInfo startPeriodInfo = (PeriodInfo)prams.get("startPeriodInfo");
        boolean isStartPeriod = false;
        boolean isSameYear = false;
        if (curPeriodInfo.getId().equals((Object)startPeriodInfo.getId())) {
            isStartPeriod = true;
        }
        if (curPeriodInfo.getPeriodYear() == prePeriodInfo.getPeriodYear()) {
            isSameYear = true;
        }
        String tmpTableName = null;
        String tmpTableName2 = null;
        try {
            tmpTableName = this.createTmpTable();
            tmpTableName2 = this.createTmpTable();
            String insertsql = this.getInsertDataSQL(tmpTableName, isStartPeriod);
            this.insertBalanceData(tmpTableName, insertsql, profitCenterId, prePeriodInfo, curPeriodInfo, isStartPeriod, isSameYear);
            this.insertBillData(tmpTableName, insertsql, profitCenterId, curPeriodInfo, isStartPeriod);
            this.insertCurPeriodData(insertsql, tmpTableName, tmpTableName2);
            if (isStartPeriod) {
                this.updateBalanceData(tmpTableName2, startPeriodInfo, profitCenterId);
                this.insertBalanceData4Start(tmpTableName2, startPeriodInfo);
            } else {
                this.deleteBalanceData(curPeriodInfo, profitCenterId);
                this.insertBalanceData(tmpTableName2);
            }
            this.insertNextBalanceData(tmpTableName2, nextPeriodInfo);
        }
        finally {
            if (tmpTableName != null) {
                this.releasTempTable(tmpTableName);
            }
            if (tmpTableName2 != null) {
                this.releasTempTable(tmpTableName);
            }
        }
        ProfitCenterOrgUnitInfo orgInfo = ProfitCenterOrgUnitFactory.getLocalInstance((Context)this.ctx).getProfitCenterOrgUnitInfo((IObjectPK)new ObjectUuidPK(profitCenterId));
        boolean isAdjustPeriod = Boolean.parseBoolean(prams.get("isAdjustPeriod").toString());
        this.updatePeriod(true, (OrgUnitInfo)orgInfo, isAdjustPeriod);
    }

    private String createTmpTable() throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" create TABLE TEML_KSQL_0 ( ");
        sql.append(" KSQL_SEQ int identity(1,1) NOT NULL ,");
        sql.append(" FPeriodID varchar(44),");
        sql.append(" fbalanceid varchar(44),");
        sql.append(" FProfitCenterID varchar(44),");
        sql.append(" FCompanyOrgUnitID varchar(44),");
        sql.append(" FCurrencyID varchar(44),");
        sql.append(" FAsstActTypeID varchar(44),");
        sql.append(" FAsstActID varchar(44),");
        sql.append(" FAsstActName_l2 NVARCHAR(80),");
        sql.append(" FSettlementType INT,");
        sql.append(" FAdminOrgUnitID varchar(44),");
        sql.append(" FPersonID varchar(44),");
        sql.append(" FAccountID varchar(44),");
        sql.append(" FcontrolUnitid varchar(44),");
        sql.append(" FBeginAmount  numeric(28, 10) DEFAULT 0,");
        sql.append(" FBeginAmountLocal numeric(28, 10) DEFAULT 0,");
        sql.append(" FArAmount numeric(28, 10) DEFAULT 0,");
        sql.append(" FArAmountLocal numeric(28, 10) DEFAULT 0,");
        sql.append(" FApAmount numeric(28, 10) DEFAULT 0,");
        sql.append(" FApAmountLocal numeric(28, 10) DEFAULT 0,");
        sql.append(" FAmount numeric(28, 10) DEFAULT 0,");
        sql.append(" FAmountLocal numeric(28, 10) DEFAULT 0");
        sql.append(")");
        String tempTable = null;
        TempTablePool pool = TempTablePool.getInstance((Context)this.ctx);
        try {
            tempTable = pool.createTempTable(sql.toString());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return tempTable;
    }

    private String getInsertDataSQL(String detailTableName, boolean isStartPeriod) {
        StringBuffer sSQL = new StringBuffer();
        sSQL.append(" FPeriodID,FProfitCenterID,FCompanyOrgUnitID,FCurrencyID,FAsstActTypeID,FAsstActID,FAsstActName_l2,").append(NEWLINE);
        sSQL.append(" FSettlementType,FAdminOrgUnitID,FPersonID,FAccountID,").append(NEWLINE);
        sSQL.append(" FcontrolUnitid,").append(NEWLINE);
        sSQL.append(" FBeginAmount,FBeginAmountLocal,FArAmount,FArAmountLocal,FApAmount,FApAmountLocal,").append(NEWLINE);
        sSQL.append(" FAmount,FAmountLocal");
        return sSQL.toString();
    }

    private Map getSystemParams(String profitCenterId) throws EASBizException, BOSException {
        int precision;
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        PeriodInfo curPeriodInfo = null;
        PeriodInfo nextPeriodInfo = null;
        PeriodInfo startPeriodInfo = null;
        ISystemStatusCtrol iSystemStatusCtrol = SystemStatusCtrolFactory.getLocalInstance((Context)this.ctx);
        curPeriodInfo = iSystemStatusCtrol.getProfitCurrentPeriod(1007, profitCenterId);
        startPeriodInfo = iSystemStatusCtrol.getProfitStartPeriod(1007, profitCenterId);
        if (curPeriodInfo == null) {
            throw new BizCloseAccountException(BizCloseAccountException.NOTSTARTPERIOD);
        }
        nextPeriodInfo = PeriodUtils.getNextPeriodInfo((Context)this.ctx, (PeriodInfo)curPeriodInfo);
        String isAdjustPeriod = "false";
        if (nextPeriodInfo.isIsAdjustPeriod()) {
            nextPeriodInfo = PeriodUtils.getNextPeriodInfo((Context)this.ctx, (PeriodInfo)nextPeriodInfo);
            isAdjustPeriod = "true";
        }
        if (nextPeriodInfo.getId() == null) {
            throw new BizCloseAccountException(BizCloseAccountException.NEXTPERIODISNULL);
        }
        paramMap.put("period", curPeriodInfo);
        paramMap.put("nextPeriod", nextPeriodInfo);
        paramMap.put("startPeriodInfo", startPeriodInfo);
        String companyid = ArapUtils.getRelatedCompanyId(this.ctx, profitCenterId);
        CompanyOrgUnitInfo companyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)this.ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyid));
        if (companyInfo.getBaseCurrency().getId() == null) {
            precision = 2;
        } else {
            ICurrency ic = CurrencyFactory.getLocalInstance((Context)this.ctx);
            CurrencyInfo ci = ic.getCurrencyInfo((IObjectPK)new ObjectUuidPK(companyInfo.getBaseCurrency().getId()), CloseAccountService.getCurrencySelector());
            precision = ci.getPrecision();
        }
        paramMap.put("precision", new Integer(precision));
        paramMap.put("companyOrgUnitID", companyInfo.getId().toString());
        paramMap.put("isAdjustPeriod", isAdjustPeriod);
        return paramMap;
    }

    public static SelectorItemCollection getCurrencySelector() {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("sign"));
        selector.add(new SelectorItemInfo("baseUnit"));
        selector.add(new SelectorItemInfo("precision"));
        selector.add(new SelectorItemInfo("deletedStatus"));
        return selector;
    }

    private void insertBalanceData(String detailTableName, String insertsql, String profitCenterId, PeriodInfo prePeriodInfo, PeriodInfo curPeriodInfo, boolean isStartPeriod, boolean isSameYear) throws EASBizException, BOSException {
        String periodID = curPeriodInfo.getId().toString();
        String prePeriodID = prePeriodInfo.getId().toString();
        StringBuffer sql = new StringBuffer();
        sql.append(" Insert  ").append(detailTableName).append("(");
        sql.append(insertsql).append(")");
        sql.append(" ( select FPeriodID,FProfitCenterOrgID,FCompanyOrgUnitID,FCurrencyID,FAsstActTypeID,FAsstActID,FAsstActName_l2,");
        sql.append(" FSettlementType,FAdminOrgUnitID,FPersonID,FAccountID,");
        sql.append(" FcontrolUnitid,");
        if (isStartPeriod) {
            sql.append(" FBeginAmount as FBeginAmount,FBeginAmountLocal as FBeginAmountLocal,0 as FArAmount ,0 as FArAmountLocal,");
            sql.append(" 0 as FApAmount,0 as FApAmountLocal,0 as FAmount,0 as FAmountLocal");
        } else {
            sql.append(" FAmount as FBeginAmount,FAmountLocal as FBeginAmountLocal,0 as FArAmount ,0 as FArAmountLocal,");
            sql.append(" 0 as FApAmount,0 as FApAmountLocal,0 as FAmount,0 as FAmountLocal");
        }
        sql.append(" from T_MAP_BALANCEBILL  ");
        sql.append("  where FProfitCenterOrgID = ? and FPeriodID = ? ");
        sql.append("  )");
        if (isStartPeriod) {
            SQLUtils.execute((Context)this.ctx, (String)sql.toString(), (Object[])new Object[]{profitCenterId, periodID});
        } else {
            SQLUtils.execute((Context)this.ctx, (String)sql.toString(), (Object[])new Object[]{profitCenterId, prePeriodID});
        }
    }

    private void insertBillData(String detailTableName, String insertsql, String profitCenterId, PeriodInfo curPeriodInfo, boolean isStartPeriod) throws EASBizException, BOSException {
        Date beginData = curPeriodInfo.getBeginDate();
        Date endData = ArapUtils.getDate(curPeriodInfo.getEndDate(), 1);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        int year = curPeriodInfo.getPeriodYear();
        int periodNumber = curPeriodInfo.getPeriodNumber();
        String periodID = curPeriodInfo.getId().toString();
        StringBuffer sql = new StringBuffer();
        sql.append(" Insert  ").append(detailTableName).append("(");
        sql.append(insertsql).append(")");
        sql.append(" ( select '").append(periodID).append("' , bill.FProfitCenterOrgID,bill.FCompanyOrgUnitID,bill.FCurrencyID,bill.FAsstActTypeID,bill.FAsstActID,bill.FAsstActName,");
        sql.append("bill.FSettlementType,null,null,null,bill.FcontrolUnitid,");
        sql.append("  0 as FBeginAmount,0 as FBeginAmountLocal,(case  FSettlementType when 10 then sum(entry.famount) else 0 end ) as FArAmount ,");
        sql.append(" (case  bill.FSettlementType when 10 then sum(entry.FAMOUNTLOCAL) else 0 end ) as FArAmountLocal , ");
        sql.append("  (case  bill.FSettlementType when 20 then sum(entry.famount) else 0 end ) as FApAmount , ");
        sql.append("  (case  bill.FSettlementType when 20 then sum(entry.FAMOUNTLOCAL) else 0 end ) as FApAmountLocal , ");
        sql.append(" 0 as FAmount,0 as FAmountLocal ");
        sql.append(" from T_MAP_BizRelatedBill bill left join T_MAP_BizRelatedbillENtry entry on bill.fid = entry.fparentID ");
        sql.append("  where bill.FProfitCenterOrgID = ? and bill.FBizDate > to_date(?) and bill.FBizDate < to_date(?) ");
        sql.append("  group by bill.FProfitCenterOrgID,bill.FCompanyOrgUnitID,bill.FCurrencyID,bill.FAsstActTypeID,bill.FAsstActID,bill.FAsstActName,");
        sql.append(" bill.FSettlementType,bill.FcontrolUnitid");
        sql.append("  )");
        SQLUtils.execute((Context)this.ctx, (String)sql.toString(), (Object[])new Object[]{profitCenterId, sdf.format(beginData), sdf.format(endData)});
    }

    private void insertCurPeriodData(String insertsql, String tmpTableName, String tmpTableName2) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" Insert  ").append(tmpTableName2).append("(");
        sql.append(insertsql).append(")");
        sql.append(" ( select FPeriodID,");
        sql.append(" FProfitCenterID,FCompanyOrgUnitID,FCurrencyID,FAsstActTypeID,FAsstActID,FAsstActName_l2,").append(NEWLINE);
        sql.append(" FSettlementType,FAdminOrgUnitID,FPersonID,FAccountID,FcontrolUnitid,").append(NEWLINE);
        sql.append(" sum(FBeginAmount),sum(FBeginAmountLocal),sum(FArAmount),sum(FArAmountLocal),sum(FApAmount),sum(FApAmountLocal),").append(NEWLINE);
        sql.append("  (case  FSettlementType when 20 then sum(FBeginAmount+FApAmount-FArAmount) else sum(FBeginAmount+FArAmount-FApAmount) end ) as FAmount , ").append(NEWLINE);
        sql.append("  (case  FSettlementType when 20 then sum(FBeginAmountLocal+FApAmountLocal-FArAmountLocal) else sum(FBeginAmountLocal+FArAmountLocal-FApAmountLocal) end ) as FAmountLocal ").append(NEWLINE);
        sql.append(" from ").append(tmpTableName);
        sql.append("  group by FPeriodID,FProfitCenterID,FCompanyOrgUnitID,FCurrencyID,FAsstActTypeID,FAsstActID,FAsstActName_l2,");
        sql.append("  FSettlementType,FAdminOrgUnitID,FPersonID,FAccountID,FcontrolUnitid)");
        SQLUtils.execute((Context)this.ctx, (String)sql.toString());
    }

    private void updateBalanceData(String tmpTableName, PeriodInfo curPeriodInfo, String profitCenterId) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" update ").append(tmpTableName).append("  as t ");
        sql.append(" set( fbalanceid ) = ");
        sql.append(" ( select  ");
        sql.append("  balance.fid ");
        sql.append(" from T_MAP_BALANCEBILL as balance ");
        sql.append(" where fPeriodID = ? and   FInitFlag = 1");
        sql.append(" and t.FProfitCenterID = balance.FProfitCenterOrgID and t.FCompanyOrgUnitID = balance.FCompanyOrgUnitID ");
        sql.append(" and t.FCurrencyID = balance.FCurrencyID  ");
        sql.append(" and t.FAsstActTypeID = balance.FAsstActTypeID  ");
        sql.append(" and t.FAsstActID = balance.FAsstActID  ");
        sql.append(" and t.FAsstActName_l2 = balance.FAsstActName_l2  ");
        sql.append(" and (t.FAdminOrgUnitID = balance.FAdminOrgUnitID or (t.FAdminOrgUnitID is null and balance.FAdminOrgUnitID is null ))");
        sql.append(" and (t.FPersonID = balance.FPersonID or (t.FPersonID is null and balance.FPersonID is null ))");
        sql.append(" and (t.FAccountID = balance.FAccountID or (t.FAccountID is null and balance.FAccountID is null ))");
        sql.append(" and (t.FcontrolUnitid = balance.FcontrolUnitid )");
        sql.append(" and (t.FSettlementType = balance.FSettlementType )");
        sql.append(")");
        SQLUtils.execute((Context)this.ctx, (String)sql.toString(), (Object[])new Object[]{curPeriodInfo.getId().toString()});
        sql.setLength(0);
        sql.append(" update t_Map_balancebill as balance");
        sql.append(" set( FBeginAmount ,FBeginAmountLocal ,FArAmount ,FArAmountLocal ,");
        sql.append(" FApAmount , FApAmountLocal , FAmount , FAmountLocal )= ");
        sql.append(" ( select  ");
        sql.append("  t.FBeginAmount,t.FBeginAmountLocal,t.FArAmount,t.FArAmountLocal, ");
        sql.append(" t.FApAmount,t.FApAmountLocal,t.FAmount,t.FAmountLocal");
        sql.append(" from ").append(tmpTableName).append(" as t ");
        sql.append(" where t.fbalanceid = balance.fid )");
        SQLUtils.execute((Context)this.ctx, (String)sql.toString());
    }

    private void insertBalanceData4Start(String tmpTableName, PeriodInfo curPeriodInfo) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" Insert T_MAP_BALANCEBILL (");
        sql.append(" fid,FPeriodID,FProfitCenterOrgID,FCompanyOrgUnitID,FCurrencyID,FAsstActTypeID,FAsstActID,FAsstActName_l2,");
        sql.append(" FSettlementType,FAdminOrgUnitID,FPersonID,FAccountID,FcontrolUnitid,");
        sql.append(" FBeginAmount,FBeginAmountLocal,FArAmount,FArAmountLocal,FApAmount,FApAmountLocal,");
        sql.append(" FAmount,FAmountLocal )");
        sql.append(" ( select ");
        sql.append(" newbosid('3CDC2D02'),t.FPeriodID,t.FProfitCenterID,t.FCompanyOrgUnitID,t.FCurrencyID,t.FAsstActTypeID,t.FAsstActID,t.FAsstActName_l2,").append(NEWLINE);
        sql.append(" t.FSettlementType,t.FAdminOrgUnitID,t.FPersonID,t.FAccountID,t.FcontrolUnitid,").append(NEWLINE);
        sql.append(" t.FBeginAmount,t.FBeginAmountLocal,t.FArAmount,t.FArAmountLocal,").append(NEWLINE);
        sql.append(" t.FApAmount,t.FApAmountLocal,t.FAmount,t.FAmountLocal").append(NEWLINE);
        sql.append(" from ").append(tmpTableName).append(" as t ");
        sql.append(" left join T_MAP_BALANCEBILL as balance on ");
        sql.append(" t.fbalanceid = balance.fid  ");
        sql.append(" where balance.fid is null  ");
        sql.append(" )");
        SQLUtils.execute((Context)this.ctx, (String)sql.toString());
    }

    private void deleteBalanceData(PeriodInfo curPeriodInfo, String profitCenterId) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" delete T_MAP_BALANCEBILL ");
        sql.append(" where FPeriodID = ? ");
        sql.append(" and FProfitCenterOrgID = ? and FInitFlag = 0");
        SQLUtils.execute((Context)this.ctx, (String)sql.toString(), (Object[])new Object[]{curPeriodInfo.getId().toString(), profitCenterId});
    }

    private void insertBalanceData(String tmpTableName) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" Insert T_MAP_BALANCEBILL (");
        sql.append(" fid,FPeriodID,FProfitCenterOrgID,FCompanyOrgUnitID,FCurrencyID,FAsstActTypeID,FAsstActID,FAsstActName_l2,");
        sql.append(" FSettlementType,FAdminOrgUnitID,FPersonID,FAccountID,FcontrolUnitid,");
        sql.append(" FBeginAmount,FBeginAmountLocal,FArAmount,FArAmountLocal,FApAmount,FApAmountLocal,");
        sql.append(" FAmount,FAmountLocal )");
        sql.append(" ( select ");
        sql.append("  newbosid('3CDC2D02'),FPeriodID,FProfitCenterID,FCompanyOrgUnitID,FCurrencyID,FAsstActTypeID,FAsstActID,FAsstActName_l2,").append(NEWLINE);
        sql.append(" FSettlementType,FAdminOrgUnitID,FPersonID,FAccountID,FcontrolUnitid,").append(NEWLINE);
        sql.append(" FBeginAmount,FBeginAmountLocal,FArAmount,FArAmountLocal,FApAmount,FApAmountLocal,").append(NEWLINE);
        sql.append(" FAmount,FAmountLocal ").append(NEWLINE);
        sql.append(" from ").append(tmpTableName).append(" )");
        SQLUtils.execute((Context)this.ctx, (String)sql.toString());
    }

    private void insertNextBalanceData(String tmpTableName, PeriodInfo nextPeriodInfo) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" Insert T_MAP_BALANCEBILL (");
        sql.append(" fid,FPeriodID,FProfitCenterOrgID,FCompanyOrgUnitID,FCurrencyID,FAsstActTypeID,FAsstActID,FAsstActName_l2,");
        sql.append(" FSettlementType,FAdminOrgUnitID,FPersonID,FAccountID,FcontrolUnitid,");
        sql.append(" FBeginAmount,FBeginAmountLocal,FArAmount,FArAmountLocal,FApAmount,FApAmountLocal,");
        sql.append(" FAmount,FAmountLocal )");
        sql.append(" ( select ");
        sql.append("  newbosid('3CDC2D02'),FPeriodID,FProfitCenterID,FCompanyOrgUnitID,FCurrencyID,FAsstActTypeID,FAsstActID,FAsstActName_l2,").append(NEWLINE);
        sql.append(" FSettlementType,FAdminOrgUnitID,FPersonID,FAccountID,FcontrolUnitid,").append(NEWLINE);
        sql.append(" FAmount,FAmountLocal,0,0,0,0,").append(NEWLINE);
        sql.append(" 0,0 ").append(NEWLINE);
        sql.append(" from ").append(tmpTableName);
        sql.append(" where FAmount <> 0 and FAmountLocal <>0 )");
        SQLUtils.execute((Context)this.ctx, (String)sql.toString());
    }

    private void releasTempTable(String tmpTableName) throws BOSException {
        if (tmpTableName == null || tmpTableName.trim().length() == 0) {
            return;
        }
        TempTablePool tmpTblPool = TempTablePool.getInstance((Context)this.ctx);
        try {
            tmpTblPool.releaseTable(tmpTableName);
        }
        catch (Exception e) {
            throw new BOSException("cannot release tempTable", (Throwable)e);
        }
    }

    private void updatePeriod(boolean isforword, OrgUnitInfo orgInfo, boolean isAdjustPeriod) throws EASBizException, BOSException {
        ISystemStatusCtrol iSystemStatusCtrol = SystemStatusCtrolFactory.getLocalInstance((Context)this.ctx);
        if (isforword) {
            iSystemStatusCtrol.nextPeriod(SystemEnum.PROFIT_CENTER_STORAGE, orgInfo);
            if (isAdjustPeriod) {
                iSystemStatusCtrol.nextPeriod(SystemEnum.PROFIT_CENTER_STORAGE, orgInfo);
            }
        } else {
            iSystemStatusCtrol.prePeriod(SystemEnum.PROFIT_CENTER_STORAGE, orgInfo);
        }
    }

    public String getTaskID() {
        return null;
    }
}

