/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.base.app;

import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.ma.base.BgAccountGroupInfo;
import com.kingdee.eas.ma.base.BgAccountInfo;
import com.kingdee.eas.ma.base.app.AbstractBgAccountVirtualModelFacadeControllerBean;
import com.kingdee.eas.ma.base.app.utils.MbgSqlHelper;
import com.kingdee.eas.ma.base.utils.AbstractVirtualModelFilterParam;
import com.kingdee.eas.ma.base.utils.BgAccountVritaulModelFilterParam;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class BgAccountVirtualModelFacadeControllerBean
extends AbstractBgAccountVirtualModelFacadeControllerBean {
    private static final long serialVersionUID = 5314777793844791203L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.base.app.BgAccountVirtualModelFacadeControllerBean");

    @Override
    protected void analyseTmpTable(Context ctx, Connection conn, String tmpTable, AbstractVirtualModelFilterParam filterParam, EntityObjectInfo entityInfo) throws SQLException {
        BgAccountVritaulModelFilterParam _filterParam = (BgAccountVritaulModelFilterParam)filterParam;
        if (_filterParam.getOrgUnitIds().isEmpty()) {
            return;
        }
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        String orgTmpTable = null;
        String bgAccTmpDis = null;
        String distriTmpTable = null;
        try {
            String sql = "Insert Into " + tmpTable + "(FId, FLongNumber, FLevel, FParentID, FIsEnable) Select FID, FLongNumber, FLevel, FDistributeRootID, 0 FROM T_Mbg_BgAccount acc Where acc.FBgAccountViewID = ?";
            BgAccountGroupInfo[] groups = _filterParam.getGroups();
            String accGroupTable = null;
            if (groups != null && groups.length > 0) {
                String accGroup = "Create Table T_MBg_BgAccGroupTEMP(FGroupId Varchar(44) NOT NULL)";
                accGroupTable = pool.createTempTable(accGroup);
                String insertGroup = "Insert Into " + accGroupTable + "(FGroupId) Values(?)";
                ArrayList<String> groupIdList = new ArrayList<String>();
                for (int i = 0; i < groups.length; ++i) {
                    BgAccountGroupInfo bgAccountGroupInfo = groups[i];
                    if (bgAccountGroupInfo == null || bgAccountGroupInfo.getId() == null) continue;
                    groupIdList.add(bgAccountGroupInfo.getId().toString());
                }
                if (!groupIdList.isEmpty()) {
                    MbgSqlHelper.executeBatch(conn, insertGroup, groupIdList);
                }
            }
            if (accGroupTable != null) {
                sql = sql + " and acc.FBgAccountGroupID in (select FGroupId from " + accGroupTable + ")";
            }
            if (Boolean.FALSE.equals(_filterParam.getIsAssigned())) {
                sql = sql + " AND acc.FIsEnabled = 1";
            }
            MbgSqlHelper.executeBatch(conn, sql, new Object[]{_filterParam.getAccountViewId()});
            if (_filterParam.getOrgUnitIds().isEmpty()) {
                return;
            }
            sql = "Create Table T_MBg_BgAccVirtual(FOrgUnitId Varchar(44) NOT NULL)";
            orgTmpTable = pool.createTempTable(sql);
            sql = "Insert Into " + orgTmpTable + "(FOrgUnitId) Values(?)";
            MbgSqlHelper.executeBatch(conn, sql, _filterParam.getOrgUnitIds());
            logger.error((Object)"begin invoke update tmpTable Enabled  load bgData!");
            sql = "Create Table distriTmpTable(FDistributeRootID Varchar(44),forgunitId Varchar(44) NOT NULL)";
            distriTmpTable = pool.createTempTable(sql);
            sql = "insert into " + distriTmpTable + "( FDistributeRootID,forgunitId) select FDistributeRootID,forgunitId from T_mbg_BgAccount where FOrgUnitId IN(Select FOrgUnitID FROM " + orgTmpTable + ")  and FDISTRIBUTEROOTID in (SELECT FDISTRIBUTEROOTID FROM T_mbg_bgAccount where FBGACCOUNTVIEWID ='" + _filterParam.getAccountViewId() + "')";
            MbgSqlHelper.execute(conn, sql);
            sql = "Update " + tmpTable + " t0 Set FIsEnable = (select count(*) From " + distriTmpTable + " accTmp where accTmp.FDistributeRootID = t0.FParentID group by accTmp.FDistributeRootID)";
            MbgSqlHelper.execute(conn, sql);
            sql = "update " + tmpTable + " set FIsEnable = 0 where FIsEnable is null";
            MbgSqlHelper.execute(conn, sql);
            logger.error((Object)"end invoke update tmpTable Enabled  load bgData!");
            boolean count = false;
            sql = Boolean.TRUE.equals(_filterParam.getIsAssigned()) ? "Delete " + tmpTable + " Where FIsEnable < " + _filterParam.getOrgUnitIds().size() : "Delete " + tmpTable + " Where FIsEnable = " + _filterParam.getOrgUnitIds().size();
            MbgSqlHelper.execute(conn, sql);
            pool.releaseTable(orgTmpTable);
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            throw new SQLException(e);
        }
        finally {
            pool.releaseTable(orgTmpTable);
            pool.releaseTable(bgAccTmpDis);
            pool.releaseTable(distriTmpTable);
        }
        pool.releaseTable(bgAccTmpDis);
        pool.releaseTable(distriTmpTable);
    }

    @Override
    protected String createBaseQuerySql(Context ctx, AbstractVirtualModelFilterParam filterParam, EntityObjectInfo entityInfo) {
        StringBuffer querySql = new StringBuffer();
        querySql.append("Select acc.FID \"id\", acc.FNumber \"number\", acc.FName_").append(ctx.getLocale()).append(" \"name\", acc.FPolAlgorithm \"polAlgorithm\", acc.FPeriodAlgorithm \"periodAlgorithm\"").append(", acc.FLongNumber \"longNumber\", acc.FLevel \"level\", acc.FIsLeaf \"isLeaf\", orgUnit.FName_").append(ctx.getLocale()).append(" \"orgUnit\"").append(" FROM ").append(this.getTableName(ctx)).append(" vTable INNER JOIN T_MBg_BgAccount acc ON acc.FID = vTable.FID INNER JOIN T_Org_BaseUnit orgUnit ON acc.FOrgUnitId = orgUnit.FID");
        return querySql.toString();
    }

    @Override
    protected BOSObjectType getBaseDataBosType() {
        return new BgAccountInfo().getBOSType();
    }
}

