/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.base.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.TreeBaseCollection;
import com.kingdee.eas.framework.TreeBaseInfo;
import com.kingdee.eas.ma.base.BgAccountInfo;
import com.kingdee.eas.ma.base.BgDimSourceFactory;
import com.kingdee.eas.ma.base.BgDimSourceInfo;
import com.kingdee.eas.ma.base.IBgDimSource;
import com.kingdee.eas.ma.base.MbgMemberInfo;
import com.kingdee.eas.ma.base.app.AbstractBgDimSourceControllerBean;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.base.utils.BgNumberHelper;
import com.kingdee.eas.ma.base.utils.OrgUnitUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Locale;
import org.apache.log4j.Logger;

public class BgDimSourceControllerBean
extends AbstractBgDimSourceControllerBean {
    private static final long serialVersionUID = 4025981142481340536L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.base.app.BgDimSourceControllerBean");

    @Override
    protected IObjectCollection _getBizCollection(Context ctx, String sourceID, String accTableID, IObjectValue costCenterInfo) throws BOSException, EASBizException {
        if (sourceID == null || StringUtils.isEmpty((String)sourceID)) {
            return null;
        }
        IBgDimSource iBgAccountSource = BgDimSourceFactory.getLocalInstance(ctx);
        BgDimSourceInfo sourceInfo = iBgAccountSource.getBgDimSourceInfo((IObjectPK)new ObjectUuidPK(sourceID));
        TreeBaseCollection result = null;
        if (sourceInfo.getBizTable().equalsIgnoreCase("T_BD_AccountView")) {
            result = this.getBDAccountColls(ctx, sourceInfo, accTableID, costCenterInfo);
        } else if (sourceInfo.getBizTable().equalsIgnoreCase("T_BC_ExpenseType")) {
            result = this.getColls(ctx, sourceInfo, costCenterInfo, true);
        } else if (sourceInfo.getBizTable().equalsIgnoreCase("T_BD_CashFlowItem") || sourceInfo.getBizTable().equalsIgnoreCase("T_CAS_FundFlowItem") || sourceInfo.getBizTable().equalsIgnoreCase("T_CSL_RptItem")) {
            result = this.getColls(ctx, sourceInfo, costCenterInfo, false);
        } else if (sourceInfo.getBizSourceType().getValue() == 2) {
            int isTree = BgDBUtils.existColumn(ctx, sourceInfo.getBizTable(), "FlongNumber");
            if (sourceInfo.getBizTable().equals("T_BD_Material")) {
                isTree = 0;
            }
            boolean isOrgChild = false;
            if (accTableID != null) {
                isOrgChild = Boolean.valueOf(accTableID);
            }
            result = this.getBaseColls(ctx, sourceInfo, costCenterInfo, false, isTree, isOrgChild);
        }
        if (result != null) {
            DataBaseInfo info = null;
            for (int i = result.size() - 1; i >= 0; --i) {
                if (!(result.getObject(i) instanceof DataBaseInfo)) continue;
                info = (DataBaseInfo)result.getObject(i);
                if (!BgNumberHelper.checkNumber(info.getNumber())) {
                    result.removeObject(i);
                    continue;
                }
                if (!(info instanceof TreeBaseInfo) || ((TreeBaseInfo)info).getLongNumber() == null || ((TreeBaseInfo)info).getLongNumber().indexOf("!!") < 0) continue;
                result.removeObject(i);
            }
        }
        return result;
    }

    private TreeBaseCollection getBDAccountColls(Context ctx, BgDimSourceInfo sourceInfo, String accTableID, IObjectValue costCenterInfo) throws EASBizException, BOSException {
        if (costCenterInfo == null) {
            return null;
        }
        TreeBaseCollection colls = new TreeBaseCollection();
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        Locale locale = ctx.getLocale();
        StringBuffer sql = new StringBuffer();
        CompanyOrgUnitInfo company = OrgUnitUtils.getCompanyOrgUnit(ctx, costCenterInfo);
        if (company != null && company.getId() != null) {
            if (accTableID != null) {
                sql.append(this.getAccoutSelector(locale));
                sql.append(" from T_BD_AccountView ");
                sql.append(" where FAccountTableID = '" + accTableID + "' ");
                sql.append(" And FCompanyID = '" + company.getId().toString() + "'");
                sql.append("Order by FLongNumber");
            } else {
                sql.append("select av.FID FID, av.FNumber FNumber, av.FName_" + locale + " FName_" + locale + " , av.fLongNumber fLongNumber, av.FIsLeaf FIsLeaf, av.FLevel FLevel, av.FDisplayName_" + locale + " FDisplayName_" + locale + " ");
                sql.append(" from T_BD_AccountView av ");
                sql.append(" left join T_ORG_Company cpy on cpy.FId = av.FCompanyID ");
                sql.append(" where cpy.FNumber = '" + company.getNumber() + "' ");
                sql.append(" or cpy.FLongNumber like '" + company.getLongNumber() + "!%' ");
                sql.append(" Order by cpy.FLongNumber asc, av.FACCOUNTTYPEID asc, fLongNumber asc");
            }
        } else {
            return null;
        }
        HashSet<String> filterSet = new HashSet<String>();
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            rst = pstmt.executeQuery();
            while (rst.next()) {
                if (filterSet.contains(rst.getString("FNumber") + "@" + rst.getString("FName_" + locale))) continue;
                filterSet.add(rst.getString("FNumber") + "@" + rst.getString("FName_" + locale));
                colls.addObject((IObjectValue)this.getBgAccountInfo(rst, locale));
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)ex);
                throw new BOSException(ex.getMessage());
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return colls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TreeBaseCollection getColls(Context ctx, BgDimSourceInfo sourceInfo, IObjectValue costCenterInfo, Boolean isCompany) throws EASBizException, BOSException {
        CompanyOrgUnitInfo company;
        if (costCenterInfo == null) {
            return null;
        }
        TreeBaseCollection colls = new TreeBaseCollection();
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        Locale locale = ctx.getLocale();
        StringBuffer sql = new StringBuffer();
        sql.append(this.getAccoutSelector(locale));
        sql.append(" from " + sourceInfo.getBizTable());
        if (isCompany.booleanValue() && (company = OrgUnitUtils.getCompanyOrgUnit(ctx, costCenterInfo)) != null && company.getId() != null && company.getLongNumber() != null) {
            String[] numbers = company.getLongNumber().split("!");
            sql.append(" where FCompanyID in( select fid from t_org_company where fnumber in( ");
            for (int i = 0; i < numbers.length; ++i) {
                if (i == 0) {
                    sql.append("'" + numbers[i] + "'");
                    continue;
                }
                sql.append(",'" + numbers[i] + "'");
            }
            sql.append(" ))");
        }
        sql.append(" order by FLongNumber");
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            rst = pstmt.executeQuery();
            while (rst.next()) {
                colls.addObject((IObjectValue)this.getBgAccountInfo(rst, locale));
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
            SQLUtils.cleanup(rst, (Statement)pstmt, (Connection)conn);
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return colls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IObjectCollection getBaseColls(Context ctx, BgDimSourceInfo sourceInfo, IObjectValue costCenterInfo, Boolean isCompany, int isTree, boolean isOrgChild) throws EASBizException, BOSException {
        TreeBaseCollection colls;
        block37: {
            boolean isOrgTable;
            if (costCenterInfo == null) {
                return null;
            }
            colls = new TreeBaseCollection();
            TempTablePool pool = null;
            String tableName = null;
            Connection conn = null;
            PreparedStatement pstmt = null;
            ResultSet rst = null;
            Locale locale = ctx.getLocale();
            StringBuffer sql = new StringBuffer();
            if (isTree == 1) {
                sql.append(this.getSelector(locale));
            } else {
                sql.append(this.getSimpleSelector(locale));
            }
            sql.append(" from " + sourceInfo.getBizTable());
            CompanyOrgUnitInfo company = OrgUnitUtils.getCompanyOrgUnit(ctx, costCenterInfo);
            if ((sourceInfo.getBizTable().equals("T_BD_Material") || sourceInfo.getBizTable().equals("T_BD_Customer") || sourceInfo.getBizTable().equals("T_BD_Supplier")) && costCenterInfo instanceof CostCenterOrgUnitInfo && ((CostCenterOrgUnitInfo)costCenterInfo).getCU() != null) {
                String bosType = "";
                String usedStatus = " and FUsedStatus in(1,2) ";
                if (sourceInfo.getBizTable().equals("T_BD_Material")) {
                    bosType = "4409E7F0";
                    usedStatus = " and FStatus in(1,2) ";
                } else if (sourceInfo.getBizTable().equals("T_BD_Customer")) {
                    bosType = "BF0C040E";
                } else if (sourceInfo.getBizTable().equals("T_BD_Supplier")) {
                    bosType = "37C67DFC";
                }
                if (isOrgChild) {
                    FullOrgUnitInfo orginfo = FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(((CostCenterOrgUnitInfo)costCenterInfo).getCU().getId()));
                    conn = this.getConnection(ctx);
                    pool = TempTablePool.getInstance((Context)ctx);
                    try {
                        tableName = pool.createTempTable("create table tempb(FCUID varchar(44))");
                        BgDBUtils.executeUpdate(ctx, " insert into " + tableName + " (FCUID) select fid from T_ORG_CtrlUnit where flongnumber like '" + orginfo.getLongNumber() + "!%' ");
                        sql.append(" where ( exists(select t.FCUID from " + tableName + " t where t.FCUID = FCONTROLUNITID )  OR FID IN(SELECT FDataBaseDID FROM t_bd_databasedassign WHERE FBOSObjectType = '" + bosType + "' AND exists(select t.FCUID from " + tableName + " t where t.FCUID = FAssignCUID ))) " + usedStatus);
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else {
                    sql.append(" where ( FCONTROLUNITID = '" + ((CostCenterOrgUnitInfo)costCenterInfo).getCU().getId().toString() + "' OR FID IN(SELECT FDataBaseDID FROM t_bd_databasedassign WHERE FBOSObjectType = '" + bosType + "' AND FAssignCUID = '" + ((CostCenterOrgUnitInfo)costCenterInfo).getCU().getId().toString() + "')) " + usedStatus);
                }
            } else if (isCompany.booleanValue() && company != null && company.getId() != null) {
                sql.append(" where FCompanyID = '" + company.getId().toString() + "'");
            }
            boolean bl = isOrgTable = sourceInfo.getBizTable().toUpperCase().indexOf("_ORG_") > -1;
            if (isOrgTable) {
                if (isCompany.booleanValue()) {
                    sql.append(" AND FISSEALUP = 0 ");
                } else {
                    sql.append(" WHERE FISSEALUP = 0 ");
                }
            }
            if (isTree == 1) {
                sql.append(" order by FLongNumber");
            } else {
                sql.append(" order by FNumber");
            }
            try {
                conn = this.getConnection(ctx);
                pstmt = conn.prepareStatement(sql.toString());
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    colls.addObject((IObjectValue)this.getMbgMemberInfo(rst, locale, isTree));
                }
            }
            catch (SQLException ex) {
                try {
                    logger.error((Object)ex);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                    if (tableName != null) {
                        try {
                            if (pool != null) {
                                pool.releaseTable(tableName);
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
                SQLUtils.cleanup(rst, (Statement)pstmt, (Connection)conn);
                if (tableName == null) break block37;
                try {
                    if (pool != null) {
                        pool.releaseTable(tableName);
                    }
                }
                catch (Exception exception) {}
            }
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
            if (tableName != null) {
                try {
                    if (pool != null) {
                        pool.releaseTable(tableName);
                    }
                }
                catch (Exception usedStatus) {}
            }
        }
        return colls;
    }

    private String getAccoutSelector(Locale locale) {
        return "select FID , FNumber, FName_" + locale + " , fLongNumber , FIsLeaf , FLevel , FDisplayName_" + locale + "";
    }

    private String getSelector(Locale locale) {
        return "select FID , FNumber, FName_" + locale + " , fLongNumber , FIsLeaf , FLevel ";
    }

    private String getSimpleSelector(Locale locale) {
        return "select FID, FNumber, FName_" + locale;
    }

    private BgAccountInfo getBgAccountInfo(ResultSet rst, Locale locale) throws SQLException {
        BgAccountInfo bgAccountInfo = new BgAccountInfo();
        bgAccountInfo.setId(BOSUuid.create((BOSObjectType)bgAccountInfo.getBOSType()));
        bgAccountInfo.setNumber(rst.getString("FNumber"));
        bgAccountInfo.setName(rst.getString("FName_" + locale));
        bgAccountInfo.setLongNumber(rst.getString("FLongNumber"));
        bgAccountInfo.setIsLeaf(rst.getBoolean("FIsLeaf"));
        bgAccountInfo.setLevel(rst.getInt("FLevel"));
        bgAccountInfo.setDisplayName(rst.getString("FDisplayName_" + locale));
        return bgAccountInfo;
    }

    private MbgMemberInfo getMbgMemberInfo(ResultSet rst, Locale locale, int isTree) throws SQLException {
        MbgMemberInfo mbgMemberInfo = new MbgMemberInfo();
        mbgMemberInfo.setId(BOSUuid.create((BOSObjectType)mbgMemberInfo.getBOSType()));
        mbgMemberInfo.setNumber(rst.getString("FNumber"));
        mbgMemberInfo.setName(rst.getString("FName_" + locale));
        if (isTree == 1) {
            mbgMemberInfo.setLongNumber(rst.getString("FLongNumber"));
            mbgMemberInfo.setIsLeaf(rst.getBoolean("FIsLeaf"));
            mbgMemberInfo.setLevel(rst.getInt("FLevel"));
        }
        return mbgMemberInfo;
    }
}

