/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.base.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.ma.base.MbgMemberInfo;
import com.kingdee.eas.ma.base.app.AbstractBgDimVirtualModelFacadeControllerBean;
import com.kingdee.eas.ma.base.app.utils.MbgSqlHelper;
import com.kingdee.eas.ma.base.utils.AbstractVirtualModelFilterParam;
import com.kingdee.eas.ma.base.utils.BgAccountVritaulModelFilterParam;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class BgDimVirtualModelFacadeControllerBean
extends AbstractBgDimVirtualModelFacadeControllerBean {
    private static final long serialVersionUID = -4151889637361914507L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.base.app.BgDimVirtualModelFacadeControllerBean");

    @Override
    protected String createBaseQuerySql(Context ctx, AbstractVirtualModelFilterParam filterParam, EntityObjectInfo entityInfo) {
        StringBuffer querySql = new StringBuffer();
        querySql.append("Select mem.FID \"id\", mem.FNumber \"number\", mem.FName_").append(ctx.getLocale()).append(" \"name\", mem.Fdescription_").append(ctx.getLocale()).append(" \"description\" ").append(", mem.FLongNumber \"longNumber\", mem.FLevel \"level\", mem.FIsLeaf \"isLeaf\", orgUnit.FName_").append(ctx.getLocale()).append(" \"orgUnit\" ").append(", p.FName_").append(ctx.getLocale()).append(" \"parent\"").append(" FROM ").append(this.getTableName(ctx)).append(" vTable INNER JOIN T_MBg_MBgMember mem ON mem.FID = vTable.FID INNER JOIN T_Org_BaseUnit orgUnit ON mem.FOrgUnitId = orgUnit.FID LEFT JOIN T_MBG_MbgMember p ON mem.FParentID = p.FID");
        return querySql.toString();
    }

    @Override
    protected void analyseTmpTable(Context ctx, Connection conn, String tmpTable, AbstractVirtualModelFilterParam filterParam, EntityObjectInfo entityInfo) throws SQLException, BOSException {
        BgAccountVritaulModelFilterParam _filterParam = (BgAccountVritaulModelFilterParam)filterParam;
        if (_filterParam.getOrgUnitIds().isEmpty() && Boolean.TRUE.equals(_filterParam.getIsAssigned())) {
            return;
        }
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        String orgTmpTable = null;
        try {
            String sql = "Insert Into " + tmpTable + "(FId, FLongNumber, FLevel, FParentID, FIsEnable) Select FID, FLongNumber, FLevel, FParentID, 0 FROM T_MBg_MBgMember mem Where mem.FViewID = ?  and  mem.FISSYSTEMDEFAULT = 0 and (mem.FOrgunitID= ? or mem.fid in(select node.FMbgMemberID FROM T_MBg_MBgMemberNode node where node.FOrgUnitID = ? ))";
            if (Boolean.FALSE.equals(_filterParam.getIsAssigned())) {
                sql = sql + " AND mem.FIsEnabled = 1";
            }
            MbgSqlHelper.executeBatch(conn, sql, new Object[]{_filterParam.getAccountViewId(), _filterParam.getCurrOrgUnit(), _filterParam.getCurrOrgUnit()});
            if (_filterParam.getOrgUnitIds().isEmpty()) {
                // empty if block
            }
            sql = "Create Table T_MBg_BgMemVirtual(FOrgUnitId Varchar(44) NOT NULL)";
            orgTmpTable = pool.createTempTable(sql);
            sql = "Insert Into " + orgTmpTable + "(FOrgUnitId) Values(?)";
            MbgSqlHelper.executeBatch(conn, sql, _filterParam.getOrgUnitIds());
            sql = "Update " + tmpTable + " t0 Set FIsEnable = (Select Count(FID) FROM T_MBg_MBgMemberNode node Where node.FMbgMemberID = t0.FID AND node.FOrgUnitID IN(Select FOrgUnitID FROM " + orgTmpTable + "))";
            MbgSqlHelper.execute(conn, sql);
            boolean count = false;
            sql = Boolean.TRUE.equals(_filterParam.getIsAssigned()) ? "Delete " + tmpTable + " Where FIsEnable < " + _filterParam.getOrgUnitIds().size() : "Delete " + tmpTable + " Where FIsEnable = " + _filterParam.getOrgUnitIds().size();
            MbgSqlHelper.execute(conn, sql);
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            throw new SQLException(e);
        }
        finally {
            if (orgTmpTable != null) {
                pool.releaseTable(tmpTable);
            }
        }
    }

    @Override
    protected BOSObjectType getBaseDataBosType() {
        return new MbgMemberInfo().getBOSType();
    }
}

