/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.base.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.TreeBaseCollection;
import com.kingdee.eas.ma.base.BgElementCollection;
import com.kingdee.eas.ma.base.BgElementException;
import com.kingdee.eas.ma.base.BgElementFactory;
import com.kingdee.eas.ma.base.BgElementInfo;
import com.kingdee.eas.ma.base.BgScenarioException;
import com.kingdee.eas.ma.base.app.AbstractBgElementControllerBean;
import com.kingdee.eas.ma.base.app.utils.BgIntIdHelper;
import com.kingdee.eas.ma.base.utils.BgDimCacheUtils;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class BgElementControllerBean
extends AbstractBgElementControllerBean {
    private static final long serialVersionUID = 196406284728613331L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.base.app.BgElementControllerBean");
    private static final String SYS_ELEMENT_NUMBER = "01";

    protected FilterInfo getFilterForDefaultCU(Context ctx, IObjectValue model) {
        return new FilterInfo();
    }

    @Override
    public void delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        if (!this.isUse(ctx, pk)) {
            if (this.isSysSet(ctx, pk)) {
                throw new BgElementException(BgElementException.ISSYSSET);
            }
        } else {
            throw new BgElementException(BgElementException.ISUSE);
        }
        super.delete(ctx, pk);
        BgDimCacheUtils.clearElementCache(ctx);
    }

    private boolean isSysSet(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        IRowSet rs;
        block5: {
            boolean bl;
            if (pk == null) {
                return false;
            }
            String sql = "select fid from t_mbg_bgelement where FID = ? and FNumber = ?";
            rs = null;
            try {
                rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new String[]{pk.toString(), SYS_ELEMENT_NUMBER});
                if (!rs.next()) break block5;
                bl = true;
            }
            catch (SQLException e) {
                try {
                    logger.error((Object)"budget error:", (Throwable)e);
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)rs);
            return bl;
        }
        SQLUtils.cleanup((ResultSet)rs);
        return false;
    }

    private boolean isUse(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        boolean isUsed = false;
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            String sql = "SELECT s.fid FROM t_mbg_bgScheme s  left join t_mbg_bgDimSettings d on d.FBgschemeId = s.FID   left join t_mbg_bgDimSettingsMember m  on d.fid=m.FBgDimSettingsId  where  d.FDimNumber = 'BG_Element'  and m.FmemberId = ? ";
            conn = this.getConnection(ctx);
            ps = conn.prepareStatement(sql);
            ps.setString(1, pk.toString());
            rs = ps.executeQuery();
            if (rs.next()) {
                isUsed = true;
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException(e.toString());
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)conn);
        return isUsed;
    }

    @Override
    protected Map _deleteEle(Context ctx, ArrayList ids) throws BOSException, EASBizException {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("number"));
        for (int i = 0; i < ids.size(); ++i) {
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)ids.get(i).toString()));
            BgElementInfo bgeleInfo = (BgElementInfo)this._getValue(ctx, (IObjectPK)pk, sic);
            if (this.isUse(ctx, (IObjectPK)pk)) {
                map.put(bgeleInfo.get("number").toString(), 1);
                continue;
            }
            if (this.isSysSet(ctx, (IObjectPK)pk)) {
                map.put(bgeleInfo.get("number").toString(), 2);
                continue;
            }
            this._delete(ctx, (IObjectPK)pk);
            map.put(bgeleInfo.get("number").toString(), 3);
        }
        return map;
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        super._delete(ctx, pk);
        BgDimCacheUtils.clearElementCache(ctx);
    }

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        BgElementInfo bgelement = (BgElementInfo)model;
        FilterInfo filter = new FilterInfo();
        filter.appendFilterItem("number", (Object)bgelement.getNumber());
        if (this._exists(ctx, filter)) {
            throw new BgScenarioException(BgScenarioException.FORBIDDENREPEATNUM);
        }
        filter.appendFilterItem("name", (Object)bgelement.getName());
        if (this._exists(ctx, filter)) {
            throw new BgElementException(BgElementException.FORBIDDENREPEATNAME);
        }
        BgIntIdHelper.setIntIdOnlyAddNew(ctx, (CoreBaseInfo)bgelement, "T_MBG_BgElement", true);
        return super._addnew(ctx, model);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        BgElementInfo bgelement = (BgElementInfo)model;
        Locale local = ctx.getLocale();
        if (bgelement.getId() != null) {
            IRowSet rs;
            block5: {
                String sql = "select top 1 fid from t_mbg_bgelement where FID <> ? and FName_" + local + " = ?";
                rs = null;
                try {
                    rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new String[]{bgelement.getId().toString(), bgelement.getName()});
                    if (!rs.next()) break block5;
                    throw new BgElementException(BgElementException.FORBIDDENREPEATNAME);
                }
                catch (SQLException e) {
                    try {
                        logger.error((Object)"budget error:", (Throwable)e);
                        throw new BOSException((Throwable)e);
                    }
                    catch (Throwable throwable) {
                        SQLUtils.cleanup(rs);
                        throw throwable;
                    }
                }
            }
            SQLUtils.cleanup((ResultSet)rs);
        }
        IObjectPK pk = super._submit(ctx, model);
        BgDimCacheUtils.clearElementCache(ctx);
        this.updateStyleSetElement(ctx, model);
        return pk;
    }

    private void updateStyleSetElement(Context ctx, IObjectValue model) throws BOSException {
        Class<?> util = null;
        try {
            util = Class.forName("com.kingdee.eas.ma.mbg.app.StyleSetControllerBean");
            Object _instance = util.newInstance();
            Method method = util.getDeclaredMethod("updateStyleSetElement", Context.class, IObjectValue.class);
            method.invoke(_instance, ctx, model);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected Map _remove(Context ctx, List ids) throws BOSException, EASBizException {
        HashMap result = new HashMap();
        HashSet<String> cantRemove = new HashSet<String>();
        HashSet<String> canSet = new HashSet<String>();
        HashSet idset = new HashSet();
        result.put("cantRemove", cantRemove);
        result.put("canSet", canSet);
        if (ids == null || ids.isEmpty()) {
            return null;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("number");
        sic.add("name");
        sic.add("isSysData");
        sic.add("parent.id");
        view.getSelector().addObjectCollection((IObjectCollection)sic);
        for (int index = 0; index < ids.size(); ++index) {
            idset.add(ids.get(index));
        }
        filter.getFilterItems().add(new FilterItemInfo("id", idset, CompareType.INCLUDE));
        view.setFilter(filter);
        BgElementCollection verCol = BgElementFactory.getLocalInstance(ctx).getBgElementCollection(view);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter1 = new FilterInfo();
        SelectorItemCollection sic1 = new SelectorItemCollection();
        sic1.add("id");
        sic1.add("number");
        sic1.add("name");
        sic1.add("isSysData");
        sic1.add("parent.id");
        evi.getSelector().addObjectCollection((IObjectCollection)sic1);
        filter1.getFilterItems().add(new FilterItemInfo("id", (Object)"Select settMember.FMemberID FROM T_MBG_BgDimSettings sett INNER JOIN T_MBG_BgDimSettingsMember settMember On settMember.FBgDimSettingsId = sett.FID Where sett.FDimNumber = 'BG_Element'", CompareType.INNER));
        evi.setFilter(filter1);
        BgElementCollection cantVerCol = BgElementFactory.getLocalInstance(ctx).getBgElementCollection(evi);
        int en = cantVerCol.size();
        for (int j = 0; j < en; ++j) {
            TreeBaseCollection children = this.getAllChildren(ctx, cantVerCol.get(j));
            if (verCol.contains(cantVerCol.get(j))) {
                verCol.remove(cantVerCol.get(j));
                cantRemove.add(cantVerCol.get(j).getId().toString());
            }
            if (children == null) continue;
            for (int i = 0; i < children.size(); ++i) {
                if (!verCol.contains(children.get(i))) continue;
                verCol.remove(cantVerCol.get(j));
                cantRemove.add(cantVerCol.get(j).getId().toString());
            }
        }
        idset.clear();
        HashMap childMap = new HashMap();
        HashSet<Object> childSet = null;
        HashMap<Object, BgElementInfo> parentMap = new HashMap<Object, BgElementInfo>();
        TreeBaseCollection coll = null;
        int in = verCol.size();
        for (int i = 0; i < in; ++i) {
            BgElementInfo version = verCol.get(i);
            coll = this.getAllChildren(ctx, version);
            childSet = new HashSet<Object>();
            BgElementInfo child = null;
            int jn = coll.size();
            for (int j = 0; j < jn; ++j) {
                child = (BgElementInfo)coll.get(j);
                childSet.add(child);
                canSet.add(child.getId().toString());
                if (verCol.contains(child)) continue;
                idset.add(child.getId().toString());
            }
            childSet.add(version);
            canSet.add(version.getId().toString());
            childMap.put(version, childSet);
            if (version.getParent() == null) continue;
            parentMap.put(version, version.getParent());
        }
        BgElementInfo parent = null;
        BgElementCollection updateParentColl = new BgElementCollection();
        for (BgElementInfo account : parentMap.keySet()) {
            parent = (BgElementInfo)parentMap.get(account);
            coll = this.getAllChildren(ctx, parent);
            BgElementInfo info = null;
            Boolean flag = true;
            int in2 = coll.size();
            for (int i = 0; i < in2; ++i) {
                info = (BgElementInfo)coll.get(i);
                if (canSet.contains(info.getId().toString())) continue;
                flag = false;
                break;
            }
            if (!flag.booleanValue()) continue;
            updateParentColl.add(account);
        }
        if (!canSet.isEmpty()) {
            ArrayList lst = new ArrayList(canSet);
            IObjectPK[] pkArrays = new IObjectPK[canSet.size()];
            int in3 = lst.size();
            for (int i = 0; i < in3; ++i) {
                pkArrays[i] = new ObjectUuidPK((String)lst.get(i));
            }
            super._deleteBatchData(ctx, pkArrays);
        }
        if (!updateParentColl.isEmpty()) {
            this.updateParent(ctx, (IObjectCollection)updateParentColl, true);
        }
        canSet.removeAll(idset);
        BgDimCacheUtils.clearElementCache(ctx);
        return result;
    }

    private void updateParent(Context ctx, IObjectCollection colls, boolean isLeaf) throws BOSException {
        BgElementInfo version = null;
        BgElementInfo parentInfo = null;
        ArrayList<String> parentIDS = new ArrayList<String>();
        int in = colls.size();
        for (int i = 0; i < in; ++i) {
            version = (BgElementInfo)colls.getObject(i);
            if (version.getParent() == null || (parentInfo = version.getParent()).getId() == null) continue;
            parentIDS.add(parentInfo.getId().toString());
        }
        if (!parentIDS.isEmpty()) {
            PreparedStatement pstmt;
            Connection conn;
            block11: {
                int i;
                conn = null;
                pstmt = null;
                int batchSize = 50;
                int batchIndex = 0;
                int size = parentIDS.size();
                int count = (size - 1) / batchSize + 1;
                int pos = 0;
                int value = isLeaf ? 1 : 0;
                StringBuffer sql = new StringBuffer("update T_MBG_BgElement set FIsLeaf = ? where FID in ( ");
                for (i = 1; i < batchSize; ++i) {
                    sql.append("?,");
                }
                sql.append("?)");
                try {
                    conn = this.getConnection(ctx);
                    pstmt = conn.prepareStatement(sql.toString());
                    for (i = 0; i < count; ++i) {
                        pstmt.setInt(1, value);
                        int j = 2;
                        while (j <= batchSize + 1) {
                            if (pos < size) {
                                pstmt.setString(j, (String)parentIDS.get(pos));
                            } else {
                                pstmt.setString(j, "#");
                            }
                            ++j;
                            ++pos;
                        }
                        pstmt.addBatch();
                        if (++batchIndex < batchSize) continue;
                        pstmt.executeBatch();
                        batchIndex = 0;
                    }
                    if (batchIndex == 0) break block11;
                    pstmt.executeBatch();
                }
                catch (SQLException e) {
                    try {
                        logger.error((Object)e);
                        throw new BOSException(e.getMessage());
                    }
                    catch (Throwable throwable) {
                        SQLUtils.cleanup(pstmt, (Connection)conn);
                        throw throwable;
                    }
                }
            }
            SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
        }
    }

    @Override
    protected IObjectPK _import4element(Context ctx, IObjectValue element) throws BOSException, EASBizException {
        this.updateStyleSetElement(ctx, element);
        return super._save(ctx, element);
    }
}

