/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.base.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.TreeBaseException;
import com.kingdee.eas.ma.base.BgException;
import com.kingdee.eas.ma.base.BgItemAllocationParameter;
import com.kingdee.eas.ma.base.BgItemCollection;
import com.kingdee.eas.ma.base.BgItemException;
import com.kingdee.eas.ma.base.BgItemFactory;
import com.kingdee.eas.ma.base.BgItemInfo;
import com.kingdee.eas.ma.base.BgItemRelationCollection;
import com.kingdee.eas.ma.base.BgItemRelationFactory;
import com.kingdee.eas.ma.base.BgItemRelationInfo;
import com.kingdee.eas.ma.base.IBgItem;
import com.kingdee.eas.ma.base.IBgItemRelation;
import com.kingdee.eas.ma.base.app.AbstractBgItemControllerBean;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class BgItemControllerBean
extends AbstractBgItemControllerBean {
    private static final long serialVersionUID = -6444264250607396614L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.base.app.BgItemControllerBean");

    protected IBgItem getInterface(Context ctx) throws BOSException {
        return BgItemFactory.getLocalInstance(ctx);
    }

    protected FilterInfo getFilterForDefaultCU(Context ctx, IObjectValue model) {
        return new FilterInfo();
    }

    protected IBgItemRelation getRelInterface(Context ctx) throws BOSException {
        return BgItemRelationFactory.getLocalInstance(ctx);
    }

    protected void _checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        if (ctx == null || model == null) {
            return;
        }
        BgItemInfo itemInfo = (BgItemInfo)model;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("bgItemGroup.id", (Object)itemInfo.getBgItemGroup().getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)itemInfo.getNumber(), CompareType.EQUALS));
        view.setFilter(filter);
        BgItemCollection results = this.getBgItemCollection(ctx, view);
        if (results != null && results.size() > 0) {
            throw new TreeBaseException(TreeBaseException.CHECKNUMBERDUPLICATED, new Object[]{itemInfo.getNumber()});
        }
    }

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        IObjectPK pk = super._addnew(ctx, model);
        if (pk != null) {
            BgItemInfo itemInfo = (BgItemInfo)model;
            BgItemRelationInfo relationInfo = new BgItemRelationInfo();
            relationInfo.setBgItem(itemInfo);
            relationInfo.setOrgUnitID(itemInfo.getOrgUnit().getId());
            relationInfo.setIsEffective(true);
            this.getRelInterface(ctx).addnew(relationInfo);
        }
        return pk;
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        if (ctx == null || pk == null) {
            return;
        }
        String bgItemId = pk.toString();
        if (!this.checkIsLeaf(ctx, bgItemId)) {
            throw new BgItemException(BgItemException.CANTDELETENOTISLEAF);
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("parent.id");
        BgItemInfo itemInfo = (BgItemInfo)this._getValue(ctx, pk, sic);
        super._delete(ctx, pk);
        this.removeBgItemRelation(ctx, pk);
        if (itemInfo.getParent() != null && this.checkIsLeaf(ctx, itemInfo.getParent().getId().toString())) {
            BgItemInfo parent = itemInfo.getParent();
            parent.setIsLeaf(true);
            SelectorItemCollection _sic = new SelectorItemCollection();
            _sic.add("isLeaf");
            this._updatePartial(ctx, (IObjectValue)parent, _sic);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean checkIsLeaf(Context ctx, String bgItemId) throws BOSException, EASBizException {
        if (ctx == null) return false;
        if (StringUtils.isEmpty((String)bgItemId)) {
            return false;
        }
        boolean re = true;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement("select TOP 1 FID From T_MBG_BgItem where FParentID = ?");
            pstmt.setString(1, bgItemId);
            rst = pstmt.executeQuery();
            re = !rst.next();
        }
        catch (BOSException ex) {
            try {
                throw ex;
                catch (SQLException ex2) {
                    throw new BgException(BgException.DATABASEERROR, new String[]{ex2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return re;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean _checkDelete(Context ctx, List bgItemIds, BOSUuid orgUnitId) throws BOSException, EASBizException {
        if (ctx == null || bgItemIds == null || bgItemIds.isEmpty() || orgUnitId == null) {
            return false;
        }
        List<Object> billIds = new ArrayList();
        StringBuffer sql = new StringBuffer();
        sql.append("select top 1 FID from T_MBG_BgItemRelation where FBgItemID in(");
        for (int i = 1; i < 50; ++i) {
            sql.append("?,");
        }
        sql.append("?) and FROOTID IS NOT NULL");
        Connection conn = null;
        boolean re = true;
        try {
            conn = this.getConnection(ctx);
            billIds = this.queryBgItemRefInfo(conn, sql.toString(), bgItemIds, orgUnitId);
            if (!billIds.isEmpty()) {
                re = false;
            }
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        return re;
    }

    private List<String> queryBgItemRefInfo(Connection conn, String sql, List<String> bgItemIds, BOSUuid orgUnitId) throws BOSException {
        ArrayList<String> billIds = new ArrayList<String>();
        if (conn == null || bgItemIds == null || sql == null) {
            return billIds;
        }
        int batchSize = 50;
        int size = bgItemIds.size();
        int count = (size - 1) / batchSize + 1;
        int pos = 0;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            pstmt = conn.prepareStatement(sql);
            for (int index = 0; index < count; ++index) {
                int x = 1;
                while (x <= batchSize) {
                    if (pos < size) {
                        pstmt.setString(x, bgItemIds.get(pos));
                    } else {
                        pstmt.setString(x, BgBaseConstants.noFindStr);
                    }
                    ++x;
                    ++pos;
                }
                pstmt.setString(batchSize, orgUnitId.toString());
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    billIds.add(rst.getString(1));
                }
                SQLUtils.cleanup((ResultSet)rst);
            }
        }
        catch (SQLException ex) {
            logger.error((Object)"", (Throwable)ex);
            throw new BOSException((Throwable)ex);
        }
        finally {
            SQLUtils.cleanup(rst, (Statement)pstmt);
        }
        return billIds;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void removeBgItemRelation(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        if (ctx == null) return;
        if (pk == null) {
            return;
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement("delete from T_MBG_BgItemRelation where FBgItemID = ?");
            pstmt.setString(1, pk.toString());
            pstmt.executeUpdate();
        }
        catch (SQLDataException ex) {
            try {
                throw ex;
                catch (SQLException ex2) {
                    throw new BgException(BgException.DATABASEERROR, new String[]{ex2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    @Override
    protected boolean _enable(Context ctx, BOSUuid bgItemID, BOSUuid orgUnitID) throws BOSException, EASBizException {
        return this.updateItemState(ctx, bgItemID, orgUnitID, true);
    }

    @Override
    protected boolean _disable(Context ctx, BOSUuid bgItemID, BOSUuid orgUnitID) throws BOSException, EASBizException {
        return this.updateItemState(ctx, bgItemID, orgUnitID, false);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean updateItemState(Context ctx, BOSUuid bgItemID, BOSUuid orgUnitID, boolean isEffective) throws BOSException, EASBizException {
        ResultSet rst;
        PreparedStatement pstmt;
        Connection conn;
        block9: {
            if (bgItemID == null) return false;
            if (orgUnitID == null) {
                return false;
            }
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("id");
            sic.add("number");
            sic.add("longnumber");
            sic.add("bgItemGroup.id");
            sic.add("bgItemGroup.global");
            BgItemInfo itemInfo = null;
            ArrayList<String> billIds = new ArrayList<String>();
            conn = null;
            pstmt = null;
            rst = null;
            try {
                conn = this.getConnection(ctx);
                itemInfo = (BgItemInfo)this._getValue(ctx, (IObjectPK)new ObjectUuidPK(bgItemID), sic);
                if (itemInfo == null) break block9;
                pstmt = conn.prepareStatement("select FID from T_MBG_BgItem where FBgItemGroupId = ? and (FNumber = ? OR FLongNumber like ?)");
                pstmt.setString(1, itemInfo.getBgItemGroup().getId().toString());
                pstmt.setString(2, itemInfo.getNumber());
                pstmt.setString(3, itemInfo.getLongNumber() + "!%");
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    billIds.add(rst.getString("FID"));
                }
                if (itemInfo.getBgItemGroup().isGlobal()) {
                    this.updateItemState(ctx, conn, billIds, isEffective);
                } else {
                    this.updateItemState(ctx, conn, billIds, orgUnitID, isEffective);
                }
            }
            catch (SQLException ex) {
                try {
                    logger.error((Object)"update BgItem Error:", (Throwable)ex);
                    throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
                    catch (SQLDataException ex2) {
                        throw new BOSException((Throwable)ex2);
                    }
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                    throw throwable;
                }
            }
        }
        SQLUtils.cleanup(rst, (Statement)pstmt, (Connection)conn);
        return true;
    }

    protected void updateItemState(Context ctx, Connection conn, List<String> billIds, BOSUuid orgUnitId, boolean isEffective) throws EASBizException {
        if (ctx == null || conn == null || billIds == null || billIds.isEmpty()) {
            return;
        }
        String sql = "update T_MBG_BgItemRelation set FISEFFECTIVE = ? where FBGITEMID = ? and FORGUNITID = ?";
        int batchIndex = 0;
        int batchSize = 100;
        PreparedStatement pstmt = null;
        try {
            pstmt = conn.prepareStatement(sql);
            int in = billIds.size();
            for (int i = 0; i < in; ++i) {
                pstmt.setBoolean(1, isEffective);
                pstmt.setString(2, billIds.get(i));
                pstmt.setString(3, orgUnitId.toString());
                pstmt.addBatch();
                if (++batchIndex < batchSize) continue;
                pstmt.executeBatch();
                batchIndex = 0;
            }
            if (batchIndex > 0) {
                pstmt.executeBatch();
            }
        }
        catch (SQLException ex) {
            logger.error((Object)"update BgItem Error:", (Throwable)ex);
            throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
        }
        finally {
            SQLUtils.cleanup((Statement)pstmt);
        }
    }

    protected void updateItemState(Context ctx, Connection conn, List<String> billIds, boolean isEffective) throws EASBizException {
        if (ctx == null || conn == null || billIds == null || billIds.isEmpty()) {
            return;
        }
        String sql = "update T_MBG_BgItemRelation set FISEFFECTIVE = ? where FBGITEMID = ?";
        int batchIndex = 0;
        int batchSize = 100;
        PreparedStatement pstmt = null;
        try {
            pstmt = conn.prepareStatement(sql);
            int in = billIds.size();
            for (int i = 0; i < in; ++i) {
                pstmt.setBoolean(1, isEffective);
                pstmt.setString(2, billIds.get(i));
                pstmt.addBatch();
                if (++batchIndex < batchSize) continue;
                pstmt.executeBatch();
                batchIndex = 0;
            }
            if (batchIndex > 0) {
                pstmt.executeBatch();
            }
        }
        catch (SQLException ex) {
            logger.error((Object)"update BgItem Error:", (Throwable)ex);
            throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
        }
        finally {
            SQLUtils.cleanup((Statement)pstmt);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Object _allocation(Context ctx, Object parameter) throws BOSException, EASBizException {
        if (ctx == null || !(parameter instanceof BgItemAllocationParameter)) {
            return false;
        }
        ArrayList result = new ArrayList();
        BgItemAllocationParameter param = (BgItemAllocationParameter)parameter;
        HashMap<String, CostCenterOrgUnitInfo> relOrgUnit = new HashMap<String, CostCenterOrgUnitInfo>();
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement("select org.FID, org.FName_" + ctx.getLocale() + " from T_MBG_BgItemRelation itemM, T_Org_CostCenter org where itemM.FOrgUnitId = org.FID and itemM.FBgItemID = ?");
            pstmt.setString(1, param.getItemInfo().getId().toString());
            rst = pstmt.executeQuery();
            while (rst.next()) {
                CostCenterOrgUnitInfo org = new CostCenterOrgUnitInfo();
                org.setId(BOSUuid.read((String)rst.getString(1)));
                org.setName(rst.getString(2));
                relOrgUnit.put(org.getId().toString(), org);
            }
        }
        catch (SQLDataException ex) {
            try {
                throw new BOSException((Throwable)ex);
                catch (SQLException ex2) {
                    logger.error((Object)"allocation Error:", (Throwable)ex2);
                    throw new BgException(BgException.DATABASEERROR, new String[]{ex2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        BOSUuid orgUnitId = null;
        BgItemRelationInfo relationInfo = null;
        CoreBaseCollection colls = new CoreBaseCollection();
        BgItemRelationInfo tmpRel = param.getItemInfo().getRelation().get(0);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("bgItem.id", (Object)param.getItemInfo().getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("orgUnitID", (Object)tmpRel.getOrgUnitID().toString(), CompareType.EQUALS));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("bgItem.id");
        sic.add("orgUnitID");
        sic.add("isEffective");
        sic.add("parentId");
        sic.add("rootId");
        view.getSelector().addObjectCollection((IObjectCollection)sic);
        BgItemRelationCollection relColls = BgItemRelationFactory.getLocalInstance(ctx).getBgItemRelationCollection(view);
        if (relColls != null) {
            tmpRel = relColls.get(0);
            int in = param.getOrgUnits().size();
            for (int i = 0; i < in; ++i) {
                orgUnitId = param.getOrgUnits().get(i);
                if (!relOrgUnit.containsKey(orgUnitId.toString())) {
                    relationInfo = new BgItemRelationInfo();
                    relationInfo.setId(BOSUuid.create((BOSObjectType)relationInfo.getBOSType()));
                    relationInfo.setBgItem(param.getItemInfo());
                    relationInfo.setOrgUnitID(orgUnitId);
                    relationInfo.setIsEffective(tmpRel.isIsEffective());
                    relationInfo.setParentId(tmpRel.getId());
                    if (tmpRel.getRootId() != null) {
                        relationInfo.setRootId(tmpRel.getRootId());
                    } else {
                        relationInfo.setRootId(tmpRel.getId());
                    }
                    colls.add((CoreBaseInfo)relationInfo);
                    continue;
                }
                result.add(relOrgUnit.get(orgUnitId.toString()));
            }
            BgItemRelationFactory.getLocalInstance(ctx).addnewBatchData(colls);
        }
        return result;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Object _unAllocation(Context ctx, Object parameter) throws BOSException, EASBizException {
        if (ctx == null) return false;
        if (!(parameter instanceof BgItemAllocationParameter)) {
            return false;
        }
        BgItemAllocationParameter param = (BgItemAllocationParameter)parameter;
        String bgItemId = null;
        String orgUnitId = null;
        ArrayList<String> bgItemIds = new ArrayList<String>();
        int batchSize = 50;
        int batchIndex = 0;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement("select FID from T_MBG_BgItem where FLongNumber = ? or FLongNumber like ?");
            pstmt.setString(1, param.getItemInfo().getLongNumber());
            pstmt.setString(2, param.getItemInfo().getLongNumber() + "!%");
            rst = pstmt.executeQuery();
            while (rst.next()) {
                bgItemIds.add(rst.getString(1));
            }
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
            pstmt = conn.prepareStatement("delete from T_MBG_BgItemRelation where FBgItemID = ? and FOrgUnitID = ?");
            int xn = bgItemIds.size();
            for (int x = 0; x < xn; ++x) {
                bgItemId = (String)bgItemIds.get(x);
                pstmt.setString(1, bgItemId);
                int in = param.getOrgUnits().size();
                for (int i = 0; i < in; ++i) {
                    orgUnitId = param.getOrgUnits().get(i).toString();
                    pstmt.setString(2, orgUnitId);
                    pstmt.addBatch();
                    if (++batchIndex < batchSize) continue;
                    pstmt.executeBatch();
                    batchIndex = 0;
                }
            }
            if (batchIndex > 0) {
                pstmt.executeBatch();
            }
        }
        catch (SQLDataException ex) {
            try {
                throw new BOSException((Throwable)ex);
                catch (SQLException ex2) {
                    logger.error((Object)"allocation Error:", (Throwable)ex2);
                    throw new BgException(BgException.DATABASEERROR, new String[]{ex2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
        return true;
    }

    @Override
    protected List _checkAllocation(Context ctx, List bgItemIds) throws BOSException, EASBizException {
        int index;
        ArrayList<String> orgUnitIds = new ArrayList<String>();
        if (bgItemIds == null || bgItemIds.isEmpty()) {
            return orgUnitIds;
        }
        int batchSize = 50;
        int size = bgItemIds.size();
        int count = (size - 1) / batchSize + 1;
        int pos = 0;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        StringBuffer sql = new StringBuffer();
        sql.append("select distinct FOrgUnitId from T_MBG_BgItemRelation where FBgItemID IN (");
        for (index = 1; index < batchSize; ++index) {
            sql.append("?,");
        }
        sql.append("?)");
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            for (index = 0; index < count; ++index) {
                int x = 1;
                while (x <= batchSize) {
                    if (pos < size) {
                        pstmt.setString(x, (String)bgItemIds.get(pos));
                    } else {
                        pstmt.setString(x, BgBaseConstants.noFindStr);
                    }
                    ++x;
                    ++pos;
                }
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    orgUnitIds.add(rst.getString(1));
                }
                SQLUtils.cleanup((ResultSet)rst);
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)ex);
                throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rst, (Statement)pstmt, (Connection)conn);
        return orgUnitIds;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected String _getMaxNumber(Context ctx, String firstNumber) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)firstNumber)) {
            return null;
        }
        String result = null;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement("select top 1 fid, fnumber from T_MBG_BgItem where fnumber like ? order by fnumber desc");
            pstmt.setString(1, firstNumber + "%");
            rs = pstmt.executeQuery();
            if (rs.next()) {
                result = rs.getString("fnumber");
            }
        }
        catch (SQLDataException ex) {
            try {
                throw new BOSException((Throwable)ex);
                catch (SQLException ex2) {
                    logger.error((Object)"getMaxNumber Error:", (Throwable)ex2);
                    throw new BgException(BgException.DATABASEERROR, new String[]{ex2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
        return result;
    }

    @Override
    protected String _getNumber(Context ctx, String number) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)number)) {
            return number;
        }
        String maxNumber = null;
        int lastNoNumber = -1;
        int i = number.length() - 1;
        while (i >= 0 && Character.isDigit(number.charAt(i))) {
            lastNoNumber = i--;
        }
        if (lastNoNumber < 0) {
            return number;
        }
        StringBuffer fString = new StringBuffer();
        for (int i2 = lastNoNumber; i2 < number.length(); ++i2) {
            fString.append("0");
        }
        DecimalFormat format = new DecimalFormat(fString.toString());
        String prev = "";
        if (lastNoNumber > 0) {
            prev = number.substring(0, lastNoNumber);
            number = number.substring(lastNoNumber);
        }
        int val = Integer.parseInt(number);
        IBgItem iBgItem = BgItemFactory.getLocalInstance(ctx);
        try {
            FilterInfo filter = new FilterInfo();
            do {
                maxNumber = prev + format.format(++val);
                filter.getFilterItems().clear();
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)maxNumber));
            } while (iBgItem.exists(filter));
        }
        catch (Exception e1) {
            maxNumber = "";
        }
        return maxNumber;
    }

    @Override
    protected List _importExcel(Context ctx, IObjectCollection colls) throws BOSException, EASBizException {
        String longNumber;
        ArrayList<String> rs = new ArrayList<String>();
        if (colls == null || colls.isEmpty()) {
            return rs;
        }
        colls.sort("longNumber");
        BgItemInfo info2 = null;
        HashMap<String, BgItemInfo> bgItems = new HashMap<String, BgItemInfo>();
        Iterator it = colls.iterator();
        while (it.hasNext()) {
            info2 = (BgItemInfo)it.next();
            String ln = null;
            if (!StringUtils.isEmpty((String)info2.getLongNumber())) {
                ln = info2.getLongNumber().indexOf("!") > 0 ? info2.getLongNumber().substring(info2.getLongNumber().lastIndexOf("!") + 1) : info2.getLongNumber();
            }
            if (ln == null || !ln.equals(info2.getNumber())) {
                rs.add(info2.getId().toString());
                it.remove();
                continue;
            }
            try {
                this._checkNumberDup(ctx, (IObjectValue)info2);
                bgItems.put(info2.getLongNumber(), info2);
            }
            catch (Exception e) {
                rs.add(info2.getId().toString());
                it.remove();
            }
        }
        HashSet<String> costNumbers = new HashSet<String>();
        HashSet<String> longNumbers = new HashSet<String>();
        for (BgItemInfo info2 : colls) {
            if (costNumbers.isEmpty()) {
                costNumbers.addAll(Arrays.asList(info2.getOrgUnit().getLongNumber().split("!")));
            }
            if (info2.getLongNumber().indexOf("!") <= 0 || bgItems.containsKey(longNumber = info2.getLongNumber().substring(0, info2.getLongNumber().lastIndexOf("!")))) continue;
            longNumbers.add(longNumber);
        }
        if (!longNumbers.isEmpty()) {
            EntityViewInfo evi = new EntityViewInfo();
            evi.setSelector(new SelectorItemCollection());
            evi.getSelector().add("id");
            evi.getSelector().add("number");
            evi.getSelector().add("name");
            evi.getSelector().add("longNumber");
            evi.setFilter(new FilterInfo());
            evi.getFilter().getFilterItems().add(new FilterItemInfo("longNumber", longNumbers, CompareType.INCLUDE));
            evi.getFilter().getFilterItems().add(new FilterItemInfo("orgUnit.number", costNumbers, CompareType.INCLUDE));
            BgItemCollection col = this.getBgItemCollection(ctx, evi);
            if (col != null) {
                for (int i = 0; i < col.size(); ++i) {
                    bgItems.put(col.get(i).getLongNumber(), col.get(i));
                }
            }
        }
        Iterator it2 = colls.iterator();
        while (it2.hasNext()) {
            info2 = (BgItemInfo)it2.next();
            if (info2.getLongNumber().indexOf("!") <= 0) continue;
            longNumber = info2.getLongNumber().substring(0, info2.getLongNumber().lastIndexOf("!"));
            if (bgItems.containsKey(longNumber)) {
                info2.setParent((BgItemInfo)bgItems.get(longNumber));
                continue;
            }
            rs.add(info2.getId().toString());
            it2.remove();
            if (bgItems.get(info2.getLongNumber()) != info2) continue;
            bgItems.remove(info2.getLongNumber());
        }
        for (int index = 0; index < colls.size(); ++index) {
            info2 = (BgItemInfo)colls.getObject(index);
            try {
                this._addnew(ctx, (IObjectValue)info2);
                continue;
            }
            catch (Exception e) {
                rs.add(info2.getId().toString());
            }
        }
        return rs;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean _checkHasChild(Context ctx, String number, String bgItemGrouId) throws BOSException, EASBizException {
        if (ctx == null) return false;
        if (StringUtils.isEmpty((String)number)) {
            return false;
        }
        boolean re = false;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement("select TOP 1 FID From T_MBG_BgItem where FParentID=(select FID From T_MBG_BgItem where fnumber=? and FBgItemGroupId = ?)");
            pstmt.setString(1, number);
            pstmt.setString(2, bgItemGrouId);
            rst = pstmt.executeQuery();
            re = rst.next();
        }
        catch (BOSException ex) {
            try {
                throw ex;
                catch (SQLException ex2) {
                    logger.error((Object)"", (Throwable)ex2);
                    throw new BOSException((Throwable)ex2);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return re;
    }

    @Override
    protected boolean _checkRefDim(Context ctx, BOSUuid id) throws BOSException, EASBizException {
        ResultSet rs;
        PreparedStatement pmst;
        Connection conn;
        block4: {
            boolean bl;
            conn = null;
            pmst = null;
            rs = null;
            try {
                conn = this.getConnection(ctx);
                pmst = conn.prepareStatement("SELECT FID FROM T_MBG_DimSrc WHERE FSrcID=?");
                pmst.setString(1, id.toString());
                rs = pmst.executeQuery();
                if (!rs.next()) break block4;
                bl = false;
            }
            catch (SQLException ex) {
                try {
                    throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs, pmst, (Connection)conn);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)pmst, (Connection)conn);
            return bl;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pmst, (Connection)conn);
        return true;
    }
}

