/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.base.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ObjectSingleKey;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.ma.base.BgException;
import com.kingdee.eas.ma.base.BgPeriodCollection;
import com.kingdee.eas.ma.base.BgPeriodDispCollection;
import com.kingdee.eas.ma.base.BgPeriodDispFactory;
import com.kingdee.eas.ma.base.BgPeriodDispInfo;
import com.kingdee.eas.ma.base.BgPeriodException;
import com.kingdee.eas.ma.base.BgPeriodFactory;
import com.kingdee.eas.ma.base.BgPeriodInfo;
import com.kingdee.eas.ma.base.BgPeriodTypeFactory;
import com.kingdee.eas.ma.base.BgPeriodTypeInfo;
import com.kingdee.eas.ma.base.IBgPeriod;
import com.kingdee.eas.ma.base.IBgPeriodDisp;
import com.kingdee.eas.ma.base.app.AbstractBgPeriodControllerBean;
import com.kingdee.eas.ma.base.utils.BgNPeriodHelper;
import com.kingdee.eas.ma.base.utils.BgPeriodHelper;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class BgPeriodControllerBean
extends AbstractBgPeriodControllerBean {
    private static final long serialVersionUID = 8575691016838748333L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.base.app.BgPeriodControllerBean");

    protected FilterInfo getFilterForDefaultCU(Context ctx, IObjectValue model) {
        return new FilterInfo();
    }

    protected FilterInfo getFilterForDefaultCU(IObjectValue model) {
        return new FilterInfo();
    }

    protected void _deleteBatchData(Context ctx, IObjectPK[] pkArray) throws BOSException, EASBizException {
        if (pkArray == null || pkArray.length == 0) {
            return;
        }
        List<BgPeriodInfo> periods = this.getBgPeriodInfos(ctx, pkArray);
        if (BgPeriodDispFactory.getLocalInstance(ctx).isUse(periods)) {
            throw new BgPeriodException(BgPeriodException.ISUSE);
        }
        super._deleteBatchData(ctx, pkArray);
    }

    @Override
    protected boolean _deleteYearPeriod(Context ctx, int year) throws BOSException, EASBizException {
        List<BgPeriodInfo> periods = this.getBgPeriodInfos(ctx, year);
        if (BgPeriodDispFactory.getLocalInstance(ctx).isUse(periods)) {
            throw new BgPeriodException(BgPeriodException.ISUSE);
        }
        this.deleteYearSubPeriod(ctx, year);
        return true;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected List<BgPeriodInfo> getBgPeriodInfos(Context ctx, IObjectPK[] pks) throws EASBizException, BOSException {
        ArrayList<BgPeriodInfo> periods = new ArrayList<BgPeriodInfo>();
        if (ctx == null) return periods;
        if (pks == null) return periods;
        if (pks.length == 0) {
            return periods;
        }
        int batchNum = 50;
        int size = pks.length;
        int count = (size - 1) / batchNum + 1;
        int pos = 0;
        BgPeriodInfo periodInfo = null;
        ArrayList<String> periodIds = new ArrayList<String>();
        int in = pks.length;
        for (int i = 0; i < in; ++i) {
            periodIds.add(pks[i].toString());
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select FID, FLongNumber from T_MBG_BgPeriod where FID in (");
        for (int index = 1; index < batchNum; ++index) {
            sql.append("?,");
        }
        sql.append("?)");
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            for (int index = 0; index < count; ++index) {
                for (int x = 1; x <= batchNum; ++x, ++pos) {
                    if (pos < size) {
                        pstmt.setString(x, (String)periodIds.get(pos));
                        continue;
                    }
                    pstmt.setString(x, "#");
                }
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    periodInfo = new BgPeriodInfo();
                    periodInfo.setId(BOSUuid.read((String)rst.getString("FID")));
                    periodInfo.setLongNumber(rst.getString("FLongNumber"));
                    periods.add(periodInfo);
                }
                SQLUtils.cleanup((ResultSet)rst);
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"delete BgPeriod Error:", (Throwable)ex);
                throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
                catch (SQLDataException ex2) {
                    throw new BOSException((Throwable)ex2);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rst, (Statement)pstmt, (Connection)conn);
        return periods;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected List<BgPeriodInfo> getBgPeriodInfos(Context ctx, int year) throws EASBizException, BOSException {
        ArrayList<BgPeriodInfo> periods = new ArrayList<BgPeriodInfo>();
        BgPeriodInfo periodInfo = null;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement("select FID, FLongNumber from T_MBG_BgPeriod where FYear = ?");
            pstmt.setInt(1, year);
            rst = pstmt.executeQuery();
            while (rst.next()) {
                periodInfo = new BgPeriodInfo();
                periodInfo.setId(BOSUuid.read((String)rst.getString("FID")));
                periodInfo.setLongNumber(rst.getString("FLongNumber"));
                periods.add(periodInfo);
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"delete BgPeriod Error:", (Throwable)ex);
                throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
                catch (SQLDataException ex2) {
                    throw new BOSException((Throwable)ex2);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return periods;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void deleteSubPeriod(Context ctx, List<BgPeriodInfo> periods) throws BOSException, EASBizException {
        if (periods == null) return;
        if (periods.isEmpty()) {
            return;
        }
        BgPeriodInfo periodInfo = null;
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement("delete from T_MBG_BgPeriod where FLongNumber like ?");
            int in = periods.size();
            for (int i = 0; i < in; ++i) {
                periodInfo = periods.get(i);
                pstmt.setString(1, periodInfo.getLongNumber() + "%");
                pstmt.executeUpdate();
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"delete BgPeriod Error:", (Throwable)ex);
                throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
                catch (SQLDataException ex2) {
                    throw new BOSException((Throwable)ex2);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void deleteYearSubPeriod(Context ctx, int year) throws BOSException, EASBizException {
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement("delete from T_MBG_BgPeriod where FYear = ?");
            pstmt.setInt(1, year);
            pstmt.executeUpdate();
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"delete BgPeriod Error:", (Throwable)ex);
                throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
                catch (SQLDataException ex2) {
                    throw new BOSException((Throwable)ex2);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    @Override
    protected IObjectCollection _getPeriodCollection(Context ctx, BOSUuid sId, BOSUuid eId) throws BOSException, EASBizException {
        BgPeriodCollection bgPeriodCol = new BgPeriodCollection();
        if (sId == null || eId == null) {
            return bgPeriodCol;
        }
        ObjectUuidPK sPk = new ObjectUuidPK(sId);
        ObjectUuidPK ePk = new ObjectUuidPK(eId);
        IBgPeriod iBgPeriod = BgPeriodFactory.getLocalInstance(ctx);
        if (sPk != null && ePk != null && iBgPeriod != null) {
            BgPeriodInfo sBgPeriod = null;
            BgPeriodInfo eBgPeriod = null;
            try {
                if (iBgPeriod.exists((IObjectPK)sPk)) {
                    sBgPeriod = iBgPeriod.getBgPeriodInfo((IObjectPK)sPk);
                }
                if (iBgPeriod.exists((IObjectPK)ePk)) {
                    eBgPeriod = iBgPeriod.getBgPeriodInfo((IObjectPK)ePk);
                }
                if (sBgPeriod != null && eBgPeriod != null && sBgPeriod.getPeriodType().equals((Object)eBgPeriod.getPeriodType())) {
                    int type = sBgPeriod.getPeriodType().getValue();
                    if (type == 8) {
                        bgPeriodCol.add(sBgPeriod);
                    } else {
                        Date beginDate = BgNPeriodHelper.getDayBegin(sBgPeriod.getBeginDate());
                        Date endDate = BgNPeriodHelper.getDayEnd(eBgPeriod.getEndDate());
                        bgPeriodCol = BgPeriodHelper.getPeriodColInfo(ctx, beginDate, endDate, type);
                    }
                }
            }
            catch (BOSException ex) {
                throw new BgPeriodException(BgPeriodException.FINDERROR);
            }
            catch (Exception e) {
                logger.error((Object)"budget error:", (Throwable)e);
            }
        }
        return bgPeriodCol;
    }

    @Override
    protected void _saveSpinnerWeek(Context ctx, List addNew, List update, List delete, String bgPeriodTypeId) throws BOSException, EASBizException {
        BgPeriodDispInfo bgPeriodDispInfo;
        BgPeriodDispCollection bgPeriodDispColl;
        List bgPeriods;
        CoreBaseCollection corebaseColl = new CoreBaseCollection();
        CoreBaseCollection corebaseDispColl = new CoreBaseCollection();
        ArrayList<ObjectStringPK> pks = new ArrayList<ObjectStringPK>();
        HashMap<String, BgPeriodDispInfo> result = new HashMap<String, BgPeriodDispInfo>();
        HashMap<String, BgPeriodInfo> bgPeriodMap = new HashMap<String, BgPeriodInfo>();
        IBgPeriodDisp dispInstance = BgPeriodDispFactory.getLocalInstance(ctx);
        BgPeriodTypeInfo bgPeriodType = BgPeriodTypeFactory.getLocalInstance(ctx).getBgPeriodTypeInfo((IObjectPK)new ObjectSingleKey((Object)bgPeriodTypeId));
        if (addNew != null && !addNew.isEmpty()) {
            bgPeriods = addNew;
            this.queryAddNewParentPeriod(bgPeriodTypeId, bgPeriods, dispInstance, result);
            for (BgPeriodInfo object : bgPeriods) {
                corebaseColl.add((CoreBaseInfo)object);
                BgPeriodDispInfo disp = BgPeriodHelper.convert2BgPeriodDisp(object, bgPeriodType);
                disp.setParent((BgPeriodDispInfo)result.get(disp.getLongNumber().substring(0, disp.getLongNumber().lastIndexOf("!"))));
                corebaseDispColl.add((CoreBaseInfo)disp);
            }
            this.addnewBatchData(ctx, corebaseColl);
            dispInstance.addnewBatchData(corebaseDispColl);
        }
        if (delete != null && !delete.isEmpty()) {
            bgPeriods = delete;
            for (BgPeriodInfo info : bgPeriods) {
                pks.add(new ObjectStringPK(info.getId().toString()));
            }
            this.deleteBatchData(ctx, (IObjectPK[])pks.toArray(new ObjectStringPK[pks.size()]));
            pks.clear();
            bgPeriodDispColl = this.getBgPeriodDispColl(delete, bgPeriodTypeId, dispInstance, true);
            int in = bgPeriodDispColl.size();
            for (int i = 0; i < in; ++i) {
                bgPeriodDispInfo = bgPeriodDispColl.get(i);
                pks.add(new ObjectStringPK(bgPeriodDispInfo.getId().toString()));
            }
            dispInstance.deleteBatchData((IObjectPK[])pks.toArray(new ObjectStringPK[pks.size()]));
        }
        if (update != null && !update.isEmpty()) {
            corebaseColl.clear();
            bgPeriods = update;
            for (BgPeriodInfo info : bgPeriods) {
                bgPeriodMap.put(info.getId().toString(), info);
                corebaseColl.add((CoreBaseInfo)info);
            }
            this.updateBatchData(ctx, corebaseColl);
            corebaseDispColl.clear();
            bgPeriodDispColl = this.getBgPeriodDispColl(update, bgPeriodTypeId, dispInstance, false);
            Iterator iter = bgPeriodDispColl.iterator();
            while (iter.hasNext()) {
                bgPeriodDispInfo = (BgPeriodDispInfo)iter.next();
                if (bgPeriodMap.containsKey(bgPeriodDispInfo.getBgPeriod().getId().toString())) {
                    BgPeriodInfo bgPeriodInfo = (BgPeriodInfo)bgPeriodMap.get(bgPeriodDispInfo.getBgPeriod().getId().toString());
                    bgPeriodDispInfo.setCreateTime(bgPeriodInfo.getCreateTime());
                    bgPeriodDispInfo.setCreator(bgPeriodInfo.getCreator());
                    bgPeriodDispInfo.setLastUpdateTime(bgPeriodInfo.getLastUpdateTime());
                    bgPeriodDispInfo.setLastUpdateUser(bgPeriodInfo.getLastUpdateUser());
                    bgPeriodDispInfo.setBeginDate(bgPeriodInfo.getBeginDate());
                    bgPeriodDispInfo.setEndDate(bgPeriodInfo.getEndDate());
                }
                corebaseDispColl.add((CoreBaseInfo)bgPeriodDispInfo);
            }
            dispInstance.updateBatchData(corebaseDispColl);
        }
    }

    private void queryAddNewParentPeriod(String bgPeriodTypeId, List<BgPeriodInfo> bgPeriods, IBgPeriodDisp dispInstance, Map<String, BgPeriodDispInfo> result) throws BOSException {
        HashSet<String> pNumbers = new HashSet<String>();
        for (BgPeriodInfo object : bgPeriods) {
            String[] numbers = object.getLongNumber().split("!");
            pNumbers.add(numbers[numbers.length - 2]);
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.getSelector().add(new SelectorItemInfo("*"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", pNumbers, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("type.id", (Object)bgPeriodTypeId, CompareType.EQUALS));
        evi.setFilter(filter);
        BgPeriodDispCollection col = dispInstance.getBgPeriodDispCollection(evi);
        Iterator iter = col.iterator();
        while (iter.hasNext()) {
            BgPeriodDispInfo bgPeriodDispInfo = (BgPeriodDispInfo)iter.next();
            result.put(bgPeriodDispInfo.getLongNumber(), bgPeriodDispInfo);
        }
    }

    private BgPeriodDispCollection getBgPeriodDispColl(List bgPeriodInfos, String bgPeriodTypeId, IBgPeriodDisp dispInstance, boolean isdeleteState) throws BOSException {
        List bgPeriods = bgPeriodInfos;
        HashSet<String> ids = new HashSet<String>();
        for (BgPeriodInfo info : bgPeriods) {
            ids.add(info.getId().toString());
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.getSelector().add(new SelectorItemInfo("id"));
        if (!isdeleteState) {
            evi.getSelector().add(new SelectorItemInfo("bgPeriod.*"));
            evi.getSelector().add(new SelectorItemInfo("beginDate"));
            evi.getSelector().add(new SelectorItemInfo("endDate"));
            evi.getSelector().add(new SelectorItemInfo("creator"));
            evi.getSelector().add(new SelectorItemInfo("createTime"));
            evi.getSelector().add(new SelectorItemInfo("lastUpdateUser"));
            evi.getSelector().add(new SelectorItemInfo("lastUpdateTime"));
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("bgPeriod.id", ids, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("type.id", (Object)bgPeriodTypeId, CompareType.EQUALS));
        evi.setFilter(filter);
        return dispInstance.getBgPeriodDispCollection(evi);
    }
}

