/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.base.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ContextUtils;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.CanNotDeleteException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.ma.base.BgFiscalYearMonth;
import com.kingdee.eas.ma.base.BgPeriodCollection;
import com.kingdee.eas.ma.base.BgPeriodDispCollection;
import com.kingdee.eas.ma.base.BgPeriodDispFactory;
import com.kingdee.eas.ma.base.BgPeriodDispInfo;
import com.kingdee.eas.ma.base.BgPeriodException;
import com.kingdee.eas.ma.base.BgPeriodFactory;
import com.kingdee.eas.ma.base.BgPeriodInfo;
import com.kingdee.eas.ma.base.BgPeriodInfoFactory;
import com.kingdee.eas.ma.base.BgPeriodTypeCollection;
import com.kingdee.eas.ma.base.BgPeriodTypeFactory;
import com.kingdee.eas.ma.base.BgPeriodTypeInfo;
import com.kingdee.eas.ma.base.BgPeriodYearEnum;
import com.kingdee.eas.ma.base.FiscalYearEnum;
import com.kingdee.eas.ma.base.IBgPeriod;
import com.kingdee.eas.ma.base.IBgPeriodDisp;
import com.kingdee.eas.ma.base.app.AbstractBgPeriodTypeControllerBean;
import com.kingdee.eas.ma.base.utils.BgCommHelper;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.base.utils.BgPeriodHelper;
import com.kingdee.eas.util.EASCommonResource;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgPeriodTypeControllerBean
extends AbstractBgPeriodTypeControllerBean {
    private static final long serialVersionUID = -5354697030625811784L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.base.app.BgPeriodTypeControllerBean");
    private static final String resClassName = "com.kingdee.eas.ma.base.BgPeriodResource";
    private static final Locale localeFromEnv = ContextUtils.getLocaleFromEnv();

    protected FilterInfo getFilterForDefaultCU(Context ctx, IObjectValue model) {
        return new FilterInfo();
    }

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        super._update(ctx, pk, model);
    }

    private String processFiscalYearSet(Context ctx, BgPeriodTypeInfo bgPeriodTypeInfo) throws EASBizException, BOSException {
        int integer;
        int successCount = 0;
        int faildCount = 0;
        StringBuilder detailMsg = new StringBuilder();
        IBgPeriodDisp dispInstance = BgPeriodDispFactory.getLocalInstance(ctx);
        IBgPeriod localInstance = BgPeriodFactory.getLocalInstance(ctx);
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection coll = new SelectorItemCollection();
        coll.add("id");
        coll.add("name");
        coll.add("number");
        view.setSelector(coll);
        BgPeriodInfoFactory factory = new BgPeriodInfoFactory(bgPeriodTypeInfo, ctx.getLocale());
        if (bgPeriodTypeInfo.isYear() && !bgPeriodTypeInfo.isHalfYear()) {
            int startYear = bgPeriodTypeInfo.getStartYear();
            int endYear = bgPeriodTypeInfo.getEndYear();
            for (int selYear = startYear; selYear <= endYear; ++selYear) {
                List<BgPeriodInfo> createBgPeriodTypeOfYear = factory.createBgPeriod(selYear, bgPeriodTypeInfo.isSelfDefined());
                if (this.existsFiscalYear(ctx, (IObjectPK)new ObjectUuidPK(bgPeriodTypeInfo.getId()), selYear, detailMsg)) {
                    ++faildCount;
                    continue;
                }
                Object[] data = (Object[])dispInstance.addBgPeriodByPeriodType(bgPeriodTypeInfo, selYear, selYear, createBgPeriodTypeOfYear);
                successCount += ((Integer)data[0]).intValue();
                faildCount += ((Integer)data[1]).intValue();
                detailMsg.append(data[2]);
            }
        } else if (bgPeriodTypeInfo.isHalfYear() && !bgPeriodTypeInfo.isQuarter()) {
            for (integer = bgPeriodTypeInfo.getStartYear(); integer <= bgPeriodTypeInfo.getEndYear(); ++integer) {
                if (this.existsFiscalYear(ctx, (IObjectPK)new ObjectUuidPK(bgPeriodTypeInfo.getId()), integer, detailMsg)) {
                    ++faildCount;
                    continue;
                }
                HashMap<String, BgPeriodDispInfo> map = new HashMap<String, BgPeriodDispInfo>();
                CoreBaseCollection collection = new CoreBaseCollection();
                CoreBaseCollection periodInfocollection = new CoreBaseCollection();
                List<BgPeriodInfo> createBgPeriodTypeOfHalfYear = factory.createBgPeriod(integer, bgPeriodTypeInfo.isSelfDefined());
                if (BgFiscalYearMonth.M07.equals((Object)bgPeriodTypeInfo.getStartMonth())) {
                    if (!this.existsSameTypeOfStandPeriod(ctx, bgPeriodTypeInfo, integer, integer, detailMsg)) {
                        ++faildCount;
                        continue;
                    }
                    for (BgPeriodInfo object : createBgPeriodTypeOfHalfYear) {
                        BgPeriodDispInfo disp = BgPeriodHelper.convert2BgPeriodDisp(object, bgPeriodTypeInfo);
                        Date beginDate = disp.getBeginDate();
                        Date endDate = disp.getEndDate();
                        FilterInfo filter = new FilterInfo();
                        filter.getFilterItems().add(new FilterItemInfo("number", (Object)"HALF.%HY", CompareType.LIKE));
                        filter.getFilterItems().add(new FilterItemInfo("beginDate", (Object)beginDate, CompareType.EQUALS));
                        filter.getFilterItems().add(new FilterItemInfo("endDate", (Object)endDate, CompareType.EQUALS));
                        view.setFilter(filter);
                        BgPeriodCollection bgPeriodCollection = localInstance.getBgPeriodCollection(view);
                        if (bgPeriodCollection != null && bgPeriodCollection.size() == 1) {
                            BgPeriodInfo bgPeriodInfo = bgPeriodCollection.get(0);
                            disp.setBgPeriod(bgPeriodInfo);
                            disp.setAlias(bgPeriodInfo.getName());
                            disp.setName(bgPeriodInfo.getName());
                            disp.setLongNumber(disp.getLongNumber().replace(disp.getNumber(), bgPeriodInfo.getNumber()));
                            disp.setNumber(bgPeriodInfo.getNumber());
                        } else {
                            periodInfocollection.add((CoreBaseInfo)object);
                        }
                        map.put(disp.getLongNumber(), disp);
                        collection.add((CoreBaseInfo)disp);
                    }
                    this.persistent(dispInstance, localInstance, map, collection, periodInfocollection);
                    ++successCount;
                    detailMsg.append(ResourceBase.getString((String)resClassName, (String)"succesSetFiscalYear", (Locale)localeFromEnv, (Object[])new Object[]{integer + ""})).append("\n");
                    continue;
                }
                Object[] data = (Object[])dispInstance.addBgPeriodByPeriodType(bgPeriodTypeInfo, integer, integer, createBgPeriodTypeOfHalfYear);
                successCount += ((Integer)data[0]).intValue();
                faildCount += ((Integer)data[1]).intValue();
                detailMsg.append(data[2]);
            }
        } else if (bgPeriodTypeInfo.isQuarter() && !bgPeriodTypeInfo.isMonth()) {
            for (integer = bgPeriodTypeInfo.getStartYear(); integer <= bgPeriodTypeInfo.getEndYear(); ++integer) {
                if (this.existsFiscalYear(ctx, (IObjectPK)new ObjectUuidPK(bgPeriodTypeInfo.getId()), integer, detailMsg)) {
                    ++faildCount;
                    continue;
                }
                HashMap<String, BgPeriodDispInfo> map = new HashMap<String, BgPeriodDispInfo>();
                CoreBaseCollection collection = new CoreBaseCollection();
                CoreBaseCollection periodInfocollection = new CoreBaseCollection();
                List<BgPeriodInfo> createBgPeriodTypeOfQuarter = factory.createBgPeriod(integer, bgPeriodTypeInfo.isSelfDefined());
                if (BgFiscalYearMonth.M04.equals((Object)bgPeriodTypeInfo.getStartMonth()) || BgFiscalYearMonth.M07.equals((Object)bgPeriodTypeInfo.getStartMonth()) || BgFiscalYearMonth.M10.equals((Object)bgPeriodTypeInfo.getStartMonth())) {
                    if (!this.existsSameTypeOfStandPeriod(ctx, bgPeriodTypeInfo, integer, integer, detailMsg)) {
                        ++faildCount;
                        continue;
                    }
                    for (BgPeriodInfo object : createBgPeriodTypeOfQuarter) {
                        BgPeriodDispInfo disp = BgPeriodHelper.convert2BgPeriodDisp(object, bgPeriodTypeInfo);
                        Date beginDate = disp.getBeginDate();
                        Date endDate = disp.getEndDate();
                        FilterInfo filter = new FilterInfo();
                        filter.getFilterItems().add(new FilterItemInfo("number", (Object)"QUAR.%Q", CompareType.LIKE));
                        filter.getFilterItems().add(new FilterItemInfo("beginDate", (Object)beginDate, CompareType.EQUALS));
                        filter.getFilterItems().add(new FilterItemInfo("endDate", (Object)endDate, CompareType.EQUALS));
                        view.setFilter(filter);
                        BgPeriodCollection bgPeriodCollection = localInstance.getBgPeriodCollection(view);
                        if (bgPeriodCollection != null && bgPeriodCollection.size() == 1) {
                            BgPeriodInfo bgPeriodInfo = bgPeriodCollection.get(0);
                            disp.setBgPeriod(bgPeriodInfo);
                            disp.setName(bgPeriodInfo.getName());
                            disp.setAlias(bgPeriodInfo.getName());
                            disp.setLongNumber(disp.getLongNumber().replace(disp.getNumber(), bgPeriodInfo.getNumber()));
                            disp.setNumber(bgPeriodInfo.getNumber());
                        } else {
                            periodInfocollection.add((CoreBaseInfo)object);
                        }
                        map.put(disp.getLongNumber(), disp);
                        collection.add((CoreBaseInfo)disp);
                    }
                    this.persistent(dispInstance, localInstance, map, collection, periodInfocollection);
                    ++successCount;
                    detailMsg.append(ResourceBase.getString((String)resClassName, (String)"succesSetFiscalYear", (Locale)localeFromEnv, (Object[])new Object[]{integer + ""})).append("\n");
                    continue;
                }
                Object[] data = (Object[])dispInstance.addBgPeriodByPeriodType(bgPeriodTypeInfo, integer, integer, createBgPeriodTypeOfQuarter);
                successCount += ((Integer)data[0]).intValue();
                faildCount += ((Integer)data[1]).intValue();
                detailMsg.append(data[2]);
            }
        } else {
            factory.setPeriodsFromDB(this.getBeginAndEndTimeFromMont(ctx, bgPeriodTypeInfo));
            for (integer = bgPeriodTypeInfo.getStartYear(); integer <= bgPeriodTypeInfo.getEndYear(); ++integer) {
                if (this.existsFiscalYear(ctx, (IObjectPK)new ObjectUuidPK(bgPeriodTypeInfo.getId()), integer, detailMsg)) {
                    ++faildCount;
                    continue;
                }
                if (!this.existsSameTypeOfStandPeriod(ctx, bgPeriodTypeInfo, integer, integer, detailMsg)) {
                    ++faildCount;
                    continue;
                }
                HashMap<String, BgPeriodDispInfo> map = new HashMap<String, BgPeriodDispInfo>();
                CoreBaseCollection collection = new CoreBaseCollection();
                CoreBaseCollection periodInfocollection = new CoreBaseCollection();
                List<BgPeriodInfo> bgperiods = factory.createBgPeriod(integer, bgPeriodTypeInfo.isSelfDefined());
                for (BgPeriodInfo object : bgperiods) {
                    BgPeriodDispInfo disp = BgPeriodHelper.convert2BgPeriodDisp(object, bgPeriodTypeInfo);
                    Date beginDate = disp.getBeginDate();
                    Date endDate = disp.getEndDate();
                    FilterInfo filter = new FilterInfo();
                    BgCommHelper.replaceFilterItems(filter, new FilterItemInfo("number", (Object)"MONT.%M", CompareType.LIKE));
                    BgCommHelper.replaceFilterItems(filter, new FilterItemInfo("beginDate", (Object)beginDate, CompareType.EQUALS));
                    BgCommHelper.replaceFilterItems(filter, new FilterItemInfo("endDate", (Object)endDate, CompareType.EQUALS));
                    view.setFilter(filter);
                    BgPeriodCollection bgPeriodCollection = localInstance.getBgPeriodCollection(view);
                    if (bgPeriodCollection != null && bgPeriodCollection.size() == 1) {
                        BgPeriodInfo bgPeriodInfo = bgPeriodCollection.get(0);
                        disp.setBgPeriod(bgPeriodInfo);
                        disp.setName(bgPeriodInfo.getName());
                        disp.setAlias(bgPeriodInfo.getName());
                        disp.setLongNumber(disp.getLongNumber().replace(disp.getNumber(), bgPeriodInfo.getNumber()));
                        disp.setNumber(bgPeriodInfo.getNumber());
                    } else {
                        disp.setBgPeriod(object);
                        periodInfocollection.add((CoreBaseInfo)object);
                    }
                    map.put(disp.getLongNumber(), disp);
                    collection.add((CoreBaseInfo)disp);
                }
                this.persistent(dispInstance, localInstance, map, collection, periodInfocollection);
                ++successCount;
                detailMsg.append(ResourceBase.getString((String)resClassName, (String)"succesSetFiscalYear", (Locale)localeFromEnv, (Object[])new Object[]{integer + ""})).append("\n");
            }
        }
        String string = ResourceBase.getString((String)resClassName, (String)"createPeriodFinished", (Locale)localeFromEnv, (Object[])new Object[]{successCount + faildCount, successCount, faildCount});
        if (faildCount == 0) {
            return ResourceBase.getString((String)resClassName, (String)"createPeriodSuccess", (Locale)localeFromEnv);
        }
        detailMsg.insert(0, string + "&");
        return detailMsg.toString();
    }

    private Map<Integer, Map<Integer, BgPeriodInfo>> getBeginAndEndTimeFromMont(Context ctx, BgPeriodTypeInfo bgPeriodTypeInfo) throws BOSException {
        HashMap<Integer, Map<Integer, BgPeriodInfo>> result = new HashMap<Integer, Map<Integer, BgPeriodInfo>>();
        int startYear = bgPeriodTypeInfo.getStartYear();
        int endYear = bgPeriodTypeInfo.getEndYear();
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().add("id");
        viewInfo.getSelector().add("number");
        viewInfo.getSelector().add("year");
        viewInfo.getSelector().add("month");
        viewInfo.getSelector().add("beginDate");
        viewInfo.getSelector().add("endDate");
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)"MONT.%M", CompareType.LIKE));
        filter.getFilterItems().add(new FilterItemInfo("year", (Object)(startYear - 1), CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("year", (Object)(endYear + 1), CompareType.LESS_EQUALS));
        viewInfo.setFilter(filter);
        viewInfo.getSorter().add(new SorterItemInfo("number"));
        BgPeriodCollection col = BgPeriodFactory.getLocalInstance(ctx).getBgPeriodCollection(viewInfo);
        if (null == col || col.isEmpty()) {
            return result;
        }
        int in = col.size();
        for (int i = 0; i < in; ++i) {
            BgPeriodInfo bgPeriodInfo = col.get(i);
            if (!result.containsKey(bgPeriodInfo.getYear())) {
                HashMap infoMap = new HashMap();
                result.put(bgPeriodInfo.getYear(), infoMap);
            }
            ((Map)result.get(bgPeriodInfo.getYear())).put(bgPeriodInfo.getMonth(), bgPeriodInfo);
        }
        return result;
    }

    private void persistent(IBgPeriodDisp dispInstance, IBgPeriod localInstance, Map<String, BgPeriodDispInfo> map, CoreBaseCollection collection, CoreBaseCollection periodInfocollection) throws BOSException, EASBizException {
        String pLongNumber = "";
        String longNumber = "";
        BgPeriodDispInfo info = null;
        for (int i = 0; i < collection.size(); ++i) {
            info = (BgPeriodDispInfo)collection.get(i);
            longNumber = info.getLongNumber();
            if (!longNumber.contains("!")) continue;
            pLongNumber = longNumber.substring(0, longNumber.lastIndexOf("!"));
            info.setParent(map.get(pLongNumber));
        }
        localInstance.addnewBatchData(periodInfocollection);
        dispInstance.addnewBatchData(collection);
    }

    protected void _canUpdate(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        BgPeriodTypeInfo value = null;
        try {
            value = this.getBgPeriodTypeInfo(ctx, pk);
            if (this.hasDuplicationOfname(value, ctx)) {
                throw new BgPeriodException(BgPeriodException.DUPLICATIONOFNAME);
            }
        }
        catch (EASBizException e) {
            throw new BOSException((Throwable)e);
        }
        catch (BOSException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private boolean existsFiscalYear(Context ctx, IObjectPK pk, int year, StringBuilder detailMsg) throws BOSException, EASBizException {
        if (pk == null) {
            return false;
        }
        BgPeriodTypeInfo value = null;
        try {
            value = this.getBgPeriodTypeInfo(ctx, pk);
            if (FiscalYearEnum.STRIDEYEAR.equals((Object)value.getFiscalYear())) {
                FilterInfo filter = new FilterInfo();
                BgCommHelper.replaceFilterItems(filter, new FilterItemInfo("type.id", (Object)pk.toString(), CompareType.EQUALS));
                String number = value.getNumber();
                BgCommHelper.replaceFilterItems(filter, new FilterItemInfo("number", (Object)(number + "." + year + "Y" + "%"), CompareType.LIKE));
                if (BgPeriodDispFactory.getLocalInstance(ctx).exists(filter)) {
                    detailMsg.append(ResourceBase.getString((String)resClassName, (String)"failed0_existFiscalYear", (Locale)localeFromEnv, (Object[])new Object[]{year + ""})).append("\n");
                    return true;
                }
            }
        }
        catch (EASBizException e) {
            logger.error((Object)e);
            throw e;
        }
        catch (BOSException e) {
            logger.error((Object)e);
            throw e;
        }
        return false;
    }

    private boolean existsSameTypeOfStandPeriod(Context ctx, BgPeriodTypeInfo bgPeriodTypeInfo, int startYear, int endYear, StringBuilder detailMsg) throws BOSException, EASBizException {
        if (startYear > endYear || !FiscalYearEnum.STRIDEYEAR.equals((Object)bgPeriodTypeInfo.getFiscalYear())) {
            return false;
        }
        StringBuilder number = new StringBuilder();
        String typeNumber = null;
        if (bgPeriodTypeInfo.isMonth()) {
            number.append("MONT");
            typeNumber = "MONT";
        } else if (bgPeriodTypeInfo.isQuarter()) {
            number.append("QUAR");
            typeNumber = "QUAR";
        } else if (bgPeriodTypeInfo.isHalfYear()) {
            number.append("HALF");
            typeNumber = "HALF";
        } else if (bgPeriodTypeInfo.isYear()) {
            number.append("YEAR");
            typeNumber = "YEAR";
        } else {
            return false;
        }
        String preFixNumber = number.append(".").toString();
        if (BgPeriodYearEnum.lastYear.equals((Object)bgPeriodTypeInfo.getBelongYear())) {
            --startYear;
        } else {
            ++endYear;
        }
        FilterInfo filter = new FilterInfo();
        HashMap<String, Integer> standardPeriodNumber = new HashMap<String, Integer>();
        HashSet<String> set = new HashSet<String>();
        for (int i = startYear; i <= endYear; ++i) {
            String string = preFixNumber + i + "Y";
            set.add(string);
            standardPeriodNumber.put(string, i);
        }
        Set keySet = standardPeriodNumber.keySet();
        BgCommHelper.replaceFilterItems(filter, new FilterItemInfo("number", set, CompareType.INCLUDE));
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection coll = new SelectorItemCollection();
        coll.add("number");
        coll.add("name");
        coll.add("id");
        coll.add("bgPeriod.id");
        coll.add("bgPeriod.number");
        view.setSelector(coll);
        view.setFilter(filter);
        BgPeriodDispCollection bgPeriodDispCollection = BgPeriodDispFactory.getLocalInstance(ctx).getBgPeriodDispCollection(view);
        HashMap<String, BgPeriodInfo> reMap = new HashMap<String, BgPeriodInfo>();
        if (bgPeriodDispCollection != null && !bgPeriodDispCollection.isEmpty()) {
            for (int i = 0; i < bgPeriodDispCollection.size(); ++i) {
                BgPeriodDispInfo bgPeriodDispInfo = bgPeriodDispCollection.get(i);
                keySet.remove(bgPeriodDispInfo.getNumber());
                reMap.put(bgPeriodDispInfo.getBgPeriod().getNumber(), bgPeriodDispInfo.getBgPeriod());
            }
        }
        if (!keySet.isEmpty() && keySet.size() > 0) {
            StringBuilder errorMsg = new StringBuilder();
            String he = ResourceBase.getString((String)resClassName, (String)"AND", (Locale)localeFromEnv);
            for (String string : keySet) {
                errorMsg.append(standardPeriodNumber.get(string)).append(he);
            }
            detailMsg.append(ResourceBase.getString((String)resClassName, (String)"failed1_notexistStandYear", (Locale)localeFromEnv, (Object[])new Object[]{BgPeriodYearEnum.lastYear.equals((Object)bgPeriodTypeInfo.getBelongYear()) ? new Integer(startYear + 1).toString() : startYear + "", typeNumber, errorMsg.deleteCharAt(errorMsg.lastIndexOf(he)).toString()})).append("\n");
            return false;
        }
        return true;
    }

    private boolean hasDuplicationOfname(BgPeriodTypeInfo value, Context ctx) throws EASBizException, BOSException {
        if (value.getName() == null) {
            return false;
        }
        FilterInfo filter = new FilterInfo();
        filter.appendFilterItem("name", (Object)value.getName().toString());
        BgCommHelper.replaceFilterItems(filter, new FilterItemInfo("id", (Object)value.getId().toString(), CompareType.NOTEQUALS));
        return BgPeriodTypeFactory.getLocalInstance(ctx).exists(filter);
    }

    protected void _canDelete(Context ctx, IObjectPK pk, Connection cn) throws CanNotDeleteException {
        BgPeriodTypeInfo value = null;
        try {
            value = this.getBgPeriodTypeInfo(ctx, pk);
        }
        catch (EASBizException e) {
            throw new CanNotDeleteException((Throwable)e);
        }
        catch (BOSException e) {
            throw new CanNotDeleteException((Throwable)e);
        }
        Locale locale = ContextUtils.getLocaleFromEnv();
        try {
            if (this.hasUsedByBgScheme(value, ctx)) {
                String messageStr = EASCommonResource.getString((String)"com.kingdee.eas.ma.base.BgPeriodMsgResource", (String)"usedByBgScheme", (Locale)locale);
                throw new CanNotDeleteException(messageStr);
            }
        }
        catch (SQLException e1) {
            throw new CanNotDeleteException((Throwable)e1);
        }
        try {
            if (this.hasBgPeriod(value, ctx)) {
                String messageStr = EASCommonResource.getString((String)"com.kingdee.eas.ma.base.BgPeriodMsgResource", (String)"deleteError0", (Locale)locale);
                throw new CanNotDeleteException(messageStr);
            }
        }
        catch (EASBizException e1) {
            throw new CanNotDeleteException((Throwable)e1);
        }
        catch (BOSException e1) {
            throw new CanNotDeleteException((Throwable)e1);
        }
        try {
            if (this.checkIsRef(ctx, value)) {
                String messageStr = EASCommonResource.getString((String)"com.kingdee.eas.ma.base.BgPeriodMsgResource", (String)"deleteError2", (Locale)locale);
                throw new CanNotDeleteException(messageStr);
            }
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            throw new CanNotDeleteException((Throwable)e);
        }
    }

    private boolean hasUsedByBgScheme(BgPeriodTypeInfo value, Context ctx) throws SQLException {
        String sql = "Select top 1 fid from t_mbg_bgDimSettingsMember where FMemberId ='" + value.getId().toString() + "'";
        IRowSet executeQuery = BgDBUtils.executeQuery(ctx, sql);
        return executeQuery.next();
    }

    private boolean isSysData(BgPeriodTypeInfo value, Context ctx) {
        return BgPeriodHelper.SYS_BGPERIOD_NUMBER.contains(value.getNumber());
    }

    private boolean checkIsRef(Context ctx, BgPeriodTypeInfo value) throws SQLException {
        String sql = "Select fid from t_mbg_bgcontrolrule where fbgperiodtypeid ='" + value.getId().toString() + "'";
        IRowSet executeQuery = BgDBUtils.executeQuery(ctx, sql);
        return executeQuery.next();
    }

    private boolean hasBgPeriod(BgPeriodTypeInfo value, Context ctx) throws EASBizException, BOSException {
        FilterInfo filter = new FilterInfo();
        filter.appendFilterItem("type.id", (Object)value.getId().toString());
        return BgPeriodDispFactory.getLocalInstance(ctx).exists(filter);
    }

    @Override
    protected void _validate(Context ctx, String id, IObjectValue model, String oprationType) throws BOSException, EASBizException {
        BgPeriodTypeInfo info = (BgPeriodTypeInfo)model;
        if (this.checkDup(ctx, oprationType, info, "number")) {
            throw new BgPeriodException(BgPeriodException.DUPLICATIONOFNUMBER);
        }
        if (this.checkDup(ctx, oprationType, info, "name")) {
            throw new BgPeriodException(BgPeriodException.DUPLICATIONOFNAME);
        }
        this.checkBgPeriodType(ctx, info, oprationType);
    }

    protected void checkBgPeriodType(Context ctx, BgPeriodTypeInfo info, String oprationType) throws BOSException, EASBizException {
        if (FiscalYearEnum.STANDARDYEAR.equals((Object)info.getFiscalYear()) && !info.isSelfDefined()) {
            FilterInfo filter = new FilterInfo();
            BgCommHelper.replaceFilterItems(filter, new FilterItemInfo("fiscalYear", (Object)info.getFiscalYear().getValue(), CompareType.EQUALS));
            BgCommHelper.replaceFilterItems(filter, new FilterItemInfo("year", (Object)info.isYear(), CompareType.EQUALS));
            BgCommHelper.replaceFilterItems(filter, new FilterItemInfo("halfYear", (Object)info.isHalfYear(), CompareType.EQUALS));
            BgCommHelper.replaceFilterItems(filter, new FilterItemInfo("quarter", (Object)info.isQuarter(), CompareType.EQUALS));
            BgCommHelper.replaceFilterItems(filter, new FilterItemInfo("month", (Object)info.isMonth(), CompareType.EQUALS));
            BgCommHelper.replaceFilterItems(filter, new FilterItemInfo("day", (Object)info.isDay(), CompareType.EQUALS));
            BgCommHelper.replaceFilterItems(filter, new FilterItemInfo("yearWeek", (Object)info.isYearWeek(), CompareType.EQUALS));
            BgCommHelper.replaceFilterItems(filter, new FilterItemInfo("mothWeek", (Object)info.isMothWeek(), CompareType.EQUALS));
            BgCommHelper.replaceFilterItems(filter, new FilterItemInfo("tenday", (Object)info.isTenday(), CompareType.EQUALS));
            BgCommHelper.replaceFilterItems(filter, new FilterItemInfo("selfDefined", (Object)info.isSelfDefined(), CompareType.EQUALS));
            if ("EDIT".equals(oprationType)) {
                BgCommHelper.replaceFilterItems(filter, new FilterItemInfo("id", (Object)info.getId().toString(), CompareType.NOTEQUALS));
            }
            if (this.exists(ctx, filter)) {
                EntityViewInfo view = new EntityViewInfo();
                view.setFilter(filter);
                BgPeriodTypeCollection bgPeriodTypeCollection = this.getBgPeriodTypeCollection(ctx, view);
                if (FiscalYearEnum.STRIDEYEAR.equals((Object)info.getFiscalYear())) {
                    throw new BgPeriodException(BgPeriodException.EXISTPERIODTYPE, new Object[]{bgPeriodTypeCollection.get(0).getName()});
                }
                throw new BgPeriodException(BgPeriodException.EXISTSAMETYPE, new Object[]{bgPeriodTypeCollection.get(0).getName()});
            }
        }
    }

    private boolean checkDup(Context ctx, String oprationType, BgPeriodTypeInfo info, String field) throws EASBizException, BOSException {
        FilterInfo filter = new FilterInfo();
        filter.appendFilterItem(field, (Object)info.getName());
        String value = null;
        value = "name".equals(field) ? info.getName() : info.getNumber();
        if ("ADDNEW".equals(oprationType)) {
            BgCommHelper.replaceFilterItems(filter, new FilterItemInfo(field, (Object)value, CompareType.EQUALS));
        } else {
            BgCommHelper.replaceFilterItems(filter, new FilterItemInfo(field, (Object)value, CompareType.EQUALS));
            BgCommHelper.replaceFilterItems(filter, new FilterItemInfo("id", (Object)info.getId().toString(), CompareType.NOTEQUALS));
        }
        return this.exists(ctx, filter);
    }

    private boolean isSysData(BgPeriodTypeInfo value) {
        return BgPeriodHelper.SYS_BGPERIOD_NUMBER.contains(value.getNumber());
    }

    @Override
    protected String _setFiscalYear(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        BgPeriodTypeInfo bgPeriodTypeInfo = (BgPeriodTypeInfo)model;
        if (FiscalYearEnum.STRIDEYEAR.equals((Object)bgPeriodTypeInfo.getFiscalYear())) {
            BgPeriodTypeFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(bgPeriodTypeInfo.getId().toString()), bgPeriodTypeInfo);
        }
        String _txt = this.processFiscalYearSet(ctx, bgPeriodTypeInfo);
        BgPeriodHelper.checkBgPeriodClosure(ctx, bgPeriodTypeInfo.getId());
        return _txt;
    }
}

