/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.base.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.TreeBaseCollection;
import com.kingdee.eas.framework.TreeBaseException;
import com.kingdee.eas.framework.TreeBaseInfo;
import com.kingdee.eas.ma.base.BgElementException;
import com.kingdee.eas.ma.base.BgPropertyCollection;
import com.kingdee.eas.ma.base.BgPropertyException;
import com.kingdee.eas.ma.base.BgPropertyFactory;
import com.kingdee.eas.ma.base.BgPropertyInfo;
import com.kingdee.eas.ma.base.BgScenarioException;
import com.kingdee.eas.ma.base.IBgProperty;
import com.kingdee.eas.ma.base.app.AbstractBgPropertyControllerBean;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgPropertyControllerBean
extends AbstractBgPropertyControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.base.app.BgPropertyControllerBean");

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.checkNumberAndName(ctx, model);
        return super._addnew(ctx, model);
    }

    protected void checkNumberAndName(Context ctx, IObjectValue model) throws BgPropertyException, BOSException, BgScenarioException, BgElementException {
        BgPropertyInfo bgProperty = (BgPropertyInfo)model;
        if (bgProperty.getBgPropertySort() == null) {
            throw new BgPropertyException(BgPropertyException.SORTISNULL);
        }
        Locale local = ctx.getLocale();
        String name = bgProperty.getName();
        String number = bgProperty.getNumber();
        BOSUuid sourceid = bgProperty.getBgPropertySort().getId();
        String sortId = bgProperty.getBgPropertySort().getId().toString();
        String sourceType = null;
        String mbgDimId = null;
        StringBuffer sql = new StringBuffer("select fsourcetype, fmbgdimid from T_MBG_BgPropertySort where FID = ?");
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new String[]{sortId});
            while (rs.next()) {
                sourceType = rs.getString(1);
                mbgDimId = rs.getString(2);
            }
            ArrayList<String> paramList = new ArrayList<String>();
            sql.setLength(0);
            sql.append("select fid from t_mbg_bgproperty where fbgpropertysortid = ? ");
            paramList.add(sourceid.toString());
            sql.append(" and fnumber = ?");
            paramList.add(number);
            if (bgProperty.getId() != null) {
                sql.append(" and fid <> ?");
                paramList.add(bgProperty.getId().toString());
            }
            if ((rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])paramList.toArray())).next()) {
                throw new BgScenarioException(BgScenarioException.FORBIDDENREPEATNUM);
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"budget error:", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
    }

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        BgPropertyInfo curMember = (BgPropertyInfo)model;
        BgPropertyInfo oldValue = (BgPropertyInfo)this._getValue(ctx, (IObjectPK)new ObjectUuidPK(curMember.getId()));
        this.checkNumberAndName(ctx, model);
        BgPropertyCollection colls = new BgPropertyCollection();
        colls.add((BgPropertyInfo)model);
        this.updateParent(ctx, (IObjectCollection)colls, false);
        super._update(ctx, pk, model);
        if (this.hasParentChanged(curMember, oldValue)) {
            this.updateCurMemberParent(ctx, oldValue, curMember.getParent(), curMember.getBgPropertySort().getId().toString());
        }
    }

    private void updateCurMemberParent(Context ctx, BgPropertyInfo oldValue, BgPropertyInfo newParent, String bgPropertySortId) throws EASBizException, BOSException {
        if (ctx == null || oldValue == null || StringUtils.isEmpty((String)bgPropertySortId)) {
            return;
        }
        BgPropertyInfo bgPropertyInfo = oldValue.getParent();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("isleaf"));
        if (bgPropertyInfo != null) {
            ObjectUuidPK curOldPk = new ObjectUuidPK(BOSUuid.read((String)bgPropertyInfo.getId().toString()));
            IObjectValue curOldParentValue = this._getValue(ctx, (IObjectPK)curOldPk);
            if (!this._exists(ctx, "select id where bgPropertySort.id = '" + bgPropertySortId + "' and parent.id = '" + bgPropertyInfo.getId().toString() + "'")) {
                ((BgPropertyInfo)curOldParentValue).setIsLeaf(true);
                this.updatePartial(ctx, (BgPropertyInfo)curOldParentValue, sic);
            }
        }
        if (newParent != null && newParent.isIsLeaf()) {
            newParent.setIsLeaf(false);
            this.updatePartial(ctx, newParent, sic);
        }
    }

    private boolean hasParentChanged(BgPropertyInfo curMember, BgPropertyInfo oldValue) {
        BgPropertyInfo newParentValue = curMember.getParent();
        BgPropertyInfo oldParentValue = oldValue.getParent();
        if (newParentValue == null && oldParentValue == null) {
            return false;
        }
        if (newParentValue == null && oldParentValue != null) {
            return true;
        }
        if (newParentValue != null && oldParentValue == null) {
            return true;
        }
        return !newParentValue.getId().toString().equals(oldParentValue.getId().toString());
    }

    @Override
    public void delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        if (this.isUse(ctx, pk)) {
            throw new BgPropertyException(BgPropertyException.ISUSE);
        }
        HashSet<String> canSet = new HashSet<String>();
        BgPropertyInfo info = BgPropertyFactory.getLocalInstance(ctx).getBgPropertyInfo(pk);
        canSet.add(info.getId().toString());
        TreeBaseCollection children = this.getAllChildren(ctx, info);
        for (int i = 0; i < children.size(); ++i) {
            info = (BgPropertyInfo)children.get(i);
            if (this.isUse(ctx, (IObjectPK)new ObjectUuidPK(info.getId()))) {
                throw new BgPropertyException(BgPropertyException.ISUSE);
            }
            canSet.add(info.getId().toString());
        }
        if (!canSet.isEmpty()) {
            ArrayList lst = new ArrayList(canSet);
            IObjectPK[] pkArrays = new IObjectPK[canSet.size()];
            int in = lst.size();
            for (int i = 0; i < in; ++i) {
                pkArrays[i] = new ObjectUuidPK((String)lst.get(i));
            }
            super._deleteBatchData(ctx, pkArrays);
        }
    }

    private boolean isUse(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        boolean isUsed = false;
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            String sql = "SELECT fid FROM t_mbg_PropertyRefSource t1 where fpropertyid = ? and (exists(select * from T_MBG_BgAccount t2 where t2.FID = t1.fsourceid) or exists(select * from T_MBG_BgOrgUnit t2 where t2.FID = t1.fsourceid)or exists(select * from T_MBG_MbgMember t2 where t2.FID = t1.fsourceid))";
            conn = this.getConnection(ctx);
            ps = conn.prepareStatement(sql);
            ps.setString(1, pk.toString());
            rs = ps.executeQuery();
            if (rs.next()) {
                isUsed = true;
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException(e.toString());
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)conn);
        return isUsed;
    }

    private BgPropertyCollection getPropertyCollByIds(Context ctx, Set idset) throws BOSException {
        IBgProperty iBgProperty = BgPropertyFactory.getLocalInstance(ctx);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("number");
        sic.add("name");
        sic.add("bgPropertySort.id");
        sic.add("parent.id");
        view.getSelector().addObjectCollection((IObjectCollection)sic);
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idset, CompareType.INCLUDE));
        view.setFilter(filter);
        view.setSorter(new SorterItemCollection());
        view.getSorter().add(new SorterItemInfo("longNumber"));
        return iBgProperty.getBgPropertyCollection(view);
    }

    private Set<String> getRefRelations(Context ctx, Set<String> bgPropertyIds) throws EASBizException, BOSException {
        if (ctx == null || bgPropertyIds == null || bgPropertyIds.isEmpty()) {
            return null;
        }
        HashSet<String> set = new HashSet<String>();
        for (String id : bgPropertyIds) {
            if (!this.isUse(ctx, (IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)))) continue;
            set.add(id);
        }
        return set;
    }

    private HashSet<String> reFilterDeleteIds(Set<String> returnSet, HashSet<String> needDeleteIDS, Map<String, HashSet<String>> childMap) {
        if (returnSet == null || returnSet.isEmpty()) {
            return needDeleteIDS;
        }
        for (String value : returnSet) {
            if (needDeleteIDS.contains(value)) {
                needDeleteIDS.remove(value);
            }
            if (childMap.isEmpty()) continue;
            for (String root : childMap.keySet()) {
                HashSet<String> children = childMap.get(root);
                if (!children.contains(value)) continue;
                for (String child : children) {
                    if (!needDeleteIDS.contains(child)) continue;
                    needDeleteIDS.remove(child);
                }
            }
        }
        return needDeleteIDS;
    }

    @Override
    protected Map _remove(Context ctx, List ids) throws BOSException, EASBizException {
        if (ids == null || ids.isEmpty()) {
            return null;
        }
        HashSet idset = new HashSet();
        for (int index = 0; index < ids.size(); ++index) {
            idset.add(ids.get(index));
        }
        HashMap<String, HashSet<String>> childMap = new HashMap<String, HashSet<String>>();
        BgPropertyCollection propertyCol = this.getPropertyCollByIds(ctx, idset);
        BgPropertyCollection propertyRefCol = new BgPropertyCollection();
        BgPropertyInfo propertyInfo = null;
        HashMap<BgPropertyInfo, BgPropertyInfo> parentMap = new HashMap<BgPropertyInfo, BgPropertyInfo>();
        TreeBaseCollection coll = null;
        HashSet<String> needDeleteIDS = new HashSet<String>();
        HashMap<String, Set<String>> returnMap = new HashMap<String, Set<String>>();
        int len = propertyCol.size();
        for (int i = 0; i < len; ++i) {
            propertyInfo = propertyCol.get(i);
            if (!childMap.containsKey(propertyInfo.getId().toString())) {
                childMap.put(propertyInfo.getId().toString(), new HashSet());
                ((HashSet)childMap.get(propertyInfo.getId().toString())).add(propertyInfo.getId().toString());
            }
            if (needDeleteIDS.contains(propertyInfo.getId().toString())) continue;
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("bgPropertySort.id", (Object)propertyInfo.getBgPropertySort().getId().toString(), CompareType.EQUALS));
            view.setFilter(filterInfo);
            coll = this.getAllChildren(ctx, propertyInfo, view);
            BgPropertyInfo child = null;
            int jn = coll.size();
            for (int j = 0; j < jn; ++j) {
                child = (BgPropertyInfo)coll.get(j);
                needDeleteIDS.add(child.getId().toString());
                if (!childMap.containsKey(propertyInfo.getId().toString())) continue;
                ((HashSet)childMap.get(propertyInfo.getId().toString())).add(child.getId().toString());
            }
            needDeleteIDS.add(propertyInfo.getId().toString());
            if (propertyInfo.getParent() == null) continue;
            parentMap.put(propertyInfo, propertyInfo.getParent());
        }
        BgPropertyInfo parent = null;
        BgPropertyCollection updateParentColl = new BgPropertyCollection();
        for (BgPropertyInfo property : parentMap.keySet()) {
            parent = (BgPropertyInfo)parentMap.get(property);
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("bgPropertySort.id", (Object)property.getBgPropertySort().getId().toString(), CompareType.EQUALS));
            view.setFilter(filterInfo);
            coll = this.getAllChildren(ctx, parent, view);
            BgPropertyInfo info = null;
            Boolean flag = true;
            int in = coll.size();
            for (int i = 0; i < in; ++i) {
                info = (BgPropertyInfo)coll.get(i);
                if (needDeleteIDS.contains(info.getId().toString())) continue;
                flag = false;
                break;
            }
            if (!flag.booleanValue()) continue;
            updateParentColl.add(property);
        }
        Set<String> existRefSet = this.getRefRelations(ctx, needDeleteIDS);
        if (!(needDeleteIDS = this.reFilterDeleteIds(existRefSet, needDeleteIDS, childMap)).isEmpty()) {
            ArrayList<String> lst = new ArrayList<String>(needDeleteIDS);
            IObjectPK[] pkArrays = new IObjectPK[needDeleteIDS.size()];
            int in = lst.size();
            for (int i = 0; i < in; ++i) {
                pkArrays[i] = new ObjectUuidPK((String)lst.get(i));
            }
            super._deleteBatchData(ctx, pkArrays);
        }
        if (!updateParentColl.isEmpty()) {
            this.updateParent(ctx, (IObjectCollection)updateParentColl, true);
        }
        returnMap.put("delete_success", needDeleteIDS);
        returnMap.put("delete_failed", existRefSet);
        return returnMap;
    }

    private void updateParent(Context ctx, IObjectCollection colls, boolean isLeaf) throws BOSException {
        BgPropertyInfo property = null;
        BgPropertyInfo parentInfo = null;
        ArrayList<String> parentIDS = new ArrayList<String>();
        int in = colls.size();
        for (int i = 0; i < in; ++i) {
            property = (BgPropertyInfo)colls.getObject(i);
            if (property.getParent() == null || (parentInfo = property.getParent()).getId() == null) continue;
            parentIDS.add(parentInfo.getId().toString());
        }
        if (!parentIDS.isEmpty()) {
            PreparedStatement pstmt;
            Connection conn;
            block11: {
                int i;
                conn = null;
                pstmt = null;
                int batchSize = 50;
                int batchIndex = 0;
                int size = parentIDS.size();
                int count = (size - 1) / batchSize + 1;
                int pos = 0;
                int value = isLeaf ? 1 : 0;
                StringBuffer sql = new StringBuffer("update T_MBG_BgProperty set FIsLeaf = ? where FID in ( ");
                for (i = 1; i < batchSize; ++i) {
                    sql.append("?,");
                }
                sql.append("?)");
                try {
                    conn = this.getConnection(ctx);
                    pstmt = conn.prepareStatement(sql.toString());
                    for (i = 0; i < count; ++i) {
                        pstmt.setInt(1, value);
                        int j = 2;
                        while (j <= batchSize + 1) {
                            if (pos < size) {
                                pstmt.setString(j, (String)parentIDS.get(pos));
                            } else {
                                pstmt.setString(j, "#");
                            }
                            ++j;
                            ++pos;
                        }
                        pstmt.addBatch();
                        if (++batchIndex < batchSize) continue;
                        pstmt.executeBatch();
                        batchIndex = 0;
                    }
                    if (batchIndex == 0) break block11;
                    pstmt.executeBatch();
                }
                catch (SQLException e) {
                    try {
                        logger.error((Object)e);
                        throw new BOSException(e.getMessage());
                    }
                    catch (Throwable throwable) {
                        SQLUtils.cleanup(pstmt, (Connection)conn);
                        throw throwable;
                    }
                }
            }
            SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
        }
    }

    protected void _checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
    }

    protected void checkLNForTree(Context ctx, TreeBaseInfo treeBaseInfo) throws BOSException, EASBizException, TreeBaseException {
    }

    protected IObjectPK[] _saveBatchData(Context ctx, IObjectCollection colls) throws BOSException, EASBizException {
        IObjectPK[] returnPks = super._saveBatchData(ctx, colls);
        this.updateParent(ctx, colls, false);
        return returnPks;
    }
}

