/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.base.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.CanNotDeleteException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.TreeBaseCollection;
import com.kingdee.eas.ma.base.BgScenarioCollection;
import com.kingdee.eas.ma.base.BgScenarioException;
import com.kingdee.eas.ma.base.BgScenarioFactory;
import com.kingdee.eas.ma.base.BgScenarioInfo;
import com.kingdee.eas.ma.base.BgScenarioNodeCollection;
import com.kingdee.eas.ma.base.BgScenarioNodeFactory;
import com.kingdee.eas.ma.base.app.AbstractBgScenarioControllerBean;
import com.kingdee.eas.ma.base.utils.BgCommNHelper;
import com.kingdee.eas.ma.base.utils.BgDimCacheUtils;
import com.kingdee.eas.ma.base.utils.BgScenarioHelper;
import com.kingdee.eas.util.EASCommonResource;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class BgScenarioControllerBean
extends AbstractBgScenarioControllerBean {
    private static final long serialVersionUID = 7208491217836435346L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.base.app.BgScenarioControllerBean");

    protected FilterInfo getFilterForDefaultCU(Context ctx, IObjectValue model) {
        return new FilterInfo();
    }

    protected FilterInfo getFilterForDefaultCU(IObjectValue model) {
        return new FilterInfo();
    }

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        BgScenarioInfo bgScenario = (BgScenarioInfo)model;
        FilterInfo filter = new FilterInfo();
        filter.appendFilterItem("number", (Object)bgScenario.getNumber());
        if (this._exists(ctx, filter)) {
            throw new BgScenarioException(BgScenarioException.FORBIDDENREPEATNUM);
        }
        FilterInfo filterName = new FilterInfo();
        filterName.appendFilterItem("name", (Object)bgScenario.getName());
        if (this._exists(ctx, filterName)) {
            throw new BgScenarioException(BgScenarioException.FORBIDDENREPEATNAME);
        }
        Integer maxid = BgCommNHelper.getMaxId(ctx, "T_MBG_BgScenario", "FScenarioID");
        bgScenario.setScenarioId(maxid);
        return super._addnew(ctx, model);
    }

    private boolean checkIsRefByTemplate(Context ctx, BgScenarioInfo info) throws BOSException, EASBizException, SQLException {
        String id = info.getId().toString();
        String sql = "SELECT top 1 fid FROM T_MBG_BgTemplate WHERE FBgScenarioID = '" + id + "'";
        ISQLExecutor iSql = SQLExecutorFactory.getLocalInstance((Context)ctx, (String)sql);
        IRowSet rs = iSql.executeSQL();
        if (rs.next()) {
            return true;
        }
        return this.isUse(ctx, id);
    }

    private boolean isUse(Context ctx, String pk) throws EASBizException, BOSException {
        boolean isUsed = false;
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            String sql = " SELECT s.fid FROM t_mbg_bgScheme s  left join t_mbg_bgDimSettings d on d.FBgschemeId = s.FID  left join t_mbg_bgDimSettingsMember m  on d.fid=m.FBgDimSettingsId  where  d.FDimNumber = 'BG_Scenario'  and m.FmemberId =? ";
            conn = this.getConnection(ctx);
            ps = conn.prepareStatement(sql);
            ps.setString(1, pk.toString());
            rs = ps.executeQuery();
            if (rs.next()) {
                isUsed = true;
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException(e.toString());
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)conn);
        return isUsed;
    }

    protected void _canUpdate(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        BgScenarioInfo value = null;
        try {
            value = this.getBgScenarioInfo(ctx, pk);
        }
        catch (EASBizException e) {
            throw new BOSException((Throwable)e);
        }
        catch (BOSException e) {
            throw new BOSException((Throwable)e);
        }
        if (!this.isLocalOrgUnitCreated(value, ctx)) {
            throw new BgScenarioException(BgScenarioException.FORBIDDENUPDATE1);
        }
    }

    protected void _canDelete(Context ctx, IObjectPK pk, Connection cn) throws CanNotDeleteException {
        BgScenarioInfo value = null;
        try {
            value = this.getBgScenarioInfo(ctx, pk);
        }
        catch (EASBizException e) {
            throw new CanNotDeleteException((Throwable)e);
        }
        catch (BOSException e) {
            throw new CanNotDeleteException((Throwable)e);
        }
        Locale locale = SysContext.getSysContext().getLocale();
        if (this.isSysData(value)) {
            String messageStr = EASCommonResource.getString((String)"com.kingdee.eas.ma.base.BgScenarioResource", (String)"BGSCENARIO_SYSDATA_FORBIDDEN_DELETE", (Locale)locale);
            throw new CanNotDeleteException(messageStr);
        }
        if (!this.isLocalOrgUnitCreated(value, ctx)) {
            String messageStr = EASCommonResource.getString((String)"com.kingdee.eas.ma.base.BgScenarioResource", (String)"BGSCENARIO_DELETE_FORBBIT_ORG", (Locale)locale);
            throw new CanNotDeleteException(messageStr);
        }
        try {
            if (!this.isRefByBgScenarion(value, ctx)) {
                String messageStr = EASCommonResource.getString((String)"com.kingdee.eas.ma.base.BgScenarioResource", (String)"BGSCENARIO_REFED_BGSCENARIO_DELETE", (Locale)locale);
                throw new CanNotDeleteException(messageStr);
            }
            if (this.checkIsRefByTemplate(ctx, value)) {
                String messageStr = EASCommonResource.getString((String)"com.kingdee.eas.ma.base.BgScenarioResource", (String)"BGSCENARIO_REFED_FORBIDDEN_DELETE", (Locale)locale);
                throw new CanNotDeleteException(messageStr);
            }
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            throw new CanNotDeleteException((Throwable)e);
        }
    }

    private boolean isRefByBgScenarion(BgScenarioInfo value, Context ctx) throws BOSException, EASBizException, SQLException {
        String id = value.getId().toString();
        String sql = "SELECT top 1 fid FROM T_MBG_BgScenarioNode WHERE FActScenarioID = '" + id + "'";
        ISQLExecutor iSql = SQLExecutorFactory.getLocalInstance((Context)ctx, (String)sql);
        IRowSet rs = iSql.executeSQL();
        if (rs.next()) {
            return true;
        }
        return this.isUse(ctx, id);
    }

    private boolean isLocalOrgUnitCreated(BgScenarioInfo value, Context ctx) {
        OrgUnitInfo orgObject = ContextUtil.getCurrentOrgUnit((Context)ctx);
        FullOrgUnitInfo castToFullOrgUnitInfo = orgObject.castToFullOrgUnitInfo();
        String longNumber = value.getOrgUnit().getId().toString();
        String longNumber2 = castToFullOrgUnitInfo.getId().toString();
        return longNumber2.equals(longNumber);
    }

    private boolean isSysData(BgScenarioInfo value) {
        return value != null && BgScenarioHelper.sysDataNumbers.contains(value.getNumber());
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        BgScenarioInfo bgScenario = (BgScenarioInfo)model;
        Locale local = ctx.getLocale();
        if (bgScenario.getId() != null) {
            IRowSet rs;
            block5: {
                String sql = "select top 1 fid from t_mbg_bgScenario where FID <> ? and FName_" + local + " = ?";
                rs = null;
                try {
                    rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new String[]{bgScenario.getId().toString(), bgScenario.getName()});
                    if (!rs.next()) break block5;
                    throw new BgScenarioException(BgScenarioException.FORBIDDENREPEATNAME);
                }
                catch (SQLException e) {
                    try {
                        logger.error((Object)"budget error:", (Throwable)e);
                        throw new BOSException((Throwable)e);
                    }
                    catch (Throwable throwable) {
                        SQLUtils.cleanup(rs);
                        throw throwable;
                    }
                }
            }
            SQLUtils.cleanup((ResultSet)rs);
        }
        return super._submit(ctx, model);
    }

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        super._update(ctx, pk, model);
        BgDimCacheUtils.clearDimMemberCache(ctx);
        BgDimCacheUtils.clearBgScenarioCache(ctx);
    }

    @Override
    protected Map _remove(Context ctx, List ids) throws BOSException, EASBizException {
        HashMap result = new HashMap();
        HashSet<String> cantRemove = new HashSet<String>();
        HashSet<String> refByBgScenario = new HashSet<String>();
        HashSet<String> canSet = new HashSet<String>();
        result.put("cantRemove", cantRemove);
        result.put("canSet", canSet);
        result.put("refByBgScenario", refByBgScenario);
        if (ids == null || ids.isEmpty()) {
            return null;
        }
        HashSet<String> idset = new HashSet<String>(ids);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        view.setFilter(filter);
        view.setSelector(sic);
        sic.add("actScenario.id");
        sic.add("bgScenario.id");
        filter.getFilterItems().add(new FilterItemInfo("actScenario.id", idset, CompareType.INCLUDE));
        BgScenarioNodeCollection nodes = BgScenarioNodeFactory.getLocalInstance(ctx).getCollection(view);
        if (nodes != null && !nodes.isEmpty()) {
            String id = null;
            for (int i = 0; i < nodes.size(); ++i) {
                id = nodes.get(i).getActScenario().getId().toString();
                refByBgScenario.add(id);
                ids.remove(id);
                idset.remove(id);
            }
        }
        filter = new FilterInfo();
        sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("number");
        sic.add("name");
        sic.add("isSysData");
        sic.add("parent.id");
        view.getSelector().addObjectCollection((IObjectCollection)sic);
        filter.getFilterItems().add(new FilterItemInfo("id", idset, CompareType.INCLUDE));
        view.setFilter(filter);
        BgScenarioCollection verCol = BgScenarioFactory.getLocalInstance(ctx).getBgScenarioCollection(view);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter1 = new FilterInfo();
        SelectorItemCollection sic1 = new SelectorItemCollection();
        sic1.add("id");
        sic1.add("number");
        sic1.add("name");
        sic1.add("isSysData");
        sic1.add("parent.id");
        evi.getSelector().addObjectCollection((IObjectCollection)sic1);
        filter1.getFilterItems().add(new FilterItemInfo("id", (Object)"Select settMember.FMemberID FROM T_MBG_BgDimSettings sett INNER JOIN T_MBG_BgDimSettingsMember settMember On settMember.FBgDimSettingsId = sett.FID Where sett.FDimNumber = 'BG_Scenario'", CompareType.INNER));
        evi.setFilter(filter1);
        BgScenarioCollection cantVerCol = BgScenarioFactory.getLocalInstance(ctx).getBgScenarioCollection(evi);
        int en = cantVerCol.size();
        for (int j = 0; j < en; ++j) {
            TreeBaseCollection children = this.getAllChildren(ctx, cantVerCol.get(j));
            if (verCol.contains(cantVerCol.get(j))) {
                verCol.remove(cantVerCol.get(j));
                cantRemove.add(cantVerCol.get(j).getId().toString());
            }
            if (children == null) continue;
            for (int i = 0; i < children.size(); ++i) {
                if (!verCol.contains(children.get(i))) continue;
                verCol.remove(cantVerCol.get(j));
                cantRemove.add(cantVerCol.get(j).getId().toString());
            }
        }
        idset.clear();
        HashMap childMap = new HashMap();
        HashSet<Object> childSet = null;
        HashMap<Object, BgScenarioInfo> parentMap = new HashMap<Object, BgScenarioInfo>();
        TreeBaseCollection coll = null;
        int in = verCol.size();
        for (int i = 0; i < in; ++i) {
            BgScenarioInfo version = verCol.get(i);
            coll = this.getAllChildren(ctx, version);
            childSet = new HashSet<Object>();
            BgScenarioInfo child = null;
            int jn = coll.size();
            for (int j = 0; j < jn; ++j) {
                child = (BgScenarioInfo)coll.get(j);
                childSet.add(child);
                canSet.add(child.getId().toString());
                if (verCol.contains(child)) continue;
                idset.add(child.getId().toString());
            }
            childSet.add(version);
            canSet.add(version.getId().toString());
            childMap.put(version, childSet);
            if (version.getParent() == null) continue;
            parentMap.put(version, version.getParent());
        }
        BgScenarioInfo parent = null;
        BgScenarioCollection updateParentColl = new BgScenarioCollection();
        for (BgScenarioInfo account : parentMap.keySet()) {
            parent = (BgScenarioInfo)parentMap.get(account);
            coll = this.getAllChildren(ctx, parent);
            BgScenarioInfo info = null;
            Boolean flag = true;
            int in2 = coll.size();
            for (int i = 0; i < in2; ++i) {
                info = (BgScenarioInfo)coll.get(i);
                if (canSet.contains(info.getId().toString())) continue;
                flag = false;
                break;
            }
            if (!flag.booleanValue()) continue;
            updateParentColl.add(account);
        }
        if (!canSet.isEmpty()) {
            ArrayList lst = new ArrayList(canSet);
            IObjectPK[] pkArrays = new IObjectPK[canSet.size()];
            int in3 = lst.size();
            for (int i = 0; i < in3; ++i) {
                pkArrays[i] = new ObjectUuidPK((String)lst.get(i));
            }
            super._deleteBatchData(ctx, pkArrays);
        }
        if (!updateParentColl.isEmpty()) {
            this.updateParent(ctx, (IObjectCollection)updateParentColl, true);
        }
        canSet.removeAll(idset);
        BgDimCacheUtils.clearDimMemberCache(ctx);
        BgDimCacheUtils.clearBgScenarioCache(ctx);
        return result;
    }

    private void updateParent(Context ctx, IObjectCollection colls, boolean isLeaf) throws BOSException {
        BgScenarioInfo version = null;
        BgScenarioInfo parentInfo = null;
        ArrayList<String> parentIDS = new ArrayList<String>();
        int in = colls.size();
        for (int i = 0; i < in; ++i) {
            version = (BgScenarioInfo)colls.getObject(i);
            if (version.getParent() == null || (parentInfo = version.getParent()).getId() == null) continue;
            parentIDS.add(parentInfo.getId().toString());
        }
        if (!parentIDS.isEmpty()) {
            PreparedStatement pstmt;
            Connection conn;
            block11: {
                int i;
                conn = null;
                pstmt = null;
                int batchSize = 50;
                int batchIndex = 0;
                int size = parentIDS.size();
                int count = (size - 1) / batchSize + 1;
                int pos = 0;
                int value = isLeaf ? 1 : 0;
                StringBuffer sql = new StringBuffer("update T_MBG_BgScenario set FIsLeaf = ? where FID in ( ");
                for (i = 1; i < batchSize; ++i) {
                    sql.append("?,");
                }
                sql.append("?)");
                try {
                    conn = this.getConnection(ctx);
                    pstmt = conn.prepareStatement(sql.toString());
                    for (i = 0; i < count; ++i) {
                        pstmt.setInt(1, value);
                        int j = 2;
                        while (j <= batchSize + 1) {
                            if (pos < size) {
                                pstmt.setString(j, (String)parentIDS.get(pos));
                            } else {
                                pstmt.setString(j, "#");
                            }
                            ++j;
                            ++pos;
                        }
                        pstmt.addBatch();
                        if (++batchIndex < batchSize) continue;
                        pstmt.executeBatch();
                        batchIndex = 0;
                    }
                    if (batchIndex == 0) break block11;
                    pstmt.executeBatch();
                }
                catch (SQLException e) {
                    try {
                        logger.error((Object)e);
                        throw new BOSException(e.getMessage());
                    }
                    catch (Throwable throwable) {
                        SQLUtils.cleanup(pstmt, (Connection)conn);
                        throw throwable;
                    }
                }
            }
            SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
        }
    }

    @Override
    protected IObjectPK _import4Scen(Context ctx, IObjectValue objVal) throws BOSException, EASBizException {
        return super._save(ctx, objVal);
    }
}

