/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.base.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSLocaleUtil;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.batch.BatchExecuteParamsEntry;
import com.kingdee.bos.framework.batch.BatchExecuteResult;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.TreeBaseCollection;
import com.kingdee.eas.framework.TreeBaseInfo;
import com.kingdee.eas.ma.base.AbstractMbgMemberInfo;
import com.kingdee.eas.ma.base.AbstractMbgViewInfo;
import com.kingdee.eas.ma.base.BgException;
import com.kingdee.eas.ma.base.IMbgMember;
import com.kingdee.eas.ma.base.MbgDimException;
import com.kingdee.eas.ma.base.MbgMemberCollection;
import com.kingdee.eas.ma.base.MbgMemberFactory;
import com.kingdee.eas.ma.base.MbgMemberInfo;
import com.kingdee.eas.ma.base.MbgMemberNodeCollection;
import com.kingdee.eas.ma.base.MbgMemberNodeFactory;
import com.kingdee.eas.ma.base.MbgViewFactory;
import com.kingdee.eas.ma.base.MbgViewInfo;
import com.kingdee.eas.ma.base.MemberSegregationRuleEnum;
import com.kingdee.eas.ma.base.app.AbstractMbgMemberControllerBean;
import com.kingdee.eas.ma.base.app.utils.BgIntIdHelper;
import com.kingdee.eas.ma.base.app.utils.MbgSqlHelper;
import com.kingdee.eas.ma.base.app.utils.TreeBaseParentChangeHelper;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.base.utils.BgCodeNumberHelper;
import com.kingdee.eas.ma.base.utils.BgCodeNumberNHelper;
import com.kingdee.eas.ma.base.utils.BgCommHelper;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.base.utils.BgDimCacheUtils;
import com.kingdee.eas.ma.base.utils.BgNumberHelper;
import com.kingdee.eas.ma.base.utils.MbgVirtualView;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.BaseException;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.log4j.Logger;

public class MbgMemberControllerBean
extends AbstractMbgMemberControllerBean {
    private static final long serialVersionUID = -8473113835524593807L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.base.app.MbgMemberControllerBean");

    public IObjectPK[] saveBatchData(Context ctx, CoreBaseCollection colls) throws BOSException, EASBizException {
        if (colls == null || colls.size() == 0) {
            return null;
        }
        this.checkCU(ctx, colls);
        this.addLog(ctx, (IObjectCollection)colls, "mbg_mbgmember_maintenance");
        FilterInfo baseFilter = new FilterInfo();
        baseFilter.getFilterItems().add(new FilterItemInfo("viewId", (Object)((MbgMemberInfo)colls.get(0)).getViewId().toString()));
        TreeBaseParentChangeHelper treeHelper = new TreeBaseParentChangeHelper(ctx, MbgMemberFactory.getLocalInstance(ctx), baseFilter);
        treeHelper.init((IObjectCollection)colls);
        BgIntIdHelper.setIntIdOnlyAddNew(ctx, (IObjectCollection)colls, ((MbgMemberInfo)colls.get(0)).getViewId().toString(), true);
        IObjectPK[] pks = super.saveBatchData(ctx, colls);
        this.updateParent(ctx, (IObjectCollection)colls, null, false);
        this.updateLeafMembers(ctx, (IObjectCollection)colls);
        treeHelper.updateParent();
        MbgVirtualView.getInstance(ctx).checkVirtualView((IObjectCollection)colls);
        BgDimCacheUtils.clearDimMemberCache(ctx);
        return pks;
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)((MbgMemberInfo)model).getNumber())) {
            BgCodeNumberHelper codeHelper = new BgCodeNumberHelper(ctx, null, null);
            codeHelper.init(model, ((MbgMemberInfo)model).getOrgunit().getId().toString());
            if (codeHelper.isHasCodeNumber()) {
                this.applyNumber(ctx, codeHelper, (MbgMemberInfo)model, ((MbgMemberInfo)model).getOrgunit().getId().toString());
            }
            if (StringUtils.isEmpty((String)((MbgMemberInfo)model).getNumber())) {
                ((MbgMemberInfo)model).setNumber("MbgMember-" + System.currentTimeMillis());
            }
        }
        if (((MbgMemberInfo)model).getNumber().length() > 80) {
            throw new MbgDimException(MbgDimException.NUMBERTOLONG);
        }
        if (!BgNumberHelper.checkNumber(((MbgMemberInfo)model).getNumber())) {
            throw new MbgDimException(MbgDimException.SPECIALCHARINNUMBER);
        }
        boolean hasSync = this.checkHasSyncFactData(ctx, model);
        this.checkNumDump(ctx, model);
        this.checkCU(ctx, model);
        this.updateTreeNodes(ctx, model);
        BgIntIdHelper.setIntIdOnlyAddNew(ctx, (CoreBaseInfo)((MbgMemberInfo)model), ((MbgMemberInfo)model).getViewId().toString(), true);
        IObjectPK pk = super._submit(ctx, model);
        if (hasSync) {
            CoreBaseCollection colls = new CoreBaseCollection();
            colls.addObject(model);
            MbgVirtualView.getInstance(ctx).checkVirtualView((IObjectCollection)colls);
            BgDimCacheUtils.clearDimMemberCache(ctx);
        }
        return pk;
    }

    private void applyNumber(Context ctx, BgCodeNumberHelper codeHelper, MbgMemberInfo model, String orgUnitId) throws EASBizException, BOSException {
        if (model.getNumber() != null) {
            return;
        }
        codeHelper.applyNumber((IObjectValue)model, orgUnitId, null);
        if (model.getNumber() != null && this._exists(ctx, "select id where number = '" + model.getNumber() + "'and viewid = '" + model.getViewId().toString() + "'")) {
            model.setNumber(null);
            this.applyNumber(ctx, codeHelper, model, orgUnitId);
        }
    }

    private boolean checkHasSyncFactData(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        if (ctx == null || model == null) {
            return false;
        }
        MbgMemberInfo member = (MbgMemberInfo)model;
        if (member.getId() == null) {
            return true;
        }
        String id = member.getId().toString();
        String number = member.getNumber();
        String parentId = member.getParent() != null ? member.getParent().getId().toString() : null;
        boolean hasSync = false;
        IRowSet rst = null;
        try {
            rst = StringUtils.isEmpty((String)parentId) ? BgDBUtils.executeQuery(ctx, "select FID from T_MBG_MbgMember where FID = ? and FNumber = ? and FParentId is null", new Object[]{id, number}) : BgDBUtils.executeQuery(ctx, "select FID from T_MBG_MbgMember where FID = ? and FNumber = ? and FParentId = ?", new Object[]{id, number, parentId});
            if (rst != null && !rst.next()) {
                hasSync = true;
            }
        }
        catch (SQLException ex) {
            try {
                throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst);
        return hasSync;
    }

    private void checkNumDump(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        if (model == null) {
            return;
        }
        MbgMemberInfo memberInfo = (MbgMemberInfo)model;
        String number = memberInfo.getNumber();
        String viewid = memberInfo.getViewId().toString();
        Object cn = null;
        Object pst = null;
        Object rst = null;
        MbgMemberInfo info = null;
        if (memberInfo.getId() != null ? this._exists(ctx, "select id where number = '" + number + "'and viewid = '" + viewid + "' and id <> '" + memberInfo.getId().toString() + "'") && (info = this.getMbgMemberInfo(ctx, "select id,orgunit.name,orgunit.number where number = '" + number + "'and viewid = '" + viewid + "' and id <> '" + memberInfo.getId().toString() + "'")) != null : this._exists(ctx, "select id where number = '" + number + "'and viewid = '" + viewid + "'") && (info = this.getMbgMemberInfo(ctx, "select id,orgunit.name,orgunit.number where number = '" + number + "'and viewid = '" + viewid + "'")) != null) {
            throw new MbgDimException(MbgDimException.EXISTSSAMEMEMBER, new Object[]{number, info.getOrgunit().getNumber(), info.getOrgunit().getName()});
        }
    }

    private void updateTreeNodes(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        if (ctx == null || model == null || ((MbgMemberInfo)model).getId() == null) {
            return;
        }
        MbgMemberInfo curMember = (MbgMemberInfo)model;
        if (!this._exists(ctx, "where id = '" + curMember.getId() + "'")) {
            return;
        }
        MbgMemberInfo oldValue = (MbgMemberInfo)this._getValue(ctx, (IObjectPK)new ObjectUuidPK(curMember.getId()));
        TreeBaseCollection coll = null;
        if (oldValue.getParent() != null && !curMember.getParent().getId().equals((Object)oldValue.getParent().getId())) {
            coll = this.getAllChildren(ctx, curMember);
            coll.addObject(0, (IObjectValue)curMember);
            this.checkCU(ctx, coll);
            this.updateAllChildsByCurMember(ctx, coll, curMember);
            this._saveBatchData(ctx, (IObjectCollection)coll);
            this.updateCurMemberParent(ctx, oldValue, curMember.getParent(), curMember.getViewId().toString());
        }
    }

    private void updateCurMemberParent(Context ctx, MbgMemberInfo model, MbgMemberInfo newParent, String viewId) throws EASBizException, BOSException {
        if (ctx == null || model == null || StringUtils.isEmpty((String)viewId)) {
            return;
        }
        String parentId = model.getParent().getId().toString();
        ObjectUuidPK curOldPk = new ObjectUuidPK(BOSUuid.read((String)parentId));
        IObjectValue curOldParentValue = this._getValue(ctx, (IObjectPK)curOldPk);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("isleaf"));
        if (!this._exists(ctx, "select id where viewId = '" + viewId + "' and parent.id = '" + parentId + "'")) {
            ((MbgMemberInfo)curOldParentValue).setIsLeaf(true);
            this.updatePartial(ctx, (MbgMemberInfo)curOldParentValue, sic);
        }
        if (newParent.isIsLeaf()) {
            newParent.setIsLeaf(false);
            this.updatePartial(ctx, newParent, sic);
        }
    }

    private void updateAllChildsByCurMember(Context ctx, TreeBaseCollection coll, MbgMemberInfo model) throws EASBizException, BOSException {
        if (coll == null || coll.isEmpty() || model == null) {
            return;
        }
        HashMap<String, MbgMemberInfo> memberParentCache = new HashMap<String, MbgMemberInfo>();
        ObjectUuidPK curPk = new ObjectUuidPK(model.getId());
        IObjectValue curValue = this._getValue(ctx, (IObjectPK)curPk);
        MbgMemberInfo newParentInfo = model.getParent();
        MbgMemberInfo newParentValue = (MbgMemberInfo)this._getValue(ctx, (IObjectPK)new ObjectUuidPK(newParentInfo.getId()));
        MbgMemberInfo childInfo = null;
        for (int i = 0; i < coll.size(); ++i) {
            childInfo = (MbgMemberInfo)coll.get(i);
            if (memberParentCache.containsKey(childInfo.getParent().getId().toString())) {
                newParentValue = (MbgMemberInfo)memberParentCache.get(childInfo.getParent().getId().toString());
                newParentValue.setIsLeaf(false);
            }
            childInfo.setLongNumber(newParentValue.getLongNumber() + "!" + childInfo.getNumber());
            childInfo.setLevel(newParentValue.getLevel() + 1);
            childInfo.setParent(newParentValue);
            memberParentCache.put(childInfo.getId().toString(), childInfo);
        }
    }

    private void checkCU(Context ctx, Object colls) throws MbgDimException, BOSException {
        if (ctx == null || colls == null) {
            return;
        }
        CtrlUnitInfo CU = ContextUtil.getCurrentCtrlUnit((Context)ctx);
        CoreBaseInfo coreBase = null;
        TreeBaseInfo treeBase = null;
        CoreBaseCollection coreCols = null;
        TreeBaseCollection treeCols = null;
        MbgMemberInfo mbgMember = null;
        if (colls instanceof CoreBaseCollection) {
            coreCols = (CoreBaseCollection)colls;
            for (int i = 0; i < coreCols.size(); ++i) {
                coreBase = coreCols.get(i);
                if (!(coreBase instanceof MbgMemberInfo) || (mbgMember = (MbgMemberInfo)coreBase).getCU() != null) continue;
                mbgMember.setCU(CU);
            }
        } else if (colls instanceof TreeBaseCollection) {
            treeCols = (TreeBaseCollection)colls;
            for (int i = 0; i < treeCols.size(); ++i) {
                treeBase = treeCols.get(i);
                if (!(treeBase instanceof MbgMemberInfo) || (mbgMember = (MbgMemberInfo)treeBase).getCU() != null) continue;
                mbgMember.setCU(CU);
            }
        } else if (colls instanceof MbgMemberInfo && (mbgMember = (MbgMemberInfo)colls).getCU() == null) {
            mbgMember.setCU(CU);
        }
    }

    private void checkLeaf(Context ctx, CoreBaseCollection colls) throws BOSException {
        if (colls.isEmpty()) {
            return;
        }
        HashMap<String, MbgMemberInfo> leafMap = new HashMap<String, MbgMemberInfo>();
        MbgMemberInfo memberInfo = null;
        for (int i = 0; i < colls.size(); ++i) {
            memberInfo = (MbgMemberInfo)colls.get(i);
            if (!memberInfo.isIsLeaf()) continue;
            leafMap.put(memberInfo.getId().toString(), memberInfo);
        }
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("name");
        sic.add("number");
        sic.add("isleaf");
        filter.getFilterItems().add(new FilterItemInfo("id", leafMap.keySet(), CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("isleaf", (Object)0, CompareType.EQUALS));
        evi.setSelector(sic);
        evi.setFilter(filter);
        MbgMemberCollection memberColls = MbgMemberFactory.getLocalInstance(ctx).getMbgMemberCollection(evi);
        if (memberColls.size() == 0) {
            return;
        }
        for (int i = 0; i < memberColls.size(); ++i) {
            ((MbgMemberInfo)leafMap.get(memberColls.get(i).getId().toString())).setIsLeaf(false);
        }
    }

    private void checkIsRef(Context ctx, CoreBaseCollection colls, String orgid) throws MbgDimException, BOSException {
        HashSet<String> addSets = new HashSet<String>();
        HashMap<String, String> tmpMap = new HashMap<String, String>();
        MbgMemberInfo memberInfo = null;
        for (int i = 0; i < colls.size(); ++i) {
            if (!(colls.get(i) instanceof MbgMemberInfo) || (memberInfo = (MbgMemberInfo)colls.get(i)).getParent() == null) continue;
            addSets.add(memberInfo.getParent().getId().toString());
            tmpMap.put(memberInfo.getParent().getId().toString(), memberInfo.getNumber());
        }
        Map<String, Set<String>> refMem = this.getRefMembers(ctx, addSets, orgid, false);
        if (refMem.get("ref_data") == null) {
            return;
        }
        if (!refMem.get("ref_data").isEmpty()) {
            StringBuffer buffer = new StringBuffer();
            Iterator<String> it = refMem.get("ref_data").iterator();
            while (it.hasNext()) {
                buffer.append((String)tmpMap.get(it.next())).append(",");
            }
            throw new MbgDimException(MbgDimException.EXISTBUDGETVALUE, new Object[]{buffer.toString().substring(0, buffer.toString().length() - 1)});
        }
    }

    @Override
    protected Map _deleteBatchData(Context ctx, Set idSets, String orgid) throws BOSException, EASBizException {
        if (idSets == null || idSets.isEmpty()) {
            return null;
        }
        HashMap<String, HashSet<String>> childMap = new HashMap<String, HashSet<String>>();
        HashMap<String, HashSet<String>> parentIDMaps = new HashMap<String, HashSet<String>>();
        HashMap<MbgMemberInfo, MbgMemberInfo> parentMap = new HashMap<MbgMemberInfo, MbgMemberInfo>();
        HashSet<String> needDeleteIDS = new HashSet<String>();
        HashMap<String, MbgMemberInfo> needDeleteInfo = new HashMap<String, MbgMemberInfo>();
        HashSet<String> sysDefaultIDS = new HashSet<String>();
        MbgMemberInfo memberInfo = null;
        TreeBaseCollection coll = null;
        MbgMemberCollection memberColls = this.getMbgMemberCollByIds(ctx, idSets);
        HashSet<String> selectIDS = new HashSet<String>();
        StringBuffer msg = new StringBuffer();
        int in = memberColls.size();
        for (int i = 0; i < in; ++i) {
            memberInfo = memberColls.get(i);
            selectIDS.add(memberInfo.getId().toString());
            if (!orgid.equals(memberInfo.getOrgunit().getId().toString())) {
                msg.append(EASResource.getString((String)"com.kingdee.eas.ma.base.MbgDimResource", (String)"cantDeleteMemberByOthOrg", (Object[])new Object[]{memberInfo.getNumber(), memberInfo.getName()}) + "\n");
                continue;
            }
            if (memberInfo.isIsSystemDefault()) {
                sysDefaultIDS.add(memberInfo.getId().toString());
                msg.append(EASResource.getString((String)"com.kingdee.eas.ma.base.MbgDimResource", (String)"cantDeleteSysDefault", (Object[])new Object[]{memberInfo.getNumber(), memberInfo.getName()}) + "\n");
                continue;
            }
            if (!childMap.containsKey(memberInfo.getId().toString())) {
                childMap.put(memberInfo.getId().toString(), new HashSet());
            }
            coll = this.getAllChildren(ctx, memberInfo);
            Object child = null;
            int jn = coll.size();
            for (int j = 0; j < jn; ++j) {
                child = (MbgMemberInfo)coll.get(j);
                if (((AbstractMbgMemberInfo)child).isIsSystemDefault()) {
                    sysDefaultIDS.add(child.getId().toString());
                }
                needDeleteIDS.add(child.getId().toString());
                needDeleteInfo.put(child.getId().toString(), (MbgMemberInfo)child);
                if (!parentIDMaps.containsKey(child.getId().toString())) {
                    parentIDMaps.put(child.getId().toString(), new HashSet());
                }
                ((HashSet)parentIDMaps.get(child.getId().toString())).add(memberInfo.getId().toString());
                this.recursionParent(coll, parentIDMaps, (MbgMemberInfo)child);
                if (childMap.containsKey(memberInfo.getId().toString())) {
                    ((HashSet)childMap.get(memberInfo.getId().toString())).add(child.getId().toString());
                }
                this.recursionChild(coll, childMap, (MbgMemberInfo)child);
            }
            needDeleteIDS.add(memberInfo.getId().toString());
            needDeleteInfo.put(memberInfo.getId().toString(), memberInfo);
            if (memberInfo.getParent() == null) continue;
            parentMap.put(memberInfo, memberInfo.getParent());
            if (!parentIDMaps.containsKey(memberInfo.getId().toString())) {
                parentIDMaps.put(memberInfo.getId().toString(), new HashSet());
                ((HashSet)parentIDMaps.get(memberInfo.getId().toString())).add(memberInfo.getParent().getId().toString());
                continue;
            }
            ((HashSet)parentIDMaps.get(memberInfo.getId().toString())).add(memberInfo.getParent().getId().toString());
        }
        MbgMemberInfo parent = null;
        MbgMemberCollection updateParentColl = new MbgMemberCollection();
        for (MbgMemberInfo member : parentMap.keySet()) {
            parent = (MbgMemberInfo)parentMap.get(member);
            coll = this.getAllChildren(ctx, parent);
            MbgMemberInfo info = null;
            Boolean flag = true;
            int in2 = coll.size();
            for (int i = 0; i < in2; ++i) {
                info = (MbgMemberInfo)coll.get(i);
                if (needDeleteIDS.contains(info.getId().toString())) continue;
                flag = false;
                break;
            }
            if (!flag.booleanValue()) continue;
            updateParentColl.add(member);
        }
        Map returnMap = this._checkRef(ctx, needDeleteIDS, orgid, true);
        needDeleteIDS = this.reFilterDeleteIds(returnMap, needDeleteIDS, needDeleteInfo, msg, childMap, parentIDMaps, selectIDS);
        AbstractMbgViewInfo info = null;
        if (memberInfo != null) {
            info = MbgViewFactory.getLocalInstance(ctx).getMbgViewInfo((IObjectPK)new ObjectUuidPK(memberInfo.getViewId()));
        }
        if (info != null && info.getSegregationRule().getValue() == 2) {
            needDeleteIDS = this.filterDeleteIdsByDispatch(ctx, needDeleteIDS, needDeleteInfo, msg, childMap, parentIDMaps, selectIDS);
        }
        if (!needDeleteIDS.isEmpty()) {
            ArrayList<String> lst = new ArrayList<String>(needDeleteIDS);
            IObjectPK[] pkArrays = new IObjectPK[needDeleteIDS.size()];
            MbgMemberCollection deColls = this.getMbgMemberCollByIds(ctx, needDeleteIDS);
            this.addLog(ctx, (IObjectCollection)deColls, "mbg_mbgmember_maintenance");
            int in3 = lst.size();
            for (int i = 0; i < in3; ++i) {
                pkArrays[i] = new ObjectUuidPK((String)lst.get(i));
            }
            super._deleteBatchData(ctx, pkArrays);
            String sql = "delete from t_mbg_mbgmembernode where FmbgMemberid in(?)";
            Connection conn = null;
            try {
                conn = this.getConnection(ctx);
                MbgSqlHelper.executeBatch(conn, sql, lst);
            }
            catch (SQLException e) {
                logger.error((Object)e);
                throw new BOSException(e.getMessage());
            }
            finally {
                SQLUtils.cleanup((Connection)conn);
            }
            int in4 = deColls.size();
            for (int i = 0; i < in4; ++i) {
                BgCodeNumberNHelper.recycleNumber(ctx, deColls.getObject(i), deColls.get(i).getOrgunit().getId().toString(), deColls.get(i).getNumber());
            }
        }
        if (!updateParentColl.isEmpty()) {
            MbgMemberInfo mbgMemberInfo = null;
            Iterator iterator = updateParentColl.iterator();
            while (iterator.hasNext()) {
                mbgMemberInfo = (MbgMemberInfo)iterator.next();
                if (needDeleteIDS.contains(mbgMemberInfo.getId().toString())) continue;
                iterator.remove();
            }
            this.updateParent(ctx, (IObjectCollection)updateParentColl, childMap, true);
        }
        returnMap.put("delete_success", needDeleteIDS);
        MbgVirtualView.getInstance(ctx).checkVirtualView((IObjectCollection)memberColls);
        BgDimCacheUtils.clearDimMemberCache(ctx);
        HashMap<String, String> resultMap = new HashMap<String, String>();
        if (msg.length() > 0) {
            if (needDeleteIDS.size() == 0) {
                resultMap.put("delete_result", "delete_fail");
                resultMap.put("delete_fail", msg.toString());
            } else {
                resultMap.put("delete_result", msg.toString());
            }
        } else {
            resultMap.put("delete_result", "delete_success");
        }
        return resultMap;
    }

    private void recursionParent(TreeBaseCollection coll, Map<String, HashSet<String>> parentIDMaps, MbgMemberInfo memberInfo) {
        MbgMemberInfo parent = null;
        for (int i = 0; i < coll.size(); ++i) {
            parent = (MbgMemberInfo)coll.get(i);
            if (!memberInfo.getLongNumber().startsWith(parent.getLongNumber() + "!")) continue;
            parentIDMaps.get(memberInfo.getId().toString()).add(parent.getId().toString());
        }
    }

    private void recursionChild(TreeBaseCollection coll, Map<String, HashSet<String>> childMaps, MbgMemberInfo memberInfo) {
        MbgMemberInfo child = null;
        if (!childMaps.containsKey(memberInfo.getId().toString())) {
            childMaps.put(memberInfo.getId().toString(), new HashSet());
        }
        for (int i = 0; i < coll.size(); ++i) {
            child = (MbgMemberInfo)coll.get(i);
            if (!child.getLongNumber().startsWith(memberInfo.getLongNumber() + "!")) continue;
            childMaps.get(memberInfo.getId().toString()).add(child.getId().toString());
        }
    }

    protected FilterInfo getFilterForDefaultCU(Context ctx, IObjectValue model) {
        FilterInfo curFilter = new FilterInfo();
        MbgMemberInfo mbgMemberInfo = (MbgMemberInfo)model;
        if (mbgMemberInfo.getViewId() == null) {
            try {
                mbgMemberInfo = (MbgMemberInfo)this._getValue(ctx, "select viewid where id = '" + ((MbgMemberInfo)model).getId().toString() + "'");
            }
            catch (EASBizException e) {
                logger.error((Object)"get bgaccview error", (Throwable)e);
            }
            catch (BOSException e) {
                logger.error((Object)"get bgaccview error", (Throwable)e);
            }
        }
        curFilter.getFilterItems().add(new FilterItemInfo("Viewid", (Object)mbgMemberInfo.getViewId().toString(), CompareType.EQUALS));
        return curFilter;
    }

    private HashSet<String> filterDeleteIdsByDispatch(Context ctx, HashSet<String> needDeleteIDS, Map<String, MbgMemberInfo> needDeleteInfo, StringBuffer msg, Map<String, HashSet<String>> childMap, Map<String, HashSet<String>> parentIDMap, HashSet<String> selectIDS) throws BOSException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("mbgMember.id");
        sic.add("orgunit.name");
        filter.getFilterItems().add(new FilterItemInfo("mbgMember.id", needDeleteIDS, CompareType.INCLUDE));
        evi.setSelector(sic);
        evi.setFilter(filter);
        MbgMemberNodeCollection colls = MbgMemberNodeFactory.getLocalInstance(ctx).getMbgMemberNodeCollection(evi);
        String id = null;
        String key2 = null;
        HashSet<String> exsitId = new HashSet<String>();
        HashSet<String> selectChildIDS = new HashSet<String>();
        LinkedHashSet<String> allSet = new LinkedHashSet<String>();
        TreeSet<MbgMemberInfo> needDeleteInfoSet = new TreeSet<MbgMemberInfo>(new Comparator<MbgMemberInfo>(){

            @Override
            public int compare(MbgMemberInfo o1, MbgMemberInfo o2) {
                return o1.getLongNumber().compareTo(o2.getLongNumber());
            }
        });
        for (int i = 0; i < colls.size(); ++i) {
            id = colls.get(i).getMbgMember().getId().toString();
            if (!needDeleteInfo.containsKey(id)) continue;
            needDeleteInfoSet.add(needDeleteInfo.get(id));
        }
        for (MbgMemberInfo mbgMemberInfo : needDeleteInfoSet) {
            allSet.add(mbgMemberInfo.getId().toString());
        }
        for (String value : allSet) {
            if (!needDeleteIDS.contains(value)) continue;
            needDeleteIDS.remove(value);
            if (childMap.containsKey(value)) {
                selectChildIDS.clear();
                for (String key2 : childMap.get(value)) {
                    if (!selectIDS.contains(key2) || !childMap.containsKey(key2)) continue;
                    if (!selectIDS.contains(value)) {
                        selectChildIDS.add(key2);
                        selectChildIDS.addAll((Collection)childMap.get(key2));
                        continue;
                    }
                    if (!selectIDS.contains(key2)) continue;
                    selectChildIDS.add(key2);
                    selectChildIDS.addAll((Collection)childMap.get(key2));
                }
                for (String key2 : childMap.get(value)) {
                    if (selectChildIDS.contains(key2)) continue;
                    needDeleteIDS.remove(key2);
                }
            }
            if (needDeleteInfo.containsKey(value)) {
                exsitId.add(value);
                msg.append(EASResource.getString((String)"com.kingdee.eas.ma.base.MbgDimResource", (String)"cantDeleteDisplayed", (Object[])new Object[]{needDeleteInfo.get(value).getNumber(), needDeleteInfo.get(value).getName()}) + "\n");
            }
            if (!parentIDMap.containsKey(value)) continue;
            needDeleteIDS.removeAll((Collection)parentIDMap.get(value));
            for (String ids : parentIDMap.get(value)) {
                if (exsitId.contains(ids)) continue;
                exsitId.add(ids);
                if (needDeleteInfo.get(parentIDMap.get(value)) == null) continue;
                msg.append(EASResource.getString((String)"com.kingdee.eas.ma.base.MbgDimResource", (String)"cantDeleteDispatchChild", (Object[])new Object[]{needDeleteInfo.get(parentIDMap.get(value)).getNumber(), needDeleteInfo.get(parentIDMap.get(value)).getName()}) + "\n");
            }
        }
        return needDeleteIDS;
    }

    private HashSet<String> reFilterDeleteIds(Map<String, HashSet<String>> returnMap, HashSet<String> needDeleteIDS, Map<String, MbgMemberInfo> needDeleteInfo, StringBuffer msg, Map<String, HashSet<String>> childMap, Map<String, HashSet<String>> parentIDMap, HashSet<String> selectIDS) {
        if (returnMap == null || returnMap.isEmpty()) {
            return needDeleteIDS;
        }
        HashSet<String> exsitId = new HashSet<String>();
        LinkedHashSet<String> allSet = new LinkedHashSet<String>();
        Iterator<String> ite = returnMap.keySet().iterator();
        while (ite.hasNext()) {
            allSet.addAll((Collection)returnMap.get(ite.next()));
        }
        String key2 = null;
        HashSet<String> selectChildIDS = new HashSet<String>();
        if (allSet != null && !allSet.isEmpty()) {
            TreeSet<MbgMemberInfo> needDeleteInfoSet = new TreeSet<MbgMemberInfo>(new Comparator<MbgMemberInfo>(){

                @Override
                public int compare(MbgMemberInfo o1, MbgMemberInfo o2) {
                    return o1.getLongNumber().compareTo(o2.getLongNumber());
                }
            });
            for (String id : allSet) {
                if (!needDeleteInfo.containsKey(id)) continue;
                needDeleteInfoSet.add(needDeleteInfo.get(id));
            }
            allSet.clear();
            for (MbgMemberInfo mbgMemberInfo : needDeleteInfoSet) {
                allSet.add(mbgMemberInfo.getId().toString());
            }
            for (String value : allSet) {
                if (!needDeleteIDS.contains(value)) continue;
                if (needDeleteIDS.contains(value)) {
                    needDeleteIDS.remove(value);
                }
                if (childMap.containsKey(value)) {
                    selectChildIDS.clear();
                    for (String key2 : childMap.get(value)) {
                        if (!selectIDS.contains(key2) || !childMap.containsKey(key2)) continue;
                        if (!selectIDS.contains(value)) {
                            selectChildIDS.add(key2);
                            selectChildIDS.addAll((Collection)childMap.get(key2));
                            continue;
                        }
                        if (!selectIDS.contains(key2)) continue;
                        selectChildIDS.add(key2);
                        selectChildIDS.addAll((Collection)childMap.get(key2));
                    }
                    for (String key2 : childMap.get(value)) {
                        if (selectChildIDS.contains(key2)) continue;
                        needDeleteIDS.remove(key2);
                    }
                }
                if (needDeleteInfo.containsKey(value)) {
                    exsitId.add(value);
                    msg.append(EASResource.getString((String)"com.kingdee.eas.ma.base.MbgDimResource", (String)"cantDeleteByhasRef", (Object[])new Object[]{needDeleteInfo.get(value).getNumber(), needDeleteInfo.get(value).getName()}) + "\n");
                }
                if (!parentIDMap.containsKey(value)) continue;
                needDeleteIDS.removeAll((Collection)parentIDMap.get(value));
                for (String ids : parentIDMap.get(value)) {
                    if (exsitId.contains(ids)) continue;
                    exsitId.add(ids);
                    if (needDeleteInfo.get(ids) == null) continue;
                    msg.append(EASResource.getString((String)"com.kingdee.eas.ma.base.MbgDimResource", (String)"cantDeleteByhasRefChild", (Object[])new Object[]{needDeleteInfo.get(ids).getNumber(), needDeleteInfo.get(ids).getName()}) + "\n");
                }
            }
        }
        return needDeleteIDS;
    }

    private TreeBaseCollection getAllChildren(Context ctx, MbgMemberInfo memberInfo) throws EASBizException, BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("viewId", (Object)memberInfo.getViewId(), CompareType.EQUALS));
        view.setFilter(filter);
        view.setSorter(new SorterItemCollection());
        SorterItemInfo sortorLongNum = new SorterItemInfo("level");
        sortorLongNum.setSortType(SortType.ASCEND);
        view.getSorter().add(sortorLongNum);
        return this.getAllChildren(ctx, memberInfo, view);
    }

    private void updateParent(Context ctx, IObjectCollection colls, Map<String, HashSet<String>> childMap, boolean isLeaf) throws BOSException {
        MbgMemberInfo memberInfo = null;
        MbgMemberInfo parentInfo = null;
        ArrayList<String> parentIDS = new ArrayList<String>();
        int in = colls.size();
        for (int i = 0; i < in; ++i) {
            memberInfo = (MbgMemberInfo)colls.getObject(i);
            if (memberInfo.getParent() == null || (parentInfo = memberInfo.getParent()).getId() == null) continue;
            if (childMap != null && childMap.containsKey(parentInfo.getId().toString())) {
                childMap.get(parentInfo.getId().toString()).removeAll((Collection)childMap.get(memberInfo.getId().toString()));
                childMap.get(parentInfo.getId().toString()).remove(memberInfo.getId().toString());
            }
            if (childMap != null && childMap.get(parentInfo.getId().toString()) != null && !childMap.get(parentInfo.getId().toString()).isEmpty()) continue;
            parentIDS.add(parentInfo.getId().toString());
        }
        if (!parentIDS.isEmpty()) {
            int i;
            Connection conn = null;
            PreparedStatement pstmt = null;
            int batchSize = 50;
            int batchIndex = 0;
            int size = parentIDS.size();
            int count = (size - 1) / batchSize + 1;
            int pos = 0;
            int value = isLeaf ? 1 : 0;
            StringBuffer sql = new StringBuffer("update T_MBG_MbgMember set FIsLeaf = ? where FID in ( ");
            for (i = 1; i < batchSize; ++i) {
                sql.append("?,");
            }
            sql.append("?)");
            try {
                conn = this.getConnection(ctx);
                pstmt = conn.prepareStatement(sql.toString());
                for (i = 0; i < count; ++i) {
                    pstmt.setInt(1, value);
                    int j = 2;
                    while (j <= batchSize + 1) {
                        if (pos < size) {
                            pstmt.setString(j, (String)parentIDS.get(pos));
                        } else {
                            pstmt.setString(j, "#");
                        }
                        ++j;
                        ++pos;
                    }
                    pstmt.addBatch();
                    if (++batchIndex < batchSize) continue;
                    pstmt.executeBatch();
                    batchIndex = 0;
                }
                if (batchIndex != 0) {
                    pstmt.executeBatch();
                }
                BgDBUtils.executeUpdate(conn, "update T_MBG_MbgMember set FIsLeaf = 0 where FIsLeaf = 1 and FID in (select FParentId from T_MBG_MbgMember)");
            }
            catch (SQLException e) {
                try {
                    logger.error((Object)e);
                    throw new BOSException(e.getMessage());
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(pstmt, (Connection)conn);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
        }
    }

    private void removeNotLeaf(Context ctx, List<String> parentIDS, Set<String> addIds) throws BOSException {
        if (parentIDS.isEmpty() || addIds.isEmpty()) {
            return;
        }
        ArrayList<String> notLeafSet = new ArrayList<String>();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("name");
        sic.add("number");
        sic.add("isleaf");
        filter.getFilterItems().add(new FilterItemInfo("id", addIds, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("isleaf", (Object)0, CompareType.EQUALS));
        evi.setSelector(sic);
        evi.setFilter(filter);
        MbgMemberCollection colls = MbgMemberFactory.getLocalInstance(ctx).getMbgMemberCollection(evi);
        for (int i = 0; i < colls.size(); ++i) {
            notLeafSet.add(colls.get(i).getId().toString());
        }
        parentIDS.removeAll(notLeafSet);
    }

    private void printLog(Context ctx, MbgMemberInfo info, String logItem) {
        String logName = info.getNumber() + " " + info.getName();
        IObjectPK tempPK = LogUtil.beginLog((Context)ctx, (String)"updateInfo", (BOSObjectType)this.getBOSType(), null, (String)logName, (String)logItem);
        LogUtil.afterLog((Context)ctx, (IObjectPK)tempPK);
    }

    private void addLog(Context ctx, IObjectCollection colls, String logItem) {
        if (colls == null || colls.isEmpty()) {
            return;
        }
        MbgMemberInfo info = null;
        int in = colls.size();
        for (int i = 0; i < in; ++i) {
            info = (MbgMemberInfo)colls.getObject(i);
            this.printLog(ctx, info, logItem);
        }
    }

    @Override
    protected Map _checkRef(Context ctx, Set idSet, String orgid) throws BOSException, EASBizException {
        return this._checkRef(ctx, idSet, orgid, false);
    }

    private Map _checkRef(Context ctx, Set idSet, String orgid, boolean isDelete) throws BOSException, EASBizException {
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        if (ctx == null || idSet.isEmpty()) {
            return result;
        }
        Map<String, Set<String>> refDim = this.getRefDimRelations(ctx, idSet, orgid);
        Map<Object, Object> refBiz = new HashMap();
        if (isDelete) {
            refBiz = this.getRefBiz(ctx, idSet);
        }
        Map<String, Set<String>> refMem = this.getRefMembers(ctx, idSet, orgid, isDelete);
        result.putAll(refDim);
        result.putAll(refBiz);
        result.putAll(refMem);
        return result;
    }

    private Map<String, Set<String>> getRefBiz(Context ctx, Set<String> mbgMemberIds) throws BOSException {
        HashMap<String, Set<String>> refBiz = new HashMap<String, Set<String>>();
        refBiz.put("ref_biz", new HashSet());
        if (ctx == null || mbgMemberIds == null || mbgMemberIds.isEmpty()) {
            return refBiz;
        }
        HashSet<String> schemeBiz = null;
        HashMap map = new HashMap();
        Connection connection = null;
        PreparedStatement pst = null;
        ResultSet rst = null;
        try {
            connection = this.getConnection(ctx);
            Map<String, Set<String>> schemeView = this.queryViewScheme(connection, pst, rst);
            String sql = "SELECT cl.FBGMEMBERNUM, ru.FFORMULA,s.FID   FROM T_MBG_BizCalcSubSet ru left join t_mbg_bizscope cl on cl.FBIZCALCSUBSETID  = ru.FID inner join T_MBG_BizCalc bc on bc.fid = ru.fbizcalcid inner join t_mbg_bgscheme s on s.FID  = bc.FBgSchemeId ";
            pst = connection.prepareStatement(sql);
            rst = pst.executeQuery();
            byte[] formula = null;
            String scopeNum = null;
            String schemeid2 = null;
            String _bizFormula = null;
            while (rst.next()) {
                scopeNum = rst.getString(1);
                formula = rst.getBytes(2);
                schemeid2 = rst.getString(3);
                if (map.containsKey(schemeid2)) {
                    if (formula != null && formula.length > 0) {
                        _bizFormula = (String)BgCommHelper.getObject(formula);
                        ((Set)map.get(schemeid2)).add(_bizFormula);
                    }
                    if (scopeNum == null) continue;
                    ((Set)map.get(schemeid2)).add(scopeNum);
                    continue;
                }
                schemeBiz = new HashSet<String>();
                if (formula != null && formula.length > 0) {
                    _bizFormula = (String)BgCommHelper.getObject(formula);
                    schemeBiz.add(_bizFormula);
                }
                if (scopeNum != null) {
                    schemeBiz.add(scopeNum);
                }
                map.put(schemeid2, schemeBiz);
            }
            SQLUtils.cleanup((ResultSet)rst, (Statement)pst);
            if (!schemeView.isEmpty() && !map.isEmpty()) {
                MbgMemberCollection colls = this.getMbgMemberCollByIds(ctx, mbgMemberIds);
                MbgMemberInfo info = null;
                String dimNumber = null;
                String constans2 = null;
                int size = colls.size();
                for (int index = 0; index < size; ++index) {
                    info = colls.get(index);
                    if (!schemeView.containsKey(info.getViewId().toString())) continue;
                    Set<String> schemeIds = schemeView.get(info.getViewId().toString());
                    block6: for (String schemeid2 : schemeIds) {
                        if (!map.containsKey(schemeid2)) continue;
                        dimNumber = info.getMbgDim().getSrcNumber() + ":" + info.getNumber();
                        for (String constans2 : (Set)map.get(schemeid2)) {
                            if (!constans2.contains(dimNumber)) continue;
                            ((Set)refBiz.get("ref_biz")).add(info.getId().toString());
                            continue block6;
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            try {
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pst, (Connection)connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pst, (Connection)connection);
        return refBiz;
    }

    private Map<String, Set<String>> getRefDimRelations(Context ctx, Set<String> mbgMemberIds, String orgid) throws BOSException {
        return this.getRefDimRelations(ctx, null, mbgMemberIds, orgid);
    }

    private Map<String, Set<String>> getRefDimRelations(Context ctx, String dimNumber, Set<String> mbgMemberIds, String orgid) throws BOSException {
        HashMap<String, Set<String>> refDim = new HashMap<String, Set<String>>();
        refDim.put("ref_dimRelation", new HashSet());
        if (ctx == null || mbgMemberIds == null || mbgMemberIds.isEmpty()) {
            return refDim;
        }
        HashMap schemeDimMems = new HashMap();
        Connection connection = null;
        PreparedStatement pst = null;
        ResultSet rst = null;
        StringBuffer querySql = new StringBuffer();
        try {
            connection = this.getConnection(ctx);
            Map<String, Set<String>> schemeView = this.queryViewScheme(connection, pst, rst);
            querySql.append("SELECT distinct s.FID, re.FDimensionNumber FROM T_MBG_DimensionRelationship re ").append("inner join T_MBG_DimensionRelationGroup  g on g.FID  = re.FDIMENSIONGROUPID ").append("inner join t_mbg_bgscheme s on s.FID  = g.FBgSchemeId ").append("inner join T_MBG_BgDimSettings st on st.FBgSchemeID = s.fid ").append("inner join T_MBG_DimRelashipGroupEntry entry on entry.FDIMRELASHIPGROUPID  = g.FID ").append("WHERE re.FCostUnitID = ?");
            if (!StringUtils.isEmpty((String)dimNumber)) {
                querySql.append(" and ENTRY.FDIMNUMBER = ? ");
            }
            pst = connection.prepareStatement(querySql.toString());
            pst.setString(1, orgid);
            if (!StringUtils.isEmpty((String)dimNumber)) {
                pst.setString(2, dimNumber);
            }
            rst = pst.executeQuery();
            String schemeId2 = null;
            String dimNum = null;
            String[] dimNums = null;
            while (rst.next()) {
                schemeId2 = rst.getString(1);
                dimNum = rst.getString(2);
                dimNums = dimNum.split(",");
                for (int i = 0; i < dimNums.length; ++i) {
                    if (!schemeDimMems.containsKey(schemeId2)) {
                        schemeDimMems.put(schemeId2, new HashSet());
                    }
                    ((Set)schemeDimMems.get(schemeId2)).addAll(this.processDimNum(dimNum));
                }
            }
            SQLUtils.cleanup((ResultSet)rst, (Statement)pst);
            if (!schemeView.isEmpty() && !schemeDimMems.isEmpty()) {
                MbgMemberCollection colls = this.getMbgMemberCollByViewIds(connection, "", mbgMemberIds);
                Set numLst = null;
                MbgMemberInfo info = null;
                String viewId = null;
                int size = colls.size();
                for (int index = 0; index < size; ++index) {
                    info = colls.get(index);
                    viewId = info.getViewId().toString();
                    if (!schemeView.containsKey(viewId)) continue;
                    Set<String> schemeIds = schemeView.get(viewId);
                    for (String schemeId2 : schemeIds) {
                        if (!schemeDimMems.containsKey(schemeId2) || !(numLst = (Set)schemeDimMems.get(schemeId2)).contains(info.getNumber())) continue;
                        ((Set)refDim.get("ref_dimRelation")).add(info.getId().toString());
                    }
                }
            }
        }
        catch (Exception e) {
            try {
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pst, (Connection)connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pst, (Connection)connection);
        return refDim;
    }

    private MbgMemberCollection getMbgMemberCollByViewIds(Connection conn, String viewId, Set<String> mbgMemberIds) {
        MbgMemberCollection memColls = new MbgMemberCollection();
        if (conn == null || mbgMemberIds == null || mbgMemberIds.isEmpty()) {
            return memColls;
        }
        MbgMemberInfo memberInfo = null;
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT FID,FNUMBER,FVIEWID FROM T_MBG_MBGMEMBER WHERE FID IN ").append(this.getAppendStrByColls(mbgMemberIds));
        IRowSet rst = null;
        try {
            rst = BgDBUtils.executeQuery(conn, sql.substring(0, sql.length() - 1) + ")");
            while (rst.next()) {
                memberInfo = new MbgMemberInfo();
                memberInfo.setId(BOSUuid.read((String)rst.getString("FID")));
                memberInfo.setViewId(BOSUuid.read((String)rst.getString("FVIEWID")));
                memberInfo.setNumber(rst.getString("FNUMBER"));
                memColls.add(memberInfo);
            }
        }
        catch (Exception e) {
            logger.error((Object)" query error ", (Throwable)e);
        }
        return memColls;
    }

    private String getAppendStrByColls(Set<String> userGroupIds) {
        if (userGroupIds == null || userGroupIds.isEmpty()) {
            return null;
        }
        StringBuffer selectGroupStr = new StringBuffer();
        selectGroupStr.append("(");
        Iterator<String> it = userGroupIds.iterator();
        while (it.hasNext()) {
            selectGroupStr.append("'").append(it.next()).append("',");
        }
        selectGroupStr.delete(selectGroupStr.length() - 1, selectGroupStr.length()).append(")");
        return selectGroupStr.toString();
    }

    private MbgMemberCollection getMbgMemberCollByIds(Context ctx, Set idSet) throws BOSException {
        IMbgMember iMbgMember = MbgMemberFactory.getLocalInstance(ctx);
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("number");
        sic.add("name");
        sic.add("longNumber");
        sic.add("mbgDim.id");
        sic.add("mbgDim.number");
        sic.add("mbgDim.srcNumber");
        sic.add("parent.id");
        sic.add("parent.number");
        sic.add("parent.name");
        sic.add("parent.longNumber");
        sic.add("parent.viewId");
        sic.add("viewId");
        sic.add("isSystemDefault");
        sic.add("orgunit.id");
        sic.add("orgunit.number");
        sic.add("orgunit.name");
        sic.add("CU.id");
        sic.add("CU.number");
        sic.add("CU.name");
        view.getSelector().addObjectCollection((IObjectCollection)sic);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        view.setFilter(filter);
        view.setSorter(new SorterItemCollection());
        view.getSorter().add(new SorterItemInfo("longNumber"));
        return iMbgMember.getMbgMemberCollection(view);
    }

    private Set<String> processDimNum(String dimNum) {
        HashSet<String> extDimNumber = new HashSet<String>();
        String[] dimNums = dimNum.split(",");
        for (int i = 0; i < dimNums.length; ++i) {
            extDimNumber.add(dimNums[i].substring(4, dimNums[i].length()));
        }
        return extDimNumber;
    }

    private Map<String, Set<String>> queryViewScheme(Connection connection, PreparedStatement pst, ResultSet rst) throws BOSException {
        HashMap<String, Set<String>> schemeView = new HashMap<String, Set<String>>();
        String schemeId = null;
        String dimViewId = null;
        HashSet<String> viewSets = null;
        try {
            String sql = "SELECT s.FBgSchemeID, m.FMemberId FROM T_MBG_BgDimSettingsMember m left join T_MBG_BgDimSettings s on s.fid = m.FBgDimSettingsID where s.fdimNumber  not in ( 'BG_Account','BG_Period','BG_Scenario','BG_Version','BG_Currency','BG_Organization','BG_Element')";
            pst = connection.prepareStatement(sql);
            rst = pst.executeQuery();
            while (rst.next()) {
                schemeId = rst.getString(1);
                dimViewId = rst.getString(2);
                if (schemeView.containsKey(dimViewId)) {
                    ((Set)schemeView.get(dimViewId)).add(schemeId);
                    continue;
                }
                viewSets = new HashSet<String>();
                viewSets.add(schemeId);
                schemeView.put(dimViewId, viewSets);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException(e.getMessage());
        }
        finally {
            SQLUtils.cleanup((ResultSet)rst, (Statement)pst);
        }
        return schemeView;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<String, Set<String>> getRefMembers(Context ctx, Set<String> mbgMemberIds, String orgid, boolean isDelete) throws BOSException {
        ResultSet rst;
        PreparedStatement pst;
        Connection connection;
        HashMap<String, Set<String>> refMem;
        block9: {
            refMem = new HashMap<String, Set<String>>();
            if (ctx == null) return refMem;
            if (mbgMemberIds == null) return refMem;
            if (mbgMemberIds.isEmpty()) {
                return refMem;
            }
            ArrayList<Object[]> params = new ArrayList<Object[]>();
            for (String id : mbgMemberIds) {
                params.add(new Object[]{id});
            }
            connection = null;
            pst = null;
            rst = null;
            TempTablePool pool = TempTablePool.getInstance((Context)ctx);
            String tmpTable = null;
            try {
                connection = this.getConnection(ctx);
                tmpTable = pool.createTempTable("Create Table TMP_MBG_TEMPTABLE(FMbgMemberID Varchar(44) NOT NULL)");
                DbUtil.executeBatch((Context)ctx, (String)("Insert Into " + tmpTable + "(FMbgMemberID) Values(?)"), params);
                pst = isDelete ? connection.prepareStatement("select FRefType, FBaseDataID from T_MBG_BgRefDimMember where FBaseDataID in (select FMbgMemberID from " + tmpTable + ") ") : connection.prepareStatement("select FRefType, FBaseDataID from T_MBG_BgRefDimMember where FBaseDataID in (select FMbgMemberID from " + tmpTable + ") and FOtherID = '" + orgid + "'");
                rst = pst.executeQuery();
                Integer refType = null;
                String baseDateId = null;
                String refStr = null;
                while (rst.next()) {
                    refType = rst.getInt(1);
                    baseDateId = rst.getString(2);
                    refStr = this.transRefStr(refType);
                    if (!refMem.containsKey(refStr)) {
                        refMem.put(refStr, new HashSet());
                    }
                    ((Set)refMem.get(refStr)).add(baseDateId);
                }
                if (tmpTable == null) break block9;
            }
            catch (Exception e) {
                try {
                    logger.error((Object)"", (Throwable)e);
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    if (tmpTable != null) {
                        pool.releaseTable(tmpTable);
                    }
                    SQLUtils.cleanup(rst, pst, (Connection)connection);
                    throw throwable;
                }
            }
            pool.releaseTable(tmpTable);
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pst, (Connection)connection);
        return refMem;
    }

    private String transRefStr(Integer refType) {
        String str = null;
        if (refType == 1) {
            str = "ref_template";
        } else if (refType == 4) {
            str = "ref_form";
        } else if (refType == 8) {
            str = "ref_data";
        }
        return str;
    }

    public BatchExecuteResult batchExecute(Context ctx, String name, Class[] paramTypes, BatchExecuteParamsEntry[] paramEntries) throws BaseException {
        return super.batchExecute(ctx, name, paramTypes, paramEntries);
    }

    @Override
    protected Map _checkRef(Context ctx, String srcNumber, String dimViewId, Set memberIdSet, boolean isOnlyCheckDataRef, String orgid) throws BOSException, EASBizException {
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        if (ctx == null || memberIdSet.isEmpty()) {
            return result;
        }
        Map<String, Set<String>> refDim = this.getRefDimRelations(ctx, srcNumber, memberIdSet, orgid);
        HashMap refBiz = new HashMap();
        Map<String, Set<String>> refMem = this.getRefMembers(ctx, memberIdSet, orgid, false);
        result.putAll(refDim);
        result.putAll(refBiz);
        result.putAll(refMem);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Set _checkRef(Context ctx, BOSUuid viewId, List numbers) throws BOSException, EASBizException {
        HashSet<String> checkNums = new HashSet<String>();
        if (ctx == null || viewId == null || numbers == null || numbers.isEmpty()) {
            return checkNums;
        }
        Connection conn = null;
        IRowSet rst = null;
        IRowSet result = null;
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        String tableName = null;
        String srcNumbr = null;
        String refField = null;
        String tmpTable = null;
        String tmpStr = null;
        try {
            conn = this.getConnection(ctx);
            rst = BgDBUtils.executeQuery(conn, "select d.FSrcNumber, d.FReffield from T_MBG_MbgDim d left join T_MBG_MbgView v on d.FID = v.FMbgDimId where v.FID = ?", new Object[]{viewId.toString()});
            if (rst.next()) {
                srcNumbr = rst.getString("FSrcNumber");
                refField = rst.getString("FReffield");
            }
            SQLUtils.cleanup((ResultSet)rst);
            if (srcNumbr != null && refField != null) {
                String _srcNumber = srcNumbr + BgBaseConstants.SEP_FOUR_STR;
                String number = null;
                String combinNumber = null;
                HashMap<String, String[]> _tmplist = new HashMap<String, String[]>();
                int in = numbers.size();
                for (int i = 0; i < in; ++i) {
                    tmpStr = (String)numbers.get(i);
                    if (tmpStr == null) continue;
                    if (tmpStr.startsWith(_srcNumber)) {
                        number = tmpStr.split(BgBaseConstants.SEP_FOUR_STR)[1];
                        combinNumber = tmpStr;
                    } else {
                        number = tmpStr;
                        combinNumber = _srcNumber + tmpStr;
                    }
                    if (_tmplist.containsKey(combinNumber)) continue;
                    _tmplist.put(combinNumber, new String[]{combinNumber, number});
                }
                tmpTable = BgDBUtils.createTmpTable(ctx, pool, "CREATE TABLE TEML_KSQL_0 (FNumber NVARCHAR(84) NOT NULL, FSNumber NVARCHAR(84) NOT NULL, FHasData INT DEFAULT 0 NOT NULL)");
                MbgSqlHelper.executeBatch(conn, "Insert Into " + tmpTable + "(FNumber, FSNumber) values (?, ?)", new ArrayList(_tmplist.values()));
                MbgSqlHelper.executeBatch(conn, "Delete FROM " + tmpTable + " t0 Where not exists (Select FNumber FROM T_MBG_MbgMember Where FViewId = ? AND FNumber = t0.FSNumber AND FISLeaf = 1)", new Object[]{viewId.toString()});
                rst = BgDBUtils.executeQuery(conn, "select s.FRefCube from T_MBG_BgScheme s join T_MBG_BgDimSettings st on s.FID = st.FBgSchemeId join T_MBG_BgDimSettingsMember sm on st.fid = sm.FBgDimSettingsId where sm.FType = 1 and sm.FMemberId = ?", new Object[]{viewId.toString()});
                while (rst.next()) {
                    tableName = rst.getString("FRefCube");
                    try {
                        MbgSqlHelper.execute(conn, "Update " + tmpTable + " t0 Set FHasData = 1 Where FHasData = 0 AND exists(Select 1 FROM " + tableName + " t1 Where t1." + refField + " = t0.FNumber)");
                    }
                    catch (Throwable throwable) {
                        SQLUtils.cleanup(result);
                        throw throwable;
                    }
                    SQLUtils.cleanup((ResultSet)result);
                }
                result = BgDBUtils.executeQuery(conn, "select FNumber from " + tmpTable + " where FHasData = 1");
                while (result.next()) {
                    checkNums.add(this.getNumber(result.getString(1)));
                }
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"sql error:", (Throwable)ex);
                throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, null, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, null, (Connection)conn);
        return checkNums;
    }

    private String getNumber(String dimNumber) {
        String[] tmpStrs;
        String number = dimNumber;
        if (number != null && (tmpStrs = dimNumber.split(BgBaseConstants.SEP_FOUR_STR)) != null) {
            if (tmpStrs.length > 1) {
                number = tmpStrs[1];
            } else if (tmpStrs.length > 0) {
                number = tmpStrs[0];
            }
        }
        return number;
    }

    @Override
    protected Map _cancelCancel(Context ctx, List ids, String viewId, String curOrgUnitId) throws BOSException, EASBizException {
        return this.doCancel(ctx, ids, true, curOrgUnitId, viewId);
    }

    @Override
    protected Map _cancel(Context ctx, List ids, String viewId, String curOrgUnitId) throws BOSException, EASBizException {
        return this.doCancel(ctx, ids, false, curOrgUnitId, viewId);
    }

    private Map doCancel(Context ctx, List ids, Boolean isEnable, String curOrgUnitId, String viewId) throws EASBizException, BOSException {
        if (ids == null || ids.isEmpty()) {
            return null;
        }
        HashMap<String, Map<Object, Object>> resultMap = new HashMap<String, Map<Object, Object>>();
        List<Object> updateIds = new ArrayList(ids);
        if (updateIds != null && !updateIds.isEmpty()) {
            HashMap<String, String> checkOrgMap = new HashMap<String, String>();
            MbgViewInfo viewInfo = MbgViewFactory.getLocalInstance(ctx).getMbgViewInfo("select orgUnit.id,segregationRule where id = '" + viewId + "'");
            String viewOrgId = viewInfo.getOrgUnit().getId().toString();
            EntityViewInfo view = new EntityViewInfo();
            view.setSelector(new SelectorItemCollection());
            view.getSelector().add(new SelectorItemInfo("id"));
            view.getSelector().add(new SelectorItemInfo("number"));
            view.getSelector().add(new SelectorItemInfo("orgUnit.id"));
            view.setFilter(new FilterInfo());
            view.getFilter().getFilterItems().add(new FilterItemInfo("id", new HashSet<Object>(updateIds), CompareType.INCLUDE));
            MbgMemberCollection colls = MbgMemberFactory.getLocalInstance(ctx).getMbgMemberCollection(view);
            MbgMemberInfo info = null;
            if (colls != null && !colls.isEmpty()) {
                for (int index = 0; index < colls.size(); ++index) {
                    info = colls.get(index);
                    if (viewInfo.getSegregationRule().equals((Object)MemberSegregationRuleEnum.SEGREGATEORG)) {
                        if (info.getOrgunit().getId().toString().equals(curOrgUnitId)) continue;
                        checkOrgMap.put(info.getId().toString(), info.getNumber());
                        updateIds.remove(info.getId().toString());
                        continue;
                    }
                    if (curOrgUnitId.equals(viewOrgId) || info.getOrgunit().getId().toString().equals(curOrgUnitId)) continue;
                    checkOrgMap.put(info.getId().toString(), info.getNumber());
                    updateIds.remove(info.getId().toString());
                }
            }
            if (!checkOrgMap.isEmpty()) {
                resultMap.put("cancel_check_org", checkOrgMap);
            }
        }
        if (isEnable.booleanValue()) {
            Map<String, String> checkMap = this.checkCancelCancel(ctx, updateIds);
            if (!checkMap.isEmpty()) {
                updateIds = new ArrayList();
                Set<String> checkSet = checkMap.keySet();
                for (int index = 0; index < ids.size(); ++index) {
                    if (!checkSet.contains(ids.get(index)) || !updateIds.contains(ids.get(index))) continue;
                    updateIds.remove((String)ids.get(index));
                }
                resultMap.put("cancel_check_number", checkMap);
            }
        } else {
            updateIds = this.getCancelIds(ctx, updateIds);
        }
        if (updateIds != null && !updateIds.isEmpty()) {
            this.updateCancelState(ctx, updateIds, isEnable);
        }
        return resultMap;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<String, String> checkCancelCancel(Context ctx, List ids) throws EASBizException, BOSException {
        IRowSet rst;
        Connection conn;
        LinkedHashMap<String, String> checkMap;
        block7: {
            checkMap = new LinkedHashMap<String, String>();
            if (ids == null) return checkMap;
            if (ids.isEmpty()) {
                return checkMap;
            }
            conn = null;
            TempTablePool pool = null;
            String tmpTable = null;
            rst = null;
            try {
                conn = BgDBUtils.getConnection(ctx);
                pool = TempTablePool.getInstance((Context)ctx);
                tmpTable = BgDBUtils.createTmpTable(ctx, pool, "CREATE TABLE TEML_KSQL_0 (FID VARCHAR(44))");
                BgDBUtils.insertKey(conn, "Insert Into " + tmpTable + " (FID) values (?)", (Collection<String>)ids);
                String sql = "Select a.FID, a.FNumber, a.FParentId, p.FIsEnabled From T_MBG_MbgMember a  Join T_MBG_MbgMember p on a.FPARENTID = p.FID Where a.FID in (Select FID from " + tmpTable + ") Order by a.FLongNumber";
                String id = null;
                String parentId = null;
                String number = null;
                boolean isEnable = false;
                rst = BgDBUtils.executeQuery(conn, sql);
                while (rst.next()) {
                    id = rst.getString("FID");
                    parentId = rst.getString("FParentId");
                    if (StringUtils.isEmpty((String)parentId)) continue;
                    number = rst.getString("FNumber");
                    isEnable = rst.getBoolean("FIsEnabled");
                    if (isEnable || !checkMap.containsKey(parentId) && ids.contains(parentId)) continue;
                    checkMap.put(id, number);
                }
                if (tmpTable == null) break block7;
            }
            catch (SQLException e) {
                try {
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    if (tmpTable != null) {
                        BgDBUtils.releaseTmpTable(pool, tmpTable);
                    }
                    SQLUtils.cleanup(rst, null, (Connection)conn);
                    throw throwable;
                }
            }
            BgDBUtils.releaseTmpTable(pool, tmpTable);
        }
        SQLUtils.cleanup((ResultSet)rst, null, (Connection)conn);
        return checkMap;
    }

    private List<MbgMemberInfo> getRootLst(MbgMemberCollection colls) {
        ArrayList<MbgMemberInfo> rootLst = new ArrayList<MbgMemberInfo>();
        if (colls == null || colls.isEmpty()) {
            return rootLst;
        }
        int size = colls.size();
        MbgMemberInfo info = null;
        MbgMemberInfo pInfo = null;
        String longNum = null;
        String pLongNum = null;
        for (int i = size - 1; i >= 0; --i) {
            boolean isRoot = true;
            pInfo = colls.get(i);
            pLongNum = pInfo.getLongNumber();
            for (int j = 0; j < size; ++j) {
                info = colls.get(j);
                longNum = info.getLongNumber();
                if (!pLongNum.startsWith(longNum + "!") || pLongNum.equals(longNum)) continue;
                isRoot = false;
                break;
            }
            if (!isRoot) continue;
            rootLst.add(pInfo);
        }
        return rootLst;
    }

    private List<String> getCancelIds(Context ctx, List ids) throws BOSException, EASBizException {
        if (ids == null || ids.isEmpty()) {
            return null;
        }
        MbgMemberCollection colls = this.getMbgMemberCollByIds(ctx, new HashSet(ids));
        List<MbgMemberInfo> rootLst = this.getRootLst(colls);
        TreeBaseCollection tbColls = null;
        MbgMemberInfo info = null;
        ArrayList<String> cancelIds = new ArrayList<String>();
        for (int i = 0; i < rootLst.size(); ++i) {
            cancelIds.add(rootLst.get(i).getId().toString());
            tbColls = this.getAllChildren(ctx, rootLst.get(i));
            if (tbColls == null || tbColls.isEmpty()) continue;
            for (int j = 0; j < tbColls.size(); ++j) {
                info = (MbgMemberInfo)tbColls.get(j);
                if (!info.isIsEnabled()) continue;
                cancelIds.add(tbColls.get(j).getId().toString());
            }
        }
        return cancelIds;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateCancelState(Context ctx, List ids, Boolean isEnable) throws EASBizException, BOSException {
        Connection conn;
        block6: {
            if (ids == null) return;
            if (ids.isEmpty()) {
                return;
            }
            conn = null;
            TempTablePool pool = null;
            String tmpTable = null;
            Date disabledDate = new Date(System.currentTimeMillis());
            String dateStr = BOSLocaleUtil.getDateTimeFormat().format(disabledDate);
            UserInfo user = ContextUtil.getCurrentUserInfo((Context)ctx);
            String userId = user.getId().toString();
            try {
                conn = BgDBUtils.getConnection(ctx);
                pool = TempTablePool.getInstance((Context)ctx);
                tmpTable = BgDBUtils.createTmpTable(ctx, pool, "CREATE TABLE TEML_KSQL_0 (FID VARCHAR(44))");
                BgDBUtils.insertKey(conn, "Insert Into " + tmpTable + " (FID) values (?)", (Collection<String>)ids);
                String sql = null;
                sql = isEnable != false ? "update T_MBG_MbgMember set FLASTUPDATEUSERID = '" + userId + "', FLASTUPDATETIME = now(),FDisabledDate = null , FIsEnabled = 1 where FId in (select FID from " + tmpTable + ")" : "update T_MBG_MbgMember set FLASTUPDATEUSERID = '" + userId + "', FLASTUPDATETIME = now(),FDisabledDate = now() , FIsEnabled = 0 where FId in (select FID from " + tmpTable + ")";
                DbUtil.execute((Context)ctx, (String)sql);
                if (tmpTable == null) break block6;
            }
            catch (SQLException e) {
                try {
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    if (tmpTable != null) {
                        BgDBUtils.releaseTmpTable(pool, tmpTable);
                    }
                    SQLUtils.cleanup((Connection)conn);
                    throw throwable;
                }
            }
            BgDBUtils.releaseTmpTable(pool, tmpTable);
        }
        SQLUtils.cleanup((Connection)conn);
    }

    @Override
    protected IObjectPK _submitforDataMigration(Context ctx, IObjectValue model, boolean isMigrate) throws BOSException, EASBizException {
        if (ctx == null || model == null || !(model instanceof MbgMemberInfo)) {
            return null;
        }
        if (StringUtils.isEmpty((String)((MbgMemberInfo)model).getNumber())) {
            BgCodeNumberHelper codeHelper = new BgCodeNumberHelper(ctx, null, null);
            codeHelper.init(model, ((MbgMemberInfo)model).getOrgunit().getId().toString());
            if (codeHelper.isHasCodeNumber()) {
                this.applyNumber(ctx, codeHelper, (MbgMemberInfo)model, ((MbgMemberInfo)model).getOrgunit().getId().toString());
            }
            if (StringUtils.isEmpty((String)((MbgMemberInfo)model).getNumber())) {
                ((MbgMemberInfo)model).setNumber("MbgMember-" + System.currentTimeMillis());
            }
        }
        if (((MbgMemberInfo)model).getNumber().length() > 80) {
            throw new MbgDimException(MbgDimException.NUMBERTOLONG);
        }
        if (!BgNumberHelper.checkNumber(((MbgMemberInfo)model).getNumber())) {
            throw new MbgDimException(MbgDimException.SPECIALCHARINNUMBER);
        }
        this.checkNumDump(ctx, model);
        if (isMigrate) {
            Connection connection = this.getConnection(ctx);
            try {
                if (!this._exists(ctx, (IObjectPK)new ObjectUuidPK(((MbgMemberInfo)model).getId()))) {
                    BgIntIdHelper.setIntIdOnlyAddNew(ctx, (CoreBaseInfo)((MbgMemberInfo)model), ((MbgMemberInfo)model).getViewId().toString(), true);
                }
                connection.setAutoCommit(false);
                Class classBgMigrationUtil = this.getClassBgMigrationUtil();
                Method method = classBgMigrationUtil.getMethod("submitforDataMigration", Context.class, Connection.class, IObjectValue.class);
                method.invoke(null, ctx, connection, model);
                connection.commit();
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                try {
                    connection.rollback();
                }
                catch (SQLException e1) {
                    logger.error((Object)e1.getMessage(), (Throwable)e1);
                    throw new BOSException((Throwable)e1);
                }
                throw new BOSException((Throwable)e);
            }
            finally {
                SQLUtils.cleanup((Connection)connection);
            }
        }
        IObjectPK pk = this._submit(ctx, model);
        return pk;
    }

    private Class getClassBgMigrationUtil() throws BOSException {
        Class<?> util = null;
        try {
            util = Class.forName("com.kingdee.eas.ma.mbg.app.data.BgMigrationUtil");
        }
        catch (ClassNotFoundException e) {
            throw new BOSException((Throwable)e);
        }
        return util;
    }

    @Override
    protected boolean _checkTmpData(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        if (ctx == null || model == null || !(model instanceof MbgMemberInfo)) {
            return true;
        }
        Connection connection = this.getConnection(ctx);
        try {
            Class classBgMigrationUtil = this.getClassBgMigrationUtil();
            Method method = classBgMigrationUtil.getMethod("checkTmpData", Context.class, Connection.class, IObjectValue.class);
            Object invoke = method.invoke(null, ctx, connection, model);
            if (invoke != null && invoke instanceof Boolean) {
                boolean bl = (Boolean)invoke;
                return bl;
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)connection);
        }
        return true;
    }

    @Override
    protected Map _checkBgData(Context ctx, IObjectValue model, boolean isSelf) throws BOSException, EASBizException {
        if (ctx == null || model == null || !(model instanceof MbgMemberInfo)) {
            return null;
        }
        Connection connection = this.getConnection(ctx);
        try {
            Class classBgMigrationUtil = this.getClassBgMigrationUtil();
            Method method = classBgMigrationUtil.getMethod("checkBgData", Context.class, Connection.class, IObjectValue.class, Boolean.TYPE);
            Object invoke = method.invoke(null, ctx, connection, model, isSelf);
            if (invoke != null && invoke instanceof Map) {
                Map map = (Map)invoke;
                return map;
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)connection);
        }
        return null;
    }

    private void updateLeafMembers(Context ctx, IObjectCollection colls) throws BOSException {
        MbgMemberInfo info = null;
        Set<String> hasLeafIds = null;
        HashSet<String> NotLeafIDS = new HashSet<String>();
        ArrayList<String> dealIds = new ArrayList<String>();
        for (int i = 0; i < colls.size(); ++i) {
            info = (MbgMemberInfo)colls.getObject(i);
            if (info.isIsLeaf()) continue;
            NotLeafIDS.add(info.getId().toString());
        }
        if (NotLeafIDS.isEmpty()) {
            return;
        }
        hasLeafIds = this.getHasLeafIds(ctx, NotLeafIDS);
        NotLeafIDS.removeAll(hasLeafIds);
        dealIds.addAll(NotLeafIDS);
        if (!dealIds.isEmpty()) {
            PreparedStatement pstmt;
            Connection conn;
            block12: {
                int i;
                conn = null;
                pstmt = null;
                int batchSize = 50;
                int batchIndex = 0;
                int size = dealIds.size();
                int count = (size - 1) / batchSize + 1;
                int pos = 0;
                int value = 1;
                StringBuffer sql = new StringBuffer("update T_MBG_MbgMember set FIsLeaf = ? where FID in ( ");
                for (i = 1; i < batchSize; ++i) {
                    sql.append("?,");
                }
                sql.append("?)");
                try {
                    conn = this.getConnection(ctx);
                    pstmt = conn.prepareStatement(sql.toString());
                    for (i = 0; i < count; ++i) {
                        pstmt.setInt(1, value);
                        int j = 2;
                        while (j <= batchSize + 1) {
                            if (pos < size) {
                                pstmt.setString(j, (String)dealIds.get(pos));
                            } else {
                                pstmt.setString(j, "#");
                            }
                            ++j;
                            ++pos;
                        }
                        pstmt.addBatch();
                        if (++batchIndex < batchSize) continue;
                        pstmt.executeBatch();
                        batchIndex = 0;
                    }
                    if (batchIndex == 0) break block12;
                    pstmt.executeBatch();
                }
                catch (SQLException e) {
                    try {
                        logger.error((Object)e);
                        throw new BOSException((Throwable)e);
                    }
                    catch (Throwable throwable) {
                        SQLUtils.cleanup(pstmt, (Connection)conn);
                        throw throwable;
                    }
                }
            }
            SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
        }
    }

    private Set<String> getHasLeafIds(Context ctx, Set<String> notLeafIDS) throws BOSException {
        HashSet<String> hasLeafIds = new HashSet<String>();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("name");
        sic.add("number");
        sic.add("isleaf");
        sic.add("parent.id");
        filter.getFilterItems().add(new FilterItemInfo("parent.id", notLeafIDS, CompareType.INCLUDE));
        evi.setSelector(sic);
        evi.setFilter(filter);
        MbgMemberCollection accColls = MbgMemberFactory.getLocalInstance(ctx).getMbgMemberCollection(evi);
        for (int i = 0; i < accColls.size(); ++i) {
            hasLeafIds.add(accColls.get(i).getParent().getId().toString());
        }
        return hasLeafIds;
    }
}

