/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.base.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.app.AbstractMbgParamsControllerBean;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.base.utils.BgDimCacheUtils;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;

public class MbgParamsControllerBean
extends AbstractMbgParamsControllerBean {
    private static final long serialVersionUID = 9038807842649561210L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.base.app.MbgParamsControllerBean");

    protected FilterInfo getDeafultFilter() {
        return new FilterInfo();
    }

    @Override
    protected String _getParamValue(Context ctx, String orgUnitId, String paramNumber) throws BOSException, EASBizException {
        if (ctx == null || orgUnitId == null || paramNumber == null) {
            return null;
        }
        if ("MBG_C001".equals(paramNumber)) {
            return this.loadMbgC00Value(ctx, orgUnitId);
        }
        String mbgParamId = null;
        String defParamValue = null;
        String mbgParamValue = null;
        Connection conn = null;
        IRowSet rst = null;
        try {
            conn = this.getConnection(ctx);
            rst = BgDBUtils.executeQuery(conn, "select FID, FDefaultValue from T_MBG_MbgParams where FNumber = ?", new Object[]{paramNumber});
            if (rst.next()) {
                mbgParamId = rst.getString("FID");
                defParamValue = rst.getString("FDefaultValue");
            }
            SQLUtils.cleanup((ResultSet)rst);
            if (mbgParamId != null && (rst = BgDBUtils.executeQuery(conn, "select FMbgParamValue from T_MBG_MbgParamsValue where FOrgUnitId = ? and FMbgParamId = ?", new Object[]{orgUnitId, mbgParamId})).next()) {
                mbgParamValue = rst.getString("FMbgParamValue");
            }
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, null, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, null, (Connection)conn);
        return StringUtils.isEmpty(mbgParamValue) ? defParamValue : mbgParamValue;
    }

    protected String loadMbgC00Value(Context ctx, String orgUnitId) throws BOSException, EASBizException {
        if (ctx == null || orgUnitId == null) {
            return null;
        }
        String paramValue = null;
        ConcurrentHashMap<String, Map<String, String>> orgParamMap = null;
        Map<String, String> paramMap = null;
        Object obj = BgDimCacheUtils.getObject(ctx, "BUDGET_MBG_PARAM_CACHE");
        orgParamMap = obj instanceof Map ? (ConcurrentHashMap<String, Map<String, String>>)obj : new ConcurrentHashMap<String, Map<String, String>>();
        if (orgParamMap.containsKey(orgUnitId)) {
            paramMap = (Map)orgParamMap.get(orgUnitId);
        } else {
            paramMap = new HashMap();
            orgParamMap.put(orgUnitId, paramMap);
        }
        if (paramMap.containsKey("MBG_C001")) {
            paramValue = (String)paramMap.get("MBG_C001");
        }
        if (StringUtils.isEmpty(paramValue)) {
            TempTablePool pool;
            String tmpOrgIdTable;
            String tmpTable;
            IRowSet rst;
            Connection conn;
            block16: {
                conn = null;
                rst = null;
                tmpTable = null;
                tmpOrgIdTable = null;
                String[] numbers = null;
                HashSet<String> numberSet = new HashSet<String>();
                ArrayList<String> orgUnitIds = new ArrayList<String>();
                pool = TempTablePool.getInstance((Context)ctx);
                try {
                    conn = this.getConnection(ctx);
                    rst = BgDBUtils.executeQuery(conn, "select FLongNumber from T_ORG_CostCenter where FID = ?", new Object[]{orgUnitId});
                    if (rst.next() && (numbers = rst.getString("FLongNumber").split(BgBaseConstants.SEP_ONE_STR)) != null) {
                        int in = numbers.length;
                        for (int i = 0; i < in; ++i) {
                            numberSet.add(numbers[i]);
                        }
                    }
                    SQLUtils.cleanup((ResultSet)rst);
                    if (!numberSet.isEmpty() && (tmpTable = BgDBUtils.createTmpTable(ctx, pool, "CREATE TABLE TEML_KSQL_0 (FNumber NVARCHAR(80))")) != null) {
                        BgDBUtils.insertKey(conn, "Insert Into " + tmpTable + " (FNumber) values (?)", numberSet);
                        rst = BgDBUtils.executeQuery(conn, "select FID from T_ORG_CostCenter where exists (select FNumber from " + tmpTable + " where FNumber = T_ORG_CostCenter.FNumber) order by FLongNumber desc");
                        while (rst.next()) {
                            orgUnitIds.add(rst.getString("FID"));
                        }
                        SQLUtils.cleanup((ResultSet)rst);
                    }
                    if (orgUnitIds.isEmpty()) break block16;
                    HashMap<String, String> valueMap = new HashMap<String, String>();
                    tmpOrgIdTable = BgDBUtils.createTmpTable(ctx, pool, "CREATE TABLE TEML_KSQL_0 (FID VARCHAR(44))");
                    if (tmpOrgIdTable != null) {
                        BgDBUtils.insertKey(conn, "Insert Into " + tmpOrgIdTable + " (FID) values (?)", orgUnitIds);
                        rst = BgDBUtils.executeQuery(conn, "select FOrgUnitId, FMbgParamValue from T_MBG_MbgParamsValue where exists (select FID from " + tmpOrgIdTable + " where FID = T_MBG_MbgParamsValue.FOrgUnitId)");
                        while (rst.next()) {
                            valueMap.put(rst.getString("FOrgUnitId"), rst.getString("FMbgParamValue"));
                        }
                        SQLUtils.cleanup((ResultSet)rst);
                        for (String _orgUnitId : orgUnitIds) {
                            if (!valueMap.containsKey(_orgUnitId)) continue;
                            paramValue = (String)valueMap.get(_orgUnitId);
                            paramMap.put("MBG_C001", paramValue);
                            break;
                        }
                    }
                }
                catch (Exception ex) {
                    try {
                        throw new BOSException((Throwable)ex);
                    }
                    catch (Throwable throwable) {
                        BgDBUtils.releaseTmpTable(pool, tmpTable);
                        BgDBUtils.releaseTmpTable(pool, tmpOrgIdTable);
                        SQLUtils.cleanup(rst, null, (Connection)conn);
                        throw throwable;
                    }
                }
            }
            BgDBUtils.releaseTmpTable(pool, tmpTable);
            BgDBUtils.releaseTmpTable(pool, tmpOrgIdTable);
            SQLUtils.cleanup((ResultSet)rst, null, (Connection)conn);
            BgDimCacheUtils.putObject(ctx, "BUDGET_MBG_PARAM_CACHE", orgParamMap);
        }
        return paramValue;
    }
}

