/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.base.app.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.ma.base.BgRefDimMemberEnum;
import com.kingdee.eas.ma.base.app.utils.MbgSqlHelper;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class BgRefDimMemberHelper {
    private static final Logger logger = Logger.getLogger((String)BgRefDimMemberHelper.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<BgRefDimMemberEnum> getRefType(Context ctx, BOSUuid baseDataID) throws BOSException {
        Connection conn = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            List result = MbgSqlHelper.executeBatchQuery(conn, "Select FRefType FROM T_MBG_BgRefDimMember Where FBaseDataId = ?", Arrays.asList(baseDataID.toString()));
            if (result == null || result.isEmpty()) {
                List<BgRefDimMemberEnum> list = null;
                return list;
            }
            ArrayList<BgRefDimMemberEnum> list = new ArrayList<BgRefDimMemberEnum>();
            Iterator it = new HashSet(result).iterator();
            while (it.hasNext()) {
                list.add(BgRefDimMemberEnum.getEnum(((Number)it.next()).intValue()));
            }
            ArrayList<BgRefDimMemberEnum> arrayList = list;
            return arrayList;
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        return null;
    }

    public static BgRefDimMemberEnum checkRef(Context ctx, BOSUuid baseDataID) throws BOSException {
        List<BgRefDimMemberEnum> refs = BgRefDimMemberHelper.getRefType(ctx, baseDataID);
        if (refs != null && !refs.isEmpty()) {
            return refs.get(0);
        }
        return null;
    }

    public static void saveRef(Context ctx, String bgSchemeId, BgRefDimMemberEnum refType, String refId, List<String[]> baseDatas) throws BOSException {
        if (ctx == null || StringUtils.isEmpty((String)bgSchemeId) || StringUtils.isEmpty((String)refId)) {
            return;
        }
        if (baseDatas == null || baseDatas.isEmpty()) {
            DbUtil.execute((Context)ctx, (String)"Delete FROM T_MBG_BgRefDimMember Where FRefId = ? and FRefType = ?", (Object[])new Object[]{refId, refType.getValue()});
            return;
        }
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        String tmpTable = null;
        try {
            tmpTable = pool.createTempTable("Create Table TMP_MBG_REFDIMMEMBER(FBaseDataID Varchar(44) NOT NULL, FOtherID Varchar(44) NOT NULL)");
            DbUtil.executeBatch((Context)ctx, (String)("Insert Into " + tmpTable + "(FBaseDataID, FOtherID) Values(?, ?)"), baseDatas);
            DbUtil.execute((Context)ctx, (String)("Update T_MBG_BgRefDimMember t1 Set FRefType = -1 Where FRefId = ? AND FRefType = ? And NOT EXISTS (Select t2.FBaseDataId FROM " + tmpTable + " t2 Where t1.FBaseDataId = t2.FBaseDataId AND t1.FOtherID = t2.FOtherID)"), (Object[])new Object[]{refId, refType.getValue()});
            DbUtil.execute((Context)ctx, (String)"Delete From T_MBG_BgRefDimMember Where FRefType = -1");
            String sql = "Insert Into T_MBG_BgRefDimMember(FID, FBgSchemeID, FRefType, FRefID, FBaseDataID, FOtherID) Select newbosid('72491949'), ?, ?, ?, FBaseDataID, FOtherID FROM " + tmpTable + " t1 Where NOT EXISTS(Select FID FROM T_MBG_BgRefDimMember t2 Where t1.FBaseDataID = t2.FBaseDataID AND t1.FOtherID = t2.FOtherID and t2.FRefId = ? and t2.FRefType = ?)";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{bgSchemeId, refType.getValue(), refId, refId, refType.getValue()});
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            if (tmpTable != null) {
                pool.releaseTable(tmpTable);
            }
        }
    }

    public static void deleteRef(Context ctx, List<String> refId) throws BOSException {
        Connection conn = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            MbgSqlHelper.executeBatch(conn, "Delete FROM T_MBG_BgRefDimMember Where FRefId = ?", refId);
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
    }

    public static void deleteRef(Context ctx, String refId) throws BOSException {
        if (ctx == null || StringUtils.isEmpty((String)refId)) {
            return;
        }
        ArrayList<String> list = new ArrayList<String>();
        list.add(refId);
        BgRefDimMemberHelper.deleteRef(ctx, list);
    }

    public static void copyRefForFixelForm(Context ctx, String bgFormId, String orgUnitId, String bgTemplateId) throws BOSException {
        DbUtil.execute((Context)ctx, (String)"Insert Into T_MBG_BgRefDimMember(FID, FBgSchemeID, FRefType, FRefID, FBaseDataID, FOtherID) Select newbosid('72491949'), FBgSchemeID, ?, ?, FBaseDataID, ? FROM T_MBG_BgRefDimMember Where FRefId = ?", (Object[])new Object[]{4, bgFormId, orgUnitId, bgTemplateId});
    }

    public static void copyRefForRollForm(Context ctx, String bgSchemeID, String bgFormId, String bgVersionId, String orgUnitId) throws BOSException {
        String fid = BOSUuid.create((String)"72491949").toString();
        DbUtil.execute((Context)ctx, (String)"Insert Into T_MBG_BgRefDimMember(FID, FBgSchemeID, FRefType, FRefID, FBaseDataID, FOtherID) values (?, ?, ?, ?, ?, ?)", (Object[])new Object[]{fid, bgSchemeID, 4, bgFormId, bgVersionId, orgUnitId});
    }
}

