/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.base.app.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.ma.base.app.utils.IResultReader;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class MbgSqlHelper {
    private static Logger logger = Logger.getLogger(MbgSqlHelper.class);
    public static final int BATCH_COUNT = 50;
    public static final String NO_FOUND = "#";
    public static final int NO_FOUND_FOR_NUMBER = Integer.MIN_VALUE;

    public static StringBuffer addPlaceHolder(StringBuffer sql, int count) {
        if (sql == null) {
            return null;
        }
        for (int i = 0; i < count - 1; ++i) {
            sql.append("?,");
        }
        sql.append("?");
        return sql;
    }

    public static StringBuffer addPlaceHolder(StringBuffer sql) {
        return MbgSqlHelper.addPlaceHolder(sql, 50);
    }

    public static void setParam4Batch(PreparedStatement pmt, int pStartIndex, int batchIndex, int batchCount, Object[] params) throws SQLException {
        if (pmt == null || pStartIndex < 1 || batchIndex < 0 || batchCount <= 0) {
            throw new SQLException("param error!");
        }
        int length = params == null ? 0 : params.length;
        int start = batchIndex * batchCount;
        for (int i = 0; i < batchCount; ++i) {
            if (i + start >= length) {
                pmt.setObject(i + pStartIndex, NO_FOUND);
                continue;
            }
            pmt.setObject(i + pStartIndex, params[i + start]);
        }
    }

    public static void setParam4BatchDefCount(PreparedStatement pmt, int pStartIndex, int batchIndex, Object[] params) throws SQLException {
        MbgSqlHelper.setParam4Batch(pmt, pStartIndex, batchIndex, 50, params);
    }

    public static void setParam4Batch(PreparedStatement pmt, int batchIndex, int batchCount, Object[] params) throws SQLException {
        MbgSqlHelper.setParam4Batch(pmt, 1, batchIndex, batchCount, params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executeBatch(Connection conn, String sql, List paramList) throws SQLException {
        if (conn == null || StringUtils.isEmpty((String)sql) || paramList == null || paramList.isEmpty()) {
            return;
        }
        PreparedStatement pstmt = null;
        try {
            pstmt = conn.prepareStatement(sql);
            int index = 0;
            for (int i = 0; i < paramList.size(); ++i) {
                if (paramList.get(i) instanceof Object[]) {
                    Object[] params = (Object[])paramList.get(i);
                    for (int p = 0; p < params.length; ++p) {
                        pstmt.setObject(p + 1, params[p]);
                    }
                } else {
                    pstmt.setObject(1, paramList.get(i));
                }
                pstmt.addBatch();
                if (++index <= 50) continue;
                pstmt.executeBatch();
                pstmt.clearBatch();
                index = 0;
            }
            if (index > 0) {
                pstmt.executeBatch();
            }
        }
        finally {
            SQLUtils.cleanup((Statement)pstmt);
        }
    }

    public static void executeBatch(Connection conn, String sql, Object param) throws SQLException {
        List<Object> params = new ArrayList<Object>();
        if (param instanceof List) {
            params = (List)param;
        } else {
            params.add(param);
        }
        MbgSqlHelper.executeBatch(conn, sql, params);
    }

    public static void executeBatchInsert(PreparedStatement pstmtInsert, List paramList) throws SQLException {
        if (pstmtInsert == null || paramList == null || paramList.isEmpty()) {
            return;
        }
        int batchIndex = 0;
        for (int i = 0; i < paramList.size(); ++i) {
            if (paramList.get(i) instanceof Object[]) {
                MbgSqlHelper.setParams(pstmtInsert, (Object[])paramList.get(i));
            } else {
                pstmtInsert.setObject(1, paramList.get(i));
            }
            pstmtInsert.addBatch();
            if (++batchIndex < 50) continue;
            batchIndex = 0;
            pstmtInsert.executeBatch();
        }
        if (batchIndex > 0) {
            pstmtInsert.executeBatch();
        }
    }

    public static int getBatchCount(Object[] params) {
        return MbgSqlHelper.getBatchCount(params, 50);
    }

    public static int getBatchCount(Object[] params, int batch) {
        if (params == null) {
            return 0;
        }
        return MbgSqlHelper.getBatchCount(params.length, batch);
    }

    public static int getBatchCount(int size, int batch) {
        if (size <= 0) {
            return 0;
        }
        return (size - 1) / batch + 1;
    }

    public static int getBatchCount(int size) {
        return MbgSqlHelper.getBatchCount(size, 50);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ResultSet batchExecuteQuery(Context ctx, String sql, Object[] params) throws SQLException {
        if (ctx == null || sql == null || params == null) {
            return null;
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            pstmt = conn.prepareStatement(sql);
            MbgSqlHelper.setParams(pstmt, params);
            rst = pstmt.executeQuery();
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rst, pstmt, (Connection)conn);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return rst;
    }

    public static ResultSet batchExecuteQuery(Connection conn, String sql, Set params) throws SQLException {
        if (conn == null || sql == null || params == null) {
            return null;
        }
        PreparedStatement pstmt = conn.prepareStatement(sql);
        MbgSqlHelper.setParams(pstmt, params);
        return pstmt.executeQuery();
    }

    public static ResultSet batchExecuteQuery(Connection conn, String sql, Object[] params) throws SQLException {
        if (conn == null || sql == null || params == null) {
            return null;
        }
        PreparedStatement pstmt = conn.prepareStatement(sql);
        MbgSqlHelper.setParams(pstmt, params);
        return pstmt.executeQuery();
    }

    public static int batchExecuteUpdate(Connection conn, String sql, Object[] params) throws SQLException {
        if (conn == null || sql == null || params == null) {
            return -1;
        }
        PreparedStatement pstmt = conn.prepareStatement(sql);
        MbgSqlHelper.setParams(pstmt, params);
        return pstmt.executeUpdate();
    }

    public static void setParams(PreparedStatement pstmt, Object[] params) throws SQLException {
        if (pstmt == null || params == null) {
            return;
        }
        int m = -1;
        int in = params.length;
        for (int i = 1; i <= in; ++i) {
            m = i - 1;
            pstmt.setObject(i, params[m]);
        }
    }

    public static void setParams(PreparedStatement pstmt, int index, Object[] params) throws SQLException {
        if (pstmt == null || params == null) {
            return;
        }
        int in = params.length;
        for (int i = 1; i <= in; ++i) {
            pstmt.setObject(i + index - 1, params[i - 1]);
        }
    }

    public static void setParams(PreparedStatement pstmt, List params) throws SQLException {
        if (pstmt == null || params == null) {
            return;
        }
        int in = params.size();
        for (int i = 0; i < in; ++i) {
            pstmt.setObject(i + 1, params.get(i));
        }
    }

    public static void setParams(PreparedStatement pstmt, List params, int index) throws SQLException {
        if (pstmt == null || params == null) {
            return;
        }
        int in = params.size() + index;
        for (int i = index; i < in; ++i) {
            pstmt.setObject(i, params.get(i - index));
        }
    }

    public static void setParams(PreparedStatement pstmt, Set params) throws SQLException {
        if (pstmt == null || params == null) {
            return;
        }
        int index = 1;
        Iterator iter = params.iterator();
        while (iter.hasNext()) {
            pstmt.setObject(index++, iter.next());
        }
    }

    public static String getParamSizeString(Collection collection) {
        if (collection == null) {
            return "";
        }
        StringBuffer str = new StringBuffer();
        int in = collection.size();
        for (int i = 0; i < in; ++i) {
            str.append("?,");
        }
        if (str.length() > 0) {
            str.delete(str.length() - 1, str.length());
        }
        return str.toString();
    }

    public static String getParamSizeString(int size) {
        if (size <= 0) {
            return "";
        }
        StringBuffer str = new StringBuffer();
        int in = size;
        for (int i = 0; i < in; ++i) {
            str.append("?,");
        }
        if (str.length() > 0) {
            str.delete(str.length() - 1, str.length());
        }
        return str.toString();
    }

    public static int execute(Context ctx, String sql, Object[] params) throws SQLException {
        if (ctx == null || sql == null) {
            return -1;
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        int number = -1;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            pstmt = conn.prepareStatement(sql);
            for (int i = 0; i < params.length; ++i) {
                pstmt.setObject(i + 1, params[i]);
            }
            number = pstmt.executeUpdate();
        }
        catch (SQLException exc) {
            try {
                throw exc;
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
        return number;
    }

    public static int execute(Connection conn, String sql) throws BOSException {
        if (conn == null || StringUtils.isEmpty((String)sql)) {
            return -1;
        }
        PreparedStatement pstmt = null;
        try {
            pstmt = conn.prepareStatement(sql);
            int n = pstmt.executeUpdate();
            return n;
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Statement)pstmt);
        }
    }

    public static int execute(Context ctx, String sql, String params) throws BOSException {
        if (ctx == null || sql == null) {
            return -1;
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        int number = -1;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            pstmt = conn.prepareStatement(sql);
            pstmt.setObject(1, params);
            number = pstmt.executeUpdate();
        }
        catch (SQLException exc) {
            try {
                StringBuffer sb = new StringBuffer("");
                sb.append("param is:").append(params);
                throw new BOSException(sql, (Throwable)exc);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
        return number;
    }

    public static Map getSubMap(Map parent, String key, boolean create) {
        if (parent == null) {
            return null;
        }
        if (parent.containsKey(key)) {
            return (Map)parent.get(key);
        }
        if (create) {
            parent.put(key, new HashMap());
            return (Map)parent.get(key);
        }
        return null;
    }

    public static void setBatchParams(Object[] sourceParams, Object[] targetParams, int startIndex, int batchIndex) {
        if (sourceParams == null || targetParams == null) {
            return;
        }
        for (int i = 0; i < 50; ++i) {
            int id = batchIndex * 50 + i;
            targetParams[startIndex + i] = id >= sourceParams.length ? NO_FOUND : sourceParams[id];
        }
    }

    public static void executeBatchQuery(Context ctx, String sql, List params, IResultReader reader) throws BOSException {
        Connection conn = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            MbgSqlHelper.executeBatchQuery(conn, sql, params, reader);
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
    }

    public static void executeBatchQuery(Connection conn, String sql, List params, IResultReader reader) throws BOSException {
        if (conn == null || sql == null || reader == null) {
            return;
        }
        PreparedStatement pstmt = null;
        ResultSet res = null;
        try {
            pstmt = conn.prepareStatement(sql);
            if (params == null || params.isEmpty()) {
                res = pstmt.executeQuery();
                while (res.next()) {
                    reader.read(res);
                }
            } else {
                for (int i = 0; i < params.size(); ++i) {
                    if (params.get(i) instanceof Object[]) {
                        MbgSqlHelper.setParams(pstmt, (Object[])params.get(i));
                    } else {
                        pstmt.setObject(1, params.get(i));
                    }
                    res = pstmt.executeQuery();
                    while (res.next()) {
                        reader.read(res);
                    }
                    SQLUtils.cleanup((ResultSet)res);
                }
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(res, (Statement)pstmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)res, (Statement)pstmt);
    }

    public static List executeQuery(Connection conn, String sql, Object[] params) throws BOSException {
        ArrayList<Object[]> pList = null;
        if (params != null) {
            pList = new ArrayList<Object[]>();
            pList.add(params);
        }
        return MbgSqlHelper.executeBatchQuery(conn, sql, pList);
    }

    public static List executeBatchQuery(Context ctx, String sql, List params) throws BOSException {
        if (ctx == null) {
            return null;
        }
        Connection conn = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            List list = MbgSqlHelper.executeBatchQuery(conn, sql, params);
            return list;
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
    }

    public static List executeBatchQuery(Connection conn, String sql, List params) throws BOSException {
        final ArrayList result = new ArrayList();
        MbgSqlHelper.executeBatchQuery(conn, sql, params, new IResultReader(){

            @Override
            public void read(ResultSet res) throws SQLException {
                result.add(res.getObject(1));
            }
        });
        return result;
    }

    public static void setBatchParams(Object[] sourceParams, Object[] targetParams, int startIndex, int batchIndex, int batchCont) {
        if (sourceParams == null || targetParams == null) {
            return;
        }
        for (int i = 0; i < batchCont; ++i) {
            int id = batchIndex * batchCont + i;
            targetParams[startIndex + i] = id >= sourceParams.length ? NO_FOUND : sourceParams[id];
        }
    }

    public static List getBatchParamsForNumber(Object[] commonParams, Object[] batchParams, int oneBatchCount) {
        return MbgSqlHelper.getBatchParamsForNumber(commonParams, batchParams, null, oneBatchCount);
    }

    public static List getBatchParamsForNumber(Object[] beforeParams, Object[] batchParams, Object[] afterParams, int oneBatchCount) {
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        if (batchParams == null || batchParams.length == 0) {
            return params;
        }
        int beforeCount = beforeParams == null ? 0 : beforeParams.length;
        int afterCount = afterParams == null ? 0 : afterParams.length;
        int batchCount = MbgSqlHelper.getBatchCount(batchParams);
        for (int i = 0; i < batchCount; ++i) {
            Object[] oneParam = new Object[beforeCount + oneBatchCount + afterCount];
            if (beforeCount > 0) {
                MbgSqlHelper.setBatchParamsForNumber(beforeParams, oneParam, 0, 0, beforeCount);
            }
            MbgSqlHelper.setBatchParamsForNumber(batchParams, oneParam, beforeCount, i, oneBatchCount);
            if (afterCount > 0) {
                MbgSqlHelper.setBatchParamsForNumber(afterParams, oneParam, beforeCount + oneBatchCount, 0, afterCount);
            }
            params.add(oneParam);
        }
        return params;
    }

    public static void setBatchParamsForNumber(Object[] sourceParams, Object[] targetParams, int startIndex, int batchIndex, int batchCont) {
        if (sourceParams == null || targetParams == null) {
            return;
        }
        for (int i = 0; i < batchCont; ++i) {
            int id = batchIndex * batchCont + i;
            targetParams[startIndex + i] = id >= sourceParams.length ? Integer.valueOf(Integer.MIN_VALUE) : sourceParams[id];
        }
    }

    public static List<Object[]> replaceSharpToInt(List<Object[]> params) {
        if (params == null) {
            return params;
        }
        for (int p = 0; p < params.size(); ++p) {
            Object[] _ps = params.get(p);
            for (int i = 0; i < _ps.length; ++i) {
                if (!NO_FOUND.equals(_ps[i])) continue;
                _ps[i] = Integer.MIN_VALUE;
            }
        }
        return params;
    }

    public static List getBatchParams(Object[] commonParams, Object[] batchParams, int oneBatchCount) {
        return MbgSqlHelper.getBatchParams(commonParams, batchParams, null, oneBatchCount);
    }

    public static List getBatchParams(Object[] beforeParams, Object[] batchParams, Object[] afterParams, int oneBatchCount) {
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        if (batchParams == null || batchParams.length == 0) {
            return params;
        }
        int beforeCount = beforeParams == null ? 0 : beforeParams.length;
        int afterCount = afterParams == null ? 0 : afterParams.length;
        int batchCount = MbgSqlHelper.getBatchCount(batchParams, oneBatchCount);
        for (int i = 0; i < batchCount; ++i) {
            Object[] oneParam = new Object[beforeCount + oneBatchCount + afterCount];
            if (beforeCount > 0) {
                MbgSqlHelper.setBatchParams(beforeParams, oneParam, 0, 0, beforeCount);
            }
            MbgSqlHelper.setBatchParams(batchParams, oneParam, beforeCount, i, oneBatchCount);
            if (afterCount > 0) {
                MbgSqlHelper.setBatchParams(afterParams, oneParam, beforeCount + oneBatchCount, 0, afterCount);
            }
            params.add(oneParam);
        }
        return params;
    }

    public static StringBuffer convertArray(Object[] obj, StringBuffer str) {
        if (obj == null || obj.length == 0) {
            return str;
        }
        if (str == null) {
            str = new StringBuffer();
        }
        for (int i = 0; i < obj.length; ++i) {
            if (i != 0) {
                str.append(", ");
            }
            str.append(obj[i]);
        }
        return str;
    }

    public static void setBytes(PreparedStatement stat, int index, byte[] bytes) throws SQLException {
        if (stat == null) {
            return;
        }
        if (bytes != null && bytes.length > 0) {
            stat.setBinaryStream(index, (InputStream)new ByteArrayInputStream(bytes), bytes.length);
        } else {
            stat.setBytes(index, null);
        }
    }

    public static byte[] getBytes(ResultSet rst, String key) throws SQLException, IOException {
        if (rst == null || StringUtils.isEmpty((String)key)) {
            return null;
        }
        InputStream in = rst.getBinaryStream(key);
        return MbgSqlHelper.getBytes(in);
    }

    public static byte[] getBytes(ResultSet rst, int index) throws SQLException, IOException {
        if (rst == null) {
            return null;
        }
        InputStream in = rst.getBinaryStream(index);
        return MbgSqlHelper.getBytes(in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] getBytes(InputStream in) throws IOException {
        if (in == null) {
            return null;
        }
        int len = -1;
        int blockSize = 1024;
        byte[] block = new byte[1024];
        byte[] bytes = null;
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        try {
            do {
                if ((len = in.read(block)) <= 0) continue;
                byteOut.write(block, 0, len);
            } while (len == 1024);
            bytes = byteOut.toByteArray();
        }
        finally {
            in.close();
            byteOut.close();
        }
        return bytes;
    }

    public static void convertTmpTable(Connection conn, Map<String, String> tmpTables) throws BOSException {
        if (conn == null || tmpTables == null || tmpTables.isEmpty()) {
            return;
        }
        String tableName = null;
        for (String key : tmpTables.keySet()) {
            tableName = "T_MBG_BgTmpQ" + key;
            if (tableName.length() > 18) {
                tableName = tableName.substring(0, 18);
            }
            if (BgDBUtils.existTable(conn, tableName) == BgDBUtils.YES) {
                MbgSqlHelper.execute(conn, "Drop Table " + tableName);
            }
            logger.error((Object)("Template Table:" + tmpTables.get(key) + ", New Table:" + tableName));
            MbgSqlHelper.execute(conn, "Select * Into " + tableName + " FROM " + tmpTables.get(key));
        }
    }
}

