/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.base.app.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ITreeBase;
import com.kingdee.eas.framework.TreeBaseCollection;
import com.kingdee.eas.framework.TreeBaseInfo;
import com.kingdee.eas.ma.base.app.utils.MbgSqlHelper;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class TreeBaseParentChangeHelper {
    private ITreeBase bizInstance = null;
    private Context ctx = null;
    private FilterInfo baseFilter = null;
    private Map<String, String> oldLongNumbers = new HashMap<String, String>();
    private Map<String, String> newLongNumbers = new HashMap<String, String>();
    private Map<String, TreeBaseInfo> childs = new HashMap<String, TreeBaseInfo>();

    public TreeBaseParentChangeHelper(Context ctx, ITreeBase bizInstance) {
        this.ctx = ctx;
        this.bizInstance = bizInstance;
    }

    public TreeBaseParentChangeHelper(Context ctx, ITreeBase bizInstance, FilterInfo baseFilter) {
        this(ctx, bizInstance);
        this.baseFilter = baseFilter;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void init(IObjectCollection col) throws BOSException {
        Connection conn;
        TreeBaseCollection treeCol;
        EntityViewInfo evi;
        TreeBaseInfo info;
        block19: {
            if (col == null || col.isEmpty()) {
                return;
            }
            HashSet<String> ids = new HashSet<String>();
            info = null;
            for (int i = 0; i < col.size(); ++i) {
                info = (TreeBaseInfo)col.getObject(i);
                if (info.getId() == null) continue;
                ids.add(info.getId().toString());
                this.newLongNumbers.put(info.getId().toString(), info.getLongNumber());
            }
            evi = new EntityViewInfo();
            TempTablePool pool = TempTablePool.getInstance((Context)this.ctx);
            String tempIds = null;
            treeCol = null;
            conn = null;
            try {
                conn = EJBFactory.getConnection((Context)this.ctx);
                tempIds = pool.createTempTable("Create Table T_MBG_TEMPIDS(FID Varchar(44) NOT NULL)");
                BgDBUtils.insertKey(conn, "Insert Into " + tempIds + "(FID) Values(?)", ids);
                evi.setFilter(new FilterInfo());
                evi.getFilter().getFilterItems().add(new FilterItemInfo("id", (Object)("Select FID FROM " + tempIds), CompareType.INNER));
                evi.setSelector(new SelectorItemCollection());
                evi.getSelector().add("id");
                evi.getSelector().add("longNumber");
                evi.getSelector().add("level");
                treeCol = this.bizInstance.getTreeBaseCollection(evi);
                if (tempIds == null) break block19;
            }
            catch (Exception e) {
                try {
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    if (tempIds != null) {
                        pool.releaseTable(tempIds);
                    }
                    SQLUtils.cleanup((Connection)conn);
                    throw throwable;
                }
            }
            pool.releaseTable(tempIds);
        }
        SQLUtils.cleanup((Connection)conn);
        if (treeCol == null || treeCol.isEmpty()) {
            return;
        }
        for (int i = 0; i < treeCol.size(); ++i) {
            info = treeCol.get(i);
            if (info.getLongNumber().equals(this.newLongNumbers.get(info.getId().toString()))) continue;
            this.oldLongNumbers.put(info.getLongNumber(), info.getId().toString());
        }
        if (this.oldLongNumbers.isEmpty()) {
            return;
        }
        Object[] params = this.oldLongNumbers.keySet().toArray();
        Arrays.sort(params);
        HashSet<String> queriedNumbers = new HashSet<String>();
        int batchCount = MbgSqlHelper.getBatchCount(params.length);
        String longNumber = null;
        String[] lns = null;
        StringBuffer maskString = new StringBuffer();
        int lIndex = 0;
        int filterIndex = 0;
        int b = 0;
        while (b < batchCount) {
            evi.getFilter().getFilterItems().clear();
            filterIndex = 0;
            maskString.setLength(0);
            block7: for (int q = 0; q < 50 && (lIndex = b * 50 + q) < params.length; ++q) {
                longNumber = (String)params[lIndex];
                lns = longNumber.split("!");
                for (int l = lns.length - 2; l >= 0; --l) {
                    queriedNumbers.add(lns[lns.length - 1]);
                    if (queriedNumbers.contains(lns[l])) continue block7;
                }
                evi.getFilter().getFilterItems().add(new FilterItemInfo("longNumber", (Object)(longNumber + "!%"), CompareType.LIKE));
                if (filterIndex > 0) {
                    maskString.append(" OR ");
                }
                maskString.append("#").append(filterIndex);
                ++filterIndex;
            }
            if (maskString.length() != 0) {
                evi.getFilter().setMaskString(maskString.toString());
                if (this.baseFilter != null && !this.baseFilter.getFilterItems().isEmpty()) {
                    evi.getFilter().mergeFilter(this.baseFilter, "AND");
                }
                if ((treeCol = this.bizInstance.getTreeBaseCollection(evi)) != null && !treeCol.isEmpty()) {
                    for (int i = 0; i < treeCol.size(); ++i) {
                        this.childs.put(treeCol.get(i).getId().toString(), treeCol.get(i));
                    }
                }
            }
            ++b;
        }
        return;
    }

    public void updateParent() throws EASBizException, BOSException {
        if (this.childs.isEmpty()) {
            return;
        }
        CoreBaseCollection updates = new CoreBaseCollection();
        int longNumIndex = 0;
        String parentLongNumber = null;
        for (TreeBaseInfo info : this.childs.values()) {
            parentLongNumber = info.getLongNumber();
            longNumIndex = -1;
            while ((longNumIndex = parentLongNumber.lastIndexOf("!")) > 0 && !this.oldLongNumbers.containsKey(parentLongNumber = parentLongNumber.substring(0, longNumIndex))) {
            }
            if (longNumIndex <= 0) continue;
            info.setLongNumber(this.newLongNumbers.get(this.oldLongNumbers.get(parentLongNumber)) + info.getLongNumber().substring(longNumIndex));
            info.setLevel(info.getLongNumber().split("!").length);
            updates.add((CoreBaseInfo)info);
        }
        this.bizInstance.updateBatchData(updates);
    }
}

