/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.base.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.BgExamineException;
import com.kingdee.eas.ma.base.TransactionCtrlFacadeFactory;
import com.kingdee.eas.ma.base.app.utils.DBTmpTableManager;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.base.utils.BgCommNHelper;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.JdbcRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;

public class BgDBUtils {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.mbg.base.util.DBUtils");
    public static int CANCEL = -1;
    public static int YES = 1;
    public static int NO = 0;
    public static final int batchSize = 50;
    public static final int batchMaxSize = 100;

    public static int length(String value) {
        int valueLength = 0;
        if (value == null) {
            return 0;
        }
        String chinese = "[\u0391-\uffe5]";
        for (int i = 0; i < value.length(); ++i) {
            String temp = value.substring(i, i + 1);
            if (temp.matches(chinese)) {
                ++valueLength;
                continue;
            }
            ++valueLength;
        }
        return valueLength;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isMSSQL(Context ctx) {
        if (ctx == null) {
            return false;
        }
        boolean re = false;
        Connection conn = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            re = BgDBUtils.isMSSQL(conn);
        }
        catch (SQLException ex) {
            logger.error((Object)"isMSSQL:", (Throwable)ex);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        return re;
    }

    public static boolean isMSSQL(Connection conn) {
        if (conn == null) {
            return false;
        }
        boolean re = false;
        DatabaseMetaData metaData = null;
        try {
            metaData = conn.getMetaData();
            String _name = metaData.getDatabaseProductName().toLowerCase();
            if (_name != null && (_name.indexOf("sql server") >= 0 || _name.indexOf("microsoft sql server") >= 0)) {
                re = true;
            }
        }
        catch (SQLException ex) {
            logger.error((Object)"isMSSQL:", (Throwable)ex);
        }
        return re;
    }

    public static boolean isOracle(Connection conn) {
        if (conn == null) {
            return false;
        }
        boolean re = false;
        DatabaseMetaData metaData = null;
        try {
            metaData = conn.getMetaData();
            String _name = metaData.getDatabaseProductName().toLowerCase();
            if (_name != null && _name.indexOf("oracle") >= 0) {
                re = true;
            }
        }
        catch (SQLException ex) {
            logger.error((Object)"isMSSQL:", (Throwable)ex);
        }
        return re;
    }

    public static boolean isDB2(Connection conn) {
        if (conn == null) {
            return false;
        }
        boolean re = false;
        DatabaseMetaData metaData = null;
        try {
            metaData = conn.getMetaData();
            String _name = metaData.getDatabaseProductName().toLowerCase();
            if (_name != null && _name.indexOf("db2") >= 0) {
                re = true;
            }
        }
        catch (SQLException ex) {
            logger.error((Object)"isMSSQL:", (Throwable)ex);
        }
        return re;
    }

    public static boolean isKingBaseES(Connection conn) {
        if (conn == null) {
            return false;
        }
        boolean re = false;
        DatabaseMetaData metaData = null;
        try {
            metaData = conn.getMetaData();
            String _name = metaData.getDatabaseProductName().toLowerCase();
            if (_name != null && _name.indexOf("kingbasees") >= 0) {
                re = true;
            }
        }
        catch (SQLException ex) {
            logger.error((Object)"isPostgresql:", (Throwable)ex);
        }
        return re;
    }

    public static boolean isPostgresql(Connection conn) {
        if (conn == null) {
            return false;
        }
        boolean re = false;
        DatabaseMetaData metaData = null;
        try {
            metaData = conn.getMetaData();
            String _name = metaData.getDatabaseProductName().toLowerCase();
            if (_name != null && _name.indexOf("postgresql") >= 0) {
                re = true;
            }
        }
        catch (SQLException ex) {
            logger.error((Object)"isPostgresql:", (Throwable)ex);
        }
        return re;
    }

    public static boolean isDM(Connection conn) {
        if (conn == null) {
            return false;
        }
        boolean re = false;
        DatabaseMetaData metaData = null;
        try {
            metaData = conn.getMetaData();
            String driverName = metaData.getDriverName();
            if (driverName != null && driverName.indexOf("DmDriver") >= 0) {
                re = true;
            }
        }
        catch (SQLException ex) {
            logger.error((Object)"isDM:", (Throwable)ex);
        }
        return re;
    }

    public static Connection getConnection(Context ctx) throws SQLDataException {
        try {
            return EJBFactory.getConnection((Context)ctx);
        }
        catch (SQLException sqle) {
            throw new SQLDataException(sqle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int existTable(Context ctx, String tableName) {
        if (ctx == null || StringUtils.isEmpty((String)tableName)) {
            return CANCEL;
        }
        Connection conn = null;
        int re = NO;
        try {
            conn = BgDBUtils.getConnection(ctx);
            re = BgDBUtils.existTable(conn, tableName);
        }
        catch (SQLDataException ex) {
            logger.error((Object)"sql error:", (Throwable)ex);
            re = CANCEL;
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        return re;
    }

    public static int existTable(Connection conn, String tableName) {
        if (conn == null || StringUtils.isEmpty((String)tableName)) {
            return CANCEL;
        }
        int re = NO;
        re = BgDBUtils.isPostgresql(conn) ? BgDBUtils.existTableByPostgreSql(conn, tableName) : BgDBUtils.existTableByKSql(conn, tableName);
        return re;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int existTableByDB(Connection conn, String tableName) {
        if (conn == null || StringUtils.isEmpty((String)tableName)) {
            return CANCEL;
        }
        ResultSet rst = null;
        Statement pstmt = null;
        int re = NO;
        String _tableName = tableName.toUpperCase();
        String[] filterTypes = new String[]{"TABLE"};
        try {
            String catalog = conn.getCatalog();
            String schemaPattern = null;
            if (BgDBUtils.isOracle(conn)) {
                schemaPattern = conn.getMetaData().getUserName().toUpperCase();
            }
            rst = conn.getMetaData().getTables(catalog, schemaPattern, _tableName, filterTypes);
            while (rst.next()) {
                if (!tableName.equalsIgnoreCase(rst.getString("TABLE_NAME"))) continue;
                re = YES;
                break;
            }
            SQLUtils.cleanup((ResultSet)rst, pstmt);
        }
        catch (SQLException ex) {
            logger.error((Object)"sql error:", (Throwable)ex);
            re = CANCEL;
        }
        finally {
            SQLUtils.cleanup(rst, pstmt);
        }
        return re;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int existTableByKSql(Connection conn, String tableName) {
        int re;
        PreparedStatement pstmt;
        ResultSet rst;
        block6: {
            if (conn == null || StringUtils.isEmpty((String)tableName)) {
                return CANCEL;
            }
            rst = null;
            pstmt = null;
            re = NO;
            String _tableName = tableName.toUpperCase();
            try {
                if (BgDBUtils.isPostgresql(conn)) {
                    re = BgDBUtils.existTableByPostgreSql(conn, tableName);
                    break block6;
                }
                pstmt = conn.prepareStatement("select * from KSQL_USERTABLES where KSQL_TABNAME = ?");
                pstmt.setString(1, _tableName);
                rst = pstmt.executeQuery();
                if (!rst.next()) break block6;
                re = YES;
            }
            catch (SQLException ex) {
                try {
                    logger.error((Object)"sql error:", (Throwable)ex);
                    re = CANCEL;
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rst, pstmt);
                    throw throwable;
                }
                SQLUtils.cleanup(rst, (Statement)pstmt);
            }
        }
        SQLUtils.cleanup(rst, (Statement)pstmt);
        return re;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int existTableByPostgreSql(Connection conn, String tableName) {
        int re;
        PreparedStatement pstmt;
        ResultSet rst;
        block5: {
            if (conn == null || StringUtils.isEmpty((String)tableName)) {
                return CANCEL;
            }
            rst = null;
            pstmt = null;
            re = NO;
            String _tableName = tableName.toLowerCase();
            try {
                pstmt = conn.prepareStatement("SELECT relname FROM pg_class WHERE relname = ?");
                pstmt.setString(1, _tableName);
                rst = pstmt.executeQuery();
                if (!rst.next()) break block5;
                re = YES;
            }
            catch (SQLException ex) {
                try {
                    logger.error((Object)"sql error:", (Throwable)ex);
                    re = CANCEL;
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rst, (Statement)pstmt);
                    throw throwable;
                }
                SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
        return re;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int existView(Context ctx, String viewName) {
        if (ctx == null || StringUtils.isEmpty((String)viewName)) {
            return CANCEL;
        }
        Connection conn = null;
        int re = NO;
        try {
            conn = BgDBUtils.getConnection(ctx);
            re = BgDBUtils.existView(conn, viewName);
        }
        catch (SQLDataException ex) {
            logger.error((Object)"sql error:", (Throwable)ex);
            re = CANCEL;
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        return re;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int existView(Connection conn, String viewName) {
        if (conn == null || StringUtils.isEmpty((String)viewName)) {
            return CANCEL;
        }
        ResultSet rst = null;
        int re = NO;
        try {
            String[] filterTypes = new String[]{"VIEW"};
            String catalog = conn.getCatalog();
            String schemaPattern = null;
            if (BgDBUtils.isOracle(conn)) {
                schemaPattern = conn.getMetaData().getUserName().toUpperCase();
            }
            rst = conn.getMetaData().getTables(catalog, schemaPattern, viewName.toUpperCase(), filterTypes);
            while (rst.next()) {
                if (!viewName.equalsIgnoreCase(rst.getString("TABLE_NAME"))) continue;
                re = YES;
                break;
            }
            SQLUtils.cleanup((ResultSet)rst);
        }
        catch (SQLException ex) {
            logger.error((Object)"sql error:", (Throwable)ex);
            re = CANCEL;
        }
        finally {
            SQLUtils.cleanup(rst);
        }
        return re;
    }

    public static int existIndexNew(Context ctx, String tableName, String indexName) throws BOSException {
        if (ctx == null || StringUtils.isEmpty((String)tableName) || StringUtils.isEmpty((String)indexName)) {
            return CANCEL;
        }
        Connection conn = null;
        int re = CANCEL;
        try {
            conn = BgDBUtils.getConnection(ctx);
            re = BgDBUtils.existIndexNew(conn, tableName, indexName);
        }
        catch (SQLDataException ex) {
            logger.error((Object)"sql error:", (Throwable)ex);
            throw new BOSException((Throwable)ex);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        return re;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int existIndex(Context ctx, String tableName, String indexName) {
        if (ctx == null || StringUtils.isEmpty((String)tableName) || StringUtils.isEmpty((String)indexName)) {
            return CANCEL;
        }
        Connection conn = null;
        int re = CANCEL;
        try {
            conn = BgDBUtils.getConnection(ctx);
            re = BgDBUtils.existIndex(conn, tableName, indexName);
        }
        catch (SQLDataException ex) {
            logger.error((Object)"sql error:", (Throwable)ex);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        return re;
    }

    public static int existIndex(Connection conn, String tableName, String indexName) {
        try {
            return BgDBUtils.existIndexNew(conn, tableName, indexName);
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            return CANCEL;
        }
    }

    public static int existIndexNew(Connection conn, String tableName, String indexName) throws BOSException {
        int re;
        ResultSet rst;
        PreparedStatement pstmt;
        block7: {
            if (conn == null || StringUtils.isEmpty((String)tableName) || StringUtils.isEmpty((String)indexName)) {
                return CANCEL;
            }
            pstmt = null;
            rst = null;
            re = NO;
            String _tableName = tableName.toUpperCase();
            String _indexName = indexName.toUpperCase();
            try {
                if (BgDBUtils.isPostgresql(conn)) {
                    re = BgDBUtils.existIndexByPostgreSql(conn, tableName, indexName);
                    break block7;
                }
                pstmt = conn.prepareStatement("select * from KSQL_INDEXES where KSQL_INDNAME = ?");
                pstmt.setString(1, _indexName);
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    re = YES;
                }
            }
            catch (SQLException ex) {
                try {
                    logger.error((Object)"sql error:", (Throwable)ex);
                    throw new BOSException((Throwable)ex);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rst, pstmt);
                    throw throwable;
                }
            }
        }
        SQLUtils.cleanup(rst, (Statement)pstmt);
        return re;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int existIndexByPostgreSql(Connection conn, String tableName, String indexName) {
        if (conn == null || StringUtils.isEmpty((String)tableName) || StringUtils.isEmpty((String)indexName)) {
            return CANCEL;
        }
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        int re = NO;
        String _tableName = tableName.toLowerCase();
        String _indexName = indexName.toLowerCase();
        try {
            pstmt = conn.prepareStatement("SELECT c.relname, c1.relname FROM pg_index i inner join pg_class c on i.indrelid = c.oid inner join pg_class c1 on i.indexrelid = c1.oid WHERE c.relname = ? and c1.relname = ?");
            pstmt.setString(1, _tableName);
            pstmt.setString(2, _indexName);
            rst = pstmt.executeQuery();
            if (rst.next()) {
                re = YES;
            }
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
        }
        catch (SQLException ex) {
            logger.error((Object)"sql error:", (Throwable)ex);
            re = CANCEL;
        }
        finally {
            SQLUtils.cleanup(rst, (Statement)pstmt);
        }
        return re;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getColumns(Context ctx, String tableName) {
        if (ctx == null || StringUtils.isEmpty((String)tableName)) {
            return null;
        }
        ArrayList<String> columns = new ArrayList();
        Connection conn = null;
        try {
            conn = BgDBUtils.getConnection(ctx);
            columns = BgDBUtils.getColumns(conn, tableName);
        }
        catch (SQLDataException ex) {
            logger.error((Object)"sql error:", (Throwable)ex);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        return columns;
    }

    public static List<String> getColumns(Connection conn, String tableName) {
        if (conn == null || StringUtils.isEmpty((String)tableName)) {
            return null;
        }
        List<Object> columns = new ArrayList();
        columns = BgDBUtils.isPostgresql(conn) ? BgDBUtils.getColumnsByPostgreSql(conn, tableName) : BgDBUtils.getColumnsByKSql(conn, tableName);
        return columns;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> getColumnsByKSql(Connection conn, String tableName) {
        ResultSet rst;
        PreparedStatement pstmt;
        ArrayList<String> columns;
        block7: {
            if (conn == null || StringUtils.isEmpty((String)tableName)) {
                return null;
            }
            columns = new ArrayList();
            HashSet<String> columnSet = new HashSet<String>();
            pstmt = null;
            rst = null;
            String _tableName = tableName.toUpperCase();
            try {
                if (BgDBUtils.isPostgresql(conn)) {
                    columns = BgDBUtils.getColumnsByPostgreSql(conn, tableName);
                    break block7;
                }
                pstmt = conn.prepareStatement("select KSQL_COL_NAME from KSQL_USERCOLUMNS where KSQL_COL_TABNAME = ?");
                pstmt.setString(1, _tableName);
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    if (StringUtils.isEmpty((String)rst.getString(1))) continue;
                    columnSet.add(rst.getString(1).toUpperCase());
                }
                columns.addAll(columnSet);
            }
            catch (SQLException ex) {
                try {
                    logger.error((Object)"sql error:", (Throwable)ex);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rst, pstmt);
                    throw throwable;
                }
                SQLUtils.cleanup(rst, (Statement)pstmt);
            }
        }
        SQLUtils.cleanup(rst, (Statement)pstmt);
        return columns;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> getColumnsByPostgreSql(Connection conn, String tableName) {
        ResultSet rst;
        PreparedStatement pstmt;
        HashSet<String> columnSet;
        block6: {
            if (conn == null || StringUtils.isEmpty((String)tableName)) {
                return null;
            }
            columnSet = new HashSet<String>();
            pstmt = null;
            rst = null;
            String _tableName = tableName.toLowerCase();
            try {
                if (!BgDBUtils.isPostgresql(conn)) break block6;
                pstmt = conn.prepareStatement("select a.attname from pg_attribute a inner join pg_class c on a.attrelid = c.oid where c.relname = ? and a.attnum > 0");
                pstmt.setString(1, _tableName);
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    columnSet.add(rst.getString(1).toUpperCase());
                }
            }
            catch (SQLException ex) {
                try {
                    logger.error((Object)"sql error:", (Throwable)ex);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rst, pstmt);
                    throw throwable;
                }
                SQLUtils.cleanup(rst, (Statement)pstmt);
            }
        }
        SQLUtils.cleanup(rst, pstmt);
        return new ArrayList<String>(columnSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int existColumn(Context ctx, String tableName, String columnName) {
        if (ctx == null || StringUtils.isEmpty((String)tableName) || StringUtils.isEmpty((String)columnName)) {
            return CANCEL;
        }
        Connection conn = null;
        int re = CANCEL;
        try {
            conn = BgDBUtils.getConnection(ctx);
            re = BgDBUtils.existColumn(conn, tableName, columnName);
        }
        catch (SQLDataException ex) {
            logger.error((Object)"sql error:", (Throwable)ex);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        return re;
    }

    public static int existColumn(Connection conn, String tableName, String columnName) {
        if (BgDBUtils.isPostgresql(conn)) {
            return BgDBUtils.existColumnByPostgreSql(conn, tableName, columnName);
        }
        return BgDBUtils.existColumnByKSql(conn, tableName, columnName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int existColumnByKSql(Connection conn, String tableName, String columnName) {
        if (conn == null || StringUtils.isEmpty((String)tableName) || StringUtils.isEmpty((String)columnName)) {
            return CANCEL;
        }
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        int re = NO;
        String _tableName = tableName.toUpperCase();
        String _columnName = columnName.toUpperCase();
        try {
            pstmt = conn.prepareStatement("select KSQL_COL_NAME from KSQL_USERCOLUMNS where KSQL_COL_NAME = ? and KSQL_COL_TABNAME = ?");
            pstmt.setString(1, _columnName);
            pstmt.setString(2, _tableName);
            rst = pstmt.executeQuery();
            if (rst.next()) {
                re = YES;
            }
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
        }
        catch (SQLException ex) {
            logger.error((Object)"sql error:", (Throwable)ex);
            re = CANCEL;
        }
        finally {
            SQLUtils.cleanup(rst, (Statement)pstmt);
        }
        return re;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int existColumnByPostgreSql(Connection conn, String tableName, String columnName) {
        if (conn == null || StringUtils.isEmpty((String)tableName) || StringUtils.isEmpty((String)columnName)) {
            return CANCEL;
        }
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        int re = NO;
        String _tableName = tableName.toLowerCase();
        String _columnName = columnName.toLowerCase();
        try {
            pstmt = conn.prepareStatement("select a.attname from pg_attribute a inner join pg_class c on a.attrelid = c.oid where c.relname = ? and a.attname = ? and a.attnum > 0");
            pstmt.setString(1, _tableName);
            pstmt.setString(2, _columnName);
            rst = pstmt.executeQuery();
            if (rst.next()) {
                re = YES;
            }
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
        }
        catch (SQLException ex) {
            logger.error((Object)"sql error:", (Throwable)ex);
            re = CANCEL;
        }
        finally {
            SQLUtils.cleanup(rst, (Statement)pstmt);
        }
        return re;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int executeUpdate(Context ctx, String sql) throws SQLDataException, SQLException {
        if (ctx == null) return CANCEL;
        if (StringUtils.isEmpty((String)sql)) {
            return CANCEL;
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        int re = NO;
        try {
            conn = BgDBUtils.getConnection(ctx);
            pstmt = conn.prepareStatement(sql);
            re = pstmt.executeUpdate();
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"sql error:", (Throwable)ex);
                throw ex;
                catch (SQLDataException ex2) {
                    logger.error((Object)"sql error:", (Throwable)ex2);
                    throw ex2;
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
        return re;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int executeUpdate(Context ctx, String sql, Object[] params) throws SQLDataException, SQLException {
        if (ctx == null) return CANCEL;
        if (StringUtils.isEmpty((String)sql)) return CANCEL;
        if (params == null) {
            return CANCEL;
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        int re = CANCEL;
        try {
            conn = BgDBUtils.getConnection(ctx);
            pstmt = conn.prepareStatement(sql);
            int in = params.length;
            for (int i = 0; i < in; ++i) {
                pstmt.setObject(i + 1, params[i]);
            }
            re = pstmt.executeUpdate();
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"sql error:", (Throwable)ex);
                throw ex;
                catch (SQLDataException ex2) {
                    logger.error((Object)"sql error:", (Throwable)ex2);
                    throw ex2;
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
        return re;
    }

    public static int executeUpdate(Connection conn, String sql) throws SQLException {
        if (conn == null || StringUtils.isEmpty((String)sql)) {
            return CANCEL;
        }
        PreparedStatement pstmt = null;
        int re = CANCEL;
        try {
            pstmt = conn.prepareStatement(sql);
            re = pstmt.executeUpdate();
        }
        catch (SQLException ex) {
            logger.error((Object)"sql error:", (Throwable)ex);
            throw ex;
        }
        finally {
            SQLUtils.cleanup((Statement)pstmt);
        }
        return re;
    }

    public static int[] executeUpdate(Connection conn, String[] sqls) throws SQLException {
        if (conn == null || sqls == null) {
            return null;
        }
        PreparedStatement pstmt = null;
        int[] re = new int[sqls.length];
        try {
            for (int i = 0; i < sqls.length; ++i) {
                if (sqls[i] == null) continue;
                pstmt = conn.prepareStatement(sqls[i]);
                re[i] = pstmt.executeUpdate();
                SQLUtils.cleanup((Statement)pstmt);
            }
        }
        catch (SQLException ex) {
            logger.error((Object)"sql error:", (Throwable)ex);
            throw ex;
        }
        finally {
            SQLUtils.cleanup(pstmt);
        }
        return re;
    }

    public static int executeUpdate(Connection conn, String sql, List<Object> params) throws SQLException {
        if (conn == null || StringUtils.isEmpty((String)sql) || params == null) {
            return CANCEL;
        }
        PreparedStatement pstmt = null;
        int re = CANCEL;
        try {
            pstmt = conn.prepareStatement(sql);
            int in = params.size();
            for (int i = 0; i < in; ++i) {
                pstmt.setObject(i + 1, params.get(i));
            }
            re = pstmt.executeUpdate();
        }
        catch (SQLException ex) {
            logger.error((Object)"sql error:", (Throwable)ex);
            throw ex;
        }
        finally {
            SQLUtils.cleanup((Statement)pstmt);
        }
        return re;
    }

    public static int executeUpdate(Connection conn, String sql, Object[] params) throws SQLException {
        int re = 0;
        if (conn == null || StringUtils.isEmpty((String)sql) || params == null) {
            return re;
        }
        PreparedStatement pstmt = null;
        try {
            pstmt = conn.prepareStatement(sql);
            int in = params.length;
            for (int i = 0; i < in; ++i) {
                pstmt.setObject(i + 1, params[i]);
            }
            re = pstmt.executeUpdate();
        }
        catch (SQLException ex) {
            logger.error((Object)"sql error:", (Throwable)ex);
            throw ex;
        }
        finally {
            SQLUtils.cleanup((Statement)pstmt);
        }
        return re;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void executeBatch(Context ctx, String sql, List<Object[]> params) throws SQLDataException, SQLException {
        if (ctx == null) return;
        if (StringUtils.isEmpty((String)sql)) return;
        if (params == null) return;
        if (params.isEmpty()) {
            return;
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        int batchIndex = 0;
        Object[] objs = null;
        try {
            conn = BgDBUtils.getConnection(ctx);
            pstmt = conn.prepareStatement(sql);
            int in = params.size();
            for (int i = 0; i < in; ++i, ++batchIndex) {
                objs = params.get(i);
                if (objs != null) {
                    for (int j = 0; j < objs.length; ++j) {
                        pstmt.setObject(j + 1, objs[j]);
                    }
                    pstmt.addBatch();
                }
                if (batchIndex < 50) continue;
                pstmt.executeBatch();
                batchIndex = 0;
            }
            if (batchIndex > 0) {
                pstmt.executeBatch();
                batchIndex = 0;
            }
        }
        catch (SQLException ex) {
            try {
                throw ex;
                catch (SQLDataException ex2) {
                    throw ex2;
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    public static int executeBatchUpdate(Connection conn, String sql, List<Object> params) throws SQLException {
        int re = 0;
        if (conn == null || StringUtils.isEmpty((String)sql) || params == null || params.isEmpty()) {
            return re;
        }
        PreparedStatement pstmt = null;
        int size = params.size();
        int count = (size - 1) / 50 + 1;
        int pos = 0;
        try {
            pstmt = conn.prepareStatement(sql);
            for (int index = 0; index < count; ++index) {
                int x = 1;
                while (x <= 50) {
                    if (pos < size) {
                        pstmt.setObject(x, params.get(pos));
                    } else {
                        pstmt.setObject(x, BgBaseConstants.noFindStr);
                    }
                    ++x;
                    ++pos;
                }
                re = pstmt.executeUpdate();
            }
        }
        catch (SQLException ex) {
            throw ex;
        }
        finally {
            SQLUtils.cleanup((Statement)pstmt);
        }
        return re;
    }

    public static void executeBatch(Connection conn, String sql, List<Object[]> params) throws SQLException {
        if (conn == null || StringUtils.isEmpty((String)sql) || params == null || params.isEmpty()) {
            return;
        }
        PreparedStatement pstmt = null;
        int batchIndex = 0;
        Object[] objs = null;
        try {
            pstmt = conn.prepareStatement(sql);
            int i = 0;
            int in = params.size();
            while (i < in) {
                objs = params.get(i);
                if (objs != null) {
                    for (int j = 0; j < objs.length; ++j) {
                        pstmt.setObject(j + 1, objs[j]);
                    }
                    pstmt.addBatch();
                }
                if (batchIndex >= 50) {
                    pstmt.executeBatch();
                    batchIndex = 0;
                }
                ++i;
                ++batchIndex;
            }
            if (batchIndex > 0) {
                pstmt.executeBatch();
                batchIndex = 0;
            }
        }
        catch (SQLException ex) {
            throw ex;
        }
        finally {
            SQLUtils.cleanup((Statement)pstmt);
        }
    }

    public static IRowSet executeQuery(Context ctx, String sql) throws SQLException {
        JdbcRowSet rowset = new JdbcRowSet();
        if (ctx == null || sql == null) {
            return rowset;
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            pstmt = conn.prepareStatement(sql);
            rs = pstmt.executeQuery();
            rowset.populate(rs);
        }
        catch (SQLException exc) {
            try {
                logger.error((Object)("Sql execute exception : " + sql), (Throwable)exc);
                throw exc;
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
        return rowset;
    }

    public static IRowSet executeQuery(Context ctx, String sql, Object[] params) throws SQLException {
        JdbcRowSet rowset = new JdbcRowSet();
        if (ctx == null || sql == null) {
            return rowset;
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            pstmt = conn.prepareStatement(sql);
            if (params != null) {
                int in = params.length;
                for (int i = 0; i < in; ++i) {
                    pstmt.setObject(i + 1, params[i]);
                }
            }
            rs = pstmt.executeQuery();
            rowset.populate(rs);
        }
        catch (SQLException exc) {
            try {
                logger.error((Object)"sql error:", (Throwable)exc);
                throw exc;
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
        return rowset;
    }

    public static IRowSet executeQuery(Connection conn, String sql) throws SQLException {
        JdbcRowSet rowset = new JdbcRowSet();
        if (conn == null || sql == null) {
            return rowset;
        }
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = conn.prepareStatement(sql);
            rs = pstmt.executeQuery();
            rowset.populate(rs);
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"sql error:", (Throwable)ex);
                throw ex;
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)pstmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt);
        return rowset;
    }

    public static IRowSet executeQuery(Connection conn, String sql, Object[] params) throws SQLException {
        JdbcRowSet rowset = new JdbcRowSet();
        if (conn == null || StringUtils.isEmpty((String)sql)) {
            return rowset;
        }
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            pstmt = conn.prepareStatement(sql);
            if (params != null) {
                int in = params.length;
                for (int i = 0; i < in; ++i) {
                    pstmt.setObject(i + 1, params[i]);
                }
            }
            rst = pstmt.executeQuery();
            rowset.populate(rst);
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"sql error:", (Throwable)ex);
                throw ex;
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, (Statement)pstmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
        return rowset;
    }

    public static IRowSet executeQuery(Connection conn, String sql, Collection<Object> params) throws SQLException {
        JdbcRowSet rowset = new JdbcRowSet();
        if (conn == null || StringUtils.isEmpty((String)sql) || params == null) {
            return rowset;
        }
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        int index = 1;
        try {
            pstmt = conn.prepareStatement(sql);
            for (Object obj : params) {
                pstmt.setObject(index++, obj);
            }
            rst = pstmt.executeQuery();
            rowset.populate(rst);
        }
        catch (SQLException ex) {
            logger.error((Object)"sql error:", (Throwable)ex);
            throw ex;
        }
        finally {
            SQLUtils.cleanup((Statement)pstmt);
        }
        return rowset;
    }

    public static List<Object[]> executeBatchQuery(Connection conn, String sql, List<Object> params) throws SQLException {
        return BgDBUtils.executeBatchQuery(conn, sql, params, 50);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Object[]> executeBatchQuery(Connection conn, String sql, List<Object> params, int batchSize) throws SQLException {
        ArrayList<Object[]> result = new ArrayList<Object[]>();
        if (conn == null || StringUtils.isEmpty((String)sql) || params == null) {
            return result;
        }
        int size = params.size();
        int count = (size - 1) / batchSize + 1;
        int pos = 0;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        int colCount = 0;
        Object[] objs = null;
        try {
            pstmt = conn.prepareStatement(sql);
            for (int index = 0; index < count; ++index) {
                int x = 1;
                while (x <= batchSize) {
                    if (pos < size) {
                        pstmt.setObject(x, params.get(pos));
                    } else {
                        pstmt.setObject(x, BgBaseConstants.noFindStr);
                    }
                    ++x;
                    ++pos;
                }
                try {
                    rst = pstmt.executeQuery();
                    colCount = rst.getMetaData().getColumnCount();
                    while (rst.next()) {
                        objs = new Object[colCount];
                        for (int i = 0; i < colCount; ++i) {
                            objs[i] = rst.getObject(i + 1);
                        }
                        result.add(objs);
                    }
                    continue;
                }
                finally {
                    SQLUtils.cleanup((ResultSet)rst);
                }
            }
        }
        catch (SQLException exc) {
            logger.error((Object)"sql error:", (Throwable)exc);
            throw exc;
        }
        finally {
            SQLUtils.cleanup(rst, (Statement)pstmt);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Object[]> executeBatchQuery(Connection conn, String sql, List<Object> firstParams, List<Object> params) throws SQLException {
        ArrayList<Object[]> result = new ArrayList<Object[]>();
        if (conn == null || StringUtils.isEmpty((String)sql) || firstParams == null) {
            return result;
        }
        int firstSize = firstParams.size();
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        int colCount = 0;
        Object[] objs = null;
        try {
            pstmt = conn.prepareStatement(sql);
            int xn = firstSize;
            for (int x = 0; x < xn; ++x) {
                pstmt.setObject(x + 1, firstParams.get(x));
            }
            if (params != null) {
                int size = params.size();
                int count = (size - 1) / 50 + 1;
                int pos = 0;
                for (int index = 0; index < count; ++index) {
                    int x = 1;
                    while (x <= 50) {
                        if (pos < size) {
                            pstmt.setObject(x + firstSize, params.get(pos));
                        } else {
                            pstmt.setObject(x + firstSize, BgBaseConstants.noFindStr);
                        }
                        ++x;
                        ++pos;
                    }
                    try {
                        rst = pstmt.executeQuery();
                        colCount = rst.getMetaData().getColumnCount();
                        while (rst.next()) {
                            objs = new Object[colCount];
                            for (int i = 0; i < colCount; ++i) {
                                objs[i] = rst.getObject(i + 1);
                            }
                            result.add(objs);
                        }
                        continue;
                    }
                    finally {
                        SQLUtils.cleanup((ResultSet)rst);
                    }
                }
            } else {
                rst = pstmt.executeQuery();
                colCount = rst.getMetaData().getColumnCount();
                while (rst.next()) {
                    objs = new Object[colCount];
                    for (int i = 0; i < colCount; ++i) {
                        objs[i] = rst.getObject(i + 1);
                    }
                    result.add(objs);
                }
            }
        }
        catch (SQLException exc) {
            try {
                logger.error((Object)"sql error:", (Throwable)exc);
                throw exc;
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, (Statement)pstmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Object[]> executeBatchQuery(Connection conn, String sql, List<Object> firstParams, List<Object[]> params, int paramLength) throws SQLException {
        ArrayList<Object[]> result = new ArrayList<Object[]>();
        if (conn == null || StringUtils.isEmpty((String)sql) || firstParams == null || params == null) {
            return result;
        }
        int size = params.size();
        int count = (size - 1) / 50 + 1;
        int pos = 0;
        int firstSize = firstParams.size();
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        int colCount = 0;
        Object[] objs = null;
        Object[] param = null;
        try {
            pstmt = conn.prepareStatement(sql);
            int xn = firstSize;
            for (int x = 0; x < xn; ++x) {
                pstmt.setObject(x + 1, firstParams.get(x));
            }
            for (int index = 0; index < count; ++index) {
                int x = 0;
                while (x < 50) {
                    int y;
                    if (pos < size) {
                        param = params.get(pos);
                        for (y = 0; y < paramLength; ++y) {
                            pstmt.setObject(x * paramLength + firstSize + y + 1, param[y]);
                        }
                    } else {
                        for (y = 0; y < paramLength; ++y) {
                            pstmt.setObject(x * paramLength + firstSize + y + 1, BgBaseConstants.noFindStr);
                        }
                    }
                    ++x;
                    ++pos;
                }
                try {
                    rst = pstmt.executeQuery();
                    colCount = rst.getMetaData().getColumnCount();
                    while (rst.next()) {
                        objs = new Object[colCount];
                        for (int i = 0; i < colCount; ++i) {
                            objs[i] = rst.getObject(i + 1);
                        }
                        result.add(objs);
                    }
                    continue;
                }
                finally {
                    SQLUtils.cleanup((ResultSet)rst);
                }
            }
        }
        catch (SQLException exc) {
            logger.error((Object)"sql error:", (Throwable)exc);
            throw exc;
        }
        finally {
            SQLUtils.cleanup(rst, (Statement)pstmt);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int dropTable(Context ctx, String tableName) {
        if (ctx == null || StringUtils.isEmpty((String)tableName)) {
            return CANCEL;
        }
        Connection conn = null;
        int re = 0;
        try {
            conn = BgDBUtils.getConnection(ctx);
            re = BgDBUtils.dropTable(conn, tableName);
        }
        catch (SQLDataException ex) {
            logger.error((Object)"sql error:", (Throwable)ex);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        return re;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int dropTable(Connection conn, String tableName) {
        if (conn == null || StringUtils.isEmpty((String)tableName)) {
            return CANCEL;
        }
        PreparedStatement pstmt = null;
        int re = CANCEL;
        try {
            pstmt = conn.prepareStatement("Drop Table " + tableName);
            re = pstmt.executeUpdate();
            SQLUtils.cleanup((Statement)pstmt);
        }
        catch (SQLException ex) {
            logger.error((Object)"sql error:", (Throwable)ex);
        }
        finally {
            SQLUtils.cleanup(pstmt);
        }
        return re;
    }

    public static String createTmpTable(TempTablePool pool, String tableSql) throws BOSException, EASBizException {
        if (pool == null || tableSql == null) {
            throw new BgExamineException(BgExamineException.TMPTABLENAMECANTISNULL);
        }
        try {
            return pool.createTempTable(tableSql);
        }
        catch (Exception ex) {
            throw new BOSException((Throwable)ex);
        }
    }

    public static String createTmpTable(Context ctx, TempTablePool pool, String tableSql) throws BOSException, EASBizException {
        if (ctx == null || pool == null || tableSql == null) {
            throw new BgExamineException(BgExamineException.TMPTABLENAMECANTISNULL);
        }
        try {
            return pool.createTempTable(tableSql);
        }
        catch (Exception ex) {
            throw new BOSException((Throwable)ex);
        }
    }

    public static String createDBTmpTable(Connection conn, TempTablePool pool, String tableSql) throws Exception {
        if (conn == null || pool == null || tableSql == null) {
            throw new BgExamineException(BgExamineException.TMPTABLENAMECANTISNULL);
        }
        return pool.createDBSystemTempTable(tableSql, conn);
    }

    public static void releaseDBTmpTable(Connection conn, TempTablePool pool, String tmpTable) throws Exception {
        if (conn == null || pool == null || tmpTable == null) {
            throw new BgExamineException(BgExamineException.TMPTABLENAMECANTISNULL);
        }
        pool.releaseDBSystemTempTable(tmpTable, conn);
    }

    public static void releaseDBTmpTable(Connection conn, TempTablePool pool, List<String> tableName) throws Exception {
        if (conn == null || pool == null || tableName == null) {
            return;
        }
        int in = tableName.size();
        for (int i = 0; i < in; ++i) {
            pool.releaseDBSystemTempTable(tableName.get(i), conn);
        }
    }

    public static DBTmpTableManager createDBTmpTable(Context ctx, final TempTablePool pool, final String tableSql) throws BOSException, EASBizException {
        if (ctx == null || pool == null || tableSql == null) {
            throw new BgExamineException(BgExamineException.TMPTABLENAMECANTISNULL);
        }
        final DBTmpTableManager manager = new DBTmpTableManager(ctx);
        TxRunnable runnable = new TxRunnable(){

            @Override
            public void run() {
                try {
                    manager.initConnection();
                    this.result = manager.createDBSystemTempTable(pool, tableSql);
                }
                catch (Exception ex) {
                    logger.error((Object)"createTmpTable error", (Throwable)ex);
                }
            }
        };
        runnable = (TxRunnable)TransactionCtrlFacadeFactory.getLocalInstance(ctx).runByRequiresNewTx(runnable);
        manager.tmpTable = runnable.getReturn();
        return manager;
    }

    public static void releaseDBTmpTable(Context ctx, final TempTablePool pool, final DBTmpTableManager manager) throws Exception {
        if (ctx == null || pool == null || manager == null) {
            return;
        }
        TxRunnable runnable = new TxRunnable(){

            @Override
            public void run() {
                try {
                    manager.releaseDBSystemTempTable(pool);
                }
                catch (Exception ex) {
                    logger.error((Object)"createTmpTable error", (Throwable)ex);
                }
            }
        };
        runnable = (TxRunnable)TransactionCtrlFacadeFactory.getLocalInstance(ctx).runByRequiresNewTx(runnable);
        manager.release();
    }

    public static String createIndex(TempTablePool pool, String tableName, String columns, boolean isUnique, boolean isClustered) throws Exception {
        return pool.createIndex(tableName, columns, isUnique, isClustered);
    }

    public static void releaseTmpTable(TempTablePool pool, String tableName) {
        if (pool == null || tableName == null) {
            return;
        }
        pool.releaseTable(tableName);
    }

    public static void releaseTmpTable(TempTablePool pool, List<String> tableName) {
        if (pool == null || tableName == null) {
            return;
        }
        int in = tableName.size();
        for (int i = 0; i < in; ++i) {
            pool.releaseTable(tableName.get(i));
        }
    }

    public static void releaseTmpTable(TempTablePool pool, Collection<String> tableName) {
        if (pool == null || tableName == null) {
            return;
        }
        for (String tmpTableName : tableName) {
            pool.releaseTable(tmpTableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int insertValue1(Connection conn, String sql, List<Object[]> sqlParams) throws SQLException {
        long st = System.currentTimeMillis();
        if (conn == null || StringUtils.isEmpty((String)sql) || sqlParams == null || sqlParams.isEmpty()) {
            return CANCEL;
        }
        int batchSize = 50;
        int batchIndex = 0;
        PreparedStatement pstmt = null;
        try {
            pstmt = conn.prepareStatement(sql);
            for (Object[] sqlData : sqlParams) {
                int in = sqlData.length;
                for (int i = 0; i < in; ++i) {
                    pstmt.setObject(i + 1, sqlData[i]);
                }
                pstmt.addBatch();
                if (++batchIndex < batchSize) continue;
                pstmt.executeBatch();
                batchIndex = 0;
            }
            if (batchIndex > 0) {
                pstmt.executeBatch();
            }
        }
        finally {
            SQLUtils.cleanup((Statement)pstmt);
        }
        logger.error((Object)("insertValue1 (" + sqlParams.size() + ") " + (System.currentTimeMillis() - st) + " ms"));
        return YES;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int insertValue(Connection conn, String sql, List<List<Object>> sqlParams) throws SQLException {
        if (conn == null || StringUtils.isEmpty((String)sql) || sqlParams == null || sqlParams.isEmpty()) {
            return CANCEL;
        }
        long st = System.currentTimeMillis();
        int batchSize = 50;
        int batchIndex = 0;
        PreparedStatement pstmt = null;
        try {
            pstmt = conn.prepareStatement(sql);
            for (List<Object> sqlData : sqlParams) {
                int in = sqlData.size();
                for (int i = 0; i < in; ++i) {
                    pstmt.setObject(i + 1, sqlData.get(i));
                }
                pstmt.addBatch();
                if (++batchIndex < batchSize) continue;
                pstmt.executeBatch();
                batchIndex = 0;
            }
            if (batchIndex > 0) {
                pstmt.executeBatch();
            }
        }
        finally {
            SQLUtils.cleanup((Statement)pstmt);
        }
        logger.error((Object)("insertValue (" + sqlParams.size() + ") " + (System.currentTimeMillis() - st) + " ms"));
        return YES;
    }

    public static String insertKey(TempTablePool pool, Connection conn, Collection<String> keys) throws BOSException {
        return BgDBUtils.insertKey(pool, conn, keys, "Varchar(44)");
    }

    public static String insertKey(TempTablePool pool, Connection conn, Collection<String> keys, String dataType) throws BOSException {
        String tempIds;
        try {
            tempIds = pool.createTempTable("Create Table T_MBG_TMPIDS(FID " + dataType + " NOT NULL)");
            BgDBUtils.insertKey(conn, "Insert Into " + tempIds + "(FID) Values(?)", keys);
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return tempIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int insertKey(Connection conn, String sql, Collection<String> sqlParams) throws SQLException {
        if (conn == null || StringUtils.isEmpty((String)sql) || sqlParams == null || sqlParams.isEmpty()) {
            return CANCEL;
        }
        long st = System.currentTimeMillis();
        int batchSize = 100;
        int batchIndex = 0;
        PreparedStatement pstmt = null;
        try {
            pstmt = conn.prepareStatement(sql);
            for (String sqlData : sqlParams) {
                pstmt.setString(1, sqlData);
                pstmt.addBatch();
                if (++batchIndex < batchSize) continue;
                pstmt.executeBatch();
                batchIndex = 0;
            }
            if (batchIndex > 0) {
                pstmt.executeBatch();
            }
        }
        finally {
            SQLUtils.cleanup((Statement)pstmt);
        }
        logger.error((Object)("insertKey (" + sqlParams.size() + ") " + (System.currentTimeMillis() - st) + " ms"));
        return YES;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int insertKey1(Connection conn, String sql, Collection<Object> sqlParams) throws SQLException {
        if (conn == null || StringUtils.isEmpty((String)sql) || sqlParams == null || sqlParams.isEmpty()) {
            return CANCEL;
        }
        long st = System.currentTimeMillis();
        int batchSize = 100;
        int batchIndex = 0;
        PreparedStatement pstmt = null;
        try {
            pstmt = conn.prepareStatement(sql);
            for (Object sqlData : sqlParams) {
                pstmt.setObject(1, sqlData);
                pstmt.addBatch();
                if (++batchIndex < batchSize) continue;
                pstmt.executeBatch();
                batchIndex = 0;
            }
            if (batchIndex > 0) {
                pstmt.executeBatch();
            }
        }
        finally {
            SQLUtils.cleanup((Statement)pstmt);
        }
        logger.error((Object)("insertKey1 (" + sqlParams.size() + ") " + (System.currentTimeMillis() - st) + " ms"));
        return YES;
    }

    public static void regorgTable(Connection conn, String cubeName) throws SQLException {
        if (BgDBUtils.isDB2(conn)) {
            String userName = conn.getMetaData().getUserName();
            CallableStatement c = conn.prepareCall("{CALL SYSPROC.ADMIN_CMD('reorg  table " + userName + "." + cubeName + "')}");
            c.execute();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getBytes(ResultSet rst, String key) throws SQLException, IOException {
        if (rst == null || StringUtils.isEmpty((String)key)) {
            return null;
        }
        InputStream in = null;
        in = rst.getObject(key) instanceof Blob ? ((Blob)rst.getObject(key)).getBinaryStream() : rst.getBinaryStream(key);
        if (in == null) {
            return null;
        }
        int len = -1;
        int blockSize = 1024;
        byte[] block = new byte[1024];
        byte[] bytes = null;
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        try {
            do {
                if ((len = in.read(block)) <= 0) continue;
                byteOut.write(block, 0, len);
            } while (len == 1024);
            bytes = byteOut.toByteArray();
        }
        finally {
            in.close();
            byteOut.close();
        }
        return bytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getBytes(ResultSet rst, int index) throws SQLException, IOException {
        if (rst == null) {
            return null;
        }
        InputStream in = null;
        in = rst.getObject(index) instanceof Blob ? ((Blob)rst.getObject(index)).getBinaryStream() : rst.getBinaryStream(index);
        if (in == null) {
            return null;
        }
        int len = -1;
        int blockSize = 1024;
        byte[] block = new byte[1024];
        byte[] bytes = null;
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        try {
            do {
                if ((len = in.read(block)) <= 0) continue;
                byteOut.write(block, 0, len);
            } while (len == 1024);
            bytes = byteOut.toByteArray();
        }
        finally {
            in.close();
            byteOut.close();
        }
        return bytes;
    }

    public static void setBytes(PreparedStatement stat, int index, byte[] bytes) throws SQLException {
        if (stat == null) {
            return;
        }
        if (bytes != null && bytes.length > 0) {
            stat.setBinaryStream(index, (InputStream)new ByteArrayInputStream(bytes), bytes.length);
        } else {
            stat.setBytes(index, null);
        }
    }

    public static String getSqlParam() {
        return BgDBUtils.getSqlParam(50);
    }

    public static String getSqlParam(int paramSize) {
        StringBuffer params = new StringBuffer();
        int in = paramSize;
        for (int i = 1; i < in; ++i) {
            params.append("?,");
        }
        params.append("?");
        return params.toString();
    }

    public static String getSqlParam(int[] sqlParams) {
        if (sqlParams == null || sqlParams.length == 0) {
            return "(-1)";
        }
        String _state = "(" + String.valueOf(sqlParams[0]);
        for (int i = 1; i < sqlParams.length; ++i) {
            _state = _state + "," + sqlParams[i];
        }
        _state = _state + ")";
        return _state;
    }

    public static String getLongNumSqlParam(int paramSize, boolean isIncludeSelf) {
        StringBuffer params = new StringBuffer();
        if (isIncludeSelf) {
            params.append("(");
            int in = paramSize;
            for (int i = 1; i < in; ++i) {
                params.append("(FLongNumber = ? OR FLongNumber like ?) OR ");
            }
            params.append("(FLongNumber = ? OR FLongNumber like ?))");
        } else {
            params.append("(");
            int in = paramSize;
            for (int i = 1; i < in; ++i) {
                params.append("FLongNumber like ? OR ");
            }
            params.append("FLongNumber like ?)");
        }
        return params.toString();
    }

    public static String getOrgRangeTable(Context ctx) throws BOSException {
        return BgCommNHelper.getOrgRangeTable(ctx);
    }

    static abstract class TxRunnable
    implements Runnable {
        protected String result;
        protected BOSException excp;

        TxRunnable() {
        }

        public String getReturn() throws BOSException {
            if (this.excp != null) {
                throw this.excp;
            }
            return this.result;
        }
    }
}

