/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.base.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.ma.base.BgScenarioInfo;
import com.kingdee.eas.ma.base.BgVersionInfo;
import com.kingdee.eas.ma.base.utils.BgCurrencyHelper;
import com.kingdee.eas.ma.base.utils.BgElementHelper;
import com.kingdee.eas.ma.base.utils.BgScenarioHelper;
import com.kingdee.eas.ma.base.utils.BgVersionHelper;
import com.kingdee.eas.ma.base.utils.BudgetCache;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BgDimCacheUtils
extends BudgetCache {
    public static String BUDGET_DIM_CACHE_NAME = "BudgetDimDataCache";
    public static final String BUDGET_DIM_ITEM_CACHE_NAME = "BudgetDimDataCache-ItemNumber";
    public static final String BUDGET_DIM_ELEMENT_CACHE = "BudgetDimDataCache-Element";
    public static final String BUDGET_DIM_CURRENCY_CACHE = "BudgetDimDataCache-Currency";
    public static final String BUDGET_DIM_SCENARIO_CACHE = "BudgetDimDataCache-Scenario";
    public static final String BUDGET_DIM_VERSION_CACHE = "BudgetDimDataCache-Version";
    public static final String BUDGET_CONTROL_PERIOD_CACHE = "BudgetControlDataCache-Period";
    public static final String BUDGET_ANALYSE_CACHE = "MbgAanalyseCacheData-";
    public static final String BUDGET_PROPERTIES_ANALYSE_CACHE = "MbgPropertiesAnalyseCache-";
    public static final String BUDGET_MBG_PARAM_CACHE = "BUDGET_MBG_PARAM_CACHE";
    public static final int INDEX_NUMBER = 0;
    public static final int INDEX_LONGNUMBER = 1;
    public static final int INDEX_NAME = 2;
    public static final int INDEX_ID = 3;
    public static final int INDEX_ORG_NAME = 4;
    public static final int INDEX_OTHER = 5;

    public static void destroyObject(Context ctx, String dimKey) {
        if (ctx == null) {
            return;
        }
        String ais = ctx.getAIS();
        String cachekey = ais + dimKey;
        BudgetCache.getInstance().destroyObject(cachekey);
    }

    public static void putObject(Context ctx, String dimKey, Object objs) {
        if (ctx == null) {
            return;
        }
        BudgetCache.getInstance().putObject(ctx.getAIS() + dimKey, objs);
    }

    public static Object getObject(Context ctx, String dimKey) {
        if (ctx == null) {
            return null;
        }
        return BudgetCache.getInstance().getObject(ctx.getAIS() + dimKey);
    }

    public static void putItemLongNumber(Context ctx, String dimKey, Object itemNumberMap) {
        BgDimCacheUtils.putObject(ctx, dimKey, itemNumberMap);
    }

    public static Object getItemLongNumber(Context ctx, String dimKey) {
        if (ctx != null) {
            return BgDimCacheUtils.getObject(ctx, dimKey);
        }
        return null;
    }

    public static void saveObject(Context ctx, String dimKey, Map<String, IObjectValue> valueMap) {
        if (ctx == null) {
            return;
        }
        String cachekey = ctx.getAIS() + dimKey;
        BudgetCache.getInstance().putObject(cachekey, valueMap);
    }

    public static Map<String, IObjectValue> loadObject(Context ctx, String dimKey) {
        if (ctx == null) {
            return null;
        }
        String cachekey = ctx.getAIS() + dimKey;
        Map valueMap = (Map)BudgetCache.getInstance().getObject(cachekey);
        return valueMap;
    }

    public static Map<String, IObjectValue> getElementCache(Context ctx) throws BOSException {
        Map<String, Object> elementMap = new HashMap<String, IObjectValue>();
        if (null == ctx) {
            return elementMap;
        }
        elementMap = BgDimCacheUtils.loadObject(ctx, BUDGET_DIM_ELEMENT_CACHE);
        if (null == elementMap) {
            elementMap = new HashMap();
            elementMap.putAll(BgElementHelper.getElementoObjMap(ctx));
            BgDimCacheUtils.saveObject(ctx, BUDGET_DIM_ELEMENT_CACHE, elementMap);
        }
        return elementMap;
    }

    public static Map<String, IObjectValue> getCurrencyCache(Context ctx) throws BOSException {
        Map<String, Object> currencyMap = new HashMap<String, IObjectValue>();
        if (null == ctx) {
            return currencyMap;
        }
        currencyMap = BgDimCacheUtils.loadObject(ctx, BUDGET_DIM_CURRENCY_CACHE);
        if (null == currencyMap) {
            currencyMap = new HashMap();
            currencyMap.putAll(BgCurrencyHelper.getCurrencyObjMap(ctx));
            BgDimCacheUtils.saveObject(ctx, BUDGET_DIM_CURRENCY_CACHE, currencyMap);
        }
        return currencyMap;
    }

    public static Map<String, IObjectValue> getScenarioCache(Context ctx) throws BOSException {
        Map<String, Object> scenarioMap = new HashMap<String, IObjectValue>();
        if (ctx == null) {
            return scenarioMap;
        }
        scenarioMap = BgDimCacheUtils.loadObject(ctx, BUDGET_DIM_SCENARIO_CACHE);
        if (scenarioMap == null) {
            scenarioMap = new HashMap();
            List<BgScenarioInfo> scenarios = BgScenarioHelper.getAllScenario(ctx);
            for (BgScenarioInfo scenario : scenarios) {
                scenarioMap.put(scenario.getNumber(), (IObjectValue)scenario);
            }
            BgDimCacheUtils.saveObject(ctx, BUDGET_DIM_SCENARIO_CACHE, scenarioMap);
        }
        return scenarioMap;
    }

    public static Map<String, IObjectValue> getVersionCache(Context ctx) throws BOSException {
        Map<String, Object> versionMap = new HashMap<String, IObjectValue>();
        if (ctx == null) {
            return versionMap;
        }
        versionMap = BgDimCacheUtils.loadObject(ctx, BUDGET_DIM_VERSION_CACHE);
        if (versionMap == null) {
            versionMap = new HashMap();
            List<BgVersionInfo> versions = BgVersionHelper.getAllVersion(ctx);
            for (BgVersionInfo version : versions) {
                versionMap.put(version.getNumber(), (IObjectValue)version);
            }
            BgDimCacheUtils.saveObject(ctx, BUDGET_DIM_VERSION_CACHE, versionMap);
        }
        return versionMap;
    }

    public static void clearElementCache(Context ctx) {
        BgDimCacheUtils.destroyObject(ctx, BUDGET_DIM_ELEMENT_CACHE);
    }

    public static void clearDimMemberCache(Context ctx) {
        BgDimCacheUtils.destroyObject(ctx, BUDGET_DIM_ITEM_CACHE_NAME);
    }

    public static void clearBgScenarioCache(Context ctx) {
        BgDimCacheUtils.destroyObject(ctx, BUDGET_DIM_SCENARIO_CACHE);
    }

    public static void clearBgVersionCache(Context ctx) {
        BgDimCacheUtils.destroyObject(ctx, BUDGET_DIM_VERSION_CACHE);
    }

    public static void clearBgCurrencyCache(Context ctx) {
        BgDimCacheUtils.destroyObject(ctx, BUDGET_DIM_CURRENCY_CACHE);
    }
}

