/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.base.utils;

import com.kingdee.eas.ma.base.BgPeriodDispCollection;
import com.kingdee.eas.ma.base.BgPeriodDispInfo;
import com.kingdee.eas.ma.base.BgPeriodEnum;
import com.kingdee.eas.ma.base.BgPeriodInfo;
import com.kingdee.eas.ma.base.BgPeriodTypeInfo;
import com.kingdee.eas.ma.base.FiscalYearEnum;
import com.kingdee.eas.ma.base.utils.CalendarHelper;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public final class BgNPeriodHelper {
    public static final String MATCH_STR = "\\-?\\d+";
    public static final String CONVERT_TYPE_ALL = "ALL";
    public static final String CONVERT_TYPE_PART = "PART";

    public Timestamp getDayMaxTimeStampB(Timestamp time) throws ParseException {
        if (time != null) {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            Date parse = format.parse(time.toString());
            long maxTimeStamp = parse.getTime() + 86400000L - 1L;
            return new Timestamp(maxTimeStamp);
        }
        return null;
    }

    public Timestamp getDayMinTimeStampB(Timestamp time) throws ParseException {
        if (time != null) {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            Date parse = format.parse(time.toString());
            return new Timestamp(parse.getTime());
        }
        return null;
    }

    public static boolean isAcrossYearsPeriod(BgPeriodTypeInfo typeInfo) {
        return FiscalYearEnum.STRIDEYEAR.equals((Object)typeInfo.getFiscalYear());
    }

    public static Object[] checkPeriodType(BgPeriodDispCollection col) {
        BgPeriodTypeInfo type;
        String number2;
        HashSet<String> fiscalYears = new HashSet<String>();
        HashSet<String> noFiscalYears = new HashSet<String>();
        HashSet<String> fiscalTypes = new HashSet<String>();
        HashSet<String> noFiscalTypes = new HashSet<String>();
        HashSet<String> allTypes = new HashSet<String>();
        HashMap leafMap = new HashMap();
        for (int i = 0; i < col.size(); ++i) {
            number2 = col.get(i).getNumber();
            type = col.get(i).getType();
            if (!col.get(i).isIsLeaf()) {
                if (!FiscalYearEnum.STANDARDYEAR.equals((Object)type.getFiscalYear())) {
                    fiscalTypes.add(type.getNumber());
                } else {
                    noFiscalTypes.add(type.getNumber());
                }
                allTypes.add(type.getNumber());
                continue;
            }
            if (!leafMap.containsKey(number2)) {
                leafMap.put(number2, new HashMap());
            }
            ((Map)leafMap.get(number2)).put(type.getNumber(), col.get(i));
        }
        BgPeriodDispCollection backup = col;
        col = new BgPeriodDispCollection();
        col.addCollection(backup);
        HashSet typeSet = new HashSet();
        for (String number2 : leafMap.keySet()) {
            typeSet.clear();
            typeSet.addAll(((Map)leafMap.get(number2)).keySet());
            typeSet.retainAll(allTypes);
            for (BgPeriodDispInfo info : ((Map)leafMap.get(number2)).values()) {
                if (((Map)leafMap.get(number2)).size() == 1) continue;
                if (typeSet.isEmpty()) {
                    if (FiscalYearEnum.STANDARDYEAR.equals((Object)info.getType().getFiscalYear())) continue;
                    col.remove(info);
                    continue;
                }
                if (allTypes.contains(info.getType().getNumber())) continue;
                col.remove(info);
            }
        }
        HashMap<String, String> periodTypeNumber = new HashMap<String, String>();
        HashSet<String> bothTypes = new HashSet<String>();
        HashSet<String> bothNumbers = new HashSet<String>(fiscalYears);
        boolean isMatch = false;
        for (int i = 0; i < col.size(); ++i) {
            number2 = col.get(i).getNumber();
            type = col.get(i).getType();
            if (col.get(i).isIsLeaf()) {
                isMatch = false;
                if (fiscalTypes.contains(type.getNumber())) {
                    isMatch = true;
                } else if (noFiscalTypes.contains(type.getNumber())) {
                    isMatch = true;
                } else if (FiscalYearEnum.STANDARDYEAR.equals((Object)type.getFiscalYear())) {
                    isMatch = true;
                } else if (((Map)leafMap.get(number2)).size() == 1) {
                    isMatch = true;
                }
                if (isMatch) {
                    if (periodTypeNumber.containsKey(number2)) {
                        bothTypes.add(type.getNumber());
                        bothTypes.add((String)periodTypeNumber.get(number2));
                        bothNumbers.add(number2);
                    } else {
                        periodTypeNumber.put(number2, type.getNumber());
                    }
                }
            }
            if (!isMatch && col.get(i).isIsLeaf()) continue;
            if (FiscalYearEnum.STANDARDYEAR.equals((Object)type.getFiscalYear())) {
                noFiscalYears.add(number2);
                noFiscalTypes.add(type.getNumber());
                continue;
            }
            fiscalYears.add(number2);
            fiscalTypes.add(type.getNumber());
        }
        fiscalYears.removeAll(bothNumbers);
        noFiscalYears.removeAll(bothNumbers);
        noFiscalTypes.addAll(fiscalTypes);
        noFiscalTypes.removeAll(bothTypes);
        Object[] result = new Object[]{!bothNumbers.isEmpty(), !fiscalYears.isEmpty(), bothNumbers, noFiscalTypes};
        return result;
    }

    public static boolean isOnlySelfDefinedPeriod(BgPeriodTypeInfo typeInfo) {
        boolean isYear = typeInfo.isYear();
        boolean isHalfYear = typeInfo.isHalfYear();
        boolean isQuarter = typeInfo.isQuarter();
        boolean isMonth = typeInfo.isMonth();
        boolean isDay = typeInfo.isDay();
        boolean isMothWeek = typeInfo.isMothWeek();
        boolean isYearWeek = typeInfo.isYearWeek();
        boolean isTenday = typeInfo.isTenday();
        boolean isSelfDefined = typeInfo.isSelfDefined();
        return isSelfDefined && !isYear && !isHalfYear && !isQuarter && !isMonth && !isDay && !isMothWeek && !isYearWeek && !isTenday;
    }

    public static BgPeriodEnum getPeriodEnumByBgPeriodType(BgPeriodTypeInfo typeInfo) {
        boolean isYear = typeInfo.isYear();
        boolean isHalfYear = typeInfo.isHalfYear();
        boolean isQuarter = typeInfo.isQuarter();
        boolean isMonth = typeInfo.isMonth();
        boolean isDay = typeInfo.isDay();
        boolean isMothWeek = typeInfo.isMothWeek();
        boolean isYearWeek = typeInfo.isYearWeek();
        boolean isTenday = typeInfo.isTenday();
        boolean isSelfDefined = typeInfo.isSelfDefined();
        if (isTenday) {
            return BgPeriodEnum.TENDAYS;
        }
        if (isYearWeek) {
            return BgPeriodEnum.YWEEK;
        }
        if (isMothWeek) {
            return BgPeriodEnum.MWEEK;
        }
        if (isDay) {
            return BgPeriodEnum.DAY;
        }
        if (isMonth) {
            return BgPeriodEnum.MONTH;
        }
        if (isQuarter) {
            return BgPeriodEnum.QUARTER;
        }
        if (isHalfYear) {
            return BgPeriodEnum.HALFYEAR;
        }
        return BgPeriodEnum.YEAR;
    }

    public static boolean compareBgPeriodBegin2End(BgPeriodInfo beginBgPeriod, BgPeriodInfo endBgPeriod) {
        return BgNPeriodHelper.compareBgPeriod(beginBgPeriod, endBgPeriod) >= 0;
    }

    public static int compareBgPeriod(BgPeriodInfo beginBgPeriod, BgPeriodInfo endBgPeriod) {
        if (beginBgPeriod == null) {
            // empty if block
        }
        return endBgPeriod.getNumber().compareTo(beginBgPeriod.getNumber());
    }

    public static String getPeriodNum(Date date, BgPeriodEnum periodType) {
        String periodNum = "";
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        if (periodType.getValue() == 1) {
            periodNum = BgNPeriodHelper.createNewYearBgPeriodNumber(calendar.get(1), 0, false);
        } else if (periodType.getValue() == 2) {
            periodNum = BgNPeriodHelper.createNewHalfYearBgPeriodNumber(calendar.get(1), calendar.get(2) + 1 < 7 ? 1 : 2, 0, false);
        } else if (periodType.getValue() == 3) {
            int month = calendar.get(2) + 1;
            int quarter = 1;
            if (month <= 3) {
                quarter = 1;
            } else if (month <= 6) {
                quarter = 2;
            } else if (month <= 9) {
                quarter = 3;
            } else if (month <= 12) {
                quarter = 4;
            }
            periodNum = BgNPeriodHelper.createNewQuarterBgPeriodNumber(calendar.get(1), quarter, 0, false);
        } else if (periodType.getValue() == 4) {
            periodNum = BgNPeriodHelper.createNewMonthBgPeriodNumber(calendar.get(1), calendar.get(2) + 1, 0, false);
        } else if (periodType.getValue() == 9) {
            int day = calendar.get(5);
            int tendays = 0;
            tendays = day <= 10 ? 0 : (day <= 20 ? 1 : 2);
            periodNum = BgNPeriodHelper.createNewTenDaysBgPeriodNumber(calendar.get(1), calendar.get(2) + 1, tendays, 0, false);
        }
        return periodNum;
    }

    public static Date getPeriodDate(String bgPeriodNumber) {
        if (StringUtils.isEmpty((String)bgPeriodNumber)) {
            return null;
        }
        String[] parameter = bgPeriodNumber.split("\\.");
        if (parameter != null) {
            Date date = null;
            CalendarHelper helper = new CalendarHelper();
            if (parameter.length == 1) {
                if (Pattern.matches("[\\d]{4}Y", bgPeriodNumber)) {
                    int year = new Integer(parameter[0].substring(0, 4));
                    date = helper.getFirstDayOfYear(year);
                }
            } else if (parameter.length == 2) {
                if (Pattern.matches("[\\d]{4}Y.[\\d]{2}HY", bgPeriodNumber)) {
                    int year = new Integer(parameter[0].substring(0, 4));
                    int halfYear = new Integer(parameter[1].substring(0, 2));
                    date = helper.getFirstDayOfHalfYear(year, halfYear);
                } else if (Pattern.matches("[\\d]{4}Y.[\\d]{2}Q", bgPeriodNumber)) {
                    int year = new Integer(parameter[0].substring(0, 4));
                    int quarter = new Integer(parameter[1].substring(0, 2));
                    date = helper.getFirstDayOfQuarter(year, quarter);
                } else if (Pattern.matches("[\\d]{4}Y.[\\d]{2}M", bgPeriodNumber)) {
                    int year = new Integer(parameter[0].substring(0, 4));
                    int month = new Integer(parameter[1].substring(0, 2));
                    date = helper.getFirstDayOfMonth(year, month);
                } else if (Pattern.matches("[\\d]{4}Y.[\\d]{2}W", bgPeriodNumber)) {
                    int year = new Integer(parameter[0].substring(0, 4));
                    int week = new Integer(parameter[1].substring(0, 2));
                    date = helper.getFirstDayOfWeek(year, week);
                }
            } else if (parameter.length == 3) {
                if (Pattern.matches("[\\d]{4}Y.[\\d]{2}M.[\\d]{2}D", bgPeriodNumber)) {
                    int year = new Integer(parameter[0].substring(0, 4));
                    int month = new Integer(parameter[1].substring(0, 2));
                    int day = new Integer(parameter[2].substring(0, 2));
                    date = helper.setDay(year, month, day);
                } else if (Pattern.matches("[\\d]{4}Y.[\\d]{2}M.[\\d]{2}TD", bgPeriodNumber)) {
                    int year = new Integer(parameter[0].substring(0, 4));
                    int month = new Integer(parameter[1].substring(0, 2));
                    int tenDays = new Integer(parameter[2].substring(0, 2));
                    date = helper.getFirstDayOfMonthTenDays(year, month, tenDays);
                } else if (Pattern.matches("[\\d]{4}Y.[\\d]{2}M.[\\d]{2}MW", bgPeriodNumber)) {
                    int year = new Integer(parameter[0].substring(0, 4));
                    int month = new Integer(parameter[1].substring(0, 2));
                    int week = new Integer(parameter[1].substring(0, 2));
                    date = helper.getFirstDayOfWeek(year, month, week);
                }
            }
            return date;
        }
        return null;
    }

    public static String getParnetPeriodNumber(String bgPeriodNumber) {
        if (StringUtils.isEmpty((String)bgPeriodNumber)) {
            return null;
        }
        String pPeriodNumber = null;
        int periodType = BgNPeriodHelper.parserBgPeriodType(bgPeriodNumber);
        Date date = BgNPeriodHelper.getPeriodDate(bgPeriodNumber);
        if (date == null || periodType == -1) {
            return null;
        }
        switch (periodType) {
            case 1: {
                break;
            }
            case 2: {
                pPeriodNumber = BgNPeriodHelper.getPeriodNum(date, BgPeriodEnum.YEAR);
                break;
            }
            case 3: {
                pPeriodNumber = BgNPeriodHelper.getPeriodNum(date, BgPeriodEnum.HALFYEAR);
                break;
            }
            case 4: {
                pPeriodNumber = BgNPeriodHelper.getPeriodNum(date, BgPeriodEnum.QUARTER);
                break;
            }
            case 5: {
                pPeriodNumber = BgNPeriodHelper.getPeriodNum(date, BgPeriodEnum.YEAR);
                break;
            }
            case 6: {
                pPeriodNumber = BgNPeriodHelper.getPeriodNum(date, BgPeriodEnum.MONTH);
                break;
            }
            case 9: {
                pPeriodNumber = BgNPeriodHelper.getPeriodNum(date, BgPeriodEnum.MONTH);
                break;
            }
            case 7: {
                pPeriodNumber = BgNPeriodHelper.getPeriodNum(date, BgPeriodEnum.MONTH);
                break;
            }
        }
        return pPeriodNumber;
    }

    public static String getOffsetBgPeriodNumberNoSign(String bgPeriodNumber, int offset) {
        if (StringUtils.isEmpty((String)bgPeriodNumber)) {
            return BgNPeriodHelper.getCcbgPeriodNumber();
        }
        String _bgPeriodNumber = bgPeriodNumber;
        String _prefix = null;
        if (Character.isLetter(_bgPeriodNumber.charAt(0))) {
            int index = _bgPeriodNumber.indexOf(".") + 1;
            _prefix = bgPeriodNumber.substring(0, index);
            _bgPeriodNumber = _bgPeriodNumber.substring(index);
            _bgPeriodNumber = _prefix + BgNPeriodHelper.getOffsetBgPeriodNumber(_bgPeriodNumber, offset);
        } else {
            _bgPeriodNumber = BgNPeriodHelper.getOffsetBgPeriodNumber(_bgPeriodNumber, offset);
        }
        return _bgPeriodNumber;
    }

    public static String getOffsetBgPeriodNumber(String ccbgPeriodNumber, int offset) {
        if (StringUtils.isEmpty((String)ccbgPeriodNumber)) {
            return BgNPeriodHelper.getCcbgPeriodNumber();
        }
        if (offset == 0) {
            return ccbgPeriodNumber;
        }
        offset = offset < -100 ? -100 : offset;
        offset = offset > 100 ? 100 : offset;
        String _offsetBgPeriodNumber = ccbgPeriodNumber;
        String[] parameter = null;
        parameter = ccbgPeriodNumber.split("\\.");
        if (parameter != null) {
            switch (parameter.length) {
                case 1: {
                    _offsetBgPeriodNumber = BgNPeriodHelper.checkOneLevelNumber(parameter, offset, false);
                    break;
                }
                case 2: {
                    _offsetBgPeriodNumber = BgNPeriodHelper.checkTwoLevelNumber(parameter, offset, false);
                    break;
                }
                case 3: {
                    _offsetBgPeriodNumber = BgNPeriodHelper.checkThreeLevelNumber(parameter, offset, false);
                    break;
                }
                case 4: {
                    _offsetBgPeriodNumber = BgNPeriodHelper.checkFourLevelNumber(parameter, offset, false);
                    break;
                }
            }
        }
        return _offsetBgPeriodNumber;
    }

    public static String getOffsetBgPeriodNumberForExpression(String ccbgPeriodNumber, int offset) {
        if (StringUtils.isEmpty((String)ccbgPeriodNumber)) {
            return BgNPeriodHelper.getCcbgPeriodNumber();
        }
        if (offset == 0) {
            return ccbgPeriodNumber;
        }
        if (offset < 0) {
            return BgNPeriodHelper.getOffsetBgPeriodNumber(ccbgPeriodNumber, offset);
        }
        String _offsetBgPeriodNumber = ccbgPeriodNumber;
        String[] parameter = null;
        parameter = ccbgPeriodNumber.split("\\.");
        if (parameter != null) {
            switch (parameter.length) {
                case 1: {
                    _offsetBgPeriodNumber = BgNPeriodHelper.checkOneLevelNumber(parameter, offset, true);
                    break;
                }
                case 2: {
                    _offsetBgPeriodNumber = BgNPeriodHelper.checkTwoLevelNumber(parameter, offset, true);
                    break;
                }
                case 3: {
                    _offsetBgPeriodNumber = BgNPeriodHelper.checkThreeLevelNumber(parameter, offset, true);
                    break;
                }
            }
        }
        return _offsetBgPeriodNumber;
    }

    private static String getCcbgPeriodNumber() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        return String.valueOf(calendar.get(1)) + "Y";
    }

    private static String checkOneLevelNumber(String[] parameter, int offset, boolean isExpression) {
        String _oneNumber = parameter[0];
        String _code = "";
        if (_oneNumber.length() >= 5) {
            _code = _oneNumber.substring(4);
        }
        String _bgPeriodNumber = _oneNumber;
        if ("Y".equals(_code) && Pattern.matches("[\\d]{4}Y", _bgPeriodNumber)) {
            int year = new Integer(_oneNumber.substring(0, 4));
            _bgPeriodNumber = BgNPeriodHelper.createNewYearBgPeriodNumber(year, offset, isExpression);
        }
        return _bgPeriodNumber;
    }

    private static String checkTwoLevelNumber(String[] parameter, int offset, boolean isExpression) {
        String _oneNumber = parameter[0];
        String _twoNumber = parameter[1];
        String _code = "";
        if (_twoNumber.length() >= 3) {
            _code = _twoNumber.substring(2);
        }
        String _bgPeriodNumber = _oneNumber + "." + _twoNumber;
        if ("HY".equals(_code)) {
            if (Pattern.matches("[\\d]{4}Y.[\\d]{2}HY", _bgPeriodNumber)) {
                int year = new Integer(_oneNumber.substring(0, 4));
                int halfYear = new Integer(_twoNumber.substring(0, 2));
                _bgPeriodNumber = BgNPeriodHelper.createNewHalfYearBgPeriodNumber(year, halfYear, offset, isExpression);
            }
        } else if ("Q".equals(_code)) {
            if (Pattern.matches("[\\d]{4}Y.[\\d]{2}Q", _bgPeriodNumber)) {
                int year = new Integer(_oneNumber.substring(0, 4));
                int quarter = new Integer(_twoNumber.substring(0, 2));
                _bgPeriodNumber = BgNPeriodHelper.createNewQuarterBgPeriodNumber(year, quarter, offset, isExpression);
            }
        } else if ("M".equals(_code)) {
            if (Pattern.matches("[\\d]{4}Y.[\\d]{2}M", _bgPeriodNumber)) {
                int year = new Integer(_oneNumber.substring(0, 4));
                int month = new Integer(_twoNumber.substring(0, 2));
                _bgPeriodNumber = BgNPeriodHelper.createNewMonthBgPeriodNumber(year, month, offset, isExpression);
            }
        } else if ("W".equals(_code) && Pattern.matches("[\\d]{4}Y.[\\d]{2}W", _bgPeriodNumber)) {
            int year = new Integer(_oneNumber.substring(0, 4));
            int week = new Integer(_twoNumber.substring(0, 2));
            _bgPeriodNumber = BgNPeriodHelper.createNewYearWeekBgPeriodNumber(year, week, offset, isExpression);
        }
        return _bgPeriodNumber;
    }

    private static String checkThreeLevelNumber(String[] parameter, int offset, boolean isExpression) {
        String _oneNumber = parameter[0];
        String _twoNumber = parameter[1];
        String _threeNumber = parameter[2];
        String _code = "";
        if (_threeNumber.length() >= 3) {
            _code = _threeNumber.substring(2);
        }
        String _bgPeriodNumber = _oneNumber + "." + _twoNumber + "." + _threeNumber;
        if ("M".equals(_code)) {
            if (Pattern.matches("[\\w]{4}.[\\d]{4}Y.[\\d]{2}M", _bgPeriodNumber)) {
                int year = new Integer(_twoNumber.substring(0, 4));
                int month = new Integer(_threeNumber.substring(0, 2));
                _bgPeriodNumber = _oneNumber + "." + BgNPeriodHelper.createNewMonthBgPeriodNumber(year, month, offset, isExpression);
            }
        } else if ("Q".equals(_code)) {
            if (Pattern.matches("[\\w]{4}.[\\d]{4}Y.[\\d]{2}Q", _bgPeriodNumber)) {
                int year = new Integer(_twoNumber.substring(0, 4));
                int quarter = new Integer(_threeNumber.substring(0, 2));
                _bgPeriodNumber = _oneNumber + "." + BgNPeriodHelper.createNewQuarterBgPeriodNumber(year, quarter, offset, isExpression);
            }
        } else if ("HY".equals(_code)) {
            if (Pattern.matches("[\\w]{4}.[\\d]{4}Y.[\\d]{2}HY", _bgPeriodNumber)) {
                int year = new Integer(_twoNumber.substring(0, 4));
                int halfYear = new Integer(_threeNumber.substring(0, 2));
                _bgPeriodNumber = _oneNumber + "." + BgNPeriodHelper.createNewHalfYearBgPeriodNumber(year, halfYear, offset, isExpression);
            }
        } else if ("MW".equals(_code)) {
            if (Pattern.matches("[\\d]{4}Y.[\\d]{2}M.[\\d]{2}MW", _bgPeriodNumber)) {
                int year = new Integer(_oneNumber.substring(0, 4));
                int month = new Integer(_twoNumber.substring(0, 2));
                int week = new Integer(_threeNumber.substring(0, 2));
                _bgPeriodNumber = BgNPeriodHelper.createNewMonthWeekBgPeriodNumber(year, month, week, offset, isExpression);
            }
        } else {
            String str = "";
            try {
                Integer num = new Integer(_threeNumber);
                Integer newNum = num + offset;
                str = newNum < 9 ? str + "00" + newNum : (newNum >= 9 && newNum < 99 ? str + "0" + newNum : str + newNum);
            }
            catch (Exception e) {
                str = "";
            }
            if (!StringUtils.isEmpty((String)str)) {
                _bgPeriodNumber = _oneNumber + "." + _twoNumber + "." + str;
            }
        }
        return _bgPeriodNumber;
    }

    private static String checkFourLevelNumber(String[] parameter, int offset, boolean isExpression) {
        String _oneNumber = parameter[0];
        String _twoNumber = parameter[1];
        String _threeNumber = parameter[2];
        String _fourNumber = parameter[3];
        String _code = "";
        if (_fourNumber.length() >= 4) {
            _code = _fourNumber.substring(2);
        }
        String _bgPeriodNumber = _oneNumber + "." + _twoNumber + "." + _fourNumber;
        if ("D".equals(_code)) {
            if (Pattern.matches("[\\d]{4}Y.[\\d]{2}M.[\\d]{2}D", _bgPeriodNumber)) {
                int year = new Integer(_oneNumber.substring(0, 4));
                int month = new Integer(_twoNumber.substring(0, 2));
                int day = new Integer(_fourNumber.substring(0, 2));
                _bgPeriodNumber = BgNPeriodHelper.createNewDayBgPeriodNumber(year, month, day, offset, isExpression);
            }
        } else if ("TD".equals(_code)) {
            if (Pattern.matches("[\\d]{4}Y.[\\d]{2}M.[\\d]{2}TD", _bgPeriodNumber)) {
                int year = new Integer(_oneNumber.substring(0, 4));
                int month = new Integer(_twoNumber.substring(0, 2));
                int tendays = new Integer(_fourNumber.substring(0, 2));
                _bgPeriodNumber = BgNPeriodHelper.createNewTenDaysBgPeriodNumber(year, month, tendays, offset, isExpression);
            }
        } else if ("MW".equals(_code) && Pattern.matches("[\\d]{4}Y.[\\d]{2}M.[\\d]{2}MW", _bgPeriodNumber)) {
            int year = new Integer(_oneNumber.substring(0, 4));
            int month = new Integer(_twoNumber.substring(0, 2));
            int week = new Integer(_fourNumber.substring(0, 2));
            _bgPeriodNumber = BgNPeriodHelper.createNewMonthWeekBgPeriodNumber(year, month, week, offset, isExpression);
        }
        return _bgPeriodNumber;
    }

    private static String createNewYearBgPeriodNumber(int year, int offset, boolean isExpression) {
        Calendar calendar = Calendar.getInstance();
        if (isExpression) {
            int _offset = offset;
            if (_offset > 1900) {
                calendar.set(_offset, 0, 1);
            } else {
                calendar.set(year + _offset, 0, 1);
            }
        } else {
            calendar.set(year, 0, 1);
            calendar.add(1, offset);
        }
        return String.valueOf(calendar.get(1)) + "Y";
    }

    private static String createNewHalfYearBgPeriodNumber(int year, int halfYear, int offset, boolean isExpression) {
        Calendar calendar = Calendar.getInstance();
        if (isExpression) {
            int _offset = offset;
            if (_offset > 2) {
                return null;
            }
            calendar.set(year, (_offset - 1) * 6, 1);
        } else {
            calendar.set(year, (halfYear - 1) * 6, 1);
            if (offset != 0) {
                calendar.add(2, offset * 6);
            }
        }
        StringBuffer _bgPeriodNumber = new StringBuffer();
        _bgPeriodNumber.append(new SimpleDateFormat("yyyy'Y.'").format(calendar.getTime()));
        int _month = calendar.get(2) + 1;
        _bgPeriodNumber.append(_month > 6 ? "02" : "01");
        _bgPeriodNumber.append("HY");
        return _bgPeriodNumber.toString();
    }

    private static String createNewQuarterBgPeriodNumber(int year, int quarter, int offset, boolean isExpression) {
        Calendar calendar = Calendar.getInstance();
        if (isExpression) {
            int _offset = offset;
            if (_offset > 4) {
                return null;
            }
            calendar.set(year, (_offset - 1) * 3, 1);
        } else {
            calendar.set(year, (quarter - 1) * 3, 1);
            calendar.add(2, offset * 3);
        }
        StringBuffer _bgPeriodNumber = new StringBuffer();
        _bgPeriodNumber.append(new SimpleDateFormat("yyyy'Y.'").format(calendar.getTime()));
        int _month = calendar.get(2) + 1;
        if (_month > 6) {
            if (_month > 9) {
                _bgPeriodNumber.append("04");
            } else {
                _bgPeriodNumber.append("03");
            }
        } else if (_month > 3) {
            _bgPeriodNumber.append("02");
        } else {
            _bgPeriodNumber.append("01");
        }
        _bgPeriodNumber.append("Q");
        return _bgPeriodNumber.toString();
    }

    private static String createNewYearWeekBgPeriodNumber(int year, int week, int offset, boolean isExpression) {
        CalendarHelper helper = new CalendarHelper();
        int maxWeek = 0;
        int tmp = 0;
        if (offset > 0) {
            maxWeek = helper.getWeeksOfYear(year, true);
            for (tmp = week + offset - maxWeek; tmp > 0; tmp -= maxWeek) {
                maxWeek = helper.getWeeksOfYear(++year, true);
            }
            String tmpWeek = tmp + maxWeek + "";
            if (tmpWeek.trim().length() == 1) {
                tmpWeek = "0" + tmpWeek;
            }
            return year + "Y" + "." + tmpWeek + "W";
        }
        if (offset < 0) {
            maxWeek = helper.getWeeksOfYear(year, true);
            for (tmp = week + offset; tmp <= 0; tmp += maxWeek) {
                maxWeek = helper.getWeeksOfYear(--year, true);
            }
            String tmpWeek = tmp + "";
            if (tmpWeek.trim().length() == 1) {
                tmpWeek = "0" + tmpWeek;
            }
            return year + "Y" + "." + tmpWeek + "W";
        }
        String tmpWeek = week + "";
        if (tmpWeek.trim().length() == 1) {
            tmpWeek = "0" + tmpWeek;
        }
        return year + "Y" + "." + tmpWeek + "W";
    }

    private static String createNewMonthBgPeriodNumber(int year, int month, int offset, boolean isExpression) {
        Calendar calendar = Calendar.getInstance();
        if (isExpression) {
            int _offset = offset;
            if (_offset > 12) {
                _offset = 12;
            }
            calendar.set(1, year);
            calendar.set(2, _offset - 1);
        } else {
            calendar.set(year, month - 1, 1);
            if (offset != 0) {
                calendar.add(2, offset);
            }
        }
        return new SimpleDateFormat("yyyy'Y.'MM'M'").format(calendar.getTime());
    }

    private static String createNewDayBgPeriodNumber(int year, int month, int day, int offset, boolean isExpression) {
        Calendar calendar = Calendar.getInstance();
        if (isExpression) {
            int _offset = offset;
            CalendarHelper calendarHelper = new CalendarHelper();
            int maxDays = calendarHelper.getDaysOfYear(year);
            if (_offset > maxDays) {
                _offset = maxDays;
            }
            calendar.set(year, month - 1, _offset);
        } else {
            calendar.set(year, month - 1, day);
            calendar.add(6, offset);
        }
        return new SimpleDateFormat("yyyy'Y.'MM'M.'dd'D'").format(calendar.getTime());
    }

    private static String createNewTenDaysBgPeriodNumber(int year, int month, int tendays, int offset, boolean isExpression) {
        Calendar calendar = Calendar.getInstance();
        String _tenDaysNumber = null;
        if (isExpression) {
            calendar.set(year, month - 1, 1);
            if (offset > 3) {
                return null;
            }
            tendays = offset;
        } else {
            int _tendays = tendays + offset;
            if (_tendays <= 0) {
                while (_tendays <= 0) {
                    offset += 3;
                    if (--month < 1) {
                        month = 12;
                        --year;
                    }
                    _tendays = tendays + offset;
                }
            } else if (_tendays > 3) {
                while (_tendays > 3) {
                    offset -= 3;
                    if (++month > 12) {
                        month = 1;
                        ++year;
                    }
                    _tendays = tendays + offset;
                }
            }
            if ((tendays += offset) == 1) {
                calendar.set(year, month - 1, 1);
            } else if (tendays == 2) {
                calendar.set(year, month - 1, 11);
            } else {
                calendar.set(year, month - 1, 21);
            }
        }
        if (tendays == 1) {
            calendar.set(5, 1);
            _tenDaysNumber = "01TD";
        } else if (tendays == 2) {
            calendar.set(5, 11);
            _tenDaysNumber = "02TD";
        } else if (tendays == 3) {
            calendar.set(5, 21);
            _tenDaysNumber = "03TD";
        }
        _tenDaysNumber = new SimpleDateFormat("yyyy'Y.'MM'M.'").format(calendar.getTime()) + _tenDaysNumber;
        return _tenDaysNumber;
    }

    private static String createNewMonthWeekBgPeriodNumber(int year, int month, int week, int offset, boolean isExpression) {
        Calendar calendar = Calendar.getInstance();
        CalendarHelper calendarHelper = new CalendarHelper();
        calendar.setFirstDayOfWeek(2);
        calendarHelper.setCalendar(calendar);
        int _year = year;
        int _month = month;
        int _week = week;
        int _offset = offset;
        int _amount = calendarHelper.getWeeksOfMonth(_year, _month);
        if (isExpression) {
            if (_offset > _amount) {
                _offset = _amount;
            }
            calendar.setTime(calendarHelper.getFirstDayOfWeek(_year, _month, _offset));
        } else {
            if (_offset > 0) {
                while (_week + _offset > _amount) {
                    _offset -= _amount;
                    if (++_month > 12) {
                        ++_year;
                        _month = 1;
                    }
                    _amount = calendarHelper.getWeeksOfMonth(_year, _month);
                }
                _week += _offset;
            } else {
                while (_week + _offset <= 0) {
                    _offset += _amount;
                    if (--_month <= 0) {
                        --_year;
                        _month = 12;
                    }
                    _amount = calendarHelper.getWeeksOfMonth(_year, _month);
                }
                _week += _offset;
            }
            calendar.setTime(calendarHelper.getFirstDayOfWeek(_year, _month, _week));
        }
        String _monthWeekNumber = new SimpleDateFormat("yyyy'Y.'MM'M.'").format(calendar.getTime());
        _monthWeekNumber = _monthWeekNumber + new DecimalFormat("00").format(calendar.get(4)) + "MW";
        return _monthWeekNumber;
    }

    public static int parserBgPeriodType(String bgPeriodNumber) {
        if (bgPeriodNumber == null) {
            return -1;
        }
        int bgPeriodType = 0;
        String[] parameter = null;
        String _code = null;
        String _bgPeriodNumber = bgPeriodNumber;
        String tmpStr = null;
        if (_bgPeriodNumber.startsWith("ZDY_")) {
            return 8;
        }
        parameter = _bgPeriodNumber.split("\\.");
        if (parameter != null) {
            switch (parameter.length) {
                case 2: {
                    tmpStr = parameter[1];
                    if (_bgPeriodNumber != null && _bgPeriodNumber.endsWith("Y") && Pattern.matches("[\\d]{4}Y", tmpStr)) {
                        bgPeriodType = 1;
                        break;
                    }
                    bgPeriodType = 8;
                    break;
                }
                case 3: {
                    _code = parameter[2].substring(2);
                    tmpStr = parameter[1] + "." + parameter[2];
                    if ("HY".equals(_code)) {
                        if (!Pattern.matches("[\\d]{4}Y.[\\d]{2}HY", tmpStr)) break;
                        bgPeriodType = 2;
                        break;
                    }
                    if ("Q".equals(_code)) {
                        if (!Pattern.matches("[\\d]{4}Y.[\\d]{2}Q", tmpStr)) break;
                        bgPeriodType = 3;
                        break;
                    }
                    if ("M".equals(_code)) {
                        if (!Pattern.matches("[\\d]{4}Y.[\\d]{2}M", tmpStr)) break;
                        bgPeriodType = 4;
                        break;
                    }
                    if (!"W".equals(_code) || !Pattern.matches("[\\d]{4}Y.[\\d]{2}W", tmpStr)) break;
                    bgPeriodType = 5;
                    break;
                }
                case 4: {
                    _code = parameter[3].substring(2);
                    tmpStr = parameter[1] + "." + parameter[2] + "." + parameter[3];
                    if ("D".equals(_code)) {
                        if (!Pattern.matches("[\\d]{4}Y.[\\d]{2}M.[\\d]{2}D", tmpStr)) break;
                        bgPeriodType = 7;
                        break;
                    }
                    if ("TD".equals(_code)) {
                        if (!Pattern.matches("[\\d]{4}Y.[\\d]{2}M.[\\d]{2}TD", tmpStr)) break;
                        bgPeriodType = 9;
                        break;
                    }
                    if (!"MW".equals(_code) || !Pattern.matches("[\\d]{4}Y.[\\d]{2}M.[\\d]{2}MW", tmpStr)) break;
                    bgPeriodType = 6;
                    break;
                }
            }
        }
        return bgPeriodType;
    }

    public static int parserBgPeriodYear(String bgPeriodNumber) {
        int _year = 0;
        if (StringUtils.isEmpty((String)bgPeriodNumber) || bgPeriodNumber.length() < 5) {
            return _year;
        }
        try {
            int index = bgPeriodNumber.indexOf(".");
            _year = Integer.valueOf(bgPeriodNumber.substring(index + 1, index + 5));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return _year;
    }

    public static int parserBgPeriodHalfYearOrQuarterOrMonth(String bgPeriodNumber) {
        int month = 0;
        if (StringUtils.isEmpty((String)bgPeriodNumber) || bgPeriodNumber.length() < 9) {
            return month;
        }
        try {
            month = Integer.valueOf(bgPeriodNumber.substring(6, 8));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return month;
    }

    public static int parserBgPeriodWeekOrTenDaysOrDay(String bgPeriodNumber) {
        int day = 0;
        if (StringUtils.isEmpty((String)bgPeriodNumber) || bgPeriodNumber.length() < 9) {
            return day;
        }
        try {
            day = Integer.valueOf(bgPeriodNumber.substring(10, 12));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return day;
    }

    public static Date getDayBegin(Date day) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(day);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        Date ds = new Date(cal.getTimeInMillis());
        return ds;
    }

    public static Date getDayEnd(Date day) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(day);
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        Date ds = new Date(cal.getTimeInMillis());
        return ds;
    }

    public static boolean isAcross(Date begin1, Date end1, Date begin2, Date end2) {
        return BgNPeriodHelper.isIn(begin1, begin2, end2) || BgNPeriodHelper.isIn(end1, begin2, end2) || BgNPeriodHelper.isIn(begin2, begin1, end1) || BgNPeriodHelper.isIn(end2, begin1, end1);
    }

    public static boolean isIn(Date date, Date begin, Date end) {
        return !begin.after(date) && !end.before(date);
    }

    public static boolean checkPeriodContinue(List<BgPeriodInfo> periodList, StringBuffer msg) {
        boolean flag = true;
        Collections.sort(periodList, new Comparator<BgPeriodInfo>(){

            @Override
            public int compare(BgPeriodInfo o1, BgPeriodInfo o2) {
                return o1.getBeginDate().compareTo(o2.getBeginDate());
            }
        });
        for (int i = 0; i < periodList.size() - 1; ++i) {
            if (msg.length() > 1) {
                msg.append("\r\n");
            }
            if (BgNPeriodHelper.dateAddOne(periodList.get(i).getEndDate()).equals(periodList.get(i + 1).getBeginDate())) continue;
            msg.append(EASResource.getString((String)"com.kingdee.eas.ma.base.BgPeriodResource", (String)"periodNotContinue"));
            flag = false;
        }
        return flag;
    }

    public static Date dateAddOne(Date date) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        ((Calendar)calendar).add(5, 1);
        date = calendar.getTime();
        return date;
    }

    public static boolean isSameBgPeriodGroup(String bgPeriodNumber1, String bgPeriodNumber2) {
        String[] param1 = bgPeriodNumber1.split("\\.");
        String[] param2 = bgPeriodNumber2.split("\\.");
        if (param1.length < 1 || param2.length < 1) {
            return false;
        }
        return param1[0].equals(param2[0]);
    }
}

