/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.base.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.rpt.TableToolkit;
import com.kingdee.eas.ma.base.BgAccountInfo;
import com.kingdee.eas.ma.base.BgAccountViewInfo;
import com.kingdee.eas.ma.base.BgException;
import com.kingdee.eas.ma.base.MbgDimException;
import com.kingdee.eas.ma.base.MbgDimInfo;
import com.kingdee.eas.ma.base.MbgMemberInfo;
import com.kingdee.eas.ma.base.MbgViewInfo;
import com.kingdee.eas.ma.base.app.utils.MbgSqlHelper;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.security.SecureRandom;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.apache.log4j.Logger;

public class MbgVirtualView
extends Thread {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.mbg.utils.base.MbgVirtualView");
    private static final int MAX_RANDOM_VALUE = 99999999;
    private static final String MBGINDEX_TABLE = "T_MBG_MBGINDEX";
    private static final String MBGINDEX_INDEX = "PK_MBG_MBGIN";
    private static final String MBGEXTDIM_TABLE = "T_MBG_MBGDIM";
    private static final String MBGEXTDIM_INDEX = "PK_MBG_MBGDM";
    private static final String MBGUNION_TABLE = "T_MBG_MBGUNION";
    private static final String MBGUNION_INDEX = "PK_MBG_MBGUN";
    private static final String TAG_FACT = "_FACT";
    private static final String TAG_CLOSURE = "_CLOSURE";
    private static final String PARAMETER = "Parameter";
    public static final String DEF_INDEX_SRCNUMBER = "Acc";
    public static final int MAX_TREE_SIZE = 50;
    private Context ctx = null;
    private String virNo = null;
    private String virTable = null;
    private int DATA_TYPE = 0;
    private int MBGINDEX_TYPE = 1;
    private int MBGEXTDIM_TYPE = 2;
    private int MBGUNION_TYPE = 3;
    private Set<BOSUuid> viewIds = null;
    public static final int DEF_FACT = 0;
    public static final int DEF_CLOSURE = 1;
    public static final int USER_FACT = 2;
    public static final int USER_CLOSURE = 3;
    public static final String BASE_SNAP_VER = "1000";
    public static final String BGORG_TABLE_KEY = "T_MBG_BGORG";
    public static final String BGORG_F_PK_KEY = "PK_MBG_BGORG";
    public static final String BGORG_C_UNINDEX_KEY = "UX_MBG_BGORGC";
    public static final String BGORG_C_INDEX_KEY = "IX_MBG_BGORGC";

    protected void setCtx(Context ctx) {
        this.ctx = ctx;
    }

    protected Context getCtx() {
        return this.ctx;
    }

    protected void setVirNo(String virNo) {
        this.virNo = virNo;
    }

    protected String getVirNo() {
        return this.virNo;
    }

    protected void setVirTable(String virTable) {
        this.virTable = virTable;
    }

    protected String getVirTable() {
        return this.virTable;
    }

    protected void setDATA_TYPE(int dATA_TYPE) {
        this.DATA_TYPE = dATA_TYPE;
    }

    protected int getDATA_TYPE() {
        return this.DATA_TYPE;
    }

    private String getAccPrefix() {
        return DEF_INDEX_SRCNUMBER + BgBaseConstants.SEP_FOUR_STR;
    }

    public MbgVirtualView(Context ctx) {
        this.setCtx(ctx);
    }

    public static MbgVirtualView getInstance(Context ctx) {
        return new MbgVirtualView(ctx);
    }

    public void checkVirtualView(IObjectCollection colls) throws BOSException, EASBizException {
        if (colls == null || colls.isEmpty()) {
            return;
        }
        IObjectValue model = null;
        BgAccountInfo account = null;
        MbgMemberInfo mbgMember = null;
        HashSet<BOSUuid> viewIds = new HashSet<BOSUuid>();
        int in = colls.size();
        for (int i = 0; i < in; ++i) {
            model = colls.getObject(i);
            if (model instanceof BgAccountInfo) {
                account = (BgAccountInfo)model;
                if (account.getBgAccountType() == null) continue;
                viewIds.add(account.getBgAccountView().getId());
                continue;
            }
            if (!(model instanceof MbgMemberInfo) || (mbgMember = (MbgMemberInfo)model).getViewId() == null) continue;
            viewIds.add(mbgMember.getViewId());
        }
        this.checkVirtualView(viewIds);
    }

    public void checkVirtualView(BOSUuid viewId) throws BOSException, EASBizException {
        HashSet<BOSUuid> viewIds = new HashSet<BOSUuid>();
        viewIds.add(viewId);
        this.checkVirtualView(viewIds);
    }

    public void checkVirtualView(Set<BOSUuid> uuids) throws BOSException, EASBizException {
        if (this.getCtx() == null || uuids == null || uuids.isEmpty()) {
            return;
        }
        this.viewIds = uuids;
        this.start();
    }

    public void checkCslVirualView() throws BOSException, EASBizException {
        BOSUuid cslViewId = BOSUuid.read((String)"M0NlAtvwTc+hRz1Td/e60V2BTmI=");
        Connection conn = null;
        try {
            IRowSet rst;
            conn = EJBFactory.getConnection((Context)this.ctx);
            String factName = MbgVirtualView.getFactTable(conn, cslViewId);
            boolean hasData = false;
            if (factName != null && (rst = BgDBUtils.executeQuery(conn, "select count(*) FROM " + factName)) != null && rst.next()) {
                boolean bl = hasData = rst.getInt(1) > 0;
            }
            if (!hasData) {
                this.checkVirtualView(cslViewId);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.getCtx() == null || this.viewIds == null || this.viewIds.isEmpty() || MbgVirtualView.checkIsUpdating(this.getCtx())) {
            return;
        }
        Connection conn = null;
        try {
            conn = BgDBUtils.getConnection(this.getCtx());
            for (BOSUuid uuid : this.viewIds) {
                this.checkVirTable(conn, uuid);
                this.checkFact(conn, uuid);
                this.checkClosure(conn);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"run check member fact Error", (Throwable)ex);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
    }

    public void recycleVirtualView(IObjectPK viewId) throws BOSException, EASBizException {
        if (this.getCtx() == null || viewId == null) {
            return;
        }
        HashSet<BOSUuid> viewIds = new HashSet<BOSUuid>();
        viewIds.add(BOSUuid.read((String)viewId.toString()));
        this.recycleVirtualView(viewIds);
    }

    public void recycleVirtualView(Collection<BOSUuid> viewIds) throws BOSException, EASBizException {
        if (this.getCtx() == null || viewIds == null || viewIds.isEmpty()) {
            return;
        }
        String factTable = null;
        String closureTable = null;
        Connection conn = null;
        try {
            conn = BgDBUtils.getConnection(this.getCtx());
            for (BOSUuid viewId : viewIds) {
                factTable = MbgVirtualView.getFactTable(conn, viewId);
                if (StringUtils.isEmpty((String)factTable)) continue;
                closureTable = MbgVirtualView.getClosureTable(factTable);
                BgDBUtils.executeUpdate(conn, "drop table " + factTable);
                BgDBUtils.executeUpdate(conn, "drop table " + closureTable);
                BgDBUtils.executeUpdate(conn, "delete from T_MBG_BgVirtualView where FID = ?", new Object[]{viewId.toString()});
            }
        }
        catch (SQLDataException ex) {
            throw ex;
        }
        catch (SQLException ex) {
            logger.error((Object)"recycleVirtualView sql error:", (Throwable)ex);
            throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
    }

    public static String getFactTable(Connection conn, BOSUuid viewId) throws EASBizException {
        if (conn == null || viewId == null) {
            return null;
        }
        IRowSet rst = null;
        String factTable = null;
        try {
            rst = BgDBUtils.executeQuery(conn, "select FTable from T_MBG_BgVirtualView where FID = ?", new Object[]{viewId.toString()});
            if (rst.next()) {
                factTable = rst.getString("FTable");
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"getFactTable sql error:", (Throwable)ex);
                throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst);
        return factTable;
    }

    public static String getMbgOrgUnitSnap(Connection conn, BOSUuid viewId) throws EASBizException {
        if (conn == null || viewId == null) {
            return null;
        }
        IRowSet rst = null;
        String snapshotvar = null;
        try {
            rst = BgDBUtils.executeQuery(conn, "select FSnapshotvar from T_MBG_BgOrgView where FID = ?", new Object[]{viewId.toString()});
            if (rst.next()) {
                snapshotvar = rst.getString("FSnapshotvar");
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"sql error:", (Throwable)ex);
                throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst);
        return snapshotvar;
    }

    public static String[] getMbgOrgUnitSnap(Connection conn, BOSUuid viewId, BOSUuid orgUnitId, BOSUuid unionId) throws EASBizException {
        String[] tables;
        IRowSet rst;
        block13: {
            if (conn == null || viewId == null) {
                return null;
            }
            rst = null;
            String snapShotVar = null;
            String snapTreeVar = null;
            String[] _tables = null;
            String[] tmpStrs = null;
            String tmpTableNam = null;
            tables = new String[4];
            try {
                if (unionId == null) {
                    rst = BgDBUtils.executeQuery(conn, "select FSnapShotVar, FSnapTreeVar from T_MBG_BgOrgView where FID = ?", new Object[]{viewId.toString()});
                    if (rst.next()) {
                        snapShotVar = rst.getString("FSnapShotVar");
                        tables[0] = MbgVirtualView.getBgOrgFactTable(snapShotVar);
                        tables[1] = MbgVirtualView.getBgOrgClosureTable(snapShotVar);
                        snapTreeVar = rst.getString("FSnapTreeVar");
                    }
                    SQLUtils.cleanup((ResultSet)rst);
                    if (snapTreeVar != null) {
                        String rootOrgID = null;
                        String bgOrgUnitLongNumber = null;
                        String sql = "select flongnumber from t_mbg_bgorgunit where fviewid = '" + viewId + "' and forgunitid = '" + orgUnitId.toString() + "' and fisvirtual = 0";
                        rst = BgDBUtils.executeQuery(conn, sql);
                        if (rst.next()) {
                            bgOrgUnitLongNumber = rst.getString(1);
                            SQLUtils.cleanup((ResultSet)rst);
                            String rootNumber = bgOrgUnitLongNumber.split(BgBaseConstants.SEP_ONE_STR)[0];
                            String sql1 = "select fid from t_mbg_bgorgunit where fnumber = '" + rootNumber + "'";
                            rst = BgDBUtils.executeQuery(conn, sql1);
                            if (rst.next()) {
                                rootOrgID = rst.getString(1);
                            }
                            SQLUtils.cleanup((ResultSet)rst);
                        }
                        _tables = snapTreeVar.split(BgBaseConstants.SEP_THR_STR);
                        for (int i = 0; i < _tables.length; ++i) {
                            tmpStrs = _tables[i].split(BgBaseConstants.SEP_ONE_STR);
                            if (!tmpStrs[0].equals(rootOrgID)) continue;
                            tmpTableNam = BGORG_TABLE_KEY + tmpStrs[1] + TAG_FACT;
                            break;
                        }
                        if (tmpTableNam != null) {
                            tables[2] = tmpTableNam;
                            tables[3] = tmpTableNam.replaceAll(TAG_FACT, TAG_CLOSURE);
                        }
                    }
                    if (tables[2] == null || tables[3] == null) {
                        tables[2] = tables[0];
                        tables[3] = tables[1];
                    }
                    break block13;
                }
                tables[0] = MbgVirtualView.getFactTable(conn, unionId);
                tables[2] = tables[0];
            }
            catch (SQLException ex) {
                try {
                    logger.error((Object)"sql error:", (Throwable)ex);
                    throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rst);
                    throw throwable;
                }
            }
        }
        SQLUtils.cleanup((ResultSet)rst);
        return tables;
    }

    public static List<String> getMbgOrgUnitClosure(Connection conn, BOSUuid viewId) throws EASBizException {
        if (conn == null || viewId == null) {
            return null;
        }
        IRowSet rst = null;
        String snapShotVar = null;
        String snapTreeVar = null;
        Object closure = null;
        String[] _tables = null;
        String[] tmpStrs = null;
        ArrayList<String> closures = new ArrayList<String>();
        try {
            rst = BgDBUtils.executeQuery(conn, "select FSnapShotVar, FSnapTreeVar from T_MBG_BgOrgView where FID = ?", new Object[]{viewId.toString()});
            if (rst.next()) {
                snapShotVar = rst.getString("FSnapShotVar");
                closures.add(MbgVirtualView.getBgOrgClosureTable(snapShotVar));
                snapTreeVar = rst.getString("FSnapTreeVar");
            }
            SQLUtils.cleanup((ResultSet)rst);
            if (snapTreeVar != null) {
                _tables = snapTreeVar.split(BgBaseConstants.SEP_THR_STR);
                int in = _tables.length;
                for (int i = 0; i < in; ++i) {
                    tmpStrs = _tables[i].split(BgBaseConstants.SEP_ONE_STR);
                    if (tmpStrs[1].length() < BGORG_TABLE_KEY.length()) {
                        tmpStrs[1] = BGORG_TABLE_KEY + tmpStrs[1] + TAG_FACT;
                    }
                    closures.add(tmpStrs[1].replaceAll(TAG_FACT, TAG_CLOSURE));
                }
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"sql error:", (Throwable)ex);
                throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst);
        return closures;
    }

    public static Map<BOSUuid, OrgUnitInfo> getMbgOrgUnitMap(Context ctx, Connection conn, BOSUuid viewId, Collection<String> orgUnitNums) throws BOSException, EASBizException {
        HashMap<BOSUuid, OrgUnitInfo> orgUnitMap = new HashMap<BOSUuid, OrgUnitInfo>();
        if (conn == null || viewId == null || orgUnitNums == null || orgUnitNums.isEmpty()) {
            return orgUnitMap;
        }
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        String tmpTable = null;
        OrgUnitInfo orgUnit = null;
        IRowSet rst = null;
        try {
            tmpTable = BgDBUtils.createTmpTable(ctx, pool, "Create Table TEML_KSQL_0 (FNumber NVARCHAR(80))");
            if (tmpTable != null) {
                BgDBUtils.insertKey(conn, "Insert Into " + tmpTable + " (FNumber) Values (?)", orgUnitNums);
                rst = BgDBUtils.executeQuery(conn, "select t.FOrgUnitId, cc.FNumber, cc.FName_" + ctx.getLocale() + " AS FName, cc.FLongNumber from T_MBG_BgOrgUnit t join T_ORG_CostCenter cc on t.FOrgUnitId = cc.FID where t.FViewId = ? and exists (select FNumber from " + tmpTable + " where FNumber = t.FNumber)");
                while (rst.next()) {
                    orgUnit = new OrgUnitInfo();
                    orgUnit.setId(BOSUuid.read((String)rst.getString("FOrgUnitId")));
                    orgUnit.setNumber(rst.getString("FNumber"));
                    orgUnit.setName(rst.getString("FName"));
                    orgUnit.setLongNumber(rst.getString("FLongNumber"));
                    orgUnitMap.put(orgUnit.getId(), orgUnit);
                }
            }
        }
        catch (SQLException ex) {
            logger.error((Object)"sql error:", (Throwable)ex);
            throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
        }
        finally {
            SQLUtils.cleanup(rst);
            try {
                BgDBUtils.releaseTmpTable(pool, tmpTable);
            }
            catch (Exception exception) {}
        }
        return orgUnitMap;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Map<String, String[]> getFactData(Context ctx, TempTablePool pool, Connection conn, BOSUuid viewId, Collection<String> queryNums) throws BOSException, EASBizException {
        HashMap<String, String[]> factDataMap = new HashMap<String, String[]>();
        if (ctx == null) return factDataMap;
        if (pool == null) return factDataMap;
        if (conn == null) return factDataMap;
        if (viewId == null) return factDataMap;
        if (queryNums == null) return factDataMap;
        if (queryNums.isEmpty()) {
            return factDataMap;
        }
        String factTable = null;
        String tmpTable = null;
        String[] factData = null;
        ResultSet rst = null;
        try {
            factTable = MbgVirtualView.getFactTable(conn, viewId);
            if (queryNums.size() < 50) {
                StringBuffer sql = new StringBuffer();
                sql.append("select FDimNumber, FLongNumber from " + factTable + " where FDimNumber IN(");
                MbgSqlHelper.addPlaceHolder(sql).append(")");
                Object[] params = new Object[50];
                MbgSqlHelper.setBatchParams(queryNums.toArray(), params, 0, 0);
                rst = BgDBUtils.executeQuery(conn, sql.toString(), params);
            } else {
                tmpTable = BgDBUtils.createTmpTable(ctx, pool, "Create Table TEML_KSQL_0 (FNumber NVARCHAR(84))");
                if (tmpTable != null) {
                    BgDBUtils.insertKey(conn, "Insert Into " + tmpTable + " (FNumber) Values (?)", queryNums);
                    rst = BgDBUtils.executeQuery(conn, "select FDimNumber, FLongNumber from " + factTable + " where exists (select FNumber from " + tmpTable + " where FNumber = " + factTable + ".FDimNumber)");
                }
            }
            while (rst != null && rst.next()) {
                factData = new String[4];
                factData[0] = rst.getString("FDimNumber");
                factData[1] = rst.getString("FLongNumber");
                factDataMap.put(rst.getString("FDimNumber"), factData);
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"sql error:", (Throwable)ex);
                throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst);
                try {
                    BgDBUtils.releaseTmpTable(pool, tmpTable);
                    throw throwable;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst);
        try {
            BgDBUtils.releaseTmpTable(pool, tmpTable);
            return factDataMap;
        }
        catch (Exception sql) {
            return factDataMap;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Set<String> queryFactData(Context ctx, Connection conn, BOSUuid viewId, Collection<String> queryNums) throws BOSException, EASBizException {
        HashSet<String> factDataSet = new HashSet<String>();
        if (ctx == null) return factDataSet;
        if (conn == null) return factDataSet;
        if (viewId == null) return factDataSet;
        if (queryNums == null) return factDataSet;
        if (queryNums.isEmpty()) {
            return factDataSet;
        }
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        String factTable = null;
        String tmpTable = null;
        IRowSet rst = null;
        try {
            factTable = MbgVirtualView.getFactTable(conn, viewId);
            tmpTable = BgDBUtils.createTmpTable(ctx, pool, "Create Table TEML_KSQL_0 (FNumber NVARCHAR(84))");
            if (tmpTable != null) {
                BgDBUtils.insertKey(conn, "Insert Into " + tmpTable + " (FNumber) Values (?)", queryNums);
                rst = BgDBUtils.executeQuery(conn, "select FNumber from " + factTable + " where exists (select FNumber from " + tmpTable + " where FNumber = " + factTable + ".FNumber)");
                while (rst.next()) {
                    factDataSet.add(rst.getString("FNumber"));
                }
            }
        }
        catch (BOSException ex) {
            try {
                throw ex;
                catch (SQLException ex2) {
                    logger.error((Object)"sql error:", (Throwable)ex2);
                    throw new BgException(BgException.DATABASEERROR, new String[]{ex2.getMessage()});
                }
                catch (Exception ex3) {
                    logger.error((Object)"sql error:", (Throwable)ex3);
                    throw new BOSException((Throwable)ex3);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst);
                BgDBUtils.releaseTmpTable(pool, tmpTable);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rst);
        BgDBUtils.releaseTmpTable(pool, tmpTable);
        return factDataSet;
    }

    public static Set<String> querySubData(Context ctx, Connection conn, BOSUuid viewId, Collection<String> queryNums) throws BOSException, EASBizException {
        HashSet<String> subDataSet = new HashSet<String>();
        if (ctx == null || conn == null || viewId == null || queryNums == null || queryNums.isEmpty()) {
            return subDataSet;
        }
        IRowSet rst = null;
        String tmpTable = null;
        String factTable = MbgVirtualView.getFactTable(conn, viewId);
        String closureTable = MbgVirtualView.getClosureTable(factTable);
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        long st = System.currentTimeMillis();
        try {
            tmpTable = BgDBUtils.createTmpTable(ctx, pool, "Create Table TEML_KSQL_0 (FNumber NVARCHAR(84))");
            if (tmpTable != null) {
                BgDBUtils.insertKey(conn, "Insert Into " + tmpTable + " (FNumber) Values (?)", queryNums);
                rst = BgDBUtils.executeQuery(conn, "select FChildId from " + closureTable + " where exists (select FNumber from " + tmpTable + " where FNumber = " + closureTable + ".FID)");
                while (rst.next()) {
                    subDataSet.add(rst.getString(1));
                }
            }
        }
        catch (SQLException ex) {
            logger.error((Object)"sql error:", (Throwable)ex);
            throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
        }
        catch (Exception ex) {
            logger.error((Object)"sql error:", (Throwable)ex);
            throw new BOSException((Throwable)ex);
        }
        finally {
            SQLUtils.cleanup(rst);
            BgDBUtils.releaseTmpTable(pool, tmpTable);
        }
        logger.info((Object)("querySubData:" + (System.currentTimeMillis() - st)));
        return subDataSet;
    }

    public static Map<String, Set<String>> querySubDataMap(Context ctx, Connection conn, BOSUuid viewId, Collection<String> queryNums, boolean isParent) throws BOSException, EASBizException {
        HashMap<String, Set<String>> subDataMap = new HashMap<String, Set<String>>();
        if (ctx == null || conn == null || viewId == null || queryNums == null || queryNums.isEmpty()) {
            return subDataMap;
        }
        IRowSet rst = null;
        String tmpTable = null;
        String factTable = MbgVirtualView.getFactTable(conn, viewId);
        String closureTable = MbgVirtualView.getClosureTable(factTable);
        String number = null;
        String child = null;
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        long st = System.currentTimeMillis();
        try {
            tmpTable = BgDBUtils.createTmpTable(ctx, pool, "Create Table TEML_KSQL_0 (FNumber NVARCHAR(84))");
            if (tmpTable != null) {
                BgDBUtils.insertKey(conn, "Insert Into " + tmpTable + " (FNumber) Values (?)", queryNums);
                rst = BgDBUtils.executeQuery(conn, "select FID, FChildId from " + closureTable + " where exists (select FNumber from " + tmpTable + " where FNumber = " + closureTable + (isParent ? ".FChildId" : ".FID") + ")");
                while (rst.next()) {
                    if (isParent) {
                        number = rst.getString(2);
                        child = rst.getString(1);
                    } else {
                        number = rst.getString(1);
                        child = rst.getString(2);
                    }
                    if (!subDataMap.containsKey(number)) {
                        subDataMap.put(number, new HashSet());
                    }
                    ((Set)subDataMap.get(number)).add(child);
                }
            }
        }
        catch (SQLException ex) {
            logger.error((Object)"sql error:", (Throwable)ex);
            throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
        }
        catch (Exception ex) {
            logger.error((Object)"sql error:", (Throwable)ex);
            throw new BOSException((Throwable)ex);
        }
        finally {
            SQLUtils.cleanup(rst);
            BgDBUtils.releaseTmpTable(pool, tmpTable);
        }
        logger.info((Object)("querySubData:" + (System.currentTimeMillis() - st)));
        return subDataMap;
    }

    public static String querySubData(Context ctx, Connection conn, MbgDimInfo mbgDim, BOSUuid viewId, Collection<String> queryNums, Collection<String> insertNums) throws BOSException, EASBizException {
        if (ctx == null || conn == null || mbgDim == null || viewId == null || queryNums == null || queryNums.isEmpty()) {
            return null;
        }
        String tmpTable = null;
        String tmpSubTable = null;
        String factTable = MbgVirtualView.getFactTable(conn, viewId);
        String closureTable = MbgVirtualView.getClosureTable(factTable);
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        HashSet<String> dimNumSet = new HashSet<String>(queryNums.size());
        for (String number : queryNums) {
            dimNumSet.add(MbgVirtualView.getDimNumber(mbgDim.getSrcNumber(), number));
        }
        try {
            tmpTable = BgDBUtils.createTmpTable(ctx, pool, "Create Table TEML_KSQL_0 (FNumber NVARCHAR(84))");
            if (tmpTable != null) {
                pool.createIndex(tmpTable, "FNumber", false, false);
                BgDBUtils.insertKey(conn, "Insert Into " + tmpTable + " (FNumber) Values (?)", dimNumSet);
                tmpSubTable = BgDBUtils.createTmpTable(ctx, pool, "Create Table TEML_KSQL_1 (FNumber NVARCHAR(84))");
                if (tmpSubTable != null) {
                    pool.createIndex(tmpSubTable, "FNumber", true, false);
                    BgDBUtils.executeUpdate(conn, "Insert Into " + tmpSubTable + " (FNumber) select distinct FChildId from " + closureTable + " where exists (select FNumber from " + tmpTable + " where FNumber = " + closureTable + ".FID)");
                    if (insertNums != null && !insertNums.isEmpty()) {
                        dimNumSet.clear();
                        for (String number : insertNums) {
                            dimNumSet.add(MbgVirtualView.getDimNumber(mbgDim.getSrcNumber(), number));
                        }
                        BgDBUtils.executeUpdate(conn, "delete from " + tmpTable);
                        BgDBUtils.insertKey(conn, "Insert Into " + tmpTable + " (FNumber) Values (?)", dimNumSet);
                        BgDBUtils.executeUpdate(conn, "Insert Into " + tmpSubTable + " (FNumber) select distinct FNumber from " + tmpTable + " where not exists (select FNumber from " + tmpSubTable + " where FNumber = " + tmpTable + ".FNumber)");
                    }
                }
            }
        }
        catch (SQLException ex) {
            logger.error((Object)"sql error:", (Throwable)ex);
            throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
        }
        catch (Exception ex) {
            logger.error((Object)"sql error:", (Throwable)ex);
            throw new BOSException((Throwable)ex);
        }
        finally {
            BgDBUtils.releaseTmpTable(pool, tmpTable);
        }
        return tmpSubTable;
    }

    private static String getDimNumber(String srcNumber, String number) {
        if (number != null && number.indexOf(BgBaseConstants.SEP_FOUR_STR) > 0) {
            return number;
        }
        return srcNumber + BgBaseConstants.SEP_FOUR_STR + number;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkVirTable(Connection conn, BOSUuid uuid) throws EASBizException {
        IRowSet rst;
        block10: {
            if (conn == null || uuid == null) {
                throw new EASBizException(EASBizException.CHECKBLANK, (Object[])new String[]{PARAMETER});
            }
            rst = null;
            IRowSet rst1 = null;
            String factType = this.getFactType(uuid);
            if (factType == null) {
                return;
            }
            try {
                block11: {
                    boolean check;
                    block9: {
                        rst = BgDBUtils.executeQuery(conn, "select FTable from T_MBG_BgVirtualView where FID = ?", new Object[]{uuid.toString()});
                        if (rst.next()) break block11;
                        check = true;
                        DecimalFormat df = new DecimalFormat("########");
                        Random random = new Random(System.currentTimeMillis());
                        this.setVirTable(this.getFactTable(factType, df, random));
                        try {
                            rst1 = BgDBUtils.executeQuery(conn, "select FTable from T_MBG_BgVirtualView where FTable = ?", new Object[]{this.getVirTable()});
                            if (rst1.next()) break block9;
                            BgDBUtils.executeUpdate(conn, "Insert Into T_MBG_BgVirtualView (FID, FTable) Values (?,?)", new Object[]{uuid.toString(), this.getVirTable()});
                            check = false;
                        }
                        catch (Throwable throwable) {
                            SQLUtils.cleanup(rst1);
                            throw throwable;
                        }
                    }
                    SQLUtils.cleanup((ResultSet)rst1);
                    while (check) {
                    }
                    break block10;
                }
                String _tmpTable = rst.getString("FTable");
                this.setVirTable(_tmpTable);
                this.setVirNo(_tmpTable.replaceFirst(TAG_FACT, "").replaceFirst(MBGINDEX_TABLE, "").replaceFirst(MBGEXTDIM_TABLE, "").replaceFirst(MBGUNION_TABLE, ""));
            }
            catch (SQLException ex) {
                try {
                    logger.error((Object)"sql error:", (Throwable)ex);
                    throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rst);
                    throw throwable;
                }
            }
        }
        SQLUtils.cleanup((ResultSet)rst);
    }

    private void checkFact(Connection conn, BOSUuid uuid) throws SQLException, EASBizException {
        if (conn == null || uuid == null) {
            throw new EASBizException(EASBizException.CHECKBLANK, (Object[])new String[]{PARAMETER});
        }
        if (this.MBGINDEX_TYPE == this.getDATA_TYPE()) {
            this.checkFactTableByNumber(conn, uuid);
        } else if (this.MBGEXTDIM_TYPE == this.getDATA_TYPE()) {
            this.checkFactTableByNumber(conn, uuid);
        } else if (this.MBGUNION_TYPE == this.getDATA_TYPE()) {
            this.checkFactTableByID(conn, uuid);
        }
        this.checkFactData(conn, uuid);
    }

    private void checkFactTableByNumber(Connection conn, BOSUuid uuid) throws SQLException, EASBizException {
        if (conn == null || uuid == null) {
            throw new EASBizException(EASBizException.CHECKBLANK, (Object[])new String[]{PARAMETER});
        }
        int re = BgDBUtils.existTable(conn, this.getVirTable());
        if (re == BgDBUtils.NO) {
            StringBuffer sql = new StringBuffer();
            sql.append("Create Table " + this.getVirTable() + " (FNUMBER NVARCHAR(80) DEFAULT '' NOT NULL, FLONGNUMBER NVARCHAR(1000), FDIMNUMBER NVARCHAR(84) DEFAULT '' NOT NULL, FDIMLONGNUMBER NVARCHAR(1000), FPARENTNUMBER NVARCHAR(84), ");
            if (this.getDATA_TYPE() == this.MBGINDEX_TYPE) {
                sql.append("FPolAlgorithm INT DEFAULT 1 NOT NULL, FBgAccountType INT DEFAULT 0 NOT NULL, FBgAccountDataType INT DEFAULT 0 NOT NULL, FBgDecreditAlgorithm INT DEFAULT 0 NOT NULL, ");
            }
            sql.append("CONSTRAINT " + this.getFactIndex(this.getVirTable()) + " PRIMARY KEY (FNUMBER))");
            BgDBUtils.executeUpdate(conn, sql.toString());
            String uxIndexName = "UX_MBG_DD" + this.getVirNo();
            int check = BgDBUtils.existIndex(conn, this.getVirTable(), uxIndexName);
            if (check == BgDBUtils.NO) {
                try {
                    BgDBUtils.executeUpdate(conn, "CREATE UNIQUE INDEX " + uxIndexName + " ON " + this.getVirTable() + " (FDIMNUMBER)");
                }
                catch (SQLException ex) {
                    logger.error((Object)"checkFactTable Sql Error:", (Throwable)ex);
                }
            }
            String dlIndexName = "IX_MBG_DL" + this.getVirNo();
            check = BgDBUtils.existIndex(conn, this.getVirTable(), dlIndexName);
            if (check == BgDBUtils.NO) {
                try {
                    BgDBUtils.executeUpdate(conn, "CREATE INDEX " + dlIndexName + " ON " + this.getVirTable() + " (FLONGNUMBER)");
                }
                catch (SQLException ex) {
                    logger.error((Object)"checkFactTable Sql Error:", (Throwable)ex);
                }
            }
            String dpIndexName = "IX_MBG_DP" + this.getVirNo();
            check = BgDBUtils.existIndex(conn, this.getVirTable(), dpIndexName);
            if (check == BgDBUtils.NO) {
                try {
                    BgDBUtils.executeUpdate(conn, "CREATE INDEX " + dpIndexName + " ON " + this.getVirTable() + " (FPARENTNUMBER)");
                }
                catch (SQLException ex) {
                    logger.error((Object)"checkFactTable Sql Error:", (Throwable)ex);
                }
            }
        } else if (this.getDATA_TYPE() == this.MBGINDEX_TYPE) {
            re = BgDBUtils.existColumn(conn, this.getVirTable(), "FPolAlgorithm");
            if (re == BgDBUtils.NO) {
                BgDBUtils.executeUpdate(conn, "ALTER TABLE " + this.getVirTable() + " ADD FPolAlgorithm INT DEFAULT 1 NOT NULL");
            }
            if ((re = BgDBUtils.existColumn(conn, this.getVirTable(), "FBgAccountType")) == BgDBUtils.NO) {
                BgDBUtils.executeUpdate(conn, "ALTER TABLE " + this.getVirTable() + " ADD FBgAccountType INT DEFAULT 0 NOT NULL");
            }
            if ((re = BgDBUtils.existColumn(conn, this.getVirTable(), "FBgAccountDataType")) == BgDBUtils.NO) {
                BgDBUtils.executeUpdate(conn, "ALTER TABLE " + this.getVirTable() + " ADD FBgAccountDataType INT DEFAULT 0 NOT NULL");
            }
            if ((re = BgDBUtils.existColumn(conn, this.getVirTable(), "FBgDecreditAlgorithm")) == BgDBUtils.NO) {
                BgDBUtils.executeUpdate(conn, "ALTER TABLE " + this.getVirTable() + " ADD FBgDecreditAlgorithm INT DEFAULT 0 NOT NULL");
            }
        }
    }

    private void checkFactTableByID(Connection conn, BOSUuid uuid) throws SQLException, EASBizException {
        if (conn == null || uuid == null) {
            throw new EASBizException(EASBizException.CHECKBLANK, (Object[])new String[]{PARAMETER});
        }
        int re = BgDBUtils.existTable(conn, this.getVirTable());
        if (re == BgDBUtils.NO) {
            StringBuffer sql = new StringBuffer();
            sql.append("Create Table " + this.getVirTable() + " (FID VARCHAR(44) DEFAULT '' NOT NULL, FNUMBER NVARCHAR(80) DEFAULT '' NOT NULL, FLONGNUMBER NVARCHAR(1000), FPARENTID VARCHAR(44), CONSTRAINT " + this.getFactIndex(this.getVirTable()) + " PRIMARY KEY (FID))");
            BgDBUtils.executeUpdate(conn, sql.toString());
            String ixNumber = "IX_MBG_DN" + this.getVirNo();
            int check = BgDBUtils.existIndex(conn, this.getVirTable(), ixNumber);
            if (check == BgDBUtils.NO) {
                try {
                    BgDBUtils.executeUpdate(conn, "CREATE INDEX " + ixNumber + " ON " + this.getVirTable() + " (FNUMBER)");
                }
                catch (SQLException ex) {
                    logger.error((Object)"checkFactTable Sql Error:", (Throwable)ex);
                }
            }
            String ixLongNumber = "IX_MBG_DL" + this.getVirNo();
            check = BgDBUtils.existIndex(conn, this.getVirTable(), ixLongNumber);
            if (check == BgDBUtils.NO) {
                try {
                    BgDBUtils.executeUpdate(conn, "CREATE INDEX " + ixLongNumber + " ON " + this.getVirTable() + " (FLONGNUMBER)");
                }
                catch (SQLException ex) {
                    logger.error((Object)"checkFactTable Sql Error:", (Throwable)ex);
                }
            }
            String ixParent = "IX_MBG_DP" + this.getVirNo();
            check = BgDBUtils.existIndex(conn, this.getVirTable(), ixParent);
            if (check == BgDBUtils.NO) {
                try {
                    BgDBUtils.executeUpdate(conn, "CREATE INDEX " + ixParent + " ON " + this.getVirTable() + " (FPARENTID)");
                }
                catch (SQLException ex) {
                    logger.error((Object)"checkFactTable Sql Error:", (Throwable)ex);
                }
            }
        }
    }

    private void checkFactData(Connection conn, BOSUuid uuid) throws SQLException, EASBizException {
        if (conn == null || uuid == null) {
            throw new EASBizException(EASBizException.CHECKBLANK, (Object[])new String[]{PARAMETER});
        }
        BgDBUtils.executeUpdate(conn, "Truncate table " + this.getVirTable());
        if (this.MBGINDEX_TYPE == this.getDATA_TYPE()) {
            this.checkMbgIndexData(conn, uuid);
        } else if (this.MBGEXTDIM_TYPE == this.getDATA_TYPE()) {
            this.checkMbgExtDimData(conn, uuid);
        } else if (this.MBGUNION_TYPE == this.getDATA_TYPE()) {
            this.checkUnionDebtData(conn, uuid);
        }
    }

    private void checkMbgIndexData(Connection conn, BOSUuid uuid) throws SQLException, EASBizException {
        if (conn == null || uuid == null) {
            throw new EASBizException(EASBizException.CHECKBLANK, (Object[])new String[]{PARAMETER});
        }
        StringBuffer sql = new StringBuffer();
        sql.append("Insert Into " + this.getVirTable() + " (FNUMBER, FLONGNUMBER, FDIMNUMBER, FDIMLONGNUMBER, FPARENTNUMBER, FPolAlgorithm, FBgAccountType, FBgAccountDataType, FBgDecreditAlgorithm) select t.FNumber, t.FLongNumber, CONCAT('" + this.getAccPrefix() + "', t.FNumber), CONCAT('" + this.getAccPrefix() + "', t.FLongNumber), CASE WHEN p.FNumber IS NULL THEN NULL ELSE CONCAT('" + this.getAccPrefix() + "', p.FNumber) END, t.FPolAlgorithm, t.FBgAccountType, t.FBgAccountDataType, t.FBgDecreditAlgorithm from T_MBG_BgAccount t left join T_MBG_BgAccount p on t.FParentID = p.FID where t.FBgAccountViewID = ?");
        BgDBUtils.executeUpdate(conn, sql.toString(), new Object[]{uuid.toString()});
        BgDBUtils.executeUpdate(conn, "update " + this.getVirTable() + " set FDIMLONGNUMBER = REPLACE(FDIMLONGNUMBER, '!', '!" + this.getAccPrefix() + "')");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkMbgExtDimData(Connection conn, BOSUuid uuid) throws SQLException, EASBizException {
        if (conn == null || uuid == null) {
            throw new EASBizException(EASBizException.CHECKBLANK, (Object[])new String[]{PARAMETER});
        }
        String srcNumber = null;
        IRowSet rst = null;
        try {
            rst = BgDBUtils.executeQuery(conn, "select t.FSrcNumber from T_MBG_MbgDim t join T_MBG_MbgView v on t.FID = v.FMbgDimID where v.FID = ?", new Object[]{uuid.toString()});
            if (rst.next()) {
                srcNumber = rst.getString("FSrcNumber");
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rst);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rst);
        if (StringUtils.isEmpty((String)srcNumber)) {
            throw new EASBizException(EASBizException.CHECKBLANK, (Object[])new String[]{PARAMETER});
        }
        String prefixStr = srcNumber + BgBaseConstants.SEP_FOUR_STR;
        StringBuffer sql = new StringBuffer();
        sql.append("Insert Into " + this.getVirTable() + " (FNUMBER, FLONGNUMBER, FDIMNUMBER, FDIMLONGNUMBER, FPARENTNUMBER) select t.FNumber, t.FLongNumber, CONCAT('" + prefixStr + "', t.FNumber), CONCAT('" + prefixStr + "', t.FLongNumber), CONCAT('" + prefixStr + "', p.FNumber) from T_MBG_MbgMember t left join T_MBG_MbgMember p on t.FParentID = p.FID where t.FViewId = ?");
        BgDBUtils.executeUpdate(conn, sql.toString(), new Object[]{uuid.toString()});
        BgDBUtils.executeUpdate(conn, "update " + this.getVirTable() + " set FPARENTNUMBER = null where FNUMBER = FLONGNUMBER");
        BgDBUtils.executeUpdate(conn, "update " + this.getVirTable() + " set FDIMLONGNUMBER = REPLACE(FDIMLONGNUMBER, '!', '!" + prefixStr + "')");
    }

    private void checkUnionDebtData(Connection conn, BOSUuid uuid) throws SQLException, EASBizException {
        if (conn == null || uuid == null) {
            throw new EASBizException(EASBizException.CHECKBLANK, (Object[])new String[]{PARAMETER});
        }
        StringBuffer sql = new StringBuffer();
        sql.append("Insert Into " + this.getVirTable() + " (FID, FNUMBER, FLONGNUMBER) select t.FUnitID, u.FNUMBER, u.FNUMBER from T_ORG_STRUCTURE t left join T_ORG_BaseUnit u on t.FUNITID = u.FID where t.FTREEID = ?");
        BgDBUtils.executeUpdate(conn, sql.toString(), new Object[]{uuid.toString()});
    }

    private void checkClosure(Connection conn) throws SQLException, EASBizException {
        if (conn == null || StringUtils.isEmpty((String)this.getVirTable())) {
            throw new EASBizException(EASBizException.CHECKBLANK, (Object[])new String[]{PARAMETER});
        }
        String closureTable = MbgVirtualView.getClosureTable(this.getVirTable());
        this.checkClosureTable(conn, closureTable);
        this.checkClosureData(conn, closureTable);
    }

    private void checkClosureTable(Connection conn, String closureTable) throws SQLException, EASBizException {
        if (conn == null || StringUtils.isEmpty((String)closureTable)) {
            throw new EASBizException(EASBizException.CHECKBLANK, (Object[])new String[]{PARAMETER});
        }
        int re = BgDBUtils.existTable(conn, closureTable);
        if (re == BgDBUtils.NO) {
            String ixIndex;
            StringBuffer sql = new StringBuffer();
            if (this.MBGINDEX_TYPE == this.getDATA_TYPE() || this.MBGEXTDIM_TYPE == this.getDATA_TYPE()) {
                sql.append("Create Table " + closureTable + " (FID NVARCHAR(84) DEFAULT '' NOT NULL, FChildId NVARCHAR(84) DEFAULT '' NOT NULL, distance INT DEFAULT 0 NOT NULL)");
            } else {
                sql.append("Create Table " + closureTable + " (FID VARCHAR(44) DEFAULT '' NOT NULL, FChildId VARCHAR(44) DEFAULT '' NOT NULL, distance INT DEFAULT 0 NOT NULL)");
            }
            BgDBUtils.executeUpdate(conn, sql.toString());
            String uxIndex = "IX_MBG_CF" + this.getVirNo();
            int check = BgDBUtils.existIndex(conn, closureTable, uxIndex);
            if (check == BgDBUtils.NO) {
                BgDBUtils.executeUpdate(conn, "CREATE UNIQUE INDEX " + uxIndex + " ON " + closureTable + " (FID, FChildId)");
            }
            if ((check = BgDBUtils.existIndex(conn, closureTable, ixIndex = "IX_MBG_CC" + this.getVirNo())) == BgDBUtils.NO) {
                BgDBUtils.executeUpdate(conn, "CREATE INDEX " + ixIndex + " ON " + closureTable + " (FChildId)");
            }
        }
    }

    private void checkClosureData(Connection conn, String closureTable) throws SQLException, EASBizException {
        this.checkClosureData(conn, closureTable, null);
    }

    private void checkClosureData(Connection conn, String closureTable, String longNumber) throws SQLException, EASBizException {
        if (conn == null || StringUtils.isEmpty((String)closureTable)) {
            throw new EASBizException(EASBizException.CHECKBLANK, (Object[])new String[]{PARAMETER});
        }
        if (StringUtils.isEmpty((String)longNumber)) {
            BgDBUtils.executeUpdate(conn, "Truncate table " + closureTable);
        }
        List<ClosureObject> closure = this.getClosureData(conn, longNumber);
        Map<String, ClosureData> closureMap = this.getClosureDataMap(closure);
        List<ClosureData> closureDatas = this.ergodicClosureData(closureMap);
        this.saveClosureData(conn, closureTable, closureDatas);
    }

    private List<ClosureObject> getClosureData(Connection conn, String longNumber) throws SQLException, EASBizException {
        if (conn == null) {
            throw new EASBizException(EASBizException.CHECKBLANK, (Object[])new String[]{PARAMETER});
        }
        List<ClosureObject> closure = null;
        closure = this.MBGINDEX_TYPE == this.getDATA_TYPE() || this.MBGEXTDIM_TYPE == this.getDATA_TYPE() ? this.getClosureDataByNumber(conn, longNumber) : this.getClosureDataById(conn);
        return closure;
    }

    private List<ClosureObject> getClosureDataById(Connection conn) throws SQLException, EASBizException {
        if (conn == null) {
            throw new EASBizException(EASBizException.CHECKBLANK, (Object[])new String[]{PARAMETER});
        }
        ArrayList<ClosureObject> closure = new ArrayList<ClosureObject>();
        IRowSet rst = null;
        ClosureObject object = null;
        try {
            rst = BgDBUtils.executeQuery(conn, "select FID, FNumber, FLONGNUMBER, FPARENTID from " + this.getVirTable() + " order by FLONGNUMBER");
            while (rst.next()) {
                object = new ClosureObject();
                object.setId(rst.getString(1));
                object.setNumber(rst.getString(2));
                object.setLongNumber(rst.getString(3));
                object.setParentId(rst.getString(4));
                closure.add(object);
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"getClosureDataById Error:", (Throwable)ex);
                throw ex;
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst);
        return closure;
    }

    private List<ClosureObject> getClosureDataByNumber(Connection conn, String longNumber) throws SQLException, EASBizException {
        if (conn == null) {
            throw new EASBizException(EASBizException.CHECKBLANK, (Object[])new String[]{PARAMETER});
        }
        ArrayList<ClosureObject> closure = new ArrayList<ClosureObject>();
        IRowSet rst = null;
        ClosureObject object = null;
        try {
            rst = StringUtils.isEmpty((String)longNumber) ? BgDBUtils.executeQuery(conn, "select FDIMNUMBER, FDIMLONGNUMBER, FPARENTNUMBER from " + this.getVirTable() + " order by FDIMLONGNUMBER") : BgDBUtils.executeQuery(conn, "select FDIMNUMBER, FDIMLONGNUMBER, FPARENTNUMBER from " + this.getVirTable() + " where FLONGNUMBER = ? or FLONGNUMBER like ? order by FLONGNUMBER", new Object[]{longNumber, longNumber + "!%"});
            while (rst.next()) {
                object = new ClosureObject();
                object.setNumber(rst.getString(1));
                object.setLongNumber(rst.getString(2));
                object.setParentNumber(rst.getString(3));
                closure.add(object);
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"getClosureDataByNumber Error:", (Throwable)ex);
                throw ex;
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst);
        return closure;
    }

    private Map<String, ClosureData> getClosureDataMap(List<ClosureObject> closures) {
        HashMap<String, ClosureData> dataMap = new HashMap<String, ClosureData>();
        if (closures == null || closures.isEmpty()) {
            return dataMap;
        }
        ClosureObject object = null;
        ClosureData data = null;
        int in = closures.size();
        block0: for (int i = 0; i < in; ++i) {
            object = closures.get(i);
            if ((StringUtils.isEmpty((String)object.getParentNumber()) || this.getAccPrefix().equals(object.getParentNumber())) && object.getParentId() == null) {
                dataMap.put(object.getLongNumber(), new ClosureData(object));
                continue;
            }
            Map.Entry entry2 = null;
            for (Map.Entry entry2 : dataMap.entrySet()) {
                if (object.getLongNumber() == null || !object.getLongNumber().startsWith((String)entry2.getKey() + BgBaseConstants.SEP_ONE_STR)) continue;
                data = (ClosureData)entry2.getValue();
                if (object.getParentId() != null) {
                    data.addChildren(object);
                    continue block0;
                }
                data.addChildrenByNumber(object);
                continue block0;
            }
        }
        return dataMap;
    }

    private List<ClosureData> ergodicClosureData(Map<String, ClosureData> closureDataMap) {
        if (closureDataMap == null || closureDataMap.isEmpty()) {
            return null;
        }
        ClosureData closureData2 = null;
        ClosureData _tmpData = null;
        ArrayList<ClosureData> closureDatas = new ArrayList<ClosureData>();
        for (ClosureData closureData2 : closureDataMap.values()) {
            if (!closureData2.getObject().isVirtual()) {
                _tmpData = new ClosureData();
                _tmpData.getObject().setId(closureData2.getObject().getId());
                _tmpData.getObject().setParentId(closureData2.getObject().getId());
                _tmpData.getObject().setNumber(closureData2.getObject().getNumber());
                _tmpData.getObject().setParentNumber(closureData2.getObject().getNumber());
                _tmpData.getObject().setLongNumber(closureData2.getObject().getNumber() + "_" + closureData2.getObject().getNumber());
                _tmpData.setLevel(closureData2.getLevel());
                closureDatas.add(_tmpData);
            }
            this.ergodicClosureData(closureData2, closureDatas);
        }
        return closureDatas;
    }

    private void ergodicClosureData(ClosureData closureData, List<ClosureData> closureDatas) {
        if (closureData == null || closureDatas == null) {
            return;
        }
        this.ergodicClosureData(closureData, closureData.getChildren(), closureDatas);
        if (!closureData.getChildren().isEmpty()) {
            ClosureData _tmpData = null;
            ClosureData _closureData2 = null;
            for (ClosureData _closureData2 : closureData.getChildren().values()) {
                if (!_closureData2.getObject().isVirtual()) {
                    _tmpData = new ClosureData();
                    _tmpData.getObject().setId(_closureData2.getObject().getId());
                    _tmpData.getObject().setParentId(_closureData2.getObject().getId());
                    _tmpData.getObject().setNumber(_closureData2.getObject().getNumber());
                    _tmpData.getObject().setParentNumber(_closureData2.getObject().getNumber());
                    _tmpData.getObject().setLongNumber(_closureData2.getObject().getNumber() + "_" + _closureData2.getObject().getNumber());
                    _tmpData.setLevel(_closureData2.getLevel() - _closureData2.getLevel());
                    closureDatas.add(_tmpData);
                }
                this.ergodicClosureData(_closureData2, closureDatas);
            }
        }
    }

    private void ergodicClosureData(ClosureData root, Map<String, ClosureData> children, List<ClosureData> closureDatas) {
        if (root == null || children == null || closureDatas == null) {
            return;
        }
        ClosureData _tmpData = null;
        ClosureData _closureData2 = null;
        for (ClosureData _closureData2 : children.values()) {
            if (!_closureData2.getObject().isVirtual()) {
                _tmpData = new ClosureData();
                _tmpData.getObject().setId(_closureData2.getObject().getId());
                _tmpData.getObject().setParentId(root.getObject().getId());
                _tmpData.getObject().setNumber(_closureData2.getObject().getNumber());
                _tmpData.getObject().setParentNumber(root.getObject().getNumber());
                _tmpData.getObject().setLongNumber(root.getObject().getNumber() + "_" + _closureData2.getObject().getNumber());
                _tmpData.setLevel(_closureData2.getLevel() - root.getLevel());
                closureDatas.add(_tmpData);
            }
            this.ergodicClosureData(root, _closureData2.getChildren(), closureDatas);
        }
    }

    private void saveClosureData(Connection conn, String closureTable, List<ClosureData> closureDatas) throws SQLException, EASBizException {
        if (conn == null || StringUtils.isEmpty((String)closureTable)) {
            throw new EASBizException(EASBizException.CHECKBLANK, (Object[])new String[]{PARAMETER});
        }
        if (closureDatas == null || closureDatas.isEmpty()) {
            return;
        }
        String key = null;
        HashSet<String> tmpSet = new HashSet<String>();
        PreparedStatement pstmt = null;
        ClosureData closureData = null;
        int batchIndex = 0;
        try {
            BgDBUtils.executeUpdate(conn, "Truncate table " + closureTable);
            pstmt = conn.prepareStatement("Insert Into " + closureTable + "(FID, FChildId, distance) values (?, ?, ?)");
            int in = closureDatas.size();
            for (int i = 0; i < in; ++i) {
                closureData = closureDatas.get(i);
                if (closureData.getObject().getId() == null) {
                    key = closureData.getObject().getParentNumber() + "_" + closureData.getObject().getNumber();
                    if (!tmpSet.contains(key)) {
                        tmpSet.add(key);
                        pstmt.setString(1, closureData.getObject().getParentNumber());
                        pstmt.setString(2, closureData.getObject().getNumber());
                        pstmt.setInt(3, closureData.getLevel());
                        pstmt.addBatch();
                        ++batchIndex;
                    }
                } else {
                    key = closureData.getObject().getParentId() + "_" + closureData.getObject().getId();
                    if (!tmpSet.contains(key)) {
                        tmpSet.add(key);
                        pstmt.setString(1, closureData.getObject().getParentId());
                        pstmt.setString(2, closureData.getObject().getId());
                        pstmt.setInt(3, closureData.getLevel());
                        pstmt.addBatch();
                        ++batchIndex;
                    }
                }
                if (batchIndex <= 50) continue;
                pstmt.executeBatch();
                batchIndex = 0;
            }
            if (batchIndex != 0) {
                pstmt.executeBatch();
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"saveClosureData Data Error:", (Throwable)ex);
                throw ex;
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt);
    }

    private String getFactType(BOSUuid uuid) {
        String factType = null;
        BOSObjectType type = uuid.getType();
        if (type != null) {
            if (type.equals((Object)new BgAccountViewInfo().getBOSType())) {
                this.setDATA_TYPE(this.MBGINDEX_TYPE);
                factType = MBGINDEX_TABLE;
            } else if (type.equals((Object)new MbgViewInfo().getBOSType())) {
                this.setDATA_TYPE(this.MBGEXTDIM_TYPE);
                factType = MBGEXTDIM_TABLE;
            } else if (type.equals((Object)new OrgTreeInfo().getBOSType())) {
                this.setDATA_TYPE(this.MBGUNION_TYPE);
                factType = MBGUNION_TABLE;
            }
        }
        return factType;
    }

    private String getFactTable(String factType, DecimalFormat df, Random random) throws EASBizException {
        if (StringUtils.isEmpty((String)factType) || df == null || random == null) {
            throw new EASBizException(EASBizException.CHECKBLANK, (Object[])new String[]{PARAMETER});
        }
        SecureRandom sRandom = new SecureRandom();
        this.setVirNo(df.format(sRandom.nextInt(99999999)));
        return factType + this.getVirNo() + TAG_FACT;
    }

    public static String getClosureTable(String factTable) throws EASBizException {
        if (!StringUtils.isEmpty((String)factTable)) {
            return factTable.replaceFirst(TAG_FACT, TAG_CLOSURE);
        }
        return null;
    }

    private String getFactIndex(String factTable) throws EASBizException {
        if (StringUtils.isEmpty((String)factTable)) {
            throw new EASBizException(EASBizException.CHECKBLANK, (Object[])new String[]{PARAMETER});
        }
        String index = null;
        if (this.MBGINDEX_TYPE == this.getDATA_TYPE()) {
            index = MBGINDEX_INDEX + this.getVirNo();
        } else if (this.MBGEXTDIM_TYPE == this.getDATA_TYPE()) {
            index = MBGEXTDIM_INDEX + this.getVirNo();
        } else if (this.MBGUNION_TYPE == this.getDATA_TYPE()) {
            index = MBGUNION_INDEX + this.getVirNo();
        }
        return index;
    }

    public void checkBgOrgClosure(Context ctx, BOSUuid bgOrgViewId) throws BOSException, EASBizException {
        if (ctx == null || bgOrgViewId == null || MbgVirtualView.checkIsUpdating(ctx)) {
            return;
        }
        MbgOrgUnitView mbgOrgImpl = new MbgOrgUnitView(ctx, bgOrgViewId);
        mbgOrgImpl.start();
    }

    public void checkBgOrgBaseClosure(Context ctx) throws BOSException, EASBizException {
        if (ctx == null) {
            return;
        }
        MbgOrgUnitView mbgOrgImpl = new MbgOrgUnitView(ctx, null);
        mbgOrgImpl.checkBgOrgBaseSnap();
    }

    public static boolean checkIsUpdating(Context ctx) {
        return ctx != null && ctx.get((Object)"MBG_IS_UPDATING") != null;
    }

    public static String getBgOrgFactTable(String orgViewSnap) {
        return BGORG_TABLE_KEY + orgViewSnap + TAG_FACT;
    }

    public static String getBgOrgClosureTable(String orgViewSnap) {
        return BGORG_TABLE_KEY + orgViewSnap + TAG_CLOSURE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkUnionDebt(Context ctx, List<BOSUuid> unionIds) throws BOSException, EASBizException {
        if (ctx == null || unionIds == null || unionIds.isEmpty()) {
            return;
        }
        Connection conn = null;
        try {
            conn = BgDBUtils.getConnection(ctx);
            for (BOSUuid unionId : unionIds) {
                this.checkUnionDebt(ctx, conn, unionId);
            }
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
    }

    private void checkUnionDebt(Context ctx, Connection conn, BOSUuid unionId) throws BOSException, EASBizException {
        if (ctx == null || conn == null || unionId == null) {
            return;
        }
        try {
            this.checkVirTable(conn, unionId);
            this.checkFact(conn, unionId);
        }
        catch (SQLException ex) {
            logger.error((Object)"checkUnionDebt sql error:", (Throwable)ex);
            throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
        }
    }

    public class ClosureData {
        private ClosureObject object = null;
        private Map<String, ClosureData> children = null;
        private int level = 0;

        public ClosureData() {
            this.object = new ClosureObject();
        }

        public ClosureData(ClosureObject object) {
            this.object = object;
        }

        public void setObject(ClosureObject object) {
            this.object = object;
        }

        public ClosureObject getObject() {
            return this.object;
        }

        public void setChildren(Map<String, ClosureData> children) {
            this.children = children;
        }

        public Map<String, ClosureData> getChildren() {
            if (this.children == null) {
                this.children = new HashMap<String, ClosureData>();
            }
            return this.children;
        }

        public void addChildren(ClosureObject object) {
            if (object == null) {
                return;
            }
            if (object.getParentId().equals(this.getObject().getId())) {
                object.setParentNumber(this.getObject().getNumber());
                if (!this.getChildren().containsKey(object.getLongNumber())) {
                    ClosureData data = new ClosureData(object);
                    data.setLevel(this.getLevel() + 1);
                    this.getChildren().put(object.getLongNumber(), data);
                }
            } else {
                this.addChildren(this, object);
            }
        }

        private void addChildren(ClosureData data, ClosureObject object) {
            if (data == null || object == null) {
                return;
            }
            Map.Entry<String, ClosureData> entry2 = null;
            String longnumber = null;
            ClosureData closureData = null;
            for (Map.Entry<String, ClosureData> entry2 : data.getChildren().entrySet()) {
                longnumber = entry2.getKey();
                closureData = entry2.getValue();
                if (object.getParentId().equals(closureData.getObject().getId())) {
                    closureData.addChildren(object);
                    continue;
                }
                if (!object.getLongNumber().startsWith(longnumber)) continue;
                this.addChildren(closureData, object);
            }
        }

        public void addChildrenByNumber(ClosureObject object) {
            if (object == null) {
                return;
            }
            if (object.getParentNumber().equals(this.getObject().getNumber())) {
                if (!this.getChildren().containsKey(object.getLongNumber())) {
                    ClosureData data = new ClosureData(object);
                    data.setLevel(this.getLevel() + 1);
                    this.getChildren().put(object.getLongNumber(), data);
                }
            } else {
                this.addChildrenByNumber(this, object);
            }
        }

        private void addChildrenByNumber(ClosureData data, ClosureObject object) {
            if (data == null || object == null) {
                return;
            }
            Map.Entry<String, ClosureData> entry2 = null;
            String longnumber = null;
            ClosureData closureData = null;
            for (Map.Entry<String, ClosureData> entry2 : data.getChildren().entrySet()) {
                longnumber = entry2.getKey();
                closureData = entry2.getValue();
                if (object.getParentNumber().equals(closureData.getObject().getNumber())) {
                    closureData.addChildrenByNumber(object);
                    continue;
                }
                if (!object.getLongNumber().startsWith(longnumber)) continue;
                this.addChildrenByNumber(closureData, object);
            }
        }

        public void addChildrenById(ClosureData object) {
            if (object == null) {
                return;
            }
            if (object.getObject().getParentId().equals(this.getObject().getId()) && !this.getChildren().containsKey(object.getObject().getId())) {
                object.setLevel(this.getLevel() + 1);
                this.getChildren().put(object.getObject().getId(), object);
            }
        }

        public void setLevel(int level) {
            this.level = level;
        }

        public int getLevel() {
            return this.level;
        }
    }

    public class BgOrgUnitObject
    extends ClosureObject {
        private String orgUnitId;
        private String pOrgUnitId;

        public BgOrgUnitObject() {
            this.orgUnitId = null;
            this.pOrgUnitId = null;
        }

        public void setOrgUnitId(String orgUnitId) {
            this.orgUnitId = orgUnitId;
        }

        public String getOrgUnitId() {
            return this.orgUnitId;
        }

        public void setPOrgUnitId(String pOrgUnitId) {
            this.pOrgUnitId = pOrgUnitId;
        }

        public String getPOrgUnitId() {
            return this.pOrgUnitId;
        }
    }

    public class ClosureObject {
        private String Id = null;
        private String parentId = null;
        private String number = null;
        private String parentNumber = null;
        private String longNumber = null;
        private boolean leaf = false;
        private boolean virtual = false;

        public void setId(String id) {
            this.Id = id;
        }

        public String getId() {
            return this.Id;
        }

        public void setParentId(String parentId) {
            this.parentId = parentId;
        }

        public String getParentId() {
            return this.parentId;
        }

        public void setNumber(String number) {
            this.number = number;
        }

        public String getNumber() {
            return this.number;
        }

        public void setParentNumber(String parentNumber) {
            this.parentNumber = parentNumber;
        }

        public String getParentNumber() {
            return this.parentNumber;
        }

        public void setLongNumber(String longNumber) {
            this.longNumber = longNumber;
        }

        public String getLongNumber() {
            return this.longNumber;
        }

        public void setLeaf(boolean leaf) {
            this.leaf = leaf;
        }

        public boolean isLeaf() {
            return this.leaf;
        }

        public void setVirtual(boolean virtual) {
            this.virtual = virtual;
        }

        public boolean isVirtual() {
            return this.virtual;
        }

        public String toString() {
            return this.getNumber() + "(" + this.getLongNumber() + ")";
        }
    }

    class MbgOrgUnitView
    extends Thread {
        private Context ctx = null;
        private BOSUuid bgOrgViewId = null;

        private String getBgOrgFactIndex(String orgViewSnap) {
            return MbgVirtualView.BGORG_F_PK_KEY + orgViewSnap;
        }

        public MbgOrgUnitView(Context ctx, BOSUuid bgOrgViewId) {
            this.ctx = ctx;
            this.bgOrgViewId = bgOrgViewId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            super.run();
            if (this.ctx == null || this.bgOrgViewId == null) {
                return;
            }
            String snapVar = null;
            Connection conn = null;
            try {
                conn = BgDBUtils.getConnection(this.ctx);
                snapVar = MbgVirtualView.getMbgOrgUnitSnap(conn, this.bgOrgViewId);
                snapVar = this.checkBgOrgSnap(conn, this.bgOrgViewId, snapVar);
                if (MbgVirtualView.checkIsUpdating(this.ctx)) {
                    return;
                }
                this.checkBgOrgFact(conn, this.bgOrgViewId, snapVar);
                this.checkBgOrgClosure(this.ctx, conn, this.bgOrgViewId, snapVar);
            }
            catch (Exception ex) {
                logger.error((Object)"checkBgOrgClosure Sql Error", (Throwable)ex);
            }
            finally {
                SQLUtils.cleanup((Connection)conn);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String checkBgOrgSnap(Connection conn, BOSUuid bgOrgViewId, String snapShotVar) throws SQLException {
            if (conn == null || bgOrgViewId == null || !StringUtils.isEmpty((String)snapShotVar) && !MbgVirtualView.BASE_SNAP_VER.equals(snapShotVar)) {
                return snapShotVar;
            }
            IRowSet rst = null;
            String snapVer = null;
            try {
                rst = BgDBUtils.executeQuery(conn, "select max(FSnapshotvar) from T_MBG_BgOrgView");
                if (rst.next()) {
                    snapVer = rst.getString(1);
                }
                if (snapVer == null) {
                    snapVer = MbgVirtualView.BASE_SNAP_VER;
                }
                int tmpValue = new Integer(snapVer) + 1;
                snapVer = new DecimalFormat("####").format(tmpValue);
                BgDBUtils.executeUpdate(conn, "Update T_MBG_BgOrgView set FSnapshotvar = ? where FID = ?", new Object[]{snapVer, bgOrgViewId.toString()});
            }
            finally {
                SQLUtils.cleanup((ResultSet)rst);
            }
            return snapVer;
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void checkBgOrgBaseSnap() throws BOSException, EASBizException {
            if (MbgVirtualView.this.getCtx() == null) {
                return;
            }
            Connection conn = null;
            IRowSet rst = null;
            try {
                conn = BgDBUtils.getConnection(MbgVirtualView.this.getCtx());
                rst = BgDBUtils.executeQuery(conn, "select FID from T_MBG_BgOrgView where FSnapshotvar = ?", new Object[]{MbgVirtualView.BASE_SNAP_VER});
                if (rst.next()) {
                    BOSUuid bgOrgViewId = BOSUuid.read((String)rst.getString(1));
                    this.checkBgOrgSnap(conn, bgOrgViewId, null);
                    MbgOrgUnitView mbgOrgImpl = new MbgOrgUnitView(MbgVirtualView.this.getCtx(), bgOrgViewId);
                    mbgOrgImpl.start();
                }
            }
            catch (SQLDataException ex) {
                try {
                    throw new BOSException((Throwable)ex);
                    catch (SQLException ex2) {
                        throw new BgException(BgException.DATABASEERROR, new String[]{ex2.getMessage()});
                    }
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rst, null, (Connection)conn);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)rst, null, (Connection)conn);
        }

        private void checkBgOrgFact(Connection conn, BOSUuid bgOrgViewId, String snapVar) throws SQLException, EASBizException {
            if (conn == null || bgOrgViewId == null || StringUtils.isEmpty((String)snapVar)) {
                throw new EASBizException(EASBizException.CHECKBLANK, (Object[])new String[]{MbgVirtualView.PARAMETER});
            }
            String bgOrgFact = this.checkBgOrgFactTable(conn, snapVar);
            this.checkBgOrgFactData(conn, bgOrgViewId, bgOrgFact);
        }

        private String checkBgOrgFactTable(Connection conn, String snapVar) throws SQLException {
            if (conn == null || snapVar == null) {
                return null;
            }
            String bgOrgFact = MbgVirtualView.getBgOrgFactTable(snapVar);
            int re = BgDBUtils.existTable(conn, bgOrgFact);
            if (re == BgDBUtils.NO) {
                String OPIndexName;
                String OLIndexName;
                StringBuffer sql = new StringBuffer();
                sql.append("Create Table " + bgOrgFact + " (FID VARCHAR(44) DEFAULT '' NOT NULL, FNUMBER NVARCHAR(80) DEFAULT '' NOT NULL, FLONGNUMBER NVARCHAR(1000), FISLEAF INT DEFAULT 0, FPARENTID VARCHAR(44), FBgOrgUnitId VARCHAR(44), CONSTRAINT " + this.getBgOrgFactIndex(snapVar) + " PRIMARY KEY (FID))");
                BgDBUtils.executeUpdate(conn, sql.toString());
                String uxIndexName = "IX_MBG_ON" + snapVar;
                int check = BgDBUtils.existIndex(conn, bgOrgFact, uxIndexName);
                if (check == BgDBUtils.NO) {
                    try {
                        BgDBUtils.executeUpdate(conn, "CREATE INDEX " + uxIndexName + " ON " + bgOrgFact + " (FNUMBER)");
                    }
                    catch (SQLException ex) {
                        logger.error((Object)"checkFactTable Sql Error:", (Throwable)ex);
                    }
                }
                if ((check = BgDBUtils.existIndex(conn, bgOrgFact, OLIndexName = "IX_MBG_OL" + snapVar)) == BgDBUtils.NO) {
                    try {
                        BgDBUtils.executeUpdate(conn, "CREATE INDEX " + OLIndexName + " ON " + bgOrgFact + " (FLONGNUMBER)");
                    }
                    catch (SQLException ex) {
                        logger.error((Object)"checkFactTable Sql Error:", (Throwable)ex);
                    }
                }
                if ((re = BgDBUtils.existIndex(conn, bgOrgFact, OPIndexName = "IX_MBG_OP" + snapVar)) == BgDBUtils.NO) {
                    try {
                        BgDBUtils.executeUpdate(conn, "CREATE INDEX " + OPIndexName + " ON " + bgOrgFact + " (FPARENTID)");
                    }
                    catch (SQLException ex) {
                        logger.error((Object)"checkFactTable Sql Error:", (Throwable)ex);
                    }
                }
            }
            if ((re = BgDBUtils.existColumn(conn, bgOrgFact, "FLONGNUMBER")) == BgDBUtils.NO) {
                BgDBUtils.executeUpdate(conn, "alter table " + bgOrgFact + " add FLONGNUMBER NVARCHAR(1000)");
            }
            if ((re = BgDBUtils.existColumn(conn, bgOrgFact, "FBgOrgUnitId")) == BgDBUtils.NO) {
                BgDBUtils.executeUpdate(conn, "alter table " + bgOrgFact + " add FBgOrgUnitId VARCHAR(44)");
                String OGIndexName = "IX_MBG_OG" + snapVar;
                re = BgDBUtils.existIndex(conn, bgOrgFact, OGIndexName);
                if (re == BgDBUtils.NO) {
                    try {
                        BgDBUtils.executeUpdate(conn, "CREATE INDEX " + OGIndexName + " ON " + bgOrgFact + " (FBgOrgUnitId)");
                    }
                    catch (SQLException ex) {
                        logger.error((Object)"checkFactTable Sql Error:", (Throwable)ex);
                    }
                }
            }
            if ((re = BgDBUtils.existColumn(conn, bgOrgFact, "FISLEAF")) == BgDBUtils.NO) {
                BgDBUtils.executeUpdate(conn, "alter table " + bgOrgFact + " add FISLEAF INT DEFAULT 0");
            }
            return bgOrgFact;
        }

        private void checkBgOrgFactData(Connection conn, BOSUuid bgOrgViewId, String bgOrgFact) throws SQLException {
            if (conn == null || StringUtils.isEmpty((String)bgOrgFact)) {
                return;
            }
            BgDBUtils.executeUpdate(conn, "Truncate table " + bgOrgFact);
            StringBuffer sql = new StringBuffer();
            sql.append("Insert Into " + bgOrgFact + " (FID, FNUMBER, FLONGNUMBER, FISLEAF, FPARENTID, FBgOrgUnitId) select t.FOrgUnitId, t.FNumber, t.FLongNumber, t.FIsLeaf, p.FOrgUnitId, t.FID from T_MBG_BgOrgUnit t left join T_MBG_BgOrgUnit p on t.FParentId = p.FID where t.FViewId = ? and t.FISVIRTUAL = 0");
            BgDBUtils.executeUpdate(conn, sql.toString(), new Object[]{bgOrgViewId.toString()});
        }

        private String checkBgOrgClosureTable(Connection conn, String snapVar) throws SQLException {
            if (conn == null || snapVar == null) {
                return null;
            }
            String bgOrgClosure = MbgVirtualView.getBgOrgClosureTable(snapVar);
            int re = BgDBUtils.existTable(conn, bgOrgClosure);
            if (re == BgDBUtils.NO) {
                String ixIndex;
                StringBuffer sql = new StringBuffer();
                sql.append("Create Table " + bgOrgClosure + " (FID VARCHAR(44) DEFAULT '' NOT NULL, FChildId VARCHAR(44) DEFAULT '' NOT NULL, distance INT DEFAULT 0 NOT NULL)");
                BgDBUtils.executeUpdate(conn, sql.toString());
                String uxIndex = MbgVirtualView.BGORG_C_UNINDEX_KEY + snapVar;
                int check = BgDBUtils.existIndex(conn, bgOrgClosure, uxIndex);
                if (check == BgDBUtils.NO) {
                    BgDBUtils.executeUpdate(conn, "CREATE UNIQUE INDEX " + uxIndex + " ON " + bgOrgClosure + " (FID, FChildId)");
                }
                if ((check = BgDBUtils.existIndex(conn, bgOrgClosure, ixIndex = MbgVirtualView.BGORG_C_INDEX_KEY + snapVar)) == BgDBUtils.NO) {
                    BgDBUtils.executeUpdate(conn, "CREATE INDEX " + ixIndex + " ON " + bgOrgClosure + " (FChildId)");
                }
            }
            return bgOrgClosure;
        }

        private void checkBgOrgClosure(Context ctx, Connection conn, BOSUuid bgOrgViewId, String snapVar) throws BOSException, EASBizException, SQLException {
            if (ctx == null || conn == null || bgOrgViewId == null || StringUtils.isEmpty((String)snapVar)) {
                throw new EASBizException(EASBizException.CHECKBLANK, (Object[])new String[]{MbgVirtualView.PARAMETER});
            }
            String bgOrgClosure = this.checkBgOrgClosureTable(conn, snapVar);
            this.checkBgOrgClosureData(ctx, conn, bgOrgViewId, bgOrgClosure, snapVar);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void checkBgOrgClosureData(Context ctx, Connection conn, BOSUuid bgOrgViewId, String bgOrgClosure, String snapVar) throws BOSException, SQLException, EASBizException {
            if (ctx == null) return;
            if (conn == null) return;
            if (conn == null) return;
            if (StringUtils.isEmpty((String)bgOrgClosure)) return;
            if (snapVar == null) {
                return;
            }
            BgDBUtils.executeUpdate(conn, "Truncate table " + bgOrgClosure);
            String sql = null;
            BgOrgUnitObject object = null;
            ClosureData closureData = null;
            ClosureData parData = null;
            HashMap<String, BgOrgUnitObject> bgOrgUnitMap = new HashMap<String, BgOrgUnitObject>();
            HashMap<String, ClosureData> bgOrgMap = new HashMap<String, ClosureData>();
            ArrayList<ClosureData> bgOrgRoots = new ArrayList<ClosureData>();
            IRowSet rst = null;
            try {
                sql = "select t.FID, t.FParentId, t.FOrgUnitId, p.FOrgUnitId, t.FNumber, t.FLongNumber, t.FIsLeaf, t.FIsVirtual from T_MBG_BgOrgUnit t left join T_MBG_BgOrgUnit p on t.FParentId = p.FID where t.FViewId = ? order by t.FLongNumber";
                rst = BgDBUtils.executeQuery(conn, sql, new Object[]{bgOrgViewId.toString()});
                while (rst.next()) {
                    object = new BgOrgUnitObject();
                    object.setId(rst.getString(1));
                    object.setParentId(rst.getString(2));
                    object.setOrgUnitId(rst.getString(3));
                    object.setPOrgUnitId(rst.getString(4));
                    object.setNumber(rst.getString("FNumber"));
                    object.setLongNumber(rst.getString("FLongNumber"));
                    object.setLeaf(rst.getBoolean("FIsLeaf"));
                    object.setVirtual(rst.getBoolean("FIsVirtual"));
                    bgOrgUnitMap.put(object.getId(), object);
                    closureData = new ClosureData(object);
                    bgOrgMap.put(closureData.getObject().getId(), closureData);
                    if (object.getParentId() != null) {
                        parData = (ClosureData)bgOrgMap.get(closureData.getObject().getParentId());
                        parData.addChildrenById(closureData);
                        continue;
                    }
                    bgOrgRoots.add(closureData);
                }
                SQLUtils.cleanup((ResultSet)rst);
            }
            catch (SQLException ex) {
                logger.error((Object)"query MbgOrgUnit Data Error:", (Throwable)ex);
                throw ex;
                catch (Exception ex2) {
                    logger.error((Object)"query MbgOrgUnit Data Error:", (Throwable)ex2);
                }
            }
            finally {
                SQLUtils.cleanup(rst);
            }
            if (bgOrgRoots.size() > 50) {
                throw new MbgDimException(MbgDimException.ORGUNITTREESIZEISOVER);
            }
            String tSnap = null;
            String tFactTable = null;
            String tClosureTable = null;
            String tmpSnapVar = "";
            int i = 0;
            int in = bgOrgRoots.size();
            while (true) {
                if (i >= in) {
                    BgDBUtils.executeUpdate(conn, "update T_MBG_BgOrgView set FSnapTreeVar = ? where FID = ?", new Object[]{tmpSnapVar, bgOrgViewId.toString()});
                    return;
                }
                closureData = (ClosureData)bgOrgRoots.get(i);
                tSnap = snapVar + TableToolkit.int2pos((int)i);
                tFactTable = this.checkBgOrgFactTable(conn, tSnap);
                tClosureTable = this.checkBgOrgClosureTable(conn, tSnap);
                this.buildOrgClosure(ctx, conn, bgOrgViewId.toString(), tFactTable, tClosureTable, closureData);
                tmpSnapVar = tmpSnapVar + closureData.getObject().getId() + BgBaseConstants.SEP_ONE_STR + tSnap + BgBaseConstants.SEP_THR_STR;
                BgDBUtils.executeUpdate(conn, "Insert Into " + bgOrgClosure + " (FID, FChildId, distance)  select t.FID, t.FChildId, t.distance from " + tClosureTable + " t  where not exists (select * from " + bgOrgClosure + " where FID = t.FID and FChildId = t.FChildId)");
                ++i;
            }
        }

        private void buildOrgClosure(Context ctx, Connection conn, String orgViewId, String orgFactTable, String orgClosureTable, ClosureData closureData) throws BOSException, SQLException {
            if (conn == null || StringUtils.isEmpty((String)orgViewId) || StringUtils.isEmpty((String)orgFactTable) || StringUtils.isEmpty((String)orgClosureTable) || closureData == null) {
                return;
            }
            HashSet<String> bgOrgIds = new HashSet<String>();
            List<Object> bgOrgUnits = new ArrayList();
            this.buildOrgClosure(closureData, bgOrgIds);
            TempTablePool pool = TempTablePool.getInstance((Context)ctx);
            String tmpTable = null;
            try {
                tmpTable = BgDBUtils.createTmpTable(ctx, pool, "CREATE TABLE TEML_KSQL_0 (FID VARCHAR(44))");
                if (tmpTable != null) {
                    BgDBUtils.insertKey(conn, "Insert Into " + tmpTable + " (FID) values (?)", bgOrgIds);
                }
                BgDBUtils.executeUpdate(conn, "Truncate table " + orgFactTable);
                String sql = "Insert Into " + orgFactTable + " (FID, FNUMBER, FLONGNUMBER, FISLEAF, FPARENTID, FBgOrgUnitId) select t.FOrgUnitId, t.FNumber, t.FLongNumber, t.FIsLeaf, p.FOrgUnitId, t.FID from T_MBG_BgOrgUnit t left join T_MBG_BgOrgUnit p on t.FParentId = p.FID where t.FViewId = ? AND t.FId IN (select FID from " + tmpTable + ")";
                BgDBUtils.executeUpdate(conn, sql, new Object[]{orgViewId});
                bgOrgUnits = this.getClosureDataByBgOrgUnit(conn, orgFactTable);
                Map closureMap = MbgVirtualView.this.getClosureDataMap(bgOrgUnits);
                List closureDatas = MbgVirtualView.this.ergodicClosureData(closureMap);
                MbgVirtualView.this.saveClosureData(conn, orgClosureTable, closureDatas);
            }
            catch (SQLException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new BOSException((Throwable)ex);
            }
            finally {
                BgDBUtils.releaseTmpTable(pool, tmpTable);
            }
        }

        private void buildOrgClosure(ClosureData closureData, Set<String> bgOrgIds) {
            if (closureData == null || bgOrgIds == null) {
                return;
            }
            bgOrgIds.add(closureData.getObject().getId());
            ClosureData child2 = null;
            for (ClosureData child2 : closureData.getChildren().values()) {
                this.buildOrgClosure(child2, bgOrgIds);
            }
        }

        private List<ClosureObject> getClosureDataByBgOrgUnit(Connection conn, String orgFactTable) throws SQLException {
            ArrayList<ClosureObject> bgOrgUnits = new ArrayList<ClosureObject>();
            if (conn == null || StringUtils.isEmpty((String)orgFactTable)) {
                return bgOrgUnits;
            }
            PreparedStatement pstmt = null;
            ResultSet rst = null;
            ClosureObject object = null;
            String sql = null;
            try {
                sql = "select t.FID, t.FParentId, t.FNumber, t.FLongNumber from " + orgFactTable + " t order by t.FLongNumber";
                pstmt = conn.prepareStatement(sql);
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    object = new ClosureObject();
                    object.setId(rst.getString(1));
                    object.setParentId(rst.getString(2));
                    object.setNumber(rst.getString(3));
                    object.setLongNumber(rst.getString(4));
                    bgOrgUnits.add(object);
                }
            }
            catch (SQLException ex) {
                try {
                    logger.error((Object)"query MbgOrgUnit Data Error:", (Throwable)ex);
                    throw ex;
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rst, pstmt);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
            return bgOrgUnits;
        }
    }
}

