/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bg;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectCollectionChangeListener;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.IObjectValueChangeListener;
import com.kingdee.bos.dao.ObjectCollectionChangeEvent;
import com.kingdee.bos.dao.ObjectValueChangeEvent;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.data.ColumnInfo;
import com.kingdee.bos.metadata.data.DataTableInfo;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.bg.BgEntityAccess;
import com.kingdee.eas.ma.bg.BgHelper;
import com.kingdee.eas.ma.bg.BgORMException;
import com.kingdee.eas.ma.bg.SingleVOCache;
import com.kingdee.util.db.SQLUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;

public class BgORMEngine {
    private static final String _ISBGORM = "_isbgorm";
    private static final String _MAINPROPERTYARY = "_mainpropertyary";
    private static final String _REMOVELIST_ = "_removelist_";
    private static final String _ORMOBJECTARY = "_ormobjectary";
    private static final String _ISNEW = "_isnew";
    private static final String SELECT = " select ";
    private static final String LISENERPROPERTY = "_lisenerproperty";
    private static final String ISLISENER = "_islisener";
    private static final String ISCHANGED = "_ischanged";
    private static final String DELETE_FROM = " delete from ";
    private static final String WHERE = " where ";
    private static final String EQUAL_QUEST = " =? ";
    private static final String ENTITY_PK_NAME = "id";
    public static final BOSUuid[] BOSUUIDARY = new BOSUuid[0];

    public static String getDBFieldName(Context ctx, PropertyInfo pro) {
        ColumnInfo mapF = pro.getMappingField();
        String fieldName = null;
        if (pro.getBoolean("isMultilingual")) {
            fieldName = mapF.getName() + "_" + ctx.getLocale().toString();
        } else if (mapF != null) {
            fieldName = mapF.getName();
        }
        return fieldName;
    }

    public static IObjectValue newVO(IObjectValue vo) {
        AbstractObjectValue avo = null;
        try {
            avo = (AbstractObjectValue)vo.getClass().newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        avo.put(ENTITY_PK_NAME, vo.get(ENTITY_PK_NAME));
        Enumeration enums = vo.keys();
        while (enums.hasMoreElements()) {
            String key = enums.nextElement().toString();
            Object o = vo.get(key);
            if (o == null) continue;
            if (o instanceof IObjectValue) {
                avo.put(key, (Object)SingleVOCache.getSingleVO((IObjectValue)o));
                continue;
            }
            if (o instanceof IObjectCollection) {
                avo.put(key, null);
                continue;
            }
            avo.put(key, o);
        }
        return avo;
    }

    public static void copyVO(IObjectValue srcVO, IObjectValue destVO, String[] property) {
        for (int i = 0; i < property.length; ++i) {
            String pro = property[i];
            destVO.put(pro, srcVO.get(pro));
        }
    }

    public static boolean isNeedUpdate(IObjectValue vo) {
        return vo.get(ENTITY_PK_NAME) == null || BgORMEngine.getIsChange(vo) || BgORMEngine.getIsNew(vo);
    }

    public static void addCollectionRemoveLisener(IObjectValue vo, String property) {
        ArrayList list = (ArrayList)vo.get(_REMOVELIST_ + property);
        if (list == null) {
            list = new ArrayList();
            vo.put(_REMOVELIST_ + property, list);
        }
        IObjectCollection coll = (IObjectCollection)vo.get(property);
        BgORMEngine.addCollectionRemoveLisener(coll, list);
    }

    public static List getRemoveList(IObjectValue vo, String property) {
        List list = (List)vo.get(_REMOVELIST_ + property);
        if (list == null) {
            return new ArrayList();
        }
        return list;
    }

    public static void addCollectionRemoveLisener(final IObjectCollection coll, final List list) {
        list.clear();
        coll.addEventListener(new IObjectCollectionChangeListener(){

            public void objectCollectionChange(ObjectCollectionChangeEvent cce) {
                BOSUuid id;
                IObjectValue vo;
                if (cce.getType() == 4 && cce.getIndex() == -1 && (vo = cce.getItem()) != null && (id = vo.getBOSUuid(BgORMEngine.ENTITY_PK_NAME)) != null && id != null && !BgORMEngine.getIsNew(vo)) {
                    list.add(id);
                }
                if (cce.getType() == 6) {
                    for (IObjectValue vo2 : coll) {
                        BOSUuid id2 = vo2.getBOSUuid(BgORMEngine.ENTITY_PK_NAME);
                        if (id2 == null || BgORMEngine.getIsNew(vo2) || list.contains(id2)) continue;
                        list.add(id2);
                    }
                }
                if (cce.getType() == 1) {
                    vo = cce.getNewItem();
                    id = vo.getBOSUuid(BgORMEngine.ENTITY_PK_NAME);
                    if (list.contains(id)) {
                        list.remove(id);
                    } else {
                        BgORMEngine.setIsNew(cce.getNewItem(), true);
                    }
                }
            }
        });
    }

    public static void setIsLisener(IObjectValue vo, boolean isLisener) {
        vo.setBoolean(ISLISENER, isLisener);
    }

    public static boolean getIsLisener(IObjectValue vo) {
        return vo.getBoolean(ISLISENER);
    }

    public static void addVOColectionChangeLisener(IObjectCollection coll, String[] property) {
        Iterator iter = coll.iterator();
        while (iter.hasNext()) {
            BgORMEngine.addVOValueChangeLisener((IObjectValue)iter.next(), property);
        }
    }

    public static void addVOValueChangeLisener(IObjectValue vo, String[] property) {
        BgORMEngine.setIsLisener(vo, false);
        vo.put(LISENERPROPERTY, (Object)property);
        BgORMEngine.setIsNew(vo, false);
        BgORMEngine.setIsChanged(vo, false);
        BgORMEngine.setIsLisener(vo, true);
        vo.addEventListener(new IObjectValueChangeListener(){

            public void objectValueChange(ObjectValueChangeEvent event) {
                if (event.getType() != 1) {
                    return;
                }
                IObjectValue src = (IObjectValue)event.getSource();
                if (BgORMEngine.getIsChange(src)) {
                    return;
                }
                if (!BgORMEngine.getIsLisener(src)) {
                    return;
                }
                String pro = event.getPropertyName();
                if (pro.equals(BgORMEngine.ISLISENER) || pro.equals(BgORMEngine.ISCHANGED)) {
                    return;
                }
                String[] property = (String[])src.get(BgORMEngine.LISENERPROPERTY);
                if (property == null || property.length == 0) {
                    return;
                }
                for (int i = 0; i < property.length; ++i) {
                    boolean ischange;
                    if (!pro.equals(property[i])) continue;
                    Object old = event.getOldValue();
                    boolean bl = ischange = !BgHelper.equals(event.getNewValue(), event.getOldValue());
                    if (!ischange) continue;
                    BgORMEngine.setIsChanged(src, true);
                }
            }
        });
    }

    public Object getPropertyValue(Context ctx, BOSUuid id, String property) {
        return null;
    }

    public void updatePropertyValue(Context ctx, BOSUuid id, String property, Object value) {
    }

    public static IObjectValue getVO(Context ctx, BOSUuid id, String[] property) throws EASBizException, BOSException {
        BOSObjectType type = id.getType();
        BgEntityAccess ea = new BgEntityAccess(ctx, type, property);
        return ea.getVO(ctx, id);
    }

    public static void setIsNew(IObjectValue vo, boolean isNew) {
        vo.setBoolean(_ISNEW, isNew);
    }

    public static boolean getIsNew(IObjectValue vo) {
        if (vo.getBOSUuid(ENTITY_PK_NAME) == null) {
            return true;
        }
        return vo.getBoolean(_ISNEW);
    }

    public static void setORMObjectAry(IObjectValue vo, String[] val) {
        vo.put(_ORMOBJECTARY, (Object)val);
    }

    public static String[] getORMObjectAry(IObjectValue vo) {
        return (String[])vo.get(_ORMOBJECTARY);
    }

    public static void setMainPropertyAry(IObjectValue vo, String[] val) {
        vo.put(_MAINPROPERTYARY, (Object)val);
    }

    public static String[] getMainPropertyAry(IObjectValue vo) {
        return (String[])vo.get(_MAINPROPERTYARY);
    }

    public static boolean getIsChange(IObjectValue vo) {
        return vo.getBoolean(ISCHANGED);
    }

    public static void setIsChanged(IObjectValue vo, boolean isChanged) {
        vo.setBoolean(ISCHANGED, isChanged);
    }

    public static boolean getIsBgORM(IObjectValue vo) {
        return vo.getBoolean(_ISBGORM);
    }

    public static void setIsBgORM(IObjectValue vo, boolean isBgORM) {
        vo.setBoolean(_ISBGORM, isBgORM);
    }

    public static boolean storeVOColl(Context ctx, Object[] coll) throws EASBizException {
        return BgORMEngine.storeVOColl(ctx, BgORMEngine.getObjectValue(coll));
    }

    public static boolean storeVOColl(Context ctx, IObjectValue[] coll) throws EASBizException {
        ArrayList<IObjectValue> newlist = new ArrayList<IObjectValue>();
        ArrayList<IObjectValue> updateList = new ArrayList<IObjectValue>();
        for (int i = 0; i < coll.length; ++i) {
            IObjectValue vo = coll[i];
            if (BgORMEngine.getIsNew(vo)) {
                newlist.add(vo);
                continue;
            }
            updateList.add(vo);
        }
        if (newlist.size() > 0) {
            IObjectValue vo = coll[0];
            String[] addnewpro = BgORMEngine.getPropertyAry(ctx, vo.getBOSType());
            BgORMEngine.addnewVO(ctx, BgORMEngine.getObjectValue(newlist.toArray()), addnewpro);
        }
        if (updateList.size() > 0) {
            BgORMEngine.updateColl(ctx, BgORMEngine.getObjectValue(updateList.toArray()), (String[])((IObjectValue)updateList.get(0)).get(LISENERPROPERTY));
        }
        return true;
    }

    public static boolean storeVOColl(Context ctx, IObjectValue[] coll, String[] property) throws EASBizException {
        ArrayList<IObjectValue> newlist = new ArrayList<IObjectValue>();
        ArrayList<IObjectValue> updateList = new ArrayList<IObjectValue>();
        for (int i = 0; i < coll.length; ++i) {
            IObjectValue vo = coll[i];
            if (BgORMEngine.getIsNew(vo)) {
                newlist.add(vo);
                continue;
            }
            updateList.add(vo);
        }
        if (newlist.size() > 0) {
            String[] addnewpro = BgORMEngine.getPropertyAry(ctx, coll[0].getBOSType());
            BgORMEngine.addnewVO(ctx, BgORMEngine.getObjectValue(newlist.toArray()), addnewpro);
        }
        if (updateList.size() > 0) {
            BgORMEngine.updateColl(ctx, BgORMEngine.getObjectValue(updateList.toArray()), property);
        }
        return true;
    }

    public static IObjectValue[] buildVOArray(IObjectCollection coll) {
        if (coll == null || coll.size() == 0) {
            return null;
        }
        IObjectValue[] voAray = new IObjectValue[]{coll.getObject(0)};
        voAray = (IObjectValue[])Array.newInstance(voAray.getClass().getComponentType(), coll.size());
        int i = 0;
        Iterator iter = coll.iterator();
        while (iter.hasNext()) {
            voAray[i++] = (IObjectValue)iter.next();
        }
        return voAray;
    }

    public static int[] updateColl(Context ctx, IObjectValue[] coll, String[] property) throws EASBizException {
        if (coll.length == 0) {
            return null;
        }
        IObjectValue vo = coll[0];
        BOSObjectType type = vo.getBOSType();
        BgEntityAccess ea = new BgEntityAccess(ctx, type, property);
        return ea.update(ctx, coll);
    }

    public static String[] getPropertyAry(Context ctx, BOSObjectType type) throws EASBizException {
        if (type == null) {
            return null;
        }
        IMetaDataLoader load = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        EntityObjectInfo entity = load.getEntity(type);
        PropertyCollection entityProperty = entity.getPropertiesRuntime();
        int size = entityProperty.size();
        ArrayList<String> property = new ArrayList<String>();
        boolean i = false;
        for (PropertyInfo entityPro : entityProperty) {
            String name = entityPro.getName();
            if (entityPro.getMappingField() == null || name.equals(ENTITY_PK_NAME)) continue;
            property.add(name);
        }
        String[] rst = property.toArray(new String[0]);
        return rst;
    }

    public static int[] addnewVO(Context ctx, IObjectValue[] coll) throws EASBizException {
        if (coll == null || coll.length == 0) {
            return null;
        }
        IObjectValue vo = coll[0];
        BOSObjectType type = vo.getBOSType();
        String[] property = BgORMEngine.getPropertyAry(ctx, type);
        BgEntityAccess ea = new BgEntityAccess(ctx, type, property);
        return ea.addnew(ctx, coll);
    }

    public static int[] addnewVO(Context ctx, IObjectValue[] coll, String[] property) throws EASBizException {
        if (coll == null || coll.length == 0) {
            return null;
        }
        IObjectValue vo = coll[0];
        BOSObjectType type = vo.getBOSType();
        BgEntityAccess ea = new BgEntityAccess(ctx, type, property);
        return ea.addnew(ctx, coll);
    }

    public static boolean removeVOColl(Context ctx, BOSUuid[] ids) throws EASBizException {
        if (ids == null || ids.length == 0) {
            return false;
        }
        BOSUuid id = ids[0];
        return BgORMEngine.removeVOColl(ctx, id.getType(), ENTITY_PK_NAME, ids);
    }

    public static boolean removeVOColl(Context ctx, BOSObjectType type, String property, BOSUuid[] ids) throws EASBizException {
        if (ids == null || ids.length == 0) {
            return true;
        }
        IMetaDataLoader load = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        EntityObjectInfo entity = load.getEntity(type);
        DataTableInfo table = entity.getTable();
        String name = table.getName();
        StringBuffer removeSb = new StringBuffer(128);
        removeSb.append(DELETE_FROM);
        removeSb.append(name);
        PropertyInfo pk = entity.getPropertyByName(property);
        ColumnInfo mapPk = pk.getMappingField();
        removeSb.append(WHERE);
        removeSb.append(mapPk.getName());
        removeSb.append(EQUAL_QUEST);
        Connection conn = null;
        PreparedStatement stmt = null;
        boolean b = false;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            stmt = conn.prepareStatement(removeSb.toString());
            for (int i = 0; i < ids.length; ++i) {
                stmt.setAsciiStream(1, (InputStream)new ByteArrayInputStream(ids[i].toString().getBytes()), 44);
                int length = ids[i].toString().length();
                if (length != 28 && length != 44) {
                    throw new SQLException("\u4e1a\u52a1\u5bf9\u8c61ID\u957f\u5ea6\u8bbe\u7f6e\u5f02\u5e38\uff01");
                }
                stmt.setAsciiStream(2, (InputStream)new ByteArrayInputStream(ids[i].toString().getBytes()), length);
                stmt.addBatch();
            }
            stmt.executeBatch();
            b = true;
        }
        catch (SQLException e1) {
            try {
                throw new BgORMException(BgORMException.DELETEENTITY, e1, new Object[]{type, ids});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)conn);
        return b;
    }

    public static BOSUuid[] getIDAry(IObjectCollection coll) {
        BOSUuid[] ids = new BOSUuid[coll.size()];
        int i = 0;
        Iterator iter = coll.iterator();
        while (iter.hasNext()) {
            ids[i++] = ((IObjectValue)iter.next()).getBOSUuid(ENTITY_PK_NAME);
        }
        return ids;
    }

    public static IObjectValue[] getObjectValue(Object[] coll) {
        IObjectValue[] vals = new IObjectValue[coll.length];
        System.arraycopy(coll, 0, vals, 0, coll.length);
        return vals;
    }

    public static IObjectValue getNewVOInstance(Context ctx, BOSUuid id) {
        IObjectValue vo = null;
        BOSObjectType type = id.getType();
        IMetaDataLoader load = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        EntityObjectInfo entity = load.getEntity(type);
        try {
            vo = (IObjectValue)Class.forName(entity.getObjectValueClass()).newInstance();
            vo.put(ENTITY_PK_NAME, (Object)id);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (SingleVOCache.cache.size() > 1000) {
            SingleVOCache.cache.clear();
        }
        SingleVOCache.cache.put(id, vo);
        return vo;
    }
}

