/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bg;

import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.ma.bg.AbstractBgTemplateInfo;
import com.kingdee.eas.ma.bg.BgCtrlTypeEnum;
import com.kingdee.eas.ma.bg.BgDimensionEnum;
import com.kingdee.eas.ma.bg.BgElementInfo;
import com.kingdee.eas.ma.bg.BgHelper;
import com.kingdee.eas.ma.bg.BgItemCollection;
import com.kingdee.eas.ma.bg.BgItemInfo;
import com.kingdee.eas.ma.bg.BgORMEngine;
import com.kingdee.eas.ma.bg.BgTemplateColumnCollection;
import com.kingdee.eas.ma.bg.BgTemplateColumnInfo;
import com.kingdee.eas.ma.bg.BgTemplateRowCollection;
import com.kingdee.eas.ma.bg.BgTemplateRowInfo;
import com.kingdee.eas.ma.bg.ReferencedCurrencyInfo;
import com.kingdee.eas.ma.bg.ReferencedDimensionCollection;
import com.kingdee.eas.ma.bg.ReferencedDimensionInfo;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;

public class BgTemplateInfo
extends AbstractBgTemplateInfo
implements Serializable {
    public BgTemplateInfo() {
    }

    protected BgTemplateInfo(String pkField) {
        super(pkField);
    }

    public void setOrgUnit(OrgUnitInfo item) {
        this.setOrgUnit(item.castToFullOrgUnitInfo());
    }

    public ReferencedDimensionInfo getRefDim(BgDimensionEnum bgDimEnum) {
        Iterator iter = this.getRefDimensions().iterator();
        ReferencedDimensionInfo refDimInfo = null;
        while (iter.hasNext() && (refDimInfo = (ReferencedDimensionInfo)iter.next()).getBgDimension().compareTo((Object)bgDimEnum) != 0) {
            refDimInfo = null;
        }
        return refDimInfo;
    }

    public void removeRefDim(BgDimensionEnum bgDimEnum) {
        ReferencedDimensionInfo refDimInfo = this.getRefDim(bgDimEnum);
        if (refDimInfo != null) {
            this.getRefDimensions().remove(refDimInfo);
        }
    }

    public ReferencedDimensionInfo getPrimaryRefDim() {
        Iterator iter = this.getRefDimensions().iterator();
        ReferencedDimensionInfo refDimInfo = null;
        while (iter.hasNext() && !(refDimInfo = (ReferencedDimensionInfo)iter.next()).isIsPrimary()) {
            refDimInfo = null;
        }
        return refDimInfo;
    }

    public ReferencedDimensionCollection getAssisRefDims() {
        Iterator iter = this.getRefDimensions().iterator();
        ReferencedDimensionCollection refDims = new ReferencedDimensionCollection();
        while (iter.hasNext()) {
            ReferencedDimensionInfo refDimInfo = (ReferencedDimensionInfo)iter.next();
            if (refDimInfo.isIsPrimary()) continue;
            refDims.add(refDimInfo);
        }
        return refDims;
    }

    public ReferencedDimensionCollection getVisibleDims() {
        if (this.isIsMultidimensional()) {
            return this.getRefDimensions();
        }
        ReferencedDimensionCollection refDims = new ReferencedDimensionCollection();
        ReferencedDimensionInfo referencedDimensionInfo = this.getPrimaryRefDim();
        if (referencedDimensionInfo != null) {
            refDims.add(this.getPrimaryRefDim());
        }
        return refDims;
    }

    public void initBgTpRows() {
        this.adjustBgItemsLeaf();
        this.getBgTpRows().clear();
        if (this.isIsMultidimensional()) {
            this.getBgTpRows().addCollection(this.generateBgTpRows_Multi());
        } else {
            this.getBgTpRows().addCollection(this.generateBgTpRows_PrimaryOnly());
        }
    }

    private void adjustBgItemsLeaf() {
        block0: for (int i = 0; i < this.getRefDimensions().size(); ++i) {
            BgItemCollection bgItems = this.getRefDimensions().get(i).getBgItems();
            block1: for (int j = 0; j < bgItems.size(); ++j) {
                BgItemInfo bgItemInfo = bgItems.get(j);
                bgItemInfo.setIsLeaf(true);
                if (bgItemInfo.getLongNumber() == null) continue block0;
                for (int k = 0; k < bgItems.size(); ++k) {
                    if (k == j) continue;
                    BgItemInfo comparedBgItemInfo = bgItems.get(k);
                    if (comparedBgItemInfo.getLongNumber() == null) continue block1;
                    if (!comparedBgItemInfo.getLongNumber().startsWith(bgItemInfo.getLongNumber())) continue;
                    bgItemInfo.setIsLeaf(false);
                    continue block1;
                }
            }
        }
    }

    private BgTemplateRowCollection generateBgTpRows_PrimaryOnly() {
        BgTemplateRowCollection bgTpRows = new BgTemplateRowCollection();
        ReferencedDimensionInfo refDimInfo = this.getPrimaryRefDim();
        Iterator iter = refDimInfo.getBgItems().iterator();
        while (iter.hasNext()) {
            BgItemInfo bgItemInfo = (BgItemInfo)iter.next();
            BgTemplateRowInfo bgTemplateRowInfo = new BgTemplateRowInfo("id");
            bgTemplateRowInfo.setBgItem1(bgItemInfo);
            if (this.getBgCtrlType() == null) {
                bgTemplateRowInfo.setBgControlType(BgCtrlTypeEnum.NoCtrl);
            } else {
                bgTemplateRowInfo.setBgControlType(this.getBgCtrlType());
            }
            bgTemplateRowInfo.setIsFlexibleCtrl(false);
            bgTemplateRowInfo.setFlexibleBgCtrlParam(new BigDecimal("0"));
            bgTemplateRowInfo.setRelativeCtrlFormula("");
            bgTpRows.add(bgTemplateRowInfo);
        }
        return bgTpRows;
    }

    private BgTemplateRowCollection generateBgTpRows_Multi() {
        BgTemplateRowCollection basedBgTpRows;
        BgTemplateRowCollection bgTpRows = new BgTemplateRowCollection();
        int visibleRefDimCount = this.getVisibleDims().size();
        bgTpRows = basedBgTpRows = this.generateBgTpRows_PrimaryOnly();
        for (int level = 2; level <= visibleRefDimCount; ++level) {
            BgItemCollection attachedBgItems = this.getRefDimensions().get(level - 1).getBgItems();
            basedBgTpRows = bgTpRows = this.attachAssisRefDimItems(basedBgTpRows, attachedBgItems, level);
        }
        return bgTpRows;
    }

    private BgTemplateRowCollection attachAssisRefDimItems(BgTemplateRowCollection basedBgTpRows, BgItemCollection attachedBgItems, int level) {
        BgTemplateRowCollection bgTpRows = new BgTemplateRowCollection();
        Iterator basedBgTpRowsIter = basedBgTpRows.iterator();
        while (basedBgTpRowsIter.hasNext()) {
            BgTemplateRowInfo basedBgTpRowInfo = (BgTemplateRowInfo)basedBgTpRowsIter.next();
            Iterator attachedBgItemsIter = attachedBgItems.iterator();
            while (attachedBgItemsIter.hasNext()) {
                BgItemInfo attachedBgItem = (BgItemInfo)attachedBgItemsIter.next();
                BgTemplateRowInfo bgTpRowInfo = basedBgTpRowInfo.dataClone();
                String valueKey = "bgItem" + level;
                bgTpRowInfo.put(valueKey, attachedBgItem);
                bgTpRows.add(bgTpRowInfo);
            }
        }
        return bgTpRows;
    }

    public void initRefCurrency(CurrencyCollection currencyCollection) {
        Iterator iter = null;
        for (int i = this.getRefCurrencies().size() - 1; i >= 0; --i) {
            ReferencedCurrencyInfo ref = this.getRefCurrencies().get(i);
            boolean has = false;
            for (CurrencyInfo cyInfo : currencyCollection) {
                if (!ref.getCurrency().getId().equals((Object)cyInfo.getId())) continue;
                has = true;
                break;
            }
            if (has) continue;
            ArrayList<BOSUuid> list = (ArrayList<BOSUuid>)this.get("_deletedRefCurr");
            if (list == null) {
                list = new ArrayList<BOSUuid>();
                this.put("_deletedRefCurr", list);
            }
            list.add(this.getRefCurrencies().get(i).getId());
            this.getRefCurrencies().removeObject(i);
        }
        for (CurrencyInfo cyInfo : currencyCollection) {
            boolean isExist = false;
            for (int i = 0; i < this.getRefCurrencies().size(); ++i) {
                if (!cyInfo.getId().equals((Object)this.getRefCurrencies().get(i).getCurrency().getId())) continue;
                isExist = true;
                break;
            }
            if (isExist) continue;
            ReferencedCurrencyInfo refCyInfo = new ReferencedCurrencyInfo();
            refCyInfo.setCurrency(cyInfo);
            this.getRefCurrencies().add(refCyInfo);
        }
    }

    public BgElementInfo getControlledBgElement() {
        BgElementInfo bgElementInfo = null;
        Iterator iter = this.getBgTpColumns().iterator();
        while (iter.hasNext()) {
            BgTemplateColumnInfo bgTpColInfo = (BgTemplateColumnInfo)iter.next();
            if (!bgTpColInfo.isIsControlled()) continue;
            bgElementInfo = bgTpColInfo.getBgElement();
            break;
        }
        return bgElementInfo;
    }

    public Hashtable getFormulaTable() {
        Hashtable<String, String> formulaTable = new Hashtable<String, String>();
        Iterator bgTpColIter = this.getBgTpColumns().iterator();
        while (bgTpColIter.hasNext()) {
            BgTemplateColumnInfo bgTpColInfo = (BgTemplateColumnInfo)bgTpColIter.next();
            String formula = bgTpColInfo.getFormula();
            if (formula == null || !formula.trim().equals("")) continue;
            formulaTable.put(BgHelper.getBgElementKey(bgTpColInfo.getBgElement(), null), formula);
        }
        return formulaTable;
    }

    public BgTemplateColumnCollection getApportionableBgTpCol() {
        BgTemplateColumnCollection apportionableBgTpCols = new BgTemplateColumnCollection();
        Iterator iter = this.getBgTpColumns().iterator();
        while (iter.hasNext()) {
            BgTemplateColumnInfo bgTpColInfo = (BgTemplateColumnInfo)iter.next();
            BgElementInfo bgEleInfo = bgTpColInfo.getBgElement();
            if (!bgEleInfo.isApportionable()) continue;
            apportionableBgTpCols.add(bgTpColInfo);
        }
        return apportionableBgTpCols;
    }

    public BgTemplateInfo deepClone() {
        BgTemplateInfo clonedBgTpInfo = (BgTemplateInfo)this.clone();
        clonedBgTpInfo.remove("id");
        clonedBgTpInfo.setIsCurrent(false);
        Iterator iter = clonedBgTpInfo.getRefCurrencies().iterator();
        while (iter.hasNext()) {
            ReferencedCurrencyInfo rci = (ReferencedCurrencyInfo)iter.next();
            rci.remove("id");
            rci.remove("bgTemplate");
        }
        Hashtable<String, BgItemInfo> ht = new Hashtable<String, BgItemInfo>();
        iter = clonedBgTpInfo.getRefDimensions().iterator();
        while (iter.hasNext()) {
            ReferencedDimensionInfo rdi = (ReferencedDimensionInfo)iter.next();
            BOSUuid rdiId = BOSUuid.create((BOSObjectType)rdi.getBOSType());
            rdi.setId(rdiId);
            rdi.remove("bgTemplate");
            Iterator itemIter = rdi.getBgItems().iterator();
            while (itemIter.hasNext()) {
                BgItemInfo bii = (BgItemInfo)itemIter.next();
                bii.setRefDimension(rdi);
                String oldId = bii.getId().toString();
                bii.setId(BOSUuid.create((BOSObjectType)bii.getBOSType()));
                ht.put(oldId, bii);
            }
        }
        iter = clonedBgTpInfo.getBgTpRows().iterator();
        while (iter.hasNext()) {
            BgTemplateRowInfo btri = (BgTemplateRowInfo)iter.next();
            btri.remove("id");
            btri.remove("bgTemplate");
            for (int i = 1; i <= 6; ++i) {
                String propertyKey = "bgItem" + i;
                if (btri.get(propertyKey) == null) continue;
                String oldId = ((BgItemInfo)btri.get(propertyKey)).getId().toString();
                btri.put(propertyKey, ht.get(oldId));
            }
        }
        iter = clonedBgTpInfo.getBgTpColumns().iterator();
        while (iter.hasNext()) {
            BgTemplateColumnInfo btci = (BgTemplateColumnInfo)iter.next();
            btci.remove("id");
            btci.remove("bgTemplate");
        }
        clonedBgTpInfo.setIsCurrent(false);
        if (clonedBgTpInfo.getParent() != null) {
            clonedBgTpInfo.setParent(null);
        }
        return clonedBgTpInfo;
    }

    public void initBgTpRowsNew() {
        this.adjustBgItemsLeaf();
        BgTemplateRowCollection oriBgTemplateRowCollection = this.getBgTpRows();
        BgTemplateRowCollection newBgTemplateRowCollection = null;
        newBgTemplateRowCollection = this.isIsMultidimensional() ? this.generateBgTpRows_Multi() : this.generateBgTpRows_PrimaryOnly();
        BgItemCollection bgItemCollection = this.getNewBgItemCByRefDimC(this.getRefDimensions());
        Iterator iteratorItem = bgItemCollection.iterator();
        while (iteratorItem.hasNext()) {
            BgItemInfo bgItem = (BgItemInfo)iteratorItem.next();
            BgTemplateRowCollection bgTemplateRowCollectionTemp = this.getBgTemplateRowCByBgTpRows(bgItem, newBgTemplateRowCollection);
            if (bgTemplateRowCollectionTemp.size() <= 0) continue;
            oriBgTemplateRowCollection.addCollection(bgTemplateRowCollectionTemp);
        }
    }

    public BgItemCollection getNewBgItemCByRefDimC(ReferencedDimensionCollection referencedDimensionCollection) {
        BgItemCollection bgItemCollection = new BgItemCollection();
        Iterator iterator = referencedDimensionCollection.iterator();
        while (iterator.hasNext()) {
            ReferencedDimensionInfo referencedDimensionInfo = (ReferencedDimensionInfo)iterator.next();
            Iterator itr = referencedDimensionInfo.getBgItems().iterator();
            while (itr.hasNext()) {
                BgItemInfo bgItem = (BgItemInfo)itr.next();
                if (!BgORMEngine.getIsNew((IObjectValue)bgItem)) continue;
                bgItemCollection.add(bgItem);
            }
        }
        return bgItemCollection;
    }

    public BgItemCollection getModifyBgItemCByRefDimC(ReferencedDimensionCollection referencedDimensionCollection) {
        BgItemCollection bgItemCollection = new BgItemCollection();
        Iterator iterator = referencedDimensionCollection.iterator();
        while (iterator.hasNext()) {
            ReferencedDimensionInfo referencedDimensionInfo = (ReferencedDimensionInfo)iterator.next();
            Iterator itr = referencedDimensionInfo.getBgItems().iterator();
            while (itr.hasNext()) {
                BgItemInfo bgItem = (BgItemInfo)itr.next();
                if (!BgORMEngine.getIsChange((IObjectValue)bgItem)) continue;
                bgItemCollection.add(bgItem);
            }
        }
        return bgItemCollection;
    }

    public BgTemplateRowCollection getBgTemplateRowCByBgTpRows(BgItemInfo bgItemInfo, BgTemplateRowCollection bgTemplateRowCollection) {
        BgTemplateRowCollection newBgTemplateRowCollection = new BgTemplateRowCollection();
        Iterator iterator = bgTemplateRowCollection.iterator();
        while (iterator.hasNext()) {
            BgTemplateRowInfo bgTemplateRowInfo = (BgTemplateRowInfo)iterator.next();
            if (bgTemplateRowInfo.getBgItem1().getItemNumber().equals(bgItemInfo.getItemNumber())) {
                newBgTemplateRowCollection.add(bgTemplateRowInfo);
                continue;
            }
            if (bgTemplateRowInfo.getBgItem2() != null && bgTemplateRowInfo.getBgItem2().getItemNumber().equals(bgItemInfo.getItemNumber())) {
                newBgTemplateRowCollection.add(bgTemplateRowInfo);
                continue;
            }
            if (bgTemplateRowInfo.getBgItem3() != null && bgTemplateRowInfo.getBgItem3().getItemNumber().equals(bgItemInfo.getItemNumber())) {
                newBgTemplateRowCollection.add(bgTemplateRowInfo);
                continue;
            }
            if (bgTemplateRowInfo.getBgItem4() != null && bgTemplateRowInfo.getBgItem4().getItemNumber().equals(bgItemInfo.getItemNumber())) {
                newBgTemplateRowCollection.add(bgTemplateRowInfo);
                continue;
            }
            if (bgTemplateRowInfo.getBgItem5() != null && bgTemplateRowInfo.getBgItem5().getItemNumber().equals(bgItemInfo.getItemNumber())) {
                newBgTemplateRowCollection.add(bgTemplateRowInfo);
                continue;
            }
            if (bgTemplateRowInfo.getBgItem6() == null || !bgTemplateRowInfo.getBgItem6().getItemNumber().equals(bgItemInfo.getItemNumber())) continue;
            newBgTemplateRowCollection.add(bgTemplateRowInfo);
        }
        return newBgTemplateRowCollection;
    }

    public void removeBgTpRowByDeleteBgItem(List listItem, BgTemplateRowCollection bgTemplateRowCollection) {
        Iterator iteratorItem = listItem.iterator();
        ArrayList list = new ArrayList();
        while (iteratorItem.hasNext()) {
            BOSUuid itemId = (BOSUuid)iteratorItem.next();
            Iterator iterator = bgTemplateRowCollection.iterator();
            int count = -1;
            while (iterator.hasNext()) {
                BgTemplateRowInfo bgTemplateRowInfo = (BgTemplateRowInfo)iterator.next();
                ++count;
                if (bgTemplateRowInfo.getBgItem1().getId().equals((Object)itemId)) {
                    this.addCurrentIndex(list, count);
                    continue;
                }
                if (bgTemplateRowInfo.getBgItem2() != null && bgTemplateRowInfo.getBgItem2().getId().equals((Object)itemId)) {
                    this.addCurrentIndex(list, count);
                    continue;
                }
                if (bgTemplateRowInfo.getBgItem3() != null && bgTemplateRowInfo.getBgItem3().getId().equals((Object)itemId)) {
                    this.addCurrentIndex(list, count);
                    continue;
                }
                if (bgTemplateRowInfo.getBgItem4() != null && bgTemplateRowInfo.getBgItem4().getId().equals((Object)itemId)) {
                    this.addCurrentIndex(list, count);
                    continue;
                }
                if (bgTemplateRowInfo.getBgItem5() != null && bgTemplateRowInfo.getBgItem5().getId().equals((Object)itemId)) {
                    this.addCurrentIndex(list, count);
                    continue;
                }
                if (bgTemplateRowInfo.getBgItem6() == null || !bgTemplateRowInfo.getBgItem6().getId().equals((Object)itemId)) continue;
                this.addCurrentIndex(list, count);
            }
        }
        Object[] arrayIndex = list.toArray();
        Arrays.sort(arrayIndex);
        int size = arrayIndex.length;
        for (int i = size - 1; i >= 0; --i) {
            bgTemplateRowCollection.removeObject((Integer)arrayIndex[i]);
        }
    }

    public void addCurrentIndex(List list, int count) {
        boolean isExist = false;
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            int nIndex = (Integer)iter.next();
            if (nIndex != count) continue;
            isExist = true;
        }
        if (!isExist) {
            list.add(new Integer(count));
        }
    }
}

