/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bg;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.basedata.org.NewOrgViewHelper;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.bg.BgTypeFactory;
import com.kingdee.eas.ma.bg.BgTypeInfo;
import com.kingdee.eas.ma.bg.IBgType;
import java.util.Vector;

public class BgTypeHelper {
    public static SelectorItemCollection getFullDataSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("seq"));
        sic.add(new SelectorItemInfo("controllable"));
        sic.add(new SelectorItemInfo("isSysDefined"));
        sic.add(new SelectorItemInfo("description"));
        sic.add(new SelectorItemInfo("isEffective"));
        sic.add(new SelectorItemInfo("isRptBgForm"));
        sic.add(new SelectorItemInfo("elements.*"));
        sic.add(new SelectorItemInfo("validBgDimensions.*"));
        sic.add(new SelectorItemInfo("bgOrgType.*"));
        sic.add(new SelectorItemInfo("orgView"));
        return sic;
    }

    public static SelectorItemCollection getElementsSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("elements.*"));
        return sic;
    }

    public static SelectorItemCollection getValidDimSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("validBgDimensions.*"));
        return sic;
    }

    public static EntityViewInfo getListEntityView() {
        EntityViewInfo evi = new EntityViewInfo();
        evi.getSelector().add(new SelectorItemInfo("id"));
        evi.getSelector().add(new SelectorItemInfo("number"));
        evi.getSelector().add(new SelectorItemInfo("name"));
        evi.getSelector().add(new SelectorItemInfo("seq"));
        evi.getSelector().add(new SelectorItemInfo("orgTree.id"));
        return evi;
    }

    public static boolean isRptBudget(BgTypeInfo bti) {
        String theNumber = bti.getNumber();
        if (theNumber == null) {
            try {
                IBgType iBgType = BgTypeFactory.getRemoteInstance();
                bti = iBgType.getBgTypeBySql(bti.getId());
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
            theNumber = bti.getNumber();
            if (theNumber == null) {
                return false;
            }
        }
        return theNumber.equals("BalanceSheetBudget") || theNumber.equals("IncomeStatementBudget");
    }

    public static Vector getOrgTypeByBgType(BgTypeInfo bgTypeInfo) throws EASBizException, BOSException {
        IBgType iBgType = BgTypeFactory.getRemoteInstance();
        Vector vec = iBgType.getOrgType(bgTypeInfo.getId().toString());
        return vec;
    }

    public static OrgUnitCollection getOrgUnitCollByBgType(BgTypeInfo bgTypeInfo, OrgUnitCollection orgUnitCollection) throws EASBizException, BOSException {
        OrgUnitCollection orgUnitCollectionNew = new OrgUnitCollection();
        Vector vecBgType = BgTypeHelper.getOrgTypeByBgType(bgTypeInfo);
        int sizeBgType = vecBgType.size();
        int size = orgUnitCollection.size();
        for (int i = 0; i < size; ++i) {
            OrgUnitInfo orgUnitInfo = orgUnitCollection.get(i);
            for (int j = 0; j < sizeBgType; ++j) {
                OrgType orgType = (OrgType)vecBgType.get(j);
                int treeType = (Integer)orgUnitInfo.get("treeType");
                if (treeType == 15 && (orgType.getValue() == 1 && orgUnitInfo.isIsCompanyOrgUnit() || orgType.getValue() == 6 && orgUnitInfo.isIsProfitOrgUnit() || orgType.getValue() == 5 && orgUnitInfo.isIsCostOrgUnit())) {
                    orgUnitCollectionNew.add(orgUnitInfo);
                    continue;
                }
                if (treeType != NewOrgViewHelper.convert((OrgType)orgType).getValue()) continue;
                orgUnitCollectionNew.add(orgUnitInfo);
            }
        }
        return orgUnitCollectionNew;
    }

    public static SelectorItemCollection getDescDataSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("seq"));
        sic.add(new SelectorItemInfo("controllable"));
        sic.add(new SelectorItemInfo("isSysDefined"));
        sic.add(new SelectorItemInfo("description"));
        sic.add(new SelectorItemInfo("isEffective"));
        sic.add(new SelectorItemInfo("elements"));
        sic.add(new SelectorItemInfo("elements.id"));
        sic.add(new SelectorItemInfo("elements.seq"));
        sic.add(new SelectorItemInfo("elements.number"));
        sic.add(new SelectorItemInfo("elements.srcType"));
        sic.add(new SelectorItemInfo("elements.apportionable"));
        sic.add(new SelectorItemInfo("elements.enabled"));
        sic.add(new SelectorItemInfo("elements.controllable"));
        sic.add(new SelectorItemInfo("elements.summable"));
        sic.add(new SelectorItemInfo("elements.forecastable"));
        sic.add(new SelectorItemInfo("elements.formula"));
        sic.add(new SelectorItemInfo("elements.bizElement"));
        sic.add(new SelectorItemInfo("validBgDimensions"));
        sic.add(new SelectorItemInfo("validBgDimensions.id"));
        sic.add(new SelectorItemInfo("validBgDimensions.fecthPath"));
        sic.add(new SelectorItemInfo("validBgDimensions.bgDimension"));
        return sic;
    }
}

