/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bg.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.SimpleTimer;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.bg.BgBalanceAccess;
import com.kingdee.eas.ma.bg.BgBizException;
import com.kingdee.eas.ma.bg.BgCtrlHelper;
import com.kingdee.eas.ma.bg.BgCurrencyCtrlTypeEnum;
import com.kingdee.eas.ma.bg.BgDataCollection;
import com.kingdee.eas.ma.bg.BgDataInfo;
import com.kingdee.eas.ma.bg.BgElementInfo;
import com.kingdee.eas.ma.bg.BgEntityAccess;
import com.kingdee.eas.ma.bg.BgFormCollection;
import com.kingdee.eas.ma.bg.BgFormInfo;
import com.kingdee.eas.ma.bg.BgHelper;
import com.kingdee.eas.ma.bg.BgORMEngine;
import com.kingdee.eas.ma.bg.HashSearchEngine;
import com.kingdee.eas.ma.bg.app.AbstractBgCarryForwardControllerBean;
import com.kingdee.eas.ma.bg.app.dao.BgCtrlDAO;
import com.kingdee.eas.ma.bg.app.dao.BgDAO;
import com.kingdee.util.db.SQLUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class BgCarryForwardControllerBean
extends AbstractBgCarryForwardControllerBean {
    private static Logger logger = Logger.getLogger(BgCarryForwardControllerBean.class);
    private static String getPeriodsListsql = "SELECT DISTINCT FPeriodID FROM T_BG_BgEntry WHERE (FBgFormID = ?)";
    private static String getPrePeriodIdsql = "SELECT TOP 1 P.FID FROM T_BD_Period P INNER JOIN T_BG_BgEntry ON P.FID = T_BG_BgEntry.FPeriodID WHERE (P.FPeriodYear * 100 + P.FPeriodNumber < ?) AND (T_BG_BgEntry.FBgFormID = ?) ORDER BY P.FPeriodYear DESC, P.FPeriodNumber DESC";
    private static String getBgDatasql = "SELECT D.FID, D.FDataType, D.FBgValue, D.FBgBalance, D.FBgInitialValue, D.FBgLastBalance, D.FBgUsableValue, D.FBgElementID, D.FCurrencyID, D.FBgCtrlType,  D.FIsFlexibleCtrl ,  D.FFlexibleBgCtrlParam ,  isnull(E.FBgItem1ID,'') || isnull(E.FBgItem2ID,'') || isnull(E.FBgItem3ID,'') || isnull(E.FBgItem4ID,'') || isnull(E.FBgItem5ID,'') || isnull(E.FBgItem5ID,'') AS FDimSerial FROM T_BG_BgEntry E INNER JOIN T_BG_BgData D ON E.FID = D.FBgEntryID WHERE (E.FBgFormID = ?) AND (E.FPeriodID = ?)  AND (e.FIsLeafPeriod = 1) AND (e.FIsLeafEntry = 1) ";

    @Override
    protected void _executor(Context ctx, java.util.Date pardate) throws BOSException, EASBizException {
        Date date = new Date(pardate.getTime());
        BgCtrlDAO dao = BgCtrlDAO.getInstance(ctx);
        BgFormCollection coll = dao.getBgForm(ctx, date);
        logger.debug((Object)("bgFormSize: " + coll.size()));
        for (int i = 0; i < coll.size(); ++i) {
            BgFormInfo vo = coll.get(i);
            List periodList = this.getPeriodsList(ctx, vo.getId());
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("No." + i + " bgFormId " + vo.getId() + "period size" + periodList.size()));
            }
            for (int j = 0; j < periodList.size(); ++j) {
                BOSUuid id = (BOSUuid)periodList.get(j);
                this.initBgForm(ctx, vo.getCompany().getId(), vo.getId(), id);
            }
        }
    }

    private List getPeriodsList(Context ctx, BOSUuid bgFormId) throws BOSException, EASBizException {
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        ArrayList<BOSUuid> list = new ArrayList<BOSUuid>();
        try {
            conn = this.getConnection(ctx);
            stmt = conn.prepareStatement(getPeriodsListsql);
            int length = bgFormId.toString().length();
            if (length != 28 && length != 44) {
                throw new SQLException("\u4e1a\u52a1\u5bf9\u8c61ID\u957f\u5ea6\u8bbe\u7f6e\u5f02\u5e38\uff01");
            }
            stmt.setAsciiStream(1, (InputStream)new ByteArrayInputStream(bgFormId.toString().getBytes()), length);
            rs = stmt.executeQuery();
            while (rs.next()) {
                list.add(BOSUuid.read((String)rs.getString(1)));
            }
        }
        catch (SQLException exp) {
            try {
                throw new BgBizException(BgBizException.GETDATA, exp, new Object[0]);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        return list;
    }

    @Override
    protected void _executor(Context ctx) throws BOSException, EASBizException {
        Date date = new Date(System.currentTimeMillis());
        this._executor(ctx, date);
    }

    public void initBgForm(Context ctx, BOSUuid companyId, BOSUuid bgFormId, BOSUuid periodId) throws EASBizException, BOSException {
        BgDataCollection coll = this.getBgData(ctx, bgFormId, periodId);
        if (coll == null || coll.size() == 0) {
            return;
        }
        BOSUuid prePeriodId = this.getPrePeriodId(ctx, bgFormId, BgDAO.getInstant(ctx).getPeriodSerial(periodId));
        if (prePeriodId != null) {
            this.initBgLastBalance(ctx, bgFormId, prePeriodId, coll);
        }
        BgCurrencyCtrlTypeEnum bgCurCtrlType = BgCtrlHelper.getBgCurrencyCtrlType(ctx, companyId);
        BgBalanceAccess ba = new BgBalanceAccess(ctx, companyId, bgFormId, periodId);
        Iterator iter = coll.iterator();
        while (iter.hasNext()) {
            BgDataInfo curdata = (BgDataInfo)iter.next();
            BigDecimal balance = ba.getBgEnableValue(ctx, curdata, bgCurCtrlType);
            curdata.setBgUsableValue(balance);
        }
        String[] properties = new String[]{"bgLastBalance", "bgUsableValue"};
        BgEntityAccess ea = new BgEntityAccess(ctx, coll.get(0).getBOSType(), properties);
        ea.update(ctx, BgORMEngine.buildVOArray((IObjectCollection)coll));
    }

    private void initBgLastBalance(Context ctx, BOSUuid bgFormId, BOSUuid prePeriodId, BgDataCollection coll) throws BOSException, EASBizException {
        BgDataCollection preColl = this.getBgData(ctx, bgFormId, prePeriodId);
        if (preColl != null && preColl.size() > 0) {
            HashSearchEngine engine = new HashSearchEngine(BgORMEngine.buildVOArray((IObjectCollection)preColl), new String[]{"DimSerial", "bgElement", "currency"});
            Iterator iter = coll.iterator();
            while (iter.hasNext()) {
                BgDataInfo curdata = (BgDataInfo)iter.next();
                if (!engine.evaluate((IObjectValue)curdata)) continue;
                BgDataInfo preData = (BgDataInfo)engine.getResult();
                curdata.setBgLastBalance(preData.getBgBalance());
                if (preData.getBgBalance() != null) continue;
                preData.setBgBalance(new BigDecimal("0"));
            }
        }
    }

    private BOSUuid getPrePeriodId(Context ctx, BOSUuid bgFormId, int periodSerial) throws BOSException, EASBizException {
        ResultSet rs;
        PreparedStatement stmt;
        Connection conn;
        block5: {
            BOSUuid bOSUuid;
            conn = null;
            stmt = null;
            rs = null;
            try {
                conn = this.getConnection(ctx);
                stmt = conn.prepareStatement(getPrePeriodIdsql);
                stmt.setInt(1, periodSerial);
                int length = bgFormId.toString().length();
                if (length != 28 && length != 44) {
                    throw new SQLException("\u4e1a\u52a1\u5bf9\u8c61ID\u957f\u5ea6\u8bbe\u7f6e\u5f02\u5e38\uff01");
                }
                stmt.setAsciiStream(2, (InputStream)new ByteArrayInputStream(bgFormId.toString().getBytes()), length);
                rs = stmt.executeQuery();
                if (!rs.next()) break block5;
                bOSUuid = BOSUuid.read((String)rs.getString(1));
            }
            catch (SQLException e) {
                try {
                    throw new BgBizException(BgBizException.GETDATA, e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs, stmt, (Connection)conn);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
            return bOSUuid;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        return null;
    }

    public BgDataCollection getBgData(Context ctx, BOSUuid bgFormId, BOSUuid periodId) throws EASBizException, BOSException {
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        BgDataCollection coll = new BgDataCollection();
        try {
            conn = this.getConnection(ctx);
            stmt = conn.prepareStatement(getBgDatasql);
            int length1 = bgFormId.toString().length();
            if (length1 != 28 && length1 != 44) {
                throw new SQLException("\u4e1a\u52a1\u5bf9\u8c61ID\u957f\u5ea6\u8bbe\u7f6e\u5f02\u5e38\uff01");
            }
            stmt.setAsciiStream(1, (InputStream)new ByteArrayInputStream(bgFormId.toString().getBytes()), length1);
            int length2 = periodId.toString().length();
            if (length2 != 28 && length2 != 44) {
                throw new SQLException("\u4e1a\u52a1\u5bf9\u8c61ID\u957f\u5ea6\u8bbe\u7f6e\u5f02\u5e38\uff01");
            }
            stmt.setAsciiStream(1, (InputStream)new ByteArrayInputStream(periodId.toString().getBytes()), length2);
            rs = stmt.executeQuery();
            HashMap cache = new HashMap();
            while (rs.next()) {
                BgDataInfo info = new BgDataInfo();
                info.setId(BOSUuid.read((String)rs.getString("FID")));
                info.put("dataType", rs.getObject("FDataType"));
                BgHelper.buildVO((IObjectValue)info, "bgElement", rs, "FBgElementID", BgElementInfo.class, cache);
                BgHelper.buildVO((IObjectValue)info, "currency", rs, "FCurrencyID", CurrencyInfo.class, cache);
                info.put("bgCtrlType", rs.getObject("FBgCtrlType"));
                info.put("bgValue", rs.getBigDecimal("FBgValue"));
                info.put("bgLastBalance", rs.getBigDecimal("FBgLastBalance"));
                info.setBgBalance(rs.getBigDecimal("FBgBalance"));
                info.setBgUsableValue(rs.getBigDecimal("FBgUsableValue"));
                info.setBgInitialValue(rs.getBigDecimal("FBgInitialValue"));
                info.setIsFlexibleCtrl(rs.getBoolean("FIsFlexibleCtrl"));
                info.setFlexibleBgCtrlParam(rs.getBigDecimal("FFlexibleBgCtrlParam"));
                info.setString("DimSerial", rs.getString("FDimSerial"));
                coll.add(info);
            }
        }
        catch (SQLException e) {
            try {
                throw new BgBizException(BgBizException.GETDATA, e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        return coll;
    }

    @Override
    protected void _executor(Context ctx, java.util.Date pardate, String sid) throws EASBizException, BOSException {
        Date date = new Date(pardate.getTime());
        BgCtrlDAO dao = BgCtrlDAO.getInstance(ctx);
        SimpleTimer time = new SimpleTimer();
        BgFormCollection coll = dao.getBgForm(ctx, date, sid);
        logger.debug((Object)("bgFormSize: " + coll.size()));
        for (int i = 0; i < coll.size(); ++i) {
            BgFormInfo vo = coll.get(i);
            List periodList = this.getPeriodsList(ctx, vo.getId());
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("No." + i + " bgFormId " + vo.getId() + "period size" + periodList.size()));
            }
            for (int j = 0; j < periodList.size(); ++j) {
                BOSUuid id = (BOSUuid)periodList.get(j);
                this.initBgForm(ctx, vo.getCompany().getId(), vo.getId(), id);
            }
        }
        System.out.println("Time :" + time.getTime());
    }
}

