/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bg.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.orm.ORMCoreException;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.SimpleTimer;
import com.kingdee.eas.base.permission.ContextUtils;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.ma.bg.BgBizException;
import com.kingdee.eas.ma.bg.BgCycleTypeEnum;
import com.kingdee.eas.ma.bg.BgDataCollection;
import com.kingdee.eas.ma.bg.BgDataInfo;
import com.kingdee.eas.ma.bg.BgElementInfo;
import com.kingdee.eas.ma.bg.BgEntryCollection;
import com.kingdee.eas.ma.bg.BgEntryInfo;
import com.kingdee.eas.ma.bg.BgFormDAFactory;
import com.kingdee.eas.ma.bg.BgFormDAHelper;
import com.kingdee.eas.ma.bg.BgFormDataSourceEnum;
import com.kingdee.eas.ma.bg.BgFormException;
import com.kingdee.eas.ma.bg.BgFormFactory;
import com.kingdee.eas.ma.bg.BgFormInfo;
import com.kingdee.eas.ma.bg.BgFormLogHelper;
import com.kingdee.eas.ma.bg.BgFormStateEnum;
import com.kingdee.eas.ma.bg.BgHelper;
import com.kingdee.eas.ma.bg.BgInstantApproveException;
import com.kingdee.eas.ma.bg.BgItemFactory;
import com.kingdee.eas.ma.bg.BgItemInfo;
import com.kingdee.eas.ma.bg.BgKDSFactory;
import com.kingdee.eas.ma.bg.BgKDSInfo;
import com.kingdee.eas.ma.bg.BgORMEngine;
import com.kingdee.eas.ma.bg.BgORMException;
import com.kingdee.eas.ma.bg.BgOperationEnum;
import com.kingdee.eas.ma.bg.BgPastDataInfo;
import com.kingdee.eas.ma.bg.BgPastRecordInfo;
import com.kingdee.eas.ma.bg.BgSchemeInfo;
import com.kingdee.eas.ma.bg.BgTemplateInfo;
import com.kingdee.eas.ma.bg.BgTypeInfo;
import com.kingdee.eas.ma.bg.CompressedObjectValue;
import com.kingdee.eas.ma.bg.HashSearchEngine;
import com.kingdee.eas.ma.bg.IBgForm;
import com.kingdee.eas.ma.bg.IBgFormDA;
import com.kingdee.eas.ma.bg.IBgItem;
import com.kingdee.eas.ma.bg.IBgKDS;
import com.kingdee.eas.ma.bg.app.AbstractBgFormControllerBean;
import com.kingdee.eas.ma.bg.app.BgCommon;
import com.kingdee.util.db.SQLUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class BgFormControllerBean
extends AbstractBgFormControllerBean {
    @Override
    protected IObjectValue _getValue(Context ctx, IObjectPK pk, SelectorItemCollection selector) throws BOSException, EASBizException {
        return super._getValue(ctx, pk);
    }

    @Override
    protected IObjectValue _getValue(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        IBgFormDA iBgFormDA = BgFormDAFactory.getLocalInstance(ctx);
        BgFormInfo bgFormInfo = iBgFormDA.getFormHeadInfo(pk.toString());
        return bgFormInfo;
    }

    public void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        block5: {
            block4: {
                if (!BgHelper.ISDeBug) break block4;
                String delBgVersion = "delete from t_bg_bgversion  where FOriginalBgFormID = ? OR FAdaptedBgFormID = ? OR FPreBgFormID = ?";
                String delPastRecode = " DELETE FROM T_BG_BgPastData WHERE (FBgPastRecordID IN( SELECT fid FROM T_BG_BgPastRecord WHERE fbgformid = ?))";
                String delPastData = " DELETE FROM T_BG_BgPastRecord WHERE (FBgFormID = ?)";
                String delBgDataSql = " DELETE FROM T_BG_BgData  WHERE (FBgEntryID IN ( SELECT fid FROM t_bg_bgentry WHERE fbgformid = ?))";
                String delBgEntrySql = " DELETE FROM T_BG_BgEntry WHERE (FBgFormID = ?)";
                String delBgFormLogSql = " DELETE FROM t_bg_bgformlog WHERE (FBgFormID = ?)";
                String delBgPostilSql = " DELETE FROM T_BG_BgPostil WHERE (FBgFormID = ?)";
                String delBgFormSql = " DELETE FROM T_BG_BgForm WHERE (FID = ?)";
                String delBgKDSSql = " DELETE FROM T_BG_BgKDS WHERE (FBgFormID = ?)";
                Connection conn = null;
                PreparedStatement stmt = null;
                try {
                    conn = this.getConnection(ctx);
                    String id = pk.toString();
                    stmt = conn.prepareStatement(delBgVersion);
                    stmt.setString(1, id.toString());
                    stmt.setString(2, id.toString());
                    stmt.setString(3, id.toString());
                    stmt.executeUpdate();
                    stmt = conn.prepareStatement(delPastRecode);
                    stmt.setString(1, id);
                    stmt.executeUpdate();
                    stmt = conn.prepareStatement(delPastData);
                    stmt.setString(1, id);
                    stmt.executeUpdate();
                    stmt = conn.prepareStatement(delBgDataSql);
                    stmt.setString(1, id);
                    stmt.executeUpdate();
                    stmt = conn.prepareStatement(delBgEntrySql);
                    stmt.setString(1, id);
                    stmt.executeUpdate();
                    stmt = conn.prepareStatement(delBgFormLogSql);
                    stmt.setString(1, id);
                    stmt.executeUpdate();
                    stmt = conn.prepareStatement(delBgPostilSql);
                    stmt.setString(1, id);
                    stmt.executeUpdate();
                    stmt = conn.prepareStatement(delBgKDSSql);
                    stmt.setString(1, id);
                    stmt.executeUpdate();
                    stmt = conn.prepareStatement(delBgFormSql);
                    stmt.setString(1, id);
                    stmt.executeUpdate();
                }
                catch (SQLException e) {
                    try {
                        throw new BgORMException(BgORMException.DELETEENTITY, e, new Object[]{pk});
                    }
                    catch (Throwable throwable) {
                        SQLUtils.cleanup(stmt, (Connection)conn);
                        throw throwable;
                    }
                }
                SQLUtils.cleanup((Statement)stmt, (Connection)conn);
                break block5;
            }
            super._delete(ctx, pk);
        }
    }

    @Override
    public void _updateWithRecord(Context ctx, IObjectCollection modelCollection) throws BOSException, EASBizException {
        SimpleTimer st = new SimpleTimer();
        IBgForm iBgForm = BgFormFactory.getLocalInstance(ctx);
        IBgFormDA iBgFormDa = BgFormDAFactory.getLocalInstance(ctx);
        for (BgFormInfo newBgFormInfo : modelCollection) {
            if (newBgFormInfo.getId() == null) {
                this.addnew(ctx, (CoreBaseInfo)newBgFormInfo);
                continue;
            }
            if (!iBgForm.exists((IObjectPK)new ObjectUuidPK(newBgFormInfo.getId()))) continue;
            BgFormInfo oldBgFormInfo = iBgForm.getBgForm4Declare(newBgFormInfo.getId());
            this.updateDataSource(ctx, newBgFormInfo.getDataSource().getValue(), newBgFormInfo.isHasEffected(), oldBgFormInfo.getId().toString());
            this.update(ctx, newBgFormInfo, oldBgFormInfo);
        }
    }

    public void updateDataSource(Context ctx, int dataSource, boolean haseffected, String bgFormId) throws BOSException, EASBizException {
        Connection conn = this.getConnection(ctx);
        PreparedStatement stmt = null;
        String sql = "update T_BG_BgForm set fdatasource=?,fhaseffected=? WHERE FID = ?";
        try {
            stmt = conn.prepareStatement(sql);
            stmt.setInt(1, dataSource);
            stmt.setInt(2, haseffected ? 1 : 0);
            stmt.setString(3, bgFormId);
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            throw new BgBizException(BgBizException.GETDATA, e, new Object[]{"bgform"});
        }
        finally {
            SQLUtils.cleanup((Statement)stmt, (Connection)conn);
        }
    }

    private void addPastRecord(Context ctx, Connection cn, String bgFormId, String originalBgFormId) throws EASBizException {
        SimpleTimer st = new SimpleTimer();
        try {
            List lstBgData = BgCommon.getBgData(cn, bgFormId);
            List lstSrc = BgCommon.getBgData(cn, originalBgFormId);
            BgCommon.sub_addPastRecord(ctx, cn, lstSrc, lstBgData, originalBgFormId);
        }
        catch (SQLException se) {
            throw new BgInstantApproveException(BgInstantApproveException.DATABASEERROR, se);
        }
    }

    public void update(Context ctx, BgFormInfo newInfo, BgFormInfo oldInfo) throws EASBizException, BOSException {
        SimpleTimer st = new SimpleTimer();
        String[] bgFormAry = new String[]{"dataSource"};
        String[] bgEntryAry = new String[]{""};
        String[] bgDataAry = new String[]{"bgValue"};
        String[] bgPastRecAry = new String[]{"modifyDate"};
        String[] bgPstDataAry = new String[]{"balance"};
        BgFormDAHelper.addModelLisener(oldInfo, bgFormAry, bgEntryAry, bgDataAry, bgPastRecAry, bgPstDataAry);
        this.compare(ctx, newInfo, oldInfo);
        BgFormDAHelper.updateInfo(ctx, oldInfo);
    }

    public void update_declare(Context ctx, BgFormInfo newInfo, BgFormInfo oldInfo) throws EASBizException, BOSException {
        IBgForm iBgForm = BgFormFactory.getLocalInstance(ctx);
        this.added_swap(ctx, oldInfo, newInfo);
        oldInfo = iBgForm.getBgForm4Declare(oldInfo.getId());
        newInfo = iBgForm.getBgForm4Declare(newInfo.getId());
        this.deal_all_update(ctx, newInfo, oldInfo);
    }

    public void added_swap(Context ctx, BgFormInfo oriInfo, BgFormInfo info) throws EASBizException, BOSException {
        String[] bgFormAry = new String[]{"name", "number", "dataSource", "hasEffected"};
        String[] bgEntryAry = new String[]{"bgItem1", "bgItem2", "bgItem3", "bgItem4", "bgItem5", "bgItem6", "isLeafPeriod", "entryType"};
        String[] bgDataAry = new String[]{"bgValue", "bgBalance"};
        String[] bgPastRecAry = new String[]{"modifyDate"};
        String[] bgPstDataAry = new String[]{"balance"};
        BgFormDAHelper.addModelLisener(oriInfo, bgFormAry, bgEntryAry, bgDataAry, bgPastRecAry, bgPstDataAry);
        BgFormDAHelper.addModelLisener(info, bgFormAry, bgEntryAry, bgDataAry, bgPastRecAry, bgPstDataAry);
        BgEntryCollection addedColl = this.compareDiff(ctx, oriInfo, info);
        oriInfo.getBgEntries().addCollection(addedColl);
        BgFormDAHelper.updateInfo(ctx, oriInfo);
        BgFormDAHelper.updateInfo(ctx, info);
    }

    public BgEntryCollection compareDiff(Context ctx, BgFormInfo oriInfo, BgFormInfo info) throws BOSException {
        BgEntryInfo bgEntry;
        Object ob;
        int ln;
        BgEntryCollection oriColl = oriInfo.getBgEntries();
        BgEntryCollection coll = info.getBgEntries();
        BgEntryCollection addedColl = new BgEntryCollection();
        HashSearchEngine engine = new HashSearchEngine(BgORMEngine.getObjectValue(oriColl.toArray()), new String[]{"bgItem1", "bgItem2", "bgItem3", "bgItem4", "bgItem5", "bgItem6", "period"});
        int size = coll.size();
        Vector<BgEntryInfo> removeColl = new Vector<BgEntryInfo>();
        for (int i = 0; i < size; ++i) {
            BgEntryInfo curEntry = coll.get(i);
            if (engine.evaluate((IObjectValue)curEntry)) continue;
            removeColl.add(curEntry);
        }
        HashSearchEngine engine1 = new HashSearchEngine(BgORMEngine.getObjectValue(coll.toArray()), new String[]{"bgItem1", "bgItem2", "bgItem3", "bgItem4", "bgItem5", "bgItem6", "period"});
        int size1 = oriColl.size();
        Vector<BgEntryInfo> removeColl1 = new Vector<BgEntryInfo>();
        for (int i = 0; i < size1; ++i) {
            BgEntryInfo curEntry = oriColl.get(i);
            if (engine1.evaluate((IObjectValue)curEntry)) continue;
            removeColl1.add(curEntry);
        }
        if (removeColl.size() != 0) {
            ln = removeColl.size();
            for (int i = 0; i < ln && (ob = removeColl.get(i)) != null; ++i) {
                bgEntry = (BgEntryInfo)ob;
                coll.remove(bgEntry);
                bgEntry.setId(null);
                BgDataCollection dataColl = bgEntry.getBgData();
                int length = dataColl.size();
                for (int j = 0; j < length; ++j) {
                    BgDataInfo dataInfo = dataColl.get(j);
                    dataInfo.setBgBalance(dataInfo.getBgValue());
                    dataInfo.setId(null);
                }
                addedColl.add(bgEntry);
            }
        }
        if (removeColl1.size() != 0) {
            ln = removeColl1.size();
            for (int i = 0; i < ln && (ob = removeColl1.get(i)) != null; ++i) {
                bgEntry = (BgEntryInfo)ob;
                oriColl.remove(bgEntry);
                this.deletePastData(ctx, bgEntry.getId().toString());
            }
        }
        if (addedColl.size() != 0) {
            return addedColl;
        }
        return null;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void deletePastData(Context ctx, String entryId) throws BOSException {
        Connection conn = null;
        PreparedStatement sm = null;
        try {
            conn = this.getConnection(ctx);
            String strSql = "delete from t_bg_bgpastData where fbgdataid in(select fid from t_bg_bgdata where fbgentryid=?)";
            sm = conn.prepareStatement(strSql);
            sm.setString(1, entryId);
            sm.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
                catch (SQLDataException e2) {
                    throw new BOSException((Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(sm, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)sm, (Connection)conn);
    }

    public void deal_all_update(Context ctx, BgFormInfo newInfo, BgFormInfo oldInfo) throws EASBizException, BOSException {
        SimpleTimer st = new SimpleTimer();
        String[] bgFormAry = new String[]{"name", "number", "dataSource", "hasEffected"};
        String[] bgEntryAry = new String[]{"bgItem1", "bgItem2", "bgItem3", "bgItem4", "bgItem5", "bgItem6", "isLeafPeriod", "entryType"};
        String[] bgDataAry = new String[]{"bgValue", "bgBalance"};
        String[] bgPastRecAry = new String[]{"modifyDate"};
        String[] bgPstDataAry = new String[]{"balance"};
        BgFormDAHelper.addModelLisener(oldInfo, bgFormAry, bgEntryAry, bgDataAry, bgPastRecAry, bgPstDataAry);
        BgFormDAHelper.addModelLisener(newInfo, bgFormAry, bgEntryAry, bgDataAry, bgPastRecAry, bgPstDataAry);
        this.deal_all(ctx, newInfo, oldInfo);
        BgFormDAHelper.updateInfo(ctx, oldInfo);
        BgFormDAHelper.updateInfo(ctx, newInfo);
    }

    public void deal_all(Context ctx, BgFormInfo newInfo, BgFormInfo oldInfo) {
        BgEntryCollection oriColl = oldInfo.getBgEntries();
        BgEntryCollection coll = newInfo.getBgEntries();
        boolean hasNewPastRecord = false;
        BgPastRecordInfo reInfo = new BgPastRecordInfo();
        HashSearchEngine engine = new HashSearchEngine(BgORMEngine.getObjectValue(coll.toArray()), new String[]{"bgCycle", "period", "bgItem1", "bgItem2", "bgItem3", "bgItem4", "bgItem5", "bgItem6"});
        Iterator iter1 = oriColl.iterator();
        while (iter1.hasNext()) {
            BgEntryInfo preEntry = (BgEntryInfo)iter1.next();
            if (!engine.evaluate((IObjectValue)preEntry)) continue;
            BgDataCollection daColl = ((BgEntryInfo)engine.getResult()).getBgData();
            HashSearchEngine engine1 = new HashSearchEngine(BgORMEngine.getObjectValue(daColl.toArray()), new String[]{"elementNumber", "currency", "bgElement"});
            Iterator iter2 = preEntry.getBgData().iterator();
            while (iter2.hasNext()) {
                BgDataInfo preData = (BgDataInfo)iter2.next();
                if (!engine1.evaluate((IObjectValue)preData)) continue;
                BgDataInfo curData = (BgDataInfo)engine1.getResult();
                if (preData.getBgValue().compareTo(curData.getBgValue()) == 0) continue;
                if (!hasNewPastRecord) {
                    reInfo.setId(null);
                    try {
                        reInfo.setSeq(this.getSeq(ctx, oldInfo.getId().toString()) + 1);
                    }
                    catch (EASBizException e) {
                        e.printStackTrace();
                    }
                    catch (BOSException e) {
                        e.printStackTrace();
                    }
                    reInfo.setBgForm(oldInfo);
                    reInfo.setModifier(ContextUtils.getUser((Context)ctx));
                    reInfo.setModifyDate(new Date(System.currentTimeMillis()));
                }
                BgPastDataInfo pDaInfo = new BgPastDataInfo();
                pDaInfo.setId(null);
                pDaInfo.setPastValue(preData.getBgValue());
                pDaInfo.setBalance(curData.getBgValue().subtract(preData.getBgValue()));
                pDaInfo.setBgData(preData);
                pDaInfo.setBgPastRecord(reInfo);
                pDaInfo.setDataSource(BgFormDataSourceEnum.SUPERIORSPLIT);
                reInfo.getPastData().add(pDaInfo);
                BigDecimal preValue = preData.getBgValue();
                BigDecimal aa = curData.getBgValue().subtract(preData.getBgValue());
                preData.setBgBalance(preData.getBgBalance() == null ? aa : preData.getBgBalance().add(aa));
                preData.setBgValue(curData.getBgValue());
                curData.setBgValue(preValue);
            }
        }
        oldInfo.getPastRecords().add(reInfo);
    }

    private int getSeq(Context ctx, String bgFormId) throws EASBizException, BOSException {
        int result = 1;
        String sql = "select max(fseq) from t_bg_bgpastrecord where fbgformid=?";
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            conn = this.getConnection(ctx);
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, bgFormId);
            rs = stmt.executeQuery();
            if (rs.next()) {
                result = rs.getInt(1) + 1;
            }
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
                throw new BgInstantApproveException(BgInstantApproveException.DATABASEERROR, e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        return result;
    }

    private void update_periodTo(Context ctx, String oriBgFormId, BgCycleTypeEnum bgCycle) throws EASBizException, BOSException {
        String sql = "SELECT TOP 1 E.FPeriodID FROM T_BD_Period P INNER JOIN  T_BG_BgEntry E ON P.FID = E.FPeriodID WHERE (E.FBgFormID = ?)  ORDER BY P.FPeriodYear DESC, P.FPeriodNumber DESC ";
        String sql1 = "update t_bg_bgform set fperiodtoid=? where fid=?";
        String sql2 = "select top 1 a.fid from t_bd_period a ,t_bd_period b  where a.ftypeid=b.ftypeid and a.fperiodyear=b.fperiodyear and a.fperiodquarter=b.fperiodquarter and b.fid=?  order by a.fperiodnumber desc";
        Connection cn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            cn = this.getConnection(ctx);
            stmt = cn.prepareStatement(sql);
            stmt.setString(1, BOSUuid.read((String)oriBgFormId).toString());
            rs = stmt.executeQuery();
            String periodId = "";
            if (rs.next()) {
                periodId = rs.getString(1);
            }
            if (bgCycle.equals((Object)BgCycleTypeEnum.Season)) {
                stmt = cn.prepareStatement(sql2);
                stmt.setString(1, periodId);
                rs = stmt.executeQuery();
                if (rs.next()) {
                    periodId = rs.getString(1);
                }
            }
            stmt = cn.prepareStatement(sql1);
            stmt.setString(1, periodId);
            stmt.setString(2, oriBgFormId);
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new BgInstantApproveException(BgInstantApproveException.DATABASEERROR, e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)cn);
    }

    public void compare(Context ctx, BgFormInfo newInfo, BgFormInfo oldInfo) {
        SimpleTimer st = new SimpleTimer();
        oldInfo.setDataSource(newInfo.getDataSource());
        BgEntryCollection oriColl = oldInfo.getBgEntries();
        BgEntryCollection coll = newInfo.getBgEntries();
        boolean hasNewPastRecord = false;
        BgPastRecordInfo reInfo = new BgPastRecordInfo();
        HashSearchEngine engine = new HashSearchEngine(BgORMEngine.getObjectValue(coll.toArray()), new String[]{"id"});
        Iterator iter1 = oriColl.iterator();
        while (iter1.hasNext()) {
            BgEntryInfo preEntry = (BgEntryInfo)iter1.next();
            if (!engine.evaluate((IObjectValue)preEntry)) continue;
            BgDataCollection daColl = ((BgEntryInfo)engine.getResult()).getBgData();
            HashSearchEngine engine1 = new HashSearchEngine(BgORMEngine.getObjectValue(daColl.toArray()), new String[]{"id"});
            Iterator iter2 = preEntry.getBgData().iterator();
            while (iter2.hasNext()) {
                BgDataInfo preData = (BgDataInfo)iter2.next();
                if (!engine1.evaluate((IObjectValue)preData)) continue;
                BgDataInfo curData = (BgDataInfo)engine1.getResult();
                if (preData.getBgValue().compareTo(curData.getBgValue()) == 0) continue;
                if (!hasNewPastRecord) {
                    reInfo.setId(null);
                    reInfo.setSeq(oldInfo.getPastRecords().size() + 1);
                    reInfo.setBgForm(oldInfo);
                    reInfo.setModifier(ContextUtils.getUser((Context)ctx));
                    reInfo.setModifyDate(new Date(System.currentTimeMillis()));
                }
                BgPastDataInfo pDaInfo = new BgPastDataInfo();
                pDaInfo.setId(null);
                pDaInfo.setPastValue(preData.getBgValue());
                pDaInfo.setBalance(curData.getBgValue().subtract(preData.getBgValue()));
                pDaInfo.setBgData(preData);
                pDaInfo.setBgPastRecord(reInfo);
                pDaInfo.setDataSource(newInfo.getDataSource());
                reInfo.getPastData().add(pDaInfo);
                preData.setBgValue(curData.getBgValue());
            }
        }
        oldInfo.getPastRecords().add(reInfo);
    }

    @Override
    public IObjectValue _updateWithRecord(Context ctx, IObjectValue newBgForm, IObjectValue oldBgForm) throws BOSException, EASBizException {
        BgFormInfo newBgFormInfo = (BgFormInfo)newBgForm;
        BgFormInfo oldBgFormInfo = (BgFormInfo)oldBgForm;
        newBgFormInfo.getPastRecords().add(BgPastRecordInfo.generatePastRecord(newBgFormInfo, oldBgFormInfo, ctx));
        return newBgFormInfo;
    }

    @Override
    public boolean _checkRefByBgVersin(Context ctx, String id) throws BOSException, EASBizException {
        ResultSet rs;
        PreparedStatement stmt;
        Connection conn;
        block4: {
            boolean bl;
            conn = this.getConnection(ctx);
            stmt = null;
            rs = null;
            String refVersionSql = "select COUNT(FID) AS theCount from t_bg_bgversion where FOriginalBgFormID = ? OR FAdaptedBgFormID = ? OR FPreBgFormID = ?";
            try {
                int theCount;
                stmt = conn.prepareStatement(refVersionSql);
                stmt.setString(1, id);
                stmt.setString(2, id);
                stmt.setString(3, id);
                rs = stmt.executeQuery();
                if (!rs.next() || (theCount = rs.getInt("theCount")) <= 0) break block4;
                bl = true;
            }
            catch (SQLException e) {
                try {
                    throw new EASBizException(BgBizException.GETDATA, (Throwable)e, new Object[]{"BgVersion"});
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs, (Statement)stmt, (Connection)conn);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
            return bl;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        return false;
    }

    @Override
    public void _checkRemovable(Context ctx, String id) throws BOSException, EASBizException {
        Connection conn = this.getConnection(ctx);
        PreparedStatement stmt = null;
        ResultSet rs = null;
        String getStateSql = "SELECT FState AS theState FROM T_BG_BgForm WHERE FID = ?";
        try {
            int state;
            stmt = conn.prepareStatement(getStateSql);
            stmt.setString(1, id);
            rs = stmt.executeQuery();
            if (rs.next() && (state = rs.getInt("theState")) == 2) {
                throw new BgFormException(BgFormException.APPROVEDDELETENOTALLOWED);
            }
        }
        catch (SQLException e) {
            try {
                throw new EASBizException(BgBizException.GETDATA, (Throwable)e, new Object[]{"BgVersion"});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        IObjectPK rs = super._save(ctx, model);
        return rs;
    }

    public void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        BgFormInfo newMode = (BgFormInfo)model;
        this.checkNumberDup(ctx, (IObjectPK)new ObjectUuidPK(newMode.getId()), (CoreBillBaseInfo)newMode);
        if (BgORMEngine.getIsBgORM(model)) {
            UserInfo userInfo = new UserInfo();
            userInfo.setId(BOSUuid.read((String)ctx.getCaller().toString()));
            newMode.setLastUpdateUser(userInfo);
            newMode.setLastUpdateTime(new Timestamp(new Date().getTime()));
            String[] ormObjectAry = BgORMEngine.getORMObjectAry(model);
            String[] bgProperty = BgORMEngine.getMainPropertyAry(model);
            BgORMEngine.storeVOColl(ctx, new IObjectValue[]{model}, bgProperty);
            for (int i = 0; i < ormObjectAry.length; ++i) {
                BOSUuid[] ids;
                IObjectValue[] coll = (IObjectValue[])model.get(ormObjectAry[i] + "key");
                if (coll != null) {
                    BgORMEngine.storeVOColl(ctx, coll, (String[])model.get(ormObjectAry[i] + "property"));
                }
                if ((ids = (BOSUuid[])model.get(ormObjectAry[i] + "deletedIds")) == null) continue;
                BgORMEngine.removeVOColl(ctx, ids);
            }
        } else {
            super._update(ctx, pk, model);
        }
    }

    public IObjectPK _addnew(Context ctx, IObjectValue cmodel) throws BOSException, EASBizException {
        BgFormInfo info = null;
        String newId = "";
        BgKDSInfo kdsInfo = new BgKDSInfo();
        if (cmodel instanceof CompressedObjectValue) {
            try {
                info = (BgFormInfo)((CompressedObjectValue)cmodel).getUncompressedObject();
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
        } else {
            info = (BgFormInfo)cmodel;
        }
        this.checkNumberDup(ctx, null, (CoreBillBaseInfo)info);
        if (BgHelper.ISDeBug) {
            Iterator dataIter;
            UserInfo userInfo = new UserInfo();
            userInfo.setId(BOSUuid.read((String)ctx.getCaller().toString()));
            BgFormInfo objectBaseInfo = null;
            objectBaseInfo = info;
            Object pk = null;
            objectBaseInfo.setCreator(userInfo);
            Date date = new Date();
            long time = date.getTime();
            objectBaseInfo.setCreateTime(new Timestamp(time));
            objectBaseInfo.setLastUpdateUser(userInfo);
            objectBaseInfo.setLastUpdateTime(new Timestamp(time));
            ArrayList<BgDataInfo> dataColl = new ArrayList<BgDataInfo>();
            ArrayList<BgEntryInfo> entryColl = new ArrayList<BgEntryInfo>();
            ArrayList<BgPastDataInfo> pastDataColl = new ArrayList<BgPastDataInfo>();
            ArrayList<BgPastRecordInfo> pastRecColl = new ArrayList<BgPastRecordInfo>();
            Iterator iter = info.getBgEntries().iterator();
            while (iter.hasNext()) {
                BgEntryInfo bgEntry = (BgEntryInfo)iter.next();
                dataIter = bgEntry.getBgData().iterator();
                while (dataIter.hasNext()) {
                    BgDataInfo bgData = (BgDataInfo)dataIter.next();
                    bgData.setBgEntry(bgEntry);
                    dataColl.add(bgData);
                }
                bgEntry.setBgForm(info);
                entryColl.add(bgEntry);
            }
            iter = info.getPastRecords().iterator();
            while (iter.hasNext()) {
                BgPastRecordInfo bgpastRec = (BgPastRecordInfo)iter.next();
                dataIter = bgpastRec.getPastData().iterator();
                while (dataIter.hasNext()) {
                    BgPastDataInfo bgPastData = (BgPastDataInfo)dataIter.next();
                    bgPastData.setBgPastRecord(bgpastRec);
                    pastDataColl.add(bgPastData);
                }
                bgpastRec.setBgForm(info);
                pastRecColl.add(bgpastRec);
            }
            BgDataInfo[] bgDataAry = new BgDataInfo[]{};
            BgEntryInfo[] bgEntryAry = new BgEntryInfo[]{};
            BgPastDataInfo[] bgPastDataAry = new BgPastDataInfo[]{};
            BgPastRecordInfo[] bgPastRecAry = new BgPastRecordInfo[]{};
            BgORMEngine.addnewVO(ctx, (IObjectValue[])new BgFormInfo[]{info});
            if (info.getState().getValue() == 4) {
                BgORMEngine.addnewVO(ctx, (IObjectValue[])entryColl.toArray(bgEntryAry));
                BgORMEngine.addnewVO(ctx, (IObjectValue[])dataColl.toArray(bgDataAry));
            }
            BgORMEngine.addnewVO(ctx, (IObjectValue[])pastRecColl.toArray(bgPastRecAry));
            BgORMEngine.addnewVO(ctx, (IObjectValue[])pastDataColl.toArray(bgPastDataAry));
            try {
                BOSUuid bosuuid;
                int i;
                int n = entryColl.size();
                for (i = 0; i < n; ++i) {
                    BgEntryInfo bgEntry = (BgEntryInfo)entryColl.get(i);
                    bosuuid = BOSUuid.create((BOSObjectType)bgEntry.getBOSType());
                    bgEntry.setId(bosuuid);
                }
                n = dataColl.size();
                for (i = 0; i < n; ++i) {
                    BgDataInfo bgData = (BgDataInfo)dataColl.get(i);
                    bosuuid = BOSUuid.create((BOSObjectType)bgData.getBOSType());
                    bgData.setId(bosuuid);
                }
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(baos);
                oos.writeObject(entryColl);
                byte[] byteArray = baos.toByteArray();
                kdsInfo.setBgEntryArray(byteArray);
                bosuuid = BOSUuid.create((BOSObjectType)kdsInfo.getBOSType());
                kdsInfo.setId(bosuuid);
                BgFormInfo bgFormInfo = new BgFormInfo();
                bgFormInfo.setId(info.getId());
                kdsInfo.setBgForm(bgFormInfo);
                IBgKDS iBgKDS = BgKDSFactory.getLocalInstance(ctx);
                iBgKDS.addnew(kdsInfo);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            return super._addnew(ctx, (IObjectValue)info);
        }
        newId = info.getId().toString();
        return new ObjectUuidPK(newId);
    }

    @Override
    public IObjectValue _getBgForm4Audit(Context ctx, BOSUuid id) throws BOSException, EASBizException {
        BgFormInfo info = new BgFormInfo();
        BgTemplateInfo temInfo = new BgTemplateInfo();
        String sql = "SELECT E.FID AS FBgEntryID, E.FSeq, E.FBgCycle, E.FPeriodID, E.FBgItem1ID, E.FBgItem2ID, E.FBgItem3ID, E.FBgItem4ID, E.FBgItem5ID, E.FBgItem6ID, E.FIsInitialized, E.FIsLeafPeriod, E.FIsLeafEntry,E.FEntryType,E.FSplitRate, D.FID AS FBgDataID, D.FBgElementID, D.FCurrencyID, D.FBgValue, D.FDataType, D.FBgBalance, D.FBgActual, D.FBgCtrlType, D.FElementNumber, D.FIsFlexibleCtrl, D.FFlexibleBgCtrlParam, D.FRelativeCtrlFormula, D.FBizActual, D.FBgUsableValue, D.FBgLastBalance, D.FBgInitialValue, D.FIdentity,  H.FBgCycle TemBgCycle  FROM T_BG_BgForm F LEFT OUTER JOIN T_BG_BgEntry E ON F.FID = E.FBgFormID LEFT OUTER JOIN T_BG_BgData D ON E.FID = D.FBgEntryID INNER JOIN T_BG_BgTemplate H ON F.FBgTemplateID = H.FID   WHERE (F.FID = ?) ORDER BY D.FBgEntryID";
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            conn = this.getConnection(ctx);
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, id.toString());
            rs = stmt.executeQuery();
            info.setId(id);
            BgEntryInfo bgEntry = null;
            String lastEntryId = null;
            BgDataInfo bgData = null;
            HashMap cache = new HashMap();
            while (rs.next()) {
                String dataId;
                String entryId = rs.getString("FBgEntryID");
                int bgCycle = rs.getInt("TemBgCycle");
                temInfo.setBgCycle(BgCycleTypeEnum.getEnum(bgCycle));
                if (!BgHelper.equals(entryId, lastEntryId)) {
                    bgEntry = new BgEntryInfo();
                    bgEntry.setId(BOSUuid.read((String)entryId));
                    this.trance((IObjectValue)bgEntry, rs, "seq", "FSeq");
                    this.trance((IObjectValue)bgEntry, rs, "bgCycle", "FBgCycle");
                    bgEntry.setPeriod(this.getPeriod(rs, "FPeriodID", cache));
                    bgEntry.setBgItem1(this.getBgItem(rs, "FBgItem1ID", cache));
                    bgEntry.setBgItem2(this.getBgItem(rs, "FBgItem2ID", cache));
                    bgEntry.setBgItem3(this.getBgItem(rs, "FBgItem3ID", cache));
                    bgEntry.setBgItem4(this.getBgItem(rs, "FBgItem4ID", cache));
                    bgEntry.setBgItem5(this.getBgItem(rs, "FBgItem5ID", cache));
                    bgEntry.setBgItem6(this.getBgItem(rs, "FBgItem6ID", cache));
                    this.trance((IObjectValue)bgEntry, rs, "isInitialized", "FIsInitialized");
                    this.trance((IObjectValue)bgEntry, rs, "isLeafPeriod", "FIsLeafPeriod");
                    this.trance((IObjectValue)bgEntry, rs, "isLeafEntry", "FIsLeafEntry");
                    this.trance((IObjectValue)bgEntry, rs, "entryType", "FEntryType");
                    this.trance((IObjectValue)bgEntry, rs, "splitRate", "FSplitRate");
                    bgEntry.setBgForm(info);
                    info.getBgEntries().add(bgEntry);
                    lastEntryId = entryId;
                }
                if ((dataId = rs.getString("FBgDataID")) == null) continue;
                bgData = new BgDataInfo();
                bgData.setId(BOSUuid.read((String)dataId));
                bgData.setBgElement(this.getBgElement(rs, "FBgElementID", cache));
                bgData.setCurrency(this.getCurrency(rs, "FCurrencyID", cache));
                this.trance((IObjectValue)bgData, rs, "bgvalue", "FBgValue");
                this.trance((IObjectValue)bgData, rs, "datatype", "FDataType");
                this.trance((IObjectValue)bgData, rs, "bgbalance", "fbgbalance");
                this.trance((IObjectValue)bgData, rs, "bgactual", "Fbgactual");
                this.trance((IObjectValue)bgData, rs, "bgctrltype", "fbgctrltype");
                this.trance((IObjectValue)bgData, rs, "elementnumber", "felementnumber");
                this.trance((IObjectValue)bgData, rs, "isFlexibleCtrl", "fisflexibleCtrl");
                this.trance((IObjectValue)bgData, rs, "flexibleBgCtrlParam", "fflexiblebgctrlparam");
                this.trance((IObjectValue)bgData, rs, "relativectrlformula", "frelativectrlformula");
                this.trance((IObjectValue)bgData, rs, "bizActual", "fbizactual");
                this.trance((IObjectValue)bgData, rs, "bgusablevalue", "fbgusablevalue");
                this.trance((IObjectValue)bgData, rs, "bglastbalance", "fbglastbalance");
                this.trance((IObjectValue)bgData, rs, "bginitialvalue", "fbginitialvalue");
                this.trance((IObjectValue)bgData, rs, "identity", "fidentity");
                bgData.setBgEntry(bgEntry);
                if (bgEntry == null) continue;
                bgEntry.getBgData().add(bgData);
            }
            info.setBgTemplate(temInfo);
        }
        catch (SQLException e) {
            try {
                throw new BgBizException(BgBizException.GETDATA, e, new Object[]{"bgform"});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        return info;
    }

    @Override
    public IObjectValue _getBgForm4Declare(Context ctx, BOSUuid id) throws BOSException, EASBizException {
        BgFormInfo info = new BgFormInfo();
        String sql = "SELECT E.FID AS FBgEntryID, D.FID AS FBgDataID, D.FBgValue, D.FIdentity FROM T_BG_BgForm F LEFT OUTER JOIN T_BG_BgEntry E ON F.FID = E.FBgFormID LEFT OUTER JOIN T_BG_BgData D ON E.FID = D.FBgEntryID WHERE (F.FID = ?) ORDER BY D.FBgEntryID";
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            conn = this.getConnection(ctx);
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, id.toString());
            rs = stmt.executeQuery();
            info.setId(id);
            BgEntryInfo bgEntry = null;
            String lastEntryId = null;
            BgDataInfo bgData = null;
            HashMap cache = new HashMap();
            while (rs.next()) {
                String dataId;
                String entryId = rs.getString("FBgEntryID");
                if (!BgHelper.equals(entryId, lastEntryId)) {
                    bgEntry = new BgEntryInfo();
                    bgEntry.setId(BOSUuid.read((String)entryId));
                    bgEntry.setBgForm(info);
                    info.getBgEntries().add(bgEntry);
                    lastEntryId = entryId;
                }
                if ((dataId = rs.getString("FBgDataID")) == null) continue;
                bgData = new BgDataInfo();
                bgData.setId(BOSUuid.read((String)dataId));
                this.trance((IObjectValue)bgData, rs, "bgvalue", "FBgValue");
                this.trance((IObjectValue)bgData, rs, "identity", "fidentity");
                bgData.setBgEntry(bgEntry);
                if (bgEntry == null) continue;
                bgEntry.getBgData().add(bgData);
            }
            this.addPstRec(ctx, info);
        }
        catch (SQLException e) {
            try {
                throw new BgBizException(BgBizException.GETDATA, e, new Object[]{"bgform"});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        return info;
    }

    public BgFormInfo addPstRec(Context ctx, BgFormInfo info) throws BOSException, EASBizException {
        String sql = "SELECT  FID, FSeq, FModifyDate, FModifierID FROM T_BG_BgPastRecord WHERE (FBgFormID = ?)";
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            conn = this.getConnection(ctx);
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, info.getId().toString());
            rs = stmt.executeQuery();
            BgPastRecordInfo pstRec = null;
            while (rs.next()) {
                pstRec = new BgPastRecordInfo();
                pstRec.setId(BOSUuid.read((String)rs.getString("FID")));
                this.trance((IObjectValue)pstRec, rs, "seq", "Fseq");
                info.getPastRecords().add(pstRec);
            }
        }
        catch (SQLException e) {
            try {
                throw new BgBizException(BgBizException.GETDATA, e, new Object[]{"bgform"});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        return info;
    }

    private void trance(IObjectValue bgEntry, ResultSet rs, String voName, String dbName) throws ORMCoreException, SQLException {
        bgEntry.put(voName, rs.getObject(dbName));
    }

    private PeriodInfo getPeriod(ResultSet rs, String name, Map cache) throws SQLException {
        PeriodInfo info = null;
        String id = rs.getString(name);
        if (id != null) {
            Object o = cache.get(id);
            if (o != null) {
                info = (PeriodInfo)o;
            } else {
                info = new PeriodInfo();
                info.setId(BOSUuid.read((String)id));
            }
        }
        return info;
    }

    private BgItemInfo getBgItem(ResultSet rs, String name, Map cache) throws SQLException {
        BgItemInfo info = null;
        String id = rs.getString(name);
        if (id != null) {
            Object o = cache.get(id);
            if (o != null) {
                info = (BgItemInfo)o;
            } else {
                info = new BgItemInfo();
                info.setId(BOSUuid.read((String)id));
            }
        }
        return info;
    }

    private BgElementInfo getBgElement(ResultSet rs, String name, Map cache) throws SQLException {
        BgElementInfo info = null;
        String id = rs.getString(name);
        if (id != null) {
            Object o = cache.get(id);
            if (o != null) {
                info = (BgElementInfo)o;
            } else {
                info = new BgElementInfo();
                info.setId(BOSUuid.read((String)id));
            }
        }
        return info;
    }

    private CurrencyInfo getCurrency(ResultSet rs, String name, Map cache) throws SQLException {
        CurrencyInfo info = null;
        String id = rs.getString(name);
        if (id != null) {
            Object o = cache.get(id);
            if (o != null) {
                info = (CurrencyInfo)o;
            } else {
                info = new CurrencyInfo();
                info.setId(BOSUuid.read((String)id));
            }
        }
        return info;
    }

    @Override
    protected void _updateForm(Context ctx, IObjectValue bgFormInfo, Hashtable newBgItems) throws EASBizException, BOSException {
        IBgItem ibi = BgItemFactory.getLocalInstance(ctx);
        for (BOSUuid id : newBgItems.keySet()) {
            BgItemInfo info = (BgItemInfo)newBgItems.get(id);
            try {
                this.addNewBgItem(ctx, info);
            }
            catch (SQLDataException e) {
                throw new BOSException((Throwable)e);
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        BgFormInfo mode = (BgFormInfo)bgFormInfo;
        this.checkNumberDup(ctx, (IObjectPK)new ObjectUuidPK(mode.getId()), (CoreBillBaseInfo)mode);
        BgFormDAHelper.updateInfo(ctx, mode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNewBgItem(Context ctx, BgItemInfo info) throws SQLDataException, SQLException {
        StringBuffer sb = new StringBuffer(40);
        sb.append("insert into t_bg_bgitem(FID,FIsLeaf,FLongNumber,FItemID,FItemNumber,FItemName_L1,FItemName_L2,FItemName_L3,FRefDimensionID,FBgDimension,FIsFromParent) ");
        sb.append(" values(?,?,?,?,?,?,?,?,?,?,?)");
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            conn = this.getConnection(ctx);
            stmt = conn.prepareStatement(sb.toString());
            stmt.setString(1, info.getId().toString());
            stmt.setInt(2, info.isIsLeaf() ? 1 : 0);
            stmt.setString(3, info.getLongNumber());
            stmt.setString(4, info.getItemID().toString());
            stmt.setString(5, info.getItemNumber());
            stmt.setString(6, null);
            stmt.setString(7, info.getItemName());
            stmt.setString(8, null);
            stmt.setString(9, null);
            stmt.setInt(10, info.getBgDimension().getValue());
            stmt.setInt(11, 0);
            stmt.executeUpdate();
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)conn);
                throw throwable;
            }
            SQLUtils.cleanup(rs, (Statement)stmt, (Connection)conn);
        }
        SQLUtils.cleanup(rs, (Statement)stmt, (Connection)conn);
    }

    @Override
    protected IObjectPK _updateWithRecord_declare(Context ctx, IObjectCollection modelCollection, Hashtable hashBgOpr) throws BOSException, EASBizException {
        SimpleTimer st = new SimpleTimer();
        IBgForm iBgForm = BgFormFactory.getLocalInstance(ctx);
        IBgFormDA iBgFormDa = BgFormDAFactory.getLocalInstance(ctx);
        Iterator iter = modelCollection.iterator();
        UserInfo use = ContextUtils.getUser((Context)ctx);
        BgFormInfo bgForm = new BgFormInfo();
        IBgKDS iBgKDS = BgKDSFactory.getLocalInstance(ctx);
        ArrayList<BOSUuid> addnewList = new ArrayList<BOSUuid>();
        ArrayList<BOSUuid> updateList = new ArrayList<BOSUuid>();
        while (iter.hasNext()) {
            BgOperationEnum bgOpr;
            BgFormInfo newBgFormInfo = (BgFormInfo)iter.next();
            if (newBgFormInfo.getId() == null) {
                ObjectUuidPK pkid = (ObjectUuidPK)this.addnew(ctx, (CoreBaseInfo)newBgFormInfo);
                bgOpr = (BgOperationEnum)((Object)hashBgOpr.get(newBgFormInfo.getOrgUnit().getId().toString()));
                if (bgOpr != null) {
                    bgForm.setId(BOSUuid.read((String)pkid.toString()));
                    BgFormLogHelper.addNewBgFormLog(ctx, bgForm, bgOpr, use);
                }
                BOSUuid formId = BOSUuid.read((String)pkid.toString());
                iBgKDS.updateBgFormState(formId, 50);
                addnewList.add(formId);
                continue;
            }
            if (!iBgForm.exists((IObjectPK)new ObjectUuidPK(newBgFormInfo.getId()))) continue;
            BgFormInfo oldBgFormInfo = iBgForm.getBgForm4Declare(newBgFormInfo.getId());
            this.updateDataSource(ctx, newBgFormInfo.getDataSource().getValue(), newBgFormInfo.isHasEffected(), oldBgFormInfo.getId().toString());
            this.update(ctx, newBgFormInfo, oldBgFormInfo);
            bgOpr = (BgOperationEnum)((Object)hashBgOpr.get(newBgFormInfo.getOrgUnit().getId().toString()));
            if (bgOpr != null) {
                bgForm.setId(newBgFormInfo.getId());
                BgFormLogHelper.addNewBgFormLog(ctx, bgForm, bgOpr, use);
            }
            iBgKDS.updateBgFormState(newBgFormInfo.getId(), 52);
            updateList.add(newBgFormInfo.getId());
        }
        return null;
    }

    @Override
    protected void _updateWithRecord_distribute(Context ctx, IObjectCollection modelCollection, Hashtable hashBgOpr) throws BOSException, EASBizException {
        SimpleTimer st = new SimpleTimer();
        IBgForm iBgForm = BgFormFactory.getLocalInstance(ctx);
        IBgFormDA iBgFormDa = BgFormDAFactory.getLocalInstance(ctx);
        Iterator iter = modelCollection.iterator();
        UserInfo use = ContextUtils.getUser((Context)ctx);
        BgFormInfo bgForm = new BgFormInfo();
        IBgKDS iBgKDS = BgKDSFactory.getLocalInstance(ctx);
        ArrayList addnewList = new ArrayList();
        ArrayList updateList = new ArrayList();
        while (iter.hasNext()) {
            BgOperationEnum bgOpr;
            BgFormInfo newBgFormInfo = (BgFormInfo)iter.next();
            if (newBgFormInfo.getId() == null) {
                ObjectUuidPK pkid = (ObjectUuidPK)this.addnew(ctx, (CoreBaseInfo)newBgFormInfo);
                bgOpr = (BgOperationEnum)((Object)hashBgOpr.get(newBgFormInfo.getOrgUnit().getId().toString()));
                if (bgOpr != null) {
                    bgForm.setId(BOSUuid.read((String)pkid.toString()));
                    BgFormLogHelper.addNewBgFormLog(ctx, bgForm, bgOpr, use);
                }
                BOSUuid formId = BOSUuid.read((String)pkid.toString());
                iBgKDS.updateBgFormState(formId, 50);
                iBgKDS.addnewBgForm(formId);
                iBgKDS.updateBgFormState(formId, 8);
                continue;
            }
            if (!iBgForm.exists((IObjectPK)new ObjectUuidPK(newBgFormInfo.getId()))) continue;
            BgFormInfo oldBgFormInfo = iBgForm.getBgForm4Declare(newBgFormInfo.getId());
            this.updateDataSource(ctx, newBgFormInfo.getDataSource().getValue(), newBgFormInfo.isHasEffected(), oldBgFormInfo.getId().toString());
            this.update(ctx, newBgFormInfo, oldBgFormInfo);
            bgOpr = (BgOperationEnum)((Object)hashBgOpr.get(newBgFormInfo.getOrgUnit().getId().toString()));
            if (bgOpr != null) {
                bgForm.setId(newBgFormInfo.getId());
                BgFormLogHelper.addNewBgFormLog(ctx, bgForm, bgOpr, use);
            }
            iBgKDS.updateBgFormState(newBgFormInfo.getId(), 52);
            iBgKDS.updateBgForm(newBgFormInfo.getId());
            iBgKDS.updateBgFormState(newBgFormInfo.getId(), 8);
        }
    }

    @Override
    protected void _submitBgForm(Context ctx, BOSUuid id) throws BOSException, EASBizException {
    }

    @Override
    protected void _submitAdjustBgFormWF(Context ctx, BOSUuid id) throws BOSException, EASBizException {
    }

    @Override
    protected void _submitRollBgFormWF(Context ctx, BOSUuid id) throws BOSException, EASBizException {
    }

    @Override
    protected void _updateAdjustBgFormWF(Context ctx, BOSUuid id) throws BOSException, EASBizException {
    }

    @Override
    protected void _updateRollBgFormWF(Context ctx, BOSUuid id) throws BOSException, EASBizException {
    }

    @Override
    protected IObjectValue _getBgformFormDis(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        Connection conn = this.getConnection(ctx);
        PreparedStatement ps = null;
        ResultSet rs = null;
        BgFormInfo bti = null;
        try {
            StringBuffer strBuffer = new StringBuffer(" select  a.fid, a.fstate, a.fnumber, a.fbgtypeid, b.fid, b.fparentid,  b.fbgcycle, a.fbgschemeid  from t_bg_bgform a ,t_bg_bgtemplate b , t_bg_bgtype c,t_bg_bgscheme d where a.fbgtemplateid=b.fid and  a.fbgtypeid = c.fid and a.fbgschemeid=d.fid and a.fid=? ");
            ps = conn.prepareStatement(strBuffer.toString());
            ps.setString(1, pk.toString());
            rs = ps.executeQuery();
            if (rs.next()) {
                bti = new BgFormInfo();
                bti.setId(BOSUuid.read((String)rs.getString(1)));
                bti.setState(BgFormStateEnum.getEnum(rs.getInt(2)));
                bti.setNumber(rs.getString(3));
                BgTypeInfo bgType = new BgTypeInfo();
                bgType.setId(BOSUuid.read((String)rs.getString(4)));
                bti.setBgType(bgType);
                BgTemplateInfo tem = new BgTemplateInfo();
                tem.setId(BOSUuid.read((String)rs.getString(5)));
                BgTemplateInfo parent = new BgTemplateInfo();
                if (rs.getString(5) == null) {
                    tem.setParent(null);
                } else {
                    parent.setId(BOSUuid.read((String)rs.getString(6)));
                    tem.setParent(parent);
                }
                tem.setBgCycle(BgCycleTypeEnum.getEnum(rs.getInt(7)));
                bti.setBgTemplate(tem);
                BgSchemeInfo scheme = new BgSchemeInfo();
                scheme.setId(BOSUuid.read((String)rs.getString(8)));
                bti.setBgScheme(scheme);
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)conn);
        return bti;
    }

    protected boolean _checkNumberDup(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        BillBaseInfo billBaseInfo = (BillBaseInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("number", (Object)billBaseInfo.getString("number"), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (billBaseInfo.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)billBaseInfo.getId().toString(), CompareType.NOTEQUALS));
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < filter.getFilterItems().size(); ++i) {
            if (i != 0) {
                sb.append(" and #" + i);
                continue;
            }
            sb.append("#" + i);
        }
        filter.setMaskString(sb.toString());
        if (super._exists(ctx, filter)) {
            throw new EASBizException(EASBizException.CHECKDUPNUMBER, new Object[]{billBaseInfo.getString("number"), ""});
        }
        return true;
    }
}

