/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bg.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CashFlowItemCollection;
import com.kingdee.eas.basedata.assistant.CashFlowItemInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.bg.BgBizException;
import com.kingdee.eas.ma.bg.BgDaHelper;
import com.kingdee.eas.ma.bg.BgItemCollection;
import com.kingdee.eas.ma.bg.BgItemFactory;
import com.kingdee.eas.ma.bg.BgItemInfo;
import com.kingdee.eas.ma.bg.IBgItem;
import com.kingdee.eas.ma.bg.app.AbstractBgItemControllerBean;
import com.kingdee.jdbc.rowset.impl.JdbcRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.Vector;

public class BgItemControllerBean
extends AbstractBgItemControllerBean {
    private IObjectCollection getCashFlowItems(Context ctx, IObjectCollection bgItems) throws BOSException, EASBizException {
        if (bgItems == null || bgItems.size() == 0) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(" SELECT FID AS id, FDirection AS direction ");
        sb.append(" FROM T_BD_CashFlowItem ");
        sb.append(" WHERE FID IN (" + this.bgItemsToSqlFormat((BgItemCollection)bgItems) + ") ");
        sb.append(" ORDER BY FNumber ");
        Connection conn = this.getConnection(ctx);
        try {
            JdbcRowSet rowSet = (JdbcRowSet)SQLUtils.getJdbcRowSet((Connection)conn, (String)sb.toString());
            if (rowSet.size() != bgItems.size()) {
                throw new EASBizException(EASBizException.CHECKBLANK);
            }
            CashFlowItemCollection cfic = new CashFlowItemCollection();
            rowSet.first();
            do {
                String theId;
                if (!BgDaHelper.isValidIdString(theId = rowSet.getString("id"))) continue;
                CashFlowItemInfo cfii = new CashFlowItemInfo();
                cfii.setId(BOSUuid.read((String)theId));
                cfii.setInt("direction", rowSet.getInt("direction"));
                cfic.add(cfii);
            } while (rowSet.next());
            CashFlowItemCollection cashFlowItemCollection = cfic;
            return cashFlowItemCollection;
        }
        catch (SQLException e) {
            throw new EASBizException(EASBizException.CHECKBLANK);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
    }

    public String bgItemsToSqlFormat(BgItemCollection bic) {
        StringBuffer sb = new StringBuffer(500);
        Iterator iter = bic.iterator();
        while (iter.hasNext()) {
            BgItemInfo bii = (BgItemInfo)iter.next();
            BOSUuid theId = bii.getItemID();
            if (theId == null) continue;
            if (sb.toString().length() > 0) {
                sb.append(",'");
                sb.append(theId.toString());
                sb.append("'");
                continue;
            }
            sb.append("'");
            sb.append(theId.toString());
            sb.append("'");
        }
        return sb.toString();
    }

    @Override
    protected IObjectCollection _getCashFlowItems(Context ctx, Vector itemIdVec) throws EASBizException, BOSException {
        IBgItem iBg = BgItemFactory.getLocalInstance(ctx);
        BgItemCollection bgItems = new BgItemCollection();
        for (int i = 0; i < itemIdVec.size(); ++i) {
            String id = (String)itemIdVec.elementAt(i);
            BgItemInfo info = (BgItemInfo)iBg.getValue((IObjectPK)new ObjectUuidPK(id));
            bgItems.add(info);
        }
        return this.getCashFlowItems(ctx, (IObjectCollection)bgItems);
    }

    @Override
    protected IObjectCollection _getOrgItemCollection(Context ctx, int orgType, String cuID) throws BOSException, EASBizException {
        String isOrgType = "";
        if (orgType == 0) {
            isOrgType = " FIsAdminOrgUnit=1 ";
        } else if (orgType == 1) {
            isOrgType = " FIsCompanyOrgUnit=1 ";
        } else if (orgType == 2) {
            isOrgType = " FIsSaleOrgUnit=1 ";
        } else if (orgType == 3) {
            isOrgType = " FIsPurchaseOrgUnit=1 ";
        } else if (orgType == 4) {
            isOrgType = " FIsStorageOrgUnit=1 ";
        } else if (orgType == 6) {
            isOrgType = " FIsProfitOrgUnit=1 ";
        } else if (orgType == 5) {
            isOrgType = " FIsCostOrgUnit=1 ";
        }
        String sql = "SELECT FID, FNumber, FName_L1, FName_L2, FName_L3 FROM T_ORG_BaseUnit WHERE " + isOrgType + " and fisGrouping =0 and FControlUnitId='" + cuID + "' ORDER BY FNumber";
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        OrgUnitCollection ouc = new OrgUnitCollection();
        try {
            conn = this.getConnection(ctx);
            stmt = conn.prepareStatement(sql);
            rs = stmt.executeQuery();
            while (rs.next()) {
                OrgUnitInfo oui = new OrgUnitInfo();
                oui.setId(BOSUuid.read((String)rs.getString("FID")));
                oui.setNumber(rs.getString("FNumber"));
                oui.setName(rs.getString("FName_L2"));
                ouc.add(oui);
            }
        }
        catch (SQLException e) {
            try {
                throw new BgBizException(BgBizException.GETDATA, e, new Object[]{"OrgUnit"});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        return ouc;
    }

    protected void _addnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        CtrlUnitInfo cuInfo = new CtrlUnitInfo();
        cuInfo.setId(BOSUuid.read((String)"00000000-0000-0000-0000-000000000000CCE7AED4"));
        ((BgItemInfo)model).setCU(cuInfo);
        super._addnew(ctx, pk, model);
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        CtrlUnitInfo cuInfo = new CtrlUnitInfo();
        cuInfo.setId(BOSUuid.read((String)"00000000-0000-0000-0000-000000000000CCE7AED4"));
        ((BgItemInfo)model).setCU(cuInfo);
        return super._addnew(ctx, model);
    }
}

