/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bg.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.ctrl.kdf.expr.Macro;
import com.kingdee.bos.ctrl.kdf.expr.SyntaxErrorException;
import com.kingdee.bos.ctrl.kdf.expr.TableRelations;
import com.kingdee.bos.ctrl.kdf.expr.Variant;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.SimpleTimer;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgUnitCommon;
import com.kingdee.eas.basedata.org.NewOrgViewHelper;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitCommonFactory;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.bg.BgBizException;
import com.kingdee.eas.ma.bg.BgCycleTypeEnum;
import com.kingdee.eas.ma.bg.BgDataInfo;
import com.kingdee.eas.ma.bg.BgDataTypeEnum;
import com.kingdee.eas.ma.bg.BgDimensionEnum;
import com.kingdee.eas.ma.bg.BgDisHelper;
import com.kingdee.eas.ma.bg.BgElementEnum;
import com.kingdee.eas.ma.bg.BgElementInfo;
import com.kingdee.eas.ma.bg.BgEntryInfo;
import com.kingdee.eas.ma.bg.BgEntryTypeEnum;
import com.kingdee.eas.ma.bg.BgFormCollection;
import com.kingdee.eas.ma.bg.BgFormDAFactory;
import com.kingdee.eas.ma.bg.BgFormDataSourceEnum;
import com.kingdee.eas.ma.bg.BgFormException;
import com.kingdee.eas.ma.bg.BgFormFactory;
import com.kingdee.eas.ma.bg.BgFormHelper;
import com.kingdee.eas.ma.bg.BgFormInfo;
import com.kingdee.eas.ma.bg.BgFormStateEnum;
import com.kingdee.eas.ma.bg.BgFormulaHelper;
import com.kingdee.eas.ma.bg.BgFormulaInfo;
import com.kingdee.eas.ma.bg.BgFormulaProxy;
import com.kingdee.eas.ma.bg.BgHelper;
import com.kingdee.eas.ma.bg.BgItemCollection;
import com.kingdee.eas.ma.bg.BgItemInfo;
import com.kingdee.eas.ma.bg.BgKDSFactory;
import com.kingdee.eas.ma.bg.BgModelNodeFactory;
import com.kingdee.eas.ma.bg.BgModelNodeInfo;
import com.kingdee.eas.ma.bg.BgORMEngine;
import com.kingdee.eas.ma.bg.BgOperationEnum;
import com.kingdee.eas.ma.bg.BgOrgHelper;
import com.kingdee.eas.ma.bg.BgPeriodNode;
import com.kingdee.eas.ma.bg.BgPeriodRange;
import com.kingdee.eas.ma.bg.BgProviderFactory;
import com.kingdee.eas.ma.bg.BgPurposeEnum;
import com.kingdee.eas.ma.bg.BgRptTemplateInfo;
import com.kingdee.eas.ma.bg.BgRptTemplateRowCollection;
import com.kingdee.eas.ma.bg.BgRptTemplateRowInfo;
import com.kingdee.eas.ma.bg.BgSchemeFactory;
import com.kingdee.eas.ma.bg.BgSchemeHelper;
import com.kingdee.eas.ma.bg.BgSchemeInfo;
import com.kingdee.eas.ma.bg.BgTemplateCollection;
import com.kingdee.eas.ma.bg.BgTemplateColumnCollection;
import com.kingdee.eas.ma.bg.BgTemplateColumnInfo;
import com.kingdee.eas.ma.bg.BgTemplateException;
import com.kingdee.eas.ma.bg.BgTemplateFactory;
import com.kingdee.eas.ma.bg.BgTemplateInfo;
import com.kingdee.eas.ma.bg.BgTemplateRowInfo;
import com.kingdee.eas.ma.bg.BgTypeFactory;
import com.kingdee.eas.ma.bg.BgTypeInfo;
import com.kingdee.eas.ma.bg.BgVerifyException;
import com.kingdee.eas.ma.bg.IBgForm;
import com.kingdee.eas.ma.bg.IBgFormDA;
import com.kingdee.eas.ma.bg.IBgKDS;
import com.kingdee.eas.ma.bg.IBgModelNode;
import com.kingdee.eas.ma.bg.IBgProvider;
import com.kingdee.eas.ma.bg.IBgScheme;
import com.kingdee.eas.ma.bg.IBgTemplate;
import com.kingdee.eas.ma.bg.IBgType;
import com.kingdee.eas.ma.bg.ReferencedCurrencyCollection;
import com.kingdee.eas.ma.bg.ReferencedCurrencyInfo;
import com.kingdee.eas.ma.bg.ReferencedDimensionCollection;
import com.kingdee.eas.ma.bg.ReferencedDimensionInfo;
import com.kingdee.eas.ma.bg.app.AbstractBgManagerControllerBean;
import com.kingdee.eas.ma.bg.app.dao.BgCtrlDAO;
import com.kingdee.eas.ma.bg.app.dao.BgDAO;
import com.kingdee.jdbc.rowset.impl.JdbcRowSet;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.apache.log4j.Logger;

public class BgManagerControllerBean
extends AbstractBgManagerControllerBean {
    static final Logger logger = Logger.getLogger(BgManagerControllerBean.class);

    @Override
    protected IObjectValue _getCurrentBgTemplate(Context ctx, BOSUuid orgId, BOSUuid bgTypeId) throws BOSException, EASBizException {
        IBgTemplate iBgTemplate = BgTemplateFactory.getLocalInstance(ctx);
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)orgId.toString(), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("bgType.id", (Object)bgTypeId.toString(), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("isCurrent", (Object)"1", CompareType.EQUALS));
        entityViewInfo.setFilter(filterInfo);
        BgTemplateCollection bgTpCollection = iBgTemplate.getBgTemplateCollection(entityViewInfo);
        if (bgTpCollection.size() == 0) {
            throw new BgTemplateException(BgTemplateException.NOCURRENTTEMPLATE);
        }
        if (bgTpCollection.size() > 1) {
            throw new BgTemplateException(BgTemplateException.MULTICURRENTTEMPLATE);
        }
        return bgTpCollection.get(0);
    }

    @Override
    protected IObjectValue _generateBgForm(Context ctx, IObjectValue bgTemplate, IObjectValue bgScheme, IObjectValue orgUnit) throws BOSException, EASBizException {
        BgFormInfo bgFormInfo = new BgFormInfo();
        this.generateFromDefault(bgFormInfo);
        this.generateBasicFromOrg(ctx, bgFormInfo, (OrgUnitInfo)orgUnit);
        this.generateBasicFromScheme(bgFormInfo, (BgSchemeInfo)bgScheme);
        this.generateBasicFromTemplate(bgFormInfo, (BgTemplateInfo)bgTemplate);
        this.generateBgEntries(ctx, bgFormInfo);
        this.generateSystemData(bgFormInfo);
        this.applyScheme(ctx, bgFormInfo);
        return bgFormInfo;
    }

    private void generateBasicFromOrg(Context ctx, BgFormInfo bgFormInfo, OrgUnitInfo orgUnitInfo) throws EASBizException, BOSException {
        bgFormInfo.setOrgUnit(orgUnitInfo);
        IOrgUnitCommon iOrgUnitCommon = OrgUnitCommonFactory.getLocalInstance((Context)ctx);
        CompanyOrgUnitInfo companyInfo = (CompanyOrgUnitInfo)iOrgUnitCommon.getRelationUnit(orgUnitInfo.getId(), OrgType.Company);
        bgFormInfo.setCompany(companyInfo);
    }

    private void generateBasicFromScheme(BgFormInfo bgFormInfo, BgSchemeInfo bgSchemeInfo) {
        bgFormInfo.setBgScheme(bgSchemeInfo);
        if (bgFormInfo.getCompany() == null) {
            bgFormInfo.setCompany(bgSchemeInfo.getCompany());
        }
        bgFormInfo.setPeriodFrom(bgSchemeInfo.getPeriodFrom());
        bgFormInfo.setPeriodTo(bgSchemeInfo.getPeriodTo());
    }

    private void generateFromDefault(BgFormInfo bgFormInfo) {
        bgFormInfo.setState(BgFormStateEnum.Edited);
        bgFormInfo.setPurpose(BgPurposeEnum.Make);
        bgFormInfo.setIsCurrent(true);
        bgFormInfo.setDataSource(BgFormDataSourceEnum.CURRENTWORKOUT);
    }

    private void generateBasicFromTemplate(BgFormInfo bgFormInfo, BgTemplateInfo bgTemplateInfo) {
        bgFormInfo.setBgTemplate(bgTemplateInfo);
        bgFormInfo.setBgType(bgTemplateInfo.getBgType());
    }

    private void generateBgEntries(Context ctx, BgFormInfo bgFormInfo) throws EASBizException, BOSException {
        Vector vector = this.getPeriodNodeVector(ctx, bgFormInfo);
        if (vector == null) {
            throw new EASBizException(BgFormException.CREATEPERIODTREE);
        }
        BigDecimal zero = new BigDecimal("0");
        for (int i = 0; i < vector.size(); ++i) {
            BgPeriodNode bgPeriodNode = (BgPeriodNode)vector.get(i);
            Iterator bgTpRowIter = bgFormInfo.getBgTemplate().getBgTpRows().iterator();
            boolean seq = true;
            while (bgTpRowIter.hasNext()) {
                BgTemplateRowInfo bgTpRowInfo = (BgTemplateRowInfo)bgTpRowIter.next();
                BgEntryInfo bgEntryInfo = new BgEntryInfo();
                bgEntryInfo.setIsLeafPeriod(bgPeriodNode.isLeaf());
                bgEntryInfo.setBgCycle(bgPeriodNode.getBgCycle());
                bgEntryInfo.setPeriod(bgPeriodNode.getPeriod());
                bgEntryInfo.setBgItem1(bgTpRowInfo.getBgItem1());
                bgEntryInfo.setBgItem2(bgTpRowInfo.getBgItem2());
                bgEntryInfo.setBgItem3(bgTpRowInfo.getBgItem3());
                bgEntryInfo.setBgItem4(bgTpRowInfo.getBgItem4());
                bgEntryInfo.setBgItem5(bgTpRowInfo.getBgItem5());
                bgEntryInfo.setBgItem6(bgTpRowInfo.getBgItem6());
                bgEntryInfo.setEntryType(BgEntryTypeEnum.General);
                bgEntryInfo.setSplitRate(zero);
                bgEntryInfo.setIsLeafEntry(bgEntryInfo.caculateIsLeafEntry());
                Iterator bgTpColIter = bgFormInfo.getBgTemplate().getBgTpColumns().iterator();
                while (bgTpColIter.hasNext()) {
                    BgTemplateColumnInfo bgTpColumnInfo = (BgTemplateColumnInfo)bgTpColIter.next();
                    if (bgTpColumnInfo.getBgElement().getDataType().equals((Object)BgDataTypeEnum.Amount)) {
                        Iterator refCurrencyIter = bgFormInfo.getBgTemplate().getRefCurrencies().iterator();
                        while (refCurrencyIter.hasNext()) {
                            BgDataInfo bgDataInfo = new BgDataInfo();
                            bgDataInfo.generateByTemplate(bgTpRowInfo, bgTpColumnInfo);
                            ReferencedCurrencyInfo refCurrencyInfo = (ReferencedCurrencyInfo)refCurrencyIter.next();
                            bgDataInfo.setCurrency(refCurrencyInfo.getCurrency());
                            bgDataInfo.setIdentity(BgFormHelper.getBgDataIdentity(bgEntryInfo, bgDataInfo));
                            bgDataInfo.setBgValue(zero);
                            bgEntryInfo.getBgData().add(bgDataInfo);
                        }
                        continue;
                    }
                    BgDataInfo bgDataInfo = new BgDataInfo();
                    bgDataInfo.generateByTemplate(bgTpRowInfo, bgTpColumnInfo);
                    bgDataInfo.setCurrency(bgFormInfo.getBgTemplate().getRefCurrencies().get(0).getCurrency());
                    bgDataInfo.setIdentity(BgFormHelper.getBgDataIdentity(bgEntryInfo, bgDataInfo));
                    bgDataInfo.setBgValue(zero);
                    bgEntryInfo.getBgData().add(bgDataInfo);
                }
                bgFormInfo.getBgEntries().add(bgEntryInfo);
            }
        }
    }

    private Vector getPeriodNodeVector(Context ctx, BgFormInfo bgFormInfo) throws BOSException, EASBizException {
        BgPeriodRange bgPeriodRange = new BgPeriodRange(bgFormInfo.getPeriodFrom(), bgFormInfo.getPeriodTo());
        IOrgUnitCommon iOrgUnitCommon = OrgUnitCommonFactory.getLocalInstance((Context)ctx);
        CompanyOrgUnitInfo companyInfo = iOrgUnitCommon.getCompany(bgFormInfo.getOrgUnit().getId());
        PeriodCollection periods = PeriodUtils.getPeriodc((Context)ctx, (PeriodInfo)bgFormInfo.getPeriodFrom(), (PeriodInfo)bgFormInfo.getPeriodTo(), (CompanyOrgUnitInfo)companyInfo);
        periods = BgHelper.filterAdjustPeriod(periods);
        Vector vector = bgPeriodRange.getPeriodNodesInRange(companyInfo, bgFormInfo.getBgTemplate().getBgCycle(), periods);
        return vector;
    }

    private void generateSystemData(BgFormInfo bgFormInfo) {
    }

    public BOSUuid getBgFormId(Context ctx, String table, BOSUuid bgTypeId, String bizOrgUnitNumber, BOSUuid periodId) throws BOSException, EASBizException {
        BOSUuid bOSUuid;
        ResultSet rs;
        PreparedStatement stmt;
        Connection conn;
        int serial;
        block5: {
            BgDAO dao = BgDAO.getInstant(ctx);
            serial = dao.getPeriodSerial(periodId);
            StringBuffer sb = new StringBuffer(128);
            sb.append("SELECT TOP 1 F.FID, F.FOrgUnitID\tFROM T_BG_BgForm F INNER JOIN T_BD_Period P1 ON F.FPeriodFromID = P1.FID INNER JOIN T_BD_Period P2 ON F.FPeriodToID = P2.FID INNER JOIN ");
            sb.append(table);
            sb.append(" O ON F.FOrgUnitID = O.FID WHERE (");
            sb.append(serial);
            sb.append(" BETWEEN (P1.FPeriodYear*100+ P1.FPeriodNumber)  AND (P2.FPeriodYear*100+ P2.FPeriodNumber)) AND (LEFT('");
            sb.append(bizOrgUnitNumber);
            sb.append("', LENGTH(O.FLongNumber)) = O.FLongNumber)\tAND (F.FBgTypeID = ?) AND (F.FState IN (2)) AND (F.FIsCurrent = 1) order by o.flongnumber desc");
            conn = null;
            stmt = null;
            rs = null;
            conn = this.getConnection(ctx);
            stmt = conn.prepareStatement(sb.toString());
            stmt.setString(1, bgTypeId.toString());
            rs = stmt.executeQuery();
            if (!rs.next()) break block5;
            BOSUuid bOSUuid2 = BOSUuid.read((String)rs.getString(1));
            SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
            return bOSUuid2;
        }
        try {
            bOSUuid = null;
        }
        catch (SQLException e) {
            try {
                System.out.println("ABCDEFG:" + e.getMessage());
                e.printStackTrace();
                throw new BgVerifyException(BgVerifyException.CHECKNOEXIST, e, new Object[]{serial + bizOrgUnitNumber + bgTypeId});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        return bOSUuid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeOrgUnitParent(Context ctx, String table, FullOrgUnitCollection coll, String number) throws EASBizException, BOSException {
        StringBuffer sb = new StringBuffer(128);
        sb.append("insert into ");
        sb.append(table);
        sb.append(" (FID, FName,FNumber,FLongNumber, FSuperID)");
        sb.append(" Values  (?,?,?,?,?)");
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            conn = this.getConnection(ctx);
            stmt = conn.prepareStatement(sb.toString());
            for (int i = 0; i < coll.size(); ++i) {
                if (number.indexOf(coll.get(i).getString("longNumber")) != 0) continue;
                this.setValue(stmt, (OrgUnitInfo)coll.get(i));
                stmt.addBatch();
            }
            stmt.executeBatch();
            SQLUtils.cleanup((Statement)stmt, (Connection)conn);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            SQLUtils.cleanup(stmt, (Connection)conn);
        }
    }

    private void setValue(PreparedStatement stmt, OrgUnitInfo info) throws SQLException {
        stmt.setString(1, info.getId().toString());
        stmt.setString(2, info.getName());
        stmt.setString(3, info.getNumber());
        stmt.setString(4, info.getString("longNumber"));
        stmt.setString(5, BgHelper.getId(info.get("superOrgUnit")));
    }

    @Override
    protected IObjectValue _getExecutiveBgForm(Context ctx, BOSUuid bizOrgUnitId, BOSUuid bgTypeId, BOSUuid periodId) throws BOSException, EASBizException {
        BOSUuid bgFormId = this.getFormId(ctx, bizOrgUnitId, bgTypeId, periodId);
        if (bgFormId == null) {
            return null;
        }
        BgFormInfo bgFormInfo = null;
        bgFormInfo = this.isRptBgForm(ctx, bgFormId) ? BgFormDAFactory.getLocalInstance(ctx).getSingleForm((IObjectPK)new ObjectUuidPK(bgFormId)) : this.getBgFormInfo(ctx, bgFormId);
        return bgFormInfo;
    }

    private boolean isRptBgForm(Context ctx, BOSUuid bgFormId) throws SQLDataException, BgBizException {
        boolean result = false;
        String sql = "SELECT a.fisrptbgform from t_bg_bgtype a ,t_bg_bgform b  where a.fid=b.fbgtypeid and b.FID = ? ";
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            conn = this.getConnection(ctx);
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, bgFormId.toString());
            rs = stmt.executeQuery();
            if (rs.next()) {
                result = rs.getInt(1) == 1;
            }
        }
        catch (SQLException e) {
            try {
                throw new BgBizException(BgBizException.GETDATA, e, new Object[]{"bgForm"});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        return result;
    }

    private BgFormInfo getBgFormInfo(Context ctx, BOSUuid bgFormId) throws EASBizException, BOSException, EASBizException, BOSException, BgFormException, EASBizException, EASBizException, EASBizException, EASBizException, BgBizException, EASBizException {
        String sql = "SELECT BgForm.FID, BgForm.FNumber, BgForm.FBgTypeID, BgForm.FCompanyID, BgForm.FOrgUnitID, BgForm.FIsCurrent, BgForm.FPeriodFromID , BgForm.FPeriodToID , BgForm.FBgTemplateID, RefDims.FID AS RefDimensionID, RefDims.FBgDimension, RefDims.FIsPrimary, RefCurs.FID AS RefCursID, RefCurs.FCurrencyID, BgTemplate.FIsMultidimensional, BgTemplate.FBgCycle , BgTempCols.FID AS TpColID, BgTempCols.FIsControlled, BgTempCols.FBgElementID, BgElements.FID AS BgElementID, BgElements.FBizElement FROM T_BG_BgForm BgForm INNER JOIN T_BG_BgTemplate BgTemplate ON BgForm.FBgTemplateID = BgTemplate.FID INNER JOIN T_BG_ReferencedDimension RefDims ON BgForm.FBgTemplateID = RefDims.FBgTemplateID INNER JOIN T_BG_ReferencedCurrency RefCurs ON BgForm.FBgTemplateID = RefCurs.FBgTemplateID INNER JOIN T_BG_BgTemplateColumn BgTempCols ON BgForm.FBgTemplateID = BgTempCols.FBgTemplateID INNER JOIN T_BG_BgElement BgElements ON BgTempCols.FBgElementID = BgElements.FID WHERE (BgForm.FIsCurrent = 1) AND (BgForm.FID = ?) ";
        Connection conn = this.getConnection(ctx);
        PreparedStatement stmt = null;
        ResultSet rs = null;
        BgFormInfo bgFormInfo = new BgFormInfo();
        try {
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, bgFormId.toString());
            rs = stmt.executeQuery();
            JdbcRowSet jdbcRs = new JdbcRowSet();
            jdbcRs.populate(rs);
            BgDAO dao = new BgDAO();
            dao.initDAO(ctx);
            if (jdbcRs.size() <= 0) {
                throw new BgFormException(BgFormException.NOEXCUTIVEFORM, new Object[]{bgFormId});
            }
            jdbcRs.first();
            BOSUuid id = BOSUuid.read((String)jdbcRs.getString("FID"));
            bgFormInfo.setId(id);
            bgFormInfo.setPeriodFrom(new PeriodInfo());
            id = BOSUuid.read((String)jdbcRs.getString("FPeriodFromID"));
            bgFormInfo.getPeriodFrom().setId(id);
            bgFormInfo.getPeriodFrom().setInt("Serial", dao.getPeriodSerial(id));
            bgFormInfo.setPeriodTo(new PeriodInfo());
            id = BOSUuid.read((String)jdbcRs.getString("FPeriodToID"));
            bgFormInfo.getPeriodTo().setId(id);
            bgFormInfo.getPeriodTo().setInt("Serial", dao.getPeriodSerial(id));
            bgFormInfo.setBgTemplate(this.getBgTemplateInfo(jdbcRs));
            bgFormInfo.setBgType(this.getBgTypeInfo(jdbcRs));
            bgFormInfo.setCompany(this.getCompany(jdbcRs));
            bgFormInfo.setOrgUnit(this.getOrgUnit(jdbcRs));
            bgFormInfo.getBgTemplate().getRefCurrencies().addCollection(this.getRefCurrencys(jdbcRs));
            bgFormInfo.getBgTemplate().getRefDimensions().addCollection(this.getRefDimensions(jdbcRs));
            bgFormInfo.getBgTemplate().getBgTpColumns().addCollection(this.getBgTpColumns(jdbcRs));
        }
        catch (SQLException e) {
            try {
                throw new BgBizException(BgBizException.GETDATA, e, new Object[]{"bgForm"});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        return bgFormInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BOSUuid getFormId(Context ctx, BOSUuid bizOrgUnitId, BOSUuid bgTypeId, BOSUuid periodId) throws BOSException, EASBizException {
        FullOrgUnitCollection coll = this.getOrgViewCollection(ctx, bgTypeId);
        int i = 0;
        if (coll == null) {
            return null;
        }
        for (i = coll.size() - 1; i >= 0 && !coll.get(i).getId().toString().equals(bizOrgUnitId.toString()); --i) {
        }
        if (i == -1) {
            return null;
        }
        String bizOrgNumber = coll.get(i).getString("longNumber");
        String table = null;
        BOSUuid bgFormId = null;
        try {
            BgCtrlDAO dao = BgCtrlDAO.getInstance(ctx);
            table = dao.getOrgUnitTable(ctx);
            this.storeOrgUnitParent(ctx, table, coll, bizOrgNumber);
            bgFormId = this.getBgFormId(ctx, table, bgTypeId, bizOrgNumber, periodId);
        }
        catch (Throwable throwable) {
            BgHelper.dropTable(ctx, table);
            throw throwable;
        }
        BgHelper.dropTable(ctx, table);
        return bgFormId;
    }

    private FullOrgUnitCollection getOrgViewCollection(Context ctx, BOSUuid bgTypeId) throws BOSException, EASBizException {
        FullOrgUnitCollection coll = null;
        IBgType ib = BgTypeFactory.getLocalInstance(ctx);
        BgTypeInfo info = ib.getBgTypeInfo("select id ,orgView where id='" + bgTypeId + "'");
        coll = NewOrgViewHelper.getAllOrgs((Context)ctx, (OrgViewType)info.getOrgView());
        return coll;
    }

    private FullOrgUnitInfo getOrgUnit(JdbcRowSet jdbcRs) throws EASBizException {
        FullOrgUnitInfo info = new FullOrgUnitInfo();
        try {
            info.setId(BOSUuid.read((String)jdbcRs.getString("FOrgUnitID")));
        }
        catch (SQLException e) {
            throw new EASBizException(BgBizException.GETDATA, (Throwable)e, new Object[]{"BgFormOrgUnit"});
        }
        return info;
    }

    private BgTemplateColumnCollection getBgTpColumns(JdbcRowSet jdbcRs) throws EASBizException {
        BgTemplateColumnCollection coll = new BgTemplateColumnCollection();
        try {
            jdbcRs.beforeFirst();
            while (jdbcRs.next()) {
                BgTemplateColumnInfo info = new BgTemplateColumnInfo();
                info.setId(BOSUuid.read((String)jdbcRs.getString("TpColID")));
                if (!coll.add(info)) continue;
                info.setIsControlled(jdbcRs.getBoolean("FIsControlled"));
                info.setBgElement(this.getBgElementInfo(jdbcRs));
            }
        }
        catch (SQLException e) {
            throw new EASBizException(BgBizException.GETDATA, (Throwable)e, new Object[]{"BgTpColumns"});
        }
        return coll;
    }

    private BgElementInfo getBgElementInfo(JdbcRowSet jdbcRs) throws EASBizException {
        BgElementInfo info = new BgElementInfo();
        try {
            info.setId(BOSUuid.read((String)jdbcRs.getString("BgElementID")));
            info.setBizElement(BgElementEnum.getEnum(jdbcRs.getInt("FBizElement")));
        }
        catch (SQLException e) {
            throw new EASBizException(BgBizException.GETDATA, (Throwable)e, new Object[]{"BgElement"});
        }
        return info;
    }

    private ReferencedDimensionCollection getRefDimensions(JdbcRowSet jdbcRs) throws EASBizException {
        ReferencedDimensionCollection coll = new ReferencedDimensionCollection();
        try {
            jdbcRs.beforeFirst();
            while (jdbcRs.next()) {
                ReferencedDimensionInfo info = new ReferencedDimensionInfo();
                info.setId(BOSUuid.read((String)jdbcRs.getString("RefDimensionID")));
                if (!coll.add(info)) continue;
                info.setIsPrimary(jdbcRs.getBoolean("FIsPrimary"));
                info.setBgDimension(BgDimensionEnum.getEnum(jdbcRs.getInt("FBgDimension")));
            }
        }
        catch (SQLException e) {
            throw new EASBizException(BgBizException.GETDATA, (Throwable)e, new Object[]{"BgRefenced"});
        }
        return coll;
    }

    private ReferencedCurrencyCollection getRefCurrencys(JdbcRowSet jdbcRs) throws EASBizException {
        ReferencedCurrencyCollection coll = new ReferencedCurrencyCollection();
        try {
            jdbcRs.beforeFirst();
            while (jdbcRs.next()) {
                ReferencedCurrencyInfo info = new ReferencedCurrencyInfo();
                info.setId(BOSUuid.read((String)jdbcRs.getString("RefCursID")));
                if (!coll.add(info)) continue;
                info.setCurrency(new CurrencyInfo());
                info.getCurrency().setId(BOSUuid.read((String)jdbcRs.getString("FCurrencyID")));
            }
        }
        catch (SQLException e) {
            throw new EASBizException(BgBizException.GETDATA, (Throwable)e, new Object[]{"RefCurrency"});
        }
        return coll;
    }

    private BgTemplateInfo getBgTemplateInfo(JdbcRowSet jdbcRs) throws BOSException, EASBizException {
        BgTemplateInfo result = new BgTemplateInfo();
        try {
            result.setId(BOSUuid.read((String)jdbcRs.getString("FBgTemplateID")));
            result.setIsMultidimensional(jdbcRs.getBoolean("FIsMultidimensional"));
            result.setBgCycle(BgCycleTypeEnum.getEnum(jdbcRs.getInt("FBgCycle")));
        }
        catch (SQLException e) {
            throw new EASBizException(BgBizException.GETDATA, (Throwable)e, new Object[]{"BgTemplate"});
        }
        return result;
    }

    private BgTypeInfo getBgTypeInfo(JdbcRowSet jdbcRs) {
        return null;
    }

    private CompanyOrgUnitInfo getCompany(JdbcRowSet jdbcRs) throws EASBizException {
        CompanyOrgUnitInfo info = new CompanyOrgUnitInfo();
        try {
            info.setId(BOSUuid.read((String)jdbcRs.getString("FCompanyID")));
        }
        catch (SQLException e) {
            throw new EASBizException(BgBizException.GETDATA, (Throwable)e, new Object[]{"CompanyOrgUnite"});
        }
        return info;
    }

    private void applyScheme(Context ctx, BgFormInfo bgFormInfo) throws EASBizException, BOSException {
        BgFormulaProxy proxy = new BgFormulaProxy(ctx, bgFormInfo.getBgScheme().getId().toString());
        TableRelations relations = new TableRelations();
        relations.getDefaultFunctionProvider().add(proxy);
        BOSUuid bgModelId = null;
        Iterator iter = bgFormInfo.getBgScheme().getBgModelNodes().iterator();
        IBgModelNode iBgModelNode = BgModelNodeFactory.getLocalInstance(ctx);
        while (iter.hasNext()) {
            BgModelNodeInfo tmpBgModelNodeInfo = (BgModelNodeInfo)iter.next();
            if (!tmpBgModelNodeInfo.getBgTemplate().getId().equals((Object)bgFormInfo.getBgTemplate().getId())) continue;
            bgModelId = tmpBgModelNodeInfo.getId();
            break;
        }
        if (bgModelId == null) {
            return;
        }
        BgModelNodeInfo bgModelNodeInfo = iBgModelNode.getBgModelNodeDesc(bgModelId);
        Iterator formulaIter = bgModelNodeInfo.getBgFormulas().iterator();
        while (formulaIter.hasNext()) {
            BgFormulaInfo bgFormulaInfo = (BgFormulaInfo)formulaIter.next();
            this.applyFormula(bgFormInfo, bgFormulaInfo, relations, ctx);
        }
    }

    private void applyFormula(BgFormInfo bgFormInfo, BgFormulaInfo bgFormulaInfo, TableRelations relations, Context ctx) throws EASBizException, BOSException {
        String formulaStr = bgFormulaInfo.getFormula();
        String[] str = formulaStr.split("\"");
        String orgNumber = str[1];
        String bgTypeNumber = str[3];
        String bgSchemeId = bgFormInfo.getBgScheme().getId().toString();
        IBgProvider iBg = BgProviderFactory.getLocalInstance(ctx);
        int cycle = iBg.getTemplateCycle(orgNumber, bgTypeNumber, bgSchemeId);
        boolean isCal = true;
        if (cycle < bgFormInfo.getBgTemplate().getBgCycle().getValue()) {
            isCal = false;
        }
        Vector vector = BgPeriodRange.getPeriodNodes(bgFormInfo.getBgEntries());
        Iterator iter = bgFormInfo.getBgEntries().iterator();
        while (iter.hasNext()) {
            BgDataInfo bgDataInfo;
            BgEntryInfo bgEntryInfo = (BgEntryInfo)iter.next();
            if (!this.matchEntryAndFormula(bgEntryInfo, bgFormulaInfo)) continue;
            String strCurrencyNum = null;
            if (bgFormulaInfo.getCurrency() != null) {
                strCurrencyNum = bgFormulaInfo.getCurrency().getNumber();
            }
            String strElementNum = bgFormulaInfo.getBgElement().getNumber();
            if (strCurrencyNum != null) {
                strElementNum = strElementNum + "_" + strCurrencyNum;
            }
            if ((bgDataInfo = bgEntryInfo.getBgDataByElementNumber(strElementNum)) == null) continue;
            String strItemKey = this.adjustDimAndItem(bgEntryInfo);
            if (isCal) {
                bgDataInfo.setBgValue(this.caculateFormula(bgFormulaInfo.getFormula(), vector, bgEntryInfo.getPeriodNode(), strItemKey, relations));
                continue;
            }
            bgDataInfo.setBgValue(new BigDecimal(0));
        }
    }

    private boolean matchEntryAndFormula(BgEntryInfo bgEntryInfo, BgFormulaInfo bgFormulaInfo) {
        boolean result = true;
        for (int i = 1; i <= BgTemplateRowInfo.MAXREFDIM; ++i) {
            String propertyKey = "bgItem" + i;
            BgItemInfo entryItemInfo = (BgItemInfo)bgEntryInfo.get(propertyKey);
            BgItemInfo formulaItemInfo = (BgItemInfo)bgFormulaInfo.get(propertyKey);
            if (entryItemInfo == null || formulaItemInfo == null) break;
            String entryItemNumber = entryItemInfo.getItemNumber();
            String formulaItemNumber = formulaItemInfo.getItemNumber();
            if (entryItemNumber == null || formulaItemNumber == null) break;
            if (entryItemNumber.equals(formulaItemNumber)) continue;
            result = false;
            break;
        }
        return result;
    }

    @Override
    protected IObjectValue _generateBgRptForm(Context ctx, IObjectValue bgRptTemplate, IObjectValue bgScheme, IObjectValue orgUnit) throws BOSException, EASBizException {
        BgFormInfo bgFormInfo = new BgFormInfo();
        this.generateFromDefault(bgFormInfo);
        this.generateBasicFromOrg(ctx, bgFormInfo, (OrgUnitInfo)orgUnit);
        this.generateBasicFromScheme(bgFormInfo, (BgSchemeInfo)bgScheme);
        this.generateBasicFromRptTemplate(bgFormInfo, (BgRptTemplateInfo)bgRptTemplate);
        this.generateBgRptEntries(ctx, bgFormInfo);
        return bgFormInfo;
    }

    private void generateBasicFromRptTemplate(BgFormInfo bgFormInfo, BgRptTemplateInfo bgRptTpInfo) {
        bgFormInfo.setBgRptTemplate(bgRptTpInfo);
        bgFormInfo.setBgTemplate(bgRptTpInfo.getBgTemplate());
        bgFormInfo.setBgType(bgRptTpInfo.getBgTemplate().getBgType());
    }

    private void generateBgRptEntries(Context ctx, BgFormInfo bgFormInfo) throws EASBizException, BOSException {
        Vector vector = this.getPeriodNodeVector(ctx, bgFormInfo);
        if (vector == null) {
            throw new BgFormException(BgFormException.CREATEPERIODTREE);
        }
        BgItemCollection bgItems = bgFormInfo.getBgRptTemplate().getBgTemplate().getRefDimensions().get(0).getBgItems();
        BgRptTemplateRowCollection bgRptTpRows = bgFormInfo.getBgRptTemplate().getBgRptTpRows();
        CurrencyInfo localCyInfo = null;
        ReferencedCurrencyCollection refCyCollecion = bgFormInfo.getBgRptTemplate().getBgTemplate().getRefCurrencies();
        if (refCyCollecion != null && refCyCollecion.size() > 0) {
            localCyInfo = refCyCollecion.get(0).getCurrency();
        }
        if (localCyInfo == null) {
            throw new BgFormException(BgFormException.MISSINGLOCALCURRENCY);
        }
        BigDecimal zero = new BigDecimal("0");
        TableRelations relations = this.getCaculatorKdTable(ctx, bgFormInfo.getBgScheme().getId().toString());
        for (int i = 0; i < vector.size(); ++i) {
            BgPeriodNode bgPeriodNode = (BgPeriodNode)vector.get(i);
            int size = bgItems.size();
            for (int j = 0; j < size; ++j) {
                BgRptTemplateRowInfo bgRptTpRowInfo = bgRptTpRows.get(j);
                BgEntryInfo bgEntryInfo = new BgEntryInfo();
                bgEntryInfo.setIsLeafPeriod(bgPeriodNode.isLeaf());
                bgEntryInfo.setBgCycle(bgPeriodNode.getBgCycle());
                bgEntryInfo.setPeriod(bgPeriodNode.getPeriod());
                bgEntryInfo.setBgItem1(bgItems.get(j));
                bgEntryInfo.setIsLeafEntry(bgRptTpRowInfo.getType().getValue() == 2);
                Iterator bgElementIter = bgFormInfo.getBgType().getElements().iterator();
                IBgProvider bgProvider = BgProviderFactory.getLocalInstance(ctx);
                while (bgElementIter.hasNext()) {
                    BgElementInfo bgElementInfo = (BgElementInfo)bgElementIter.next();
                    BgDataInfo bgDataInfo = new BgDataInfo();
                    bgDataInfo.generateByRptTemplate(bgElementInfo);
                    bgDataInfo.setCurrency(localCyInfo);
                    BigDecimal formulaResult = new BigDecimal("0");
                    if (bgRptTpRowInfo != null && bgRptTpRowInfo.getType().getValue() == 2) {
                        bgDataInfo.setBgValue(null);
                        String theFormula = null;
                        theFormula = bgRptTpRowInfo.getFormula();
                        if (theFormula != null && !theFormula.equals("")) {
                            if (bgFormInfo.getBgType().getNumber().equals("BalanceSheetBudget")) {
                                String schemeId = bgFormInfo.getBgScheme().getId().toString();
                                String orgNumber = bgFormInfo.getOrgUnit().getNumber();
                                String bgElementNumber = bgElementInfo.getNumber();
                                String dim = String.valueOf(1100);
                                String bgItemsString = theFormula;
                                String cyNumber = localCyInfo.getNumber();
                                String yearString = String.valueOf(bgPeriodNode.getPeriod().getPeriodYear());
                                String quarterString = String.valueOf(bgPeriodNode.getPeriod().getPeriodQuarter());
                                String periodString = String.valueOf(bgPeriodNode.getPeriod().getPeriodNumber());
                                if (bgPeriodNode.isLeaf()) {
                                    formulaResult = bgProvider.parseBgFormula(schemeId, "AccountBudget", orgNumber, bgElementNumber, dim, bgItemsString, cyNumber, yearString, quarterString, periodString, bgFormInfo.getBgTemplate().getBgCycle());
                                }
                            } else if (bgPeriodNode.isLeaf()) {
                                formulaResult = this.caculateFormula(theFormula, vector, bgPeriodNode, bgEntryInfo.getBgItemsKey(), relations);
                            }
                        }
                    }
                    if (formulaResult == null) {
                        formulaResult = zero;
                    }
                    bgDataInfo.setBgValue(formulaResult);
                    bgDataInfo.setIdentity(BgFormHelper.getBgDataIdentity(bgEntryInfo, bgDataInfo));
                    bgEntryInfo.getBgData().add(bgDataInfo);
                }
                bgFormInfo.getBgEntries().add(bgEntryInfo);
            }
        }
    }

    private BigDecimal caculateFormula(String theFormula, Vector vector, BgPeriodNode currentBgPeriodNode, String bgItemsKey, TableRelations relations) {
        Object theValue;
        BigDecimal result = new BigDecimal("0");
        if (theFormula == null || theFormula.equals("")) {
            return result;
        }
        if ((theFormula = BgFormulaHelper.adjustFormula(theFormula, bgItemsKey, currentBgPeriodNode, vector)).equals("")) {
            return result;
        }
        Macro macro = relations.getNewMacroEngine(null, theFormula);
        boolean executeResult = false;
        try {
            executeResult = macro.execute();
        }
        catch (Exception e1) {
            e1.printStackTrace();
            return result;
        }
        if (!executeResult) {
            SyntaxErrorException e = macro.getSyntaxError();
            System.out.println(e.getMessage());
            return new BigDecimal("0");
        }
        Variant variant = macro.getVariableValue("$VALUE");
        if (variant != null && (theValue = variant.getValue()) != null) {
            if (theValue instanceof Number) {
                result = new BigDecimal(theValue.toString());
            } else if (theValue instanceof BigDecimal) {
                result = (BigDecimal)theValue;
            }
        }
        return result;
    }

    private TableRelations getCaculatorKdTable(Context ctx, String schemeId) {
        TableRelations relations = new TableRelations();
        BgFormulaProxy proxy = new BgFormulaProxy(ctx, schemeId);
        relations.getDefaultFunctionProvider().add(proxy);
        return relations;
    }

    private String adjustDimAndItem(BgEntryInfo bgEntryInfo) {
        BgItemInfo bgItemInfo;
        StringBuffer strItemKey = new StringBuffer(100);
        if (bgEntryInfo.getBgItem1() != null) {
            bgItemInfo = bgEntryInfo.getBgItem1();
            strItemKey.append(bgItemInfo.getBgDimension().getValue());
            strItemKey.append("&");
            strItemKey.append(bgItemInfo.getItemNumber());
        }
        if (bgEntryInfo.getBgItem2() != null) {
            bgItemInfo = bgEntryInfo.getBgItem2();
            strItemKey.append(":");
            strItemKey.append(bgItemInfo.getBgDimension().getValue());
            strItemKey.append("&");
            strItemKey.append(bgItemInfo.getItemNumber());
        }
        if (bgEntryInfo.getBgItem3() != null) {
            strItemKey.append(":");
            bgItemInfo = bgEntryInfo.getBgItem1();
            strItemKey.append(bgItemInfo.getBgDimension().getValue());
            strItemKey.append("&");
            strItemKey.append(bgItemInfo.getItemNumber());
        }
        if (bgEntryInfo.getBgItem4() != null) {
            strItemKey.append(":");
            bgItemInfo = bgEntryInfo.getBgItem1();
            strItemKey.append(bgItemInfo.getBgDimension().getValue());
            strItemKey.append("&");
            strItemKey.append(bgItemInfo.getItemNumber());
        }
        if (bgEntryInfo.getBgItem5() != null) {
            strItemKey.append(":");
            bgItemInfo = bgEntryInfo.getBgItem1();
            strItemKey.append(bgItemInfo.getBgDimension().getValue());
            strItemKey.append("&");
            strItemKey.append(bgItemInfo.getItemNumber());
        }
        if (bgEntryInfo.getBgItem6() != null) {
            strItemKey.append(":");
            bgItemInfo = bgEntryInfo.getBgItem1();
            strItemKey.append(bgItemInfo.getBgDimension().getValue());
            strItemKey.append("&");
            strItemKey.append(bgItemInfo.getItemNumber());
        }
        return strItemKey.toString();
    }

    @Override
    protected IObjectValue _getCurBgTemForFormSearch(Context ctx, BOSUuid orgId, BOSUuid bgTypeId) throws BOSException, EASBizException {
        IBgTemplate ibt = BgTemplateFactory.getLocalInstance(ctx);
        BgTemplateInfo info = null;
        try {
            info = (BgTemplateInfo)this._getCurrentBgTemplate(ctx, orgId, bgTypeId);
        }
        catch (BgTemplateException e) {
            info = null;
        }
        if (info == null) {
            return null;
        }
        BOSUuid temId = info.getId();
        return ibt.getBgTemplateInfo((IObjectPK)new ObjectUuidPK(temId), BgManagerControllerBean.getDataSelectors());
    }

    public static SelectorItemCollection getDataSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("bgCycle"));
        sic.add(new SelectorItemInfo("bgType.id"));
        sic.add(new SelectorItemInfo("refCurrencies.currency.number"));
        sic.add(new SelectorItemInfo("refCurrencies.currency.name"));
        sic.add(new SelectorItemInfo("refCurrencies.currency.id"));
        sic.add(new SelectorItemInfo("refDimensions.id"));
        sic.add(new SelectorItemInfo("refDimensions.bgDimension"));
        sic.add(new SelectorItemInfo("bgTpColumns.bgElement.id"));
        sic.add(new SelectorItemInfo("bgTpColumns.bgElement.number"));
        sic.add(new SelectorItemInfo("bgTpColumns.bgElement.name"));
        sic.add(new SelectorItemInfo("bgTpColumns.bgElement.dataType"));
        return sic;
    }

    @Override
    protected void _dealDistribute(Context ctx, IObjectPK pk, IObjectCollection subOrgs, Hashtable simpleScaleTable) throws BOSException, EASBizException {
        IBgFormDA iBgFormDa = BgFormDAFactory.getLocalInstance(ctx);
        IBgKDS iBgKDS = BgKDSFactory.getLocalInstance(ctx);
        IBgForm iBgForm = BgFormFactory.getLocalInstance(ctx);
        SimpleTimer time = new SimpleTimer();
        BgFormInfo bgFormInfoTotal = iBgFormDa.getFormForEdit(pk);
        BgSchemeInfo bgSchemeInfo = bgFormInfoTotal.getBgScheme();
        IBgScheme iBgScheme = BgSchemeFactory.getLocalInstance(ctx);
        bgSchemeInfo = iBgScheme.getBgSchemeInfo((IObjectPK)new ObjectUuidPK(bgSchemeInfo.getId()), BgSchemeHelper.getPeriodSelectors());
        BgTemplateInfo bgTemplateInfoTotal = bgFormInfoTotal.getBgTemplate();
        FullOrgUnitInfo orgUnitInfoTotal = bgFormInfoTotal.getOrgUnit();
        FullOrgUnitInfo org2 = null;
        OrgUnitCollection inOrgs = (OrgUnitCollection)subOrgs;
        BgFormCollection bgFormCollectionSub = new BgFormCollection();
        for (FullOrgUnitInfo org2 : inOrgs) {
            BgFormInfo subBgFormInfo = iBgFormDa.getBgFormForDis(bgFormInfoTotal.getBgType().getId().toString(), org2, bgSchemeInfo, bgTemplateInfoTotal);
            if (subBgFormInfo.getId() == null) {
                BgDisHelper.setFormNumberAndName(ctx, subBgFormInfo);
                subBgFormInfo.setState(BgFormStateEnum.Edited);
            }
            subBgFormInfo.setCU(BgOrgHelper.getDefCU());
            subBgFormInfo.setDataSource(BgFormDataSourceEnum.SUPERIORSPLIT);
            subBgFormInfo.setState(BgFormStateEnum.Distributing);
            subBgFormInfo.setHasEffected(true);
            Hashtable<String, BgOperationEnum> hash = new Hashtable<String, BgOperationEnum>();
            hash.put(subBgFormInfo.getOrgUnit().getId().toString(), BgOperationEnum.Distribute);
            bgFormCollectionSub.add(subBgFormInfo);
            BgDisHelper.applySimpleScale2(bgFormInfoTotal, bgFormCollectionSub, simpleScaleTable);
            logger.info((Object)("app get all bgForm44:" + time.getTime()));
            BgORMEngine.setIsNew((IObjectValue)subBgFormInfo, true);
            iBgForm.updateWithRecord_distribute(bgFormCollectionSub, hash);
            bgFormCollectionSub.clear();
        }
        System.out.println("app get all bgForm:" + time.getTime());
        logger.info((Object)("app get all bgForm:" + time.getTime()));
    }

    @Override
    protected Vector _getBgDimension(Context ctx, BOSUuid orgUnitId, BOSUuid bgTypeId, BOSUuid periodId) throws BOSException, EASBizException {
        Vector<BgDimensionEnum> result = new Vector<BgDimensionEnum>();
        BOSUuid bgFormId = this.getFormId(ctx, orgUnitId, bgTypeId, periodId);
        if (bgFormId == null) {
            return result;
        }
        String sql = "SELECT RefDims.FBgDimension bgdim FROM T_BG_BgForm BgForm INNER JOIN T_BG_BgTemplate BgTemplate ON BgForm.FBgTemplateID = BgTemplate.FID INNER JOIN T_BG_ReferencedDimension RefDims ON BgForm.FBgTemplateID = RefDims.FBgTemplateID WHERE (BgForm.FIsCurrent = 1) AND (BgForm.FID = ?) ";
        Connection conn = this.getConnection(ctx);
        PreparedStatement stmt = null;
        ResultSet rs = null;
        BgFormInfo bgFormInfo = new BgFormInfo();
        try {
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, bgFormId.toString());
            rs = stmt.executeQuery();
            while (rs.next()) {
                result.add(BgDimensionEnum.getEnum(rs.getInt(1)));
            }
        }
        catch (SQLException e) {
            try {
                throw new BgBizException(BgBizException.GETDATA, e, new Object[]{"bgForm"});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        return result;
    }
}

