/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bg.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.bg.BgBizException;
import com.kingdee.eas.ma.bg.BgCycleTypeEnum;
import com.kingdee.eas.ma.bg.BgDaHelper;
import com.kingdee.eas.ma.bg.BgFormInfo;
import com.kingdee.eas.ma.bg.BgFormStateEnum;
import com.kingdee.eas.ma.bg.BgSchemeInfo;
import com.kingdee.eas.ma.bg.BgTemplateInfo;
import com.kingdee.eas.ma.bg.BgTypeInfo;
import com.kingdee.eas.ma.bg.app.AbstractBgV2DistributeControllerBean;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class BgV2DistributeControllerBean
extends AbstractBgV2DistributeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.bg.app.BgV2DistributeControllerBean");

    @Override
    protected IObjectValue _getBgFormForDisChk(Context ctx, String bgFormId) throws BOSException, EASBizException {
        StringBuffer sb = new StringBuffer(200);
        sb.append(" SELECT bgForm.FID bgFormId, bgForm.FNumber, bgForm.FState,");
        sb.append(" bgTem.FID bgTemId, bgTem.FParentId, bgTem.FBgCycle,");
        sb.append(" bgForm.FBgSchemeID, bgForm.FBgTypeID");
        sb.append(" FROM T_BG_BgForm bgForm,T_BG_BgTemplate bgTem");
        sb.append(" WHERE bgForm.FBgTemplateId = bgTem.Fid and bgForm.FID = ?");
        Connection conn = this.getConnection(ctx);
        PreparedStatement stmt = null;
        ResultSet rs = null;
        BgFormInfo bgFormInfo = null;
        try {
            stmt = conn.prepareStatement(BgDaHelper.convert(ctx, sb.toString()));
            stmt.setString(1, BOSUuid.read((String)bgFormId).toString());
            rs = stmt.executeQuery();
            if (rs.next()) {
                bgFormInfo = new BgFormInfo();
                String id = rs.getString(1);
                String number = rs.getString(2);
                int state = rs.getInt(3);
                String bgTemId = rs.getString(4);
                String parentId = rs.getString(5);
                int cycle = rs.getInt(6);
                String schemeId = rs.getString(7);
                String bgTypeId = rs.getString(8);
                bgFormInfo.setId(BOSUuid.read((String)id));
                bgFormInfo.setNumber(number);
                bgFormInfo.setState(BgFormStateEnum.getEnum(state));
                BgTemplateInfo temInfo = new BgTemplateInfo();
                temInfo.setId(BOSUuid.read((String)bgTemId));
                if (parentId == null) {
                    temInfo.setParent(null);
                } else {
                    BgTemplateInfo parent = new BgTemplateInfo();
                    parent.setId(BOSUuid.read((String)parentId));
                    temInfo.setParent(parent);
                }
                temInfo.setBgCycle(BgCycleTypeEnum.getEnum(cycle));
                bgFormInfo.setBgTemplate(temInfo);
                BgSchemeInfo bgScheme = new BgSchemeInfo();
                bgScheme.setId(BOSUuid.read((String)schemeId));
                bgFormInfo.setBgScheme(bgScheme);
                BgTypeInfo bgType = new BgTypeInfo();
                bgType.setId(BOSUuid.read((String)bgTypeId));
                bgFormInfo.setBgType(bgType);
            }
        }
        catch (SQLException e) {
            try {
                logger.debug((Object)e);
                e.printStackTrace();
                throw new EASBizException(BgBizException.GETDATA, (Throwable)e, new Object[]{"BgForm"});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        return bgFormInfo;
    }

    @Override
    protected IObjectValue _getBgFormForDisChk(Context ctx, String bgTypeId, String orgId, String bgSchemeId, String bgTemplateId) throws BOSException, EASBizException {
        Connection conn = this.getConnection(ctx);
        PreparedStatement ps = null;
        ResultSet rs = null;
        BgFormInfo bgFormInfo = null;
        try {
            boolean blbgTypeId = bgTypeId != null;
            boolean blorgUnitId = orgId != null;
            boolean blbgSchemeID = bgSchemeId != null;
            StringBuffer strBuffer = new StringBuffer(" SELECT FID , FSTATE = CASE FSTATE\tWHEN 4 THEN 1\tELSE 2\tEND\tFROM T_BG_BgForm where FSTATE in (1,2,3,4,6,7,8,9,10,11,13,14)");
            if (blbgTypeId) {
                strBuffer.append(" and fbgTypeId = ? ");
            }
            if (blorgUnitId) {
                strBuffer.append(" and forgUnitID = ? ");
            }
            if (blorgUnitId) {
                strBuffer.append(" and fBgschemeID = ? ");
            }
            strBuffer.append(" ORDER BY FSTATE");
            ps = conn.prepareStatement(strBuffer.toString());
            strBuffer = null;
            int index = 1;
            if (blbgTypeId) {
                ps.setString(index++, BOSUuid.read((String)bgTypeId).toString());
            }
            if (blbgTypeId) {
                ps.setString(index++, BOSUuid.read((String)orgId).toString());
            }
            if (blbgTypeId) {
                ps.setString(index++, BOSUuid.read((String)bgSchemeId).toString());
            }
            rs = ps.executeQuery();
            String strId = null;
            if (rs.next()) {
                strId = rs.getString("FID");
            }
            if (strId != null) {
                bgFormInfo = (BgFormInfo)this._getBgFormForDisChk(ctx, strId);
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException(e.toString());
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)conn);
        return bgFormInfo;
    }
}

