/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bg.app.dao;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.bg.BgBizException;
import com.kingdee.eas.ma.bg.BgHelper;
import com.kingdee.eas.ma.bg.app.dao.BgAlyDAOBase;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.JdbcRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class BgBizSummaAlyDAO
extends BgAlyDAOBase {
    private BgBizSummaAlyDAO() {
    }

    public static BgBizSummaAlyDAO getInstance(Context ctx) {
        BgBizSummaAlyDAO dao = new BgBizSummaAlyDAO();
        dao.ctx = ctx;
        dao.locale = ctx.getLocale().toString();
        return dao;
    }

    protected Connection getConnection(Context ctx) throws SQLDataException {
        try {
            return EJBFactory.getConnection((Context)ctx);
        }
        catch (SQLException sqle) {
            throw new SQLDataException(sqle);
        }
    }

    public IRowSet getResult(EntityViewInfo ev) throws EASBizException, BgBizException, BOSException {
        FilterItemCollection filters = ev.getFilter().getFilterItems();
        StringBuffer sb = new StringBuffer();
        boolean filterByBizDate = this.isByBizDate(filters);
        Integer dispPeriod = (Integer)BgHelper.getFilterValue(filters, "displayPeriodStyle");
        String tableName1 = BgHelper.getTableName(this.ctx);
        String tableName2 = BgHelper.getTableName(this.ctx);
        String tableName3 = BgHelper.getTableName(this.ctx);
        String sbCreateTable1 = this.getCreateSql1(tableName1);
        String sbCreateTable2 = this.getCreateSql2(tableName2);
        String sbCreateTable3 = this.getCreateSql3(tableName3);
        String sbInsertTable1 = this.getInsertSql1(filters, filterByBizDate, tableName1, dispPeriod);
        String sbInsertTable2 = this.getInsertSql2(filterByBizDate, dispPeriod, tableName1, tableName2);
        PreparedStatement stmt = null;
        ResultSet rs = null;
        JdbcRowSet result = null;
        Connection conn = this.getConnection(this.ctx);
        try {
            stmt = conn.prepareStatement(sbCreateTable1);
            stmt.execute();
            SQLUtils.cleanup((Statement)stmt);
            stmt = conn.prepareStatement(sbInsertTable1);
            this.setParams1(filters, filterByBizDate, stmt);
            stmt.execute();
            SQLUtils.cleanup((Statement)stmt);
            stmt = conn.prepareStatement(sbCreateTable2);
            stmt.execute();
            stmt.close();
            stmt = conn.prepareStatement(sbInsertTable2);
            this.setParams2(filters, filterByBizDate, stmt);
            stmt.execute();
            stmt = conn.prepareStatement(sbCreateTable3);
            stmt.execute();
            stmt.close();
            stmt = conn.prepareStatement(this.getInsertSql3(dispPeriod, tableName2, tableName3));
            this.setParams3(filters, filterByBizDate, stmt);
            stmt.execute();
            stmt.close();
            String sql = this.getDisplaySql4BgBiz(tableName3);
            stmt = conn.prepareStatement(sql);
            rs = stmt.executeQuery();
            result = new JdbcRowSet();
            result.populate(rs);
        }
        catch (SQLException ex) {
            try {
                ex.printStackTrace();
                throw new BgBizException(BgBizException.BGALYRPTFETCHDATA, ex, new Object[]{"getExpBalanceRowSet"});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)stmt, (Connection)conn);
                BgHelper.dropTable(this.ctx, tableName1);
                BgHelper.dropTable(this.ctx, tableName2);
                BgHelper.dropTable(this.ctx, tableName3);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        BgHelper.dropTable(this.ctx, tableName1);
        BgHelper.dropTable(this.ctx, tableName2);
        BgHelper.dropTable(this.ctx, tableName3);
        return result;
    }

    private String getDisplaySql4BgBiz(String resultTableName) {
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT ResultData.*, ResultData.FBgValue - ResultData.FBgInitialValue AS FBgAdjustValue , BgItem1.FItemID AS BgItem1ID , BgItem1.FItemNumber AS BgItem1Number , BgItem1.FItemName_");
        sb.append(this.locale);
        sb.append(" AS BgItem1Name , BgItem2.FItemID AS BgItem2ID , BgItem2.FItemNumber AS BgItem2Number , BgItem2.FItemName_");
        sb.append(this.locale);
        sb.append(" AS BgItem2Name , BgItem3.FItemID AS BgItem3ID , BgItem3.FItemNumber AS BgItem3Number , BgItem3.FItemName_");
        sb.append(this.locale);
        sb.append(" AS BgItem3Name , BgItem4.FItemID AS BgItem4ID , BgItem4.FItemNumber AS BgItem4Number , BgItem4.FItemName_");
        sb.append(this.locale);
        sb.append(" AS BgItem4Name , BgItem5.FItemID AS BgItem5ID , BgItem5.FItemNumber AS BgItem5Number , BgItem5.FItemName_");
        sb.append(this.locale);
        sb.append(" AS BgItem5Name , BgItem6.FItemID AS BgItem6ID , BgItem6.FItemNumber AS BgItem6Number , BgItem6.FItemName_");
        sb.append(this.locale);
        sb.append(" AS BgItem6Name");
        sb.append(" FROM ");
        sb.append(resultTableName);
        sb.append(" ResultData LEFT OUTER JOIN T_BG_BgItem BgItem6 ON ResultData.FBgItem6ID = BgItem6.FID LEFT OUTER JOIN T_BG_BgItem BgItem5 ON ResultData.FBgItem5ID =BgItem5.FID LEFT OUTER JOIN T_BG_BgItem BgItem4 ON ResultData.FBgItem4ID =BgItem4.FID LEFT OUTER JOIN T_BG_BgItem BgItem3 ON ResultData.FBgItem3ID =BgItem3.FID LEFT OUTER JOIN T_BG_BgItem BgItem2 ON ResultData.FBgItem2ID =BgItem2.FID LEFT OUTER JOIN T_BG_BgItem BgItem1 ON ResultData.FBgItem1ID =BgItem1.FID  Order by FOrgUnitID,FBgTypeID,FDispPeriod, BgItem1Number, ResultData.FID");
        return sb.toString();
    }

    private String getInsertSql3(Integer dispPeriod, String table1, String table2) {
        if (dispPeriod == 12) {
            String dispPeriodS = " to_char(Period.FPeriodYear) ";
            String groupPeriod = " Period.FPeriodYear,";
            return this.groupByPeriod(table1, table2, dispPeriodS, groupPeriod);
        }
        if (dispPeriod == 3) {
            String dispPeriodS = " to_char(Period.FPeriodYear)||'-'||to_char(Period.FPeriodQuarter) ";
            String groupPeriod = " Period.FPeriodYear,Period.FPeriodQuarter,";
            return this.groupByPeriod(table1, table2, dispPeriodS, groupPeriod);
        }
        String selectSql = " to_char(Period.FPeriodYear)||'-'||right('0'||to_char(Period.FPeriodNumber),2) ";
        String groupSql = " Period.FPeriodYear,Period.FPeriodNumber,";
        return this.groupByPeriod(table1, table2, selectSql, groupSql);
    }

    private String groupByPeriod(String table1, String table2, String disp, String groupSql) {
        StringBuffer sb = new StringBuffer(256);
        sb.append("INSERT INTO ");
        sb.append(table2);
        sb.append(" SELECT  A.FOrgUnitID||");
        sb.append(disp);
        sb.append("||isnull(A.FBgItem1ID,'') || isnull(A.FBgItem2ID,'') || isnull(A.FBgItem3ID,'') || isnull(A.FBgItem4ID,'') || isnull(A.FBgItem5ID,'')  AS FID, A.FOrgUnitID, A.FBgTypeID," + disp + " AS FDispPeriod, A.FCurrencyID, A.FBizElement, sum(Lst.FBizActual) AS FLstBizValue, sum(A.FBgValue), sum(A.FBgInitialValue), sum(A.FBizActual), sum(Nxt.FBgValue) AS FNxtBgValue, A.FBgItem1ID, A.FBgItem2ID, A.FBgItem3ID, A.FBgItem4ID, A.FBgItem5ID, A.FBgItem6ID FROM ");
        sb.append(table1);
        sb.append(" A LEFT OUTER JOIN ");
        sb.append(table1);
        sb.append(" Nxt ON A.FOrgUnitID = Nxt.FOrgUnitID AND A.FBgItem1ID = Nxt.FBgItem1ID AND A.FBgItem2ID = Nxt.FBgItem2ID AND A.FBgItem3ID = Nxt.FBgItem3ID AND A.FBgItem4ID = Nxt.FBgItem4ID AND A.FBgItem5ID = Nxt.FBgItem5ID AND A.FBgItem6ID = Nxt.FBgItem6ID AND A.FBizElement = Nxt.FBizElement AND A.FCurrencyID = Nxt.FCurrencyID AND A.FBgTypeID = Nxt.FBgTypeID LEFT OUTER JOIN ");
        sb.append(table1);
        sb.append(" Lst ON A.FOrgUnitID = Lst.FOrgUnitID AND A.FBgItem1ID = Lst.FBgItem1ID AND A.FBgItem2ID = Lst.FBgItem2ID AND A.FBgItem3ID = Lst.FBgItem3ID AND A.FBgItem4ID = Lst.FBgItem4ID AND A.FBgItem5ID = Lst.FBgItem5ID AND A.FBgItem6ID = Lst.FBgItem6ID AND A.FBizElement = Lst.FBizElement AND A.FCurrencyID = Lst.FCurrencyID AND A.FBgTypeID = Lst.FBgTypeID");
        sb.append("  inner join T_BD_Period Period on A.FPeriodID = Period.FID");
        sb.append(" WHERE (A.PERIODSEQ BETWEEN ? AND ?)");
        sb.append(" AND (A.PERIODSEQ = Lst.PERIODSEQ + 100 or Lst.PERIODSEQ is null) ");
        sb.append(" AND (A.PERIODSEQ = Nxt.PERIODSEQ - 100 or Nxt.PERIODSEQ is null)");
        sb.append(" Group by  A.FOrgUnitID,A.FBgTypeID," + groupSql + " A.FBizElement, A.FCurrencyID, A.FBgItem1ID,A.FBgItem2ID,A.FBgItem3ID,A.FBgItem4ID,A.FBgItem5ID,A.FBgItem6ID");
        return sb.toString();
    }

    private void setParams3(FilterItemCollection filters, boolean filterByBizDate, PreparedStatement stmt) throws EASBizException, BOSException, SQLException {
        int number = 1;
        int beginPeriodYear = Integer.parseInt(BgHelper.getFilterValue(filters, "beginPeriodYear").toString());
        int beginPeriodMonth = Integer.parseInt(BgHelper.getFilterValue(filters, "beginPeriodMonth").toString());
        int endPeriodYear = Integer.parseInt(BgHelper.getFilterValue(filters, "endPeriodYear").toString());
        int endPeriodMonth = Integer.parseInt(BgHelper.getFilterValue(filters, "endPeriodMonth").toString());
        stmt.setInt(number++, beginPeriodYear * 100 + beginPeriodMonth);
        stmt.setInt(number++, endPeriodYear * 100 + endPeriodMonth);
    }

    public void setParams2(FilterItemCollection filters, boolean filterByBizDate, PreparedStatement stmt) throws SQLException {
        if (filterByBizDate) {
            stmt.setDate(1, (Date)BgHelper.getFilterValue(filters, "beginBizDate"));
            stmt.setDate(2, (Date)BgHelper.getFilterValue(filters, "endBizDate"));
        }
    }

    public void setParams1(FilterItemCollection filters, boolean filterByBizDate, PreparedStatement stmt) throws SQLException {
        int number = 1;
        stmt.setString(number++, BgHelper.getId(BgHelper.getFilterValue(filters, "bgType")));
        if (filterByBizDate) {
            stmt.setDate(number++, (Date)BgHelper.getFilterValue(filters, "beginBizDate"));
            stmt.setDate(number++, (Date)BgHelper.getFilterValue(filters, "endBizDate"));
        } else {
            int beginPeriodYear = Integer.parseInt(BgHelper.getFilterValue(filters, "beginPeriodYear").toString());
            int beginPeriodMonth = Integer.parseInt(BgHelper.getFilterValue(filters, "beginPeriodMonth").toString());
            int endPeriodYear = Integer.parseInt(BgHelper.getFilterValue(filters, "endPeriodYear").toString());
            int endPeriodMonth = Integer.parseInt(BgHelper.getFilterValue(filters, "endPeriodMonth").toString());
            stmt.setInt(number++, beginPeriodYear * 100 + beginPeriodMonth);
            stmt.setInt(number++, endPeriodYear * 100 + endPeriodMonth);
        }
    }

    public String getInsertSql2(boolean filterByBizDate, Integer dispPeriod, String tableName1, String tableName2) {
        StringBuffer sb = new StringBuffer();
        sb.append("INSERT INTO ");
        sb.append(tableName2);
        sb.append(" SELECT BgEntry.FID,  BgEntry.FOrgUnitID, BgEntry.FBgTypeID, BgEntry.FPeriodID, Period.FPeriodYear * 100 + Period.FPeriodNumber AS periodSeq, BgElement.FBizElement, BgData.FCurrencyID, BgData.FBgValue, BgData.FBgLastBalance, BgData.FBgActual, BgData.FBizActual, BgData.FBgInitialValue, BgData.FBgBalance, BgData.FBgUsableValue, BgEntry.FBgItem1ID, BgEntry.FBgItem2ID, BgEntry.FBgItem3ID, BgEntry.FBgItem4ID, BgEntry.FBgItem5ID, BgEntry.FBgItem6ID ");
        sb.append(" FROM T_BG_BgData BgData INNER JOIN T_BG_BgElement BgElement ON BgData.FBgElementID = BgElement.FID inner JOIN ").append(tableName1).append(" BgEntry ON BgData.FBgEntryID = BgEntry.FID INNER JOIN T_BD_Period Period ON Period.FID = BgEntry.FPeriodID");
        return sb.toString();
    }

    public String getCreateSql2(String table) {
        StringBuffer sb = new StringBuffer();
        sb.append("Create Table ");
        sb.append(table);
        sb.append(" (FID char (44),FOrgUnitID char (44),FBgTypeID char (44),FPeriodID char (44), PERIODSEQ int ,FBizElement int ,FCurrencyID char (44),FBgValue decimal(28,10),FBgLastBalance decimal(28,10),FBgActual decimal(28,10),FBizActual decimal(28,10),FBgInitialValue decimal(28,10),FBgBalance decimal(28,10),FBgUsableValue decimal(28,10),FBgItem1ID char (44),FBgItem2ID char (44),FBgItem3ID char (44),FBgItem4ID char (44),FBgItem5ID char (44),FBgItem6ID char (44))");
        return sb.toString();
    }

    public String getCreateSql3(String tableName) {
        StringBuffer sb = new StringBuffer();
        sb.append(" Create Table ");
        sb.append(tableName);
        sb.append("(FID varchar (512),FOrgUnitID char (44),FBgTypeID char (44),FDispPeriod char (44),FCurrencyID char (44),FBizElement int ,FLSTBIZVALUE decimal(28,10),FBgValue decimal(28,10),FBgInitialValue decimal(28,10),FBizActual decimal(28,10),FNXTBGVALUE decimal(28,10),FBgItem1ID char (44),FBgItem2ID char (44),FBgItem3ID char (44),FBgItem4ID char (44),FBgItem5ID char (44),FBgItem6ID char (44))");
        return sb.toString();
    }

    public String getInsertSql1(FilterItemCollection filters, boolean filterByBizDate, String table, Integer dispPeriod) {
        StringBuffer sb = new StringBuffer();
        sb.append("INSERT INTO ");
        sb.append(table);
        sb.append(" SELECT v.FID, v.FOrgUnitID, v.FBgTypeID, v.FPeriodID, v.FBgItem1ID, v.FBgItem2ID, v.FBgItem3ID, v.FBgItem4ID, v.FBgItem5ID, v.FBgItem6ID FROM V_BG_BgEntry as v, t_bg_bgentry as t");
        if (filterByBizDate) {
            sb.append(" WHERE  (v.FOrgUnitID IN (").append(BgHelper.getFilterValue(filters, "bizOrgUnitIDs")).append(")  AND (v.FBgTypeID = ?) AND (v.FEndDate  > ?) AND  (v.FBeginDate < ?))");
        } else {
            sb.append(" WHERE  (v.FOrgUnitID IN (").append(BgHelper.getFilterValue(filters, "bizOrgUnitIDs")).append(") ").append(" AND (v.FBgTypeID = ?) AND (v.FPeriodYear*100+v.FPeriodNumber  BETWEEN ? AND ?)) ");
        }
        sb.append(" and v.fid=t.fid ");
        if (dispPeriod != 12) {
            if (dispPeriod == 1) {
                sb.append(" and t.FBgCycle=3 ");
            } else if (dispPeriod == 3) {
                sb.append(" and (t.FBgCycle=2 or t.FBgCycle=3) ");
            }
        }
        return sb.toString();
    }

    public String getCreateSql1(String table) {
        StringBuffer sb = new StringBuffer();
        sb.append("Create Table ");
        sb.append(table);
        sb.append("  (FID char (44), FOrgUnitID char (44), FBgTypeID char (44), FPeriodID char (44), FBgItem1ID char (44), FBgItem2ID char (44), FBgItem3ID char (44), FBgItem4ID char (44), FBgItem5ID char (44), FBgItem6ID char (44))");
        return sb.toString();
    }
}

