/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bg;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class BGUtils {
    private static final int BUFF_SIZE = 8192;

    public static byte[] compressObject(Object object) throws Exception {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(8192);
        GZIPOutputStream gout = new GZIPOutputStream((OutputStream)bos, 8192);
        ObjectOutputStream os = new ObjectOutputStream(gout);
        os.writeObject(object);
        BGUtils.closeOutputStream(bos, gout, bos);
        return bos.toByteArray();
    }

    public static Object uncompressObject(byte[] data) throws Exception {
        ByteArrayInputStream bin = new ByteArrayInputStream(data);
        GZIPInputStream gin = new GZIPInputStream((InputStream)bin, 8192);
        ObjectInputStream oin = new ObjectInputStream(gin);
        Object obj = oin.readObject();
        BGUtils.closeInputStream(bin, gin, oin);
        return obj;
    }

    private static void closeInputStream(InputStream inByte, InputStream inZip, InputStream inObject) {
        BGUtils.closeInputStream(inObject);
        BGUtils.closeInputStream(inZip);
        BGUtils.closeInputStream(inByte);
    }

    private static void closeOutputStream(OutputStream outByte, OutputStream outZip, OutputStream outObject) {
        BGUtils.closeOutputStream(outObject);
        BGUtils.closeOutputStream(outZip);
        BGUtils.closeOutputStream(outByte);
    }

    private static void closeInputStream(InputStream in) {
        try {
            in.close();
        }
        catch (IOException ie) {
            ie.getMessage();
        }
        in = null;
    }

    private static void closeOutputStream(OutputStream out) {
        try {
            out.close();
        }
        catch (IOException ie) {
            ie.getMessage();
        }
        out = null;
    }

    public static int getObjectSize(Object obj) {
        int size = 0;
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream(8192);
            ObjectOutputStream os = new ObjectOutputStream(bos);
            long start = System.currentTimeMillis();
            os.writeObject(obj);
            long end = System.currentTimeMillis();
            bos.close();
            byte[] data = bos.toByteArray();
            size = data.length;
        }
        catch (Exception e) {
            e.getMessage();
        }
        return size;
    }
}

