/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bg;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.IVoucher;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.ma.bg.BgCheckHelper;
import com.kingdee.eas.ma.bg.BgCtrlParam;
import com.kingdee.eas.ma.bg.BgTemplateColumnCollection;
import com.kingdee.eas.ma.bg.BgTemplateInfo;
import com.kingdee.eas.ma.bg.BgVerifyException;
import com.kingdee.eas.ma.bg.IGetBgParam;
import com.kingdee.eas.ma.bg.ReferencedCurrencyCollection;
import com.kingdee.eas.ma.bg.ReferencedCurrencyInfo;
import com.kingdee.eas.ma.bg.ReferencedDimensionCollection;
import java.util.Iterator;

public class BgAuditUtils {
    public static final int TYPE_Voucher = 1;
    public static final int TYPE_ExpendBill = 2;
    public static final int TYPE_LoanReqBill = 3;

    public static BgCtrlParam[] getBgCtrlParaByUuid(Context ctx, BOSUuid bosUuid) throws EASBizException, BOSException {
        int type = BgAuditUtils.getBillType(ctx, bosUuid);
        BgCtrlParam[] bgCtrlParamArray = null;
        if (type == 1) {
            IVoucher iVoucher = VoucherFactory.getLocalInstance((Context)ctx);
            return bgCtrlParamArray;
        }
        BOSObjectType bosType = bosUuid.getType();
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        EntityObjectInfo entity = loader.getEntity(bosType);
        String path = entity.getExtendedProperty("BgCtrl");
        Class<?> obj = null;
        try {
            obj = Class.forName(path);
            IGetBgParam ig = (IGetBgParam)obj.newInstance();
            bgCtrlParamArray = ig.getBgParam(ctx, bosUuid);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return bgCtrlParamArray;
    }

    public static int getBillType(Context ctx, BOSUuid bosUuid) {
        BOSObjectType bosType = bosUuid.getType();
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        EntityObjectInfo entity = loader.getEntity(bosType);
        String bizI = entity.getBusinessInterface();
        Object bgCtrlParamArray = null;
        int index = bizI.lastIndexOf("IVoucher");
        if (index != -1) {
            return 1;
        }
        return 2;
    }

    public static boolean verifyBizData(BgCtrlParam param, BgTemplateInfo bgTemplateInfo) throws EASBizException, BgVerifyException {
        if (!BgAuditUtils.verifyDimensions(param, bgTemplateInfo.getRefDimensions())) {
            return false;
        }
        if (!BgAuditUtils.verifyBizElement(param, bgTemplateInfo.getBgTpColumns())) {
            return false;
        }
        return BgAuditUtils.verifyCurrency(param, bgTemplateInfo.getRefCurrencies());
    }

    public static boolean verifyParam(Context ctx, BgCtrlParam bgCtrlParam) throws EASBizException, BOSException {
        BgCheckHelper.checkBlank(bgCtrlParam, new Object[]{"param"});
        BgCheckHelper.checkBlank(bgCtrlParam.getCompanyId(), new Object[]{"companyId"});
        BgCheckHelper.checkBlank(bgCtrlParam.getPeriodId(), new Object[]{"periodId"});
        BgCheckHelper.checkBlank(bgCtrlParam.getBizDate(), new Object[]{"bizDate"});
        BgCheckHelper.checkBlank(bgCtrlParam.getBizOrgUnitId(), new Object[]{"bizOrgUnitId"});
        BgCheckHelper.checkBlank(bgCtrlParam.getCtrlSystem(), new Object[]{"ctrlSystem"});
        BgCheckHelper.checkBlank(bgCtrlParam.getBgTypeId(), new Object[]{"bgTypeId"});
        BgCheckHelper.checkBlank(bgCtrlParam.getSrcBillId(), new Object[]{"srcBillId"});
        BgCheckHelper.checkBlank(bgCtrlParam.getCurrencyId(), new Object[]{"currency"});
        BgCheckHelper.checkBlank(bgCtrlParam.getDimensions().size(), new Object[]{"dimensions"});
        BgCheckHelper.checkBlank(bgCtrlParam.getDatas().size(), new Object[]{"datas"});
        return true;
    }

    public static boolean verifyBizElement(BgCtrlParam bgCtrlParam, BgTemplateColumnCollection columns) throws EASBizException {
        for (int i = 0; i < columns.size(); ++i) {
            if (bgCtrlParam.getData(columns.get(i).getBgElement().getBizElement()) != null) continue;
            return false;
        }
        return true;
    }

    public static boolean verifyDimensions(BgCtrlParam bgCtrlParam, ReferencedDimensionCollection bgDims) throws EASBizException {
        for (int i = 0; i < bgDims.size(); ++i) {
            IObjectValue dim = bgCtrlParam.getDimension(bgDims.get(i).getBgDimension());
            if (dim == null) {
                return false;
            }
            dim.setInt("BgDimIndex", i);
        }
        return true;
    }

    public static boolean verifyCurrency(BgCtrlParam bgCtrlParam, ReferencedCurrencyCollection refCurColl) throws BgVerifyException {
        Iterator refCurrency = refCurColl.iterator();
        while (refCurrency.hasNext()) {
            ReferencedCurrencyInfo element = (ReferencedCurrencyInfo)refCurrency.next();
            if (!element.getCurrency().getId().equals((Object)bgCtrlParam.getCurrencyId())) continue;
            return true;
        }
        return false;
    }
}

