/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bg;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.bg.BgDataCollection;
import com.kingdee.eas.ma.bg.BgDataInfo;
import com.kingdee.eas.ma.bg.BgEntryCollection;
import com.kingdee.eas.ma.bg.BgEntryInfo;
import com.kingdee.eas.ma.bg.BgFormCollection;
import com.kingdee.eas.ma.bg.BgFormInfo;
import com.kingdee.eas.ma.bg.BgFormStateHelper;
import com.kingdee.eas.ma.bg.BgHelper;
import com.kingdee.eas.ma.bg.BgTemplateInfo;
import com.kingdee.eas.util.client.EASResource;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;

public class BgDisHelper {
    public static boolean checkBgCycleBigger(BgFormInfo bgFormInfoTotal, BgFormCollection bgFormCollectionSub) {
        int bgCycle = bgFormInfoTotal.getBgTemplate().getBgCycle().getValue();
        Iterator iter = bgFormCollectionSub.iterator();
        while (iter.hasNext()) {
            BgFormInfo bfi = (BgFormInfo)iter.next();
            BgTemplateInfo bti = bfi.getBgTemplate();
            if (bti.getBgCycle().getValue() <= bgCycle) continue;
            return false;
        }
        return true;
    }

    public static boolean checkChildrenVlaid(BOSUuid parentTpId, BgFormCollection bfc) {
        boolean result = true;
        Iterator iter = bfc.iterator();
        while (iter.hasNext()) {
            BgFormInfo bfi = (BgFormInfo)iter.next();
            BgTemplateInfo bti = bfi.getBgTemplate();
            if (bti.getId().equals((Object)parentTpId)) continue;
            if (bti.getParent() == null) {
                result = false;
                break;
            }
            BOSUuid subTpId = bti.getParent().getId();
            if (subTpId.equals((Object)parentTpId)) continue;
            result = false;
            break;
        }
        return result;
    }

    public static void applySimpleScale(BgFormInfo editData, BgFormCollection subBgFormCollection, Hashtable scaleTable) {
        int entrySize = editData.getBgEntries().size();
        for (int i = 0; i < entrySize; ++i) {
            BgEntryInfo bgEntryInfo = editData.getBgEntries().get(i);
            int dataSize = bgEntryInfo.getBgData().size();
            for (int j = 0; j < dataSize; ++j) {
                BgDataInfo bgDataInfo = bgEntryInfo.getBgData().get(j);
                int formSize = subBgFormCollection.size();
                for (int k = 0; k < formSize; ++k) {
                    BgFormInfo subFormInfo = subBgFormCollection.get(k);
                    BgEntryCollection subBgEntryCollection = BgDisHelper.getBgEntryCollByLowerBgForm(bgEntryInfo, subFormInfo);
                    BigDecimal scale = (BigDecimal)scaleTable.get(subBgFormCollection.get(k).getOrgUnit().getId().toString());
                    BgDisHelper.setBgDataScaleLowerBgEntryColl(bgDataInfo, subBgEntryCollection, scale);
                }
            }
        }
    }

    public static void applySimpleScale2(BgFormInfo editData, BgFormCollection subBgFormCollection, Hashtable scaleTable) {
        HashMap mapTotal = editData.reassembleBgForm();
        Object[] vecEntryKey = mapTotal.keySet().toArray();
        BgDataInfo dataInfoTotal = null;
        int m = subBgFormCollection.size();
        for (int i = 0; i < m; ++i) {
            BgFormInfo subBgFormInfo = subBgFormCollection.get(i);
            HashMap mapSub = subBgFormInfo.reassembleBgForm();
            BigDecimal scale = (BigDecimal)scaleTable.get(subBgFormInfo.getOrgUnit().getId().toString());
            for (int j = 0; j < vecEntryKey.length; ++j) {
                Object entryKey = vecEntryKey[j];
                HashMap mapDataTotal = (HashMap)mapTotal.get(entryKey);
                HashMap mapDataSub = (HashMap)mapSub.get(entryKey);
                if (mapDataTotal == null || mapDataSub == null) continue;
                Object[] vecDataKey = mapDataTotal.keySet().toArray();
                for (int k = 0; k < vecDataKey.length; ++k) {
                    Object dataKey = vecDataKey[k];
                    dataInfoTotal = (BgDataInfo)mapDataTotal.get(dataKey);
                    BgDataInfo dataInfoSub = (BgDataInfo)mapDataSub.get(dataKey);
                    if (!dataInfoSub.getBgElement().isApportionable()) {
                        dataInfoSub.setBgValue(dataInfoTotal.getBgValue());
                        continue;
                    }
                    BigDecimal bigValue = dataInfoTotal.getBgValue().multiply(scale).divide(new BigDecimal("100"), 6, 4);
                    dataInfoSub.setBgValue(bigValue);
                }
            }
        }
    }

    public static BgEntryCollection getBgEntryCollByLowerBgForm(BgEntryInfo bgEntryInfo, BgFormInfo subBgFormInfo) {
        BgEntryCollection bgEntryCollection = new BgEntryCollection();
        PeriodInfo periodInfo = bgEntryInfo.getPeriod();
        String strEntryKey = bgEntryInfo.getBgItemsKey();
        BgEntryCollection bgEntryCollectionTemp = subBgFormInfo.getBgEntries();
        int sizeTemp = bgEntryCollectionTemp.size();
        for (int j = 0; j < sizeTemp; ++j) {
            BgEntryInfo bgEntryInfoTemp = bgEntryCollectionTemp.get(j);
            if (!bgEntryInfoTemp.isIsLeafPeriod() || !periodInfo.getId().equals((Object)bgEntryInfoTemp.getPeriod().getId()) || !strEntryKey.equals(bgEntryInfoTemp.getBgItemsKey()) || !bgEntryInfo.getBgCycle().equals((Object)bgEntryInfoTemp.getBgCycle())) continue;
            bgEntryCollection.add(bgEntryInfoTemp);
        }
        return bgEntryCollection;
    }

    public static void setBgDataScaleLowerBgEntryColl(BgDataInfo bgDataInfo, BgEntryCollection subBgEntryCollection, BigDecimal bigScale) {
        int size = subBgEntryCollection.size();
        String elementKey = bgDataInfo.getElementKey();
        for (int i = 0; i < size; ++i) {
            BgEntryInfo bgEntryInfoTemp = subBgEntryCollection.get(i);
            BgDataCollection bgDataCollectionTemp = bgEntryInfoTemp.getBgData();
            int sizeTemp = bgDataCollectionTemp.size();
            for (int j = 0; j < sizeTemp; ++j) {
                BgDataInfo bgDataInfoTemp = bgDataCollectionTemp.get(j);
                if (!elementKey.equals(bgDataInfoTemp.getElementKey()) || !bgDataInfo.getElementNumber().equals(bgDataInfoTemp.getElementNumber())) continue;
                if (!bgDataInfo.getBgElement().isApportionable()) {
                    bgDataInfoTemp.setBgValue(bgDataInfo.getBgValue());
                    continue;
                }
                BigDecimal bigValue = bgDataInfo.getBgValue().multiply(bigScale).divide(new BigDecimal("100"), 6, 4);
                bgDataInfoTemp.setBgValue(bigValue);
            }
        }
    }

    public static void checkState(BgFormInfo bgForm, boolean isCurr) throws BOSException, EASBizException {
        BgFormStateHelper bsh = new BgFormStateHelper();
        int state = bgForm.getState().getValue();
        if (bgForm.getId() == null) {
            state = -1;
        }
        boolean isOk = false;
        boolean isProm = false;
        if (isCurr) {
            isOk = bsh.isDistCurrForm(state);
            isProm = bsh.isDistCurrProm(state);
        } else {
            isOk = bsh.isDistSubForm(state);
            isProm = bsh.isDistSubProm(state);
        }
        if (!isOk && !isProm) {
            String str = EASResource.getString((String)"com.kingdee.eas.ma.bg.BgAllApproveResource", (String)"CurrBgForm");
            String strResState = EASResource.getString((String)"com.kingdee.eas.ma.bg.BgAllApproveResource", (String)"State");
            String strSub = EASResource.getString((String)"com.kingdee.eas.ma.bg.BgAllApproveResource", (String)"SubBgForm");
            String strState = bgForm.getNumber() + ":" + bgForm.getState().getAlias();
            String str1 = EASResource.getString((String)"com.kingdee.eas.ma.bg.BgAllApproveResource", (String)"NotDistribute");
            if (isCurr) {
                throw new BOSException(str + strState + strResState + str1);
            }
            throw new BOSException(strSub + strState + strResState + str1);
        }
    }

    public static void setFormNumberAndName(Context ctx, BgFormInfo tmpBgFormInfo) throws BOSException {
        ICodingRuleManager iCodingRuleManager = null;
        iCodingRuleManager = ctx == null ? CodingRuleManagerFactory.getRemoteInstance() : CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        String theNumber = null;
        try {
            theNumber = iCodingRuleManager.getNumber((IObjectValue)new BgTemplateInfo(), tmpBgFormInfo.getOrgUnit().getId().toString());
        }
        catch (Exception e) {
            theNumber = null;
        }
        if (theNumber == null) {
            theNumber = tmpBgFormInfo.getOrgUnit().getNumber() + "_" + tmpBgFormInfo.getBgType().getNumber() + "_" + BgHelper.getTimeString();
        }
        tmpBgFormInfo.setNumber(theNumber);
        tmpBgFormInfo.setName(tmpBgFormInfo.getOrgUnit().getName() + "_" + tmpBgFormInfo.getBgType().getName() + "_" + BgHelper.getTimeString());
    }
}

