/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bg;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.ma.bg.BgDataInfo;
import com.kingdee.eas.ma.bg.BgEntryInfo;
import com.kingdee.eas.ma.bg.BgFormFactory;
import com.kingdee.eas.ma.bg.BgFormInfo;
import com.kingdee.eas.ma.bg.BgFormLogHelper;
import com.kingdee.eas.ma.bg.BgOperationEnum;
import com.kingdee.eas.ma.bg.BgPeriodNode;
import com.kingdee.eas.ma.bg.IBgForm;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;

public class BgFormHelper {
    public static SelectorItemCollection getCloneSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("bizDate"));
        sic.add(new SelectorItemInfo("state"));
        sic.add(new SelectorItemInfo("purpose"));
        sic.add(new SelectorItemInfo("isCurrent"));
        sic.add(new SelectorItemInfo("modifiableByJunior"));
        sic.add(new SelectorItemInfo("creator"));
        sic.add(new SelectorItemInfo("bgType"));
        sic.add(new SelectorItemInfo("orgUnit"));
        sic.add(new SelectorItemInfo("bgTemplate"));
        sic.add(new SelectorItemInfo("bgScheme"));
        sic.add(new SelectorItemInfo("periodFrom"));
        sic.add(new SelectorItemInfo("periodTo"));
        sic.add(new SelectorItemInfo("bgScheme"));
        sic.add(new SelectorItemInfo("bgEntries"));
        sic.add(new SelectorItemInfo("bgEntries.bgData"));
        return sic;
    }

    public static SelectorItemCollection getEditDataSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("bizDate"));
        sic.add(new SelectorItemInfo("state"));
        sic.add(new SelectorItemInfo("purpose"));
        sic.add(new SelectorItemInfo("isCurrent"));
        sic.add(new SelectorItemInfo("creator"));
        sic.add(new SelectorItemInfo("bgType"));
        sic.add(new SelectorItemInfo("orgUnit"));
        sic.add(new SelectorItemInfo("bgTemplate"));
        sic.add(new SelectorItemInfo("bgScheme"));
        sic.add(new SelectorItemInfo("periodFrom"));
        sic.add(new SelectorItemInfo("periodTo"));
        sic.add(new SelectorItemInfo("bgEntries"));
        sic.add(new SelectorItemInfo("bgEntries.period"));
        sic.add(new SelectorItemInfo("bgEntries.bgItem1"));
        sic.add(new SelectorItemInfo("bgEntries.bgItem2"));
        sic.add(new SelectorItemInfo("bgEntries.bgItem3"));
        sic.add(new SelectorItemInfo("bgEntries.bgItem4"));
        sic.add(new SelectorItemInfo("bgEntries.bgItem5"));
        sic.add(new SelectorItemInfo("bgEntries.bgItem6"));
        sic.add(new SelectorItemInfo("bgEntries.bgData"));
        sic.add(new SelectorItemInfo("bgEntries.bgData.currency"));
        sic.add(new SelectorItemInfo("bgEntries.bgData.bgElement"));
        return sic;
    }

    public static SelectorItemCollection getDecDistDataSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("bizDate"));
        sic.add(new SelectorItemInfo("state"));
        sic.add(new SelectorItemInfo("purpose"));
        sic.add(new SelectorItemInfo("isCurrent"));
        sic.add(new SelectorItemInfo("creator"));
        sic.add(new SelectorItemInfo("bgType"));
        sic.add(new SelectorItemInfo("orgUnit"));
        sic.add(new SelectorItemInfo("bgTemplate"));
        sic.add(new SelectorItemInfo("bgTemplate.bgCycle"));
        sic.add(new SelectorItemInfo("bgScheme"));
        sic.add(new SelectorItemInfo("periodFrom"));
        sic.add(new SelectorItemInfo("periodTo"));
        sic.add(new SelectorItemInfo("bgEntries"));
        sic.add(new SelectorItemInfo("bgEntries.period"));
        sic.add(new SelectorItemInfo("bgEntries.bgItem1"));
        sic.add(new SelectorItemInfo("bgEntries.bgItem2"));
        sic.add(new SelectorItemInfo("bgEntries.bgItem3"));
        sic.add(new SelectorItemInfo("bgEntries.bgItem4"));
        sic.add(new SelectorItemInfo("bgEntries.bgItem5"));
        sic.add(new SelectorItemInfo("bgEntries.bgItem6"));
        sic.add(new SelectorItemInfo("bgEntries.bgData"));
        sic.add(new SelectorItemInfo("bgEntries.bgData.currency"));
        sic.add(new SelectorItemInfo("bgEntries.bgData.bgElement"));
        sic.add(new SelectorItemInfo("pastRecords"));
        sic.add(new SelectorItemInfo("pastRecords.id"));
        sic.add(new SelectorItemInfo("pastRecords.pastData"));
        return sic;
    }

    public static void sortCollection(IObjectCollection iObjCollection) {
        if (iObjCollection.size() == 1) {
            return;
        }
        for (int i = 0; i < iObjCollection.size() - 1; ++i) {
            for (int j = 0; j < iObjCollection.size() - 1 - i; ++j) {
                Comparable compare2;
                Comparable compare1 = (Comparable)iObjCollection.getObject(j);
                if (compare1.compareTo(compare2 = (Comparable)iObjCollection.getObject(j + 1)) <= 0) continue;
                BgFormHelper.swap(iObjCollection, j, j + 1);
            }
        }
    }

    public static boolean swap(IObjectCollection iObjCollection, int indexA, int indexB) {
        if (indexA == indexB) {
            return true;
        }
        if (indexA == -1 || indexB == -1) {
            return false;
        }
        if (indexA >= iObjCollection.size() || indexB >= iObjCollection.size()) {
            return false;
        }
        IObjectValue a = iObjCollection.getObject(indexA);
        IObjectValue b = iObjCollection.getObject(indexB);
        iObjCollection.removeObject(indexA);
        iObjCollection.removeObject(indexB - 1);
        iObjCollection.addObject(indexA, b);
        iObjCollection.addObject(indexB, a);
        return true;
    }

    public static String getBgDataIdentity(BgEntryInfo bei, BgDataInfo bdi) {
        return BgPeriodNode.toNumbericString(bei.getPeriod(), bei.getBgCycle()) + "_" + bei.getBgItemsKey() + "_" + bdi.getElementKey();
    }

    public static void storeBgFormLog(BgFormInfo bgFormInfo, BgOperationEnum bgOpr) throws EASBizException, BOSException {
        UserInfo user = (UserInfo)SysContext.getSysContext().getCurrentUser();
        BgFormLogHelper.addNewBgFormLog(null, bgFormInfo, bgOpr, user);
    }

    public static boolean checkBgFormValid(String formId) throws EASBizException, BOSException {
        IBgForm iBgForm = BgFormFactory.getRemoteInstance();
        boolean isExist = iBgForm.exists((IObjectPK)new ObjectUuidPK(formId));
        if (!isExist) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.ma.bg.BgFormResource", (String)"bgFormNotValid"));
            return false;
        }
        int state = 1;
        String str = "select FState from T_BG_BgForm where fid = '" + formId + "'";
        ISQLExecutor sqlExe = SQLExecutorFactory.getRemoteInstance((String)str);
        IRowSet rs = null;
        try {
            rs = sqlExe.executeSQL();
            while (rs.next()) {
                state = rs.getInt(1);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (state == 50 || state == 52 || state == 54) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.ma.bg.BgFormResource", (String)"bgFormNotValid"));
            return false;
        }
        return true;
    }
}

