/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bg;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.IOrgUnitCommon;
import com.kingdee.eas.basedata.org.OrgUnitCommonFactory;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.ITableManagerFacade;
import com.kingdee.eas.common.TableManagerFacadeFactory;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.ma.bg.BgBalanceWFEnum;
import com.kingdee.eas.ma.bg.BgCtrlParam;
import com.kingdee.eas.ma.bg.BgDimensionEnum;
import com.kingdee.eas.ma.bg.BgElementEnum;
import com.kingdee.eas.ma.bg.BgElementInfo;
import com.kingdee.eas.ma.bg.BgItemInfo;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import com.kingdee.util.enums.IntEnum;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.log4j.Logger;

public class BgHelper {
    public static boolean ISDeBug = true;
    public static final boolean isCompress = false;
    private static Logger logger = Logger.getLogger(BgHelper.class);
    public static final int DEC_LENGTH = 200;
    public static final int[] Season = new int[]{1, 1, 1, 2, 2, 2, 3, 3, 3, 4, 4, 4};
    public static int tempTableCount = 0;

    public static Object getFilterValue(FilterItemCollection filters, String filterName) {
        for (int i = 0; i < filters.size(); ++i) {
            if (!filters.get(i).getPropertyName().equals(filterName)) continue;
            return filters.get(i).getCompareValue();
        }
        return null;
    }

    public static Vector getFilterValues(FilterItemCollection filters, String filterName) {
        Vector<Object> vec = new Vector<Object>();
        for (int i = 0; i < filters.size(); ++i) {
            if (!filters.get(i).getPropertyName().equals(filterName)) continue;
            vec.add(filters.get(i).getCompareValue());
        }
        return vec;
    }

    public static SorterItemInfo getSorterItem(SorterItemCollection sorters, String sorterName) {
        for (int i = 0; i < sorters.size(); ++i) {
            if (!sorters.get(i).getPropertyName().equals(sorterName)) continue;
            return sorters.get(i);
        }
        return null;
    }

    public static FilterItemInfo getFilterItem(FilterItemCollection filters, String filterName) {
        for (int i = 0; i < filters.size(); ++i) {
            if (!filters.get(i).getPropertyName().equals(filterName)) continue;
            return filters.get(i);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void dropTable(Context ctx, String table) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)table)) {
            return;
        }
        String sql = "Drop Table " + table;
        Connection conn = null;
        PreparedStatement stat = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            stat = conn.prepareStatement(sql);
            stat.execute();
        }
        catch (SQLException sQLException) {
            SQLUtils.cleanup(stat, (Connection)conn);
            catch (Throwable throwable) {
                SQLUtils.cleanup(stat, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stat, (Connection)conn);
    }

    public static String getBgItemsKey(Object[] bgItemArray) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < bgItemArray.length; ++i) {
            BgItemInfo bgItemInfo = (BgItemInfo)bgItemArray[i];
            if (bgItemInfo == null) continue;
            if (i != 0) {
                sb.append("_");
            }
            sb.append(bgItemInfo.getItemNumber());
        }
        return sb.toString();
    }

    public static String getBgElementKey(BgElementInfo bgElementInfo, CurrencyInfo cyInfo) {
        String s = bgElementInfo.getNumber();
        if (cyInfo != null) {
            s = s + "_" + cyInfo.getNumber();
        }
        return s;
    }

    public static SelectorItemCollection getShortSelectors() {
        SelectorItemCollection shortSelector = new SelectorItemCollection();
        shortSelector.add(new SelectorItemInfo("id"));
        shortSelector.add(new SelectorItemInfo("name"));
        shortSelector.add(new SelectorItemInfo("number"));
        shortSelector.add(new SelectorItemInfo("controllable"));
        shortSelector.add(new SelectorItemInfo("bgOrgType.id"));
        shortSelector.add(new SelectorItemInfo("bgOrgType.orgType"));
        shortSelector.add(new SelectorItemInfo("isSysDefined"));
        shortSelector.add(new SelectorItemInfo("isRptBgForm"));
        shortSelector.add(new SelectorItemInfo("validBgDimensions.*"));
        return shortSelector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void objectWrite(Object obj, String key) {
        ObjectOutputStream p = null;
        FileOutputStream objfile = null;
        try {
            logger.debug((Object)("write object " + key));
            objfile = new FileOutputStream(key);
            p = new ObjectOutputStream(objfile);
            p.writeObject(obj);
            p.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (p != null) {
                    p.close();
                }
                if (objfile != null) {
                    objfile.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object objectRead(String key) {
        Object obj = null;
        ObjectInputStream p = null;
        FileInputStream objfile = null;
        try {
            logger.info((Object)("read object " + key));
            objfile = new FileInputStream(key);
            p = new ObjectInputStream(objfile);
            obj = p.readObject();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (p != null) {
                    p.close();
                }
                if (objfile != null) {
                    objfile.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return obj;
    }

    public static boolean equals(String o1, String o2) {
        if (o1 != null) {
            if (o2 == null) {
                return false;
            }
            return o1.trim().equals(o2.trim());
        }
        return o2 == null;
    }

    public static boolean equals(Object o1, Object o2) {
        if (o1 == null) {
            return o2 == null;
        }
        if (o2 == null) {
            return false;
        }
        if (o1 instanceof BigDecimal && o2 instanceof BigDecimal) {
            BigDecimal new_o1 = (BigDecimal)o1;
            BigDecimal new_o2 = (BigDecimal)o2;
            if (new_o1.scale() < new_o2.scale()) {
                new_o1 = new_o1.setScale(new_o2.scale());
            } else if (new_o2.scale() < new_o1.scale()) {
                new_o2 = new_o2.setScale(new_o1.scale());
            }
            return new_o1.equals(new_o2);
        }
        if (IObjectValue.class.isInstance(o1) && IObjectValue.class.isInstance(o2)) {
            IObjectValue newo1 = (IObjectValue)o1;
            IObjectValue newo2 = (IObjectValue)o2;
            String pkfield = newo1.getPKField();
            return BgHelper.equals(newo1.getBOSUuid(pkfield), newo2.getBOSUuid(pkfield));
        }
        if (o1.hashCode() != o2.hashCode()) {
            return false;
        }
        return o1.equals(o2);
    }

    public static boolean bgAuditIsOK(BgCtrlParam[] param) {
        if (BgHelper.isEmpty(param)) {
            return true;
        }
        int size = param.length;
        for (int i = 0; i < size; ++i) {
            if (param[i].isOK()) continue;
            return false;
        }
        return true;
    }

    public static boolean isEmpty(Object[] param) {
        return param == null || param.length == 0 || param[0] == null;
    }

    public static String getBgAuditMsg(BgCtrlParam[] params) {
        StringBuffer sb = new StringBuffer(128);
        String strBgBalance = BgBalanceWFEnum.BgBalance.getAlias();
        String strBizValue = BgBalanceWFEnum.BizValue.getAlias();
        for (int i = 0; i < params.length; ++i) {
            if (params[i].isOK()) continue;
            BgCtrlParam param = params[i];
            for (IntEnum key : param.getDimensions().keySet()) {
                String number = param.getDimension((BgDimensionEnum)key).getString("number");
                if (StringUtils.isEmpty((String)number)) continue;
                sb.append("\n");
                sb.append(key);
                sb.append(":");
                sb.append(param.getDimension((BgDimensionEnum)key).getString("number"));
            }
            for (IntEnum key : param.getDatas().keySet()) {
                sb.append("\n" + key);
                sb.append("_");
                sb.append(strBgBalance);
                sb.append(":");
                BigDecimal bgBalance = param.getData((BgElementEnum)key).getBgBalance();
                if (bgBalance == null) {
                    bgBalance = new BigDecimal("0");
                }
                sb.append(BgHelper.cutZero(bgBalance));
                sb.append("\n" + key);
                sb.append("_");
                sb.append(strBizValue);
                sb.append(":");
                BigDecimal bizValue = param.getData((BgElementEnum)key).getValue();
                if (bizValue == null) {
                    bizValue = new BigDecimal("0");
                }
                sb.append(BgHelper.cutZero(bizValue));
            }
        }
        return sb.toString();
    }

    public static int countNumber(String number) {
        int j;
        if (number == null) {
            return -1;
        }
        if ((number = number.trim()).length() == 0) {
            return 0;
        }
        int i = 0;
        int count = 1;
        while ((j = number.indexOf(".", i)) >= 0) {
            i = j + 1;
            ++count;
        }
        return count;
    }

    public static int getValue(IntEnum enums) {
        if (enums != null) {
            return enums.getValue();
        }
        return 0;
    }

    public static String getString(Object uuid) {
        if (uuid != null) {
            return uuid.toString();
        }
        return null;
    }

    public static String getId(Object info) {
        if (info == null) {
            return null;
        }
        if (AbstractObjectValue.class.isInstance(info)) {
            AbstractObjectValue objInfo = (AbstractObjectValue)info;
            return objInfo.getBOSUuid("id").toString();
        }
        return info.toString();
    }

    public static BOSUuid[] getIds(List list) {
        if (list == null || list.size() == 0) {
            return null;
        }
        BOSUuid[] ids = new BOSUuid[list.size()];
        for (int i = 0; i < ids.length; ++i) {
            ids[i] = (BOSUuid)list.get(i);
        }
        return ids;
    }

    public static java.util.Date getDayBegin() {
        Calendar cal = GregorianCalendar.getInstance();
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        return cal.getTime();
    }

    public static java.util.Date getDayEnd() {
        Calendar cal = GregorianCalendar.getInstance();
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        return cal.getTime();
    }

    public static Date getSQLBegin(java.util.Date da) {
        Calendar cal = GregorianCalendar.getInstance();
        cal.setTime(da);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        Date ds = new Date(cal.getTimeInMillis());
        return ds;
    }

    public static Date getSQLEnd(java.util.Date da) {
        Calendar cal = GregorianCalendar.getInstance();
        cal.setTime(da);
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        return new Date(cal.getTimeInMillis());
    }

    public static boolean isStartGroupUsing() throws EASBizException, BOSException {
        boolean isStart = false;
        HashMap<String, Object> hmApp = new HashMap<String, Object>();
        hmApp.put("BG005", null);
        IParamControl pc = ParamControlFactory.getRemoteInstance();
        HashMap hmAllParam = pc.getParamHashMap(hmApp);
        String strValue = null;
        if (hmAllParam.get("BG005") != null) {
            strValue = (String)hmAllParam.get("BG005");
        }
        if (strValue != null && strValue.equals("true")) {
            isStart = true;
        }
        return isStart;
    }

    public static CompanyOrgUnitInfo conversionCompanyOrgByOrgUnit(OrgUnitInfo orgUnitInfo) throws EASBizException, BOSException {
        CompanyOrgUnitInfo companyOrgUnitInfo = null;
        ICompanyOrgUnit iCompanyOrgUnit = CompanyOrgUnitFactory.getRemoteInstance();
        companyOrgUnitInfo = iCompanyOrgUnit.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgUnitInfo.getId()));
        return companyOrgUnitInfo;
    }

    public static void assertNotNull(BigDecimal decimal) {
        if (decimal == null) {
            decimal = new BigDecimal("0");
        }
    }

    public static void assertNotNull(CoreBaseInfo object, String field) {
    }

    public static int getSeason(int i) {
        return Season[i];
    }

    public static java.util.Date getFirstYearDate(java.util.Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(2, 0);
        return cal.getTime();
    }

    public static java.util.Date getFirstSeasonDate(java.util.Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int sean = BgHelper.getSeason(cal.get(2));
        cal.set(2, sean * 3 - 2);
        return cal.getTime();
    }

    public static String getTimeString() {
        StringBuffer sb = new StringBuffer();
        sb.append(Calendar.getInstance().get(1));
        sb.append(Calendar.getInstance().get(2));
        sb.append(Calendar.getInstance().get(5));
        sb.append(Calendar.getInstance().get(11));
        sb.append(Calendar.getInstance().get(12));
        sb.append(Calendar.getInstance().get(13));
        return sb.toString();
    }

    public static synchronized String getTableName(Context ctx) throws BOSException, EASBizException {
        ITableManagerFacade mang = TableManagerFacadeFactory.getLocalInstance((Context)ctx);
        return mang.getTableName("bg");
    }

    public static void buildVO(IObjectValue info, String infoField, ResultSet rs, String dbField, Class linkClass, Map cache) throws SQLException {
        String id = rs.getString(dbField);
        IObjectValue linkObject = (IObjectValue)cache.get(id);
        if (linkObject == null || !linkObject.getClass().equals(linkClass)) {
            try {
                linkObject = (IObjectValue)linkClass.newInstance();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            linkObject.setBOSUuid("id", BOSUuid.read((String)id));
            cache.put(id, linkObject);
        }
        info.put(infoField, (Object)linkObject);
    }

    public static PeriodCollection filterAdjustPeriod(PeriodCollection periodCollection) {
        int i;
        int size = periodCollection.size();
        int[] indexArr = new int[size];
        for (i = 0; i < size; ++i) {
            PeriodInfo periodInfo = periodCollection.get(i);
            if (!periodInfo.isIsAdjustPeriod()) continue;
            indexArr[i] = 1;
        }
        for (i = size - 1; i >= 0; --i) {
            int index = indexArr[i];
            if (index != 1) continue;
            periodCollection.removeObject(i);
        }
        return periodCollection;
    }

    public static CompanyOrgUnitInfo getCompanyOrgByOrgUnit(OrgUnitInfo orgUnitInfo) throws EASBizException, BOSException {
        if (orgUnitInfo == null) {
            return null;
        }
        IOrgUnitCommon iOrgCommon = OrgUnitCommonFactory.getRemoteInstance();
        CompanyOrgUnitInfo companyInfo = iOrgCommon.getCompany(orgUnitInfo.getId());
        return companyInfo;
    }

    public static boolean isGroupModel() throws EASBizException, BOSException {
        boolean groupModel = false;
        HashMap<String, Object> hmApp = new HashMap<String, Object>();
        hmApp.put("G000", null);
        IParamControl pc = ParamControlFactory.getRemoteInstance();
        HashMap hmAllParam = pc.getParamHashMap(hmApp);
        int is_Group_Right = 0;
        if (hmAllParam.get("G000") != null) {
            is_Group_Right = Integer.parseInt(hmAllParam.get("G000").toString());
        }
        if (is_Group_Right == 0) {
            groupModel = true;
        } else if (is_Group_Right == 1) {
            groupModel = false;
        }
        return groupModel;
    }

    public static void showSerialVer(Class cl) {
        ObjectStreamClass osc = ObjectStreamClass.lookup(cl);
        System.out.println("className: " + cl.getName());
        System.out.println("private static final long serialVersionUID = " + osc.getSerialVersionUID() + "L");
    }

    public static void showClassUrl(Class cl) {
        String className = cl.getName();
        System.out.println(className);
        String name = className.replace('.', '/') + ".class";
        ClassLoader classLoader = cl.getClassLoader();
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        if (classLoader != null) {
            System.out.println(classLoader.getResource(name));
        }
    }

    public static BigDecimal cutZero(BigDecimal bigDecimal) {
        if (bigDecimal != null) {
            String str = (bigDecimal = bigDecimal.setScale(15, 4)).toString();
            int index = str.lastIndexOf("0");
            if (index > 0) {
                char ch = str.charAt(index - 1);
                while (ch == '0' && index > 0) {
                    ch = str.charAt(--index - 1);
                }
                str = str.substring(0, index);
            } else {
                str = "0";
            }
            bigDecimal = new BigDecimal(str);
        } else {
            bigDecimal = new BigDecimal("0");
        }
        return bigDecimal;
    }

    public static BigDecimal cutZero(BigDecimal bigDecimal, int precision) {
        bigDecimal = bigDecimal != null ? bigDecimal.setScale(precision, 4) : new BigDecimal("0");
        return bigDecimal;
    }
}

